/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.dialogue.npcDialogue.unique;

import com.lilithsthrone.game.PropertyValue;
import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.PlayerCharacter;
import com.lilithsthrone.game.character.npc.NPC;
import com.lilithsthrone.game.character.npc.dominion.Lumi;
import com.lilithsthrone.game.dialogue.DialogueFlagValue;
import com.lilithsthrone.game.dialogue.DialogueNode;
import com.lilithsthrone.game.dialogue.responses.Response;
import com.lilithsthrone.game.dialogue.responses.ResponseCombat;
import com.lilithsthrone.game.dialogue.responses.ResponseEffectsOnly;
import com.lilithsthrone.game.dialogue.responses.ResponseSex;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.game.sex.SexPace;
import com.lilithsthrone.game.sex.managers.universal.SMLyingDown;
import com.lilithsthrone.game.sex.positions.slots.SexSlot;
import com.lilithsthrone.game.sex.positions.slots.SexSlotLyingDown;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.utils.Util;
import com.lilithsthrone.world.WorldType;
import com.lilithsthrone.world.places.PlaceType;

public class LumiDialogue {
    public static final DialogueNode LUMI_APPEARS = new DialogueNode("\u5c0f\u5df7", "", true){

        @Override
        public String getAuthor() {
            return "Nnxx";
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("characters/dominion/lumi", "LUMI_APPEARS");
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1) {
                if (Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.lumiMet)) {
                    return new Response("\u505c\u7559", "\u5f85\u5728\u8fd9\u770b\u770b\u8c01\u63a5\u8fd1\u3002", LUMI_APPEARS_REPEAT_ENCOUNTER);
                }
                return new Response("\u505c\u7559", "\u5f85\u5728\u8fd9\u770b\u770b\u8c01\u63a5\u8fd1\u3002", LUMI_APPEARS_FIRST_ENCOUNTER);
            }
            if (index == 2) {
                return new ResponseEffectsOnly("\u8eb2\u907f", "\u8fc5\u901f\u8eb2\u8fdb\u4e00\u6761\u72ed\u7a84\u7684\u901a\u9053\u4e2d\u3002"){

                    @Override
                    public void effects() {
                        Main.game.getTextStartStringBuilder().append(UtilText.parseFromXMLFile("characters/dominion/lumi", "LUMI_APPEARS_EVADE"));
                        Main.game.setContent(new Response("", "", Main.game.getDefaultDialogue(false)));
                    }
                };
            }
            return null;
        }
    };
    private static long moneyStolen = 0L;
    public static final DialogueNode LUMI_APPEARS_FIRST_ENCOUNTER = new DialogueNode("\u5c0f\u5df7", "", true, true){

        @Override
        public String getAuthor() {
            return "Nnxx";
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("characters/dominion/lumi", "LUMI_APPEARS_FIRST_ENCOUNTER");
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1) {
                return new Response("\u7b49\u5f85", "\u7ee7\u7eed\u8eb2\u5728\u90a3\u5806\u5783\u573e\u540e\u9762\u3002", LUMI_APPEARS_FIRST_ENCOUNTER_WAITING){

                    @Override
                    public void effects() {
                        moneyStolen = Main.game.getPlayer().getMoney() >= 700L ? 700L : Main.game.getPlayer().getMoney();
                        Main.game.getPlayer().incrementMoney(-moneyStolen);
                        if (moneyStolen == 700L) {
                            Main.game.getTextEndStringBuilder().append(UtilText.parseFromXMLFile("characters/dominion/lumi", "MAX_MONEY_STOLEN"));
                        } else {
                            Main.game.getTextEndStringBuilder().append(UtilText.parseFromXMLFile("characters/dominion/lumi", "ALL_MONEY_STOLEN"));
                        }
                    }
                };
            }
            return null;
        }
    };
    public static final DialogueNode LUMI_APPEARS_FIRST_ENCOUNTER_WAITING = new DialogueNode("\u5c0f\u5df7", "", true, true){

        @Override
        public String getAuthor() {
            return "Nnxx";
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("characters/dominion/lumi", "LUMI_APPEARS_FIRST_ENCOUNTER_WAITING");
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1) {
                return new Response("\u8ffd\u4e0a\u5bf9\u65b9", "\u4f60\u4e0d\u80fd\u8ba9\u8fd9\u4e2a\u5c0f\u5077\u9003\u8dd1\uff01", LUMI_CHASE);
            }
            if (index == 2) {
                return new ResponseEffectsOnly("\u8ba9\u5bf9\u65b9\u79bb\u5f00", "\u4f60\u6ca1\u6709\u95f2\u5de5\u592b\u8ffd\u4ec0\u4e48\u6bdb\u5934\u5c0f\u8d3c\uff0c\u8ba9\u4ed6\u8d70\u5427\u3002"){

                    @Override
                    public void effects() {
                        Main.game.getTextStartStringBuilder().append(UtilText.parseFromXMLFile("characters/dominion/lumi", "LUMI_LET_THEM_ESCAPE"));
                        Main.game.setContent(new Response("", "", Main.game.getDefaultDialogue(false)));
                    }
                };
            }
            return null;
        }
    };
    public static final DialogueNode LUMI_CHASE = new DialogueNode("\u5c0f\u5df7", "", true, true){

        @Override
        public String getAuthor() {
            return "Nnxx";
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("characters/dominion/lumi", "LUMI_CHASE");
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1) {
                return new Response("\u4e58\u80dc\u8ffd\u51fb", "\u4f60\u4e0d\u80fd\u8ba9\u8fd9\u4e2a\u5c0f\u5077\u9003\u8dd1\uff01", LUMI_CHASE_CONTINUE){

                    @Override
                    public void effects() {
                        Main.game.getNpc(Lumi.class).setLocation(Main.game.getPlayer().getWorldLocation(), Main.game.getPlayer().getLocation(), true);
                    }
                };
            }
            return null;
        }
    };
    public static final DialogueNode LUMI_CHASE_CONTINUE = new DialogueNode("\u5c0f\u5df7", "", true, true){

        @Override
        public String getAuthor() {
            return "Nnxx";
        }

        @Override
        public int getSecondsPassed() {
            return 600;
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("characters/dominion/lumi", "LUMI_CHASE_CONTINUE");
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1) {
                return new Response("\u5bf9\u8bdd", "\u51b3\u5b9a\u8bd5\u7740\u8ddf\u5979\u8c08\u8c08\u3002\u6bd5\u7adf\uff0c\u66b4\u529b\u6c38\u8fdc\u4e0d\u662f\u89e3\u51b3\u4e4b\u9053\u3002", LUMI_CAUGHT_TALK);
            }
            if (index == 2) {
                return new ResponseCombat("\u6218\u6597", "\u4f60\u4e0d\u80fd\u8ba9\u8fd9\u4e2a\u5c0f\u5077\u9003\u8dd1\uff01", Main.game.getNpc(Lumi.class), Util.newHashMapOfValues(new Util.Value<PlayerCharacter, String>(Main.game.getPlayer(), UtilText.parseFromXMLFile("characters/dominion/lumi", "LUMI_COMBAT_PC_OPENING")), new Util.Value<NPC, String>(Main.game.getNpc(Lumi.class), UtilText.parseFromXMLFile("characters/dominion/lumi", "LUMI_COMBAT_LUMI_OPENING")))){

                    @Override
                    public void effects() {
                        Main.game.getDialogueFlags().setFlag(DialogueFlagValue.lumiDisabled, true);
                    }
                };
            }
            return null;
        }
    };
    public static final DialogueNode COMBAT_PLAYER_LOSS = new DialogueNode("\u5c0f\u5df7", "", true){

        @Override
        public String getAuthor() {
            return "Nnxx";
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("characters/dominion/lumi", "COMBAT_PLAYER_LOSS");
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1) {
                return new Response("\u7ee7\u7eed", "\u7ee7\u7eed\u4f60\u7684\u65c5\u7a0b\u2026\u2026", null){

                    @Override
                    public DialogueNode getNextDialogue() {
                        return Main.game.getDefaultDialogue(false);
                    }

                    @Override
                    public void effects() {
                        Main.game.getNpc(Lumi.class).setLocation(WorldType.EMPTY, PlaceType.GENERIC_HOLDING_CELL);
                    }
                };
            }
            return null;
        }
    };
    public static final DialogueNode COMBAT_PLAYER_WIN = new DialogueNode("\u5c0f\u5df7", "", true){

        @Override
        public String getAuthor() {
            return "Nnxx";
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("characters/dominion/lumi", "COMBAT_PLAYER_WIN");
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1) {
                return new Response("\u53d6\u56de\u94b1\u8d22", "\u62ff\u8d70\u4f60\u7684\u94b1\uff0c\u4e00\u8a00\u4e0d\u53d1\u5730\u79bb\u5f00\u3002", COMBAT_PLAYER_WIN_RECOVER_MONEY){

                    @Override
                    public void effects() {
                        Main.game.getPlayer().incrementMoney(moneyStolen);
                    }
                };
            }
            if (index == 2 && Main.getProperties().hasValue(PropertyValue.nonConContent)) {
                return new ResponseSex("\u8d81\u6b64\u673a\u4f1a", "\u65e2\u7136\u5979\u5df2\u7ecf\u88ab\u5236\u670d\uff0c\u90a3\u662f\u65f6\u5019\u8ddf\u8fd9\u4e2a\u65e0\u52a9\u7684\u72fc\u5973\u73a9\u4e00\u73a9\u4e86\uff01", false, false, new SMLyingDown(Util.newHashMapOfValues(new Util.Value<PlayerCharacter, SexSlot>(Main.game.getPlayer(), SexSlotLyingDown.MISSIONARY)), Util.newHashMapOfValues(new Util.Value<NPC, SexSlot>(Main.game.getNpc(Lumi.class), SexSlotLyingDown.LYING_DOWN))){

                    @Override
                    public SexPace getStartingSexPaceModifier(GameCharacter character) {
                        if (character.isPlayer()) {
                            return SexPace.DOM_ROUGH;
                        }
                        return SexPace.SUB_RESISTING;
                    }
                }, null, null, AFTER_SEX, UtilText.parseFromXMLFile("characters/dominion/lumi", "COMBAT_PLAYER_WIN_TAKE_ADVANTAGE")){

                    @Override
                    public void effects() {
                        Main.game.getPlayer().incrementKarma(-1000);
                    }
                };
            }
            return null;
        }
    };
    public static final DialogueNode AFTER_SEX = new DialogueNode("\u5c0f\u5df7", "", true, true){

        @Override
        public String getAuthor() {
            return "Nnxx";
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("characters/dominion/lumi", "AFTER_SEX");
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1) {
                return new Response("\u7ee7\u7eed", "\u7ee7\u7eed\u4f60\u7684\u65c5\u7a0b\u2026\u2026", null){

                    @Override
                    public DialogueNode getNextDialogue() {
                        return Main.game.getDefaultDialogue(false);
                    }

                    @Override
                    public void effects() {
                        Main.game.getNpc(Lumi.class).setLocation(WorldType.EMPTY, PlaceType.GENERIC_HOLDING_CELL);
                    }
                };
            }
            return null;
        }
    };
    public static final DialogueNode COMBAT_PLAYER_WIN_RECOVER_MONEY = new DialogueNode("\u5c0f\u5df7", "", true, true){

        @Override
        public String getAuthor() {
            return "Nnxx";
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("characters/dominion/lumi", "COMBAT_PLAYER_WIN_RECOVER_MONEY");
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1) {
                return new Response("\u7ee7\u7eed", "\u7ee7\u7eed\u4f60\u7684\u65c5\u7a0b\u2026\u2026", null){

                    @Override
                    public DialogueNode getNextDialogue() {
                        return Main.game.getDefaultDialogue(false);
                    }

                    @Override
                    public void effects() {
                        Main.game.getNpc(Lumi.class).setLocation(WorldType.EMPTY, PlaceType.GENERIC_HOLDING_CELL);
                    }
                };
            }
            return null;
        }
    };
    public static final DialogueNode COMBAT_PLAYER_WIN_TAKE_ADVANTAGE = new DialogueNode("\u5c0f\u5df7", "", true, true){

        @Override
        public String getAuthor() {
            return "Nnxx";
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("characters/dominion/lumi", "COMBAT_PLAYER_WIN_TAKE_ADVANTAGE");
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1) {
                return new Response("\u7ee7\u7eed", "\u7ee7\u7eed\u4f60\u7684\u65c5\u7a0b\u2026\u2026", null){

                    @Override
                    public DialogueNode getNextDialogue() {
                        return Main.game.getDefaultDialogue(false);
                    }

                    @Override
                    public void effects() {
                        Main.game.getNpc(Lumi.class).setLocation(WorldType.EMPTY, PlaceType.GENERIC_HOLDING_CELL);
                    }
                };
            }
            return null;
        }
    };
    public static final DialogueNode LUMI_CAUGHT_TALK = new DialogueNode("\u5c0f\u5df7", "", true, true){

        @Override
        public String getAuthor() {
            return "Nnxx";
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("characters/dominion/lumi", "LUMI_CAUGHT_TALK");
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1) {
                return new Response("\u7ed9\u4e88", "\u8ba9\u5362\u7c73\u62ff\u7740\u4ece\u4f60\u8eab\u4e0a\u5077\u8d70\u7684\u94b1\uff0c\u544a\u8bc9\u5979\u4e00\u5b9a\u8981\u597d\u597d\u7528\u3002", LUMI_CAUGHT_TALK_GIVE_MONEY){

                    @Override
                    public void effects() {
                        Main.game.getNpc(Lumi.class).setPlayerKnowsName(true);
                        Main.game.getTextEndStringBuilder().append(Main.game.getNpc(Lumi.class).incrementAffection(Main.game.getPlayer(), 10.0f));
                    }
                };
            }
            if (index == 2) {
                return new Response("\u8981\u6c42", "\u8981\u6c42\u5362\u7c73\u628a\u4ece\u4f60\u90a3\u5077\u6765\u7684\u94b1\u8fd8\u56de\u6765\u3002", LUMI_CAUGHT_TALK_ASK_FOR_MONEY_BACK){

                    @Override
                    public void effects() {
                        Main.game.getNpc(Lumi.class).setPlayerKnowsName(true);
                        Main.game.getPlayer().incrementMoney(moneyStolen);
                        Main.game.getDialogueFlags().setFlag(DialogueFlagValue.lumiPromisedDinner, true);
                        Main.game.getTextEndStringBuilder().append(Main.game.getNpc(Lumi.class).incrementAffection(Main.game.getPlayer(), 5.0f));
                    }
                };
            }
            if (index == 3) {
                return new Response("\u5a01\u80c1", "\u6559\u8bad\u4e00\u4e0b\u8fd9\u4e2a\u5c0f\u8d3c\uff01\u4f60\u6709\u9884\u611f\u5982\u679c\u8fd9\u4e48\u505a\u4e86\uff0c\u5c31\u6c38\u8fdc\u4e0d\u4f1a\u518d\u8ddf\u5979\u89c1\u9762\u4e86\u3002", LUMI_CAUGHT_TALK_THREATEN){

                    @Override
                    public void effects() {
                        Main.game.getDialogueFlags().setFlag(DialogueFlagValue.lumiDisabled, true);
                    }
                };
            }
            return null;
        }
    };
    public static final DialogueNode LUMI_CAUGHT_TALK_GIVE_MONEY = new DialogueNode("\u5c0f\u5df7", "", true, true){

        @Override
        public String getAuthor() {
            return "Nnxx";
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("characters/dominion/lumi", "LUMI_CAUGHT_TALK_GIVE_MONEY");
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1) {
                return new Response("\u7ee7\u7eed", "\u7ee7\u7eed\u4f60\u7684\u65c5\u7a0b\u2026\u2026", null){

                    @Override
                    public DialogueNode getNextDialogue() {
                        return Main.game.getDefaultDialogue(false);
                    }
                };
            }
            return null;
        }
    };
    public static final DialogueNode LUMI_CAUGHT_TALK_ASK_FOR_MONEY_BACK = new DialogueNode("\u5c0f\u5df7", "", true, true){

        @Override
        public String getAuthor() {
            return "Nnxx";
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("characters/dominion/lumi", "LUMI_CAUGHT_TALK_ASK_FOR_MONEY_BACK");
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1) {
                return new Response("\u7ee7\u7eed", "\u7ee7\u7eed\u4f60\u7684\u65c5\u7a0b\u2026\u2026", null){

                    @Override
                    public DialogueNode getNextDialogue() {
                        return Main.game.getDefaultDialogue(false);
                    }
                };
            }
            return null;
        }
    };
    public static final DialogueNode LUMI_CAUGHT_TALK_THREATEN = new DialogueNode("\u5c0f\u5df7", "", true, true){

        @Override
        public String getAuthor() {
            return "Nnxx";
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("characters/dominion/lumi", "LUMI_CAUGHT_TALK_THREATEN");
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1) {
                return new Response("\u7ee7\u7eed", "\u7ee7\u7eed\u4f60\u7684\u65c5\u7a0b\u2026\u2026", null){

                    @Override
                    public DialogueNode getNextDialogue() {
                        return Main.game.getDefaultDialogue(false);
                    }

                    @Override
                    public void effects() {
                        Main.game.getNpc(Lumi.class).setLocation(WorldType.EMPTY, PlaceType.GENERIC_HOLDING_CELL);
                    }
                };
            }
            return null;
        }
    };
    public static final DialogueNode LUMI_APPEARS_REPEAT_ENCOUNTER = new DialogueNode("\u5c0f\u5df7", "", true, true){

        @Override
        public String getAuthor() {
            return "Nnxx";
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("characters/dominion/lumi", "LUMI_APPEARS_REPEAT_ENCOUNTER");
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            return null;
        }
    };
}

