/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.dialogue.places.dominion;

import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.PlayerCharacter;
import com.lilithsthrone.game.character.body.CoverableArea;
import com.lilithsthrone.game.character.gender.Gender;
import com.lilithsthrone.game.character.npc.NPC;
import com.lilithsthrone.game.character.npc.NPCGenerationFlag;
import com.lilithsthrone.game.character.npc.dominion.EnforcerWarehouseGuard;
import com.lilithsthrone.game.character.npc.dominion.Sean;
import com.lilithsthrone.game.character.npc.submission.Claire;
import com.lilithsthrone.game.character.persona.Occupation;
import com.lilithsthrone.game.character.quests.Quest;
import com.lilithsthrone.game.character.quests.QuestLine;
import com.lilithsthrone.game.character.race.AbstractSubspecies;
import com.lilithsthrone.game.character.race.FurryPreference;
import com.lilithsthrone.game.character.race.RaceStage;
import com.lilithsthrone.game.character.race.Subspecies;
import com.lilithsthrone.game.combat.DamageType;
import com.lilithsthrone.game.combat.spells.Spell;
import com.lilithsthrone.game.dialogue.DialogueFlagValue;
import com.lilithsthrone.game.dialogue.DialogueNode;
import com.lilithsthrone.game.dialogue.places.dominion.slaverAlley.SlaverAlleyDialogue;
import com.lilithsthrone.game.dialogue.responses.Response;
import com.lilithsthrone.game.dialogue.responses.ResponseCombat;
import com.lilithsthrone.game.dialogue.responses.ResponseSex;
import com.lilithsthrone.game.dialogue.utils.ParserTag;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.game.inventory.ItemTag;
import com.lilithsthrone.game.inventory.Rarity;
import com.lilithsthrone.game.inventory.clothing.AbstractClothing;
import com.lilithsthrone.game.inventory.clothing.AbstractClothingType;
import com.lilithsthrone.game.inventory.clothing.ClothingType;
import com.lilithsthrone.game.inventory.enchanting.ItemEffect;
import com.lilithsthrone.game.inventory.enchanting.ItemEffectType;
import com.lilithsthrone.game.inventory.enchanting.TFModifier;
import com.lilithsthrone.game.inventory.enchanting.TFPotency;
import com.lilithsthrone.game.inventory.item.AbstractItem;
import com.lilithsthrone.game.inventory.item.AbstractItemType;
import com.lilithsthrone.game.inventory.item.ItemType;
import com.lilithsthrone.game.inventory.weapon.AbstractWeapon;
import com.lilithsthrone.game.inventory.weapon.AbstractWeaponType;
import com.lilithsthrone.game.inventory.weapon.WeaponType;
import com.lilithsthrone.game.sex.ImmobilisationType;
import com.lilithsthrone.game.sex.SexControl;
import com.lilithsthrone.game.sex.managers.SexManagerDefault;
import com.lilithsthrone.game.sex.managers.dominion.SMClaireWarehouse;
import com.lilithsthrone.game.sex.positions.SexPosition;
import com.lilithsthrone.game.sex.positions.slots.SexSlot;
import com.lilithsthrone.game.sex.positions.slots.SexSlotAgainstWall;
import com.lilithsthrone.game.sex.positions.slots.SexSlotStocks;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.utils.Util;
import com.lilithsthrone.utils.Vector2i;
import com.lilithsthrone.utils.colours.PresetColour;
import com.lilithsthrone.world.Cell;
import com.lilithsthrone.world.WorldType;
import com.lilithsthrone.world.places.PlaceType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class EnforcerWarehouse {
    private static EnforcerWarehouseGuard arrestingGuard = null;
    private static List<GameCharacter> randomSexPartners = null;
    public static final DialogueNode ENCLOSURE_TELEPORT_PADS = new DialogueNode("\u4f20\u9001\u677f", "", false){

        @Override
        public boolean isTravelDisabled() {
            return !Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.clairePadsInvestigated);
        }

        @Override
        public int getSecondsPassed() {
            return 60;
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("places/dominion/enforcerWarehouse/generic", "ENCLOSURE_TELEPORT_PADS");
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1 && !Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.clairePadsInvestigated)) {
                return new Response("\u8c03\u67e5\u4f20\u9001\u677f", "\u4ed4\u7ec6\u770b\u4e00\u4e0b\u4f20\u9001\u677f\uff0c\u627e\u627e\u6709\u6ca1\u6709\u514b\u83b1\u5c14\u8981\u627e\u7684\u201c\u7cbe\u534e\u63a5\u5165\u53e3\u201d\u3002", ENCLOSURE_TELEPORT_PADS_INVESTIGATE){

                    @Override
                    public void effects() {
                        Main.game.getDialogueFlags().setFlag(DialogueFlagValue.clairePadsInvestigated, true);
                    }
                };
            }
            return null;
        }
    };
    public static final DialogueNode ENCLOSURE_TELEPORT_PADS_INVESTIGATE = new DialogueNode("", "", true){

        @Override
        public int getSecondsPassed() {
            return 300;
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("places/dominion/enforcerWarehouse/generic", "ENCLOSURE_TELEPORT_PADS_INVESTIGATE");
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1) {
                return new Response("\u4e25\u8083\u8ba4\u771f", "\u8fd9\u4e48\u65e9\u5c31\u6253\u9000\u5802\u9f13\u53ef\u4e0d\u662f\u514b\u83b1\u5c14\u7684\u98ce\u683c\u3002\u544a\u8bc9\u5979\u5f97\u632f\u4f5c\u8d77\u6765\u3002<br/>[style.italicsGood(\u4f60\u89c9\u5f97\u76f4\u622a\u4e86\u5f53\u4e00\u4e9b\u5bf9\u514b\u83b1\u5c14\u6700\u6709\u5e2e\u52a9\u3002)]", ENCLOSURE_TELEPORT_PADS_INVESTIGATE_RESPOND_TO_CLAIRE){

                    @Override
                    public void effects() {
                        Main.game.getTextStartStringBuilder().append(UtilText.parseFromXMLFile("places/dominion/enforcerWarehouse/generic", "ENCLOSURE_TELEPORT_PADS_PULL_TOGETHER"));
                        Main.game.getTextStartStringBuilder().append(Main.game.getNpc(Claire.class).incrementAffection(Main.game.getPlayer(), 15.0f));
                    }
                };
            }
            if (index == 2) {
                return new Response("\u5b89\u6170", "\u544a\u8bc9\u514b\u83b1\u5c14\u5148\u4e0d\u8981\u7edd\u671b\uff0c\u8239\u5230\u6865\u5934\u81ea\u7136\u76f4\u3002<br/>[style.italicsMinorGood(\u514b\u83b1\u5c14\u4f1a\u559c\u6b22\u8fd9\u79cd\u65b9\u5f0f\u7684\u3002)]", ENCLOSURE_TELEPORT_PADS_INVESTIGATE_RESPOND_TO_CLAIRE){

                    @Override
                    public void effects() {
                        Main.game.getTextStartStringBuilder().append(UtilText.parseFromXMLFile("places/dominion/enforcerWarehouse/generic", "ENCLOSURE_TELEPORT_PADS_REASSURE"));
                        Main.game.getTextStartStringBuilder().append(Main.game.getNpc(Claire.class).incrementAffection(Main.game.getPlayer(), 10.0f));
                    }
                };
            }
            if (index == 3) {
                return new Response("\u62e5\u62b1", "\u6216\u8bb8\u514b\u83b1\u5c14\u53ea\u662f\u9700\u8981\u4e00\u4e2a\u62e5\u62b1\uff0c\u8ba9\u5979\u51b7\u9759\u4e0b\u6765\uff1f<br/>[style.italicsMinorGood(\u514b\u83b1\u5c14\u6216\u8bb8\u4f1a\u89c9\u5f97\u4f60\u505a\u5f97\u6709\u4e9b\u8fc7\uff0c\u4f46\u5979\u4f1a\u660e\u767d\u4f60\u7684\u5fc3\u610f\u7684\u3002)]", ENCLOSURE_TELEPORT_PADS_INVESTIGATE_RESPOND_TO_CLAIRE){

                    @Override
                    public void effects() {
                        Main.game.getTextStartStringBuilder().append(UtilText.parseFromXMLFile("places/dominion/enforcerWarehouse/generic", "ENCLOSURE_TELEPORT_PADS_HUG"));
                        Main.game.getTextStartStringBuilder().append(Main.game.getNpc(Claire.class).incrementAffection(Main.game.getPlayer(), 5.0f));
                    }
                };
            }
            return null;
        }
    };
    public static final DialogueNode ENCLOSURE_TELEPORT_PADS_INVESTIGATE_RESPOND_TO_CLAIRE = new DialogueNode("", "", false){

        @Override
        public int getSecondsPassed() {
            return 300;
        }

        @Override
        public String getContent() {
            return "";
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            return ENCLOSURE_TELEPORT_PADS.getResponse(responseTab, index);
        }
    };
    public static final DialogueNode ENCLOSURE = new DialogueNode("\u4ed3\u5e93", "", false){

        @Override
        public int getSecondsPassed() {
            return 60;
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("places/dominion/enforcerWarehouse/generic", "ENCLOSURE");
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            return null;
        }
    };
    public static final DialogueNode ENCLOSURE_SHELVING = new DialogueNode("\u8d27\u67b6", "", false){

        @Override
        public int getSecondsPassed() {
            return 60;
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("places/dominion/enforcerWarehouse/generic", "ENCLOSURE_SHELVING");
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (!Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.claireEnclosureEscaped) && index == 1) {
                return new Response("\u79fb\u52a8\u8d27\u67b6", "\u79fb\u52a8\u8d27\u67b6\uff0c\u5c1d\u8bd5\u6253\u5f00\u4e00\u6761\u8def", ENCLOSURE_SHELVING_MOVE){

                    @Override
                    public void effects() {
                        Main.game.getNpc(Claire.class).setLocation(Main.game.getPlayer(), false);
                        Cell c = Main.game.getActiveWorld().getCell(Main.game.getPlayer().getLocation().getX() + 1, Main.game.getPlayer().getLocation().getY());
                        c.getPlace().setPlaceType(PlaceType.ENFORCER_WAREHOUSE_CORRIDOR);
                        c.getPlace().setName(PlaceType.ENFORCER_WAREHOUSE_CORRIDOR.getName());
                        Main.game.getPlayerCell().getInventory().addItem(Main.game.getItemGen().generateItem(ItemType.getSpellBookType(Spell.TELEPORT)));
                    }
                };
            }
            return null;
        }
    };
    public static final DialogueNode ENCLOSURE_SHELVING_MOVE = new DialogueNode("\u4ed3\u5e93", "", true){

        @Override
        public int getSecondsPassed() {
            return 180;
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("places/dominion/enforcerWarehouse/generic", "ENCLOSURE_SHELVING_MOVE");
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1) {
                return new Response("\u5b66\u4e60\u6cd5\u672f", "\u6d4f\u89c8\u4e00\u904d\u4f20\u9001\u672f\u6cd5\u672f\u4e66\uff0c\u5c3d\u5feb\u5b66\u4f1a\u4f20\u9001\u672f\u3002", ENCLOSURE_SHELVING_DRAG_TELEPORT_LEARNED){

                    @Override
                    public void effects() {
                        Main.game.getTextStartStringBuilder().append(UtilText.parseFromXMLFile("places/dominion/enforcerWarehouse/generic", "ENCLOSURE_SHELVING_DRAG_TELEPORT_LEARNED_START"));
                        Main.game.getTextStartStringBuilder().append("<span style='border:0; padding:0; text-align:center;'><i>" + Main.game.getPlayer().useItem(Main.game.getItemGen().generateItem(ItemType.getSpellBookType(Spell.TELEPORT)), Main.game.getPlayer(), true) + "</i></span>");
                        Main.game.getTextStartStringBuilder().append(UtilText.parseFromXMLFile("places/dominion/enforcerWarehouse/generic", "ENCLOSURE_SHELVING_DRAG_TELEPORT_LEARNED_END"));
                    }
                };
            }
            return null;
        }
    };
    public static final DialogueNode ENCLOSURE_SHELVING_DRAG_TELEPORT_LEARNED = new DialogueNode("", "", true){

        @Override
        public int getSecondsPassed() {
            return 300;
        }

        @Override
        public String getContent() {
            return "";
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1) {
                return new Response("\u7ee7\u7eed\u5411\u524d", "\u8fdb\u5165\u4ed3\u5e93\uff0c\u5bfb\u627e\u51fa\u53e3\u3002", CORRIDOR){

                    @Override
                    public void effects() {
                        Main.game.getDialogueFlags().setFlag(DialogueFlagValue.claireEnclosureEscaped, true);
                        Main.game.getPlayer().setLocation(new Vector2i(Main.game.getPlayer().getLocation().getX() + 1, Main.game.getPlayer().getLocation().getY()));
                    }
                };
            }
            return null;
        }
    };
    public static final DialogueNode CORRIDOR = new DialogueNode("\u8d70\u5eca", "", false){

        @Override
        public int getSecondsPassed() {
            return 60;
        }

        @Override
        public String getContent() {
            ArrayList<String> dangerousDirections = new ArrayList<String>();
            Vector2i location = Main.game.getPlayer().getLocation();
            boolean isMainEntrance = false;
            Cell c = Main.game.getActiveWorld().getCell(location.getX(), location.getY() + 1);
            if (c != null && c.getPlace().getPlaceType().isDangerous()) {
                dangerousDirections.add("\u5317\u8fb9");
                if (c.getPlace().getPlaceType().equals(PlaceType.ENFORCER_WAREHOUSE_ENTRANCE)) {
                    isMainEntrance = true;
                }
            }
            if ((c = Main.game.getActiveWorld().getCell(location.getX(), location.getY() - 1)) != null && c.getPlace().getPlaceType().isDangerous()) {
                dangerousDirections.add("\u5357\u8fb9");
                if (c.getPlace().getPlaceType().equals(PlaceType.ENFORCER_WAREHOUSE_ENTRANCE)) {
                    isMainEntrance = true;
                }
            }
            if ((c = Main.game.getActiveWorld().getCell(location.getX() + 1, location.getY())) != null && c.getPlace().getPlaceType().isDangerous()) {
                dangerousDirections.add("\u4e1c\u8fb9");
                if (c.getPlace().getPlaceType().equals(PlaceType.ENFORCER_WAREHOUSE_ENTRANCE)) {
                    isMainEntrance = true;
                }
            }
            if ((c = Main.game.getActiveWorld().getCell(location.getX() - 1, location.getY())) != null && c.getPlace().getPlaceType().isDangerous()) {
                dangerousDirections.add("\u897f\u8fb9");
                if (c.getPlace().getPlaceType().equals(PlaceType.ENFORCER_WAREHOUSE_ENTRANCE)) {
                    isMainEntrance = true;
                }
            }
            StringBuilder sb = new StringBuilder();
            sb.append(UtilText.parseFromXMLFile("places/dominion/enforcerWarehouse/generic", "CORRIDOR"));
            if (isMainEntrance) {
                sb.append(UtilText.parseFromXMLFile("places/dominion/enforcerWarehouse/generic", "CORRIDOR_ENTRANCE_WARNING"));
            } else if (!dangerousDirections.isEmpty()) {
                sb.append("<p style='test-align:center; color:" + PresetColour.GENERIC_BAD.toWebHexString() + ";'><i>");
                if (dangerousDirections.size() > 1) {
                    sb.append(Util.stringsToStringList(dangerousDirections, false) + "\u8bbe\u6709\u5c97\u54e8\uff01\u8fdb\u5165\u8fd9\u4e9b\u533a\u57df\u5fc5\u5b9a\u4f1a\u5f15\u53d1\u6218\u6597\uff01");
                } else {
                    sb.append(Util.stringsToStringList(dangerousDirections, false) + "\u8bbe\u6709\u5c97\u54e8\uff01\u8fdb\u5165\u8fd9\u4e2a\u533a\u57df\u5fc5\u5b9a\u4f1a\u5f15\u53d1\u6218\u6597\uff01");
                }
                sb.append("</i></p>");
            }
            return sb.toString();
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            return null;
        }
    };
    public static final DialogueNode CLAIRE_WARNING = new DialogueNode("\u8d70\u5eca", "", true){

        @Override
        public boolean isTravelDisabled() {
            return !Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.claireWarning);
        }

        @Override
        public int getSecondsPassed() {
            return 60;
        }

        @Override
        public String getContent() {
            if (!Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.claireWarning)) {
                NPC guard = Main.game.getCharactersPresent(Main.game.getWorlds().get(WorldType.ENFORCER_WAREHOUSE).getClosestCell(Main.game.getPlayer().getLocation(), PlaceType.ENFORCER_WAREHOUSE_ENFORCER_GUARD_POST)).get(0);
                return UtilText.parseFromXMLFile("places/dominion/enforcerWarehouse/generic", "CLAIRE_WARNING", guard);
            }
            return CORRIDOR.getContent();
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (!Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.claireWarning) && index == 1) {
                return new Response("\u7ee7\u7eed", "\u7ee7\u7eed\u7a7f\u8d8a\u4ed3\u5e93\u2026\u2026", CLAIRE_WARNING){

                    @Override
                    public void effects() {
                        Main.game.getDialogueFlags().setFlag(DialogueFlagValue.claireWarning, true);
                    }
                };
            }
            return null;
        }
    };
    public static final DialogueNode AFTER_CLAIRE_SEX = new DialogueNode("\u89e3\u8131", "\u4f60\u5e2e\u514b\u83b1\u5c14\u5904\u7406\u4e86\u5979\u7684\u6027\u6b32\u2026\u2026", true){

        @Override
        public int getSecondsPassed() {
            return 60;
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("places/dominion/enforcerWarehouse/generic", "AFTER_CLAIRE_SEX");
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1) {
                return new Response("\u7ee7\u7eed", "\u7ee7\u7eed\u7a7f\u8d8a\u4ed3\u5e93\u2026\u2026", Main.game.getDefaultDialogue());
            }
            return null;
        }
    };
    public static final DialogueNode ASK_CLAIRE_REPEAT_SEX = new DialogueNode("", "", false){

        @Override
        public int getSecondsPassed() {
            return 60;
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("places/dominion/enforcerWarehouse/generic", "ASK_CLAIRE_REPEAT_SEX");
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            return Main.game.getDefaultDialogue().getResponse(responseTab, index);
        }
    };
    public static final DialogueNode CRATES = new DialogueNode("\u677f\u6761\u7bb1", "", false){

        @Override
        public int getSecondsPassed() {
            return 60;
        }

        @Override
        public String getContent() {
            StringBuilder sb = new StringBuilder();
            if (Main.game.getPlayerCell().getPlace().getPlaceType() == PlaceType.ENFORCER_WAREHOUSE_CRATES_SEARCHED) {
                sb.append(UtilText.parseFromXMLFile("places/dominion/enforcerWarehouse/generic", "CRATE_SEARCHED"));
            }
            sb.append(UtilText.parseFromXMLFile("places/dominion/enforcerWarehouse/generic", "CRATES"));
            if (Main.game.getNpc(Claire.class).getLust() > 75.0f || Main.game.getNpc(Claire.class).getSexCount(Main.game.getPlayer()).getTotalTimesHadSex() > 0) {
                sb.append(UtilText.parseFromXMLFile("places/dominion/enforcerWarehouse/generic", "CRATES_RECESS"));
            }
            return sb.toString();
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1) {
                if (Main.game.getPlayerCell().getPlace().getPlaceType() == PlaceType.ENFORCER_WAREHOUSE_CRATES_SEARCHED || Main.game.getPlayerCell().getPlace().getPlaceType() == PlaceType.ENFORCER_WAREHOUSE_CRATES_ARK_SEARCHED) {
                    return new Response("\u7ffb\u627e\u677f\u6761\u7bb1", "\u7ffb\u8fc7\u8be5\u533a\u57df\u6240\u6709\u5f00\u5c01\u7684\u677f\u6761\u7bb1\u4e86\uff01", null);
                }
                return new Response("\u7ffb\u627e\u677f\u6761\u7bb1", "\u7ffb\u8fc7\u8fd9\u4e9b\u677f\u6761\u7bb1\uff0c\u770b\u770b\u80fd\u5426\u627e\u5230\u4e9b\u6709\u7528\u7684\u4e1c\u897f\u3002", CRATES_SEARCH){

                    @Override
                    public void effects() {
                        double rnd = Math.random();
                        if (rnd < 0.25) {
                            ArrayList<AbstractClothingType> clothingToGenerate = new ArrayList<AbstractClothingType>(ClothingType.getAllClothing());
                            clothingToGenerate.removeIf(clothing -> !clothing.getDefaultItemTags().contains((Object)ItemTag.SOLD_BY_NYAN));
                            AbstractClothing clothing2 = Main.game.getItemGen().generateClothing(Util.randomItemFrom(clothingToGenerate), false);
                            for (int i = 0; i < Util.random.nextInt(4); ++i) {
                                TFModifier rndMod = TFModifier.getClothingAttributeList().get(Util.random.nextInt(TFModifier.getClothingAttributeList().size()));
                                clothing2.addEffect(new ItemEffect(ItemEffectType.CLOTHING, TFModifier.CLOTHING_ATTRIBUTE, rndMod, TFPotency.getRandomWeightedPositivePotency(), 0));
                            }
                            Main.game.getTextEndStringBuilder().append(Main.game.getPlayer().addClothing(clothing2, 1, false, true));
                        } else if (rnd < 0.5) {
                            ArrayList<AbstractWeaponType> weaponToGenerate = new ArrayList<AbstractWeaponType>(WeaponType.getAllWeapons());
                            weaponToGenerate.removeIf(weapon -> weapon.getRarity() != Rarity.RARE && weapon.getRarity() != Rarity.EPIC || !weapon.getItemTags().contains((Object)ItemTag.SOLD_BY_VICKY));
                            AbstractWeapon weapon2 = Main.game.getItemGen().generateWeapon(Util.randomItemFrom(weaponToGenerate));
                            Main.game.getTextEndStringBuilder().append(Main.game.getPlayer().addWeapon(weapon2, 1, false, true));
                        } else {
                            ArrayList<AbstractItemType> itemTypes = Util.newArrayListOfValues(ItemType.getItemTypeFromId("BOTTLED_ESSENCE_DEMON"), ItemType.getItemTypeFromId("innoxia_race_demon_liliths_gift"), ItemType.FETISH_UNREFINED);
                            AbstractItem item = Main.game.getItemGen().generateItem(Util.randomItemFrom(itemTypes));
                            Main.game.getTextEndStringBuilder().append(Main.game.getPlayer().addItem(item, 3 + Util.random.nextInt(6), false, true));
                        }
                        if (Main.game.getPlayerCell().getPlace().getPlaceType() == PlaceType.ENFORCER_WAREHOUSE_CRATES_ARK) {
                            Main.game.getPlayerCell().getPlace().setPlaceType(PlaceType.ENFORCER_WAREHOUSE_CRATES_ARK_SEARCHED);
                            Main.game.getPlayerCell().getPlace().setName(PlaceType.ENFORCER_WAREHOUSE_CRATES_ARK_SEARCHED.getName());
                        } else {
                            Main.game.getPlayerCell().getPlace().setPlaceType(PlaceType.ENFORCER_WAREHOUSE_CRATES_SEARCHED);
                            Main.game.getPlayerCell().getPlace().setName(PlaceType.ENFORCER_WAREHOUSE_CRATES_SEARCHED.getName());
                        }
                    }
                };
            }
            if (index == 2) {
                return EnforcerWarehouse.getClaireCratesSexResponse();
            }
            return null;
        }
    };
    public static final DialogueNode CRATES_SEARCH = new DialogueNode("\u677f\u6761\u7bb1", "", false){

        @Override
        public int getSecondsPassed() {
            return 60;
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("places/dominion/enforcerWarehouse/generic", "CRATES_SEARCH");
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            return CRATES.getResponse(responseTab, index);
        }
    };
    public static final DialogueNode CRATES_ARK = new DialogueNode("\u677f\u6761\u7bb1", "", false){

        @Override
        public int getSecondsPassed() {
            return 60;
        }

        @Override
        public String getContent() {
            if (Main.game.isSillyModeEnabled()) {
                if (Main.game.getPlayerCell().getPlace().getPlaceType() == PlaceType.ENFORCER_WAREHOUSE_CRATES_ARK_SEARCHED) {
                    return UtilText.parseFromXMLFile("places/dominion/enforcerWarehouse/generic", "CRATES_ARK_SEARCHED");
                }
                return UtilText.parseFromXMLFile("places/dominion/enforcerWarehouse/generic", "CRATES_ARK");
            }
            return CRATES.getContent();
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            return CRATES.getResponse(responseTab, index);
        }
    };
    public static final DialogueNode CRATES_LUST_WEAPON = new DialogueNode("\u201c\u7edd\u5bc6\u201d\u677f\u6761\u7bb1", "", false){

        @Override
        public int getSecondsPassed() {
            return 60;
        }

        @Override
        public String getContent() {
            StringBuilder sb = new StringBuilder();
            if (Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.claireObtainedLightningGlobe)) {
                return UtilText.parseFromXMLFile("places/dominion/enforcerWarehouse/generic", "CRATES_LUST_WEAPON_SEARCHED");
            }
            sb.append(UtilText.parseFromXMLFile("places/dominion/enforcerWarehouse/generic", "CRATES_LUST_WEAPON"));
            if (Main.game.getNpc(Claire.class).getLust() > 75.0f || Main.game.getNpc(Claire.class).getSexCount(Main.game.getPlayer()).getTotalTimesHadSex() > 0) {
                sb.append(UtilText.parseFromXMLFile("places/dominion/enforcerWarehouse/generic", "CRATES_RECESS"));
            }
            return sb.toString();
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1) {
                if (Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.claireObtainedLightningGlobe)) {
                    return new Response("\u7ffb\u627e\u677f\u6761\u7bb1", "\u7ffb\u8fc7\u8be5\u533a\u57df\u6240\u6709\u5f00\u5c01\u7684\u677f\u6761\u7bb1\u4e86\uff01", null);
                }
                return new Response("\u7ffb\u627e\u677f\u6761\u7bb1", "\u5728\u201c\u7edd\u5bc6\u201d\u677f\u6761\u7bb1\u4e2d\u7ffb\u627e\uff0c\u770b\u770b\u6709\u6ca1\u6709\u4ec0\u4e48\u80fd\u5e2e\u52a9\u4f60\u4eec\u9003\u79bb\u4ed3\u5e93\u7684\u4e1c\u897f\u3002", CRATES_LUST_WEAPON_SEARCH){

                    @Override
                    public void effects() {
                        Main.game.getDialogueFlags().setFlag(DialogueFlagValue.claireObtainedLightningGlobe, true);
                        Main.game.getTextEndStringBuilder().append(Main.game.getNpc(Claire.class).setLust(80.0f));
                        Main.game.getTextEndStringBuilder().append(Main.game.getPlayer().incrementLust(20.0f, false));
                        Main.game.getPlayerCell().getPlace().setPlaceType(PlaceType.ENFORCER_WAREHOUSE_CRATES_SEARCHED);
                        Main.game.getPlayerCell().getPlace().setName(PlaceType.ENFORCER_WAREHOUSE_CRATES_SEARCHED.getName());
                    }
                };
            }
            if (index == 2) {
                return EnforcerWarehouse.getClaireCratesSexResponse();
            }
            return null;
        }
    };
    public static final DialogueNode CRATES_LUST_WEAPON_SEARCH = new DialogueNode("\u201c\u7edd\u5bc6\u201d\u677f\u6761\u7bb1", "", true){

        @Override
        public int getSecondsPassed() {
            return 60;
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("places/dominion/enforcerWarehouse/generic", "CRATES_LUST_WEAPON_SEARCH");
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1) {
                return new Response("\u5e2e\u5fd9", "\u8be2\u95ee\u514b\u83b1\u5c14\u5979\u662f\u4e0d\u662f\u8fd8\u597d\u3002", CRATES_LUST_WEAPON_OBTAINED){

                    @Override
                    public void effects() {
                        AbstractItem item = Main.game.getItemGen().generateItem(ItemType.getItemTypeFromId("BOTTLED_ESSENCE_DEMON"));
                        Main.game.getTextEndStringBuilder().append(Main.game.getPlayer().addWeapon(Main.game.getItemGen().generateWeapon("innoxia_lightningGlobe_lightning_globe", DamageType.LUST), 1, false, true));
                        Main.game.getTextEndStringBuilder().append(Main.game.getPlayer().addItem(item, 3, false, true));
                    }
                };
            }
            return null;
        }
    };
    public static final DialogueNode CRATES_LUST_WEAPON_OBTAINED = new DialogueNode("\u201c\u7edd\u5bc6\u201d\u677f\u6761\u7bb1", "", true){

        @Override
        public int getSecondsPassed() {
            return 60;
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("places/dominion/enforcerWarehouse/generic", "CRATES_LUST_WEAPON_OBTAINED");
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1) {
                return new Response("\u7ee7\u7eed", "\u76f8\u4fe1\u514b\u83b1\u5c14\u8db3\u4ee5\u81ea\u63a7\uff0c\u7ee7\u7eed\u524d\u8fdb\u3002", CRATES_LUST_WEAPON_OBTAINED_CONTINUE){

                    @Override
                    public void effects() {
                    }
                };
            }
            if (index == 2) {
                return EnforcerWarehouse.getClaireCratesSexResponse();
            }
            return null;
        }
    };
    public static final DialogueNode CRATES_LUST_WEAPON_OBTAINED_CONTINUE = new DialogueNode("\u201c\u7edd\u5bc6\u201d\u677f\u6761\u7bb1", "", false){

        @Override
        public int getSecondsPassed() {
            return 60;
        }

        @Override
        public String getContent() {
            StringBuilder sb = new StringBuilder();
            sb.append(UtilText.parseFromXMLFile("places/dominion/enforcerWarehouse/generic", "CRATES_LUST_WEAPON_OBTAINED_CONTINUE"));
            sb.append(CRATES_LUST_WEAPON.getContent());
            return sb.toString();
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            return CRATES_LUST_WEAPON.getResponse(responseTab, index);
        }
    };
    public static final DialogueNode SHELVES_SPELL_BOOK = new DialogueNode("\u8d27\u67b6", "", false){

        @Override
        public int getSecondsPassed() {
            return 60;
        }

        @Override
        public String getContent() {
            StringBuilder sb = new StringBuilder();
            if (Main.game.getPlayerCell().getPlace().getPlaceType() == PlaceType.ENFORCER_WAREHOUSE_CRATES_SPELL_BOOK_SEARCHED) {
                return UtilText.parseFromXMLFile("places/dominion/enforcerWarehouse/generic", "SHELVES_SPELL_BOOK_SEARCHED");
            }
            sb.append(UtilText.parseFromXMLFile("places/dominion/enforcerWarehouse/generic", "SHELVES_SPELL_BOOK"));
            if (Main.game.getNpc(Claire.class).getLust() > 75.0f || Main.game.getNpc(Claire.class).getSexCount(Main.game.getPlayer()).getTotalTimesHadSex() > 0) {
                sb.append(UtilText.parseFromXMLFile("places/dominion/enforcerWarehouse/generic", "CRATES_RECESS"));
            }
            return sb.toString();
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1) {
                if (Main.game.getPlayerCell().getPlace().getPlaceType() == PlaceType.ENFORCER_WAREHOUSE_CRATES_SPELL_BOOK_SEARCHED) {
                    return new Response("\u641c\u7d22\u8d27\u67b6", "\u4f60\u5df2\u7ecf\u641c\u7d22\u8fc7\u8be5\u533a\u57df\u7684\u6240\u6709\u8d27\u67b6\u4e86\uff01", null);
                }
                return new Response("\u641c\u7d22\u8d27\u67b6", "\u641c\u7d22\u8fd9\u4e9b\u8d27\u67b6\uff0c\u770b\u770b\u80fd\u5426\u627e\u5230\u4e9b\u6709\u7528\u7684\u4e1c\u897f\u3002", SHELVES_SPELL_BOOK_SEARCH){

                    @Override
                    public void effects() {
                        Main.game.getPlayerCell().getPlace().setPlaceType(PlaceType.ENFORCER_WAREHOUSE_CRATES_SPELL_BOOK_SEARCHED);
                        Main.game.getPlayerCell().getPlace().setName(PlaceType.ENFORCER_WAREHOUSE_CRATES_SPELL_BOOK_SEARCHED.getName());
                        AbstractItem item = Main.game.getItemGen().generateItem(ItemType.getSpellBookType(Spell.TELEPATHIC_COMMUNICATION));
                        Main.game.getTextEndStringBuilder().append(Main.game.getPlayer().addItem(item, 1, false, true));
                    }
                };
            }
            if (index == 2) {
                return EnforcerWarehouse.getClaireCratesSexResponse();
            }
            return null;
        }
    };
    public static final DialogueNode SHELVES_SPELL_BOOK_SEARCH = new DialogueNode("\u677f\u6761\u7bb1", "", false){

        @Override
        public int getSecondsPassed() {
            return 60;
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("places/dominion/enforcerWarehouse/generic", "CRATES_SPELL_BOOK_SEARCH");
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            return SHELVES_SPELL_BOOK.getResponse(responseTab, index);
        }
    };
    public static final DialogueNode ENFORCER_GUARD_POST = new DialogueNode("\u6267\u6cd5\u8005\u5c97\u54e8", "", true){

        @Override
        public boolean isTravelDisabled() {
            return !Main.game.getDialogueFlags().warehouseDefeatedIDs.contains(EnforcerWarehouse.getEnforcersPresent().get(0).getId());
        }

        @Override
        public int getSecondsPassed() {
            return 60;
        }

        @Override
        public String getContent() {
            if (Main.game.getDialogueFlags().warehouseDefeatedIDs.contains(EnforcerWarehouse.getEnforcersPresent().get(0).getId())) {
                return UtilText.parseFromXMLFile("places/dominion/enforcerWarehouse/generic", "ENFORCER_GUARD_POST_CLEARED", EnforcerWarehouse.getEnforcersPresent());
            }
            return UtilText.parseFromXMLFile("places/dominion/enforcerWarehouse/generic", "ENFORCER_GUARD_POST", EnforcerWarehouse.getEnforcersPresent());
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            GameCharacter guard = EnforcerWarehouse.getEnforcersPresent().get(0);
            if (!Main.game.getDialogueFlags().warehouseDefeatedIDs.contains(guard.getId()) && index == 1) {
                return new ResponseCombat("\u81ea\u536b", UtilText.parse(guard, "\u4e0e\u8fd9\u4e2a\u597d\u6218\u7684[npc.race]SWORD\u5b88\u536b\u6218\u6597\u3002", new ParserTag[0]), (NPC)guard, Util.newHashMapOfValues(new Util.Value<PlayerCharacter, String>(Main.game.getPlayer(), UtilText.parseFromXMLFile("places/dominion/enforcerWarehouse/generic", "ENFORCER_GUARD_POST_PLAYER_FIGHT_START", EnforcerWarehouse.getEnforcersPresent())), new Util.Value<GameCharacter, String>(guard, UtilText.parseFromXMLFile("places/dominion/enforcerWarehouse/generic", "ENFORCER_GUARD_POST_GUARD_FIGHT_START", EnforcerWarehouse.getEnforcersPresent()))));
            }
            return null;
        }
    };
    public static final DialogueNode AFTER_GUARD_COMBAT_VICTORY = new DialogueNode("\u80dc\u5229", "\u4f60\u6210\u529f\u51fb\u8d25\u4e86SWORD\u5b88\u536b\uff01", true){

        @Override
        public int getSecondsPassed() {
            return 60;
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("places/dominion/enforcerWarehouse/generic", "AFTER_GUARD_COMBAT_VICTORY", EnforcerWarehouse.getEnforcersPresent());
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            GameCharacter guard = EnforcerWarehouse.getEnforcersPresent().get(0);
            if (index == 1) {
                return new Response("\u7ee7\u7eed", UtilText.parse(guard, "\u628a\u8fd9\u4e2a\u88ab\u51fb\u8d25\u7684[npc.race]\u4e22\u5728\u8eab\u540e\uff0c\u7ee7\u7eed\u7a7f\u8fc7\u4ed3\u5e93\u3002", new ParserTag[0]), Main.game.getDefaultDialogue());
            }
            return null;
        }
    };
    public static final DialogueNode AFTER_GUARD_COMBAT_DEFEAT = new DialogueNode("\u843d\u8d25", "SWORD\u5b88\u536b\u8bc1\u660e\u4f60\u8fd8\u662f\u4e0d\u884c\uff01", true){

        @Override
        public int getSecondsPassed() {
            return 60;
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("places/dominion/enforcerWarehouse/generic", "AFTER_GUARD_COMBAT_DEFEAT", EnforcerWarehouse.getEnforcersPresent());
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            final GameCharacter guard = EnforcerWarehouse.getEnforcersPresent().get(0);
            if (index == 1) {
                return new Response("\u88ab\u62d8\u7559\u2026\u2026", UtilText.parse(guard, "\u88ab\u51fb\u8d25\u540e\uff0c\u4f60\u65e0\u53ef\u62b5\u6297\uff0c\u53ea\u80fd\u88ab[npc.name(the)]\u62d6\u8d70\uff0c\u8fce\u63a5\u4f60\u7684\u547d\u8fd0\u2026\u2026", new ParserTag[0]), AFTER_GUARD_COMBAT_DEFEAT_ENTRANCE){

                    @Override
                    public void effects() {
                        arrestingGuard = (EnforcerWarehouseGuard)guard;
                        Main.game.getPlayer().setLocation(WorldType.ENFORCER_WAREHOUSE, PlaceType.ENFORCER_WAREHOUSE_ENTRANCE, false);
                        arrestingGuard.setLocation(WorldType.ENFORCER_WAREHOUSE, PlaceType.ENFORCER_WAREHOUSE_ENTRANCE, false);
                        Main.game.getNpc(Claire.class).returnToHome();
                        Main.game.getNpc(Claire.class).setLust(Main.game.getNpc(Claire.class).getRestingLust());
                    }
                };
            }
            return null;
        }
    };
    public static final DialogueNode AFTER_GUARD_COMBAT_DEFEAT_ENTRANCE = new DialogueNode("", "", true){

        @Override
        public int getSecondsPassed() {
            return 60;
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("places/dominion/enforcerWarehouse/generic", "AFTER_GUARD_COMBAT_DEFEAT_ENTRANCE", EnforcerWarehouse.getEnforcersPresent());
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1) {
                if (Main.game.isNonConEnabled()) {
                    return new Response("\u9888\u624b\u67b7", UtilText.parse((GameCharacter)arrestingGuard, "[npc.Name(the)]\u628a\u4f60\u62d6\u5230\u4e86\u9888\u624b\u67b7\u65c1\u2026\u2026", new ParserTag[0]), AFTER_COMBAT_DEFEAT_SENT_TO_STOCKS){

                        @Override
                        public void effects() {
                            Main.game.getPlayer().setLocation(WorldType.SLAVER_ALLEY, PlaceType.SLAVER_ALLEY_PUBLIC_STOCKS, false);
                            arrestingGuard.setLocation(Main.game.getPlayer(), false);
                            Main.game.getNpc(Claire.class).returnToHome();
                            Main.game.getNpc(Claire.class).setLust(Main.game.getNpc(Claire.class).getRestingLust());
                            Main.game.getTextEndStringBuilder().append(Main.game.getPlayer().setQuestProgress(QuestLine.SIDE_TELEPORTATION, Quest.TELEPORTING_CAUGHT));
                        }
                    };
                }
                return new Response("\u88ab\u9501\u4f4f", UtilText.parse((GameCharacter)arrestingGuard, "[npc.Name(the)]\u628a\u4f60\u62d6\u8fdb\u4e86\u6267\u6cd5\u8005\u603b\u90e8\uff0c\u4e22\u5165\u4e86\u76d1\u72f1\u2026\u2026", new ParserTag[0]), AFTER_COMBAT_DEFEAT_SENT_TO_CELLS){

                    @Override
                    public void effects() {
                        Main.game.getPlayer().setLocation(WorldType.ENFORCER_HQ, PlaceType.ENFORCER_HQ_CELL, false);
                        Main.game.getTextStartStringBuilder().append(UtilText.parseFromXMLFile("places/dominion/enforcerWarehouse/generic", "AFTER_COMBAT_DEFEAT_SENT_TO_CELLS", arrestingGuard));
                        arrestingGuard.returnToHome();
                        Main.game.getNpc(Claire.class).returnToHome();
                        Main.game.getNpc(Claire.class).setLust(Main.game.getNpc(Claire.class).getRestingLust());
                        Main.game.getTextEndStringBuilder().append(Main.game.getPlayer().setQuestProgress(QuestLine.SIDE_TELEPORTATION, Quest.TELEPORTING_CAUGHT));
                    }
                };
            }
            return null;
        }
    };
    public static final DialogueNode ENTRANCE = new DialogueNode("\u4ed3\u5e93\u5165\u53e3", "", true){

        @Override
        public int getSecondsPassed() {
            return 60;
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("places/dominion/enforcerWarehouse/generic", "ENTRANCE", EnforcerWarehouse.getEnforcersPresent());
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 0) {
                return new Response("\u653e\u5f03", "\u56de\u5230\u4ed3\u5e93\u91cc\uff0c\u91cd\u65b0\u601d\u8003\u8be5\u5982\u4f55\u79bb\u5f00\u8fd9\u91cc\u3002", CORRIDOR){

                    @Override
                    public void effects() {
                        Main.game.getTextStartStringBuilder().append(UtilText.parseFromXMLFile("places/dominion/enforcerWarehouse/generic", "ENTRANCE_BACK_OFF"));
                        Main.game.getTextStartStringBuilder().append(UtilText.parseFromXMLFile("places/dominion/enforcerWarehouse/generic", "CORRIDOR"));
                        Main.game.getPlayer().setNearestLocation(WorldType.ENFORCER_WAREHOUSE, PlaceType.ENFORCER_WAREHOUSE_CORRIDOR, false);
                    }
                };
            }
            if (index == 1) {
                return new ResponseCombat("\u6218\u6597", "\u8981\u6446\u8131\u8fd9\u4e2a\u56f0\u5883\uff0c\u552f\u4e00\u7684\u65b9\u6cd5\u5c31\u662f\u5728\u6218\u6597\u4e2d\u51fb\u8d25\u8fd9\u4e9bSWORD\u6267\u6cd5\u8005\uff01", (NPC)EnforcerWarehouse.getEnforcersPresent().get(0), EnforcerWarehouse.getEnforcersPresent(), Util.newHashMapOfValues(new Util.Value<PlayerCharacter, String>(Main.game.getPlayer(), UtilText.parseFromXMLFile("places/dominion/enforcerWarehouse/generic", "ENTRANCE_PLAYER_CHALLENGE", EnforcerWarehouse.getEnforcersPresent())), new Util.Value<GameCharacter, String>(EnforcerWarehouse.getEnforcersPresent().get(0), UtilText.parseFromXMLFile("places/dominion/enforcerWarehouse/generic", "ENTRANCE_GUARD_RESPONSE_1", EnforcerWarehouse.getEnforcersPresent().get(0))), new Util.Value<GameCharacter, String>(EnforcerWarehouse.getEnforcersPresent().get(1), UtilText.parseFromXMLFile("places/dominion/enforcerWarehouse/generic", "ENTRANCE_GUARD_RESPONSE_2", EnforcerWarehouse.getEnforcersPresent().get(1))), new Util.Value<GameCharacter, String>(EnforcerWarehouse.getEnforcersPresent().get(2), UtilText.parseFromXMLFile("places/dominion/enforcerWarehouse/generic", "ENTRANCE_GUARD_RESPONSE_3", EnforcerWarehouse.getEnforcersPresent().get(2))), new Util.Value<GameCharacter, String>(EnforcerWarehouse.getEnforcersPresent().get(3), UtilText.parseFromXMLFile("places/dominion/enforcerWarehouse/generic", "ENTRANCE_GUARD_RESPONSE_4", EnforcerWarehouse.getEnforcersPresent().get(3)))));
            }
            if (index == 2) {
                if (!Main.game.getPlayer().hasWeaponType(WeaponType.getWeaponTypeFromId("innoxia_lightningGlobe_lightning_globe"), true)) {
                    return new Response("\u95ea\u7535\u7403", "\u4f60\u6ca1\u6709\u5728\u4ed3\u5e93\u4e2d\u627e\u5230\u95ea\u7535\u7403\u2026\u2026", null);
                }
                return new Response("\u95ea\u7535\u7403", "\u8ba9\u95ea\u7535\u7403\u8fc7\u8f7d\uff0c\u4ece\u5730\u4e0a\u6eda\u5230\u6267\u6cd5\u8005\u8eab\u65c1\u3002\u4ece\u4e2d\u91ca\u653e\u7684\u50ac\u60c5\u80fd\u91cf\u7406\u5e94\u4f1a\u8ba9\u4ed6\u4eec\u6b32\u706b\u4e2d\u70e7\uff0c\u65e0\u89c6\u7ad9\u5c97\u7684\u4efb\u52a1\uff0c\u5f00\u59cb\u76f8\u4e92\u505a\u7231\u3002", ENTRANCE_LIGHTNING_GLOBE){

                    @Override
                    public void effects() {
                        for (GameCharacter c : EnforcerWarehouse.getEnforcersPresent()) {
                            c.setLust(100.0f);
                        }
                        Main.game.getTextEndStringBuilder().append("<p style='text-align:center;'><i>\u4f60[style.colourBad(\u5931\u53bb\u4e86)]<b>" + Main.game.getPlayer().getMana() + "</b>[style.colourAura(\u7075\u6c14)]\uff01</i></p>");
                        Main.game.getPlayer().setMana(0.0f);
                    }
                };
            }
            if (index == 3) {
                if (Main.game.getPlayer().hasSpell(Spell.TELEPATHIC_COMMUNICATION)) {
                    if (Main.game.getPlayer().getMana() >= Spell.TELEPATHIC_COMMUNICATION.getModifiedCost(Main.game.getPlayer())) {
                        return new Response("\u4f20\u97f3\u4f0e\u4fe9", UtilText.parse(EnforcerWarehouse.getEnforcersPresent(), "\u5bf9[npc.name(the)]\u91ca\u653e\u6cd5\u672f\u201c" + Spell.TELEPATHIC_COMMUNICATION.getName() + "\u201d\uff0c\u5e76\u501f\u52a9\u94fe\u63a5\u4f20\u9012\u4e00\u6761\u6c42\u6551\u4fe1\u606f\uff0c\u5047\u88c5\u6709\u4eba\u5728\u4ed3\u5e93\u6df1\u5904\u9700\u8981\u6551\u52a9\u2026\u2026", new ParserTag[0]), ENTRANCE_TELEPATHIC_TRICKERY);
                    }
                    return new Response("\u4f20\u97f3\u4f0e\u4fe9", "\u4f60\u6ca1\u6709\u8db3\u591f\u7684\u7075\u6c14\u91ca\u653e\u201c" + Spell.TELEPATHIC_COMMUNICATION.getName() + "\u201d\u2026\u2026", null);
                }
                return new Response("\u4f20\u97f3\u4f0e\u4fe9", "\u4f60\u8fd8\u6ca1\u6709\u5b66\u4f1a\u201c" + Spell.TELEPATHIC_COMMUNICATION.getName() + "\u201d\u2026\u2026", null);
            }
            return null;
        }
    };
    public static final DialogueNode AFTER_ENTRANCE_VICTORY = new DialogueNode("\u80dc\u5229", "\u4f60\u6210\u529f\u51fb\u8d25\u4e86SWORD\u5b88\u536b\uff01", true){

        @Override
        public int getSecondsPassed() {
            return 60;
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("places/dominion/enforcerWarehouse/generic", "AFTER_ENTRANCE_VICTORY", EnforcerWarehouse.getEnforcersPresent());
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1) {
                return new Response("\u9003\u8131", "\u4f60\u548c\u514b\u83b1\u5c14\u6700\u7ec8\u6210\u529f\u9003\u51fa\u4e86\u4ed3\u5e93\uff01", AFTER_ENTRANCE_VICTORY_ESCAPE){

                    @Override
                    public void effects() {
                        Main.game.getPlayer().setLocation(WorldType.DOMINION, PlaceType.DOMINION_ENFORCER_HQ);
                        Main.game.getNpc(Claire.class).setLocation(Main.game.getPlayer(), false);
                        Main.game.getTextEndStringBuilder().append(Main.game.getPlayer().setQuestProgress(QuestLine.SIDE_TELEPORTATION, Quest.SIDE_UTIL_COMPLETE));
                    }
                };
            }
            return null;
        }
    };
    public static final DialogueNode AFTER_ENTRANCE_VICTORY_ESCAPE = new DialogueNode("", "", true){

        @Override
        public int getSecondsPassed() {
            return 60;
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("places/dominion/enforcerWarehouse/generic", "AFTER_ENTRANCE_VICTORY_ESCAPE", EnforcerWarehouse.getEnforcersPresent());
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1) {
                return new Response("\u9053\u522b", "\u8ddf\u514b\u83b1\u5c14\u9053\u522b\uff0c\u7ee7\u7eed\u4f60\u7684\u65c5\u7a0b\u2026\u2026", Main.game.getDefaultDialogue()){

                    @Override
                    public void effects() {
                        Main.game.getNpc(Claire.class).returnToHome();
                        Main.game.getNpc(Claire.class).setLust(Main.game.getNpc(Claire.class).getRestingLust());
                        Main.game.getTextStartStringBuilder().append(UtilText.parseFromXMLFile("places/dominion/enforcerWarehouse/generic", "AFTER_ENTRANCE_VICTORY_ESCAPE_END"));
                    }
                };
            }
            return null;
        }
    };
    public static final DialogueNode AFTER_ENTRANCE_DEFEAT = new DialogueNode("\u843d\u8d25", "\u4f60\u8fd8\u662f\u96be\u4ee5\u540c\u65f6\u62b5\u6321\u56db\u4e2aSWORD\u6267\u6cd5\u8005\u3002\u4f60\u762b\u5012\u5728\u5730\uff0c\u4e00\u8d25\u6d82\u5730\u3002", true){

        @Override
        public int getSecondsPassed() {
            return 60;
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("places/dominion/enforcerWarehouse/generic", "AFTER_ENTRANCE_DEFEAT", EnforcerWarehouse.getEnforcersPresent());
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1) {
                return new Response("\u9888\u624b\u67b7", UtilText.parse(EnforcerWarehouse.getEnforcersPresent().get(0), "[npc.Name(the)]\u628a\u4f60\u62d6\u5230\u4e86\u9888\u624b\u67b7\u65c1\u2026\u2026", new ParserTag[0]), AFTER_COMBAT_DEFEAT_SENT_TO_STOCKS){

                    @Override
                    public void effects() {
                        arrestingGuard = (EnforcerWarehouseGuard)EnforcerWarehouse.getEnforcersPresent().get(0);
                        Main.game.getPlayer().setLocation(WorldType.SLAVER_ALLEY, PlaceType.SLAVER_ALLEY_PUBLIC_STOCKS, false);
                        arrestingGuard.setLocation(Main.game.getPlayer(), false);
                        Main.game.getNpc(Claire.class).returnToHome();
                        Main.game.getNpc(Claire.class).setLust(Main.game.getNpc(Claire.class).getRestingLust());
                        Main.game.getTextEndStringBuilder().append(Main.game.getPlayer().setQuestProgress(QuestLine.SIDE_TELEPORTATION, Quest.TELEPORTING_CAUGHT));
                    }
                };
            }
            return null;
        }
    };
    public static final DialogueNode ENTRANCE_LIGHTNING_GLOBE = new DialogueNode("", "", true){

        @Override
        public int getSecondsPassed() {
            return 60;
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("places/dominion/enforcerWarehouse/generic", "ENTRANCE_LIGHTNING_GLOBE", EnforcerWarehouse.getEnforcersPresent());
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1) {
                return new Response("\u9003\u8131", "\u4f60\u548c\u514b\u83b1\u5c14\u6700\u7ec8\u6210\u529f\u9003\u51fa\u4e86\u4ed3\u5e93\uff01", AFTER_ENTRANCE_VICTORY_ESCAPE){

                    @Override
                    public void effects() {
                        Main.game.getPlayer().setLocation(WorldType.DOMINION, PlaceType.DOMINION_ENFORCER_HQ);
                        Main.game.getNpc(Claire.class).setLocation(Main.game.getPlayer(), false);
                        Main.game.getTextEndStringBuilder().append(Main.game.getPlayer().setQuestProgress(QuestLine.SIDE_TELEPORTATION, Quest.SIDE_UTIL_COMPLETE));
                    }
                };
            }
            return null;
        }
    };
    public static final DialogueNode ENTRANCE_TELEPATHIC_TRICKERY = new DialogueNode("", "", true){

        @Override
        public int getSecondsPassed() {
            return 60;
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("places/dominion/enforcerWarehouse/generic", "ENTRANCE_TELEPATHIC_TRICKERY", EnforcerWarehouse.getEnforcersPresent());
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1) {
                return new Response("\u9003\u8131", "\u4f60\u548c\u514b\u83b1\u5c14\u6700\u7ec8\u6210\u529f\u9003\u51fa\u4e86\u4ed3\u5e93\uff01", AFTER_ENTRANCE_VICTORY_ESCAPE){

                    @Override
                    public void effects() {
                        Main.game.getPlayer().setLocation(WorldType.DOMINION, PlaceType.DOMINION_ENFORCER_HQ);
                        Main.game.getNpc(Claire.class).setLocation(Main.game.getPlayer(), false);
                        Main.game.getTextEndStringBuilder().append(Main.game.getPlayer().setQuestProgress(QuestLine.SIDE_TELEPORTATION, Quest.SIDE_UTIL_COMPLETE));
                    }
                };
            }
            return null;
        }
    };
    public static final DialogueNode AFTER_COMBAT_DEFEAT_SENT_TO_STOCKS = new DialogueNode("", "", true){

        @Override
        public void applyPreParsingEffects() {
            Main.game.getPlayer().setCaptive(true);
            Main.game.getPlayer().unequipAllClothingIntoHoldingInventory(Main.game.getNpc(Sean.class), false, false);
        }

        @Override
        public int getSecondsPassed() {
            return 1200;
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("places/dominion/enforcerWarehouse/generic", "AFTER_COMBAT_DEFEAT_SENT_TO_STOCKS", arrestingGuard);
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1) {
                return new ResponseSex("\u9501\u5728\u9888\u624b\u67b7\u4e0a", UtilText.parse((GameCharacter)arrestingGuard, "\u4f60\u65e0\u80fd\u4e3a\u529b\uff0c\u53ea\u80fd\u773c\u7741\u7741\u5730\u770b\u7740[npc.name]\u5bf9\u4f60\u4e3a\u6240\u6b32\u4e3a\u3002", new ParserTag[0]), false, false, new SexManagerDefault(SexPosition.STOCKS, Util.newHashMapOfValues(new Util.Value<EnforcerWarehouseGuard, SexSlot>(arrestingGuard, arrestingGuard.hasPenis() || !Main.game.getPlayer().isAbleToAccessCoverableArea(CoverableArea.MOUTH, true) ? SexSlotStocks.BEHIND_STOCKS : SexSlotStocks.RECEIVING_ORAL)), Util.newHashMapOfValues(new Util.Value<PlayerCharacter, SexSlot>(Main.game.getPlayer(), SexSlotStocks.LOCKED_IN_STOCKS))){

                    @Override
                    public Map<ImmobilisationType, Map<GameCharacter, Set<GameCharacter>>> getStartingCharactersImmobilised() {
                        return Util.newHashMapOfValues(new Util.Value(ImmobilisationType.STOCKS, Util.newHashMapOfValues(new Util.Value<EnforcerWarehouseGuard, HashSet<GameCharacter>>(arrestingGuard, Util.newHashSetOfValues(Main.game.getPlayer())))));
                    }

                    @Override
                    public boolean isCharacterStartNaked(GameCharacter character) {
                        return character.isPlayer();
                    }

                    @Override
                    public SexControl getSexControl(GameCharacter character) {
                        if (character.isPlayer()) {
                            return SexControl.NONE;
                        }
                        return super.getSexControl(character);
                    }

                    @Override
                    public boolean isPositionChangingAllowed(GameCharacter character) {
                        return false;
                    }

                    @Override
                    public boolean isAbleToRemoveOthersClothing(GameCharacter character, AbstractClothing clothing) {
                        if (character.isPlayer()) {
                            return false;
                        }
                        return super.isAbleToRemoveOthersClothing(character, clothing);
                    }

                    @Override
                    public boolean isAbleToEquipSexClothing(GameCharacter equippingCharacter, GameCharacter targetedCharacter, AbstractClothing clothingToEquip) {
                        return !equippingCharacter.isPlayer();
                    }

                    @Override
                    public boolean isAbleToRemoveSelfClothing(GameCharacter character) {
                        return !character.isPlayer();
                    }

                    @Override
                    public List<CoverableArea> getAdditionalAreasToExposeDuringSex(GameCharacter performer, GameCharacter target) {
                        return new ArrayList<CoverableArea>();
                    }
                }, null, null, AFTER_STOCKS_ENFORCER_SEX, UtilText.parseFromXMLFile("places/dominion/enforcerWarehouse/generic", "START_STOCKS_ENFORCER_SEX"));
            }
            return null;
        }
    };
    public static final DialogueNode AFTER_STOCKS_ENFORCER_SEX = new DialogueNode("\u7ed3\u675f", "", true){

        @Override
        public int getSecondsPassed() {
            return 600;
        }

        @Override
        public void applyPreParsingEffects() {
            arrestingGuard.returnToHome();
        }

        @Override
        public String getDescription() {
            return UtilText.parse((GameCharacter)arrestingGuard, "[npc.Name]\u548c\u4f60\u505a\u591f\u4e86\u2026\u2026", new ParserTag[0]);
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("places/dominion/enforcerWarehouse/generic", "AFTER_STOCKS_ENFORCER_SEX", arrestingGuard);
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1) {
                return new Response("\u964c\u751f\u4eba\u63a5\u8fd1", "\u51e0\u4e2a\u964c\u751f\u4eba\u4e0a\u524d\u6765\uff0c\u51c6\u5907\u548c\u4f60\u723d\u4e00\u723d\u2026\u2026", STOCKS_RANDOMS){

                    @Override
                    public void effects() {
                        randomSexPartners = SlaverAlleyDialogue.generateRandomStocksPartners(Main.game.getPlayer(), true);
                    }
                };
            }
            return null;
        }
    };
    public static final DialogueNode STOCKS_RANDOMS = new DialogueNode("", "", true){

        @Override
        public int getSecondsPassed() {
            return 1200;
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("places/dominion/enforcerWarehouse/generic", "STOCKS_RANDOMS", randomSexPartners);
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1) {
                return new ResponseSex("\u518d\u6b21\u88ab\u4f7f\u7528", "\u6709\u4e24\u4e2a\u964c\u751f\u4eba\u7ad9\u597d\u4f4d\u7f6e\uff0c\u5f00\u59cb\u4f7f\u7528\u4f60\u89e3\u51b3\u6027\u6b32\u2026\u2026", false, false, new SexManagerDefault(SexPosition.STOCKS, Util.newHashMapOfValues(new Util.Value<GameCharacter, SexSlot>(randomSexPartners.get(0), SexSlotStocks.BEHIND_STOCKS), new Util.Value<GameCharacter, SexSlot>(randomSexPartners.get(1), SexSlotStocks.RECEIVING_ORAL)), Util.newHashMapOfValues(new Util.Value<PlayerCharacter, SexSlot>(Main.game.getPlayer(), SexSlotStocks.LOCKED_IN_STOCKS))){

                    @Override
                    public Map<ImmobilisationType, Map<GameCharacter, Set<GameCharacter>>> getStartingCharactersImmobilised() {
                        return Util.newHashMapOfValues(new Util.Value(ImmobilisationType.STOCKS, Util.newHashMapOfValues(new Util.Value<GameCharacter, HashSet<GameCharacter>>(randomSexPartners.get(0), Util.newHashSetOfValues(Main.game.getPlayer())))));
                    }

                    @Override
                    public boolean isCharacterStartNaked(GameCharacter character) {
                        return character.isPlayer();
                    }

                    @Override
                    public SexControl getSexControl(GameCharacter character) {
                        if (character.isPlayer()) {
                            return SexControl.NONE;
                        }
                        return super.getSexControl(character);
                    }

                    @Override
                    public boolean isPositionChangingAllowed(GameCharacter character) {
                        return false;
                    }

                    @Override
                    public boolean isAbleToRemoveOthersClothing(GameCharacter character, AbstractClothing clothing) {
                        if (character.isPlayer()) {
                            return false;
                        }
                        return super.isAbleToRemoveOthersClothing(character, clothing);
                    }

                    @Override
                    public boolean isAbleToEquipSexClothing(GameCharacter equippingCharacter, GameCharacter targetedCharacter, AbstractClothing clothingToEquip) {
                        return !equippingCharacter.isPlayer();
                    }

                    @Override
                    public boolean isAbleToRemoveSelfClothing(GameCharacter character) {
                        return !character.isPlayer();
                    }

                    @Override
                    public List<CoverableArea> getAdditionalAreasToExposeDuringSex(GameCharacter performer, GameCharacter target) {
                        return new ArrayList<CoverableArea>();
                    }
                }, null, null, AFTER_STOCKS_RANDOM_SEX, UtilText.parseFromXMLFile("places/dominion/enforcerWarehouse/generic", "START_STOCKS_RANDOM_SEX", randomSexPartners)){

                    @Override
                    public void effects() {
                        arrestingGuard.returnToHome();
                    }
                };
            }
            return null;
        }
    };
    public static final DialogueNode AFTER_STOCKS_RANDOM_SEX = new DialogueNode("\u7ed3\u675f", "", true){

        @Override
        public int getSecondsPassed() {
            return 1200;
        }

        @Override
        public String getDescription() {
            return UtilText.parse(randomSexPartners, "[npc.Name]\u548c[npc2.name]\u8ddf\u4f60\u505a\u5b8c\u4e86\u2026\u2026", new ParserTag[0]);
        }

        @Override
        public void applyPreParsingEffects() {
            Main.game.getNpc(Claire.class).setLocation(Main.game.getPlayer(), false);
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("places/dominion/enforcerWarehouse/generic", "AFTER_STOCKS_RANDOM_SEX", randomSexPartners);
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1) {
                return new Response("\u88ab\u6551\u4e0b", "\u76d1\u7ba1\u76d1\u72f1\u7684\u6267\u6cd5\u8005\u89e3\u5f00\u4e86\u9501\uff0c\u5c06\u4f60\u653e\u5f52\u81ea\u7531\u3002", STOCKS_SET_FREE){

                    @Override
                    public void effects() {
                        for (GameCharacter character : randomSexPartners) {
                            Main.game.banishNPC((NPC)character);
                        }
                        Main.game.getNpc(Claire.class).returnToHome();
                        Main.game.getNpc(Claire.class).setLust(Main.game.getNpc(Claire.class).getRestingLust());
                        Main.game.getTextEndStringBuilder().append(Main.game.getPlayer().setQuestProgress(QuestLine.SIDE_TELEPORTATION, Quest.SIDE_UTIL_COMPLETE));
                    }
                };
            }
            return null;
        }
    };
    public static final DialogueNode STOCKS_SET_FREE = new DialogueNode("", "", true, true){

        @Override
        public int getSecondsPassed() {
            return 300;
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("places/dominion/enforcerWarehouse/generic", "STOCKS_SET_FREE");
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1) {
                return new Response("\u7ee7\u7eed", "\u7ee7\u7eed\u4f60\u7684\u65c5\u7a0b\u2026\u2026", Main.game.getDefaultDialogue()){

                    @Override
                    public void effects() {
                        Main.game.getPlayer().setCaptive(false);
                        Main.game.getPlayer().equipAllClothingFromHoldingInventory();
                    }
                };
            }
            return null;
        }
    };
    public static final DialogueNode AFTER_COMBAT_DEFEAT_SENT_TO_CELLS = new DialogueNode("", "", true){

        @Override
        public void applyPreParsingEffects() {
            Main.game.getPlayer().setCaptive(true);
        }

        @Override
        public int getSecondsPassed() {
            return 300;
        }

        @Override
        public String getContent() {
            return "";
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1) {
                return new Response("\u7b49\u5f85", "\u4f60\u65e0\u4e8b\u53ef\u505a\uff0c\u53ea\u5f97\u7b49\u4eba\u5c06\u4f60\u89e3\u6551\u4e0b\u6765\u2026\u2026", AFTER_COMBAT_DEFEAT_CELLS_WAITING){

                    @Override
                    public void effects() {
                        Main.game.getNpc(Claire.class).setLocation(Main.game.getPlayer(), false);
                    }
                };
            }
            return null;
        }
    };
    public static final DialogueNode AFTER_COMBAT_DEFEAT_CELLS_WAITING = new DialogueNode("", "", true){

        @Override
        public int getSecondsPassed() {
            return 7200;
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("places/dominion/enforcerWarehouse/generic", "AFTER_COMBAT_DEFEAT_CELLS_WAITING");
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1) {
                return new Response("\u88ab\u6551\u4e0b", "\u514b\u83b1\u5c14\u547d\u4ee4\u770b\u7ba1\u76d1\u72f1\u7684\u6267\u6cd5\u8005\u7ed9\u9888\u624b\u67b7\u89e3\u9501\uff0c\u5c06\u4f60\u653e\u5f52\u81ea\u7531\u3002", CELLS_SET_FREE){

                    @Override
                    public void effects() {
                        Main.game.getNpc(Claire.class).returnToHome();
                        Main.game.getNpc(Claire.class).setLust(Main.game.getNpc(Claire.class).getRestingLust());
                        Main.game.getTextEndStringBuilder().append(Main.game.getPlayer().setQuestProgress(QuestLine.SIDE_TELEPORTATION, Quest.SIDE_UTIL_COMPLETE));
                        Main.game.getPlayer().setCaptive(false);
                        Main.game.getPlayer().setLocation(WorldType.DOMINION, PlaceType.DOMINION_ENFORCER_HQ, false);
                    }
                };
            }
            return null;
        }
    };
    public static final DialogueNode CELLS_SET_FREE = new DialogueNode("", "", true, true){

        @Override
        public int getSecondsPassed() {
            return 300;
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("places/dominion/enforcerWarehouse/generic", "CELLS_SET_FREE");
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1) {
                return new Response("\u7ee7\u7eed", "\u7ee7\u7eed\u4f60\u7684\u65c5\u7a0b\u2026\u2026", Main.game.getDefaultDialogue());
            }
            return null;
        }
    };

    public static List<GameCharacter> getEnforcersPresent() {
        ArrayList<GameCharacter> list = new ArrayList<GameCharacter>();
        for (GameCharacter gameCharacter : Main.game.getCharactersPresent()) {
            if (!(gameCharacter instanceof EnforcerWarehouseGuard)) continue;
            if (gameCharacter.getHistory() == Occupation.NPC_ENFORCER_SWORD_INSPECTOR) {
                list.add(0, gameCharacter);
                continue;
            }
            list.add(gameCharacter);
        }
        if (arrestingGuard != null) {
            list.add(0, arrestingGuard);
        }
        return list;
    }

    private static EnforcerWarehouseGuard generateGuard(Occupation occupation) {
        Gender gender = Gender.getGenderFromUserPreferences(false, false);
        HashMap<AbstractSubspecies, Integer> subspeciesMap = new HashMap<AbstractSubspecies, Integer>();
        ArrayList<AbstractSubspecies> subspeciesAvailable = Util.newArrayListOfValues(Subspecies.getSubspeciesFromId("innoxia_panther_subspecies_tiger"), Subspecies.getSubspeciesFromId("innoxia_panther_subspecies_lion"), Subspecies.getSubspeciesFromId("innoxia_panther_subspecies_leopard"), Subspecies.DOG_MORPH_DOBERMANN, Subspecies.DOG_MORPH_GERMAN_SHEPHERD, Subspecies.FOX_MORPH, Subspecies.WOLF_MORPH);
        for (AbstractSubspecies abstractSubspecies : subspeciesAvailable) {
            if (gender.isFeminine()) {
                if (Main.getProperties().getSubspeciesFeminineFurryPreferencesMap().get(abstractSubspecies) == FurryPreference.HUMAN || Main.getProperties().getSubspeciesFemininePreferencesMap().get(abstractSubspecies).getValue() <= 0) continue;
                subspeciesMap.put(abstractSubspecies, Main.getProperties().getSubspeciesFemininePreferencesMap().get(abstractSubspecies).getValue());
                continue;
            }
            if (Main.getProperties().getSubspeciesMasculineFurryPreferencesMap().get(abstractSubspecies) == FurryPreference.HUMAN || Main.getProperties().getSubspeciesMasculinePreferencesMap().get(abstractSubspecies).getValue() <= 0) continue;
            subspeciesMap.put(abstractSubspecies, Main.getProperties().getSubspeciesMasculinePreferencesMap().get(abstractSubspecies).getValue());
        }
        if (gender.isFeminine()) {
            for (Map.Entry entry : Main.getProperties().getSubspeciesFeminineFurryPreferencesMap().entrySet()) {
                if (entry.getValue() != FurryPreference.HUMAN) continue;
                subspeciesMap.remove(entry.getKey());
            }
        } else {
            for (Map.Entry entry : Main.getProperties().getSubspeciesMasculineFurryPreferencesMap().entrySet()) {
                if (entry.getValue() != FurryPreference.HUMAN) continue;
                subspeciesMap.remove(entry.getKey());
            }
        }
        int total = 0;
        for (Integer i : subspeciesMap.values()) {
            total += i.intValue();
        }
        if (subspeciesMap.isEmpty() || total == 0) {
            try {
                EnforcerWarehouseGuard enforcerWarehouseGuard = new EnforcerWarehouseGuard(occupation, Util.randomItemFrom(subspeciesAvailable), RaceStage.PARTIAL, gender, false, new NPCGenerationFlag[0]);
                Main.game.addNPC(enforcerWarehouseGuard, false);
                return enforcerWarehouseGuard;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            AbstractSubspecies abstractSubspecies = (AbstractSubspecies)Util.getRandomObjectFromWeightedMap(subspeciesMap);
            RaceStage stage = RaceStage.GREATER;
            stage = gender.isFeminine() ? Main.game.getCharacterUtils().getRaceStageFromPreferences(Main.getProperties().getSubspeciesFeminineFurryPreferencesMap().get(abstractSubspecies), gender, abstractSubspecies) : Main.game.getCharacterUtils().getRaceStageFromPreferences(Main.getProperties().getSubspeciesMasculineFurryPreferencesMap().get(abstractSubspecies), gender, abstractSubspecies);
            try {
                EnforcerWarehouseGuard guard = new EnforcerWarehouseGuard(occupation, abstractSubspecies, stage, gender, false, new NPCGenerationFlag[0]);
                Main.game.addNPC(guard, false);
                return guard;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static void initWarehouse() {
        ArrayList<String> usedAdjectives = Util.newArrayListOfValues("\u7126\u8651", "\u61e6\u5f31");
        for (Cell c : Main.game.getWorlds().get(WorldType.ENFORCER_WAREHOUSE).getCells(PlaceType.ENFORCER_WAREHOUSE_ENFORCER_GUARD_POST)) {
            EnforcerWarehouseGuard guard = EnforcerWarehouse.generateGuard(Occupation.NPC_ENFORCER_SWORD_CONSTABLE);
            guard.setLocation(c.getType(), c.getLocation(), true);
            usedAdjectives.add(Main.game.getCharacterUtils().setGenericName(guard, "SWORD\u5b88\u536b", usedAdjectives));
        }
        EnforcerWarehouseGuard guard = EnforcerWarehouse.generateGuard(Occupation.NPC_ENFORCER_SWORD_INSPECTOR);
        guard.setLocation(WorldType.ENFORCER_WAREHOUSE, PlaceType.ENFORCER_WAREHOUSE_ENTRANCE, true);
        guard.setGenericName("SWORD\u7763\u5bdf");
        guard = EnforcerWarehouse.generateGuard(Occupation.NPC_ENFORCER_SWORD_SERGEANT);
        guard.setLocation(WorldType.ENFORCER_WAREHOUSE, PlaceType.ENFORCER_WAREHOUSE_ENTRANCE, true);
        usedAdjectives.add(Main.game.getCharacterUtils().setGenericName(guard, "SWORD\u5b88\u536b", usedAdjectives));
        for (int i = 0; i < 2; ++i) {
            guard = EnforcerWarehouse.generateGuard(Occupation.NPC_ENFORCER_SWORD_CONSTABLE);
            guard.setLocation(WorldType.ENFORCER_WAREHOUSE, PlaceType.ENFORCER_WAREHOUSE_ENTRANCE, true);
            usedAdjectives.add(Main.game.getCharacterUtils().setGenericName(guard, "SWORD\u5b88\u536b", usedAdjectives));
        }
    }

    private static Response getClaireCratesSexResponse() {
        if (Main.game.getNpc(Claire.class).getLust() > 75.0f) {
            return new ResponseSex("\u63d0\u4f9b\u5e2e\u52a9", "\u9644\u8fd1\u6709\u51e0\u4e2a\u5806\u8d77\u7684\u677f\u6761\u7bb1\uff0c\u6b63\u662f\u4e2a\u5408\u9002\u7684\u4f4d\u7f6e\uff0c\u53ef\u4ee5\u8ba9\u4f60\u5e2e\u514b\u83b1\u5c14\u7f13\u89e3\u4e00\u4e0b\u2026\u2026", true, true, new SMClaireWarehouse(Util.newHashMapOfValues(new Util.Value<PlayerCharacter, SexSlot>(Main.game.getPlayer(), SexSlotAgainstWall.STANDING_WALL)), Util.newHashMapOfValues(new Util.Value<NPC, SexSlot>(Main.game.getNpc(Claire.class), SexSlotAgainstWall.BACK_TO_WALL))), null, null, AFTER_CLAIRE_SEX, UtilText.parseFromXMLFile("places/dominion/enforcerWarehouse/generic", "START_CLAIRE_SEX"));
        }
        if (Main.game.getNpc(Claire.class).getSexCount(Main.game.getPlayer()).getTotalTimesHadSex() > 0) {
            return new Response("\u518d\u6765\u4e00\u6b21", "\u770b\u770b\u514b\u83b1\u5c14\u8fd8\u4e0d\u60f3\u4e0d\u60f3\u5728\u677f\u6761\u7bb1\u540e\u9762\u518d\u505a\u4e00\u6b21\u2026\u2026", ASK_CLAIRE_REPEAT_SEX);
        }
        return null;
    }
}

