/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.dialogue.places.dominion.cityHall;

import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.npc.NPC;
import com.lilithsthrone.game.character.quests.QuestLine;
import com.lilithsthrone.game.dialogue.DialogueFlagValue;
import com.lilithsthrone.game.dialogue.DialogueNode;
import com.lilithsthrone.game.dialogue.responses.Response;
import com.lilithsthrone.game.dialogue.utils.ParserTag;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.game.occupantManagement.OccupancyUtil;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.rendering.SVGImages;
import com.lilithsthrone.utils.Util;
import com.lilithsthrone.utils.colours.PresetColour;
import com.lilithsthrone.world.Cell;
import com.lilithsthrone.world.WorldType;
import com.lilithsthrone.world.places.PlaceType;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class CityHall {
    private static NPC lodger;
    public static final DialogueNode OUTSIDE;
    public static final DialogueNode CITY_HALL_FOYER;
    public static final DialogueNode CITY_HALL_INFORMATION_DESK;
    public static final DialogueNode CITY_HALL_INFORMATION_DESK_NAME_CHANGE;
    public static final DialogueNode CITY_HALL_INFORMATION_DESK_PROPERTY;
    public static final DialogueNode CITY_HALL_CORRIDOR;
    public static final DialogueNode CITY_HALL_WAITING_AREA;
    public static final DialogueNode CITY_HALL_WAITING_AREA_LODGER_LIST;
    public static final DialogueNode LODGER_IMPORT;
    public static final DialogueNode CITY_HALL_APPROACH_LODGER;
    public static final DialogueNode LODGER_DENIED;
    public static final DialogueNode LODGER_GIVEN_ROOM;
    public static final DialogueNode CITY_HALL_OFFICE;
    public static final DialogueNode CITY_HALL_STAIRS;

    private static String getImportRow(String name) {
        String baseName = Util.getFileName(name);
        String identifier = Util.getFileIdentifier(name);
        return "<tr><td style='min-width:200px;'>" + baseName + "</td><td><div class='saveLoadButton' id='IMPORT_LODGER_" + identifier + "' style='color:" + PresetColour.GENERIC_GOOD.toWebHexString() + ";'>\u5bfc\u51fa</div></td></tr>";
    }

    public static void setupLodger(NPC lodger) {
        CityHall.lodger = lodger;
        Main.game.setActiveNPC(lodger);
    }

    static {
        OUTSIDE = new DialogueNode("\u95e8\u5385", "\uff0c", false){

            @Override
            public int getSecondsPassed() {
                return 120;
            }

            @Override
            public String getContent() {
                return UtilText.parseFromXMLFile("places/dominion/cityHall/generic", "OUTSIDE");
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                if (index == 1) {
                    if (Main.game.getHourOfDay() >= 9 && Main.game.getHourOfDay() <= 16) {
                        return new Response("\u8fdb\u5165", "\u5fa1\u57ce\u533a\u5e02\u653f\u5385\u5bf9\u516c\u4f17\u5f00\u653e\uff0c\u6240\u4ee5\u4f60\u53ef\u4ee5\u968f\u610f\u8fdb\u51fa\u3002", CITY_HALL_FOYER){

                            @Override
                            public void effects() {
                                Main.game.getPlayer().setLocation(WorldType.CITY_HALL, PlaceType.CITY_HALL_ENTRANCE, false);
                                Main.game.getTextStartStringBuilder().append(UtilText.parseFromXMLFile("places/dominion/cityHall/generic", "ENTRY"));
                            }
                        };
                    }
                    return new Response("\u8fdb\u5165", "\u5fa1\u57ce\u533a\u5e02\u653f\u5385\u73b0\u5728\u4e0d\u5bf9\u516c\u4f17\u5f00\u653e\uff0c \u6240\u4ee5\u5982\u679c\u4f60\u9700\u8981\u529e\u7406\u4efb\u4f55\u4e8b\u52a1\uff0c \u8bf7\u5728\u65e9\u4e0a\u4e5d\u70b9\u5230\u4e0b\u5348\u56db\u70b9\u4e4b\u95f4\u518d\u6765\u3002", null);
                }
                return null;
            }
        };
        CITY_HALL_FOYER = new DialogueNode("\u524d\u5385", "-", false){

            @Override
            public int getSecondsPassed() {
                return 30;
            }

            @Override
            public String getContent() {
                return UtilText.parseFromXMLFile("places/dominion/cityHall/generic", "CITY_HALL_FOYER");
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                if (index == 1) {
                    return new Response("\u79bb\u5f00", "\u7a7f\u8fc7\u65cb\u8f6c\u73bb\u7483\u95e8\uff0c\u56de\u5230\u5fa1\u57ce\u533a\u3002", OUTSIDE){

                        @Override
                        public void effects() {
                            Main.game.getPlayer().setLocation(WorldType.DOMINION, PlaceType.DOMINION_CITY_HALL, false);
                        }
                    };
                }
                return null;
            }
        };
        CITY_HALL_INFORMATION_DESK = new DialogueNode("\u54a8\u8be2\u53f0", "-", false){

            @Override
            public int getSecondsPassed() {
                return 10;
            }

            @Override
            public String getContent() {
                return UtilText.parseFromXMLFile("places/dominion/cityHall/generic", "CITY_HALL_INFORMATION_DESK");
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                if (index == 1) {
                    return new Response("\u4fee\u6539\u59d3\u540d", "\u8be2\u95ee\u5176\u4e2d\u4e00\u4e2a\u63a5\u5f85\u80fd\u4e0d\u80fd\u4fee\u6539\u81ea\u5df1\u7684\u59d3\u540d\u3002", CITY_HALL_INFORMATION_DESK_NAME_CHANGE);
                }
                if (index == 2) {
                    return new Response("\u5730\u4ea7", "\u8be2\u95ee\u5176\u4e2d\u4e00\u4e2a\u63a5\u5f85\uff0c\u80fd\u5426\u5728\u5fa1\u57ce\u533a\u4e70\u623f\u6216\u8005\u79df\u623f\u3002", CITY_HALL_INFORMATION_DESK_PROPERTY);
                }
                return null;
            }
        };
        CITY_HALL_INFORMATION_DESK_NAME_CHANGE = new DialogueNode("\u54a8\u8be2\u53f0", "-", false){

            @Override
            public int getSecondsPassed() {
                return 30;
            }

            @Override
            public String getContent() {
                return UtilText.parseFromXMLFile("places/dominion/cityHall/generic", "CITY_HALL_INFORMATION_DESK_NAME_CHANGE");
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                if (index == 1) {
                    return new Response("\u4fee\u6539\u59d3\u540d", "\u4f60\u5df2\u7ecf\u95ee\u8fc7\u6539\u540d\u7684\u4e8b\u4e86\u3002", null);
                }
                if (index == 2) {
                    return new Response("\u5730\u4ea7", "\u8be2\u95ee\u5176\u4e2d\u4e00\u4e2a\u63a5\u5f85\uff0c\u80fd\u5426\u5728\u5fa1\u57ce\u533a\u4e70\u623f\u6216\u8005\u79df\u623f\u3002", CITY_HALL_INFORMATION_DESK_PROPERTY);
                }
                return null;
            }
        };
        CITY_HALL_INFORMATION_DESK_PROPERTY = new DialogueNode("\u54a8\u8be2\u53f0", "-", false){

            @Override
            public int getSecondsPassed() {
                return 30;
            }

            @Override
            public String getContent() {
                return UtilText.parseFromXMLFile("places/dominion/cityHall/generic", "CITY_HALL_INFORMATION_DESK_PROPERTY");
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                if (index == 1) {
                    return new Response("\u4fee\u6539\u59d3\u540d", "\u8be2\u95ee\u5176\u4e2d\u4e00\u4e2a\u63a5\u5f85\u80fd\u4e0d\u80fd\u4fee\u6539\u81ea\u5df1\u7684\u59d3\u540d\u3002", CITY_HALL_INFORMATION_DESK_NAME_CHANGE);
                }
                if (index == 2) {
                    return new Response("\u5730\u4ea7", "\u4f60\u5df2\u7ecf\u95ee\u8fc7\u5728\u5fa1\u57ce\u533a\u4e70\u623f\u3001\u79df\u623f\u7684\u4e8b\u60c5\u4e86\u3002", null);
                }
                return null;
            }
        };
        CITY_HALL_CORRIDOR = new DialogueNode("\u8d70\u5eca", "-", false){

            @Override
            public int getSecondsPassed() {
                return 15;
            }

            @Override
            public String getContent() {
                return UtilText.parseFromXMLFile("places/dominion/cityHall/generic", "CITY_HALL_CORRIDOR");
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                return null;
            }
        };
        CITY_HALL_WAITING_AREA = new DialogueNode("\u7b49\u5f85\u5ba4", "", false){

            @Override
            public void applyPreParsingEffects() {
                if (!Main.game.getPlayer().hasQuest(QuestLine.SIDE_ACCOMMODATION)) {
                    Main.game.getTextEndStringBuilder().append(UtilText.parseFromXMLFile("places/dominion/cityHall/generic", "CITY_HALL_WAITING_AREA_LODGER_QUEST"));
                    Main.game.getTextEndStringBuilder().append(Main.game.getPlayer().startQuest(QuestLine.SIDE_ACCOMMODATION));
                } else if (!Main.game.getPlayer().isQuestCompleted(QuestLine.SIDE_ACCOMMODATION)) {
                    Main.game.getTextEndStringBuilder().append(UtilText.parseFromXMLFile("places/dominion/cityHall/generic", "CITY_HALL_WAITING_AREA_LODGER_QUEST"));
                } else if (!OccupancyUtil.isFreeRoomAvailableForOccupant()) {
                    Main.game.getTextEndStringBuilder().append(UtilText.parseFromXMLFile("places/dominion/cityHall/generic", "CITY_HALL_WAITING_AREA_LODGER_NO_ROOM"));
                } else {
                    Main.game.getTextEndStringBuilder().append(UtilText.parseFromXMLFile("places/dominion/cityHall/generic", "CITY_HALL_WAITING_AREA_LODGER_AVAILABLE"));
                }
                Main.game.getDialogueFlags().setFlag(DialogueFlagValue.cityHallLodgerBoardSeen, true);
            }

            @Override
            public int getSecondsPassed() {
                return 60;
            }

            @Override
            public String getContent() {
                return UtilText.parseFromXMLFile("places/dominion/cityHall/generic", "CITY_HALL_WAITING_AREA");
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                if (index == 1) {
                    if (!Main.game.getPlayer().isQuestCompleted(QuestLine.SIDE_ACCOMMODATION)) {
                        return new Response("\u623f\u5ba2", "\u8389\u83b1\u96c5\u8fd8\u6ca1\u6709\u5141\u8bb8\u4f60\u5728\u5979\u7684\u5b85\u90b8\u91cc\u63a5\u5f85\u623f\u5ba2\uff0c\u73b0\u5728\u53bb\u770b\u544a\u793a\u677f\u4e5f\u6ca1\u6709\u610f\u4e49\u3002", null);
                    }
                    if (!OccupancyUtil.isFreeRoomAvailableForOccupant()) {
                        return new Response("\u623f\u5ba2", "\u6ca1\u6709\u623f\u5ba2\u80fd\u591f\u5165\u4f4f\u7684\u7a7a\u623f\u95f4\uff0c\u73b0\u5728\u53bb\u770b\u544a\u793a\u677f\u4e5f\u6ca1\u6709\u610f\u4e49\u3002", null);
                    }
                    return new Response("\u623f\u5ba2", "\u4ed4\u7ec6\u77a7\u77a7\u544a\u793a\u724c\uff0c\u6709\u6ca1\u6709\u6b63\u5728\u5bfb\u6c42\u4f4f\u5904\u7684\u623f\u5ba2\u3002", CITY_HALL_WAITING_AREA_LODGER_LIST);
                }
                return null;
            }
        };
        CITY_HALL_WAITING_AREA_LODGER_LIST = new DialogueNode("", "", true){

            @Override
            public String getContent() {
                UtilText.nodeContentSB.setLength(0);
                UtilText.nodeContentSB.append(UtilText.parseFromXMLFile("places/dominion/cityHall/generic", "CITY_HALL_WAITING_AREA_LODGER_LIST"));
                UtilText.nodeContentSB.append("<p style='text-align:center;'><div class='container-full-width' style='margin-bottom:0; text-align:center;'><div style='width:40%; float:left; font-weight:bold; margin:0; padding:0;'>\u540d\u5b57</div><div style='float:left; width:17%; font-weight:bold; margin:0; padding:0; text-align:center;'><b style='color:" + PresetColour.ANDROGYNOUS.toWebHexString() + ";'>\u6027\u522b</b></div><div style='float:left; width:17%; font-weight:bold; margin:0; padding:0; text-align:center;'><b style='color:" + PresetColour.TRANSFORMATION_GENERIC.toWebHexString() + ";'>\u79cd\u65cf</b></div><div style='float:left; width:17%; font-weight:bold; margin:0; padding:0; text-align:center;'><b style='color:" + PresetColour.BASE_BROWN.toWebHexString() + ";'>\u5de5\u4f5c</b></div><div style='float:left; width:9%; font-weight:bold; margin:0; padding:0; text-align:center;'>\u63a5\u8fd1</div></div>");
                ArrayList<NPC> charactersPresent = new ArrayList<NPC>(Main.game.getCharactersPresent());
                charactersPresent.removeIf(npc -> Main.game.getPlayer().getCompanions().contains(npc));
                Collections.sort(charactersPresent, (e1, e2) -> e1.getName(true).compareTo(e2.getName(true)));
                if (charactersPresent.isEmpty()) {
                    UtilText.nodeContentSB.append("<div class='container-full-width' style='margin-bottom:0; text-align:center;'><b>\u627e\u4e0d\u5230\u4efb\u4f55\u623f\u5ba2\u2026\u2026</b></div>");
                } else {
                    int i = 0;
                    for (NPC slave : charactersPresent) {
                        boolean alternateBackground = i % 2 == 0;
                        UtilText.nodeContentSB.append(UtilText.parse((GameCharacter)slave, "<div class='container-full-width inner' style='margin-bottom:0;" + (String)(alternateBackground ? "background:" + PresetColour.BACKGROUND_ALT.toWebHexString() + ";'" : "'") + "'><div style='width:40%; float:left; margin:0; padding:0; text-align:center;'><span style='color:" + slave.getFemininity().getColour().toWebHexString() + ";'>" + slave.getName(true) + "</span></div><div style='float:left; width:17%; margin:0; padding:0; text-align:center;'>" + UtilText.parse((GameCharacter)slave, "[npc.Gender(true)]", new ParserTag[0]) + "</div><div style='float:left; width:17%; margin:0; padding:0; text-align:center;'><span style='color:" + slave.getSubspecies().getColour(slave).toWebHexString() + ";'>" + UtilText.parse((GameCharacter)slave, "[npc.Race]", new ParserTag[0]) + "</span></div><div style='float:left; width:17%; margin:0; padding:0; text-align:center;'>" + Util.capitaliseSentence(slave.getOccupation().getName(slave)) + "</div><div style='float:left; width:9%; font-weight:bold; margin:0; padding:0;'><div id='" + slave.getId() + "_LODGER' class='square-button solo'><div class='square-button-content'>" + SVGImages.SVG_IMAGE_PROVIDER.getPeopleIcon() + "</div></div></div></div>", new ParserTag[0]));
                        ++i;
                    }
                }
                UtilText.nodeContentSB.append("</p>");
                return UtilText.nodeContentSB.toString();
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                if (index == 1) {
                    return new Response("\u5bfc\u5165", "\u67e5\u770b\u5bfc\u5165\u754c\u9762\u7684\u89d2\u8272\u3002", LODGER_IMPORT);
                }
                if (index == 0) {
                    return new Response("\u8fd4\u56de", "\u4ece\u544a\u793a\u724c\u8fb9\u9000\u5f00\u3002", CITY_HALL_WAITING_AREA);
                }
                return null;
            }
        };
        LODGER_IMPORT = new DialogueNode("", "", true){

            @Override
            public String getContent() {
                return "";
            }

            @Override
            public String getHeaderContent() {
                StringBuilder saveLoadSB = new StringBuilder();
                saveLoadSB.append(UtilText.parseFromXMLFile("places/dominion/cityHall/generic", "LODGER_IMPORT_START"));
                saveLoadSB.append("<p><table align='center'>");
                Main.getSlavesForImport().sort(Comparator.comparingLong(File::lastModified).reversed());
                for (File f : Main.getSlavesForImport()) {
                    saveLoadSB.append(CityHall.getImportRow(f.getName()));
                }
                saveLoadSB.append("</table></p><p id='hiddenPField' style='display:none;'></p>");
                return saveLoadSB.toString();
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                if (index == 0) {
                    return new Response("\u8fd4\u56de", "\u56de\u5230\u4e0a\u4e00\u754c\u9762\u3002", CITY_HALL_WAITING_AREA_LODGER_LIST);
                }
                return null;
            }
        };
        CITY_HALL_APPROACH_LODGER = new DialogueNode("", "", true){

            @Override
            public int getSecondsPassed() {
                return 120;
            }

            @Override
            public String getContent() {
                return UtilText.parseFromXMLFile("places/dominion/cityHall/generic", "CITY_HALL_APPROACH_LODGER");
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                if (index == 1) {
                    return new Response("\u63d0\u4f9b\u623f\u95f4", "\u544a\u8bc9[npc.name]\u4f60\u60f3\u7ed9[npc.herHim]\u63d0\u4f9b\u4e00\u4e2a\u4f4f\u7684\u5730\u65b9\u3002", LODGER_GIVEN_ROOM){

                        @Override
                        public void effects() {
                            Cell c = OccupancyUtil.getFreeRoomForOccupant();
                            lodger.setLocation(c.getType(), c.getLocation(), true);
                            Main.game.getPlayer().setLocation(c.getType(), c.getLocation(), false);
                            Main.game.getPlayer().addFriendlyOccupant(lodger);
                            Main.game.getTextEndStringBuilder().append(lodger.setAffection(Main.game.getPlayer(), 25.0f));
                        }
                    };
                }
                if (index == 2) {
                    return new Response("\u79bb\u5f00", "\u4f60\u5bf9[npc.name]\u7684\u7b2c\u4e00\u5370\u8c61\u4e0d\u592a\u5999\uff0c\u51b3\u5b9a\u8fd8\u662f\u4e0d\u7ed9[npc.herHim]\u63d0\u4f9b\u4f4f\u5904\u4e86\u2026\u2026", LODGER_DENIED);
                }
                return null;
            }
        };
        LODGER_DENIED = new DialogueNode("", "", false){

            @Override
            public void applyPreParsingEffects() {
                Main.game.getTextStartStringBuilder().append(UtilText.parseFromXMLFile("places/dominion/cityHall/generic", "LODGER_DENIED"));
                Main.game.banishNPC(lodger);
            }

            @Override
            public int getSecondsPassed() {
                return 120;
            }

            @Override
            public String getContent() {
                return "";
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                if (index == 1) {
                    return new Response("\u7ee7\u7eed", "\u4f60\u8ba9[npc.name]\u4f4f\u8fdb\u4e86\u65b0\u623f\u95f4\uff0c\u4fbf\u7ee7\u7eed\u4eca\u5929\u7684\u5176\u4ed6\u8ba1\u5212\u4e86\u2026\u2026", Main.game.getDefaultDialogue(false));
                }
                return null;
            }
        };
        LODGER_GIVEN_ROOM = new DialogueNode("", "", true){

            @Override
            public int getSecondsPassed() {
                return 900;
            }

            @Override
            public String getContent() {
                return UtilText.parseFromXMLFile("places/dominion/cityHall/generic", "LODGER_GIVEN_ROOM");
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                if (index == 1) {
                    return new Response("\u7ee7\u7eed", "\u4f60\u8ba9[npc.name]\u4f4f\u8fdb\u4e86\u65b0\u623f\u95f4\uff0c\u4fbf\u7ee7\u7eed\u4eca\u5929\u7684\u5176\u4ed6\u8ba1\u5212\u4e86\u2026\u2026", Main.game.getDefaultDialogue(false));
                }
                return null;
            }
        };
        CITY_HALL_OFFICE = new DialogueNode("\u79c1\u4eba\u529e\u516c\u5ba4", "-", false){

            @Override
            public int getSecondsPassed() {
                return 10;
            }

            @Override
            public String getContent() {
                return UtilText.parseFromXMLFile("places/dominion/cityHall/generic", "CITY_HALL_OFFICE");
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                return null;
            }
        };
        CITY_HALL_STAIRS = new DialogueNode("\u697c\u68af", "-", false){

            @Override
            public int getSecondsPassed() {
                return 10;
            }

            @Override
            public String getContent() {
                return UtilText.parseFromXMLFile("places/dominion/cityHall/generic", "CITY_HALL_STAIRS");
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                return null;
            }
        };
    }
}

