/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.dialogue.places.dominion.harpyNests;

import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.npc.NPC;
import com.lilithsthrone.game.character.quests.Quest;
import com.lilithsthrone.game.character.quests.QuestLine;
import com.lilithsthrone.game.character.race.Subspecies;
import com.lilithsthrone.game.dialogue.DialogueFlagValue;
import com.lilithsthrone.game.dialogue.DialogueNode;
import com.lilithsthrone.game.dialogue.encounters.AbstractEncounter;
import com.lilithsthrone.game.dialogue.encounters.Encounter;
import com.lilithsthrone.game.dialogue.responses.Response;
import com.lilithsthrone.game.dialogue.responses.ResponseEffectsOnly;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.game.inventory.item.ItemType;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.world.WorldType;
import com.lilithsthrone.world.places.PlaceType;
import java.util.ArrayList;

public class HarpyNestsDialogue {
    public static final DialogueNode OUTSIDE = new DialogueNode("\u54c8\u6bd4\u4e4b\u5de2", "\u54c8\u6bd4\u4e4b\u5de2", false){

        @Override
        public int getSecondsPassed() {
            return 300;
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("places/dominion/harpyNests/generic", "OUTSIDE");
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1) {
                return new Response("\u54c8\u6bd4\u4e4b\u5de2", "\u4e0a\u53bb\u5230\u54c8\u6bd4\u4e4b\u5de2\u3002", PlaceType.HARPY_NESTS_ENTRANCE_ENFORCER_POST.getDialogue(false)){

                    @Override
                    public void effects() {
                        Main.game.getTextStartStringBuilder().append(UtilText.parseFromXMLFile("places/dominion/harpyNests/generic", "OUTSIDE_ENTRY"));
                        Main.game.getPlayer().setLocation(WorldType.HARPY_NEST, PlaceType.HARPY_NESTS_ENTRANCE_ENFORCER_POST, false);
                    }
                };
            }
            return null;
        }
    };
    public static final DialogueNode ENTRANCE_ENFORCER_POST = new DialogueNode("\u6267\u6cd5\u8005\u5c97\u54e8", ".", true){

        @Override
        public int getSecondsPassed() {
            return 60;
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("places/dominion/harpyNests/generic", "ENTRANCE_ENFORCER_POST");
        }

        @Override
        public boolean isTravelDisabled() {
            return !Main.game.getDialogueFlags().values.contains(DialogueFlagValue.hasHarpyNestAccess);
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 0) {
                return null;
            }
            if (index == 1) {
                return new Response("\u8857\u9053", "\u4e0b\u53bb\u5230\u5fa1\u57ce\u533a\u8857\u9053\u3002", PlaceType.DOMINION_HARPY_NESTS_ENTRANCE.getDialogue(false)){

                    @Override
                    public void effects() {
                        if (Main.game.getPlayer().isAbleToFly()) {
                            Main.game.getTextStartStringBuilder().append("<p>Stepping back out through the same door you used to enter the Enforcer post, you").append(!Main.game.getPlayer().isAbleToFlyFromExtraParts() ? " spread your wings and" : "").append(" swoop back down to street level.</p>");
                        } else {
                            Main.game.getTextStartStringBuilder().append("<p>\u4f60\u518d\u6b21\u8fdb\u5165\u5c06\u4f60\u5e26\u5230\u6267\u6cd5\u8005\u5c97\u54e8\u7684\u7535\u68af\uff0c\u5f88\u5feb\u5c31\u56de\u5230\u4e86\u8857\u9053\u4e0a\u3002</p>");
                        }
                        Main.game.getPlayer().setLocation(WorldType.DOMINION, PlaceType.DOMINION_HARPY_NESTS_ENTRANCE, false);
                    }
                };
            }
            ArrayList<Response> responses = new ArrayList<Response>();
            if (!Main.game.getDialogueFlags().values.contains(DialogueFlagValue.hasHarpyNestAccess)) {
                responses.add(new Response("\u8bf7\u6c42\u901a\u884c", "\u5230\u684c\u5b50\u524d\u8be2\u95ee\u4f60\u80fd\u5426\u8fdb\u5165\u54c8\u6bd4\u4e4b\u5de2\u3002", ENTRANCE_ENFORCER_POST_ASK_FOR_ACCESS){

                    @Override
                    public void effects() {
                        Main.game.getDialogueFlags().values.add(DialogueFlagValue.hasHarpyNestAccess);
                        Main.game.getTextEndStringBuilder().append(Main.game.getPlayer().addItem(Main.game.getItemGen().generateItem(ItemType.getLoreBook(Subspecies.HARPY)), false, true));
                    }
                });
            } else if (!Main.game.getPlayer().hasQuest(QuestLine.SIDE_HARPY_PACIFICATION)) {
                responses.add(new Response("\u6124\u6012\u7684\u54c8\u6bd4", "\u8be2\u95ee\u5176\u4e2d\u4e00\u4e2a\u6267\u6cd5\u8005\u54c8\u6bd4\u4e4b\u5de2\u6700\u8fd1\u51fa\u4ec0\u4e48\u5e7a\u86fe\u5b50\u4e86\u3002", ENTRANCE_ENFORCER_POST_ASK_ABOUT_RIOTS));
            } else if (Main.game.getPlayer().getQuest(QuestLine.SIDE_HARPY_PACIFICATION) == Quest.HARPY_PACIFICATION_REWARD && !Main.game.getPlayer().isQuestCompleted(QuestLine.SIDE_HARPY_PACIFICATION)) {
                responses.add(new Response("\u62a5\u544a", "\u5411\u6267\u6cd5\u8005\u62a5\u544a\u4f60\u5df2\u7ecf\u5c06\u4e09\u4f4d\u65cf\u957f\u5e73\u606f\u4e0b\u6765\u4e86\u3002", ENTRANCE_ENFORCER_POST_COMPLETED_PACIFICATION){

                    @Override
                    public void effects() {
                        Main.game.getTextEndStringBuilder().append(Main.game.getPlayer().setQuestProgress(QuestLine.SIDE_HARPY_PACIFICATION, Quest.SIDE_UTIL_COMPLETE));
                        Main.game.getTextEndStringBuilder().append(Main.game.getPlayer().incrementMoney(5000L));
                        Main.game.getDialogueFlags().setSavedLong("angry_harpies_completed", Main.game.getMinutesPassed());
                    }
                });
            } else if (!Main.game.getPlayer().isQuestCompleted(QuestLine.SIDE_HARPY_PACIFICATION)) {
                responses.add(new Response("\u62a5\u544a", "\u4f60\u8fd8\u6ca1\u80fd\u628a\u4e09\u4f4d\u65cf\u957f\u90fd\u5e73\u606f\u4e0b\u6765\uff01", null));
            }
            if (Main.game.getPlayer().hasQuest(QuestLine.SIDE_BUYING_BRAX) && Main.game.getPlayer().getQuest(QuestLine.SIDE_BUYING_BRAX) == Quest.BUYING_BRAX_LOLLIPOPS && !Main.game.getPlayer().hasItemType(ItemType.CANDI_CONTRABAND)) {
                responses.add(new Response("\u574e\u8fea\u7684\u68d2\u68d2\u7cd6", "\u8be2\u95ee\u9644\u8fd1\u7684\u6267\u6cd5\u8005\uff0c\u77e5\u4e0d\u77e5\u9053\u574e\u8fea\u8981\u6c42\u7684\u90a3\u7bb1\u68d2\u68d2\u7cd6\u3002", ENTRANCE_ENFORCER_POST_CANDIS_LOLLIPOPS){

                    @Override
                    public void effects() {
                        Main.game.getTextEndStringBuilder().append(Main.game.getPlayer().addItem(Main.game.getItemGen().generateItem(ItemType.CANDI_CONTRABAND), false));
                        Main.game.getTextEndStringBuilder().append(Main.game.getPlayer().setQuestProgress(QuestLine.SIDE_BUYING_BRAX, Quest.BUYING_BRAX_DELIVER_LOLLIPOPS));
                    }
                });
            }
            for (int i = 0; i < responses.size(); ++i) {
                if (index - 2 != i) continue;
                return (Response)responses.get(i);
            }
            return null;
        }
    };
    public static final DialogueNode ENTRANCE_ENFORCER_POST_ASK_FOR_ACCESS = new DialogueNode("\u6267\u6cd5\u8005\u5c97\u54e8", ".", true){

        @Override
        public boolean isTravelDisabled() {
            return !Main.game.getDialogueFlags().values.contains(DialogueFlagValue.hasHarpyNestAccess);
        }

        @Override
        public int getSecondsPassed() {
            return 120;
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("places/dominion/harpyNests/generic", "ENTRANCE_ENFORCER_POST_ASK_FOR_ACCESS");
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            return ENTRANCE_ENFORCER_POST.getResponse(0, index);
        }
    };
    public static final DialogueNode ENTRANCE_ENFORCER_POST_ASK_ABOUT_RIOTS = new DialogueNode("\u6267\u6cd5\u8005\u5c97\u54e8", ".", true){

        @Override
        public int getSecondsPassed() {
            return 300;
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("places/dominion/harpyNests/generic", "ENTRANCE_ENFORCER_POST_ASK_ABOUT_RIOTS");
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1) {
                return new Response("\u8ddf\u968f", "\u6309\u7167\u9a6c\u7537\u8bf4\u7684\u505a\uff0c\u8ddf\u968f\u4ed6", ENTRANCE_ENFORCER_POST_ASK_ABOUT_RIOTS_NEXT){

                    @Override
                    public void effects() {
                        Main.game.getTextEndStringBuilder().append(Main.game.getPlayer().startQuest(QuestLine.SIDE_HARPY_PACIFICATION));
                    }
                };
            }
            return null;
        }
    };
    public static final DialogueNode ENTRANCE_ENFORCER_POST_ASK_ABOUT_RIOTS_NEXT = new DialogueNode("\u6267\u6cd5\u8005\u5c97\u54e8", ".", true, true){

        @Override
        public int getSecondsPassed() {
            return 300;
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("places/dominion/harpyNests/generic", "ENTRANCE_ENFORCER_POST_ASK_ABOUT_RIOTS_NEXT");
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1) {
                return new Response("\u79bb\u5f00", "\u4f60\u5728\u540c\u610f\u5e2e\u52a9\u5e73\u606f\u54c8\u6bd4\u4e4b\u5de2\u540e\uff0c\u79bb\u5f00\u4e86\u9a6c\u7537\u7684\u529e\u516c\u5ba4\u2026\u2026", ENTRANCE_ENFORCER_POST){

                    @Override
                    public void effects() {
                        Main.game.appendToTextStartStringBuilder(UtilText.parseFromXMLFile("places/dominion/harpyNests/generic", "ENTRANCE_ENFORCER_POST_ASK_ABOUT_RIOTS_NEXT_LEAVE"));
                    }
                };
            }
            return null;
        }
    };
    public static final DialogueNode ENTRANCE_ENFORCER_POST_COMPLETED_PACIFICATION = new DialogueNode("\u6267\u6cd5\u8005\u5c97\u54e8", ".", false){

        @Override
        public int getSecondsPassed() {
            return 120;
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("places/dominion/harpyNests/generic", "ENTRANCE_ENFORCER_POST_COMPLETED_PACIFICATION");
        }

        @Override
        public boolean isTravelDisabled() {
            return !Main.game.getDialogueFlags().values.contains(DialogueFlagValue.hasHarpyNestAccess);
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            return ENTRANCE_ENFORCER_POST.getResponse(0, index);
        }
    };
    public static final DialogueNode ENTRANCE_ENFORCER_POST_CANDIS_LOLLIPOPS = new DialogueNode("\u6267\u6cd5\u8005\u5c97\u54e8", ".", false){

        @Override
        public int getSecondsPassed() {
            return 120;
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("places/dominion/harpyNests/generic", "ENTRANCE_ENFORCER_POST_CANDIS_LOLLIPOPS");
        }

        @Override
        public boolean isTravelDisabled() {
            return !Main.game.getDialogueFlags().values.contains(DialogueFlagValue.hasHarpyNestAccess);
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            return ENTRANCE_ENFORCER_POST.getResponse(responseTab, index);
        }
    };
    public static final DialogueNode WALKWAY = new DialogueNode("\u901a\u9053", ".", false){

        @Override
        public int getSecondsPassed() {
            return 120;
        }

        @Override
        public String getContent() {
            StringBuilder sb = new StringBuilder();
            sb.append(UtilText.parseFromXMLFile("places/dominion/harpyNests/generic", "WALKWAY"));
            sb.append(UtilText.parseFromXMLFile("places/dominion/harpyNests/generic", "WALKWAY_CORE", new ArrayList<GameCharacter>(Main.game.getNonCompanionCharactersPresent())));
            for (GameCharacter gameCharacter : Main.game.getNonCompanionCharactersPresent()) {
                sb.append(((NPC)gameCharacter).getPresentInTileDescription(false));
            }
            return sb.toString();
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1) {
                if (Main.game.getPlayer().isQuestCompleted(QuestLine.SIDE_HARPY_PACIFICATION)) {
                    return new ResponseEffectsOnly("\u6311\u4e8b", "\u867d\u7136\u4f60\u5df2\u7ecf\u5e73\u606f\u4e86\u54c8\u6bd4\u7684\u5de2\u7a74\uff0c\u4f46\u4f60\u627e\u5230\u4e00\u53ea\u60f3\u6253\u67b6\u7684\u54c8\u6bd4\u80af\u5b9a\u4e0d\u96be\u2026\u2026"){

                        @Override
                        public int getSecondsPassed() {
                            return 1800;
                        }

                        @Override
                        public void effects() {
                            DialogueNode dn = Encounter.HARPY_NEST_LOOK_FOR_TROUBLE.getRandomEncounter(true);
                            Main.game.setContent(new Response("", "", dn));
                        }
                    };
                }
                return AbstractEncounter.exploreArea("\u901a\u9053");
            }
            if (index == 2) {
                return AbstractEncounter.useOffspringMap();
            }
            return null;
        }
    };
    public static final DialogueNode WALKWAY_BRIDGE = new DialogueNode("\u6865\u8def", "", false){

        @Override
        public int getSecondsPassed() {
            return 120;
        }

        @Override
        public String getContent() {
            StringBuilder sb = new StringBuilder();
            sb.append(UtilText.parseFromXMLFile("places/dominion/harpyNests/generic", "WALKWAY_BRIDGE"));
            sb.append(UtilText.parseFromXMLFile("places/dominion/harpyNests/generic", "WALKWAY_CORE", new ArrayList<GameCharacter>(Main.game.getNonCompanionCharactersPresent())));
            for (GameCharacter gameCharacter : Main.game.getNonCompanionCharactersPresent()) {
                sb.append(((NPC)gameCharacter).getPresentInTileDescription(false));
            }
            return sb.toString();
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            return WALKWAY.getResponse(responseTab, index);
        }
    };
}

