/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.dialogue.places.dominion.lilayashome;

import com.lilithsthrone.game.character.npc.NPC;
import com.lilithsthrone.game.character.quests.Quest;
import com.lilithsthrone.game.character.quests.QuestLine;
import com.lilithsthrone.game.character.race.AbstractSubspecies;
import com.lilithsthrone.game.character.race.Race;
import com.lilithsthrone.game.character.race.Subspecies;
import com.lilithsthrone.game.combat.spells.Spell;
import com.lilithsthrone.game.dialogue.DialogueFlagValue;
import com.lilithsthrone.game.dialogue.DialogueManager;
import com.lilithsthrone.game.dialogue.DialogueNode;
import com.lilithsthrone.game.dialogue.places.dominion.lilayashome.LilayaHomeGeneric;
import com.lilithsthrone.game.dialogue.responses.Response;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.game.inventory.item.AbstractItemType;
import com.lilithsthrone.game.inventory.item.ItemType;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.rendering.RenderingEngine;
import com.lilithsthrone.world.Cell;
import com.lilithsthrone.world.WorldRegion;
import com.lilithsthrone.world.WorldType;
import com.lilithsthrone.world.places.PlaceType;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Library {
    public static final DialogueNode LIBRARY = new DialogueNode("", "", false){

        @Override
        public String getContent() {
            UtilText.nodeContentSB.setLength(0);
            List<NPC> charactersPresent = Main.game.getNonCompanionCharactersPresent();
            UtilText.nodeContentSB.append(UtilText.parseFromXMLFile("places/dominion/lilayasHome/library", "LIBRARY"));
            if (!charactersPresent.isEmpty()) {
                for (NPC slave : charactersPresent) {
                    UtilText.nodeContentSB.append(LilayaHomeGeneric.getSlavePresentDescription(slave, "\u751a\u81f3\u61d2\u5f97\u5047\u88c5[npc.sheIs]\u5728\u5de5\u4f5c\u3002", "\u4f3c\u4e4e\u5728\u5fc3\u733f\u610f\u9a6c\u5730\u91cd\u65b0\u6392\u5217\u4e66\u7c4d\u3002", "\u76ee\u524d\u6b63\u5728\u6e05\u7406\u8d27\u67b6\u4e0a\u7684\u7070\u5c18\uff0c\u786e\u4fdd\u4e00\u5207\u4e95\u7136\u6709\u5e8f\u3002", "\u76ee\u524d\u6b63\u5728\u91cd\u65b0\u6574\u7406\u5176\u4e2d\u4e00\u4e2a\u8d27\u67b6\u3002", "\u6b63\u5728\u5c3d\u804c\u5c3d\u8d23\u5730\u4e3a\u56fe\u4e66\u9986\u73b0\u6709\u7684\u6240\u6709\u4e66\u7c4d\u7f16\u5236\u76ee\u5f55\u3002"));
                }
            }
            return UtilText.nodeContentSB.toString();
        }

        @Override
        public String getResponseTabTitle(int index) {
            if (index == 0) {
                return "\u56fe\u4e66\u9986";
            }
            if (index == 1) {
                return "\u5feb\u901f\u65c5\u884c";
            }
            if (index == 2) {
                return "\u6cd5\u672f";
            }
            if (index == 3) {
                return "\u79cd\u65cf";
            }
            return null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Response getResponse(int responseTab, int index) {
            if (responseTab == 0) {
                List<NPC> charactersPresent = Main.game.getNonCompanionCharactersPresent();
                if (index == 1) {
                    if (Main.game.getCurrentDialogueNode() != ARCANE_AROUSAL) return new Response("\u5965\u672f\u72c2\u6b32", "\u4e00\u672c\u76ae\u9762\u88c5\u8ba2\u7684\u5927\u90e8\u5934\uff0c\u4f3c\u4e4e\u80fd\u8ba9\u4eba\u4e86\u89e3\u5965\u672f\u7684\u8fd0\u4f5c\u65b9\u5f0f\u3002", ARCANE_AROUSAL){

                        @Override
                        public void effects() {
                            Main.game.getDialogueFlags().setFlag(DialogueFlagValue.readBook1, true);
                        }
                    };
                    return new Response("\u5965\u672f\u72c2\u6b32", "\u4f60\u5df2\u7ecf\u5728\u8bfb\u8fd9\u672c\u4e66\u4e86\uff01", null);
                }
                if (index == 2) {
                    if (Main.game.getCurrentDialogueNode() != LILITHS_DYNASTY) return new Response("\u8389\u8389\u4e1d\u7684\u738b\u671d", "\u8389\u8389\u4e1d\uff0c\u4f55\u8bb8\u4eba\u4e5f\uff1f\u8fd9\u672c\u7cbe\u88c5\u4e66\u6216\u8bb8\u80fd\u5e26\u6211\u4eec\u4e00\u63a2\u7a76\u7adf\u3002", LILITHS_DYNASTY){

                        @Override
                        public void effects() {
                            Main.game.getDialogueFlags().setFlag(DialogueFlagValue.readBook2, true);
                        }
                    };
                    return new Response("\u8389\u8389\u4e1d\u7684\u738b\u671d", "\u4f60\u5df2\u7ecf\u5728\u8bfb\u8fd9\u672c\u4e66\u4e86\uff01", null);
                }
                if (index == 3) {
                    if (Main.game.getCurrentDialogueNode() != DOMINION_HISTORY) return new Response("\u5fa1\u57ce\u533a\u901a\u53f2", "\u4e00\u672c\u5e73\u88c5\u4e66\uff0c\u63cf\u8ff0\u4e86\u8fd9\u5ea7\u57ce\u5e02\u8bde\u751f\u4ee5\u6765\u7684\u5386\u53f2\u7eaa\u4e8b\u3002", DOMINION_HISTORY){

                        @Override
                        public void effects() {
                            Main.game.getDialogueFlags().setFlag(DialogueFlagValue.readBook3, true);
                        }
                    };
                    return new Response("\u5fa1\u57ce\u533a\u901a\u53f2", "\u4f60\u5df2\u7ecf\u5728\u8bfb\u8fd9\u672c\u4e66\u4e86\uff01", null);
                }
                if (index == 4) {
                    if (Main.game.getCurrentDialogueNode() != PREGNANCY_INFO) return new Response("\u597d\u5b55\u4e34\u95e8", "\u5c0f\u5f00\u672c\u7684\u4e66\u7c4d\uff0c\u91cc\u9762\u8bb0\u8f7d\u4e86\u5f88\u591a\u6000\u5b55\u76f8\u5173\u7684\u77e5\u8bc6\u3002", PREGNANCY_INFO){

                        @Override
                        public void effects() {
                            Main.game.getDialogueFlags().setFlag(DialogueFlagValue.readBook4, true);
                        }
                    };
                    return new Response("\u597d\u5b55\u4e34\u95e8", "\u4f60\u5df2\u7ecf\u5728\u8bfb\u8fd9\u672c\u4e66\u4e86\uff01", null);
                }
                if (index == 5) {
                    if (Main.game.getCurrentDialogueNode() != FERAL_HISTORY) return new Response("\u517d\u6001\u4eba\u7684\u5174\u4e0e\u8870", "\u4e00\u672c\u7cbe\u88c5\u4e66\uff0c\u8be6\u7ec6\u63cf\u8ff0\u4e86\u517d\u6001\u8f6c\u5316\u5728\u8389\u8389\u4e1d\u738b\u56fd\u793e\u4f1a\u4e2d\u7684\u5386\u53f2\u6545\u4e8b\u3002", FERAL_HISTORY){

                        @Override
                        public void effects() {
                            Main.game.getDialogueFlags().setFlag(DialogueFlagValue.readBook5, true);
                        }
                    };
                    return new Response("\u517d\u6001\u4eba\u7684\u5174\u4e0e\u8870", "\u4f60\u5df2\u7ecf\u5728\u8bfb\u8fd9\u672c\u4e66\u4e86\uff01", null);
                }
                if (index == 6) {
                    if (Main.game.getCurrentDialogueNode() != DOMINION_MAP) return new Response("\u57ce\u5e02\u5730\u56fe", "\u4e00\u9762\u5899\u4e0a\u6302\u7740\u4e00\u5e45\u5de8\u5927\u7684\u3001\u88c5\u88f1\u597d\u7684\u5fa1\u57ce\u533a\u5730\u56fe\u3002\u7ed9\u5b83\u62cd\u5f20\u7167\u3002", DOMINION_MAP){

                        @Override
                        public void effects() {
                            Cell[][] grid = Main.game.getWorlds().get(WorldType.DOMINION).getGrid();
                            for (int i = 0; i < grid.length; ++i) {
                                for (int j = 0; j < grid[0].length; ++j) {
                                    grid[i][j].setDiscovered(true);
                                }
                            }
                        }
                    };
                    return new Response("\u57ce\u5e02\u5730\u56fe", "\u4f60\u5df2\u7ecf\u5728\u67e5\u770b\u5fa1\u57ce\u533a\u7684\u5730\u56fe\u4e86\uff01", null);
                }
                if (index == 7 && Main.game.getPlayer().isQuestProgressGreaterThan(QuestLine.SIDE_SLAVERY, Quest.SIDE_SLAVER_NEED_RECOMMENDATION)) {
                    if (Main.game.getCurrentDialogueNode() != SLAVERY_HISTORY) return new Response("\u4ee5\u4eba\u4e3a\u4ea7", "\u4e00\u672c\u539a\u539a\u7684\u7cbe\u88c5\u4e66\uff0c\u8be6\u7ec6\u4ecb\u7ecd\u4e86\u8389\u8389\u4e1d\u738b\u56fd\u5974\u96b6\u5236\u7684\u5386\u53f2\u548c\u5408\u6cd5\u6027\u3002", SLAVERY_HISTORY){

                        @Override
                        public void effects() {
                            Main.game.appendToTextStartStringBuilder(UtilText.parseFromXMLFile("places/dominion/lilayasHome/library", "SLAVERY_HISTORY"));
                            Main.game.getDialogueFlags().setFlag(DialogueFlagValue.readBookSlavery, true);
                        }
                    };
                    return new Response("\u4ee5\u4eba\u4e3a\u4ea7", "\u4f60\u5df2\u7ecf\u5728\u8bfb\u8fd9\u672c\u4e66\u4e86\uff01", null);
                }
                if (index == 8 && Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.readBookSlavery)) {
                    if (!Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.getDialogueFlagValueFromId("acexp_dungeon_found"))) return new Response("\u8389\u83b1\u96c5\u7684\u80ae\u810f\u79d8\u5bc6", "\u4e00\u672c\u5370\u6709\u201c\u8389\u83b1\u96c5\u7684\u80ae\u810f\u79d8\u5bc6\u201d\u7684\u5927\u90e8\u5934\u5f15\u8d77\u4e86\u4f60\u7684\u6ce8\u610f\u2026\u2026", DUNGEON_TRIGGER){

                        @Override
                        public void effects() {
                            Main.game.getDialogueFlags().setFlag(DialogueFlagValue.getDialogueFlagValueFromId("acexp_dungeon_found"), true);
                        }
                    };
                    return new Response("\u8389\u83b1\u96c5\u7684\u5730\u7262", "\u62c9\u51fa\u300a\u8389\u83b1\u96c5\u7684\u80ae\u810f\u79d8\u5bc6\u300b\u8fd9\u672c\u539a\u4e66\uff0c\u6253\u5f00\u901a\u5f80\u8389\u83b1\u96c5\u5730\u7262\u7684\u79d8\u5bc6\u901a\u9053\u3002", DialogueManager.getDialogueFromId("acexp_dominion_lilaya_dungeon_stairsUp")){

                        @Override
                        public void effects() {
                            Main.game.appendToTextStartStringBuilder(UtilText.parseFromXMLFile("places/dominion/lilayasHome/library", "DUNGEON_OPENS"));
                            Main.game.appendToTextStartStringBuilder(UtilText.parseFromXMLFile("acexp/dominion/lilaya_dungeon", "DUNGEON_ENTRY"));
                            Main.game.getPlayer().setLocation(WorldType.getWorldTypeFromId("acexp_dungeon"), PlaceType.getPlaceTypeFromId("acexp_dungeon_stairs"), false);
                        }
                    };
                }
                if (index < 9 || index - 9 >= charactersPresent.size()) return null;
                NPC slave = charactersPresent.get(index - 9);
                return LilayaHomeGeneric.interactWithNPC(slave);
            }
            if (responseTab == 1) {
                return LilayaHomeGeneric.getLilayasHouseFastTravelResponses(index);
            }
            if (responseTab == 2) {
                List<Spell> spells = Main.game.getPlayer().getSpells();
                Spell spell = null;
                if (index == 0) {
                    if (spells.size() < 15) return null;
                    spell = spells.get(14);
                } else if (index < 15 && index - 1 < spells.size()) {
                    spell = spells.get(index - 1);
                } else if (index >= 15 && index < spells.size()) {
                    spell = spells.get(index);
                }
                if (spell == null) return null;
                return Library.getSpellResponse(spell);
            }
            if (responseTab != 3) return null;
            if (index == 1) {
                return new Response("\u592a\u53e4\u751f\u7269", "\u56fe\u4e66\u9986\u4e2d\u4e13\u95e8\u6536\u85cf\u6709\u5173\u6076\u9b54\u548c\u5929\u4f7f\u79cd\u65cf\u4e66\u7c4d\u7684\u533a\u57df\u3002", ELDER_RACES);
            }
            if (index == 2) {
                return new Response("\u5fa1\u57ce\u533a\u7684\u79cd\u65cf", "\u56fe\u4e66\u9986\u7684\u4e00\u90e8\u5206\u4e13\u95e8\u7528\u6765\u6536\u85cf\u4e0e\u57ce\u5e02\u4e2d\u4e3b\u8981\u79cd\u65cf\u6709\u5173\u7684\u4e66\u7c4d\u3002", DOMINION_RACES);
            }
            if (index == 3) {
                return new Response("\u5f17\u6d1b\u4f0a\u7530\u91ce", "\u56fe\u4e66\u9986\u6709\u4e00\u90e8\u5206\u4e13\u95e8\u7528\u6765\u6536\u85cf\u6709\u5173\u88ab\u79f0\u4e3a \u201c\u5f17\u6d1b\u4f0a\u7530\u91ce\u201d \u7684\u5730\u533a\u7684\u4e66\u7c4d\u3002", FIELDS_BOOKS);
            }
            if (index == 4) {
                return new Response("\u5c71\u8109", "\u56fe\u4e66\u9986\u6709\u4e00\u90e8\u5206\u4e13\u95e8\u7528\u6765\u6536\u85cf\u6709\u5173\u88ab\u79f0\u4e3a \u201c\u768e\u6708\u5c71\u8109\u201d \u5730\u533a\u7684\u4e66\u7c4d\u3002", MOUNTAIN_BOOKS);
            }
            if (index == 5) {
                return new Response("\u65e0\u5c3d\u4e4b\u6d77", "\u56fe\u4e66\u9986\u6709\u4e00\u90e8\u5206\u4e13\u95e8\u7528\u6765\u6536\u85cf\u6709\u5173 \u201c\u65e0\u5c3d\u4e4b\u6d77\u201d \u7684\u4e66\u7c4d\u3002", SEA_BOOKS);
            }
            if (index == 6) {
                return new Response("\u4e1b\u6797", "\u56fe\u4e66\u9986\u6709\u4e00\u90e8\u5206\u4e13\u95e8\u7528\u6765\u6536\u85cf\u6709\u5173\u4e1b\u6797\u5730\u533a\u7684\u4e66\u7c4d\u3002", JUNGLE_BOOKS);
            }
            if (index != 7) return null;
            return new Response("\u6c99\u6f20", "\u56fe\u4e66\u9986\u7684\u4e00\u90e8\u5206\u4e13\u95e8\u7528\u6765\u6536\u85cf\u6709\u5173\u8389\u8389\u4e1d\u738b\u56fd\u5357\u90e8\u6c99\u6f20\u7684\u4e66\u7c4d\u3002", DESERT_BOOKS);
        }
    };
    public static final DialogueNode SPELL_BOOK = new DialogueNode("", "", false){

        @Override
        public String getContent() {
            return "";
        }

        @Override
        public String getResponseTabTitle(int index) {
            return LIBRARY.getResponseTabTitle(index);
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            return LIBRARY.getResponse(responseTab, index);
        }
    };
    public static final DialogueNode ARCANE_AROUSAL = new DialogueNode("", "", false){

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("places/dominion/lilayasHome/library", "ARCANE_AROUSAL");
        }

        @Override
        public String getResponseTabTitle(int index) {
            return LIBRARY.getResponseTabTitle(index);
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            return LIBRARY.getResponse(responseTab, index);
        }
    };
    public static final DialogueNode LILITHS_DYNASTY = new DialogueNode("", "", false){

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("places/dominion/lilayasHome/library", "LILITHS_DYNASTY");
        }

        @Override
        public String getResponseTabTitle(int index) {
            return LIBRARY.getResponseTabTitle(index);
        }

        @Override
        public Response getResponse(int responseTab, int lore) {
            return LIBRARY.getResponse(responseTab, lore);
        }
    };
    public static final DialogueNode DOMINION_HISTORY = new DialogueNode("", "", false){

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("places/dominion/lilayasHome/library", "DOMINION_HISTORY");
        }

        @Override
        public String getResponseTabTitle(int index) {
            return LIBRARY.getResponseTabTitle(index);
        }

        @Override
        public Response getResponse(int responseTab, int lore) {
            return LIBRARY.getResponse(responseTab, lore);
        }
    };
    public static final DialogueNode PREGNANCY_INFO = new DialogueNode("", "", false){

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("places/dominion/lilayasHome/library", "PREGNANCY_INFO");
        }

        @Override
        public String getResponseTabTitle(int index) {
            return LIBRARY.getResponseTabTitle(index);
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            return LIBRARY.getResponse(responseTab, index);
        }
    };
    public static final DialogueNode FERAL_HISTORY = new DialogueNode("", "", false){

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("places/dominion/lilayasHome/library", "FERAL_HISTORY");
        }

        @Override
        public String getResponseTabTitle(int index) {
            return LIBRARY.getResponseTabTitle(index);
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            return LIBRARY.getResponse(responseTab, index);
        }
    };
    public static final DialogueNode DOMINION_MAP = new DialogueNode("", "", false){

        @Override
        public String getContent() {
            StringBuilder sb = new StringBuilder();
            sb.append(UtilText.parseFromXMLFile("places/dominion/lilayasHome/library", "DOMINION_MAP"));
            sb.append(RenderingEngine.ENGINE.getFullMap(WorldType.DOMINION, false, false));
            return sb.toString();
        }

        @Override
        public String getResponseTabTitle(int index) {
            return LIBRARY.getResponseTabTitle(index);
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            return LIBRARY.getResponse(responseTab, index);
        }
    };
    public static final DialogueNode SLAVERY_HISTORY = new DialogueNode("", "", false){

        @Override
        public String getContent() {
            return "";
        }

        @Override
        public String getResponseTabTitle(int index) {
            return LIBRARY.getResponseTabTitle(index);
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            return LIBRARY.getResponse(responseTab, index);
        }
    };
    public static final DialogueNode DUNGEON_TRIGGER = new DialogueNode("", "", true){

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("places/dominion/lilayasHome/library", "DUNGEON_TRIGGER");
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1) {
                return new Response("\u8389\u83b1\u96c5\u7684\u5730\u7262", "\u6cbf\u7740\u87ba\u65cb\u697c\u68af\u524d\u5f80\u8389\u83b1\u96c5\u7684\u5730\u7262\u3002", DialogueManager.getDialogueFromId("acexp_dominion_lilaya_dungeon_stairsUp")){

                    @Override
                    public void effects() {
                        Main.game.appendToTextStartStringBuilder(UtilText.parseFromXMLFile("acexp/dominion/lilaya_dungeon", "DUNGEON_ENTRY"));
                        Main.game.getPlayer().setLocation(WorldType.getWorldTypeFromId("acexp_dungeon"), PlaceType.getPlaceTypeFromId("acexp_dungeon_stairs"), false);
                    }
                };
            }
            if (index == 2) {
                return new Response("\u4ee5\u540e\u518d\u8bf4", "\u51b3\u5b9a\u6682\u65f6\u4e0d\u53bb\u8389\u83b1\u96c5\u7684\u5730\u7262\u2026\u2026", DUNGEON_TRIGGER_BACK);
            }
            return null;
        }
    };
    public static final DialogueNode DUNGEON_TRIGGER_BACK = new DialogueNode("", "", false, true){

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("places/dominion/lilayasHome/library", "DUNGEON_TRIGGER_BACK");
        }

        @Override
        public String getResponseTabTitle(int index) {
            return LIBRARY.getResponseTabTitle(index);
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            return LIBRARY.getResponse(responseTab, index);
        }
    };
    public static final DialogueNode ELDER_RACES = new DialogueNode("", "", false){

        @Override
        public String getContent() {
            return "<p>\u8d70\u8fc7\u5176\u4e2d\u4e00\u6761\u8fc7\u9053\uff0c\u4f60\u53d1\u73b0\u81ea\u5df1\u88ab\u6df1\u7d2b\u8272\u77f3\u5934\u96d5\u523b\u800c\u6210\u7684\u8d27\u67b6\u6240\u5305\u56f4\u3002\u5f53\u4f60\u7ecf\u8fc7\u65f6\uff0c\u629b\u5149\u7684\u8868\u9762\u5728\u5934\u9876\u706f\u7684\u7167\u5c04\u4e0b\u95ea\u95ea\u53d1\u5149\u3002\u5f53\u4f60\u89e6\u6478\u8fd9\u79cd\u5947\u602a\u7684\u6750\u6599\u65f6\uff0c\u6027\u5feb\u611f\u95ea\u7535\u822c\u8d2f\u7a7f\u4e86\u4f60\u7684\u8eab\u4f53\u3002\u4f60\u611f\u5230\u53c8\u60ca\u53c8\u6015\u3002</p><p>\u8fd9\u4e9b\u4e66\u770b\u8d77\u6765\u90fd\u662f\u5173\u4e8e\u6076\u9b54\u7684\u516b\u5366\u548c\u8001\u6389\u7259\u7684\u8f76\u4e8b\uff0c\u5927\u90e8\u5206\u90fd\u6ca1\u4ec0\u4e48\u770b\u5934\u3002\u4e0d\u8fc7\uff0c\u8fd8\u662f\u6709\u51e0\u672c\u52fe\u8d77\u4e86\u4f60\u7684\u5174\u8da3\u2026\u2026</p>";
        }

        @Override
        public String getResponseTabTitle(int index) {
            return LIBRARY.getResponseTabTitle(index);
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (responseTab == 3) {
                ArrayList<Response> raceResponses = new ArrayList<Response>();
                HashSet<AbstractItemType> booksAdded = new HashSet<AbstractItemType>();
                for (AbstractSubspecies subspecies : Library.getAisleSubspecies(LibraryAisle.DEMON)) {
                    if (!booksAdded.add(ItemType.getLoreBook(subspecies))) continue;
                    raceResponses.add(Library.bookResponse(ELDER_RACES, subspecies));
                }
                if (index == 0) {
                    return new Response("\u8fd4\u56de", "\u56de\u5230\u79cd\u65cf\u76ee\u5f55\u3002", LIBRARY);
                }
                if (index > 0 && index - 1 < raceResponses.size()) {
                    return (Response)raceResponses.get(index - 1);
                }
                return null;
            }
            return LIBRARY.getResponse(responseTab, index);
        }
    };
    public static final DialogueNode DOMINION_RACES = new DialogueNode("", "", false){

        @Override
        public String getContent() {
            return "<p>\u4f60\u8d70\u8fc7\u4e00\u6761\u901a\u9053\uff0c\u53d1\u73b0\u81ea\u5df1\u88ab\u4e00\u5806\u539a\u5b9e\u7684\u6728\u5934\u67b6\u5b50\u56f4\u4f4f\u4e86\uff0c\u8fd9\u4e9b\u6728\u5934\u67b6\u5b50\u662f\u88ab\u51f8\u51fa\u6765\u7684\u94a2\u94c1\u6a2a\u6881\u8fde\u5728\u4e00\u8d77\u7684\u3002\u8fd9\u513f\u5f88\u591a\u4e66\u90fd\u5728\u8bb2\u5fa1\u57ce\u533a\u7684\u5730\u65b9\u5386\u53f2\uff0c\u867d\u7136\u5bf9\u5386\u53f2\u7814\u7a76\u8005\u6765\u8bf4\u5e94\u8be5\u5f88\u6709\u8da3\uff0c\u4f46\u5bf9\u4f60\u6765\u8bf4\u5c31\u6ca1\u4ec0\u4e48\u8425\u517b\u4e86\u3002</p><p>\u4f60\u654f\u9510\u5730\u53d1\u73b0\uff0c\u6709\u51e0\u4e2a\u8d27\u67b6\u770b\u8d77\u6765\u6709\u70b9\u4e0e\u4f17\u4e0d\u540c\u3002\u6700\u4e0a\u9762\u7684\u67b6\u5b50\u4f3c\u4e4e\u662f\u7528\u6811\u679d\u88c5\u9970\u800c\u6210\uff0c\u5c31\u50cf\u9e1f\u5de2\u4e00\u6837\u3002\u6700\u9760\u8fd1\u5730\u677f\u7684\u67b6\u5b50\u8868\u9762\u975e\u5e38\u5149\u6ed1\uff0c\u5c31\u50cf\u6728\u5934\u53d8\u6210\u4e86\u77f3\u5934\u3002\u6478\u8d77\u6765\u597d\u50cf\u5f88\u6e7f\u6da6\u3002</p><p>\u867d\u7136\u8fd9\u4e9b\u4e66\u5927\u90e8\u5206\u90fd\u6ca1\u4ec0\u4e48\u53ef\u8bfb\u7684\uff0c\u4f46\u6709\u51e0\u672c\u8be6\u7ec6\u4ecb\u7ecd\u4e86\u57ce\u5e02\u91cc\u7684\u5404\u79cd\u65cf\u7fa4\uff0c\u4f60\u8003\u8651\u662f\u4e0d\u662f\u5e94\u8be5\u8bfb\u4e00\u8bfb\u8fd9\u51e0\u672c\u2026\u2026</p>";
        }

        @Override
        public String getResponseTabTitle(int index) {
            return LIBRARY.getResponseTabTitle(index);
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (responseTab == 3) {
                ArrayList<Response> raceResponses = new ArrayList<Response>();
                HashSet<AbstractItemType> booksAdded = new HashSet<AbstractItemType>();
                for (AbstractSubspecies subspecies : Library.getAisleSubspecies(LibraryAisle.DOMINION)) {
                    if (!booksAdded.add(ItemType.getLoreBook(subspecies))) continue;
                    raceResponses.add(Library.bookResponse(DOMINION_RACES, subspecies));
                }
                if (index == 0) {
                    return new Response("\u8fd4\u56de", "\u56de\u5230\u79cd\u65cf\u76ee\u5f55\u3002", LIBRARY);
                }
                if (index > 0 && index - 1 < raceResponses.size()) {
                    return (Response)raceResponses.get(index - 1);
                }
                return null;
            }
            return LIBRARY.getResponse(responseTab, index);
        }
    };
    public static final DialogueNode FIELDS_BOOKS = new DialogueNode("", "", false){

        @Override
        public String getContent() {
            return "<p>\u4f60\u6f2b\u6b65\u5728\u56fe\u4e66\u9986\u8d70\u5eca\uff0c\u53d1\u73b0\u8fd9\u513f\u7a7a\u6c14\u6bd4\u5e73\u65f6\u6e05\u65b0\u591a\u4e86\u3002\u4f60\u5fc3\u60f3\uff0c\u8fd9\u5927\u6982\u662f\u4e00\u79cd\u5965\u672f\u9644\u9b54\u3002\u4e8e\u662f\u4f60\u5f00\u59cb\u89c2\u5bdf\u56db\u5468\u7684\u4e66\u67b6\uff0c\u60f3\u627e\u5230\u86db\u4e1d\u9a6c\u8ff9\u3002</p><p>\u4e4d\u4e00\u770b\uff0c\u5b83\u4eec\u4f3c\u4e4e\u662f\u7528\u8349\u76ae\u5757\u5236\u4f5c\u7684\uff0c\u4f46\u4ed4\u7ec6\u4e00\u770b\uff0c\u5c31\u4f1a\u53d1\u73b0\u5b83\u4eec\u5176\u5b9e\u662f\u7ecf\u8fc7\u5de7\u5999\u96d5\u523b\u7684\u6728\u5757\u3002\u6709\u4e2a\u67b6\u5b50\u4e0a\u7684\u8349\u76ae\u50cf\u662f\u88ab\u96ea\u8986\u76d6\u4e86\uff0c\u8fd8\u80fd\u611f\u5230\u5b83\u6563\u53d1\u51fa\u4e1d\u4e1d\u5bd2\u6c14\u3002\u679c\u4e0d\u5176\u7136\uff0c\u8fd9\u513f\u7684\u4e66\u7c4d\u90fd\u662f\u548c\u5f17\u6d1b\u4f0a\u7530\u91ce\u4ee5\u53ca\u751f\u6d3b\u5728\u90a3\u91cc\u7684\u79cd\u65cf\u6709\u5173\u3002\u8fd9\u4e00\u533a\u57df\u7684\u7530\u56ed\u6c14\u8d28\u4e5f\u662f\u56e0\u6b64\u914d\u7f6e\u7684\u5427\u3002</p>";
        }

        @Override
        public String getResponseTabTitle(int index) {
            return LIBRARY.getResponseTabTitle(index);
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (responseTab == 3) {
                ArrayList<Response> raceResponses = new ArrayList<Response>();
                HashSet<AbstractItemType> booksAdded = new HashSet<AbstractItemType>();
                for (AbstractSubspecies subspecies : Library.getAisleSubspecies(LibraryAisle.FIELDS)) {
                    if (!booksAdded.add(ItemType.getLoreBook(subspecies))) continue;
                    raceResponses.add(Library.bookResponse(FIELDS_BOOKS, subspecies));
                }
                if (index == 0) {
                    return new Response("\u8fd4\u56de", "\u56de\u5230\u79cd\u65cf\u76ee\u5f55\u3002", LIBRARY);
                }
                if (index > 0 && index - 1 < raceResponses.size()) {
                    return (Response)raceResponses.get(index - 1);
                }
                return null;
            }
            return LIBRARY.getResponse(responseTab, index);
        }
    };
    public static final DialogueNode JUNGLE_BOOKS = new DialogueNode("", "", false){

        @Override
        public String getContent() {
            return "<p>\u4f60\u53d1\u73b0\u81ea\u5df1[pc.walking]\u8fc7\u7684\u901a\u9053\u88ab\u65bd\u52a0\u4e86\u5965\u672f\u9644\u9b54\uff0c\u5f25\u6f2b\u7740\u95f7\u70ed\u6f6e\u6e7f\u7684\u6c14\u6c1b\u3002\u4e24\u8fb9\u7684\u67b6\u5b50\u662f\u7531\u5de8\u5927\u7684\u3001\u6709\u751f\u547d\u7684\u6df1\u8272\u6728\u5757\u62fc\u63a5\u800c\u6210\u7684\uff0c\u8868\u9762\u8fd8\u4e0d\u65f6\u957f\u51fa\u4e00\u4e9b\u5c0f\u5de7\u7684\u70ed\u5e26\u690d\u7269\u3002</p><p>\u518d\u6b21\u611f\u8c22\u5947\u5999\u7684\u6cd5\u672f\uff0c\u8fd9\u6837\u7684\u73af\u5883\u4e5f\u5e76\u6ca1\u6709\u635f\u574f\u9648\u5217\u7684\u8bb8\u591a\u4e66\u7c4d\u3002\u4f60\u5306\u5306\u626b\u4e86\u51e0\u773c\uff0c\u53d1\u73b0\u5b83\u4eec\u90fd\u662f\u4e1b\u6797\u4e3b\u9898\u7684\u3002\u8d70\u5230\u8fc7\u9053\u4e2d\u9014\uff0c\u4f60\u770b\u89c1\u4e00\u4e9b\u8bb0\u8f7d\u4e86\u5317\u65b9\u4e1b\u6797\u79cd\u65cf\u7684\u4e66\uff0c\u8981\u4e0d\u8981\u7a0d\u5fae\u505c\u4e0b\u6765\u8bfb\u4e00\u8bfb\u5462\u2026\u2026</p>";
        }

        @Override
        public String getResponseTabTitle(int index) {
            return LIBRARY.getResponseTabTitle(index);
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (responseTab == 3) {
                ArrayList<Response> raceResponses = new ArrayList<Response>();
                HashSet<AbstractItemType> booksAdded = new HashSet<AbstractItemType>();
                for (AbstractSubspecies subspecies : Library.getAisleSubspecies(LibraryAisle.JUNGLE)) {
                    if (!booksAdded.add(ItemType.getLoreBook(subspecies))) continue;
                    raceResponses.add(Library.bookResponse(JUNGLE_BOOKS, subspecies));
                }
                if (index == 0) {
                    return new Response("\u8fd4\u56de", "\u56de\u5230\u79cd\u65cf\u76ee\u5f55\u3002", LIBRARY);
                }
                if (index > 0 && index - 1 < raceResponses.size()) {
                    return (Response)raceResponses.get(index - 1);
                }
                return null;
            }
            return LIBRARY.getResponse(responseTab, index);
        }
    };
    public static final DialogueNode MOUNTAIN_BOOKS = new DialogueNode("", "", false){

        @Override
        public String getContent() {
            return "<p>\u4f60[pc.Walking]\u5728\u8389\u83b1\u96c5\u56fe\u4e66\u9986\u7684\u4f17\u591a\u8fc7\u9053\u4e2d\uff0c\u5ffd\u7136\u611f\u89c9\u6c27\u6c14\u53d8\u5f97\u7a00\u8584\uff0c\u7a7a\u6c14\u4e5f\u5f00\u59cb\u53d1\u5e72\u53d1\u51b7\u3002\u4f60\u76f8\u4fe1\u8fd9\u662f\u67d0\u79cd\u5965\u672f\u9644\u9b54\u7684\u5f71\u54cd\uff0c\u4e8e\u662f\u73af\u987e\u4e86\u4e00\u4e0b\u4e24\u8fb9\u7684\u4e66\u67b6\uff0c\u53d1\u73b0\u5b83\u4eec\u90fd\u662f\u4ece\u7c97\u91ce\u7684\u5ca9\u77f3\u91cc\u51ff\u51fa\u7684\u3002\u4e66\u67b6\u4e0a\u6446\u653e\u7684\u4e66\u7c4d\u4f3c\u4e4e\u90fd\u4e0e\u5c71\u533a\u6709\u5173\u3002\u8fd9\u4e9b\u5965\u672f\u9644\u9b54\u4e00\u5b9a\u662f\u5728\u52aa\u529b\u6e32\u67d3\u9ad8\u6d77\u62d4\u7684\u6c14\u6c1b\u3002</p><p>\u624b\u8fb9\u7684\u4e66\u7c4d\u63cf\u5199\u4e86\u8bb8\u591a\u5c45\u4f4f\u5728\u768e\u6708\u5c71\u8109\u7684\u79cd\u65cf\uff0c\u8981\u4e0d\u8981\u7a0d\u5fae\u505c\u4e0b\u6765\u8bfb\u4e00\u8bfb\u5462\u2026\u2026</p>";
        }

        @Override
        public String getResponseTabTitle(int index) {
            return LIBRARY.getResponseTabTitle(index);
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (responseTab == 3) {
                ArrayList<Response> raceResponses = new ArrayList<Response>();
                HashSet<AbstractItemType> booksAdded = new HashSet<AbstractItemType>();
                for (AbstractSubspecies subspecies : Library.getAisleSubspecies(LibraryAisle.MOUNTAIN)) {
                    if (!booksAdded.add(ItemType.getLoreBook(subspecies))) continue;
                    raceResponses.add(Library.bookResponse(MOUNTAIN_BOOKS, subspecies));
                }
                if (index == 0) {
                    return new Response("\u8fd4\u56de", "\u56de\u5230\u79cd\u65cf\u76ee\u5f55\u3002", LIBRARY);
                }
                if (index > 0 && index - 1 < raceResponses.size()) {
                    return (Response)raceResponses.get(index - 1);
                }
                return null;
            }
            return LIBRARY.getResponse(responseTab, index);
        }
    };
    public static final DialogueNode SEA_BOOKS = new DialogueNode("", "", false){

        @Override
        public String getContent() {
            return "<p>\u4f60[pc.walk]\u5728\u8389\u83b1\u96c5\u56fe\u4e66\u9986\u4f17\u591a\u4e66\u7c4d\u4e2d\u7684\u4e00\u6761\u8fc7\u9053\u4e0a\uff0c\u9690\u9690\u7ea6\u7ea6\u542c\u5230\u62cd\u6253\u6d77\u5cb8\u7684\u6d6a\u6f6e\u58f0\u3002\u547c\u5438\u7740\u6c81\u4eba\u5fc3\u813e\u7684\u54b8\u54b8\u6d77\u5473\uff0c\u4f60\u77e5\u9053\u8fd9\u662f\u5965\u672f\u53d1\u6325\u7684\u6548\u679c\u3002\u4e66\u67b6\u4e0a\u6446\u653e\u7740\u770b\u4f3c\u6d3b\u73ca\u745a\u548c\u6f02\u6d41\u6728\u7684\u7269\u54c1\uff0c\u4f60\u53ef\u4ee5\u6839\u636e\u8fd9\u4e9b\u7ebf\u7d22\u63a8\u65ad\u51fa\u8fd9\u4e2a\u8fc7\u9053\u662f\u4e13\u95e8\u7528\u6765\u6446\u653e\u6709\u5173\u6d77\u6d0b\u4e3b\u9898\u7684\u4e66\u7c4d\u7684\u3002</p><p>\u4f60\u505c\u4e0b\u811a\u6b65\uff0c\u4ed4\u7ec6\u89c2\u5bdf\u4e86\u67b6\u4e0a\u7684\u4e66\u810a\uff0c\u53d1\u73b0\u6709\u51e0\u672c\u548c\u65e0\u5c3d\u4e4b\u6d77\u7684\u4f17\u591a\u79cd\u65cf\u6709\u5173\uff0c\u4f60\u5728\u8003\u8651\u8981\u4e0d\u8981\u82b1\u70b9\u65f6\u95f4\u7a0d\u5fae\u8bfb\u8bfb\u2026\u2026</p>";
        }

        @Override
        public String getResponseTabTitle(int index) {
            return LIBRARY.getResponseTabTitle(index);
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (responseTab == 3) {
                ArrayList<Response> raceResponses = new ArrayList<Response>();
                HashSet<AbstractItemType> booksAdded = new HashSet<AbstractItemType>();
                for (AbstractSubspecies subspecies : Library.getAisleSubspecies(LibraryAisle.SEA)) {
                    if (!booksAdded.add(ItemType.getLoreBook(subspecies))) continue;
                    raceResponses.add(Library.bookResponse(SEA_BOOKS, subspecies));
                }
                if (index == 0) {
                    return new Response("\u8fd4\u56de", "\u56de\u5230\u79cd\u65cf\u76ee\u5f55\u3002", LIBRARY);
                }
                if (index > 0 && index - 1 < raceResponses.size()) {
                    return (Response)raceResponses.get(index - 1);
                }
                return null;
            }
            return LIBRARY.getResponse(responseTab, index);
        }
    };
    public static final DialogueNode DESERT_BOOKS = new DialogueNode("", "", false){

        @Override
        public String getContent() {
            return "<p>[pc.Walking]\u5728\u56fe\u4e66\u9986\u7684\u8fc7\u9053\u4e0a\uff0c\u4f60\u4e0d\u7981\u89c9\u5f97\uff0c\u6bd4\u8d77\u5f80\u5e38\uff0c\u8fd9\u513f\u7684\u7a7a\u6c14\u672a\u514d\u4e5f\u592a\u5e72\u592a\u70ed\u4e86\u3002\u8fd9\u597d\u50cf\u662f\u4e3a\u4e86\u914d\u5408\u4e66\u67b6\u4e3b\u9898\u800c\u65bd\u653e\u7684\u5965\u672f\u6cd5\u672f\u3002\u56e0\u4e3a\u67b6\u4e0a\u8fd9\u4e9b\u4e66\u548c\u8389\u8389\u4e1d\u738b\u56fd\u7684\u5357\u90e8\u6c99\u6f20\u6709\u5173\u3002\u4e66\u67b6\u672c\u8eab\u4e5f\u4e0e\u8fd9\u4e00\u4e3b\u9898\u76f8\u543b\u5408\uff0c\u7531\u539a\u539a\u7684\u5927\u7406\u77f3\u5757\u780c\u6210\uff0c\u8868\u9762\u523b\u6709\u5947\u7279\u7684\u8c61\u5f62\u6587\u5b57\u3002</p><p>\u5728\u8fc7\u9053\u4e2d\u9014\u505c\u4e0b\uff0c\u4f60\u968f\u610f\u6311\u4e86\u51e0\u672c\u4e66\u6765\u7ffb\u770b\uff0c\u53d1\u73b0\u5b83\u4eec\u4e0e\u6c99\u6f20\u4e2d\u53d1\u73b0\u7684\u79cd\u65cf\u6709\u5173\u3002\u4f60\u4e0d\u786e\u5b9a\u5b83\u4eec\u5bf9\u4f60\u6709\u6ca1\u6709\u7528\uff0c\u51b3\u5b9a\u7a0d\u7a0d\u9a7b\u8db3\uff0c\u628a\u5b83\u4eec\u901a\u8bfb\u4e00\u904d\u2026\u2026</p>";
        }

        @Override
        public String getResponseTabTitle(int index) {
            return LIBRARY.getResponseTabTitle(index);
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (responseTab == 3) {
                ArrayList<Response> raceResponses = new ArrayList<Response>();
                HashSet<AbstractItemType> booksAdded = new HashSet<AbstractItemType>();
                for (AbstractSubspecies subspecies : Library.getAisleSubspecies(LibraryAisle.DESERT)) {
                    if (!booksAdded.add(ItemType.getLoreBook(subspecies))) continue;
                    raceResponses.add(Library.bookResponse(DESERT_BOOKS, subspecies));
                }
                if (index == 0) {
                    return new Response("\u8fd4\u56de", "\u56de\u5230\u79cd\u65cf\u76ee\u5f55\u3002", LIBRARY);
                }
                if (index > 0 && index - 1 < raceResponses.size()) {
                    return (Response)raceResponses.get(index - 1);
                }
                return null;
            }
            return LIBRARY.getResponse(responseTab, index);
        }
    };

    private static Set<AbstractSubspecies> getAisleSubspecies(LibraryAisle aisle) {
        HashSet<AbstractSubspecies> aisleSubspecies = new HashSet<AbstractSubspecies>();
        for (AbstractSubspecies subspecies : Subspecies.getAllSubspecies()) {
            List<WorldRegion> mostCommonRegion = subspecies.getMostCommonWorldRegions();
            if (mostCommonRegion.isEmpty()) {
                mostCommonRegion.add(WorldRegion.DOMINION);
            }
            boolean add = false;
            boolean demonic = subspecies.getRace() == Race.DEMON || subspecies.getRace() == Race.ANGEL || subspecies.getRace() == Race.ELEMENTAL;
            switch (aisle) {
                case DEMON: {
                    add = demonic;
                    break;
                }
                case DESERT: {
                    add = !demonic && (mostCommonRegion.contains((Object)WorldRegion.SAVANNAH) || mostCommonRegion.contains((Object)WorldRegion.DESERT) || mostCommonRegion.contains((Object)WorldRegion.DESERT_CITY) || mostCommonRegion.contains((Object)WorldRegion.VOLCANO));
                    break;
                }
                case DOMINION: {
                    add = !demonic && (mostCommonRegion.contains((Object)WorldRegion.DOMINION) || mostCommonRegion.contains((Object)WorldRegion.SUBMISSION));
                    break;
                }
                case FIELDS: {
                    add = !demonic && (mostCommonRegion.contains((Object)WorldRegion.WOODLAND) || mostCommonRegion.contains((Object)WorldRegion.FIELDS) || mostCommonRegion.contains((Object)WorldRegion.FIELD_CITY) || mostCommonRegion.contains((Object)WorldRegion.RIVER));
                    break;
                }
                case JUNGLE: {
                    add = !demonic && (mostCommonRegion.contains((Object)WorldRegion.JUNGLE) || mostCommonRegion.contains((Object)WorldRegion.JUNGLE_CITY));
                    break;
                }
                case MOUNTAIN: {
                    add = !demonic && (mostCommonRegion.contains((Object)WorldRegion.MOUNTAINS) || mostCommonRegion.contains((Object)WorldRegion.YOUKO_FOREST) || mostCommonRegion.contains((Object)WorldRegion.SNOW));
                    break;
                }
                case SEA: {
                    boolean bl = add = !demonic && (mostCommonRegion.contains((Object)WorldRegion.SEA) || mostCommonRegion.contains((Object)WorldRegion.SEA_CITY));
                }
            }
            if (!add) continue;
            aisleSubspecies.add(subspecies);
        }
        return aisleSubspecies;
    }

    private static Response getSpellResponse(final Spell spell) {
        return new Response(spell.getName(), "\u9605\u8bfb\u4e86\u89e3\u6cd5\u672f'" + spell.getName() + "'\u3002", SPELL_BOOK){

            @Override
            public void effects() {
                Main.game.getTextEndStringBuilder().append(ItemType.getSpellBookType(spell).getEffects().get(0).applyEffect(Main.game.getPlayer(), Main.game.getPlayer(), 0));
            }
        };
    }

    private static Response bookResponse(DialogueNode nodeToReturnTo, AbstractSubspecies subspecies) {
        final AbstractItemType book = ItemType.getLoreBook(subspecies);
        if (Main.getProperties().isAdvancedRaceKnowledgeDiscovered(subspecies)) {
            return new Response(book.getName(false), book.getDescription(), nodeToReturnTo){

                @Override
                public void effects() {
                    Main.game.getTextEndStringBuilder().append(book.getEffects().get(0).applyEffect(Main.game.getPlayer(), Main.game.getPlayer(), 1));
                }
            };
        }
        return new Response(book.getName(false), "\u4f60\u8fd8\u6ca1\u53d1\u73b0\u8fd9\u672c\u4e66\u5462\uff01", null);
    }

    private static enum LibraryAisle {
        DEMON,
        DOMINION,
        FIELDS,
        JUNGLE,
        MOUNTAIN,
        SEA,
        DESERT;

    }
}

