/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.dialogue.places.dominion.lilayashome;

import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.npc.NPC;
import com.lilithsthrone.game.dialogue.DialogueNode;
import com.lilithsthrone.game.dialogue.companions.CompanionManagement;
import com.lilithsthrone.game.dialogue.companions.OccupantManagementDialogue;
import com.lilithsthrone.game.dialogue.places.dominion.lilayashome.LilayaHomeGeneric;
import com.lilithsthrone.game.dialogue.responses.Response;
import com.lilithsthrone.game.dialogue.utils.ParserTag;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.world.places.AbstractPlaceUpgrade;
import com.lilithsthrone.world.places.PlaceUpgrade;
import java.util.ArrayList;
import java.util.List;

public class LilayaOfficeDialogue {
    public static final DialogueNode ROOM_OFFICE = new DialogueNode("\u623f\u95f4", "", false){

        @Override
        public int getSecondsPassed() {
            return 10;
        }

        @Override
        public String getLabel() {
            return Main.game.getPlayer().getLocationPlace().getName();
        }

        @Override
        public String getContent() {
            StringBuilder sb = new StringBuilder();
            sb.append(LilayaHomeGeneric.getBaseRoomDescription());
            sb.append("<p><b style='color:" + PlaceUpgrade.LILAYA_OFFICE.getColour().toWebHexString() + ";'>" + PlaceUpgrade.LILAYA_OFFICE.getName() + "</b><br/>" + PlaceUpgrade.LILAYA_OFFICE.getRoomDescription(Main.game.getPlayerCell()) + "</p>");
            for (AbstractPlaceUpgrade up : Main.game.getPlayerCell().getPlace().getPlaceUpgrades()) {
                if (up.isCoreRoomUpgrade()) continue;
                sb.append("<p><b style='color:" + up.getColour().toWebHexString() + ";'>" + up.getName() + "</b><br/>" + up.getRoomDescription(Main.game.getPlayerCell()) + "</p>");
            }
            return sb.toString();
        }

        @Override
        public String getResponseTabTitle(int index) {
            return LilayaHomeGeneric.getLilayasHouseStandardResponseTabs(index);
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (responseTab == 1) {
                return LilayaHomeGeneric.getLilayasHouseFastTravelResponses(index);
            }
            List<NPC> charactersPresent = LilayaHomeGeneric.getSlavesAndOccupantsPresent();
            ArrayList<NPC> slavesAssignedToRoom = new ArrayList<NPC>();
            slavesAssignedToRoom.addAll(charactersPresent);
            if (index == 0) {
                return null;
            }
            if (index == 1) {
                if (Main.game.getPlayer().isAbleToAccessRoomManagement()) {
                    return new Response("\u7ba1\u7406\u623f\u95f4", "\u8fdb\u5165\u8be5\u623f\u95f4\u7684\u7ba1\u7406\u754c\u9762\u3002", OccupantManagementDialogue.ROOM_UPGRADES){

                        @Override
                        public void effects() {
                            OccupantManagementDialogue.cellToInspect = Main.game.getPlayerCell();
                        }
                    };
                }
                return new Response("\u7ba1\u7406\u623f\u95f4", "\u5728\u8fdb\u5165\u8be5\u754c\u9762\u524d\uff0c\u4f60\u9700\u8981\u83b7\u5f97\u8d29\u5974\u8bb8\u53ef\uff1b\u8389\u83b1\u96c5\u8981\u662f\u5141\u8bb8\u4f60\u5e26\u4eba\u6216\u73a9\u5076\u4f4f\u4e0b\u7684\u8bdd\u90a3\u4e5f\u884c\u3002", null);
            }
            if (index == 2) {
                if (Main.game.getPlayer().isAbleToAccessRoomManagement()) {
                    return new Response("\u4eba\u5458\u7ba1\u7406", "\u8fdb\u5165\u5974\u96b6\u548c\u53cb\u4eba\u4f4f\u5ba2\u7684\u7ba1\u7406\u754c\u9762\u3002", OccupantManagementDialogue.getSlaveryRoomListDialogue(null, null)){

                        @Override
                        public void effects() {
                            CompanionManagement.initManagement(Main.game.getDefaultDialogue(), 0, null);
                        }
                    };
                }
                return new Response("\u7ba1\u7406\u4eba\u5458", "\u5728\u8fdb\u5165\u8be5\u754c\u9762\u524d\uff0c\u4f60\u9700\u8981\u83b7\u5f97\u8d29\u5974\u8bb8\u53ef\uff1b\u8389\u83b1\u96c5\u8981\u662f\u5141\u8bb8\u4f60\u5e26\u4eba\u6216\u73a9\u5076\u4f4f\u4e0b\u7684\u8bdd\u90a3\u4e5f\u884c\u3002", null);
            }
            if (index == 3) {
                return new Response("\u4f4f\u6237\u540d\u5355", "\u6253\u5f00\u4f4f\u6237\u540d\u5355\u754c\u9762\uff0c\u53ef\u4ee5\u7ba1\u7406\u6240\u6709\u623f\u95f4\u3001\u5974\u96b6\u548c\u53cb\u5584\u7684\u4f4f\u6237\u3002", OccupantManagementDialogue.getSlaveryOverviewDialogue(null)){

                    @Override
                    public void effects() {
                        CompanionManagement.initManagement(Main.game.getDefaultDialogue(), 0, null);
                    }
                };
            }
            int indexPresentStart = 4;
            if (index - indexPresentStart < slavesAssignedToRoom.size()) {
                NPC character = (NPC)slavesAssignedToRoom.get(index - indexPresentStart);
                if (charactersPresent.contains(character) || character.getHomeCell().equals(Main.game.getPlayerCell()) && Main.game.getPlayer().getCompanions().contains(character)) {
                    return LilayaHomeGeneric.interactWithNPC(character);
                }
                return new Response(UtilText.parse((GameCharacter)character, "[npc.Name]", new ParserTag[0]), UtilText.parse((GameCharacter)character, "\u867d\u7136\u8fd9\u91cc\u662f[npc.namePos]\u7684\u623f\u95f4\uff0c\u4f46[npc.sheIs]" + (character.getLocationPlace().getPlaceUpgrades().contains(PlaceUpgrade.LILAYA_SLAVE_LOUNGE) ? "\u73b0\u5728\u6b63\u5728\u5974\u96b6\u4f11\u606f\u5ba4\u4f11\u606f\u3002" : "\u73b0\u5728\u6b63\u5728\u5916\u9762\u5de5\u4f5c\u3002"), new ParserTag[0]), null);
            }
            return null;
        }
    };
}

