/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.dialogue.places.dominion.lilayashome;

import com.lilithsthrone.game.character.npc.dominion.Arthur;
import com.lilithsthrone.game.character.npc.dominion.Lilaya;
import com.lilithsthrone.game.character.npc.dominion.Rose;
import com.lilithsthrone.game.character.quests.Quest;
import com.lilithsthrone.game.character.quests.QuestLine;
import com.lilithsthrone.game.combat.spells.Spell;
import com.lilithsthrone.game.dialogue.DialogueNode;
import com.lilithsthrone.game.dialogue.places.dominion.lilayashome.LilayaHomeGeneric;
import com.lilithsthrone.game.dialogue.responses.Response;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.game.inventory.item.ItemType;
import com.lilithsthrone.game.inventory.weapon.WeaponType;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.utils.Util;
import com.lilithsthrone.utils.colours.Colour;
import com.lilithsthrone.utils.colours.PresetColour;
import com.lilithsthrone.world.WorldType;
import com.lilithsthrone.world.places.PlaceType;
import java.util.ArrayList;

public class RoomArthur {
    public static final DialogueNode ROOM_ARTHUR_INSTALLATION = new DialogueNode("\u4e9a\u745f\u7684\u623f\u95f4", "", true){

        @Override
        public int getSecondsPassed() {
            return 1800;
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("places/dominion/lilayasHome/arthursRoom", "ROOM_ARTHUR_INSTALLATION");
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1) {
                return new Response("\u5bfb\u627e\u8389\u897f\u4e1d", "\u5982\u679c\u4f60\u60f3\u5f04\u660e\u767d\u6765\u9f99\u53bb\u8109\uff0c\u6700\u597d\u8fd8\u662f\u540c\u610f\u5e2e\u5fd9\u3002", ROOM_ARTHUR_INSTALLATION_AGREE_TO_CONVINCE_LYSSIETH){

                    @Override
                    public void effects() {
                        Main.game.getTextEndStringBuilder().append(Main.game.getPlayer().setQuestProgress(QuestLine.MAIN, Quest.MAIN_2_A_INTO_THE_DEPTHS));
                    }
                };
            }
            return null;
        }
    };
    public static final DialogueNode ROOM_ARTHUR_INSTALLATION_AGREE_TO_CONVINCE_LYSSIETH = new DialogueNode("\u4e9a\u745f\u7684\u623f\u95f4", "", true){

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("places/dominion/lilayasHome/arthursRoom", "ROOM_ARTHUR_INSTALLATION_AGREE_TO_CONVINCE_LYSSIETH");
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1) {
                return new Response("\u7ee7\u7eed", "\u8ba9\u4e9a\u745f\u7ee7\u7eed\u5b9e\u9a8c\u3002", ROOM_ARTHUR);
            }
            return null;
        }
    };
    public static final DialogueNode ROOM_ARTHUR = new DialogueNode("", "", false){

        @Override
        public int getSecondsPassed() {
            return 30;
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("places/dominion/lilayasHome/arthursRoom", "ROOM_ARTHUR");
        }

        @Override
        public String getResponseTabTitle(int index) {
            return LilayaHomeGeneric.getLilayasHouseStandardResponseTabs(index);
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (responseTab == 1) {
                return LilayaHomeGeneric.getLilayasHouseFastTravelResponses(index);
            }
            if (index == 1) {
                return new Response("\u8389\u897f\u4e1d", "\u8be2\u95ee\u4e9a\u745f\u8389\u83b1\u96c5\u7684\u6bcd\u4eb2\u2014\u2014\u8389\u897f\u4e1d\u7684\u4e8b\u60c5\u3002", ROOM_ARTHUR_LYSSIETH);
            }
            if (index == 2) {
                return new Response("\u8389\u83b1\u96c5", "\u8be2\u95ee\u4e9a\u745f\u4ed6\u4e4b\u524d\u8ddf\u8389\u83b1\u96c5\u662f\u4ec0\u4e48\u5173\u7cfb\u3002", ROOM_ARTHUR_LILAYA);
            }
            ArrayList<Response> additionalResponses = new ArrayList<Response>();
            if (!Main.game.getPlayer().isQuestCompleted(QuestLine.SIDE_HYPNO_WATCH)) {
                if (!Main.game.getPlayer().hasQuest(QuestLine.SIDE_HYPNO_WATCH)) {
                    additionalResponses.add(new Response("\u5b9e\u9a8c", "\u8be2\u95ee\u4e9a\u745f\u4ed6\u6b63\u5728\u8fdb\u884c\u4ec0\u4e48\u5b9e\u9a8c\u3002", ROOM_ARTHUR_HYPNO_WATCH_START){

                        @Override
                        public void effects() {
                            Main.game.getTextEndStringBuilder().append(Main.game.getPlayer().startQuest(QuestLine.SIDE_HYPNO_WATCH));
                        }

                        @Override
                        public Colour getHighlightColour() {
                            return PresetColour.QUEST_SIDE;
                        }
                    });
                } else if (Main.game.getPlayer().getQuest(QuestLine.SIDE_HYPNO_WATCH) == Quest.SIDE_HYPNO_WATCH_VICKY) {
                    if (!Main.game.getPlayer().hasItem(Main.game.getItemGen().generateItem(ItemType.ARTHURS_PACKAGE))) {
                        additionalResponses.add(new Response("\u9012\u4ea4\u5305\u88f9", "\u4f60\u9700\u8981\u5148\u4ece\u201c\u5965\u672f\u827a\u672f\u201d\u62ff\u5230\u5305\u88f9\uff01", null));
                    } else {
                        additionalResponses.add(new Response("\u9012\u4ea4\u5305\u88f9", "\u5c06\u4f60\u4ece\u201c\u5965\u672f\u827a\u672f\u201d\u62ff\u5230\u7684\u5305\u88f9\u4ea4\u51fa\u53bb\u3002", ROOM_ARTHUR_HYPNO_WATCH_DELIVERY){

                            @Override
                            public void effects() {
                                Main.game.getPlayer().removeItem(Main.game.getItemGen().generateItem(ItemType.ARTHURS_PACKAGE));
                                Main.game.getTextEndStringBuilder().append(Main.game.getPlayer().setQuestProgress(QuestLine.SIDE_HYPNO_WATCH, Quest.SIDE_HYPNO_WATCH_TEST_SUBJECT));
                                Main.game.getNpc(Lilaya.class).setLocation(Main.game.getPlayer().getWorldLocation(), Main.game.getPlayer().getLocation(), false);
                            }
                        });
                    }
                }
            }
            if (!Main.game.getPlayer().isQuestCompleted(QuestLine.SIDE_ARCANE_LIGHTNING)) {
                if (!Main.game.getPlayer().hasQuest(QuestLine.SIDE_ARCANE_LIGHTNING) && Main.game.getPlayer().hasWeaponType(WeaponType.getWeaponTypeFromId("innoxia_lightningGlobe_lightning_globe"), true)) {
                    additionalResponses.add(new Response("\u53d1\u51fa\u95ea\u7535\u7684\u7403\u4f53", "\u5c06\u90a3\u4e2a\u4ece\u6267\u6cd5\u8005\u4ed3\u5e93\u627e\u5230\u7684\u53d1\u51fa\u95ea\u7535\u7684\u7403\u4f53\u7ed9\u4e9a\u745f\u77a7\u77a7\uff0c\u95ee\u95ee\u4ed6\u80fd\u4e0d\u80fd\u89e3\u5f00\u5176\u4e2d\u529b\u91cf\u7684\u79d8\u5bc6\u3002", ROOM_ARTHUR_ARCANE_LIGHTNING_START){

                        @Override
                        public void effects() {
                            Main.game.getTextEndStringBuilder().append(Main.game.getPlayer().startQuest(QuestLine.SIDE_ARCANE_LIGHTNING));
                        }

                        @Override
                        public Colour getHighlightColour() {
                            return PresetColour.QUEST_SIDE;
                        }
                    });
                } else if (Main.game.getPlayer().getQuest(QuestLine.SIDE_ARCANE_LIGHTNING) == Quest.LIGHTNING_SPELL_1_PAYMENT) {
                    if (Main.game.getPlayer().getEssenceCount() < 500) {
                        additionalResponses.add(new Response("\u7ed9\u51fa\u7403\u4f53", "\u4f60\u81f3\u5c11\u9700\u8981\u5728\u7075\u6c14\u4e2d\u5438\u6536500\u7cbe\u534e\u624d\u80fd\u7ee7\u7eed\uff01", null));
                    } else {
                        additionalResponses.add(new Response("\u7ed9\u51fa\u7403\u4f53", "\u5c06\u5965\u672f\u95ea\u7535\u7403\u4ea4\u7ed9\u4e9a\u745f\uff0c\u5e76\u4e14\u5141\u8bb8\u4ed6\u4ece\u4f60\u7684\u7075\u6c14\u4e2d\u63d0\u53d6\u7cbe\u534e\u7528\u4ee5\u89e3\u9501\u5176\u79d8\u5bc6\u3002<br/>[style.italicsMinorBad(\u4f60\u5c06\u4f1a\u5931\u53bb500\u7cbe\u534e\uff01)]", ROOM_ARTHUR_ARCANE_LIGHTNING_PAYMENT));
                    }
                } else if (Main.game.getPlayer().getQuest(QuestLine.SIDE_ARCANE_LIGHTNING) == Quest.LIGHTNING_SPELL_2_WAITING) {
                    if ((long)Main.game.getDayNumber() - Main.game.getDialogueFlags().getSavedLong("arthur_globe_day_start") < 14L) {
                        additionalResponses.add(new Response("\u5965\u672f\u95ea\u7535", "\u8fd9\u6bb5\u65f6\u95f4\u4e9a\u745f\u8fd8\u4e0d\u8db3\u4ee5\u4ece\u8fd9\u4e2a\u5965\u672f\u95ea\u7535\u7403\u4e2d\u89e3\u9501\u5176\u79d8\u5bc6\u3002" + (String)(RoomArthur.getDaysRemainingUntilArcaneLightningUnlocked() == 1 ? "\u660e\u5929" : Util.intToString(RoomArthur.getDaysRemainingUntilArcaneLightningUnlocked()) + "\u5929\u4e4b\u540e") + "\u518d\u56de\u6765\u770b\u770b\u4ed6\u80fd\u53d1\u73b0\u4ec0\u4e48\u3002", null));
                    } else {
                        additionalResponses.add(new Response("\u5965\u672f\u95ea\u7535", "\u81ea\u4ece\u4f60\u5c06\u5965\u672f\u95ea\u7535\u7403\u4ea4\u7ed9\u4e9a\u745f\u5df2\u7ecf\u8fc7\u53bb\u4e86\u4e24\u5468\uff0c\u4f60\u5e94\u8be5\u95ee\u95ee\u4ed6\u662f\u5426\u4ece\u5176\u4e2d\u89e3\u9501\u4e86\u4ec0\u4e48\u79d8\u5bc6\u3002", ROOM_ARTHUR_ARCANE_LIGHTNING_END));
                    }
                }
            }
            for (int i = 0; i < additionalResponses.size(); ++i) {
                if (index != i + 3) continue;
                return (Response)additionalResponses.get(i);
            }
            return null;
        }
    };
    public static final DialogueNode ROOM_ARTHUR_LYSSIETH = new DialogueNode("", "", false){

        @Override
        public int getSecondsPassed() {
            return 300;
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("places/dominion/lilayasHome/arthursRoom", "ROOM_ARTHUR_LYSSIETH");
        }

        @Override
        public String getResponseTabTitle(int index) {
            return ROOM_ARTHUR.getResponseTabTitle(index);
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (responseTab == 0 && index == 1) {
                return new Response("\u8389\u897f\u4e1d", "\u4f60\u5df2\u7ecf\u95ee\u8fc7\u4e9a\u745f\u8389\u897f\u4e1d\u7684\u4e8b\u60c5\u4e86\u3002", null);
            }
            return ROOM_ARTHUR.getResponse(responseTab, index);
        }
    };
    public static final DialogueNode ROOM_ARTHUR_LILAYA = new DialogueNode("", "", false){

        @Override
        public int getSecondsPassed() {
            return 300;
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("places/dominion/lilayasHome/arthursRoom", "ROOM_ARTHUR_LILAYA");
        }

        @Override
        public String getResponseTabTitle(int index) {
            return ROOM_ARTHUR.getResponseTabTitle(index);
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (responseTab == 0 && index == 2) {
                return new Response("\u8389\u83b1\u96c5", "\u4f60\u5df2\u7ecf\u95ee\u8fc7\u4e9a\u745f\u8389\u83b1\u96c5\u7684\u4e8b\u60c5\u4e86\u3002", null);
            }
            return ROOM_ARTHUR.getResponse(responseTab, index);
        }
    };
    public static final DialogueNode ROOM_ARTHUR_HYPNO_WATCH_START = new DialogueNode("", "", false){

        @Override
        public int getSecondsPassed() {
            return 300;
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("places/dominion/lilayasHome/arthursRoom", "ROOM_ARTHUR_HYPNO_WATCH_START");
        }

        @Override
        public String getResponseTabTitle(int index) {
            return ROOM_ARTHUR.getResponseTabTitle(index);
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            return ROOM_ARTHUR.getResponse(responseTab, index);
        }
    };
    public static final DialogueNode ROOM_ARTHUR_HYPNO_WATCH_DELIVERY = new DialogueNode("", "", true){

        @Override
        public int getSecondsPassed() {
            return 300;
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("places/dominion/lilayasHome/arthursRoom", "ROOM_ARTHUR_HYPNO_WATCH_DELIVERY");
        }

        @Override
        public String getResponseTabTitle(int index) {
            return null;
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1) {
                return new Response("\u540c\u610f", "\u4f60\u76f8\u4fe1\u8389\u83b1\u96c5\uff0c\u540c\u610f\u4e86\u5979\u7684\u8bf7\u6c42\u3002", ROOM_ARTHUR_HYPNO_WATCH_OFFER_SELF);
            }
            if (index == 2) {
                return new Response("\u62d2\u7edd", "\u4f60\u662f\u4e0d\u53ef\u80fd\u540c\u610f\u505a\u8389\u83b1\u96c5\u548c\u4e9a\u745f\u7684\u5b9e\u9a8c\u5bf9\u8c61\u7684\uff01\u6216\u8bb8\u841d\u4e1d\u80fd\u66ff\u4f60\u201c\u81ea\u613f\u201d\u53c2\u52a0\u2026\u2026", ROOM_ARTHUR_HYPNO_WATCH_OFFER_REFUSED);
            }
            return null;
        }
    };
    public static final DialogueNode ROOM_ARTHUR_HYPNO_WATCH_OFFER_SELF = new DialogueNode("", "", true, true){

        @Override
        public void applyPreParsingEffects() {
            Main.game.getTextEndStringBuilder().append(Main.game.getNpc(Lilaya.class).incrementAffection(Main.game.getPlayer(), 10.0f));
            Main.game.getTextEndStringBuilder().append(Main.game.getNpc(Arthur.class).incrementAffection(Main.game.getPlayer(), 5.0f));
        }

        @Override
        public int getSecondsPassed() {
            return 300;
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("places/dominion/lilayasHome/arthursRoom", "ROOM_ARTHUR_HYPNO_WATCH_OFFER_SELF");
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1) {
                return new Response("\u9192\u6765", "\u4f60\u7a81\u7136\u4ece\u5e7b\u5883\u4e2d\u8df3\u51fa\u3002", ROOM_ARTHUR_HYPNO_WATCH_OFFER_SELF_WAKE_UP){

                    @Override
                    public void effects() {
                        Main.game.getTextEndStringBuilder().append(Main.game.getPlayer().addItem(Main.game.getItemGen().generateItem(ItemType.ORIENTATION_HYPNO_WATCH), false, true));
                        Main.game.getTextEndStringBuilder().append(Main.game.getPlayer().setQuestProgress(QuestLine.SIDE_HYPNO_WATCH, Quest.SIDE_UTIL_COMPLETE));
                        Main.game.getNpc(Lilaya.class).setLocation(WorldType.LILAYAS_HOUSE_GROUND_FLOOR, PlaceType.LILAYA_HOME_LAB, true);
                    }
                };
            }
            return null;
        }
    };
    public static final DialogueNode ROOM_ARTHUR_HYPNO_WATCH_OFFER_SELF_WAKE_UP = new DialogueNode("", "", true, true){

        @Override
        public int getSecondsPassed() {
            return 900;
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("places/dominion/lilayasHome/arthursRoom", "ROOM_ARTHUR_HYPNO_WATCH_OFFER_SELF_WAKE_UP");
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1) {
                return new Response("\u7ee7\u7eed", "\u8ba9\u4e9a\u745f\u7ee7\u7eed\u5176\u4ed6\u5b9e\u9a8c\u3002", LilayaHomeGeneric.CORRIDOR){

                    @Override
                    public void effects() {
                        Main.game.getPlayer().setNearestLocation(Main.game.getPlayer().getWorldLocation(), PlaceType.LILAYA_HOME_CORRIDOR, false);
                    }
                };
            }
            return null;
        }
    };
    public static final DialogueNode ROOM_ARTHUR_HYPNO_WATCH_OFFER_REFUSED = new DialogueNode("", "", true, true){

        @Override
        public void applyPreParsingEffects() {
            Main.game.getNpc(Rose.class).setLocation(Main.game.getPlayer(), false);
        }

        @Override
        public int getSecondsPassed() {
            return 300;
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("places/dominion/lilayasHome/arthursRoom", "ROOM_ARTHUR_HYPNO_WATCH_OFFER_REFUSED");
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1) {
                return new Response("\u53eb\u9192\u841d\u4e1d", "\u5e2e\u8389\u83b1\u96c5\u4e00\u8d77\u53eb\u9192\u841d\u4e1d\u3002", ROOM_ARTHUR_HYPNO_WATCH_OFFER_REFUSED_WAKE_ROSE){

                    @Override
                    public void effects() {
                        Main.game.getTextEndStringBuilder().append(Main.game.getPlayer().addItem(Main.game.getItemGen().generateItem(ItemType.ORIENTATION_HYPNO_WATCH), false, true));
                        Main.game.getTextEndStringBuilder().append(Main.game.getPlayer().setQuestProgress(QuestLine.SIDE_HYPNO_WATCH, Quest.SIDE_UTIL_COMPLETE));
                        Main.game.getNpc(Lilaya.class).setLocation(WorldType.LILAYAS_HOUSE_GROUND_FLOOR, PlaceType.LILAYA_HOME_LAB, false);
                        Main.game.getNpc(Rose.class).setLocation(WorldType.LILAYAS_HOUSE_GROUND_FLOOR, PlaceType.LILAYA_HOME_LAB, false);
                    }
                };
            }
            return null;
        }
    };
    public static final DialogueNode ROOM_ARTHUR_HYPNO_WATCH_OFFER_REFUSED_WAKE_ROSE = new DialogueNode("", "", true, true){

        @Override
        public int getSecondsPassed() {
            return 300;
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("places/dominion/lilayasHome/arthursRoom", "ROOM_ARTHUR_HYPNO_WATCH_OFFER_REFUSED_WAKE_ROSE");
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1) {
                return new Response("\u7ee7\u7eed", "\u8ba9\u4e9a\u745f\u7ee7\u7eed\u5176\u4ed6\u5b9e\u9a8c\u3002", LilayaHomeGeneric.CORRIDOR){

                    @Override
                    public void effects() {
                        Main.game.getPlayer().setNearestLocation(Main.game.getPlayer().getWorldLocation(), PlaceType.LILAYA_HOME_CORRIDOR, false);
                    }
                };
            }
            return null;
        }
    };
    public static final DialogueNode ROOM_ARTHUR_ARCANE_LIGHTNING_START = new DialogueNode("", "", true, true){

        @Override
        public int getSecondsPassed() {
            return 300;
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("places/dominion/lilayasHome/arthursRoom", "ROOM_ARTHUR_ARCANE_LIGHTNING_START");
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1) {
                if (Main.game.getPlayer().getEssenceCount() < 500) {
                    return new Response("\u7ed9\u51fa\u7403\u4f53", "\u4f60\u81f3\u5c11\u9700\u8981\u5728\u7075\u6c14\u4e2d\u5438\u6536500\u7cbe\u534e\u624d\u80fd\u7ee7\u7eed\uff01", null);
                }
                return new Response("\u7ed9\u51fa\u7403\u4f53", "\u5c06\u5965\u672f\u95ea\u7535\u7403\u4ea4\u7ed9\u4e9a\u745f\uff0c\u5e76\u4e14\u5141\u8bb8\u4ed6\u4ece\u4f60\u7684\u7075\u6c14\u4e2d\u63d0\u53d6\u7cbe\u534e\u7528\u4ee5\u89e3\u9501\u5176\u79d8\u5bc6\u3002<br/>[style.italicsMinorBad(\u4f60\u5c06\u4f1a\u5931\u53bb500\u7cbe\u534e\uff01)]", ROOM_ARTHUR_ARCANE_LIGHTNING_PAYMENT);
            }
            if (index == 2) {
                return new Response("\u7a0d\u540e", "\u544a\u8bc9\u4e9a\u745f\u4f60\u8981\u8003\u8651\u4e00\u4e0b\uff0c\u4e4b\u540e\u518d\u56de\u6765\u8ba9\u4ed6\u5bf9\u7403\u4f53\u505a\u5b9e\u9a8c\u3002", LilayaHomeGeneric.CORRIDOR){

                    @Override
                    public void effects() {
                        Main.game.getTextStartStringBuilder().append(UtilText.parseFromXMLFile("places/dominion/lilayasHome/arthursRoom", "ROOM_ARTHUR_ARCANE_LIGHTNING_START_LEAVE"));
                        Main.game.getPlayer().setNearestLocation(Main.game.getPlayer().getWorldLocation(), PlaceType.LILAYA_HOME_CORRIDOR, false);
                    }
                };
            }
            return null;
        }
    };
    public static final DialogueNode ROOM_ARTHUR_ARCANE_LIGHTNING_PAYMENT = new DialogueNode("", "", true, true){

        @Override
        public void applyPreParsingEffects() {
            Main.game.getPlayer().removeWeaponTypeIntoVoid(WeaponType.getWeaponTypeFromId("innoxia_lightningGlobe_lightning_globe"), true, true, true);
            Main.game.getTextEndStringBuilder().append(Main.game.getPlayer().incrementEssenceCount(-500, false));
            Main.game.getTextEndStringBuilder().append(Main.game.getPlayer().setQuestProgress(QuestLine.SIDE_ARCANE_LIGHTNING, Quest.LIGHTNING_SPELL_2_WAITING));
            Main.game.getDialogueFlags().setSavedLong("arthur_globe_day_start", Main.game.getDayNumber());
        }

        @Override
        public int getSecondsPassed() {
            return 300;
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("places/dominion/lilayasHome/arthursRoom", "ROOM_ARTHUR_ARCANE_LIGHTNING_PAYMENT");
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1) {
                return new Response("\u79bb\u5f00", "\u4ece\u4e9a\u745f\u7684\u623f\u95f4\u8d70\u51fa\uff0c\u8ba9\u4ed6\u7ee7\u7eed\u4ed6\u7684\u5b9e\u9a8c\u3002", LilayaHomeGeneric.CORRIDOR){

                    @Override
                    public void effects() {
                        Main.game.getTextStartStringBuilder().append(UtilText.parseFromXMLFile("places/dominion/lilayasHome/arthursRoom", "ROOM_ARTHUR_ARCANE_LIGHTNING_PAYMENT_LEAVE"));
                        Main.game.getPlayer().setNearestLocation(Main.game.getPlayer().getWorldLocation(), PlaceType.LILAYA_HOME_CORRIDOR, false);
                    }
                };
            }
            return null;
        }
    };
    public static final DialogueNode ROOM_ARTHUR_ARCANE_LIGHTNING_END = new DialogueNode("", "", true, true){

        @Override
        public int getSecondsPassed() {
            return 300;
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("places/dominion/lilayasHome/arthursRoom", "ROOM_ARTHUR_ARCANE_LIGHTNING_END");
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1) {
                return new Response("\u5b66\u4e60\u6cd5\u672f", "\u901a\u8bfb\u7b14\u8bb0\uff0c\u5b66\u4f1a\u4e9a\u745f\u521b\u9020\u7684\u4e24\u79cd\u6cd5\u672f\u3002", ROOM_ARTHUR_ARCANE_LIGHTNING_END_FINAL);
            }
            return null;
        }
    };
    public static final DialogueNode ROOM_ARTHUR_ARCANE_LIGHTNING_END_FINAL = new DialogueNode("", "", true, true){

        @Override
        public void applyPreParsingEffects() {
            Main.game.getTextEndStringBuilder().append(Main.game.getPlayer().addWeapon(Main.game.getItemGen().generateWeapon("innoxia_lightningGlobe_lightning_globe_ring"), 1, false, true));
            Main.game.getPlayer().addSpell(Spell.ARCANE_CHAIN_LIGHTNING);
            Main.game.getPlayer().addSpell(Spell.ARCANE_LIGHTNING_SUPERBOLT);
            Main.game.getTextEndStringBuilder().append("<p style='text-align:center;'>\u4f60\u5b66\u4f1a\u4e86\u4ee5\u4e0b\u6cd5\u672f:<br/><b style='color:" + PresetColour.SPELL_SCHOOL_ARCANE.toWebHexString() + ";'>" + Spell.ARCANE_CHAIN_LIGHTNING.getName() + "</b><br/><b style='color:" + PresetColour.SPELL_SCHOOL_ARCANE.toWebHexString() + ";'>" + Spell.ARCANE_LIGHTNING_SUPERBOLT.getName() + "</b></p>");
            Main.game.getTextEndStringBuilder().append(Main.game.getPlayer().setQuestProgress(QuestLine.SIDE_ARCANE_LIGHTNING, Quest.SIDE_UTIL_COMPLETE));
        }

        @Override
        public int getSecondsPassed() {
            return 3600;
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("places/dominion/lilayasHome/arthursRoom", "ROOM_ARTHUR_ARCANE_LIGHTNING_END_FINAL");
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1) {
                return new Response("\u7ee7\u7eed", "\u8ba9\u4e9a\u745f\u7ee7\u7eed\u5176\u4ed6\u5b9e\u9a8c\u3002", LilayaHomeGeneric.CORRIDOR){

                    @Override
                    public void effects() {
                        Main.game.getTextStartStringBuilder().append(UtilText.parseFromXMLFile("places/dominion/lilayasHome/arthursRoom", "ROOM_ARTHUR_ARCANE_LIGHTNING_END_FINAL_LEAVE"));
                        Main.game.getPlayer().setNearestLocation(Main.game.getPlayer().getWorldLocation(), PlaceType.LILAYA_HOME_CORRIDOR, false);
                    }
                };
            }
            return null;
        }
    };

    private static int getDaysRemainingUntilArcaneLightningUnlocked() {
        return (int)(14L - ((long)Main.game.getDayNumber() - Main.game.getDialogueFlags().getSavedLong("arthur_globe_day_start")));
    }
}

