/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.dialogue.places.dominion.nyansApartment;

import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.npc.dominion.Nyan;
import com.lilithsthrone.game.character.npc.dominion.NyanMum;
import com.lilithsthrone.game.dialogue.DialogueFlagValue;
import com.lilithsthrone.game.dialogue.DialogueNode;
import com.lilithsthrone.game.dialogue.places.dominion.nyansApartment.NyanApartment;
import com.lilithsthrone.game.dialogue.places.dominion.shoppingArcade.ClothingEmporium;
import com.lilithsthrone.game.dialogue.responses.Response;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.game.inventory.InventorySlot;
import com.lilithsthrone.game.inventory.clothing.AbstractClothing;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.utils.Util;
import com.lilithsthrone.world.AbstractWorldType;
import com.lilithsthrone.world.WorldType;
import com.lilithsthrone.world.places.AbstractPlaceType;
import com.lilithsthrone.world.places.PlaceType;

public class NyanDateFinalRepeat {
    private static boolean kinky = false;
    private static boolean doubleDate = false;
    private static int dateBill;
    private static float playerAlcoholIncrement;
    public static final DialogueNode SOLO_DATE_START;
    public static final DialogueNode SOLO_DATE_RESTAURANT_1_ARRIVED;
    public static final DialogueNode SOLO_DATE_RESTAURANT_2_WINE_ORDER;
    public static final DialogueNode SOLO_DATE_RESTAURANT_3_MAIN_DATE;
    public static final DialogueNode SOLO_DATE_END_RETURN;
    public static final DialogueNode SOLO_DATE_END_RETURN_INSIDE;
    public static final DialogueNode DOUBLE_DATE_START;
    public static final DialogueNode DOUBLE_DATE_RESTAURANT_1_ARRIVED;
    public static final DialogueNode DOUBLE_DATE_RESTAURANT_2_MAIN_DATE;
    public static final DialogueNode DOUBLE_DATE_END_RETURN;
    public static final DialogueNode POST_DOUBLE_DATE_APARTMENT_LOUNGE;
    public static final DialogueNode POST_DOUBLE_DATE_APARTMENT_BEDROOM;

    private static Nyan getNyan() {
        return (Nyan)Main.game.getNpc(Nyan.class);
    }

    private static NyanMum getNyanMum() {
        return (NyanMum)Main.game.getNpc(NyanMum.class);
    }

    private static void travelTo(AbstractWorldType worldType, AbstractPlaceType placeType) {
        Main.game.getPlayer().setLocation(worldType, placeType);
        NyanDateFinalRepeat.getNyan().setLocation(Main.game.getPlayer(), false);
        if (doubleDate) {
            NyanDateFinalRepeat.getNyanMum().setLocation(Main.game.getPlayer(), false);
        }
    }

    static {
        playerAlcoholIncrement = 0.0f;
        SOLO_DATE_START = new DialogueNode("", "", true){

            @Override
            public void applyPreParsingEffects() {
                doubleDate = false;
                dateBill = 0;
                NyanDateFinalRepeat.getNyan().wearDress();
                NyanDateFinalRepeat.getNyan().wearCoat(true, true);
                NyanDateFinalRepeat.travelTo(WorldType.NYANS_APARTMENT, PlaceType.NYAN_APARTMENT_ENTRANCE);
                Main.game.getDialogueFlags().setFlag(DialogueFlagValue.nyanWeekendDated, true);
            }

            @Override
            public int getSecondsPassed() {
                return 600;
            }

            @Override
            public String getContent() {
                return UtilText.parseFromXMLFile("places/dominion/nyansApartment/finalRepeatDate", "SOLO_DATE_START");
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                if (index == 1) {
                    return new Response("\u9910\u5385", "\u966a\u59ae\u5b89\u53bb\u9910\u5385\u3002", SOLO_DATE_RESTAURANT_1_ARRIVED);
                }
                return null;
            }
        };
        SOLO_DATE_RESTAURANT_1_ARRIVED = new DialogueNode("", "", true){

            @Override
            public void applyPreParsingEffects() {
                NyanDateFinalRepeat.getNyan().wearCoat(false, false);
                NyanDateFinalRepeat.travelTo(WorldType.SHOPPING_ARCADE, PlaceType.SHOPPING_ARCADE_RESTAURANT);
            }

            @Override
            public int getSecondsPassed() {
                return 900;
            }

            @Override
            public String getContent() {
                return UtilText.parseFromXMLFile("places/dominion/nyansApartment/finalRepeatDate", "SOLO_DATE_RESTAURANT_1_ARRIVED");
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                if (index == 1) {
                    final int cost = 350;
                    return new Response("\u72d0\u72f8\u8461\u8404\u56ed (" + UtilText.formatAsMoney(cost, "span") + ")", "\u70b9\u9910\u5355\u4e0a\u6700\u4fbf\u5b9c\u7684\u8461\u8404\u9152\uff0c\u5c3d\u7ba1\u5982\u6b64\uff0c\u5b83\u4ecd\u7136\u662f\u4e00\u6b3e\u975e\u5e38\u597d\u7684\u4f73\u917f\u3002", SOLO_DATE_RESTAURANT_2_WINE_ORDER){

                        @Override
                        public void effects() {
                            UtilText.addSpecialParsingString("\u72d0\u72f8\u8461\u8404\u56ed", true);
                            UtilText.addSpecialParsingString(Util.intToString(cost), false);
                            dateBill += cost;
                            Main.game.getTextStartStringBuilder().append(UtilText.parseFromXMLFile("places/dominion/nyansApartment/finalRepeatDate", "SOLO_DATE_RESTAURANT_2_VULPINE"));
                        }
                    };
                }
                if (index == 2) {
                    final int cost = 600;
                    return new Response("\u5929\u89d2\u517d\u7cbe\u9009 (" + UtilText.formatAsMoney(cost, "span") + ")", "\u70b9\u9910\u5355\u4e0a\u8f83\u8d35\u7684\u4e00\u6b3e\u8461\u8404\u9152\u3002", SOLO_DATE_RESTAURANT_2_WINE_ORDER){

                        @Override
                        public void effects() {
                            UtilText.addSpecialParsingString("\u5929\u89d2\u517d\u7cbe\u9009", true);
                            UtilText.addSpecialParsingString(Util.intToString(cost), false);
                            dateBill += cost;
                            Main.game.getTextStartStringBuilder().append(UtilText.parseFromXMLFile("places/dominion/nyansApartment/finalRepeatDate", "SOLO_DATE_RESTAURANT_2_ALICORN"));
                            Main.game.getTextStartStringBuilder().append(ClothingEmporium.incrementAffection(NyanDateFinalRepeat.getNyan(), 1.0f, 60.0f, 100.0f));
                        }
                    };
                }
                if (index == 3) {
                    final int cost = 950;
                    return new Response("\u5996\u72d0\u7684\u73cd\u85cf (" + UtilText.formatAsMoney(cost, "span") + ")", "\u70b9\u9910\u5355\u4e0a\u6700\u8d35\u7684\u4e00\u6b3e\u8461\u8404\u9152\u3002", SOLO_DATE_RESTAURANT_2_WINE_ORDER){

                        @Override
                        public void effects() {
                            UtilText.addSpecialParsingString("\u5996\u72d0\u7684\u73cd\u85cf", true);
                            UtilText.addSpecialParsingString(Util.intToString(cost), false);
                            dateBill += cost;
                            Main.game.getTextStartStringBuilder().append(UtilText.parseFromXMLFile("places/dominion/nyansApartment/finalRepeatDate", "SOLO_DATE_RESTAURANT_2_YOUKO"));
                            Main.game.getTextStartStringBuilder().append(ClothingEmporium.incrementAffection(NyanDateFinalRepeat.getNyan(), 2.0f, 60.0f, 100.0f));
                        }
                    };
                }
                return null;
            }
        };
        SOLO_DATE_RESTAURANT_2_WINE_ORDER = new DialogueNode("", "", true, true){

            @Override
            public int getSecondsPassed() {
                return 300;
            }

            @Override
            public String getContent() {
                return UtilText.parseFromXMLFile("places/dominion/nyansApartment/finalRepeatDate", "SOLO_DATE_RESTAURANT_2_WINE_ORDER");
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                if (index == 1) {
                    return new Response("\u5171\u4eab\u74f6\u5b50", "\u8bf4\u4f60\u4f1a\u548c\u59ae\u5b89\u4e00\u8d77\u5206\u4eab\u8fd9\u74f6\u9152\u3002", SOLO_DATE_RESTAURANT_3_MAIN_DATE){

                        @Override
                        public void effects() {
                            Main.game.getTextStartStringBuilder().append(UtilText.parseFromXMLFile("places/dominion/nyansApartment/finalRepeatDate", "SOLO_DATE_RESTAURANT_3_SHARE"));
                            playerAlcoholIncrement = 0.1f;
                        }
                    };
                }
                if (index == 2) {
                    return new Response("\u6c34", "\u7ed9\u81ea\u5df1\u70b9\u4e00\u74f6\u6c34\u3002", SOLO_DATE_RESTAURANT_3_MAIN_DATE){

                        @Override
                        public void effects() {
                            dateBill += 25;
                            Main.game.getTextStartStringBuilder().append(UtilText.parseFromXMLFile("places/dominion/nyansApartment/finalRepeatDate", "SOLO_DATE_RESTAURANT_3_WATER"));
                            playerAlcoholIncrement = 0.0f;
                        }
                    };
                }
                if (index == 3) {
                    return new Response("\u5564\u9152", "\u7ed9\u81ea\u5df1\u70b9\u4e00\u624e\u5564\u9152\u3002", SOLO_DATE_RESTAURANT_3_MAIN_DATE){

                        @Override
                        public void effects() {
                            dateBill += 50;
                            Main.game.getTextStartStringBuilder().append(UtilText.parseFromXMLFile("places/dominion/nyansApartment/finalRepeatDate", "SOLO_DATE_RESTAURANT_3_BEER"));
                            playerAlcoholIncrement = 0.05f;
                        }
                    };
                }
                return null;
            }
        };
        SOLO_DATE_RESTAURANT_3_MAIN_DATE = new DialogueNode("", "", true, true){

            @Override
            public void applyPreParsingEffects() {
                NyanDateFinalRepeat.getNyan().incrementAlcoholLevel(0.2f);
                Main.game.getPlayer().incrementAlcoholLevel(playerAlcoholIncrement * 2.0f);
                dateBill += 1400;
            }

            @Override
            public int getSecondsPassed() {
                return 6000;
            }

            @Override
            public String getContent() {
                UtilText.addSpecialParsingString(Util.intToString(dateBill), true);
                return UtilText.parseFromXMLFile("places/dominion/nyansApartment/finalRepeatDate", "SOLO_DATE_RESTAURANT_3_MAIN_DATE");
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                if (index == 1) {
                    return new Response("\u79bb\u5f00(" + UtilText.formatAsMoney(dateBill, "span") + ")", "\u4ed8\u8d26\u7136\u540e\u966a\u59ae\u5b89\u56de\u516c\u5bd3\u3002", SOLO_DATE_END_RETURN){

                        @Override
                        public void effects() {
                            Main.game.getTextEndStringBuilder().append(Main.game.getPlayer().incrementMoney(-dateBill));
                            Main.game.getTextEndStringBuilder().append(NyanDateFinalRepeat.getNyan().incrementAffection(Main.game.getPlayer(), 10.0f));
                        }
                    };
                }
                return null;
            }
        };
        SOLO_DATE_END_RETURN = new DialogueNode("", "", true, true){

            @Override
            public void applyPreParsingEffects() {
                NyanDateFinalRepeat.travelTo(WorldType.NYANS_APARTMENT, PlaceType.NYAN_APARTMENT_ENTRANCE);
                NyanDateFinalRepeat.getNyan().wearCoat(false, true);
                AbstractClothing shoes = NyanDateFinalRepeat.getNyan().getClothingInSlot(InventorySlot.FOOT);
                if (shoes != null) {
                    NyanDateFinalRepeat.getNyan().unequipClothingIntoVoid(shoes, true, (GameCharacter)NyanDateFinalRepeat.getNyan());
                }
                Main.game.getPlayer().applyFoodConsumed(10);
                Main.game.getPlayer().applyDrinkConsumed(10);
                NyanDateFinalRepeat.getNyan().applyFoodConsumed(10);
                NyanDateFinalRepeat.getNyan().applyDrinkConsumed(10);
            }

            @Override
            public int getSecondsPassed() {
                return 600;
            }

            @Override
            public String getContent() {
                return UtilText.parseFromXMLFile("places/dominion/nyansApartment/finalRepeatDate", "SOLO_DATE_END_RETURN");
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                if (index == 1) {
                    return new Response("\u8fdb\u5165", "\u63a5\u53d7\u59ae\u5b89\u7684\u9080\u8bf7\u8fdb\u5165\u5979\u7684\u516c\u5bd3\u3002", SOLO_DATE_END_RETURN_INSIDE);
                }
                return null;
            }
        };
        SOLO_DATE_END_RETURN_INSIDE = new DialogueNode("", "", true, true){

            @Override
            public void applyPreParsingEffects() {
                NyanApartment.setActiveSexPartner(NyanDateFinalRepeat.getNyan());
                NyanDateFinalRepeat.getNyan().wearLingerie(false);
                NyanDateFinalRepeat.travelTo(WorldType.NYANS_APARTMENT, PlaceType.NYAN_APARTMENT_NYAN_BEDROOM);
            }

            @Override
            public int getSecondsPassed() {
                return 120;
            }

            @Override
            public String getContent() {
                return UtilText.parseFromXMLFile("places/dominion/nyansApartment/finalRepeatDate", "SOLO_DATE_END_RETURN_INSIDE");
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                return NyanApartment.SOLO_SEX_FOREPLAY.getResponse(responseTab, index);
            }
        };
        DOUBLE_DATE_START = new DialogueNode("", "", true){

            @Override
            public void applyPreParsingEffects() {
                doubleDate = true;
                dateBill = 0;
                NyanDateFinalRepeat.getNyanMum().equipClothing();
                NyanDateFinalRepeat.getNyan().wearDress();
                NyanDateFinalRepeat.getNyan().wearCoat(true, true);
                NyanDateFinalRepeat.travelTo(WorldType.NYANS_APARTMENT, PlaceType.NYAN_APARTMENT_ENTRANCE);
                Main.game.getDialogueFlags().setFlag(DialogueFlagValue.nyanWeekendDated, true);
            }

            @Override
            public int getSecondsPassed() {
                return 120;
            }

            @Override
            public String getContent() {
                return UtilText.parseFromXMLFile("places/dominion/nyansApartment/finalRepeatDate", "DOUBLE_DATE_START");
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                if (index == 1) {
                    return new Response("\u9910\u5385", "\u966a\u59ae\u5b89\u548c[nyanmum.name]\u53bb\u9910\u5385\u3002", DOUBLE_DATE_RESTAURANT_1_ARRIVED);
                }
                return null;
            }
        };
        DOUBLE_DATE_RESTAURANT_1_ARRIVED = new DialogueNode("", "", true){

            @Override
            public void applyPreParsingEffects() {
                NyanDateFinalRepeat.travelTo(WorldType.SHOPPING_ARCADE, PlaceType.SHOPPING_ARCADE_RESTAURANT);
                NyanDateFinalRepeat.getNyan().wearCoat(false, false);
                dateBill += 950;
            }

            @Override
            public int getSecondsPassed() {
                return 1200;
            }

            @Override
            public String getContent() {
                return UtilText.parseFromXMLFile("places/dominion/nyansApartment/finalRepeatDate", "DOUBLE_DATE_RESTAURANT_1_ARRIVED");
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                if (index == 1) {
                    return new Response("\u559d\u540c\u4e00\u74f6", "\u540c\u610f\u4e0e\u59ae\u5b89\u548c[nyanmum.name]\u559d\u540c\u4e00\u74f6\u3002", DOUBLE_DATE_RESTAURANT_2_MAIN_DATE){

                        @Override
                        public void effects() {
                            Main.game.getTextStartStringBuilder().append(UtilText.parseFromXMLFile("places/dominion/nyansApartment/finalRepeatDate", "DOUBLE_DATE_RESTAURANT_2_SHARE"));
                            playerAlcoholIncrement = 0.1f;
                        }
                    };
                }
                if (index == 2) {
                    return new Response("\u6c34", "\u7ed9\u81ea\u5df1\u70b9\u4e00\u74f6\u6c34\u3002", DOUBLE_DATE_RESTAURANT_2_MAIN_DATE){

                        @Override
                        public void effects() {
                            dateBill += 25;
                            Main.game.getTextStartStringBuilder().append(UtilText.parseFromXMLFile("places/dominion/nyansApartment/finalRepeatDate", "DOUBLE_DATE_RESTAURANT_2_WATER"));
                            playerAlcoholIncrement = 0.0f;
                        }
                    };
                }
                if (index == 3) {
                    return new Response("\u5564\u9152", "\u7ed9\u81ea\u5df1\u70b9\u4e00\u624e\u5564\u9152\u3002", DOUBLE_DATE_RESTAURANT_2_MAIN_DATE){

                        @Override
                        public void effects() {
                            dateBill += 50;
                            Main.game.getTextStartStringBuilder().append(UtilText.parseFromXMLFile("places/dominion/nyansApartment/finalRepeatDate", "DOUBLE_DATE_RESTAURANT_2_BEER"));
                            playerAlcoholIncrement = 0.05f;
                        }
                    };
                }
                return null;
            }
        };
        DOUBLE_DATE_RESTAURANT_2_MAIN_DATE = new DialogueNode("", "", true, true){

            @Override
            public void applyPreParsingEffects() {
                NyanDateFinalRepeat.getNyan().incrementAlcoholLevel(0.2f);
                NyanDateFinalRepeat.getNyanMum().incrementAlcoholLevel(0.2f);
                Main.game.getPlayer().incrementAlcoholLevel(playerAlcoholIncrement * 2.0f);
                dateBill += 1200;
            }

            @Override
            public int getSecondsPassed() {
                return 6000;
            }

            @Override
            public String getContent() {
                UtilText.addSpecialParsingString(Util.intToString(dateBill), true);
                return UtilText.parseFromXMLFile("places/dominion/nyansApartment/finalRepeatDate", "DOUBLE_DATE_RESTAURANT_2_MAIN_DATE");
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                if (index == 1) {
                    return new Response("\u79bb\u5f00(" + UtilText.formatAsMoney(dateBill, "span") + ")", "\u4ed8\u8d26\u7136\u540e\u966a\u732b\u5973\u4eec\u56de\u516c\u5bd3\u3002", DOUBLE_DATE_END_RETURN){

                        @Override
                        public void effects() {
                            Main.game.getTextEndStringBuilder().append(Main.game.getPlayer().incrementMoney(-dateBill));
                            Main.game.getTextEndStringBuilder().append(NyanDateFinalRepeat.getNyan().incrementAffection(Main.game.getPlayer(), 10.0f));
                            Main.game.getTextEndStringBuilder().append(NyanDateFinalRepeat.getNyanMum().incrementAffection(Main.game.getPlayer(), 10.0f));
                        }
                    };
                }
                return null;
            }
        };
        DOUBLE_DATE_END_RETURN = new DialogueNode("", "", true, true){

            @Override
            public void applyPreParsingEffects() {
                NyanDateFinalRepeat.travelTo(WorldType.NYANS_APARTMENT, PlaceType.NYAN_APARTMENT_ENTRANCE);
                NyanDateFinalRepeat.getNyan().wearCoat(false, true);
                AbstractClothing shoes = NyanDateFinalRepeat.getNyan().getClothingInSlot(InventorySlot.FOOT);
                if (shoes != null) {
                    NyanDateFinalRepeat.getNyan().unequipClothingIntoVoid(shoes, true, (GameCharacter)NyanDateFinalRepeat.getNyan());
                }
                Main.game.getPlayer().applyFoodConsumed(10);
                Main.game.getPlayer().applyDrinkConsumed(10);
                NyanDateFinalRepeat.getNyan().applyFoodConsumed(10);
                NyanDateFinalRepeat.getNyan().applyDrinkConsumed(10);
                NyanDateFinalRepeat.getNyanMum().applyFoodConsumed(10);
                NyanDateFinalRepeat.getNyanMum().applyDrinkConsumed(10);
            }

            @Override
            public int getSecondsPassed() {
                return 600;
            }

            @Override
            public String getContent() {
                return UtilText.parseFromXMLFile("places/dominion/nyansApartment/finalRepeatDate", "DOUBLE_DATE_END_RETURN");
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                if (index == 1) {
                    return new Response("\u4f11\u606f\u5ba4", " \u542c[nyanmum.name]\u7684\u8bdd\u53bb\u4f11\u606f\u5ba4\u7b49\u5f85\u2026\u2026", POST_DOUBLE_DATE_APARTMENT_LOUNGE){

                        @Override
                        public void effects() {
                            kinky = false;
                            Main.game.getTextStartStringBuilder().append(UtilText.parseFromXMLFile("places/dominion/nyansApartment/finalRepeatDate", "DOUBLE_DATE_END_RETURN_LOUNGE"));
                        }
                    };
                }
                if (index == 2) {
                    return new Response("\u4f11\u606f\u5ba4(\u8c03\u76ae)", "\u544a\u8bc9[nyanmum.name]\u4f60\u559c\u6b22\u5979\u7684\u201c\u8c03\u76ae\u4e3b\u610f\u201d\uff0c\u542c\u5979\u7684\u8bdd\u5728\u4f11\u606f\u5ba4\u4e56\u4e56\u7b49\u5f85\u2026\u2026", POST_DOUBLE_DATE_APARTMENT_LOUNGE){

                        @Override
                        public void effects() {
                            kinky = true;
                            Main.game.getTextStartStringBuilder().append(UtilText.parseFromXMLFile("places/dominion/nyansApartment/finalRepeatDate", "DOUBLE_DATE_END_RETURN_LOUNGE_KINKY"));
                        }
                    };
                }
                return null;
            }
        };
        POST_DOUBLE_DATE_APARTMENT_LOUNGE = new DialogueNode("", "", true, true){

            @Override
            public void applyPreParsingEffects() {
                NyanDateFinalRepeat.travelTo(WorldType.NYANS_APARTMENT, PlaceType.NYAN_APARTMENT_SPARE_BEDROOM);
                Main.game.getPlayer().setLocation(WorldType.NYANS_APARTMENT, PlaceType.NYAN_APARTMENT_LOUNGE);
            }

            @Override
            public int getSecondsPassed() {
                return 300;
            }

            @Override
            public String getContent() {
                return UtilText.parseFromXMLFile("places/dominion/nyansApartment/finalRepeatDate", "POST_DOUBLE_DATE_APARTMENT_LOUNGE");
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                if (index == 1) {
                    return new Response("\u5367\u5ba4", "\u8fdb\u5165[nyanmum.namePos]\u7684\u5367\u5ba4\u2026\u2026", POST_DOUBLE_DATE_APARTMENT_BEDROOM);
                }
                return null;
            }
        };
        POST_DOUBLE_DATE_APARTMENT_BEDROOM = new DialogueNode("", "", true, true){

            @Override
            public void applyPreParsingEffects() {
                NyanDateFinalRepeat.getNyan().wearLingerie(kinky);
                NyanDateFinalRepeat.getNyanMum().wearLingerie(kinky);
                NyanDateFinalRepeat.travelTo(WorldType.NYANS_APARTMENT, PlaceType.NYAN_APARTMENT_SPARE_BEDROOM);
            }

            @Override
            public int getSecondsPassed() {
                return 120;
            }

            @Override
            public String getContent() {
                StringBuilder sb = new StringBuilder();
                sb.append(UtilText.parseFromXMLFile("places/dominion/nyansApartment/finalRepeatDate", "POST_DOUBLE_DATE_APARTMENT_BEDROOM_START"));
                if (kinky) {
                    sb.append(UtilText.parseFromXMLFile("places/dominion/nyansApartment/finalRepeatDate", "POST_DOUBLE_DATE_APARTMENT_BEDROOM_KINKY"));
                } else {
                    sb.append(UtilText.parseFromXMLFile("places/dominion/nyansApartment/finalRepeatDate", "POST_DOUBLE_DATE_APARTMENT_BEDROOM"));
                }
                sb.append(UtilText.parseFromXMLFile("places/dominion/nyansApartment/finalRepeatDate", "POST_DOUBLE_DATE_APARTMENT_BEDROOM_END"));
                return sb.toString();
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                return NyanApartment.DOUBLE_SEX_FOREPLAY.getResponse(responseTab, index);
            }
        };
    }
}

