/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.dialogue.places.dominion.slaverAlley;

import com.lilithsthrone.game.character.npc.dominion.Finch;
import com.lilithsthrone.game.character.quests.Quest;
import com.lilithsthrone.game.character.quests.QuestLine;
import com.lilithsthrone.game.dialogue.DialogueFlagValue;
import com.lilithsthrone.game.dialogue.DialogueNode;
import com.lilithsthrone.game.dialogue.companions.CompanionManagement;
import com.lilithsthrone.game.dialogue.companions.OccupantManagementDialogue;
import com.lilithsthrone.game.dialogue.responses.Response;
import com.lilithsthrone.game.dialogue.responses.ResponseTrade;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.game.inventory.item.ItemType;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.utils.Util;
import com.lilithsthrone.utils.colours.PresetColour;

public class SlaveryAdministration {
    private static int slaverLicenseCost = 5000;
    public static final DialogueNode SLAVERY_ADMINISTRATION_EXTERIOR = new DialogueNode("\u5974\u96b6\u7ba1\u7406\u5c40", ".", false){

        @Override
        public int getSecondsPassed() {
            return 60;
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("places/dominion/slaverAlley/slaveryAdministration", "SLAVERY_ADMINISTRATION_EXTERIOR");
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1) {
                return new Response("\u8fdb\u5165", "\u8d70\u8fdb\u5974\u96b6\u7ba1\u7406\u5c40\u3002", SLAVERY_ADMINISTRATION);
            }
            if (index == 2) {
                if (Main.game.getCurrentDialogueNode() == SLAVERY_ADMINISTRATION_POSTERS) {
                    return new Response("\u6d77\u62a5", "\u4f60\u5df2\u7ecf\u4ed4\u7ec6\u770b\u8fc7\u6d77\u62a5\u4e86\u2026\u2026", null);
                }
                return new Response("\u6d77\u62a5", "\u4ed4\u7ec6\u770b\u4e00\u4e0b\u5f20\u8d34\u5728\u5974\u96b6\u7ba1\u7406\u5c40\u5efa\u7b51\u5899\u4e0a\u7684\u6d77\u62a5\u3002", SLAVERY_ADMINISTRATION_POSTERS);
            }
            return null;
        }
    };
    public static final DialogueNode SLAVERY_ADMINISTRATION_POSTERS = new DialogueNode("\u5974\u96b6\u7ba1\u7406\u5c40", ".", false){

        @Override
        public int getSecondsPassed() {
            return 120;
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("places/dominion/slaverAlley/slaveryAdministration", "SLAVERY_ADMINISTRATION_POSTERS");
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            return SLAVERY_ADMINISTRATION_EXTERIOR.getResponse(responseTab, index);
        }
    };
    public static final DialogueNode SLAVERY_ADMINISTRATION = new DialogueNode("\u5974\u96b6\u7ba1\u7406\u5c40", ".", true){

        @Override
        public int getSecondsPassed() {
            return 120;
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("places/dominion/slaverAlley/slaveryAdministration", "SLAVERY_ADMINISTRATION");
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (Main.game.getPlayer().isHasSlaverLicense()) {
                if (index == 1) {
                    return new ResponseTrade("\u4ea4\u6613", "\u8d2d\u4e70\u5974\u5f79\u76f8\u5173\u7269\u54c1\u3002", SlaveryAdministration.getFinch());
                }
                if (index == 2 && !Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.finchFreedomTalk)) {
                    return new Response("\u91ca\u653e\u5974\u96b6", "\u8be2\u95ee\u82ac\u5947\u5982\u679c\u8981\u91ca\u653e\u5974\u96b6\uff0c\u9700\u8981\u7ecf\u8fc7\u4ec0\u4e48\u6d41\u7a0b\u3002", SLAVE_FREEDOM_TALK){

                        @Override
                        public void effects() {
                            SlaveryAdministration.getFinch().addItem(Main.game.getItemGen().generateItem("innoxia_slavery_freedom_certification"), 10, false, false);
                            Main.game.getDialogueFlags().setFlag(DialogueFlagValue.finchFreedomTalk, true);
                        }
                    };
                }
                if (index == 5) {
                    return new Response("\u5974\u96b6\u7ba1\u7406", "\u6253\u5f00\u5974\u96b6\u7ba1\u7406\u754c\u9762\u3002", SLAVERY_ADMINISTRATION){

                        @Override
                        public boolean isTradeHighlight() {
                            return true;
                        }

                        @Override
                        public DialogueNode getNextDialogue() {
                            CompanionManagement.initManagement(null, 0, null);
                            return OccupantManagementDialogue.getSlaveryManagementDialogue(null, null);
                        }
                    };
                }
                if (index == 0) {
                    return new Response("\u79bb\u5f00", "\u56de\u5230\u5916\u8fb9\u3002", SLAVERY_ADMINISTRATION_EXTERIOR);
                }
                return null;
            }
            if (index == 1) {
                if (!Main.game.getPlayer().hasQuest(QuestLine.SIDE_SLAVERY)) {
                    return new Response("\u8d29\u5974\u8bb8\u53ef", "\u8be2\u95ee\u82ac\u5947\u83b7\u5f97\u8d29\u5974\u8bb8\u53ef\u7684\u4e8b\u60c5\u3002", SLAVERY_ADMINISTRATION_ASK_ABOUT_SLAVER_LICENSE){

                        @Override
                        public void effects() {
                            Main.game.getTextEndStringBuilder().append(Main.game.getPlayer().startQuest(QuestLine.SIDE_SLAVERY));
                            Main.game.getDialogueFlags().values.add(DialogueFlagValue.finchIntroduced);
                        }
                    };
                }
                if (Main.game.getPlayer().getQuest(QuestLine.SIDE_SLAVERY) == Quest.SIDE_SLAVER_RECOMMENDATION_OBTAINED) {
                    if (Main.game.getPlayer().getMoney() >= (long)slaverLicenseCost) {
                        return new Response("\u9012\u4ea4\u4fe1\u4ef6(<span style='color:" + PresetColour.CURRENCY_GOLD.toWebHexString() + ";'>" + UtilText.getCurrencySymbol() + "</span> " + slaverLicenseCost + ")", "\u5c06\u4f60\u4ece\u8389\u83b1\u96c5\u5904\u5f97\u5230\u7684\u63a8\u8350\u4fe1\u4ea4\u7ed9\u82ac\u5947\uff0c\u7136\u540e\u4e0a\u4ea4" + slaverLicenseCost + "\u706b\u5e01\u4ee5\u83b7\u53d6\u8d29\u5974\u8bb8\u53ef\u3002", SLAVERY_ADMINISTRATION_SLAVER_LICENSE_OBTAINED){

                            @Override
                            public void effects() {
                                Main.game.getPlayer().incrementMoney(-slaverLicenseCost);
                            }
                        };
                    }
                    return new Response("\u9012\u4ea4\u4fe1\u4ef6(" + UtilText.getCurrencySymbol() + slaverLicenseCost + ")", "\u4f60\u6ca1\u6709\u8db3\u591f\u7684\u94b1\u6765\u4e70\u8d29\u5974\u8bb8\u53ef\uff01\u4f60\u81f3\u5c11\u9700\u8981" + slaverLicenseCost + "\u706b\u5e01\u3002", null);
                }
                return new Response("\u9012\u4ea4\u4fe1\u4ef6(" + UtilText.getCurrencySymbol() + slaverLicenseCost + ")", "\u4f60\u9700\u8981\u5148\u4ece\u8389\u83b1\u96c5\u90a3\u91cc\u62ff\u5230\u63a8\u8350\u4fe1\uff01", null);
            }
            if (index == 0) {
                return new Response("\u79bb\u5f00", "\u56de\u5230\u5916\u8fb9\u3002", SLAVERY_ADMINISTRATION_EXTERIOR){

                    @Override
                    public void effects() {
                        Main.game.getDialogueFlags().values.add(DialogueFlagValue.finchIntroduced);
                    }
                };
            }
            return null;
        }
    };
    public static final DialogueNode SLAVERY_ADMINISTRATION_ASK_ABOUT_SLAVER_LICENSE = new DialogueNode("\u5974\u96b6\u7ba1\u7406\u5c40", ".", true){

        @Override
        public int getSecondsPassed() {
            return 300;
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("places/dominion/slaverAlley/slaveryAdministration", "SLAVERY_ADMINISTRATION_ASK_ABOUT_SLAVER_LICENSE");
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            return SLAVERY_ADMINISTRATION.getResponse(0, index);
        }
    };
    public static final DialogueNode SLAVERY_ADMINISTRATION_SLAVER_LICENSE_OBTAINED = new DialogueNode("\u5974\u96b6\u7ba1\u7406\u5c40", ".", true){

        @Override
        public int getSecondsPassed() {
            return 300;
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("places/dominion/slaverAlley/slaveryAdministration", "SLAVERY_ADMINISTRATION_SLAVER_LICENSE_OBTAINED");
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1) {
                return new Response("\u89c4\u7ae0", "\u8ba9[finch.name]\u7ed9\u4f60\u89e3\u91ca\u4e00\u4e0b\u89c4\u77e9\u3002", SLAVERY_ADMINISTRATION_SLAVER_LICENSE_OBTAINED_RULES){

                    @Override
                    public void effects() {
                        Main.game.getTextEndStringBuilder().append(Main.game.getPlayer().setQuestProgress(QuestLine.SIDE_SLAVERY, Quest.SIDE_UTIL_COMPLETE));
                        Main.game.getTextEndStringBuilder().append(Main.game.getPlayer().addItem(Main.game.getItemGen().generateItem(ItemType.SLAVER_LICENSE), false));
                    }
                };
            }
            return null;
        }
    };
    public static final DialogueNode SLAVERY_ADMINISTRATION_SLAVER_LICENSE_OBTAINED_RULES = new DialogueNode("\u5974\u96b6\u7ba1\u7406\u5c40", ".", true, true){

        @Override
        public int getSecondsPassed() {
            return 300;
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("places/dominion/slaverAlley/slaveryAdministration", "SLAVERY_ADMINISTRATION_SLAVER_LICENSE_OBTAINED_RULES");
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            return SLAVERY_ADMINISTRATION.getResponse(0, index);
        }
    };
    public static final DialogueNode SLAVE_FREEDOM_TALK = new DialogueNode("", "", true){

        @Override
        public void applyPreParsingEffects() {
            if (Main.game.getPlayer().hasQuest(QuestLine.SIDE_ACCOMMODATION)) {
                Main.game.getTextEndStringBuilder().append(UtilText.parseFromXMLFile("places/dominion/slaverAlley/slaveryAdministration", "SLAVE_FREEDOM_TALK_END"));
            } else {
                Main.game.getTextEndStringBuilder().append(UtilText.parseFromXMLFile("places/dominion/slaverAlley/slaveryAdministration", "SLAVE_FREEDOM_TALK_END_START_ACCOMMODATION_QUEST"));
                Main.game.getTextEndStringBuilder().append(Main.game.getPlayer().startQuest(QuestLine.SIDE_ACCOMMODATION));
            }
        }

        @Override
        public int getSecondsPassed() {
            return 300;
        }

        @Override
        public String getContent() {
            UtilText.addSpecialParsingString(Util.intToString(ItemType.getItemTypeFromId("innoxia_slavery_freedom_certification").getValue()), true);
            return UtilText.parseFromXMLFile("places/dominion/slaverAlley/slaveryAdministration", "SLAVE_FREEDOM_TALK");
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            return SLAVERY_ADMINISTRATION.getResponse(0, index);
        }
    };

    private static Finch getFinch() {
        return (Finch)Main.game.getNpc(Finch.class);
    }
}

