/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.dialogue.places.dominion.warehouseDistrict;

import com.lilithsthrone.game.character.quests.Quest;
import com.lilithsthrone.game.character.quests.QuestLine;
import com.lilithsthrone.game.dialogue.DialogueNode;
import com.lilithsthrone.game.dialogue.places.dominion.warehouseDistrict.DominionExpress;
import com.lilithsthrone.game.dialogue.places.dominion.warehouseDistrict.KaysWarehouse;
import com.lilithsthrone.game.dialogue.responses.Response;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.game.inventory.item.ItemType;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.world.WorldType;
import com.lilithsthrone.world.places.PlaceType;
import java.util.ArrayList;

public class Warehouses {
    public static final DialogueNode WAREHOUSE_DISTRICT = new DialogueNode("", "", false){

        @Override
        public int getSecondsPassed() {
            return 120;
        }

        @Override
        public String getContent() {
            StringBuilder sb = new StringBuilder();
            sb.append(UtilText.parseFromXMLFile("places/dominion/warehouseDistrict/warehouses", "WAREHOUSE_DISTRICT"));
            boolean businessFound = false;
            if (Main.game.getPlayer().hasItemType(ItemType.NATALYA_BUSINESS_CARD) || Main.game.getPlayer().hasItemType(ItemType.NATALYA_BUSINESS_CARD_STAMPED)) {
                sb.append(UtilText.parseFromXMLFile("places/dominion/warehouseDistrict/dominionExpress", "WAREHOUSE_DISTRICT_DOMINION_EXPRESS"));
                businessFound = true;
            }
            if (Main.game.getPlayer().isQuestProgressGreaterThan(QuestLine.RELATIONSHIP_NYAN_HELP, Quest.RELATIONSHIP_NYAN_1_STOCK_ISSUES)) {
                sb.append(UtilText.parseFromXMLFile("places/dominion/warehouseDistrict/kaysTextiles", "WAREHOUSE_DISTRICT_KAYS_TEXTILES"));
                businessFound = true;
            }
            if (!businessFound) {
                sb.append(UtilText.parseFromXMLFile("places/dominion/warehouseDistrict/warehouses", "WAREHOUSE_DISTRICT_NO_BUSINESS"));
            }
            return sb.toString();
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            ArrayList<Response> responses = new ArrayList<Response>();
            if ((Main.game.getPlayer().hasItemType(ItemType.NATALYA_BUSINESS_CARD) || Main.game.getPlayer().hasItemType(ItemType.NATALYA_BUSINESS_CARD_STAMPED)) && !Main.game.getPlayer().isQuestFailed(QuestLine.ROMANCE_NATALYA)) {
                if (!Main.game.isExtendedWorkTime() && !Main.game.getPlayer().isQuestCompleted(QuestLine.ROMANCE_NATALYA)) {
                    responses.add(new Response("\u5fa1\u57ce\u901f\u9012", "\u5fa1\u57ce\u901f\u9012\u73b0\u5728\u4e0d\u63a5\u5f85\u6765\u8bbf\u516c\u4f17\u3002\u82e5\u60f3\u518d\u89c1\u5230\u5a1c\u5854\u8389\u4e9a\uff0c\u9700\u8981\u5728[unit.time(6)]-[unit.time(22)]\u4e4b\u95f4\u518d\u6765\u3002", null));
                } else {
                    responses.add(new Response("\u5fa1\u57ce\u901f\u9012", "\u8fdb\u5165\u5a1c\u5854\u8389\u4e9a\u7684\u5feb\u9012\u516c\u53f8\u201c\u5fa1\u57ce\u901f\u9012\u201d\u7684\u4e3b\u4ed3\u5e93\u3002", DominionExpress.INITIAL_ENTRANCE){

                        @Override
                        public void effects() {
                            Main.game.getPlayer().setLocation(WorldType.DOMINION_EXPRESS, PlaceType.DOMINION_EXPRESS_EXIT);
                        }
                    });
                }
            }
            if (Main.game.getPlayer().isQuestProgressGreaterThan(QuestLine.RELATIONSHIP_NYAN_HELP, Quest.RELATIONSHIP_NYAN_1_STOCK_ISSUES)) {
                if (!Main.game.isExtendedWorkTime()) {
                    responses.add(new Response(WorldType.TEXTILES_WAREHOUSE.getName(), "\u201c" + WorldType.TEXTILES_WAREHOUSE.getName() + "\u201d\u7684\u4ed3\u5e93\u5165\u53e3\u65c1\u6302\u7740\u4e00\u4e2a\u6807\u7b7e\uff0c\u4e0a\u9762\u8868\u793a\u53ea\u5728[unit.time(6)]-[unit.time(22)]\u5f00\u95e8\u3002\u5982\u679c\u4f60\u60f3\u8fdb\u53bb\uff0c\u6700\u597d\u665a\u70b9\u518d\u6765\u2026\u2026", null));
                } else {
                    responses.add(new Response(WorldType.TEXTILES_WAREHOUSE.getName(), "\u8fdb\u5165\u5b58\u653e\u4e1a\u52a1\u7684\u4ed3\u5e93'" + WorldType.TEXTILES_WAREHOUSE.getName() + "'\u3002", KaysWarehouse.INITIAL_ENTRY){

                        @Override
                        public void effects() {
                            Main.game.getPlayer().setLocation(WorldType.TEXTILES_WAREHOUSE, PlaceType.TEXTILE_WAREHOUSE_ENTRANCE);
                        }
                    });
                }
            }
            if (index > 0 && index - 1 < responses.size()) {
                return (Response)responses.get(index - 1);
            }
            return null;
        }
    };
}

