/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.dialogue.places.fields;

import com.lilithsthrone.game.character.npc.submission.DarkSiren;
import com.lilithsthrone.game.dialogue.DialogueFlagValue;
import com.lilithsthrone.game.dialogue.DialogueManager;
import com.lilithsthrone.game.dialogue.DialogueNode;
import com.lilithsthrone.game.dialogue.responses.Response;
import com.lilithsthrone.game.dialogue.responses.ResponseEffectsOnly;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.utils.Vector2i;
import com.lilithsthrone.world.Bearing;
import com.lilithsthrone.world.Cell;
import com.lilithsthrone.world.Season;
import com.lilithsthrone.world.WorldType;
import com.lilithsthrone.world.places.PlaceType;
import java.util.HashMap;
import java.util.Map;

public class FieldsDialogue {
    public static final DialogueNode DOMINION_EXTERIOR_FIRST_TIME_LEAVING = new DialogueNode("", "", true){

        @Override
        public int getSecondsPassed() {
            return 1800;
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("places/global/globalPlaces", "DOMINION_EXTERIOR_FIRST_TIME_LEAVING");
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1) {
                return new Response("\u4e25\u9635\u4ee5\u5f85", "\u4e3a\u5373\u5c06\u51fa\u73b0\u7684\u4e00\u5207\u505a\u597d\u51c6\u5907\uff01", DOMINION_EXTERIOR_FIRST_TIME_LEAVING_MERAXIS);
            }
            return null;
        }
    };
    public static final DialogueNode DOMINION_EXTERIOR_FIRST_TIME_LEAVING_MERAXIS = new DialogueNode("", "", true, true){

        @Override
        public void applyPreParsingEffects() {
            Main.game.getDialogueFlags().setFlag(DialogueFlagValue.leftDominionFirstTime, true);
            Main.game.getNpc(DarkSiren.class).setLocation(Main.game.getPlayer(), false);
        }

        @Override
        public int getSecondsPassed() {
            return 300;
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("places/global/globalPlaces", "DOMINION_EXTERIOR_FIRST_TIME_LEAVING_MERAXIS");
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1) {
                return new Response("\u8c22\u7edd", "\u544a\u8bc9\u6885\u62c9\u514b\u897f\u4e1d\uff0c\u4f60\u6ca1\u5174\u8da3\u548c\u5979\u5bf9\u51b3\u3002", DOMINION_EXTERIOR_FIRST_TIME_LEAVING_MERAXIS_DECLINED);
            }
            if (index == 2) {
                return new Response("\u63a5\u53d7", "\u63a5\u4e0b\u4e0e\u6885\u62c9\u514b\u897f\u4e1d\u7684\u5bf9\u51b3\u3002", null);
            }
            if (index == 3) {
                return new Response("\u7231\u2665\u51b3\u2665\u6597", "\u5411\u6885\u62c9\u514b\u897f\u4e1d\u63d0\u4f9b\u53e6\u4e00\u79cd\u51b3\u6597\u65b9\u5f0f\uff1a\u4e24\u4eba\u505a\u7231\uff0c\u8c01\u5148\u8fbe\u5230\u9ad8\u6f6e\u8c01\u5c31\u8f93\u4e86\uff01", null);
            }
            return null;
        }
    };
    public static final DialogueNode DOMINION_EXTERIOR_FIRST_TIME_LEAVING_MERAXIS_DECLINED = new DialogueNode("", "", true, true){

        @Override
        public void applyPreParsingEffects() {
            Main.game.getNpc(DarkSiren.class).setLocation(WorldType.getWorldTypeFromId("innoxia_fields_elis_town"), PlaceType.getPlaceTypeFromId("innoxia_fields_elis_town_town_hall"));
        }

        @Override
        public int getSecondsPassed() {
            return 300;
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("places/global/globalPlaces", "DOMINION_EXTERIOR_FIRST_TIME_LEAVING_MERAXIS_DECLINED");
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1) {
                return new Response("\u7ee7\u7eed", "\u6885\u62c9\u514b\u897f\u4e1d\u53d1\u51fa\u8b66\u544a\u540e\u5c31\u79bb\u5f00\u4e86\uff0c\u4f60\u53ef\u4ee5\u7ee7\u7eed\u524d\u5f80\u7530\u91ce\u3002", Main.game.getDefaultDialogue(false));
            }
            return null;
        }
    };
    public static final DialogueNode DOMINION_EXTERIOR = new DialogueNode("\u5fa1\u57ce\u533a", "", false){

        @Override
        public int getSecondsPassed() {
            return 3600;
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("places/global/globalPlaces", "DOMINION_EXTERIOR");
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1) {
                return new ResponseEffectsOnly("\u5e02\u4e2d\u5fc3", "\u5411\u7740\u5fa1\u57ce\u533a\u4e2d\u5fc3\u8fdb\u53d1\u3002"){

                    @Override
                    public void effects() {
                        Main.game.getPlayer().setLocation(WorldType.DOMINION, PlaceType.DOMINION_PLAZA, false);
                        Main.game.getTextStartStringBuilder().append(UtilText.parseFromXMLFile("places/global/globalPlaces", "ENTERING_DOMINION"));
                        Main.game.setContent(new Response("", "", Main.game.getDefaultDialogue(false)));
                    }
                };
            }
            return null;
        }
    };
    public static final DialogueNode FOLOI_FIELDS = new DialogueNode("\u5f17\u6d1b\u4f0a\u7530\u91ce", "", false){

        @Override
        public int getSecondsPassed() {
            if (Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.hasSnowedThisWinter) && Main.game.getSeason() == Season.WINTER && !Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.lunetteTerrorEnded)) {
                return 3600;
            }
            return 1800;
        }

        @Override
        public String getContent() {
            StringBuilder sb = new StringBuilder();
            sb.append(UtilText.parseFromXMLFile("places/global/globalPlaces", "FOLOI_FIELDS"));
            sb.append(FieldsDialogue.getUnavailableAreaText());
            if (Main.game.getPlayer().getLocation().increment(0, -1).equals(Main.game.getWorlds().get(WorldType.WORLD_MAP).getCell(PlaceType.WORLD_MAP_DOMINION).getLocation())) {
                sb.append(UtilText.parseFromXMLFile("places/fields/centaur_transport", "UNEXPLORED"));
            }
            return sb.toString();
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (Main.game.getPlayer().getLocation().increment(0, -1).equals(Main.game.getWorlds().get(WorldType.WORLD_MAP).getCell(PlaceType.WORLD_MAP_DOMINION).getLocation())) {
                if (index == 1) {
                    return new Response("\u8f66\u7ad9", "\u8d70\u8fd1\u201c\u534a\u4eba\u9a6c\u62c9\u8f66\u7ad9\u201d\uff0c\u770b\u770b\u662f\u5426\u8fd8\u6709\u5e08\u5085\u5728\u3002", DialogueManager.getDialogueFromId("innoxia_places_fields_centaur_transport_approach")){

                        @Override
                        public void effects() {
                            Main.game.getPlayerCell().getPlace().setPlaceType(PlaceType.getPlaceTypeFromId("innoxia_fields_centaur_transport"));
                        }
                    };
                }
            } else if (index == 1) {
                return new ResponseEffectsOnly("\u63a2\u7d22", "\u82b1\u70b9\u65f6\u95f4\u63a2\u7d22\u4e00\u4e0b\u7530\u91ce\u3002\u867d\u7136\u8fd9\u6837\u5e94\u8be5\u4e5f\u627e\u4e0d\u5230\u4ec0\u4e48\u4e1c\u897f\uff0c\u4f46\u81f3\u5c11\u4e0d\u5fc5\u6765\u56de\u5954\u6ce2\u2026\u2026"){

                    @Override
                    public int getSecondsPassed() {
                        return 1800;
                    }

                    @Override
                    public void effects() {
                        DialogueNode dn = Main.game.getActiveWorld().getCell(Main.game.getPlayer().getLocation()).getDialogue(true, true);
                        Main.game.setContent(new Response("", "", dn));
                    }
                };
            }
            return null;
        }
    };
    public static final DialogueNode FOLOI_FOREST = new DialogueNode("\u5f17\u6d1b\u4f0a\u68ee\u6797", "", false){

        @Override
        public int getSecondsPassed() {
            return 3600;
        }

        @Override
        public String getContent() {
            StringBuilder sb = new StringBuilder();
            sb.append(UtilText.parseFromXMLFile("places/global/globalPlaces", "FOLOI_FOREST"));
            sb.append(FieldsDialogue.getUnavailableAreaText());
            return sb.toString();
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            return null;
        }
    };
    public static final DialogueNode GRASSLAND_WILDERNESS = new DialogueNode("\u8352\u91ce\u8349\u539f", "", false){

        @Override
        public int getSecondsPassed() {
            return 3600;
        }

        @Override
        public String getContent() {
            StringBuilder sb = new StringBuilder();
            sb.append(UtilText.parseFromXMLFile("places/global/globalPlaces", "GRASSLAND_WILDERNESS"));
            sb.append(FieldsDialogue.getUnavailableAreaText());
            return sb.toString();
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1) {
                return new ResponseEffectsOnly("\u63a2\u7d22", "\u82b1\u70b9\u65f6\u95f4\u63a2\u7d22\u4e00\u4e0b\u5c71\u8c37\u3002\u867d\u7136\u8fd9\u6837\u5e94\u8be5\u4e5f\u627e\u4e0d\u5230\u4ec0\u4e48\u4e1c\u897f\uff0c\u4f46\u81f3\u5c11\u4e0d\u5fc5\u6765\u56de\u5954\u6ce2\u2026\u2026"){

                    @Override
                    public int getSecondsPassed() {
                        return 1800;
                    }

                    @Override
                    public void effects() {
                        DialogueNode dn = Main.game.getActiveWorld().getCell(Main.game.getPlayer().getLocation()).getDialogue(true, true);
                        Main.game.setContent(new Response("", "", dn));
                    }
                };
            }
            return null;
        }
    };
    public static final DialogueNode RIVER_HUBUR = new DialogueNode("\u80e1\u5e03\u5c14\u6cb3", "", false){

        @Override
        public int getSecondsPassed() {
            return 1800;
        }

        @Override
        public String getContent() {
            StringBuilder sb = new StringBuilder();
            sb.append(UtilText.parseFromXMLFile("places/global/globalPlaces", "RIVER_HUBUR"));
            sb.append(FieldsDialogue.getUnavailableAreaText());
            return sb.toString();
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1) {
                return new ResponseEffectsOnly("\u63a2\u7d22", "\u82b1\u70b9\u65f6\u95f4\u63a2\u7d22\u4e00\u4e0b\u6cb3\u5cb8\u3002\u867d\u7136\u8fd9\u6837\u5e94\u8be5\u4e5f\u627e\u4e0d\u5230\u4ec0\u4e48\u4e1c\u897f\uff0c\u4f46\u81f3\u5c11\u4e0d\u5fc5\u6765\u56de\u5954\u6ce2\u2026\u2026"){

                    @Override
                    public int getSecondsPassed() {
                        return 1800;
                    }

                    @Override
                    public void effects() {
                        DialogueNode dn = Main.game.getActiveWorld().getCell(Main.game.getPlayer().getLocation()).getDialogue(true, true);
                        Main.game.setContent(new Response("", "", dn));
                    }
                };
            }
            return null;
        }
    };
    public static final DialogueNode ELIS = new DialogueNode("\u4f0a\u5229\u65af", "", false){

        @Override
        public int getSecondsPassed() {
            return 1800;
        }

        @Override
        public String getContent() {
            StringBuilder sb = new StringBuilder();
            sb.append(UtilText.parseFromXMLFile("places/global/globalPlaces", "ELIS"));
            sb.append(FieldsDialogue.getUnavailableAreaText());
            return sb.toString();
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1) {
                return new Response("\u4ece\u6b63\u95e8\u800c\u5165", "\u4ece\u4e1c\u9762\u63a5\u8fd1\u4f0a\u5229\u65af\uff0c\u8fd9\u6837\u5c31\u53ef\u4ee5\u901a\u8fc7\u4e3b\u95e8\u697c\u8fdb\u5165\u5c0f\u9547\u3002", DialogueManager.getDialogueFromId("innoxia_places_fields_elis_generic_road_east")){

                    @Override
                    public void effects() {
                        Main.game.getPlayer().setLocation(WorldType.getWorldTypeFromId("innoxia_fields_elis_town"), PlaceType.getPlaceTypeFromId("innoxia_fields_elis_town_entry_east"));
                        Main.game.getPlayer().setNearestLocation(WorldType.getWorldTypeFromId("innoxia_fields_elis_town"), PlaceType.getPlaceTypeFromId("innoxia_fields_elis_town_road_east"));
                        Main.game.appendToTextStartStringBuilder(UtilText.parseFromXMLFile("places/fields/elis/generic", "ENTER_ELIS"));
                    }

                    @Override
                    public boolean isStripContent() {
                        return true;
                    }
                };
            }
            if (index == 2) {
                return new Response("\u4ece\u540e\u95e8\u800c\u5165", "\u4ece\u897f\u9762\u63a5\u8fd1\u4f0a\u5229\u65af\uff0c\u8fd9\u6837\u5c31\u53ef\u4ee5\u4ece\u5176\u540e\u95e8\u697c\u8fdb\u5165\u5c0f\u9547\u3002", DialogueManager.getDialogueFromId("innoxia_places_fields_elis_generic_road_west")){

                    @Override
                    public void effects() {
                        Main.game.getPlayer().setLocation(WorldType.getWorldTypeFromId("innoxia_fields_elis_town"), PlaceType.getPlaceTypeFromId("innoxia_fields_elis_town_entry_west"));
                        Main.game.getPlayer().setNearestLocation(WorldType.getWorldTypeFromId("innoxia_fields_elis_town"), PlaceType.getPlaceTypeFromId("innoxia_fields_elis_town_road_west"));
                        Main.game.appendToTextStartStringBuilder(UtilText.parseFromXMLFile("places/fields/elis/generic", "ENTER_ELIS"));
                    }

                    @Override
                    public boolean isStripContent() {
                        return true;
                    }
                };
            }
            return null;
        }
    };

    private static String getUnavailableAreaText() {
        Vector2i playerLoc = Main.game.getPlayer().getLocation();
        HashMap<Bearing, Cell> dirMap = new HashMap<Bearing, Cell>();
        dirMap.put(Bearing.NORTH, Main.game.getWorlds().get(WorldType.WORLD_MAP).getCell(playerLoc.getX(), playerLoc.getY() + 1));
        dirMap.put(Bearing.EAST, Main.game.getWorlds().get(WorldType.WORLD_MAP).getCell(playerLoc.getX() + 1, playerLoc.getY()));
        dirMap.put(Bearing.SOUTH, Main.game.getWorlds().get(WorldType.WORLD_MAP).getCell(playerLoc.getX(), playerLoc.getY() - 1));
        dirMap.put(Bearing.WEST, Main.game.getWorlds().get(WorldType.WORLD_MAP).getCell(playerLoc.getX() - 1, playerLoc.getY()));
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : dirMap.entrySet()) {
            if (entry.getValue() == null || ((Cell)entry.getValue()).getDialogue(false) != null) continue;
            if (sb.length() > 0) {
                sb.append("<br/>");
            } else {
                sb.append("<p style='text-align:center;'>[style.boldBad(\u65c5\u884c\u53d7\u9650)]<br/>[style.italicsMinorBad(");
            }
            sb.append("\u4f60\u73b0\u5728\u65e0\u6cd5\u4ece<b>" + ((Bearing)((Object)entry.getKey())).getName() + "</b>\u65c5\u884c\u5230" + ((Cell)entry.getValue()).getPlace().getName() + "\uff01");
        }
        if (sb.length() > 0) {
            sb.append(")]</p>");
        }
        return sb.toString();
    }
}

