/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.dialogue.places.submission;

import com.lilithsthrone.game.character.effects.Perk;
import com.lilithsthrone.game.character.quests.Quest;
import com.lilithsthrone.game.character.quests.QuestLine;
import com.lilithsthrone.game.dialogue.DialogueFlagValue;
import com.lilithsthrone.game.dialogue.DialogueNode;
import com.lilithsthrone.game.dialogue.encounters.AbstractEncounter;
import com.lilithsthrone.game.dialogue.encounters.BatCavernsEncounterDialogue;
import com.lilithsthrone.game.dialogue.npcDialogue.dominion.WesQuest;
import com.lilithsthrone.game.dialogue.places.dominion.DominionPlaces;
import com.lilithsthrone.game.dialogue.responses.Response;
import com.lilithsthrone.game.dialogue.responses.ResponseEffectsOnly;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.utils.Util;
import com.lilithsthrone.utils.Vector2i;
import com.lilithsthrone.world.Cell;
import com.lilithsthrone.world.WorldType;
import com.lilithsthrone.world.places.PlaceType;
import java.time.DayOfWeek;

public class BatCaverns {
    public static final DialogueNode STAIRCASE = new DialogueNode("\u65cb\u8f6c\u697c\u68af", "", false){

        @Override
        public int getSecondsPassed() {
            return 300;
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("places/submission/batCaverns", "STAIRCASE");
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1) {
                return new Response("\u5c48\u57ce\u533a", "\u56de\u5230\u5c48\u57ce\u533a\u3002", PlaceType.SUBMISSION_BAT_CAVERNS.getDialogue(false)){

                    @Override
                    public void effects() {
                        Main.game.getPlayer().setLocation(WorldType.SUBMISSION, PlaceType.SUBMISSION_BAT_CAVERNS, false);
                    }
                };
            }
            return null;
        }
    };
    public static final DialogueNode SHAFT = new DialogueNode("", "", false){

        @Override
        public int getSecondsPassed() {
            return 300;
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("places/submission/batCaverns", "SHAFT");
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1) {
                if (Main.game.getPlayer().isAbleToFly()) {
                    if (!Main.game.getPlayer().isPartyAbleToFly()) {
                        return new Response("\u5fa1\u57ce\u533a", "\u7531\u4e8e\u4f60\u7684\u961f\u4f0d\u6210\u5458\u65e0\u6cd5\u98de\u884c\uff0c\u6240\u4ee5\u4e0d\u80fd\u4f7f\u7528\u8fd9\u53e3\u7ad6\u4e95\u56de\u5230\u5fa1\u57ce\u533a\u2026\u2026", null);
                    }
                    return new Response("\u5fa1\u57ce\u533a", "\u98de\u4e0a\u7ad6\u4e95\uff0c\u56de\u5230\u5fa1\u57ce\u533a\u3002", SHAFT_FLY_UP){

                        @Override
                        public void effects() {
                            if (Main.game.getWorlds().get(WorldType.DOMINION).getCell(PlaceType.DOMINION_EXIT_TO_BAT_CAVERNS) == null) {
                                Cell referenceCell = Main.game.getWorlds().get(WorldType.DOMINION).getCell(PlaceType.DOMINION_WAREHOUSES);
                                Cell shaftCell = Main.game.getWorlds().get(WorldType.DOMINION).getCell(new Vector2i(referenceCell.getLocation().getX() + 2, referenceCell.getLocation().getY()));
                                shaftCell.getPlace().setPlaceType(PlaceType.DOMINION_EXIT_TO_BAT_CAVERNS);
                                shaftCell.getPlace().setName(PlaceType.BAT_CAVERN_SHAFT.getName());
                                Main.game.getTextStartStringBuilder().append(UtilText.parseFromXMLFile("places/submission/batCaverns", "SHAFT_FLY_UP_FIRST_TIME"));
                            } else {
                                Main.game.getTextStartStringBuilder().append(UtilText.parseFromXMLFile("places/submission/batCaverns", "SHAFT_FLY_UP"));
                            }
                            Main.game.getPlayer().setLocation(WorldType.DOMINION, PlaceType.DOMINION_EXIT_TO_BAT_CAVERNS, false);
                        }
                    };
                }
                return new Response("\u5fa1\u57ce\u533a", "\u7531\u4e8e\u4f60\u65e0\u6cd5\u98de\u884c\uff0c\u6240\u4ee5\u4e0d\u80fd\u4f7f\u7528\u8fd9\u53e3\u7ad6\u4e95\u56de\u5230\u5fa1\u57ce\u533a\u2026\u2026", null);
            }
            return null;
        }
    };
    public static final DialogueNode SHAFT_FLY_UP = new DialogueNode("", "", false){

        @Override
        public int getSecondsPassed() {
            return 180;
        }

        @Override
        public String getContent() {
            return "";
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            return DominionPlaces.CITY_EXIT_BAT_CAVERNS.getResponse(responseTab, index);
        }
    };
    public static final DialogueNode CAVERN_DARK = new DialogueNode("\u9634\u6697\u6d1e\u7a9f", "", false){

        @Override
        public String getAuthor() {
            return "Duner & Innoxia";
        }

        @Override
        public int getSecondsPassed() {
            return 300;
        }

        @Override
        public String getContent() {
            StringBuilder sb = new StringBuilder();
            sb.append(UtilText.parseFromXMLFile("places/submission/batCaverns", "CAVERN_DARK"));
            Main.game.getNonCompanionCharactersPresent().forEach(npc -> sb.append(npc.getPresentInTileDescription(false)));
            return sb.toString();
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1) {
                return AbstractEncounter.exploreArea("\u9634\u6697\u7684\u6d1e\u7a9f\u6df1\u5904");
            }
            if (index == 2) {
                return AbstractEncounter.useOffspringMap();
            }
            if (index == 3) {
                return BatCaverns.getElleSearchResponse();
            }
            if (index == 4 && (Main.game.getPlayer().getQuest(QuestLine.SIDE_REBEL_BASE) == Quest.REBEL_BASE_PASSWORD_PART_ONE || Main.game.getPlayer().getQuest(QuestLine.SIDE_REBEL_BASE) == Quest.REBEL_BASE_PASSWORD_PART_TWO)) {
                if (!Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.rebelBaseDarkPassFound)) {
                    if (Util.random.nextInt(100) <= 20 + (Main.game.getPlayer().hasTraitActivated(Perk.OBSERVANT) ? 30 : 0)) {
                        if (Main.game.getPlayer().isQuestProgressLessThan(QuestLine.SIDE_REBEL_BASE, Quest.REBEL_BASE_PASSWORD_PART_TWO)) {
                            return new Response("\u641c\u5bfb\u5bc6\u7801", "\u5411\u9ed1\u6697\u4e2d\u7aa5\u63a2\uff0c\u52aa\u529b\u5bfb\u627e\u795e\u79d8\u901a\u9053\u7684\u5bc6\u7801\u3002", BatCavernsEncounterDialogue.REBEL_BASE_PASSWORD_ONE);
                        }
                        return new Response("\u641c\u5bfb\u5bc6\u7801", "\u5411\u9ed1\u6697\u4e2d\u7aa5\u63a2\uff0c\u52aa\u529b\u5bfb\u627e\u795e\u79d8\u901a\u9053\u5269\u4e0b\u7684\u5bc6\u7801\u3002", BatCavernsEncounterDialogue.REBEL_BASE_PASSWORD_TWO);
                    }
                    return new Response("\u641c\u5bfb\u5bc6\u7801", "\u5411\u9ed1\u6697\u4e2d\u7aa5\u63a2\uff0c\u52aa\u529b\u5bfb\u627e\u795e\u79d8\u901a\u9053\u7684\u5bc6\u7801\u3002", BatCavernsEncounterDialogue.REBEL_BASE_PASSWORD_SEARCH_FAILED);
                }
                return new Response("\u641c\u5bfb\u5bc6\u7801", "\u4f60\u5df2\u7ecf\u627e\u5230\u6b64\u533a\u57df\u7684\u5bc6\u7801\u4e86\u3002", null);
            }
            if (index == 5 && Main.game.isSillyMode() && (Main.game.getPlayer().getQuest(QuestLine.SIDE_REBEL_BASE) == Quest.REBEL_BASE_PASSWORD_PART_ONE || Main.game.getPlayer().getQuest(QuestLine.SIDE_REBEL_BASE) == Quest.REBEL_BASE_PASSWORD_PART_TWO)) {
                return new Response("\u6211\u53ef\u662f\u4e2a\u5927\u5fd9\u4eba\uff01", "\u7b80\u76f4\u662f\u6d6a\u8d39\u65f6\u95f4\u3002<br/>[style.boldBad(\u8fd9\u5c06\u4f1a\u8df3\u8fc7\u201c\u6478\u91d1\u6821\u5c09\u201d\u7684\u6240\u6709\u5185\u5bb9\u548c\u5956\u52b1\uff01)]", BatCavernsEncounterDialogue.REBEL_BASE_PASSWORD_SILLY);
            }
            return null;
        }
    };
    public static final DialogueNode CAVERN_LIGHT = new DialogueNode("\u751f\u7269\u5fae\u5149\u7167\u4eae\u7684\u6d1e\u7a9f", "", false){

        @Override
        public String getAuthor() {
            return "Duner & Innoxia";
        }

        @Override
        public int getSecondsPassed() {
            return 300;
        }

        @Override
        public String getContent() {
            StringBuilder sb = new StringBuilder();
            sb.append(UtilText.parseFromXMLFile("places/submission/batCaverns", "CAVERN_LIGHT"));
            Main.game.getNonCompanionCharactersPresent().forEach(npc -> sb.append(npc.getPresentInTileDescription(false)));
            return sb.toString();
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1) {
                return AbstractEncounter.exploreArea("\u8367\u5149\u68ee\u6797");
            }
            if (index == 2) {
                return AbstractEncounter.useOffspringMap();
            }
            if (index == 3) {
                return BatCaverns.getElleSearchResponse();
            }
            if (index == 4 && (Main.game.getPlayer().getQuest(QuestLine.SIDE_REBEL_BASE) == Quest.REBEL_BASE_PASSWORD_PART_ONE || Main.game.getPlayer().getQuest(QuestLine.SIDE_REBEL_BASE) == Quest.REBEL_BASE_PASSWORD_PART_TWO)) {
                if (!Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.rebelBaseLightPassFound)) {
                    if (Util.random.nextInt(100) <= 20 + (Main.game.getPlayer().hasTraitActivated(Perk.OBSERVANT) ? 30 : 0)) {
                        if (Main.game.getPlayer().isQuestProgressLessThan(QuestLine.SIDE_REBEL_BASE, Quest.REBEL_BASE_PASSWORD_PART_TWO)) {
                            return new Response("\u641c\u5bfb\u5bc6\u7801", "\u62e8\u5f00\u8611\u83c7\u4e1b\uff0c\u52aa\u529b\u5bfb\u627e\u795e\u79d8\u901a\u9053\u7684\u5bc6\u7801\u3002", BatCavernsEncounterDialogue.REBEL_BASE_PASSWORD_ONE);
                        }
                        return new Response("\u641c\u5bfb\u5bc6\u7801", "\u62e8\u5f00\u8611\u83c7\u4e1b\uff0c\u52aa\u529b\u5bfb\u627e\u795e\u79d8\u901a\u9053\u5269\u4e0b\u7684\u5bc6\u7801\u3002", BatCavernsEncounterDialogue.REBEL_BASE_PASSWORD_TWO);
                    }
                    return new Response("\u641c\u5bfb\u5bc6\u7801", "\u62e8\u5f00\u8611\u83c7\u4e1b\uff0c\u52aa\u529b\u5bfb\u627e\u795e\u79d8\u901a\u9053\u7684\u5bc6\u7801\u3002", BatCavernsEncounterDialogue.REBEL_BASE_PASSWORD_SEARCH_FAILED);
                }
                return new Response("\u641c\u5bfb\u5bc6\u7801", "\u4f60\u5df2\u7ecf\u627e\u5230\u6b64\u533a\u57df\u7684\u5bc6\u7801\u4e86\u3002", null);
            }
            if (index == 5 && Main.game.isSillyMode() && (Main.game.getPlayer().getQuest(QuestLine.SIDE_REBEL_BASE) == Quest.REBEL_BASE_PASSWORD_PART_ONE || Main.game.getPlayer().getQuest(QuestLine.SIDE_REBEL_BASE) == Quest.REBEL_BASE_PASSWORD_PART_TWO)) {
                return new Response("\u6211\u53ef\u662f\u4e2a\u5927\u5fd9\u4eba\uff01", "\u7b80\u76f4\u662f\u6d6a\u8d39\u65f6\u95f4\u3002<br/>[style.boldBad(\u8fd9\u5c06\u4f1a\u8df3\u8fc7\u201c\u6478\u91d1\u6821\u5c09\u201d\u7684\u6240\u6709\u5185\u5bb9\u548c\u5956\u52b1\uff01)]", BatCavernsEncounterDialogue.REBEL_BASE_PASSWORD_SILLY);
            }
            return null;
        }
    };
    public static final DialogueNode RIVER = new DialogueNode("\u5730\u4e0b\u6cb3", "", false){

        @Override
        public int getSecondsPassed() {
            return 300;
        }

        @Override
        public String getContent() {
            StringBuilder sb = new StringBuilder();
            sb.append(UtilText.parseFromXMLFile("places/submission/batCaverns", "RIVER"));
            Main.game.getNonCompanionCharactersPresent().forEach(npc -> sb.append(npc.getPresentInTileDescription(false)));
            return sb.toString();
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1) {
                return AbstractEncounter.exploreArea("\u6cb3\u8fb9");
            }
            if (index == 2) {
                return AbstractEncounter.useOffspringMap();
            }
            if (index == 3) {
                return BatCaverns.getElleSearchResponse();
            }
            return null;
        }
    };
    public static final DialogueNode RIVER_BRIDGE = new DialogueNode("\u8611\u83c7\u6865", "", false){

        @Override
        public int getSecondsPassed() {
            return 300;
        }

        @Override
        public String getContent() {
            StringBuilder sb = new StringBuilder();
            sb.append(UtilText.parseFromXMLFile("places/submission/batCaverns", "RIVER_BRIDGE"));
            Main.game.getNonCompanionCharactersPresent().forEach(npc -> sb.append(npc.getPresentInTileDescription(false)));
            return sb.toString();
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1) {
                return AbstractEncounter.exploreArea("\u6865\u6881\u5468\u8fb9");
            }
            if (index == 2) {
                return AbstractEncounter.useOffspringMap();
            }
            if (index == 3) {
                return BatCaverns.getElleSearchResponse();
            }
            return null;
        }
    };
    public static final DialogueNode RIVER_END = new DialogueNode("\u5730\u4e0b\u6cb3", "", false){

        @Override
        public int getSecondsPassed() {
            return 300;
        }

        @Override
        public String getContent() {
            StringBuilder sb = new StringBuilder();
            sb.append(UtilText.parseFromXMLFile("places/submission/batCaverns", "RIVER_END"));
            Main.game.getNonCompanionCharactersPresent().forEach(npc -> sb.append(npc.getPresentInTileDescription(false)));
            return sb.toString();
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1) {
                return AbstractEncounter.exploreArea("\u6cb3\u8fb9");
            }
            if (index == 2) {
                return AbstractEncounter.useOffspringMap();
            }
            if (index == 3) {
                return BatCaverns.getElleSearchResponse();
            }
            return null;
        }
    };
    public static final DialogueNode SLIME_LAKE = new DialogueNode("\u53f2\u83b1\u59c6\u6e56", "", false){

        @Override
        public int getSecondsPassed() {
            return 300;
        }

        @Override
        public String getContent() {
            UtilText.nodeContentSB.setLength(0);
            UtilText.nodeContentSB.append(UtilText.parseFromXMLFile("places/submission/batCaverns", "SLIME_LAKE"));
            if (!Main.game.getPlayer().hasQuest(QuestLine.SIDE_SLIME_QUEEN)) {
                UtilText.nodeContentSB.append(UtilText.parseFromXMLFile("places/submission/batCaverns", "SLIME_LAKE_QUEEN_UNKNOWN"));
            } else if (Main.game.getPlayer().isQuestProgressGreaterThan(QuestLine.SIDE_SLIME_QUEEN, Quest.SLIME_QUEEN_THREE)) {
                UtilText.nodeContentSB.append(UtilText.parseFromXMLFile("places/submission/batCaverns", "SLIME_LAKE_QUEEN_KNOWLEDGE"));
            } else if (Main.game.getPlayer().isQuestProgressGreaterThan(QuestLine.SIDE_SLIME_QUEEN, Quest.SLIME_QUEEN_TWO)) {
                UtilText.nodeContentSB.append(UtilText.parseFromXMLFile("places/submission/batCaverns", "SLIME_LAKE_QUEEN_GUESS"));
            }
            Main.game.getNonCompanionCharactersPresent().forEach(npc -> UtilText.nodeContentSB.append(npc.getPresentInTileDescription(false)));
            return UtilText.nodeContentSB.toString();
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1) {
                return AbstractEncounter.exploreArea("\u6e56\u8fb9");
            }
            if (index == 2) {
                return AbstractEncounter.useOffspringMap();
            }
            if (index == 3 && Main.game.getPlayer().isQuestProgressGreaterThan(QuestLine.SIDE_SLIME_QUEEN, Quest.SLIME_QUEEN_TWO)) {
                return new Response("\u6446\u6e21\u4e0a\u5c9b", "\u4f60\u53ef\u4ee5\u7528\u8239\u7a7f\u8fc7\u6e56\u9762\uff0c\u5230\u8fbe\u5c9b\u4e0a\u3002", SLIME_LAKE_ISLAND){

                    @Override
                    public void effects() {
                        Main.game.getTextStartStringBuilder().append(UtilText.parseFromXMLFile("places/submission/batCaverns", "SLIME_LAKE_BOAT"));
                        if (Main.game.getPlayer().isQuestCompleted(QuestLine.SIDE_SLIME_QUEEN)) {
                            Main.game.getTextStartStringBuilder().append(UtilText.parseFromXMLFile("places/submission/batCaverns", "SLIME_LAKE_PACIFIED"));
                        } else {
                            Main.game.getTextStartStringBuilder().append(UtilText.parseFromXMLFile("places/submission/batCaverns", "SLIME_LAKE_READY_FIGHT"));
                        }
                    }
                };
            }
            if (index == 4 && Main.game.getPlayer().isQuestProgressGreaterThan(QuestLine.SIDE_SLIME_QUEEN, Quest.SLIME_QUEEN_TWO)) {
                if (Main.game.getPlayer().isAbleToFly()) {
                    return new Response("\u98de\u4e0a\u5c9b", "\u98de\u5230\u5c9b\u4e0a\u3002", SLIME_LAKE_ISLAND){

                        @Override
                        public void effects() {
                            Main.game.getTextStartStringBuilder().append(UtilText.parseFromXMLFile("places/submission/batCaverns", "SLIME_LAKE_FLY"));
                            if (Main.game.getPlayer().isQuestCompleted(QuestLine.SIDE_SLIME_QUEEN)) {
                                Main.game.getTextStartStringBuilder().append(UtilText.parseFromXMLFile("places/submission/batCaverns", "SLIME_LAKE_PACIFIED"));
                            } else {
                                Main.game.getTextStartStringBuilder().append(UtilText.parseFromXMLFile("places/submission/batCaverns", "SLIME_LAKE_READY_FIGHT"));
                            }
                        }
                    };
                }
                return new Response("\u98de\u4e0a\u5c9b", "\u4f60\u65e0\u6cd5\u98de\u884c\u3002\u770b\u6837\u5b50\u4f60\u5f97\u7528\u8239\u4e86\u2026\u2026", null);
            }
            return null;
        }
    };
    public static final DialogueNode SLIME_LAKE_ISLAND = new DialogueNode("\u53f2\u83b1\u59c6\u6e56", "", true){

        @Override
        public int getSecondsPassed() {
            return 300;
        }

        @Override
        public String getContent() {
            return "";
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1) {
                return new Response("\u63a2\u7d22", "\u4f60\u9700\u8981\u5230\u6e56\u7684\u53e6\u4e00\u8fb9\u624d\u80fd\u63a2\u7d22\u8be5\u533a\u57df\uff01", null);
            }
            if (index == 2 && Main.game.getPlayer().isQuestProgressGreaterThan(QuestLine.SIDE_SLIME_QUEEN, Quest.SLIME_QUEEN_TWO)) {
                return new Response("\u6446\u6e21\u8fd4\u56de", "\u7528\u8239\u8fd4\u56de\u6e56\u7684\u53e6\u4e00\u8fb9\u3002", SLIME_LAKE){

                    @Override
                    public void effects() {
                        Main.game.getTextStartStringBuilder().append(UtilText.parseFromXMLFile("places/submission/batCaverns", "SLIME_LAKE_BOAT_RETURN"));
                    }
                };
            }
            if (index == 3 && Main.game.getPlayer().isQuestProgressGreaterThan(QuestLine.SIDE_SLIME_QUEEN, Quest.SLIME_QUEEN_TWO)) {
                if (Main.game.getPlayer().isAbleToFly()) {
                    return new Response("\u98de\u56de\u53bb", "\u98de\u5230\u6e56\u7684\u53e6\u4e00\u8fb9\u3002", SLIME_LAKE){

                        @Override
                        public void effects() {
                            Main.game.getTextStartStringBuilder().append(UtilText.parseFromXMLFile("places/submission/batCaverns", "SLIME_LAKE_FLY_RETURN"));
                        }
                    };
                }
                return new Response("\u98de\u56de\u53bb", "\u4f60\u65e0\u6cd5\u98de\u884c\u3002\u770b\u6837\u5b50\u4f60\u5f97\u7528\u8239\u4e86\u2026\u2026", null);
            }
            if (index == 4) {
                return new ResponseEffectsOnly("\u5f00\u95e8", "\u63a8\u5f00\u9ad8\u5854\u7684\u6b63\u95e8\uff0c\u7136\u540e\u8fdb\u5165\u5176\u4e2d\u3002"){

                    @Override
                    public void effects() {
                        Main.game.getPlayer().setLocation(WorldType.SLIME_QUEENS_LAIR_GROUND_FLOOR, PlaceType.SLIME_QUEENS_LAIR_ENTRANCE);
                        Main.game.getTextStartStringBuilder().append("<p>\u4f60\u8d70\u5230\u77f3\u5236\u9ad8\u5854\u7684\u5e95\u90e8\uff0c\u5c06[pc.hand]\u653e\u5728\u94c1\u6805\u88c5\u9970\u7684\u6a61\u6728\u5927\u95e8\u4e0a\uff0c\u7528\u529b\u4e00\u63a8\uff0c\u4fbf\u5c06\u5176\u63a8\u5f00\uff0c\u8d70\u4e86\u8fdb\u53bb\u3002</p>");
                        if (Main.game.getPlayer().isQuestProgressLessThan(QuestLine.SIDE_SLIME_QUEEN, Quest.SLIME_QUEEN_FOUR)) {
                            Main.game.getTextEndStringBuilder().append(Main.game.getPlayer().setQuestProgress(QuestLine.SIDE_SLIME_QUEEN, Quest.SLIME_QUEEN_FOUR));
                        }
                        Main.game.setContent(new Response("", "", Main.game.getDefaultDialogue(false)));
                    }
                };
            }
            return null;
        }
    };
    public static final DialogueNode REBEL_BASE_ENTRANCE_HANDLE = new DialogueNode("\u5947\u602a\u7684\u62c9\u6746", "", false){

        @Override
        public String getAuthor() {
            return "DSG";
        }

        @Override
        public int getSecondsPassed() {
            return 30;
        }

        @Override
        public String getContent() {
            StringBuilder sb = new StringBuilder();
            sb.append(CAVERN_DARK.getContent());
            sb.append(UtilText.parseFromXMLFile("places/submission/batCaverns", "REBEL_BASE_ENTRANCE_HANDLE"));
            return sb.toString();
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1) {
                if (Main.game.getPlayer().isQuestProgressLessThan(QuestLine.SIDE_REBEL_BASE, Quest.REBEL_BASE_PASSWORD_PART_ONE)) {
                    return new Response("\u62c9\u52a8\u62c9\u6746", "\u80fd\u6709\u4ec0\u4e48\u95ee\u9898\u5462\uff1f", BatCavernsEncounterDialogue.REBEL_BASE_DOOR_NO_PASS);
                }
                if (Main.game.getPlayer().isQuestProgressLessThan(QuestLine.SIDE_REBEL_BASE, Quest.REBEL_BASE_PASSWORD_PART_TWO)) {
                    return new Response("\u62c9\u52a8\u62c9\u6746", "\u62c9\u6746\u7eb9\u4e1d\u4e0d\u52a8\uff0c\u770b\u6765\u4f60\u9700\u8981\u4e2a\u5bc6\u7801\u3002", null);
                }
                if (Main.game.getPlayer().isQuestProgressLessThan(QuestLine.SIDE_REBEL_BASE, Quest.REBEL_BASE_PASSWORD_COMPLETE)) {
                    return new Response("\u62c9\u52a8\u62c9\u6746", "\u4f60\u8fd8\u6ca1\u6709\u5b8c\u6574\u7684\u5bc6\u7801\uff01", null);
                }
                if (Main.game.getPlayer().isQuestProgressLessThan(QuestLine.SIDE_REBEL_BASE, Quest.REBEL_BASE_EXPLORATION)) {
                    return new Response("\u62c9\u52a8\u62c9\u6746", "\u4f60\u5df2\u7ecf\u62e5\u6709\u5b8c\u6574\u7684\u5bc6\u7801\uff0c\u53ef\u4ee5\u518d\u6b21\u62c9\u52a8\u62c9\u6746\u4e86\u2026\u2026\u5982\u679c\u4f60\u613f\u610f\u7684\u8bdd\u3002", REBEL_BASE_DOOR_OPENED){

                        @Override
                        public void effects() {
                            Main.game.getPlayerCell().getPlace().setPlaceType(PlaceType.BAT_CAVERNS_REBEL_BASE_ENTRANCE_EXTERIOR);
                            Main.game.getPlayerCell().getPlace().setName(PlaceType.BAT_CAVERNS_REBEL_BASE_ENTRANCE_EXTERIOR.getName());
                        }
                    };
                }
            } else {
                return CAVERN_DARK.getResponse(responseTab, index - 1);
            }
            return null;
        }
    };
    public static final DialogueNode REBEL_BASE_DOOR_OPENED = new DialogueNode("\u9690\u85cf\u901a\u9053", "", true){

        @Override
        public void applyPreParsingEffects() {
            Main.game.getPlayerCell().getPlace().setPlaceType(PlaceType.BAT_CAVERNS_REBEL_BASE_ENTRANCE_EXTERIOR);
            Main.game.getPlayerCell().getPlace().setName(PlaceType.BAT_CAVERNS_REBEL_BASE_ENTRANCE_EXTERIOR.getName());
        }

        @Override
        public String getAuthor() {
            return "DSG";
        }

        @Override
        public int getSecondsPassed() {
            return 30;
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("places/submission/batCaverns", "REBEL_BASE_DOOR_OPENED");
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1) {
                return new Response("\u8fdb\u5165", "\u8fd9\u4e2a\u6d1e\u7a74\u4e0d\u662f\u81ea\u7136\u5f62\u6210\u7684\uff0c\u800c\u662f\u4eba\u5de5\u5f00\u51ff\u7684\uff0c\u6240\u4ee5\u5b83\u4e00\u5b9a\u901a\u5411\u67d0\u4e2a\u5730\u65b9\u3002", PlaceType.REBEL_BASE_ENTRANCE.getDialogue(false)){

                    @Override
                    public void effects() {
                        Main.game.getTextEndStringBuilder().append(Main.game.getPlayer().setQuestProgress(QuestLine.SIDE_REBEL_BASE, Quest.REBEL_BASE_EXPLORATION));
                        Main.game.getPlayer().setLocation(WorldType.REBEL_BASE, PlaceType.REBEL_BASE_ENTRANCE);
                    }
                };
            }
            if (index == 2) {
                return new Response("\u4e0d\u8981\u8fdb\u5165", "\u9b3c\u77e5\u9053\u6d1e\u91cc\u6709\u4ec0\u4e48\u2026\u2026", Main.game.getDefaultDialogue(false));
            }
            return null;
        }
    };
    public static final DialogueNode REBEL_BASE_ENTRANCE_EXTERIOR = new DialogueNode("\u9690\u85cf\u6d1e\u7a74", "", false){

        @Override
        public String getAuthor() {
            return "DSG";
        }

        @Override
        public int getSecondsPassed() {
            return 30;
        }

        @Override
        public String getContent() {
            StringBuilder sb = new StringBuilder();
            sb.append(CAVERN_DARK.getContent());
            if (Main.game.getPlayer().isQuestFailed(QuestLine.SIDE_REBEL_BASE) || Main.game.getPlayer().isQuestCompleted(QuestLine.SIDE_REBEL_BASE)) {
                sb.append(UtilText.parseFromXMLFile("places/submission/batCaverns", "REBEL_BASE_ENTRANCE_EXTERIOR_COLLAPSED"));
            } else {
                sb.append(UtilText.parseFromXMLFile("places/submission/batCaverns", "REBEL_BASE_ENTRANCE_EXTERIOR"));
            }
            return sb.toString();
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (!Main.game.getPlayer().isQuestFailed(QuestLine.SIDE_REBEL_BASE) && !Main.game.getPlayer().isQuestProgressGreaterThan(QuestLine.SIDE_REBEL_BASE, Quest.REBEL_BASE_EXPLORATION)) {
                if (index == 1) {
                    return new Response("\u8fdb\u5165", "\u8fd9\u4e2a\u6d1e\u7a74\u4e0d\u662f\u81ea\u7136\u5f62\u6210\u7684\uff0c\u800c\u662f\u4eba\u5de5\u5f00\u51ff\u7684\uff0c\u6240\u4ee5\u5b83\u4e00\u5b9a\u901a\u5411\u67d0\u4e2a\u5730\u65b9\u3002", PlaceType.REBEL_BASE_ENTRANCE.getDialogue(false)){

                        @Override
                        public void effects() {
                            Main.game.getTextEndStringBuilder().append(Main.game.getPlayer().setQuestProgress(QuestLine.SIDE_REBEL_BASE, Quest.REBEL_BASE_EXPLORATION));
                            Main.game.getPlayer().setLocation(WorldType.REBEL_BASE, PlaceType.REBEL_BASE_ENTRANCE);
                        }
                    };
                }
            } else {
                return CAVERN_DARK.getResponse(responseTab, index);
            }
            return null;
        }
    };

    private static Response getElleSearchResponse() {
        if (Main.game.getPlayer().getQuest(QuestLine.SIDE_WES) == Quest.WES_1) {
            if (Main.game.getDayOfWeek() != DayOfWeek.WEDNESDAY || Main.game.getHourOfDay() < 12 || Main.game.getHourOfDay() >= 15) {
                return new Response("\u5bfb\u627e\u57c3\u52d2", "\u5982\u679c\u60f3\u627e\u5230\u827e\u52d2\uff0c\u5fc5\u987b\u5728" + (Main.game.getDayOfWeek() != DayOfWeek.WEDNESDAY ? "[style.italicsBad(\u661f\u671f\u4e09)]" : "[style.italicsGood(\u661f\u671f\u4e09)]") + "\u7684" + (Main.game.getHourOfDay() < 12 || Main.game.getHourOfDay() >= 15 ? "[style.italicsBad([units.time(12)]-[units.time(15)])]" : "[style.italicsGood([units.time(12)]-[units.time(15)])]") + "\uff01", null);
            }
            return new Response("\u5bfb\u627e\u57c3\u52d2", "\u5f00\u59cb\u5728\u8759\u8760\u6d1e\u7a9f\u6b64\u5904\u5bfb\u627e\u57c3\u52d2\u7684\u75d5\u8ff9\u2026\u2026", WesQuest.ELLE_SEARCH);
        }
        return null;
    }
}

