/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.dialogue.places.submission;

import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.PlayerCharacter;
import com.lilithsthrone.game.character.gender.Gender;
import com.lilithsthrone.game.character.npc.NPC;
import com.lilithsthrone.game.character.npc.submission.Claire;
import com.lilithsthrone.game.character.npc.submission.DarkSiren;
import com.lilithsthrone.game.character.npc.submission.Elizabeth;
import com.lilithsthrone.game.character.npc.submission.FortressAlphaLeader;
import com.lilithsthrone.game.character.npc.submission.FortressFemalesLeader;
import com.lilithsthrone.game.character.npc.submission.FortressMalesLeader;
import com.lilithsthrone.game.character.npc.submission.GamblingDenPatron;
import com.lilithsthrone.game.character.npc.submission.HazmatRat;
import com.lilithsthrone.game.character.npc.submission.RatWarrensCaptive;
import com.lilithsthrone.game.character.persona.Occupation;
import com.lilithsthrone.game.character.quests.Quest;
import com.lilithsthrone.game.character.quests.QuestLine;
import com.lilithsthrone.game.dialogue.DialogueFlagValue;
import com.lilithsthrone.game.dialogue.DialogueNode;
import com.lilithsthrone.game.dialogue.encounters.AbstractEncounter;
import com.lilithsthrone.game.dialogue.npcDialogue.dominion.WesQuest;
import com.lilithsthrone.game.dialogue.places.dominion.EnforcerWarehouse;
import com.lilithsthrone.game.dialogue.places.submission.dicePoker.DicePokerTable;
import com.lilithsthrone.game.dialogue.places.submission.gamblingDen.GamblingDenDialogue;
import com.lilithsthrone.game.dialogue.places.submission.impFortress.ImpCitadelDialogue;
import com.lilithsthrone.game.dialogue.places.submission.impFortress.ImpFortressDialogue;
import com.lilithsthrone.game.dialogue.places.submission.ratWarrens.RatWarrensDialogue;
import com.lilithsthrone.game.dialogue.responses.Response;
import com.lilithsthrone.game.dialogue.responses.ResponseEffectsOnly;
import com.lilithsthrone.game.dialogue.responses.ResponseSex;
import com.lilithsthrone.game.dialogue.responses.ResponseTrade;
import com.lilithsthrone.game.dialogue.story.LyssiethReveal;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.game.inventory.InventorySlot;
import com.lilithsthrone.game.inventory.clothing.ClothingType;
import com.lilithsthrone.game.inventory.item.ItemType;
import com.lilithsthrone.game.sex.managers.SexManagerDefault;
import com.lilithsthrone.game.sex.positions.SexPosition;
import com.lilithsthrone.game.sex.positions.slots.SexSlot;
import com.lilithsthrone.game.sex.positions.slots.SexSlotStanding;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.utils.Util;
import com.lilithsthrone.utils.Vector2i;
import com.lilithsthrone.utils.colours.Colour;
import com.lilithsthrone.utils.colours.PresetColour;
import com.lilithsthrone.world.WorldType;
import com.lilithsthrone.world.places.PlaceType;
import java.util.ArrayList;
import java.util.List;

public class SubmissionGenericPlaces {
    public static final DialogueNode WALKWAYS = new DialogueNode("\u901a\u9053", "", false){

        @Override
        public String getAuthor() {
            return "Duner & Innoxia";
        }

        @Override
        public int getSecondsPassed() {
            return 180;
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("places/submission/submissionPlaces", "WALKWAYS") + (Math.random() < (double)0.2f ? UtilText.parseFromXMLFile("places/submission/submissionPlaces", "WALKWAYS_EXTRA") : "");
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            return null;
        }
    };
    public static final DialogueNode TUNNEL = new DialogueNode("\u96a7\u9053", "", false){

        @Override
        public String getAuthor() {
            return "Duner";
        }

        @Override
        public int getSecondsPassed() {
            return 180;
        }

        @Override
        public String getContent() {
            UtilText.nodeContentSB.setLength(0);
            UtilText.nodeContentSB.append(UtilText.parseFromXMLFile("places/submission/submissionPlaces", "TUNNEL"));
            boolean pacified = true;
            if (Main.game.getPlayer().getLocationPlace().getPlaceType().equals(PlaceType.SUBMISSION_IMP_TUNNELS_ALPHA)) {
                pacified = Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.impFortressAlphaDefeated);
            }
            if (Main.game.getPlayer().getLocationPlace().getPlaceType().equals(PlaceType.SUBMISSION_IMP_TUNNELS_DEMON)) {
                pacified = Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.impFortressDemonDefeated);
            }
            if (Main.game.getPlayer().getLocationPlace().getPlaceType().equals(PlaceType.SUBMISSION_IMP_TUNNELS_FEMALES)) {
                pacified = Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.impFortressFemalesDefeated);
            }
            if (Main.game.getPlayer().getLocationPlace().getPlaceType().equals(PlaceType.SUBMISSION_IMP_TUNNELS_MALES)) {
                pacified = Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.impFortressMalesDefeated);
            }
            if (!pacified) {
                UtilText.nodeContentSB.append("<span style='color:" + Main.game.getPlayer().getLocationPlace().getPlaceType().getColour().toWebHexString() + ";'>" + UtilText.parseFromXMLFile("places/submission/submissionPlaces", "TUNNEL_IMP_CONTROL") + "</span>");
            }
            for (GameCharacter gameCharacter : Main.game.getCharactersTreatingCellAsHome(Main.game.getPlayerCell())) {
                UtilText.nodeContentSB.append(((NPC)gameCharacter).getPresentInTileDescription(!pacified));
            }
            return UtilText.nodeContentSB.toString();
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1) {
                return AbstractEncounter.exploreArea("\u96a7\u9053");
            }
            if (index == 2) {
                return AbstractEncounter.useOffspringMap();
            }
            return null;
        }
    };
    public static final DialogueNode BAT_CAVERNS = new DialogueNode("\u8759\u8760\u6d1e\u7a9f", "", false){

        @Override
        public int getSecondsPassed() {
            return 180;
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("places/submission/submissionPlaces", "BAT_CAVERNS");
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1) {
                return new Response("\u8759\u8760\u6d1e\u7a9f", "\u8fdb\u5165\u8759\u8760\u6d1e\u7a9f\u3002", PlaceType.BAT_CAVERN_ENTRANCE.getDialogue(false)){

                    @Override
                    public void effects() {
                        Main.game.getTextStartStringBuilder().append(UtilText.parseFromXMLFile("places/submission/submissionPlaces", "BAT_CAVERNS_ENTRY"));
                        Main.game.getPlayer().setLocation(WorldType.BAT_CAVERNS, PlaceType.BAT_CAVERN_ENTRANCE, false);
                    }
                };
            }
            return null;
        }
    };
    public static final DialogueNode RAT_WARREN = new DialogueNode("\u9f20\u7a9f", "", false){

        @Override
        public int getSecondsPassed() {
            return 180;
        }

        @Override
        public String getContent() {
            if (Main.game.getPlayer().isQuestCompleted(QuestLine.SIDE_VENGAR) || Main.game.getPlayer().getQuest(QuestLine.SIDE_VENGAR) == Quest.VENGAR_THREE_END) {
                return UtilText.parseFromXMLFile("places/submission/submissionPlaces", "RAT_WARREN_CLOSED");
            }
            return UtilText.parseFromXMLFile("places/submission/submissionPlaces", "RAT_WARREN");
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (!Main.game.getPlayer().isQuestCompleted(QuestLine.SIDE_VENGAR) && Main.game.getPlayer().getQuest(QuestLine.SIDE_VENGAR) != Quest.VENGAR_THREE_END && index == 1) {
                return new Response("\u6572\u6572", "\u6572\u95e8\uff0c\u770b\u662f\u5426\u6709\u4eba\u56de\u5e94\u3002", RAT_WARREN_KNOCK_ON_DOOR){

                    @Override
                    public void effects() {
                        RatWarrensDialogue.init();
                        Main.game.getPlayer().setLocation(WorldType.RAT_WARRENS, PlaceType.RAT_WARRENS_ENTRANCE);
                    }
                };
            }
            return null;
        }
    };
    public static final DialogueNode RAT_WARREN_KNOCK_ON_DOOR = new DialogueNode("\u9f20\u7a9f", "", true){

        @Override
        public int getSecondsPassed() {
            return 120;
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("places/submission/submissionPlaces", "RAT_WARREN_KNOCK_ON_DOOR", RatWarrensDialogue.getGuards(false));
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            boolean freeEntry;
            boolean bl = freeEntry = Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.ratWarrensEntry) || Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.ratWarrensEntryWhore);
            if (index == 1) {
                if (!Main.game.getPlayer().hasQuest(QuestLine.SIDE_VENGAR)) {
                    return new Response("\u8fdb\u5165", "\u4f60\u6ca1\u6709\u5408\u9002\u7684\u7406\u7531\u8fdb\u5165\u9f20\u7a9f\u2026\u2026", null);
                }
                if (freeEntry) {
                    return new Response("\u8fdb\u5165", "\u536b\u5175\u8ba4\u51fa\u4e86\u4f60\uff0c\u4f60\u53ef\u4ee5\u81ea\u7531\u8fdb\u5165\u9f20\u7a9f\u3002", RatWarrensDialogue.RAT_WARREN_INITIAL_ENTRY);
                }
                return new Response("\u89e3\u91ca", "\u544a\u8bc9\u5b88\u536b\u4f60\u662f\u4ee3\u8868\u963f\u514b\u585e\u5c14\u6765\u548c\u6587\u52a0\u8c08\u751f\u610f\u7684\u3002", RatWarrensDialogue.RAT_WARREN_INITIAL_ENTRY);
            }
            if (index == 2) {
                return new Response("\u9000\u5f00", freeEntry ? "\u51b3\u5b9a\u4e0d\u8fdb\u5165\u9f20\u7a9f\uff0c\u8fd4\u56de\u5927\u95e8\u3002" : "\u4f60\u5728\u8fd9\u91cc\u6ca1\u6709\u4efb\u4f55\u751f\u610f\u8981\u8c08\uff0c\u6240\u4ee5\u4f60\u4e0d\u80fd\u8fdb\u53bb\u3002\u6700\u597d\u5728\u5b88\u536b\u5b9e\u65bd\u5a01\u80c1\u4e4b\u524d\u79bb\u5f00\u2026\u2026", RAT_WARREN_STEP_BACK){

                    @Override
                    public void effects() {
                        if (freeEntry) {
                            Main.game.getTextStartStringBuilder().append(UtilText.parseFromXMLFile("places/submission/submissionPlaces", "RAT_WARREN_ENTRY_STEP_BACK", RatWarrensDialogue.getGuards(false)));
                        } else {
                            Main.game.getTextStartStringBuilder().append(UtilText.parseFromXMLFile("places/submission/submissionPlaces", "RAT_WARREN_STEP_BACK", RatWarrensDialogue.getGuards(false)));
                        }
                        RatWarrensDialogue.exit();
                    }
                };
            }
            return null;
        }
    };
    public static final DialogueNode RAT_WARREN_STEP_BACK = new DialogueNode("\u9f20\u7a9f", "", false){

        @Override
        public int getSecondsPassed() {
            return 60;
        }

        @Override
        public String getContent() {
            return "";
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            return RAT_WARREN.getResponse(responseTab, index);
        }
    };
    public static final DialogueNode GAMBLING_DEN = new DialogueNode("\u8d4c\u573a", "", false){

        @Override
        public int getSecondsPassed() {
            return 180;
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("places/submission/submissionPlaces", "GAMBLING_DEN");
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1) {
                return new Response("\u8d4c\u573a", "\u8fdb\u5165\u8d4c\u573a\u3002", GamblingDenDialogue.ENTRANCE){

                    @Override
                    public void effects() {
                        List<NPC> gamblersPresent = Main.game.getCharactersPresent(Main.game.getWorlds().get(WorldType.GAMBLING_DEN).getCell(PlaceType.GAMBLING_DEN_GAMBLING));
                        for (NPC npc : gamblersPresent) {
                            if (!(npc instanceof GamblingDenPatron)) continue;
                            Main.game.banishNPC(npc);
                        }
                        try {
                            Main.game.addNPC(new GamblingDenPatron(Gender.getGenderFromUserPreferences(false, false), DicePokerTable.COPPER, false), false);
                            Main.game.addNPC(new GamblingDenPatron(Gender.getGenderFromUserPreferences(false, false), DicePokerTable.COPPER, false), false);
                            Main.game.addNPC(new GamblingDenPatron(Gender.getGenderFromUserPreferences(false, false), DicePokerTable.SILVER, false), false);
                            Main.game.addNPC(new GamblingDenPatron(Gender.getGenderFromUserPreferences(false, false), DicePokerTable.SILVER, false), false);
                            Main.game.addNPC(new GamblingDenPatron(Gender.getGenderFromUserPreferences(false, false), DicePokerTable.GOLD, false), false);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        Main.game.getPlayer().setLocation(WorldType.GAMBLING_DEN, PlaceType.GAMBLING_DEN_ENTRANCE);
                    }
                };
            }
            return null;
        }
    };
    public static final DialogueNode LILIN_PALACE_CAVERN = new DialogueNode("\u6d1e\u7a9f", "", false){

        @Override
        public int getSecondsPassed() {
            return 180;
        }

        @Override
        public String getContent() {
            UtilText.nodeContentSB.setLength(0);
            UtilText.nodeContentSB.append(UtilText.parseFromXMLFile("places/submission/submissionPlaces", "LILIN_PALACE_CAVERN"));
            if (Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.elizabethIntroduced)) {
                UtilText.nodeContentSB.append(UtilText.parseFromXMLFile("places/submission/submissionPlaces", "LILIN_PALACE_CAVERN_MET_ELIZABETH"));
            } else {
                UtilText.nodeContentSB.append(UtilText.parseFromXMLFile("places/submission/submissionPlaces", "LILIN_PALACE_CAVERN_NOT_MET_ELIZABETH"));
            }
            return UtilText.nodeContentSB.toString();
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            return null;
        }
    };
    public static final DialogueNode LILIN_PALACE_GATE = new DialogueNode("\u8389\u897f\u4e1d\u7684\u5bab\u6bbf\u95e8", "", true){

        @Override
        public boolean isTravelDisabled() {
            return !Main.game.getPlayer().isQuestProgressGreaterThan(QuestLine.MAIN, Quest.MAIN_2_C_SIRENS_FALL) || Main.game.getNpc(Elizabeth.class).getWorldLocation() == WorldType.SUBMISSION && Main.game.getNpc(Elizabeth.class).isVisiblyPregnant() && !Main.game.getNpc(Elizabeth.class).isCharacterReactedToPregnancy(Main.game.getPlayer());
        }

        @Override
        public int getSecondsPassed() {
            return 60;
        }

        @Override
        public String getContent() {
            Main.game.getDialogueFlags().setFlag(DialogueFlagValue.elizabethAskedAboutUniforms, false);
            Main.game.getDialogueFlags().setFlag(DialogueFlagValue.elizabethAskedAboutSurname, false);
            Main.game.getDialogueFlags().setFlag(DialogueFlagValue.elizabethAskedAboutRoutine, false);
            UtilText.nodeContentSB.setLength(0);
            UtilText.nodeContentSB.append(UtilText.parseFromXMLFile("places/submission/submissionPlaces", "LILIN_PALACE_GATE"));
            if (Main.game.getPlayer().isQuestProgressGreaterThan(QuestLine.MAIN, Quest.MAIN_2_C_SIRENS_FALL)) {
                UtilText.nodeContentSB.append(UtilText.parseFromXMLFile("places/submission/submissionPlaces", "LILIN_PALACE_GATE_ENTRY_GRANTED"));
            } else if (Main.game.getPlayer().getQuest(QuestLine.MAIN) == Quest.MAIN_2_C_SIRENS_FALL) {
                UtilText.nodeContentSB.append(UtilText.parseFromXMLFile("places/submission/submissionPlaces", "LILIN_PALACE_GATE_ENTRY_BLOCKED_QUEST_COMPLETED"));
            } else if (Main.game.getPlayer().getQuest(QuestLine.MAIN) == Quest.MAIN_2_B_SIRENS_CALL) {
                UtilText.nodeContentSB.append(UtilText.parseFromXMLFile("places/submission/submissionPlaces", "LILIN_PALACE_GATE_ENTRY_BLOCKED_QUEST_GAINED"));
            } else if (Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.elizabethIntroduced)) {
                UtilText.nodeContentSB.append(UtilText.parseFromXMLFile("places/submission/submissionPlaces", "LILIN_PALACE_GATE_ENTRY_BLOCKED_INTRODUCED"));
            } else {
                UtilText.nodeContentSB.append(UtilText.parseFromXMLFile("places/submission/submissionPlaces", "LILIN_PALACE_GATE_ENTRY_BLOCKED"));
            }
            return UtilText.nodeContentSB.toString();
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (!Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.elizabethIntroduced)) {
                if (index == 1) {
                    return new Response("\u4ecb\u7ecd", "\u544a\u8bc9\u9b45\u9b54\u548c\u5979\u7684\u5c0f\u5f1f\u4eec\u4f60\u662f\u8c01\u3002", LILIN_PALACE_GATE_GENERIC_TALK){

                        @Override
                        public void effects() {
                            Main.game.getNpc(Elizabeth.class).setPlayerKnowsName(true);
                            Main.game.getDialogueFlags().setFlag(DialogueFlagValue.elizabethIntroduced, true);
                            Main.game.getTextStartStringBuilder().append(UtilText.parseFromXMLFile("places/submission/submissionPlaces", "LILIN_PALACE_GATE_INTRODUCTION"));
                        }
                    };
                }
                return null;
            }
            if (Main.game.getPlayer().isQuestProgressGreaterThan(QuestLine.MAIN, Quest.MAIN_2_C_SIRENS_FALL)) {
                if (Main.game.getNpc(Elizabeth.class).getWorldLocation() == WorldType.SUBMISSION) {
                    if (Main.game.getNpc(Elizabeth.class).isVisiblyPregnant() && !Main.game.getNpc(Elizabeth.class).isCharacterReactedToPregnancy(Main.game.getPlayer())) {
                        if (index == 1) {
                            return new Response("\u6000\u5b55", "\u95ee\u95ee\u4f0a\u4e3d\u838e\u767d\u5728\u6000\u5b55\u671f\u95f4\u662f\u5426\u9700\u8981\u4ec0\u4e48\u5e2e\u52a9\u3002", LILIN_PALACE_GATE_GENERIC_TALK){

                                @Override
                                public void effects() {
                                    Main.game.getNpc(Elizabeth.class).setCharacterReactedToPregnancy(Main.game.getPlayer(), true);
                                    Main.game.getTextStartStringBuilder().append(UtilText.parseFromXMLFile("places/submission/submissionPlaces", "LILIN_PALACE_GATE_PREGNANCY"));
                                }
                            };
                        }
                    } else {
                        if (index == 1) {
                            if (Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.elizabethAskedAboutUniforms)) {
                                return new Response("\u5236\u670d", "\u4f60\u5df2\u7ecf\u95ee\u8fc7\u4f0a\u4e3d\u838e\u767d\u5173\u4e8e\u5979\u7684\u5236\u670d\u4e86\u2026\u2026", null);
                            }
                            return new Response("\u5236\u670d", "\u95ee\u95ee\u4f0a\u4e3d\u838e\u767d\u4e3a\u4ec0\u4e48\u5979\u548c\u5979\u7684\u90e8\u961f\u7a7f\u7740\u5386\u53f2\u60a0\u4e45\u7684\u5236\u670d\u3002", LILIN_PALACE_GATE_GENERIC_TALK){

                                @Override
                                public void effects() {
                                    Main.game.getDialogueFlags().setFlag(DialogueFlagValue.elizabethAskedAboutUniforms, true);
                                    Main.game.getTextStartStringBuilder().append(UtilText.parseFromXMLFile("places/submission/submissionPlaces", "LILIN_PALACE_GATE_UNIFORMS"));
                                }
                            };
                        }
                        if (index == 2) {
                            if (Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.elizabethAskedAboutSurname)) {
                                return new Response("\u59d3\u6c0f", "\u4f60\u5df2\u7ecf\u95ee\u8fc7\u4f0a\u4e3d\u838e\u767d\u5979\u7684\u59d3\u4e86\u2026\u2026", null);
                            }
                            return new Response("\u59d3\u6c0f", "\u95ee\u95ee\u4f0a\u4e3d\u838e\u767d\u4e3a\u4ec0\u4e48\u4e0d\u613f\u610f\u522b\u4eba\u79f0\u547c\u5979\u7684\u59d3\u6c0f\u3002", LILIN_PALACE_GATE_GENERIC_TALK){

                                @Override
                                public void effects() {
                                    Main.game.getDialogueFlags().setFlag(DialogueFlagValue.elizabethAskedAboutSurname, true);
                                    Main.game.getTextStartStringBuilder().append(UtilText.parseFromXMLFile("places/submission/submissionPlaces", "LILIN_PALACE_GATE_SURNAME"));
                                }
                            };
                        }
                        if (index == 3) {
                            if (Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.elizabethAskedAboutRoutine)) {
                                return new Response("\u65e5\u5e38", "\u4f60\u5df2\u7ecf\u95ee\u8fc7\u4f0a\u4e3d\u838e\u767d\u5979\u7684\u65e5\u5e38\u751f\u6d3b\u4e86\u2026\u2026", null);
                            }
                            return new Response("\u65e5\u5e38", "\u95ee\u95ee\u4f0a\u4e3d\u838e\u767d\u5979\u7684\u65e5\u5e38\u751f\u6d3b\u3002", LILIN_PALACE_GATE_GENERIC_TALK){

                                @Override
                                public void effects() {
                                    Main.game.getDialogueFlags().setFlag(DialogueFlagValue.elizabethAskedAboutRoutine, true);
                                    Main.game.getTextStartStringBuilder().append(UtilText.parseFromXMLFile("places/submission/submissionPlaces", "LILIN_PALACE_GATE_ROUTINE"));
                                }
                            };
                        }
                    }
                }
                return null;
            }
            if (Main.game.getPlayer().getQuest(QuestLine.MAIN) == Quest.MAIN_2_C_SIRENS_FALL) {
                if (index == 1) {
                    return new Response("\u6c47\u62a5", "\u544a\u8bc9\u4f0a\u4e3d\u838e\u767d\u4f60\u662f\u600e\u4e48\u5bf9\u4ed8\u585e\u58ec\u7684\u3002", LILIN_PALACE_GATE_GENERIC_TALK){

                        @Override
                        public void effects() {
                            if (Main.game.getPlayer().hasItemType(ItemType.LYSSIETHS_RING)) {
                                Main.game.getTextStartStringBuilder().append(UtilText.parseFromXMLFile("places/submission/submissionPlaces", "LILIN_PALACE_GATE_COMPLETED_QUEST_WITH_COMBAT"));
                                Main.game.getPlayer().removeItem(Main.game.getItemGen().generateItem(ItemType.LYSSIETHS_RING));
                                Main.game.getTextEndStringBuilder().append(Main.game.getPlayer().removedItemFromInventoryText(ItemType.LYSSIETHS_RING));
                            } else {
                                Main.game.getTextStartStringBuilder().append(UtilText.parseFromXMLFile("places/submission/submissionPlaces", "LILIN_PALACE_GATE_COMPLETED_QUEST_WITH_TRICKERY"));
                            }
                            if (!Main.game.getPlayer().hasClothingType(ClothingType.FINGER_LYSSIETHS_RING, true)) {
                                Main.game.getTextEndStringBuilder().append(Main.game.getPlayer().addClothing(Main.game.getItemGen().generateClothing(ClothingType.FINGER_LYSSIETHS_RING, false), false));
                            }
                            Main.game.getTextEndStringBuilder().append(Main.game.getPlayer().setQuestProgress(QuestLine.MAIN, Quest.MAIN_2_D_MEETING_A_LILIN));
                        }
                    };
                }
                return null;
            }
            if (index == 1) {
                return new ResponseEffectsOnly("\u8d70\u5f00", "\u51b3\u5b9a\u79bb\u5f00\u4f0a\u4e3d\u838e\u767d\u548c\u738b\u5ba4\u536b\u961f\uff0c\u56de\u5230\u5c48\u57ce\u533a\u3002"){

                    @Override
                    public void effects() {
                        Main.game.getPlayer().setLocation(new Vector2i(Main.game.getPlayer().getLocation().getX(), Main.game.getPlayer().getLocation().getY() - 1));
                        Main.game.setContent(new Response("", "", LILIN_PALACE_CAVERN));
                    }
                };
            }
            if (index == 2) {
                if (Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.elizabethAskedAboutUniforms)) {
                    return new Response("\u5236\u670d", "\u4f60\u5df2\u7ecf\u95ee\u8fc7\u4f0a\u4e3d\u838e\u767d\u5173\u4e8e\u5979\u7684\u5236\u670d\u4e86\u2026\u2026", null);
                }
                return new Response("\u5236\u670d", "\u95ee\u95ee\u4f0a\u4e3d\u838e\u767d\u4e3a\u4ec0\u4e48\u5979\u548c\u5979\u7684\u90e8\u961f\u7a7f\u7740\u5386\u53f2\u60a0\u4e45\u7684\u5236\u670d\u3002", LILIN_PALACE_GATE_GENERIC_TALK){

                    @Override
                    public void effects() {
                        Main.game.getDialogueFlags().setFlag(DialogueFlagValue.elizabethAskedAboutUniforms, true);
                        Main.game.getTextStartStringBuilder().append(UtilText.parseFromXMLFile("places/submission/submissionPlaces", "LILIN_PALACE_GATE_UNIFORMS"));
                    }
                };
            }
            if (index == 3) {
                if (Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.elizabethAskedAboutSurname)) {
                    return new Response("\u59d3\u6c0f", "\u4f60\u5df2\u7ecf\u95ee\u8fc7\u4f0a\u4e3d\u838e\u767d\u5979\u7684\u59d3\u4e86\u2026\u2026", null);
                }
                return new Response("\u59d3\u6c0f", "\u95ee\u95ee\u4f0a\u4e3d\u838e\u767d\u4e3a\u4ec0\u4e48\u4e0d\u613f\u610f\u522b\u4eba\u79f0\u547c\u5979\u7684\u59d3\u6c0f\u3002", LILIN_PALACE_GATE_GENERIC_TALK){

                    @Override
                    public void effects() {
                        Main.game.getDialogueFlags().setFlag(DialogueFlagValue.elizabethAskedAboutSurname, true);
                        Main.game.getTextStartStringBuilder().append(UtilText.parseFromXMLFile("places/submission/submissionPlaces", "LILIN_PALACE_GATE_SURNAME"));
                    }
                };
            }
            if (index == 4) {
                if (Main.game.getPlayer().getQuest(QuestLine.MAIN) == Quest.MAIN_2_A_INTO_THE_DEPTHS) {
                    if (Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.impFortressDemonDefeated)) {
                        return new Response("\u89d0\u89c1", "\u95ee\u95ee\u4f0a\u4e3d\u838e\u767d\u5982\u4f55\u624d\u80fd\u89d0\u89c1\u8389\u897f\u4e1d\u3002", LILIN_PALACE_GATE_GENERIC_TALK){

                            @Override
                            public void effects() {
                                Main.game.getTextStartStringBuilder().append(UtilText.parseFromXMLFile("places/submission/submissionPlaces", "LILIN_PALACE_GATE_AUDIENCE_SKIP"));
                                Main.game.getTextEndStringBuilder().append(Main.game.getPlayer().addClothing(Main.game.getItemGen().generateClothing(ClothingType.FINGER_LYSSIETHS_RING, false), false));
                                Main.game.getTextEndStringBuilder().append(Main.game.getPlayer().setQuestProgress(QuestLine.MAIN, Quest.MAIN_2_D_MEETING_A_LILIN));
                            }
                        };
                    }
                    return new Response("\u89d0\u89c1", "\u95ee\u95ee\u4f0a\u4e3d\u838e\u767d\u5982\u4f55\u624d\u80fd\u89d0\u89c1\u8389\u897f\u4e1d\u3002", LILIN_PALACE_GATE_GENERIC_TALK){

                        @Override
                        public void effects() {
                            Main.game.getTextStartStringBuilder().append(UtilText.parseFromXMLFile("places/submission/submissionPlaces", "LILIN_PALACE_GATE_AUDIENCE"));
                            Main.game.getTextEndStringBuilder().append(Main.game.getPlayer().addItem(Main.game.getItemGen().generateItem(ItemType.LYSSIETHS_RING), false));
                            Main.game.getTextEndStringBuilder().append(Main.game.getPlayer().setQuestProgress(QuestLine.MAIN, Quest.MAIN_2_B_SIRENS_CALL));
                        }
                    };
                }
                if (Main.game.getPlayer().getQuest(QuestLine.MAIN) == Quest.MAIN_2_B_SIRENS_CALL) {
                    return new Response("\u89d0\u89c1", "\u4f60\u5df2\u7ecf\u95ee\u8fc7\u4f0a\u4e3d\u838e\u767d\u5982\u4f55\u624d\u80fd\u89d0\u89c1\u8389\u897f\u4e1d\u4e86\u3002\u4f60\u9700\u8981\u627e\u5230\u5e76\u5f81\u670d\u8389\u897f\u4e1d\u7684\u5973\u513f\uff0c\u201c\u6697\u591c\u585e\u58ec\u201d\u3002", null);
                }
                return new Response("\u89d0\u89c1", "\u4f0a\u4e3d\u838e\u767d\u8bf4\u4e0d\u8389\u897f\u4e1d\u63a5\u5f85\u8bbf\u5ba2\uff0c\u81f3\u5c11\u76ee\u524d\u4f60\u6ca1\u6709\u7279\u522b\u7684\u7406\u7531\u8981\u89c1\u5979\u3002\u4e5f\u8bb8\u5728\u672a\u6765\u7684\u67d0\u4e00\u5929\uff0c\u4f60\u9700\u8981\u6c42\u89c1\u8389\u897f\u4e1d\u2026\u2026", null);
            }
            return null;
        }
    };
    public static final DialogueNode LILIN_PALACE_GATE_GENERIC_TALK = new DialogueNode("\u8389\u897f\u4e1d\u7684\u5bab\u6bbf\u95e8", "", true, true){

        @Override
        public boolean isTravelDisabled() {
            return LILIN_PALACE_GATE.isTravelDisabled();
        }

        @Override
        public int getSecondsPassed() {
            return 60;
        }

        @Override
        public String getContent() {
            return "";
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            return LILIN_PALACE_GATE.getResponse(responseTab, index);
        }
    };
    public static final DialogueNode LILIN_PALACE = new DialogueNode("\u8389\u897f\u4e1d\u7684\u5bab\u6bbf", "", false){

        @Override
        public int getSecondsPassed() {
            return 60;
        }

        @Override
        public String getContent() {
            UtilText.nodeContentSB.setLength(0);
            UtilText.nodeContentSB.append(UtilText.parseFromXMLFile("places/submission/submissionPlaces", "LILIN_PALACE"));
            if (Main.game.getPlayer().getQuest(QuestLine.MAIN) == Quest.MAIN_2_D_MEETING_A_LILIN) {
                if (Main.game.getPlayer().hasCompanions()) {
                    UtilText.nodeContentSB.append(UtilText.parseFromXMLFile("places/submission/submissionPlaces", "LILIN_PALACE_ELIZABETH_LEADS_COMPANIONS", Main.game.getPlayer().getMainCompanion()));
                } else {
                    UtilText.nodeContentSB.append(UtilText.parseFromXMLFile("places/submission/submissionPlaces", "LILIN_PALACE_ELIZABETH_LEADS"));
                }
            } else if (Main.game.getPlayer().isQuestProgressGreaterThan(QuestLine.MAIN, Quest.MAIN_2_D_MEETING_A_LILIN)) {
                UtilText.nodeContentSB.append(UtilText.parseFromXMLFile("places/submission/submissionPlaces", "LILIN_PALACE_ELIZABETH_ESCORT"));
            }
            return UtilText.nodeContentSB.toString();
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1) {
                if (Main.game.getPlayer().getQuest(QuestLine.MAIN) == Quest.MAIN_2_D_MEETING_A_LILIN) {
                    return new Response("\u8fdb\u5165", "\u4e0e\u4f0a\u4e3d\u838e\u767d\u8fdb\u5165\u5bab\u6bbf\uff0c\u7ee7\u7eed\u8ddf\u968f\u5979\u5230\u6b63\u6bbf\u3002" + (Main.game.getPlayer().hasCompanions() ? "<br/>[style.italicsMinorBad(\u8fd9\u5c06\u9063\u6563\u4f60\u7684\u6240\u6709\u540c\u4f34\uff0c\u4ed6\u4eec\u5c06\u88ab\u9001\u56de\u5bb6\u3002)]" : ""), LyssiethReveal.ENTRANCE_WITH_ELIZABETH){

                        @Override
                        public void effects() {
                            Main.game.getPlayer().removeAllCompanions(true);
                            Main.game.getPlayer().setLocation(WorldType.LYSSIETH_PALACE, PlaceType.LYSSIETH_PALACE_ENTRANCE);
                            Main.game.getNpc(Elizabeth.class).setLocation(WorldType.LYSSIETH_PALACE, PlaceType.LYSSIETH_PALACE_ENTRANCE);
                            ((DarkSiren)Main.game.getNpc(DarkSiren.class)).postDefeatReset();
                        }
                    };
                }
                if (Main.game.getPlayer().isQuestProgressGreaterThan(QuestLine.MAIN, Quest.MAIN_2_D_MEETING_A_LILIN)) {
                    return new Response("\u8fdb\u5165", Main.game.getNpc(Elizabeth.class).getWorldLocation() == WorldType.SUBMISSION ? "\u544a\u8bc9\u4f0a\u4e3d\u838e\u767d\u4f60\u60f3\u8fdb\u5165\u5bab\u6bbf\uff0c\u8ba9\u5979\u4e3a\u4f60\u6253\u5f00\u5927\u95e8\u3002" : "\u544a\u8bc9\u5b88\u536b\u4f60\u8981\u8fdb\u5165\u5bab\u6bbf\uff0c\u8ba9\u5979\u4e3a\u4f60\u6253\u5f00\u5927\u95e8\u3002", PlaceType.LYSSIETH_PALACE_ENTRANCE.getDialogue(false)){

                        @Override
                        public void effects() {
                            Main.game.getPlayer().setLocation(WorldType.LYSSIETH_PALACE, PlaceType.LYSSIETH_PALACE_ENTRANCE);
                            Main.game.getNpc(Elizabeth.class).setLocation(WorldType.SUBMISSION, PlaceType.SUBMISSION_LILIN_PALACE_GATE);
                        }
                    };
                }
                return new Response("\u8fdb\u5165", "\u95e8\u9501\u7740\u2026\u2026", null);
            }
            return null;
        }
    };
    public static final DialogueNode IMP_FORTRESS_ALPHA = new DialogueNode("\u7c97\u7cd9\u8981\u585e", "", false){

        @Override
        public int getSecondsPassed() {
            return 180;
        }

        @Override
        public String getContent() {
            UtilText.nodeContentSB.setLength(0);
            UtilText.nodeContentSB.append(UtilText.parseFromXMLFile("places/submission/submissionPlaces", "IMP_FORTRESS"));
            UtilText.nodeContentSB.append(UtilText.parseFromXMLFile("places/submission/submissionPlaces", "IMP_FORTRESS_ALPHA"));
            if (Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.impFortressAlphaPacified)) {
                UtilText.nodeContentSB.append(UtilText.parseFromXMLFile("places/submission/submissionPlaces", "IMP_FORTRESS_ENTRY_PACIFIED"));
            } else if (Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.impFortressAlphaDefeated)) {
                UtilText.nodeContentSB.append(UtilText.parseFromXMLFile("places/submission/submissionPlaces", "IMP_FORTRESS_ENTRY_DEFEATED"));
            } else {
                UtilText.nodeContentSB.append(UtilText.parseFromXMLFile("places/submission/submissionPlaces", "IMP_FORTRESS_ENTRY"));
            }
            return UtilText.nodeContentSB.toString();
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            boolean canEnter;
            boolean bl = canEnter = Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.impFortressAlphaDefeated) || Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.impFortressAlphaPacified);
            if (index == 1) {
                return new Response(canEnter ? "\u8fdb\u5165" : "\u9760\u8fd1", canEnter ? "\u8fdb\u5165\u8981\u585e\u3002" : "\u9760\u8fd1\u8981\u585e\u5165\u53e3\u7684\u5b88\u536b\u3002", PlaceType.FORTRESS_ALPHA_ENTRANCE.getDialogue(false)){

                    @Override
                    public void effects() {
                        if (!Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.impFortressAlphaDefeated)) {
                            if (ImpFortressDialogue.getImpBossGroup(WorldType.IMP_FORTRESS_ALPHA, false).isEmpty()) {
                                ImpFortressDialogue.resetFortress(WorldType.IMP_FORTRESS_ALPHA);
                            } else if (!ImpFortressDialogue.getImpBossGroup(WorldType.IMP_FORTRESS_ALPHA, false).contains(Main.game.getNpc(FortressAlphaLeader.class))) {
                                Main.game.getNpc(FortressAlphaLeader.class).setLocation(WorldType.IMP_FORTRESS_ALPHA, PlaceType.FORTRESS_ALPHA_KEEP, true);
                            } else if (ImpFortressDialogue.getImpGuards(WorldType.IMP_FORTRESS_ALPHA).isEmpty()) {
                                ImpFortressDialogue.resetGuards(WorldType.IMP_FORTRESS_ALPHA);
                            }
                        }
                        Main.game.getPlayer().setLocation(WorldType.IMP_FORTRESS_ALPHA, PlaceType.FORTRESS_ALPHA_ENTRANCE);
                    }
                };
            }
            if (index == 2) {
                if (Main.game.getPlayer().isPartyAbleToFly()) {
                    return new Response("\u98de\u884c", canEnter ? "\u4f60\u53ea\u9700\u7a7f\u8fc7\u524d\u95e8\u5373\u53ef\uff0c\u9664\u975e\u4f60\u60f3\u70ab\u8000\u4e00\u4e0b\uff0c\u5426\u5219\u6ca1\u5fc5\u8981\u8fd9\u4e48\u505a\u2026\u2026" : "\u98de\u8d8a\u8981\u585e\u7684\u56f4\u5899\uff0c\u907f\u514d\u4e0e\u95e8\u53e3\u7684\u5c0f\u6076\u9b54\u5b88\u536b\u53d1\u751f\u51b2\u7a81\u3002", PlaceType.FORTRESS_ALPHA_COURTYARD.getDialogue(false)){

                        @Override
                        public void effects() {
                            if (!Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.impFortressAlphaDefeated)) {
                                if (ImpFortressDialogue.getImpBossGroup(WorldType.IMP_FORTRESS_ALPHA, false).isEmpty()) {
                                    ImpFortressDialogue.resetFortress(WorldType.IMP_FORTRESS_ALPHA);
                                } else if (!ImpFortressDialogue.getImpBossGroup(WorldType.IMP_FORTRESS_ALPHA, false).contains(Main.game.getNpc(FortressAlphaLeader.class))) {
                                    Main.game.getNpc(FortressAlphaLeader.class).setLocation(WorldType.IMP_FORTRESS_ALPHA, PlaceType.FORTRESS_ALPHA_KEEP, true);
                                } else if (ImpFortressDialogue.getImpGuards(WorldType.IMP_FORTRESS_ALPHA).isEmpty()) {
                                    ImpFortressDialogue.resetGuards(WorldType.IMP_FORTRESS_ALPHA);
                                }
                            }
                            Main.game.getTextStartStringBuilder().append(UtilText.parseFromXMLFile("places/submission/submissionPlaces", "IMP_FORTRESS_FLY_ENTRY"));
                            Main.game.getPlayer().setLocation(WorldType.IMP_FORTRESS_ALPHA, PlaceType.FORTRESS_ALPHA_COURTYARD);
                        }
                    };
                }
                return new Response("\u98de\u884c", "\u4f60\u6216\u4f60\u961f\u4f0d\u4e2d\u7684\u4e00\u5458\u65e0\u6cd5\u98de\u884c\uff0c\u4f60\u4e0d\u80fd\u98de\u8d8a\u56f4\u5899\u8fdb\u5165\u8981\u585e\uff01", null);
            }
            return null;
        }
    };
    public static final DialogueNode IMP_FORTRESS_FEMALES = new DialogueNode("\u7c97\u7cd9\u8981\u585e", "", false){

        @Override
        public int getSecondsPassed() {
            return 180;
        }

        @Override
        public String getContent() {
            UtilText.nodeContentSB.setLength(0);
            UtilText.nodeContentSB.append(UtilText.parseFromXMLFile("places/submission/submissionPlaces", "IMP_FORTRESS"));
            UtilText.nodeContentSB.append(UtilText.parseFromXMLFile("places/submission/submissionPlaces", "IMP_FORTRESS_FEMALES"));
            if (Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.impFortressFemalesPacified)) {
                UtilText.nodeContentSB.append(UtilText.parseFromXMLFile("places/submission/submissionPlaces", "IMP_FORTRESS_ENTRY_PACIFIED"));
            } else if (Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.impFortressFemalesDefeated)) {
                UtilText.nodeContentSB.append(UtilText.parseFromXMLFile("places/submission/submissionPlaces", "IMP_FORTRESS_ENTRY_DEFEATED"));
            } else {
                UtilText.nodeContentSB.append(UtilText.parseFromXMLFile("places/submission/submissionPlaces", "IMP_FORTRESS_ENTRY"));
            }
            return UtilText.nodeContentSB.toString();
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            boolean canEnter;
            boolean bl = canEnter = Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.impFortressFemalesDefeated) || Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.impFortressFemalesPacified);
            if (index == 1) {
                return new Response(canEnter ? "\u8fdb\u5165" : "\u9760\u8fd1", canEnter ? "\u8fdb\u5165\u8981\u585e\u3002" : "\u9760\u8fd1\u8981\u585e\u5165\u53e3\u7684\u5b88\u536b\u3002", PlaceType.FORTRESS_FEMALES_ENTRANCE.getDialogue(false)){

                    @Override
                    public void effects() {
                        if (!Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.impFortressFemalesDefeated)) {
                            if (ImpFortressDialogue.getImpBossGroup(WorldType.IMP_FORTRESS_FEMALES, false).isEmpty()) {
                                ImpFortressDialogue.resetFortress(WorldType.IMP_FORTRESS_FEMALES);
                            } else if (!ImpFortressDialogue.getImpBossGroup(WorldType.IMP_FORTRESS_FEMALES, false).contains(Main.game.getNpc(FortressFemalesLeader.class))) {
                                Main.game.getNpc(FortressFemalesLeader.class).setLocation(WorldType.IMP_FORTRESS_FEMALES, PlaceType.FORTRESS_FEMALES_KEEP, true);
                            } else if (ImpFortressDialogue.getImpGuards(WorldType.IMP_FORTRESS_FEMALES).isEmpty()) {
                                ImpFortressDialogue.resetGuards(WorldType.IMP_FORTRESS_FEMALES);
                            }
                        }
                        Main.game.getPlayer().setLocation(WorldType.IMP_FORTRESS_FEMALES, PlaceType.FORTRESS_FEMALES_ENTRANCE);
                    }
                };
            }
            if (index == 2) {
                if (Main.game.getPlayer().isPartyAbleToFly()) {
                    return new Response("\u98de\u884c", canEnter ? "\u4f60\u53ea\u9700\u7a7f\u8fc7\u524d\u95e8\u5373\u53ef\uff0c\u9664\u975e\u4f60\u60f3\u70ab\u8000\u4e00\u4e0b\uff0c\u5426\u5219\u6ca1\u5fc5\u8981\u8fd9\u4e48\u505a\u2026\u2026" : "\u98de\u8d8a\u8981\u585e\u7684\u56f4\u5899\uff0c\u907f\u514d\u4e0e\u95e8\u53e3\u7684\u5c0f\u6076\u9b54\u5b88\u536b\u53d1\u751f\u51b2\u7a81\u3002", PlaceType.FORTRESS_FEMALES_COURTYARD.getDialogue(false)){

                        @Override
                        public void effects() {
                            if (!Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.impFortressFemalesDefeated)) {
                                if (ImpFortressDialogue.getImpBossGroup(WorldType.IMP_FORTRESS_FEMALES, false).isEmpty()) {
                                    ImpFortressDialogue.resetFortress(WorldType.IMP_FORTRESS_FEMALES);
                                } else if (!ImpFortressDialogue.getImpBossGroup(WorldType.IMP_FORTRESS_FEMALES, false).contains(Main.game.getNpc(FortressFemalesLeader.class))) {
                                    Main.game.getNpc(FortressFemalesLeader.class).setLocation(WorldType.IMP_FORTRESS_FEMALES, PlaceType.FORTRESS_FEMALES_KEEP, true);
                                } else if (ImpFortressDialogue.getImpGuards(WorldType.IMP_FORTRESS_FEMALES).isEmpty()) {
                                    ImpFortressDialogue.resetGuards(WorldType.IMP_FORTRESS_FEMALES);
                                }
                            }
                            Main.game.getTextStartStringBuilder().append(UtilText.parseFromXMLFile("places/submission/submissionPlaces", "IMP_FORTRESS_FLY_ENTRY"));
                            Main.game.getPlayer().setLocation(WorldType.IMP_FORTRESS_FEMALES, PlaceType.FORTRESS_FEMALES_COURTYARD);
                        }
                    };
                }
                return new Response("\u98de\u884c", "\u4f60\u6216\u4f60\u961f\u4f0d\u4e2d\u7684\u4e00\u5458\u65e0\u6cd5\u98de\u884c\uff0c\u4f60\u4e0d\u80fd\u98de\u8d8a\u56f4\u5899\u8fdb\u5165\u8981\u585e\uff01", null);
            }
            return null;
        }
    };
    public static final DialogueNode IMP_FORTRESS_MALES = new DialogueNode("\u7c97\u7cd9\u8981\u585e", "", false){

        @Override
        public int getSecondsPassed() {
            return 180;
        }

        @Override
        public String getContent() {
            UtilText.nodeContentSB.setLength(0);
            UtilText.nodeContentSB.append(UtilText.parseFromXMLFile("places/submission/submissionPlaces", "IMP_FORTRESS"));
            UtilText.nodeContentSB.append(UtilText.parseFromXMLFile("places/submission/submissionPlaces", "IMP_FORTRESS_MALES"));
            if (Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.impFortressMalesPacified)) {
                UtilText.nodeContentSB.append(UtilText.parseFromXMLFile("places/submission/submissionPlaces", "IMP_FORTRESS_ENTRY_PACIFIED"));
            } else if (Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.impFortressMalesDefeated)) {
                UtilText.nodeContentSB.append(UtilText.parseFromXMLFile("places/submission/submissionPlaces", "IMP_FORTRESS_ENTRY_DEFEATED"));
            } else {
                UtilText.nodeContentSB.append(UtilText.parseFromXMLFile("places/submission/submissionPlaces", "IMP_FORTRESS_ENTRY"));
            }
            return UtilText.nodeContentSB.toString();
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            boolean canEnter;
            boolean bl = canEnter = Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.impFortressMalesDefeated) || Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.impFortressMalesPacified);
            if (index == 1) {
                return new Response(canEnter ? "\u8fdb\u5165" : "\u9760\u8fd1", canEnter ? "\u8fdb\u5165\u8981\u585e\u3002" : "\u9760\u8fd1\u8981\u585e\u5165\u53e3\u7684\u5b88\u536b\u3002", PlaceType.FORTRESS_MALES_ENTRANCE.getDialogue(false)){

                    @Override
                    public void effects() {
                        if (!Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.impFortressMalesDefeated)) {
                            if (ImpFortressDialogue.getImpBossGroup(WorldType.IMP_FORTRESS_MALES, false).isEmpty()) {
                                ImpFortressDialogue.resetFortress(WorldType.IMP_FORTRESS_MALES);
                            } else if (!ImpFortressDialogue.getImpBossGroup(WorldType.IMP_FORTRESS_MALES, false).contains(Main.game.getNpc(FortressMalesLeader.class))) {
                                Main.game.getNpc(FortressMalesLeader.class).setLocation(WorldType.IMP_FORTRESS_MALES, PlaceType.FORTRESS_MALES_KEEP, true);
                            } else if (ImpFortressDialogue.getImpGuards(WorldType.IMP_FORTRESS_MALES).isEmpty()) {
                                ImpFortressDialogue.resetGuards(WorldType.IMP_FORTRESS_MALES);
                            }
                        }
                        Main.game.getPlayer().setLocation(WorldType.IMP_FORTRESS_MALES, PlaceType.FORTRESS_MALES_ENTRANCE);
                    }
                };
            }
            if (index == 2) {
                if (Main.game.getPlayer().isPartyAbleToFly()) {
                    return new Response("\u98de\u884c", canEnter ? "\u4f60\u53ea\u9700\u7a7f\u8fc7\u524d\u95e8\u5373\u53ef\uff0c\u9664\u975e\u4f60\u60f3\u70ab\u8000\u4e00\u4e0b\uff0c\u5426\u5219\u6ca1\u5fc5\u8981\u8fd9\u4e48\u505a\u2026\u2026" : "\u98de\u8d8a\u8981\u585e\u7684\u56f4\u5899\uff0c\u907f\u514d\u4e0e\u95e8\u53e3\u7684\u5c0f\u6076\u9b54\u5b88\u536b\u53d1\u751f\u51b2\u7a81\u3002", PlaceType.FORTRESS_MALES_COURTYARD.getDialogue(false)){

                        @Override
                        public void effects() {
                            if (!Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.impFortressMalesDefeated)) {
                                if (ImpFortressDialogue.getImpBossGroup(WorldType.IMP_FORTRESS_MALES, false).isEmpty()) {
                                    ImpFortressDialogue.resetFortress(WorldType.IMP_FORTRESS_MALES);
                                } else if (!ImpFortressDialogue.getImpBossGroup(WorldType.IMP_FORTRESS_MALES, false).contains(Main.game.getNpc(FortressMalesLeader.class))) {
                                    Main.game.getNpc(FortressMalesLeader.class).setLocation(WorldType.IMP_FORTRESS_MALES, PlaceType.FORTRESS_MALES_KEEP, true);
                                } else if (ImpFortressDialogue.getImpGuards(WorldType.IMP_FORTRESS_MALES).isEmpty()) {
                                    ImpFortressDialogue.resetGuards(WorldType.IMP_FORTRESS_MALES);
                                }
                            }
                            Main.game.getTextStartStringBuilder().append(UtilText.parseFromXMLFile("places/submission/submissionPlaces", "IMP_FORTRESS_FLY_ENTRY"));
                            Main.game.getPlayer().setLocation(WorldType.IMP_FORTRESS_MALES, PlaceType.FORTRESS_MALES_COURTYARD);
                        }
                    };
                }
                return new Response("\u98de\u884c", "\u4f60\u6216\u4f60\u961f\u4f0d\u4e2d\u7684\u4e00\u5458\u65e0\u6cd5\u98de\u884c\uff0c\u4f60\u4e0d\u80fd\u98de\u8d8a\u56f4\u5899\u8fdb\u5165\u8981\u585e\uff01", null);
            }
            return null;
        }
    };
    public static final DialogueNode IMP_FORTRESS_DEMON = new DialogueNode("\u77f3\u5236\u57ce\u5821", "", false){

        @Override
        public int getSecondsPassed() {
            return 180;
        }

        @Override
        public String getContent() {
            if (Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.impFortressDemonDefeated)) {
                return UtilText.parseFromXMLFile("places/submission/submissionPlaces", "IMP_CITADEL_DEFEATED");
            }
            Main.game.getDialogueFlags().setFlag(DialogueFlagValue.impCitadelEncountered, true);
            UtilText.nodeContentSB.setLength(0);
            UtilText.nodeContentSB.append(UtilText.parseFromXMLFile("places/submission/submissionPlaces", "IMP_CITADEL_BASE"));
            if (Main.game.getPlayer().hasItemType(ItemType.IMP_FORTRESS_ARCANE_KEY) && Main.game.getPlayer().hasItemType(ItemType.IMP_FORTRESS_ARCANE_KEY_2) && Main.game.getPlayer().hasItemType(ItemType.IMP_FORTRESS_ARCANE_KEY_3) || Main.game.getPlayer().hasClothingType(ClothingType.getClothingTypeFromId("innoxia_neck_key_chain"), true)) {
                UtilText.nodeContentSB.append(UtilText.parseFromXMLFile("places/submission/submissionPlaces", "IMP_CITADEL_KEYS"));
            } else {
                UtilText.nodeContentSB.append(UtilText.parseFromXMLFile("places/submission/submissionPlaces", "IMP_CITADEL_NO_KEYS"));
            }
            return UtilText.nodeContentSB.toString();
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1) {
                if (Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.impFortressDemonDefeated)) {
                    return new Response("\u8fdb\u5165", "\u8fdb\u5165\u6697\u591c\u585e\u58ec\u57ce\u5821\u7684\u5e9f\u589f\u3002", PlaceType.FORTRESS_DEMON_ENTRANCE.getDialogue(false)){

                        @Override
                        public void effects() {
                            Main.game.getPlayer().setLocation(WorldType.IMP_FORTRESS_DEMON, PlaceType.FORTRESS_DEMON_ENTRANCE);
                            Main.game.getTextStartStringBuilder().append(UtilText.parseFromXMLFile("places/submission/submissionPlaces", "IMP_CITADEL_RUINS_ENTRY"));
                        }
                    };
                }
                if (Main.game.getPlayer().hasItemType(ItemType.IMP_FORTRESS_ARCANE_KEY) && Main.game.getPlayer().hasItemType(ItemType.IMP_FORTRESS_ARCANE_KEY_2) && Main.game.getPlayer().hasItemType(ItemType.IMP_FORTRESS_ARCANE_KEY_3) || Main.game.getPlayer().hasClothingType(ClothingType.getClothingTypeFromId("innoxia_neck_key_chain"), true)) {
                    return new Response("\u8fdb\u5165", "\u8fdb\u5165\u57ce\u5821\u3002", FORTRESS_DEMON_ENTRANCE_KEY_ENTRY){

                        @Override
                        public void effects() {
                            Main.game.getPlayer().setLocation(WorldType.IMP_FORTRESS_DEMON, PlaceType.FORTRESS_DEMON_ENTRANCE);
                            ImpCitadelDialogue.applyEntry();
                            if (!Main.game.getPlayer().hasClothingType(ClothingType.getClothingTypeFromId("innoxia_neck_key_chain"), true)) {
                                Main.game.getTextStartStringBuilder().append(UtilText.parseFromXMLFile("places/submission/submissionPlaces", "IMP_CITADEL_KEY_ENTRY"));
                                Main.game.getTextEndStringBuilder().append(Main.game.getPlayer().addClothing(Main.game.getItemGen().generateClothing(ClothingType.getClothingTypeFromId("innoxia_neck_key_chain"), false), false));
                                Main.game.getPlayer().removeItem(Main.game.getItemGen().generateItem(ItemType.IMP_FORTRESS_ARCANE_KEY));
                                Main.game.getPlayer().removeItem(Main.game.getItemGen().generateItem(ItemType.IMP_FORTRESS_ARCANE_KEY_2));
                                Main.game.getPlayer().removeItem(Main.game.getItemGen().generateItem(ItemType.IMP_FORTRESS_ARCANE_KEY_3));
                            } else {
                                Main.game.getTextStartStringBuilder().append(UtilText.parseFromXMLFile("places/submission/submissionPlaces", "IMP_CITADEL_KEY_ENTRY_REPEAT"));
                                if (Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.impFortressDemonImpsDefeated)) {
                                    Main.game.getTextStartStringBuilder().append(UtilText.parseFromXMLFile("places/submission/submissionPlaces", "IMP_CITADEL_KEY_ENTRY_REPEAT_IMPS"));
                                } else {
                                    Main.game.getTextStartStringBuilder().append(UtilText.parseFromXMLFile("places/submission/submissionPlaces", "IMP_CITADEL_KEY_ENTRY_REPEAT_NO_IMPS"));
                                }
                            }
                        }
                    };
                }
                return new Response("\u8fdb\u5165", "\u4f60\u6ca1\u96c6\u9f50\u4e09\u628a\u94a5\u5319\uff0c\u6253\u4e0d\u5f00\u5927\u95e8\u2026\u2026", null);
            }
            return null;
        }
    };
    public static final DialogueNode FORTRESS_DEMON_ENTRANCE_KEY_ENTRY = new DialogueNode("", "", false){

        @Override
        public String getContent() {
            return "";
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            return ImpCitadelDialogue.ENTRANCE.getResponse(responseTab, index);
        }
    };
    public static final DialogueNode SEWER_ENTRANCE = new DialogueNode("\u6267\u6cd5\u8005\u68c0\u67e5\u70b9", "", false){

        @Override
        public int getSecondsPassed() {
            return 180;
        }

        @Override
        public boolean isTravelDisabled() {
            return Main.game.getPlayer().isQuestCompleted(QuestLine.SIDE_VENGAR) && Main.game.getPlayer().isHasSlaverLicense() && !Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.milkersClaireDialogue);
        }

        @Override
        public String getContent() {
            if (Main.game.getPlayer().isQuestCompleted(QuestLine.SIDE_VENGAR) && !Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.milkersClaireDialogue)) {
                return UtilText.parseFromXMLFile("places/submission/submissionPlaces", "SEWER_ENTRANCE_CLAIRE_MILKERS");
            }
            return UtilText.parseFromXMLFile("places/submission/submissionPlaces", "SEWER_ENTRANCE");
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (Main.game.getPlayer().isQuestCompleted(QuestLine.SIDE_VENGAR) && Main.game.getPlayer().isHasSlaverLicense() && !Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.milkersClaireDialogue)) {
                if (index == 1) {
                    return new Response("\u6536\u4e0b\u201c\u5976\u725b\u201d", "\u544a\u8bc9\u514b\u83b1\u5c14\uff0c\u4f60\u4f1a\u5bf9\u4ece\u9f20\u7a9f\u91cc\u6551\u51fa\u7684\u5974\u96b6\u8d1f\u8d23", SEWER_ENTRANCE_MILKERS_RESOLVED){

                        @Override
                        public void effects() {
                            Main.game.getDialogueFlags().setFlag(DialogueFlagValue.milkersClaireDialogue, true);
                            Main.game.appendToTextStartStringBuilder(UtilText.parseFromXMLFile("places/submission/submissionPlaces", "SEWER_ENTRANCE_CLAIRE_MILKERS_ACCEPTED"));
                            if (RatWarrensDialogue.getMilkers().isEmpty()) {
                                RatWarrensDialogue.spawnMilkers();
                            }
                            for (GameCharacter milker : RatWarrensDialogue.getMilkers()) {
                                ((RatWarrensCaptive)milker).applyMilkingEquipment(false, Util.newArrayListOfValues(InventorySlot.NIPPLE, InventorySlot.VAGINA));
                                milker.setLocation(WorldType.SLAVER_ALLEY, PlaceType.SLAVER_ALLEY_SLAVERY_ADMINISTRATION, true);
                                Main.game.getPlayer().addSlave((NPC)milker);
                                milker.setObedience(100.0f);
                                milker.setHistory(Occupation.NPC_SLAVE);
                            }
                        }
                    };
                }
                if (index == 2) {
                    return new Response("\u8c22\u7edd", "\u544a\u8bc9\u514b\u83b1\u5c14\u4f60\u5bf9\u4ece\u9f20\u7a9f\u6551\u51fa\u7684\u5974\u96b6\u4e0d\u611f\u5174\u8da3\u3002", SEWER_ENTRANCE_MILKERS_RESOLVED){

                        @Override
                        public void effects() {
                            Main.game.getDialogueFlags().setFlag(DialogueFlagValue.milkersClaireDialogue, true);
                            Main.game.appendToTextStartStringBuilder(UtilText.parseFromXMLFile("places/submission/submissionPlaces", "SEWER_ENTRANCE_CLAIRE_MILKERS_DECLINED"));
                            RatWarrensDialogue.banishMilkers();
                        }
                    };
                }
            } else {
                if (index == 1) {
                    return new Response("\u5fa1\u57ce\u533a", "\u56de\u5230\u5fa1\u57ce\u533a\u3002", PlaceType.DOMINION_EXIT_TO_SUBMISSION.getDialogue(false)){

                        @Override
                        public void effects() {
                            Main.game.getPlayer().setLocation(WorldType.DOMINION, PlaceType.DOMINION_EXIT_TO_SUBMISSION, false);
                        }
                    };
                }
                if (index == 2) {
                    return new Response("\u514b\u83b1\u5c14", "\u9760\u8fd1\u514b\u83b1\u5c14\u548c\u5979\u6253\u62db\u547c\u3002", CLAIRE);
                }
                if (index == 3) {
                    return new Response("\u81ea\u52a8\u552e\u8d27\u673a", "\u9760\u8fd1\u6267\u6cd5\u8005\u524d\u54e8\u7ad9\u5916\u7684\u81ea\u52a8\u552e\u8d27\u673a\u3002", VENDING_MACHINE);
                }
            }
            return null;
        }
    };
    public static final DialogueNode SEWER_ENTRANCE_MILKERS_RESOLVED = new DialogueNode("", "", false, true){

        @Override
        public int getSecondsPassed() {
            return 300;
        }

        @Override
        public String getContent() {
            return "";
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            return SEWER_ENTRANCE.getResponse(responseTab, index);
        }
    };
    public static final DialogueNode CLAIRE = new DialogueNode("\u514b\u83b1\u5c14", "", true){

        @Override
        public int getSecondsPassed() {
            return 60;
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("places/submission/submissionPlaces", "CLAIRE");
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            ArrayList<Response> responses = new ArrayList<Response>();
            responses.add(new Response("\u8fd4\u56de", "\u544a\u8bc9\u514b\u83b1\u5c14\u4f60\u5f97\u8d70\u4e86\u3002", SEWER_ENTRANCE));
            if (Main.game.getCurrentDialogueNode() == CLAIRE_INFO_SUBMISSION_SOCIETY) {
                responses.add(new Response("\u4fe1\u606f", "\u4f60\u5df2\u7ecf\u95ee\u8fc7\u514b\u83b1\u5c14\u5c48\u57ce\u533a\u7684\u793e\u4f1a\u60c5\u51b5\u4e86\u3002", null));
            } else {
                responses.add(new Response("\u4fe1\u606f", "\u95ee\u95ee\u514b\u83b1\u5c14\u5c48\u57ce\u533a\u7684\u793e\u4f1a\u72b6\u51b5\u3002", CLAIRE_INFO_SUBMISSION_SOCIETY){

                    @Override
                    public void effects() {
                        SubmissionGenericPlaces.applyClaireMeetingEffects();
                    }
                });
            }
            if (Main.game.getCurrentDialogueNode() == CLAIRE_INFO_LYSSIETH) {
                responses.add(new Response("\u8389\u897f\u4e1d", "\u4f60\u5df2\u7ecf\u95ee\u8fc7\u514b\u83b1\u5c14\u5173\u4e8e\u8389\u897f\u4e1d\u4e86\u3002", null));
            } else {
                responses.add(new Response("\u8389\u897f\u4e1d", "\u95ee\u95ee\u514b\u83b1\u5c14\u5173\u4e8e\u8389\u897f\u4e1d\u3002", CLAIRE_INFO_LYSSIETH){

                    @Override
                    public void effects() {
                        SubmissionGenericPlaces.applyClaireMeetingEffects();
                    }
                });
            }
            if (Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.claireAskedTeleportation)) {
                if (Main.game.getCurrentDialogueNode() == CLAIRE_INFO_SWORD_ORICL) {
                    responses.add(new Response("SWORD & ORICL", "\u4f60\u5df2\u7ecf\u95ee\u8fc7\u514b\u83b1\u5c14\u5173\u4e8e\u6267\u6cd5\u8005\u7684\u5206\u90e8\u201cSWORD\u201d\u548c\u201cORICL\u201d\u3002", null));
                } else {
                    responses.add(new Response("SWORD & ORICL", "\u95ee\u95ee\u514b\u83b1\u5c14\u6267\u6cd5\u8005\u7684\u5206\u90e8\u201cSWORD\u201d\u548c\u201cORICL\u201d\u3002", CLAIRE_INFO_SWORD_ORICL));
                }
            } else {
                responses.add(new Response("\u4f20\u9001\u677f", "\u95ee\u95ee\u514b\u83b1\u5c14\u4f20\u9001\u677f\u7684\u4e8b\u3002", CLAIRE_INFO_TELEPORTATION){

                    @Override
                    public void effects() {
                        Main.game.getDialogueFlags().setFlag(DialogueFlagValue.claireAskedTeleportation, true);
                        SubmissionGenericPlaces.applyClaireMeetingEffects();
                    }
                });
            }
            if (Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.claireAskedTeleportation)) {
                if (!Main.game.getPlayer().hasQuest(QuestLine.SIDE_TELEPORTATION) || !Main.game.getPlayer().isQuestCompleted(QuestLine.SIDE_TELEPORTATION)) {
                    if (!Main.game.getPlayer().isQuestCompleted(QuestLine.SIDE_SLIME_QUEEN)) {
                        responses.add(new Response("\u4f20\u9001\u677f", "\u5728\u5c48\u57ce\u533a\u6267\u884c\u8005\u6709\u7406\u7531\u76f8\u4fe1\u4f60\u4e4b\u524d\uff0c\u4f60\u65e0\u6cd5\u770b\u5230\u4f20\u9001\u677f\u2026\u2026<br/>[style.italicsMinorBad(\u8981\u9009\u62e9\u8fd9\u4e2a\u9009\u9879\uff0c\u4f60\u9700\u8981\u5b8c\u6210\u4efb\u52a1'" + QuestLine.SIDE_SLIME_QUEEN.getName() + "'.)]", null));
                    } else {
                        responses.add(new Response("\u4f20\u9001\u677f", "\u544a\u8bc9\u514b\u83b1\u5c14\u4f60\u60f3\u770b\u770b\u4f20\u9001\u677f\u3002<br/>[style.italicsQuestSide(\u8fd9\u5c06\u4f1a\u5f00\u542f\u4e00\u4e2a\u652f\u7ebf\u4efb\u52a1\uff0c\u4f60\u9700\u8981\u5148\u89e3\u51b3\u8be5\u4efb\u52a1\uff0c\u7136\u540e\u624d\u80fd\u7ee7\u7eed\u4e4b\u524d\u7684\u4e8b\u2026\u2026)]", CLAIRE_TELEPORTATION_PADS){

                            @Override
                            public void effects() {
                                SubmissionGenericPlaces.applyClaireMeetingEffects();
                            }

                            @Override
                            public Colour getHighlightColour() {
                                return PresetColour.QUEST_SIDE;
                            }
                        });
                    }
                } else if (Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.claireAskedWarehouseEscape)) {
                    responses.add(new ResponseSex("\u5371\u9669\u6027\u7231", "\u4ece\u4f60\u5728SWORD\u4ed3\u5e93\u7684\u7ecf\u5386\u6765\u770b\uff0c\u514b\u83b1\u5c14\u4f3c\u4e4e\u5bf9\u5371\u9669\u7684\u6027\u7231\u60c5\u6709\u72ec\u949f\u3002\u5982\u679c\u4f60\u60f3\u7684\u8bdd\uff0c\u4f60\u603b\u662f\u53ef\u4ee5\u6ee1\u8db3\u5979\u5bf9\u5b83\u7684\u6e34\u671b\u2026\u2026", true, true, new SexManagerDefault(SexPosition.STANDING, Util.newHashMapOfValues(new Util.Value<PlayerCharacter, SexSlot>(Main.game.getPlayer(), SexSlotStanding.STANDING_DOMINANT)), Util.newHashMapOfValues(new Util.Value<NPC, SexSlot>(Main.game.getNpc(Claire.class), SexSlotStanding.STANDING_SUBMISSIVE))){

                        @Override
                        public boolean isPublicSex() {
                            return false;
                        }
                    }, null, null, AFTER_CLAIRE_SEX, UtilText.parseFromXMLFile("places/submission/submissionPlaces", "START_CLAIRE_SEX")));
                } else {
                    responses.add(new Response("\u4ed3\u5e93", "\u95ee\u95ee\u514b\u83b1\u5c14\u662f\u5426\u8fd8\u8bb0\u5f97\u4f60\u4eceSWORD\u4ed3\u5e93\u9003\u8dd1\u7684\u4e8b\u3002", CLAIRE_WAREHOUSE){

                        @Override
                        public void effects() {
                            Main.game.getDialogueFlags().setFlag(DialogueFlagValue.claireAskedWarehouseEscape, true);
                            SubmissionGenericPlaces.applyClaireMeetingEffects();
                        }
                    });
                }
            }
            if (Main.game.getPlayer().getQuest(QuestLine.SIDE_SLIME_QUEEN) == Quest.SLIME_QUEEN_TWO) {
                responses.add(new Response("\u8fd4\u56de\u6c47\u62a5", "\u62a5\u544a\u53f2\u83b1\u59c6\u6240\u8bf4\u7684\u201c\u53f2\u83b1\u59c6\u5973\u738b\u201d\u3002", CLAIRE_INFO_REPORT_BACK){

                    @Override
                    public void effects() {
                        SubmissionGenericPlaces.applyClaireMeetingEffects();
                        Main.game.getTextEndStringBuilder().append(Main.game.getPlayer().incrementMoney(5000L));
                        Main.game.getTextEndStringBuilder().append(Main.game.getPlayer().setQuestProgress(QuestLine.SIDE_SLIME_QUEEN, Quest.SLIME_QUEEN_THREE));
                    }
                });
            } else if (Main.game.getPlayer().getQuest(QuestLine.SIDE_SLIME_QUEEN) == Quest.SLIME_QUEEN_SIX_SUBMIT || Main.game.getPlayer().getQuest(QuestLine.SIDE_SLIME_QUEEN) == Quest.SLIME_QUEEN_SIX_FORCE || Main.game.getPlayer().getQuest(QuestLine.SIDE_SLIME_QUEEN) == Quest.SLIME_QUEEN_SIX_CONVINCE) {
                responses.add(new Response("\u8fd4\u56de\u6c47\u62a5", "\u5411\u514b\u83b1\u5c14\u62a5\u544a\u4f60\u5df2\u7ecf\u6253\u8d25\u4e86\u53f2\u83b1\u59c6\u5973\u738b\u3002", CLAIRE_INFO_SLIME_QUEEN_REPORT_BACK){

                    @Override
                    public void effects() {
                        SubmissionGenericPlaces.applyClaireMeetingEffects();
                        Main.game.getTextEndStringBuilder().append(Main.game.getPlayer().incrementMoney(20000L));
                        Main.game.getTextEndStringBuilder().append(Main.game.getPlayer().addItem(Main.game.getItemGen().generateItem("dsg_quest_hazmat_rat_card"), false));
                        Main.game.getTextEndStringBuilder().append(Main.game.getPlayer().setQuestProgress(QuestLine.SIDE_SLIME_QUEEN, Quest.SIDE_UTIL_COMPLETE));
                    }
                });
            }
            if (!(!Main.game.getPlayer().hasQuest(QuestLine.SIDE_VENGAR) || Main.game.getPlayer().hasQuestInLine(QuestLine.SIDE_VENGAR, Quest.VENGAR_TWO_COOPERATION) || Main.game.getPlayer().hasQuestInLine(QuestLine.SIDE_VENGAR, Quest.VENGAR_OPTIONAL_CLAIRE) || Main.game.getPlayer().hasQuestInLine(QuestLine.SIDE_VENGAR, Quest.VENGAR_THREE_END) || Main.game.getPlayer().isQuestCompleted(QuestLine.SIDE_VENGAR))) {
                responses.add(new Response("\u6587\u52a0", "\u8bf7\u514b\u83b1\u5c14\u5e2e\u5fd9\u5bf9\u4ed8\u6587\u52a0\u3002", CLAIRE_VENGAR_HELP){

                    @Override
                    public void effects() {
                        SubmissionGenericPlaces.applyClaireMeetingEffects();
                    }
                });
            }
            if (Main.game.getPlayer().getQuest(QuestLine.SIDE_WES) == Quest.WES_2) {
                responses.add(new Response("\u533f\u540d\u4e3e\u62a5", "\u8be2\u95ee\u514b\u83b1\u5c14\u662f\u5426\u6709\u533f\u540d\u63d0\u4ea4\u72af\u7f6a\u6d3b\u52a8\u8bc1\u636e\u7684\u65b9\u6cd5\uff0c\u8fd9\u6837\u4f60\u5c31\u53ef\u4ee5\u5b58\u50a8\u6709\u57c3\u52d2\u4e0e\u9ed1\u5e2e\u6253\u4ea4\u9053\u8bc1\u636e\u7684\u5965\u672f\u5f55\u97f3\u673a\u4e86\u3002", WesQuest.CLAIRE_ELLE_EVIDENCE){

                    @Override
                    public void effects() {
                        SubmissionGenericPlaces.applyClaireMeetingEffects();
                    }
                });
            }
            for (int i = 0; i < responses.size(); ++i) {
                if (index != i) continue;
                return (Response)responses.get(i);
            }
            return null;
        }
    };
    public static final DialogueNode CLAIRE_INFO_REPORT_BACK = new DialogueNode("", "", true){

        @Override
        public int getSecondsPassed() {
            return 120;
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("places/submission/submissionPlaces", "CLAIRE_INFO_REPORT_BACK");
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1) {
                return new Response("\u7ee7\u7eed", "\u8ba9\u514b\u83b1\u5c14\u56de\u5230\u5979\u7684\u5de5\u4f5c\u5c97\u4f4d\uff0c\u7ee7\u7eed\u65c5\u9014\u3002", SEWER_ENTRANCE);
            }
            return null;
        }
    };
    public static final DialogueNode CLAIRE_INFO_SLIME_QUEEN_REPORT_BACK = new DialogueNode("", "", true){

        @Override
        public int getSecondsPassed() {
            return 120;
        }

        @Override
        public String getContent() {
            if (Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.slimeQueenHelped)) {
                return UtilText.parseFromXMLFile("places/submission/submissionPlaces", "CLAIRE_INFO_SLIME_QUEEN_REPORT_BACK_LIE");
            }
            return UtilText.parseFromXMLFile("places/submission/submissionPlaces", "CLAIRE_INFO_SLIME_QUEEN_REPORT_BACK");
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            return CLAIRE.getResponse(responseTab, index);
        }
    };
    public static final DialogueNode CLAIRE_VENGAR_HELP = new DialogueNode("", "", true){

        @Override
        public int getSecondsPassed() {
            return 120;
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("places/submission/submissionPlaces", "CLAIRE_VENGAR_HELP");
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1) {
                return new Response("\u7b49\u5f85", "\u7167\u514b\u83b1\u5c14\u8bf4\u7684\u505a\uff0c\u7b49\u5979\u56de\u6765\u3002", CLAIRE_VENGAR_HELP_WAIT){

                    @Override
                    public void effects() {
                        Main.game.getTextEndStringBuilder().append(Main.game.getPlayer().addOptionalQuestProgress(QuestLine.SIDE_VENGAR, Quest.VENGAR_OPTIONAL_CLAIRE));
                        Main.game.getTextEndStringBuilder().append(Main.game.getPlayer().addItem(Main.game.getItemGen().generateItem(ItemType.RESONANCE_STONE), false, true));
                    }
                };
            }
            return null;
        }
    };
    public static final DialogueNode CLAIRE_VENGAR_HELP_WAIT = new DialogueNode("", "", true, true){

        @Override
        public int getSecondsPassed() {
            return 600;
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("places/submission/submissionPlaces", "CLAIRE_VENGAR_HELP_WAIT");
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            return CLAIRE.getResponse(responseTab, index);
        }
    };
    public static final DialogueNode CLAIRE_INFO_SUBMISSION_SOCIETY = new DialogueNode("", "", true){

        @Override
        public int getSecondsPassed() {
            return 120;
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("places/submission/submissionPlaces", "CLAIRE_INFO_SUBMISSION_SOCIETY");
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            return CLAIRE.getResponse(responseTab, index);
        }
    };
    public static final DialogueNode CLAIRE_INFO_LYSSIETH = new DialogueNode("", "", true){

        @Override
        public int getSecondsPassed() {
            return 120;
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("places/submission/submissionPlaces", "CLAIRE_INFO_LYSSIETH");
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            return CLAIRE.getResponse(responseTab, index);
        }
    };
    public static final DialogueNode CLAIRE_INFO_TELEPORTATION = new DialogueNode("", "", true){

        @Override
        public int getSecondsPassed() {
            return 120;
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("places/submission/submissionPlaces", "CLAIRE_INFO_TELEPORTATION");
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            return CLAIRE.getResponse(responseTab, index);
        }
    };
    public static final DialogueNode CLAIRE_INFO_SWORD_ORICL = new DialogueNode("", "", true){

        @Override
        public int getSecondsPassed() {
            return 120;
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("places/submission/submissionPlaces", "CLAIRE_INFO_SWORD_ORICL");
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            return CLAIRE.getResponse(responseTab, index);
        }
    };
    public static final DialogueNode CLAIRE_TELEPORTATION_PADS = new DialogueNode("", "", true){

        @Override
        public int getSecondsPassed() {
            return 120;
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("places/submission/submissionPlaces", "CLAIRE_TELEPORTATION_PADS");
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1) {
                return new Response("\u4f20\u9001\uff01", "\u4f20\u9001\u677f\u5df2\u7ecf\u542f\u52a8\uff0c\u5c06\u4f60\u548c\u514b\u83b1\u5c14\u9001\u5f80\u672a\u77e5\u76ee\u7684\u5730\uff01", ENFORCER_WARHOUSE_APPEARANCE){

                    @Override
                    public void effects() {
                        EnforcerWarehouse.initWarehouse();
                        Main.game.getPlayer().setLocation(WorldType.ENFORCER_WAREHOUSE, PlaceType.ENFORCER_WAREHOUSE_ENCLOSURE_TELEPORT_PADS, false);
                        Main.game.getNpc(Claire.class).setLocation(Main.game.getPlayer(), false);
                        Main.game.getTextEndStringBuilder().append(UtilText.parseFromXMLFile("places/submission/submissionPlaces", "ENFORCER_WARHOUSE_APPEARANCE"));
                        if (Main.game.getPlayer().hasCompanions()) {
                            if (Main.game.getPlayer().getMainCompanion().isElemental()) {
                                Main.game.getTextEndStringBuilder().append(UtilText.parseFromXMLFile("places/submission/submissionPlaces", "ENFORCER_WARHOUSE_APPEARANCE_ELEMENTAL", Main.game.getPlayer().getMainCompanion()));
                            } else {
                                Main.game.getTextEndStringBuilder().append(UtilText.parseFromXMLFile("places/submission/submissionPlaces", "ENFORCER_WARHOUSE_APPEARANCE_COMPANIONS", Main.game.getPlayer().getMainCompanion()));
                            }
                            Main.game.getPlayer().removeAllCompanions(true);
                        } else {
                            Main.game.getTextEndStringBuilder().append(UtilText.parseFromXMLFile("places/submission/submissionPlaces", "ENFORCER_WARHOUSE_APPEARANCE_SOLO"));
                        }
                        Main.game.getTextEndStringBuilder().append(UtilText.parseFromXMLFile("places/submission/submissionPlaces", "ENFORCER_WARHOUSE_APPEARANCE_END"));
                        Main.game.getTextEndStringBuilder().append(Main.game.getPlayer().startQuest(QuestLine.SIDE_TELEPORTATION));
                    }
                };
            }
            return null;
        }
    };
    public static final DialogueNode ENFORCER_WARHOUSE_APPEARANCE = new DialogueNode("", "", true){

        @Override
        public int getSecondsPassed() {
            return 60;
        }

        @Override
        public String getContent() {
            return "";
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            return EnforcerWarehouse.ENCLOSURE_TELEPORT_PADS.getResponse(responseTab, index);
        }
    };
    public static final DialogueNode CLAIRE_WAREHOUSE = new DialogueNode("", "", true){

        @Override
        public int getSecondsPassed() {
            return 120;
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("places/submission/submissionPlaces", "CLAIRE_WAREHOUSE");
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            return CLAIRE.getResponse(responseTab, index);
        }
    };
    public static final DialogueNode AFTER_CLAIRE_SEX = new DialogueNode("\u7ed3\u675f", "\u514b\u83b1\u5c14\u548c\u4f60\u4ea4\u7f20\u7684\u8eab\u4f53\u5206\u5f00\u2026\u2026", true){

        @Override
        public int getSecondsPassed() {
            return 180;
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("places/submission/submissionPlaces", "AFTER_CLAIRE_SEX");
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            return CLAIRE.getResponse(responseTab, index);
        }
    };
    private static boolean vendingMachineInspected = false;
    private static boolean vendingMachineTalked = false;
    public static final DialogueNode VENDING_MACHINE = new DialogueNode("", "", true){

        @Override
        public void applyPreParsingEffects() {
            vendingMachineInspected = false;
            vendingMachineTalked = false;
        }

        @Override
        public int getSecondsPassed() {
            return 60;
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("places/submission/submissionPlaces", "VENDING_MACHINE");
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1) {
                return new ResponseTrade("\u4ea4\u6613", "\u770b\u770b\u81ea\u52a8\u552e\u8d27\u673a\u4eca\u5929\u5356\u4ec0\u4e48\u3002", Main.game.getNpc(HazmatRat.class)){

                    @Override
                    public void effects() {
                        ((HazmatRat)Main.game.getNpc(HazmatRat.class)).applyRestock();
                    }
                };
            }
            if (index == 2) {
                return new Response("\u5ba1\u89c6", vendingMachineInspected ? "\u4f60\u5df2\u7ecf\u8fd1\u8ddd\u79bb\u770b\u8fc7\u81ea\u52a8\u552e\u8d27\u673a\u4e86\u2026\u2026 " : "\u8fd1\u8ddd\u79bb\u770b\u770b\u81ea\u52a8\u552e\u8d27\u673a\u3002", vendingMachineInspected ? null : VENDING_MACHINE_MISC){

                    @Override
                    public void effects() {
                        Main.game.getTextStartStringBuilder().append(UtilText.parseFromXMLFile("places/submission/submissionPlaces", "VENDING_MACHINE_INSPECT"));
                        Main.game.getDialogueFlags().setFlag(DialogueFlagValue.vendingMachineTalked, true);
                        vendingMachineInspected = true;
                    }
                };
            }
            if (index == 3 && Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.vendingMachineTalked)) {
                return new Response("\u4ea4\u8c08", vendingMachineTalked ? "\u4f60\u5df2\u7ecf\u5c1d\u8bd5\u8fc7\u548c\u81ea\u52a8\u552e\u8d27\u673a\u8bf4\u8bdd\u4e86\u2026\u2026" : "\u4f60\u786e\u4fe1\u91cc\u9762\u4e00\u5b9a\u6709\u4eba\uff0c\u4e8e\u662f\u51b3\u5b9a\u5c1d\u8bd5\u4e0e\u81ea\u52a8\u552e\u8d27\u673a\u8bf4\u8bdd\u3002", vendingMachineTalked ? null : VENDING_MACHINE_MISC){

                    @Override
                    public void effects() {
                        Main.game.getTextStartStringBuilder().append(UtilText.parseFromXMLFile("places/submission/submissionPlaces", "VENDING_MACHINE_TALK"));
                        vendingMachineTalked = true;
                    }
                };
            }
            if (index == 0) {
                return new Response("\u8fd4\u56de", "\u79bb\u5f00\u81ea\u52a8\u552e\u8d27\u673a\uff0c\u53bb\u522b\u5904\u770b\u770b\u2026\u2026", SEWER_ENTRANCE);
            }
            return null;
        }
    };
    public static final DialogueNode VENDING_MACHINE_MISC = new DialogueNode("", "", true, true){

        @Override
        public int getSecondsPassed() {
            return 120;
        }

        @Override
        public String getContent() {
            return "";
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            return VENDING_MACHINE.getResponse(responseTab, index);
        }
    };

    private static void applyClaireMeetingEffects() {
        if (Main.game.getNpc(Claire.class).isVisiblyPregnant()) {
            Main.game.getNpc(Claire.class).setCharacterReactedToPregnancy(Main.game.getPlayer(), true);
        }
    }
}

