/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.dialogue.places.submission.dicePoker;

import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.npc.NPC;
import com.lilithsthrone.game.character.npc.submission.GamblingDenPatron;
import com.lilithsthrone.game.dialogue.DialogueNode;
import com.lilithsthrone.game.dialogue.places.submission.dicePoker.Dice;
import com.lilithsthrone.game.dialogue.places.submission.dicePoker.DiceFace;
import com.lilithsthrone.game.dialogue.places.submission.dicePoker.DicePokerTable;
import com.lilithsthrone.game.dialogue.places.submission.dicePoker.Hand;
import com.lilithsthrone.game.dialogue.responses.Response;
import com.lilithsthrone.game.dialogue.responses.ResponseEffectsOnly;
import com.lilithsthrone.game.dialogue.responses.ResponseSex;
import com.lilithsthrone.game.dialogue.responses.ResponseTag;
import com.lilithsthrone.game.dialogue.utils.ParserTag;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.game.sex.managers.universal.SMGeneric;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.rendering.SVGImages;
import com.lilithsthrone.utils.Util;
import com.lilithsthrone.utils.colours.PresetColour;
import java.util.ArrayList;
import java.util.List;

public class DicePoker {
    private static String dialoguePath;
    private static DialogueNode endingNode;
    private static int moneyPool;
    private static DicePokerTable table;
    private static NPC gambler;
    private static List<Dice> playerDice;
    private static List<Dice> gamblerDice;
    private static List<Dice> diceToReroll;
    private static String[] progressDescriptions;
    public static int progress;
    private static String responseContent;
    private static String buyInDescription;
    public static final DialogueNode GAMBLING;
    public static final DialogueNode GAMBLING_RULES;
    private static final DialogueNode START;
    private static final DialogueNode ROLL;
    private static final DialogueNode BET_NEED_REACT;
    private static final DialogueNode REROLL;
    private static final DialogueNode END_WIN;
    private static final DialogueNode END_DRAW;
    private static final DialogueNode END_LOSS;
    private static final DialogueNode END_LOSS_OFFER_BODY;
    private static final DialogueNode END_LOSS_AFTER_SEX;

    public static DialogueNode initDicePoker(NPC gambler, DicePokerTable table, DialogueNode endingNode, String dialoguePath) {
        DicePoker.dialoguePath = dialoguePath;
        DicePoker.endingNode = endingNode;
        DicePoker.table = table;
        progress = 0;
        moneyPool = table.getInitialBet() * 2;
        buyInDescription = Main.game.getPlayer().incrementMoney(-table.getInitialBet());
        DicePoker.gambler = gambler;
        if (DicePoker.gambler.getDice() != null) {
            gamblerDice = new ArrayList<Dice>(gambler.getDice());
        } else {
            gamblerDice = new ArrayList<Dice>();
            for (int i = 0; i < 5; ++i) {
                gamblerDice.add(new Dice());
            }
        }
        for (Dice d : playerDice) {
            d.setFace(DiceFace.ONE);
        }
        for (Dice d : gamblerDice) {
            d.setFace(DiceFace.ONE);
        }
        diceToReroll.clear();
        diceToReroll.addAll(playerDice);
        diceToReroll.addAll(gamblerDice);
        return START;
    }

    public static List<Dice> getPlayerDice() {
        return playerDice;
    }

    public static boolean isAbleToSelectReroll() {
        return !Main.game.getCurrentDialogueNode().equals(START) && !Main.game.getCurrentDialogueNode().equals(END_WIN) && !Main.game.getCurrentDialogueNode().equals(END_DRAW) && !Main.game.getCurrentDialogueNode().equals(END_LOSS);
    }

    public static void setReroll(Dice d) {
        if (diceToReroll.contains(d)) {
            diceToReroll.remove(d);
        } else {
            diceToReroll.add(d);
        }
        Main.game.setContent(new Response("", "", Main.game.getCurrentDialogueNode()));
    }

    private static String getGamblingFormat(String turnText) {
        UtilText.nodeContentSB.setLength(0);
        int comparingHands = Hand.compareHands(playerDice, gamblerDice);
        UtilText.nodeContentSB.append("<div class='container-half-width'>");
        for (int i = 0; i < playerDice.size(); ++i) {
            UtilText.nodeContentSB.append("<div class='modifier-icon' style='width:18%; margin:0 1%; border:3px solid " + (diceToReroll.contains(playerDice.get(i)) ? PresetColour.GENERIC_MINOR_GOOD.toWebHexString() : "") + ";'>" + (String)(Hand.getDiceInHand(playerDice).contains(playerDice.get(i)) ? "<div style='width:100%;height:100%;position:absolute;left:0;bottom:0;padding:0;margin:0'>" + SVGImages.SVG_IMAGE_PROVIDER.getDiceGlow() + "</div>" : "") + "<div class='modifier-icon-content'>" + playerDice.get(i).getFace().getSVGString() + "</div><div class='overlay' id='DICE_PLAYER_" + i + "'></div></div>");
        }
        Hand playerHand = Hand.getHand(playerDice);
        UtilText.nodeContentSB.append("<div class='container-full-width' style='text-align:center;'><b>" + playerHand.getRanking() + ". " + playerHand.getName() + "</b>| [style.colourDisabled(\u4ef7\u503c: " + Hand.getValue(playerDice) + ")]<br/>" + (comparingHands == 0 ? "[style.colourDisabled(\u4f60" + (progress == 3 ? "\u5e73\u5c40\u4e86" : "\u8981\u5e73\u5c40\u4e86") + "\u2026\u2026)]" : (comparingHands < 0 ? "[style.colourTerrible(\u4f60" + (progress == 3 ? "\u8f93\u4e86" : "\u8981\u8f93\u4e86") + "\uff01)]" : "[style.colourExcellent(\u4f60" + (progress == 3 ? "\u8d62\u4e86" : "\u8981\u8d62\u4e86") + "\uff01)]")) + "</div>");
        UtilText.nodeContentSB.append("</div>");
        UtilText.nodeContentSB.append("<div class='container-half-width'>");
        for (int i = 0; i < gamblerDice.size(); ++i) {
            UtilText.nodeContentSB.append("<div class='modifier-icon' style='width:18%; margin:0 1%; border:3px solid " + (diceToReroll.contains(gamblerDice.get(i)) ? PresetColour.GENERIC_MINOR_GOOD.toWebHexString() : "") + ";'>" + (String)(Hand.getDiceInHand(gamblerDice).contains(gamblerDice.get(i)) ? "<div style='width:100%;height:100%;position:absolute;left:0;bottom:0;padding:0;margin:0'>" + SVGImages.SVG_IMAGE_PROVIDER.getDiceGlow() + "</div>" : "") + "<div class='modifier-icon-content'>" + gamblerDice.get(i).getFace().getSVGString() + "</div></div>");
        }
        Hand gamblerHand = Hand.getHand(gamblerDice);
        UtilText.nodeContentSB.append("<div class='container-full-width' style='text-align:center;'><b>" + gamblerHand.getRanking() + "." + gamblerHand.getName() + "</b>| [style.colourDisabled(\u4ef7\u503c: " + Hand.getValue(gamblerDice) + ")]<br/>" + UtilText.parse((GameCharacter)gambler, comparingHands == 0 ? "[style.colourDisabled([npc.Name]" + (progress == 3 ? "\u5e73\u5c40\u4e86" : "\u8981\u5e73\u5c40\u4e86") + "\u2026\u2026)]" : (comparingHands > 0 ? "[style.colourTerrible([npc.Name]" + (progress == 3 ? "\u8f93\u4e86" : "\u8981\u8f93\u4e86") + "\uff01)]" : "[style.colourExcellent([npc.Name]" + (progress == 3 ? "\u8d62\u4e86" : "\u8981\u8d62\u4e86") + "\uff01)]"), new ParserTag[0]) + "</div>");
        UtilText.nodeContentSB.append("</div>");
        UtilText.nodeContentSB.append("<div class='container-full-width'>");
        UtilText.nodeContentSB.append("<div class='container-quarter-width' style='width:13%; margin:0 2%; text-align:center;'>\u8fdb\u5ea6:</div>");
        for (int i = 0; i < progressDescriptions.length; ++i) {
            UtilText.nodeContentSB.append((String)(i != 0 ? "<div class='container-quarter-width inner' style='width:5%; margin:0; text-align:center;'>" + (progress < i ? "&gt;" : "[style.colourDisabledDark(&gt;)]") + "</div>" : "") + "<div class='container-quarter-width inner' style='box-sizing:border-box; width:13%; margin:0 2%; text-align:center; " + (progress == i ? "border:1px solid #777;" : "") + "'>" + (String)(progress == i ? "[style.boldGood(" + progressDescriptions[i] + ")]" : (progress < i ? progressDescriptions[i] : "[style.colourDisabledDark(" + progressDescriptions[i] + ")]")) + "</div>");
        }
        UtilText.nodeContentSB.append("<div class='container-full-width' style='text-align:center;'>\u603b\u5956\u6c60: " + UtilText.formatAsMoney(moneyPool, "span") + "</div>");
        UtilText.nodeContentSB.append("</div>");
        UtilText.nodeContentSB.append(UtilText.parse((GameCharacter)gambler, turnText, new ParserTag[0]));
        return UtilText.nodeContentSB.toString();
    }

    private static void rollRice() {
        for (Dice dice : diceToReroll) {
            dice.roll();
        }
        diceToReroll.clear();
    }

    private static long getRaiseAmount() {
        if (Main.game.getPlayer().getMoney() < (long)table.getRaiseAmount()) {
            return Main.game.getPlayer().getMoney();
        }
        return table.getRaiseAmount();
    }

    private static boolean isGamblerRaising() {
        int differenceWillingToRaiseAt = -Util.random.nextInt(3) - 1;
        return Hand.getHand(playerDice) != Hand.getHand(gamblerDice) && Hand.compareHands(playerDice, gamblerDice) < differenceWillingToRaiseAt;
    }

    private static boolean isGamblerFolding() {
        int differenceWillingToFoldAt = Util.random.nextInt(6) + 4;
        return Hand.getHand(playerDice) != Hand.getHand(gamblerDice) && Hand.compareHands(playerDice, gamblerDice) > differenceWillingToFoldAt;
    }

    private static void calculateGamblerRerolls() {
        ArrayList<Dice> rerollDice = new ArrayList<Dice>(gamblerDice);
        if (Hand.getHand(gamblerDice) != Hand.NINE_RUNT) {
            rerollDice.removeAll(Hand.getDiceInHand(gamblerDice));
        }
        diceToReroll.addAll(rerollDice);
    }

    static {
        playerDice = new ArrayList<Dice>();
        gamblerDice = new ArrayList<Dice>();
        diceToReroll = new ArrayList<Dice>();
        progressDescriptions = new String[]{"\u6447\u70b9", "\u4e0b\u6ce8", "\u91cd\u6447", "\u652f\u4ed8"};
        progress = 0;
        for (int i = 0; i < 5; ++i) {
            playerDice.add(new Dice());
            gamblerDice.add(new Dice());
        }
        GAMBLING = new DialogueNode("\u9ab0\u5b50\u6251\u514b\u684c", "", false){

            @Override
            public String getContent() {
                return "";
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                List<NPC> gamblers = Main.game.getNonCompanionCharactersPresent();
                if (index == 0) {
                    return null;
                }
                if (index == gamblers.size() + 1) {
                    return new Response("\u89c4\u5219", "\u9605\u8bfb\u9644\u8fd1\u5c55\u793a\u9ab0\u5b50\u6251\u514b\u89c4\u5219\u7684\u6807\u5fd7\u3002", GAMBLING_RULES);
                }
                try {
                    gamblers.sort((g1, g2) -> ((GamblingDenPatron)g1).getTable().compareTo(((GamblingDenPatron)g2).getTable()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (index - 1 < gamblers.size()) {
                    final NPC gambler = gamblers.get(index - 1);
                    final DicePokerTable table = gambler instanceof GamblingDenPatron && ((GamblingDenPatron)gambler).getTable() != null ? ((GamblingDenPatron)gambler).getTable() : DicePokerTable.COPPER;
                    int buyIn = table.getInitialBet() + table.getRaiseAmount();
                    if (Main.game.getPlayer().getMoney() >= (long)buyIn) {
                        return new ResponseEffectsOnly("<span style='color:" + table.getColour().toWebHexString() + ";'>" + UtilText.parse((GameCharacter)gambler, "[npc.Name(a)]", new ParserTag[0]) + "</span> (" + UtilText.formatAsMoney(buyIn, "span") + ")", UtilText.parse((GameCharacter)gambler, "\u8ddf[npc.name]\u6765\u4e00\u628a\u9ab0\u5b50\u6251\u514b\u3002\u5165\u6ce8\u91d1\u989d\u4e3a" + UtilText.formatAsMoney(table.getInitialBet(), "span") + "\uff0c\u4f46\u60f3\u8981\u52a0\u6ce8\u5219\u8fd8\u9700\u8981" + UtilText.formatAsMoney(table.getRaiseAmount(), "span") + "\u3002", new ParserTag[0])){

                            @Override
                            public void effects() {
                                Main.game.setContent(new Response("", "", DicePoker.initDicePoker(gambler, table, Main.game.getDefaultDialogue(), "misc/dicePoker")));
                            }
                        };
                    }
                    return new Response(gambler.getName(true) + " (" + UtilText.formatAsMoneyUncoloured(buyIn, "span") + ")", "\u5165\u6ce8\u91d1\u989d\u4e3a" + UtilText.formatAsMoney(table.getInitialBet(), "span") + "\uff0c\u4f46\u60f3\u8981\u52a0\u6ce8\u5219\u8fd8\u9700\u8981" + UtilText.formatAsMoney(table.getRaiseAmount(), "span") + "\u3002\u6240\u4ee5\u4f60\u94b1\u4e0d\u591f\u5728\u8fd9\u4e2a\u684c\u5b50\u4e0a\u8d4c\uff01", null);
                }
                return null;
            }
        };
        GAMBLING_RULES = new DialogueNode("\u9ab0\u5b50\u6251\u514b\u684c", "", true){

            @Override
            public String getContent() {
                return UtilText.parseFromXMLFile("places/submission/gamblingDen/main", "GAMBLING_RULES");
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                if (index == 0) {
                    return new Response("\u8fd4\u56de", "\u8bfb\u5b8c\u89c4\u5219\uff0c\u4ece\u65c1\u8fb9\u9000\u5f00\u3002", Main.game.getDefaultDialogue());
                }
                return null;
            }
        };
        START = new DialogueNode("\u9ab0\u5b50\u6251\u514b", "", true){

            @Override
            public void applyPreParsingEffects() {
                UtilText.addSpecialParsingString(table.getName(), true);
                UtilText.addSpecialParsingString(UtilText.formatAsMoney(table.getInitialBet(), "span"), false);
                Main.game.appendToTextStartStringBuilder(DicePoker.getGamblingFormat(buyInDescription + UtilText.parseFromXMLFile(dialoguePath, "START", gambler)));
                gambler.setPlayerKnowsName(true);
            }

            @Override
            public String getLabel() {
                return "\u9ab0\u5b50\u6251\u514b -<b style='color:" + table.getColour().toWebHexString() + ";'>" + Util.capitaliseSentence(table.getName()) + "</b>";
            }

            @Override
            public String getContent() {
                return "";
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                if (index == 1) {
                    return new Response("\u6447\u70b9", "\u6447\u9ab0\u5b50\u3002", ROLL){

                        @Override
                        public void effects() {
                            DicePoker.rollRice();
                            ++progress;
                        }
                    };
                }
                return null;
            }
        };
        ROLL = new DialogueNode("\u9ab0\u5b50\u6251\u514b", "", true){

            @Override
            public String getContent() {
                if (Hand.compareHands(playerDice, gamblerDice) > 0) {
                    return DicePoker.getGamblingFormat(UtilText.parseFromXMLFile(dialoguePath, "ROLL_WINNING", gambler));
                }
                if (Hand.compareHands(playerDice, gamblerDice) == 0) {
                    return DicePoker.getGamblingFormat(UtilText.parseFromXMLFile(dialoguePath, "ROLL_DRAWING", gambler));
                }
                return DicePoker.getGamblingFormat(UtilText.parseFromXMLFile(dialoguePath, "ROLL_LOSING", gambler));
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                if (index == 1) {
                    return new ResponseEffectsOnly("\u8ddf\u6ce8", "\u4e0d\u63d0\u9ad8\u8d4c\u6ce8\u3002"){

                        @Override
                        public void effects() {
                            UtilText.addSpecialParsingString(UtilText.formatAsMoney(DicePoker.getRaiseAmount(), "span"), true);
                            if (DicePoker.isGamblerRaising()) {
                                moneyPool = (int)((long)moneyPool + DicePoker.getRaiseAmount());
                                responseContent = UtilText.parseFromXMLFile(dialoguePath, "ROLL_CALL_OPPONENT_RAISES", gambler);
                                Main.game.setContent(new Response("", "", BET_NEED_REACT));
                            } else {
                                responseContent = UtilText.parseFromXMLFile(dialoguePath, "ROLL_CALL_OPPONENT_CALLS", gambler);
                                DicePoker.calculateGamblerRerolls();
                                ++progress;
                                Main.game.setContent(new Response("", "", REROLL));
                            }
                        }
                    };
                }
                if (index == 2) {
                    return new ResponseEffectsOnly("\u52a0\u6ce8", "\u63d0\u9ad8\u8d4c\u6ce8\u3002"){

                        @Override
                        public void effects() {
                            UtilText.addSpecialParsingString(UtilText.formatAsMoney(DicePoker.getRaiseAmount(), "span"), true);
                            if (DicePoker.isGamblerFolding()) {
                                String moneyChange = Main.game.getPlayer().incrementMoney(moneyPool);
                                UtilText.addSpecialParsingString(moneyChange, false);
                                responseContent = UtilText.parseFromXMLFile(dialoguePath, "ROLL_RAISE_OPPONENT_FOLDS", gambler);
                                ++progress;
                                ++progress;
                                Main.game.setContent(new Response("", "", END_WIN));
                            } else {
                                moneyPool = (int)((long)moneyPool + DicePoker.getRaiseAmount() * 2L);
                                String moneyChange = Main.game.getPlayer().incrementMoney(-DicePoker.getRaiseAmount());
                                UtilText.addSpecialParsingString(moneyChange, false);
                                responseContent = UtilText.parseFromXMLFile(dialoguePath, "ROLL_RAISE_OPPONENT_CALLS", gambler);
                                DicePoker.calculateGamblerRerolls();
                                ++progress;
                                Main.game.setContent(new Response("", "", REROLL));
                            }
                        }
                    };
                }
                return null;
            }
        };
        BET_NEED_REACT = new DialogueNode("\u9ab0\u5b50\u6251\u514b", "", true){

            @Override
            public String getContent() {
                return DicePoker.getGamblingFormat(responseContent);
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                if (index == 1) {
                    return new ResponseEffectsOnly("\u8ddf\u6ce8(" + UtilText.formatAsMoney(DicePoker.getRaiseAmount(), "span") + ")", UtilText.parse((GameCharacter)gambler, "\u8ddf\u968f[npc.namePos]\u52a0\u6ce8" + UtilText.formatAsMoney(DicePoker.getRaiseAmount(), "span") + "\u3002", new ParserTag[0])){

                        @Override
                        public void effects() {
                            UtilText.addSpecialParsingString(UtilText.formatAsMoney(DicePoker.getRaiseAmount(), "span"), true);
                            moneyPool = (int)((long)moneyPool + DicePoker.getRaiseAmount());
                            String moneyChange = Main.game.getPlayer().incrementMoney(-DicePoker.getRaiseAmount());
                            UtilText.addSpecialParsingString(moneyChange, false);
                            responseContent = UtilText.parseFromXMLFile(dialoguePath, "BET_NEED_REACT_CALL", gambler);
                            DicePoker.calculateGamblerRerolls();
                            ++progress;
                            Main.game.setContent(new Response("", "", REROLL));
                        }
                    };
                }
                if (index == 2) {
                    return new ResponseEffectsOnly("\u5f03\u6743", UtilText.parse((GameCharacter)gambler, "\u5411[npc.namePos]\u6295\u964d\uff0c\u8ba9[npc.herHim]\u62ff\u8d70\u5956\u6c60\u4e2d" + UtilText.formatAsMoney(moneyPool, "span") + "\u3002", new ParserTag[0])){

                        @Override
                        public void effects() {
                            moneyPool = (int)((long)moneyPool + DicePoker.getRaiseAmount());
                            UtilText.addSpecialParsingString(UtilText.formatAsMoney(moneyPool, "span"), true);
                            responseContent = UtilText.parseFromXMLFile(dialoguePath, "BET_NEED_REACT_FOLD", gambler);
                            ++progress;
                            ++progress;
                            Main.game.setContent(new Response("", "", END_LOSS));
                        }
                    };
                }
                return null;
            }
        };
        REROLL = new DialogueNode("\u9ab0\u5b50\u6251\u514b", "", true){

            @Override
            public String getContent() {
                return DicePoker.getGamblingFormat(responseContent);
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                boolean reroll = false;
                for (Dice d : playerDice) {
                    if (!diceToReroll.contains(d)) continue;
                    reroll = true;
                    break;
                }
                if (index == 1) {
                    return new ResponseEffectsOnly(reroll ? "\u91cd\u6447" : "\u4e0d\u91cd\u6447", reroll ? "\u6447\u9ab0\u5b50\u3002" : "\u9009\u62e9\u4e0d\u91cd\u6447\u4efb\u4f55\u4e00\u679a\u9ab0\u5b50\u3002(\u70b9\u51fb\u9009\u4e2d\u9ab0\u5b50\u6765\u91cd\u6447\u3002)"){

                        @Override
                        public void effects() {
                            boolean diceRerolled = !diceToReroll.isEmpty();
                            DicePoker.rollRice();
                            if (Hand.compareHands(playerDice, gamblerDice) == 0) {
                                UtilText.addSpecialParsingString(UtilText.formatAsMoney(moneyPool), true);
                                UtilText.addSpecialParsingString(Main.game.getPlayer().incrementMoney(moneyPool / 2), false);
                                responseContent = diceRerolled ? UtilText.parseFromXMLFile(dialoguePath, "REROLL_DRAW_WITH_ROLL", gambler) : UtilText.parseFromXMLFile(dialoguePath, "REROLL_DRAW_WITHOUT_ROLL", gambler);
                                ++progress;
                                Main.game.setContent(new Response("", "", END_DRAW));
                            } else if (Hand.compareHands(playerDice, gamblerDice) > 0) {
                                String moneyChange = Main.game.getPlayer().incrementMoney(moneyPool);
                                UtilText.addSpecialParsingString(moneyChange, true);
                                responseContent = diceRerolled ? UtilText.parseFromXMLFile(dialoguePath, "REROLL_WIN_WITH_ROLL", gambler) : UtilText.parseFromXMLFile(dialoguePath, "REROLL_WIN_WITHOUT_ROLL", gambler);
                                ++progress;
                                Main.game.setContent(new Response("", "", END_WIN));
                            } else {
                                UtilText.addSpecialParsingString(UtilText.formatAsMoney(moneyPool, "span"), true);
                                responseContent = diceRerolled ? UtilText.parseFromXMLFile(dialoguePath, "REROLL_LOSS_WITH_ROLL", gambler) : UtilText.parseFromXMLFile(dialoguePath, "REROLL_LOSS_WITHOUT_ROLL", gambler);
                                ++progress;
                                Main.game.setContent(new Response("", "", END_LOSS));
                            }
                        }
                    };
                }
                return null;
            }
        };
        END_WIN = new DialogueNode("\u9ab0\u5b50\u6251\u514b", "", true){

            @Override
            public String getContent() {
                return DicePoker.getGamblingFormat(responseContent);
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                if (index == 1) {
                    return new Response("\u7ee7\u7eed", "\u79bb\u684c\u5b50\u8fdc\u70b9\u3002", endingNode){

                        @Override
                        public void effects() {
                            progress = 0;
                        }
                    };
                }
                return null;
            }
        };
        END_DRAW = new DialogueNode("\u9ab0\u5b50\u6251\u514b", "", true){

            @Override
            public String getContent() {
                return DicePoker.getGamblingFormat(responseContent);
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                if (index == 1) {
                    return new Response("\u7ee7\u7eed", "\u79bb\u684c\u5b50\u8fdc\u70b9\u3002", endingNode){

                        @Override
                        public void effects() {
                            progress = 0;
                        }
                    };
                }
                return null;
            }
        };
        END_LOSS = new DialogueNode("\u9ab0\u5b50\u6251\u514b", "", true){

            @Override
            public String getContent() {
                return DicePoker.getGamblingFormat(responseContent);
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                if (index == 1) {
                    return new Response("\u63a5\u53d7\u635f\u5931", "\u4ece\u684c\u65c1\u8d70\u5f00\u3002", endingNode){

                        @Override
                        public void effects() {
                            progress = 0;
                        }
                    };
                }
                if (index == 2) {
                    if (!gambler.isAttractedTo(Main.game.getPlayer())) {
                        return new Response("\u732e\u4e0a\u8eab\u4f53", UtilText.parse((GameCharacter)gambler, "[npc.Name]\u5e76\u6ca1\u6709\u88ab\u4f60\u5438\u5f15\uff0c\u6240\u4ee5\u4e5f\u5c31\u65e0\u6cd5\u901a\u8fc7\u732e\u4e0a\u8eab\u4f53\u4ee3\u66ff\u4ed8\u94b1\u3002", new ParserTag[0]), null);
                    }
                    return new Response("\u732e\u4e0a\u8eab\u4f53", UtilText.parse((GameCharacter)gambler, "\u5982\u679c[npc.name]\u80fd\u628a\u94b1\u8fd8\u56de\u6765\uff0c\u90a3\u4f60\u53ef\u4ee5\u8ba9[npc.she]\u968f\u610f\u4f7f\u7528\u4f60\u7684\u8eab\u4f53\u3002", new ParserTag[0]), END_LOSS_OFFER_BODY);
                }
                return null;
            }
        };
        END_LOSS_OFFER_BODY = new DialogueNode("\u9ab0\u5b50\u6251\u514b", "", true){

            @Override
            public String getContent() {
                return UtilText.parseFromXMLFile(dialoguePath, "END_LOSS_OFFER_BODY", gambler);
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                if (index == 1) {
                    return new Response("\u62d2\u7edd", "\u4ece\u684c\u65c1\u8d70\u5f00\u3002", endingNode){

                        @Override
                        public void effects() {
                            progress = 0;
                            Main.game.getTextStartStringBuilder().append(UtilText.parseFromXMLFile(dialoguePath, "END_LOSS_OFFER_BODY_DECLINE", gambler));
                        }
                    };
                }
                if (index == 2) {
                    return new ResponseSex("\u63a5\u53d7", UtilText.parse((GameCharacter)gambler, "\u5141\u8bb8[npc.name]\u516c\u5f00\u8ddf\u4f60\u4ea4\u5abe\uff0c\u6765\u53d6\u56de\u4f60\u8f93\u6389\u7684\u94b1\u3002", new ParserTag[0]), true, false, new SMGeneric(Util.newArrayListOfValues(gambler), Util.newArrayListOfValues(Main.game.getPlayer()), null, null, new ResponseTag[0]), END_LOSS_AFTER_SEX, UtilText.parseFromXMLFile(dialoguePath, "END_LOSS_OFFER_BODY_ACCEPT", gambler)){

                        @Override
                        public void effects() {
                            Main.game.getTextStartStringBuilder().append(Main.game.getPlayer().incrementMoney(moneyPool / 2));
                        }
                    };
                }
                return null;
            }
        };
        END_LOSS_AFTER_SEX = new DialogueNode("\u7ed3\u675f", "", true){

            @Override
            public String getDescription() {
                return UtilText.parse((GameCharacter)gambler, "[npc.Name]\u5df2\u7ecf\u723d\u591f\u4e86\uff0c\u6027\u7231\u5c31\u6b64\u7ed3\u675f\u2026\u2026", new ParserTag[0]);
            }

            @Override
            public String getContent() {
                return UtilText.parseFromXMLFile(dialoguePath, "END_LOSS_AFTER_SEX", gambler);
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                if (index == 1) {
                    return new Response("\u7ee7\u7eed", "\u79bb\u684c\u5b50\u8fdc\u70b9\u3002", endingNode){

                        @Override
                        public void effects() {
                            progress = 0;
                        }
                    };
                }
                return null;
            }
        };
    }
}

