/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.dialogue.places.submission.dicePoker;

import com.lilithsthrone.game.dialogue.places.submission.dicePoker.Dice;
import com.lilithsthrone.game.dialogue.places.submission.dicePoker.DiceFace;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public enum Hand {
    ONE_FIVE_OF_A_KIND(1, "\u4e94\u6761", "33333", "\u4e94\u679a\u540c\u70b9\u6570\u7684\u9ab0\u5b50\u3002"),
    TWO_FOUR_OF_A_KIND(2, "\u56db\u6761", "55551", "\u56db\u679a\u540c\u70b9\u6570\u7684\u9ab0\u5b50\u3002"),
    THREE_HIGH_STRAIGHT(3, "\u5927\u987a\u5b50", "23456", "\u4ece\u4e8c\u5f00\u59cb\u7684\u8fde\u7eed\u6570\u5b57\u3002"),
    FOUR_FULL_HOUSE(4, "\u846b\u82a6", "22666", "\u4e24\u679a\u540c\u70b9\u6570\u7684\u9ab0\u5b50\uff0c\u52a0\u4e0a\u4e09\u679a\u540c\u70b9\u6570\uff0c\u4f46\u4e0e\u4e4b\u524d\u70b9\u6570\u76f8\u5f02\u7684\u9ab0\u5b50\u3002"),
    FIVE_THREE_OF_A_KIND(5, "\u4e09\u6761", "44415", "\u4e09\u679a\u540c\u70b9\u6570\u7684\u9ab0\u5b50\u3002"),
    SIX_LOW_STRAIGHT(6, "\u5c0f\u987a\u5b50", "12345", "\u4ece\u4e00\u5f00\u59cb\u7684\u8fde\u7eed\u6570\u5b57\u3002"),
    SEVEN_TWO_PAIR(7, "\u4e24\u5bf9", "55331", "\u4e24\u679a\u540c\u70b9\u6570\u7684\u9ab0\u5b50\uff0c\u52a0\u4e0a\u4e24\u679a\u540c\u70b9\u6570\uff0c\u4f46\u4e0e\u4e4b\u524d\u70b9\u6570\u76f8\u5f02\u7684\u9ab0\u5b50\u3002"),
    EIGHT_PAIR(8, "\u4e00\u5bf9", "22415", "\u4e24\u679a\u540c\u70b9\u6570\u7684\u9ab0\u5b50\u3002"),
    NINE_RUNT(9, "\u70c2\u624b", "13456", "\u6240\u6709\u9ab0\u5b50\u70b9\u6570\u90fd\u4e0d\u540c\u3002");

    private int ranking;
    private String name;
    private String example;
    private String exampleDescription;

    private Hand(int ranking, String name, String example, String exampleDescription) {
        this.ranking = ranking;
        this.name = name;
        this.example = example;
        this.exampleDescription = exampleDescription;
    }

    public static int compareHands(List<Dice> playerDice, List<Dice> gamblerDice) {
        Hand playerHand = Hand.getHand(playerDice);
        Hand gamblerHand = Hand.getHand(gamblerDice);
        if (playerHand.getRanking() == gamblerHand.getRanking()) {
            return Hand.getValue(playerDice) - Hand.getValue(gamblerDice);
        }
        return gamblerHand.getRanking() - playerHand.getRanking();
    }

    public static Hand getHand(List<Dice> dice) {
        HashMap<DiceFace, Integer> faceCount = new HashMap<DiceFace, Integer>();
        for (Dice d : dice) {
            faceCount.putIfAbsent(d.getFace(), 0);
            faceCount.put(d.getFace(), (Integer)faceCount.get((Object)d.getFace()) + 1);
        }
        if (faceCount.size() == 1) {
            return ONE_FIVE_OF_A_KIND;
        }
        if (faceCount.containsValue(4)) {
            return TWO_FOUR_OF_A_KIND;
        }
        if (faceCount.containsKey((Object)DiceFace.TWO) && faceCount.containsKey((Object)DiceFace.THREE) && faceCount.containsKey((Object)DiceFace.FOUR) && faceCount.containsKey((Object)DiceFace.FIVE) && faceCount.containsKey((Object)DiceFace.SIX)) {
            return THREE_HIGH_STRAIGHT;
        }
        if (faceCount.containsValue(2) && faceCount.containsValue(3)) {
            return FOUR_FULL_HOUSE;
        }
        if (faceCount.containsValue(3)) {
            return FIVE_THREE_OF_A_KIND;
        }
        if (faceCount.containsKey((Object)DiceFace.ONE) && faceCount.containsKey((Object)DiceFace.TWO) && faceCount.containsKey((Object)DiceFace.THREE) && faceCount.containsKey((Object)DiceFace.FOUR) && faceCount.containsKey((Object)DiceFace.FIVE)) {
            return SIX_LOW_STRAIGHT;
        }
        if (faceCount.containsValue(2) && faceCount.size() == 3) {
            return SEVEN_TWO_PAIR;
        }
        if (faceCount.containsValue(2)) {
            return EIGHT_PAIR;
        }
        return NINE_RUNT;
    }

    public static List<Dice> getDiceInHand(List<Dice> dice) {
        ArrayList<Dice> diceInHand;
        block5: {
            HashMap<DiceFace, Integer> faceCount;
            block8: {
                block7: {
                    block6: {
                        diceInHand = new ArrayList<Dice>(dice);
                        faceCount = new HashMap<DiceFace, Integer>();
                        for (Dice dice2 : dice) {
                            faceCount.putIfAbsent(dice2.getFace(), 0);
                            faceCount.put(dice2.getFace(), (Integer)faceCount.get((Object)dice2.getFace()) + 1);
                        }
                        if (faceCount.size() == 1) break block5;
                        if (!faceCount.containsValue(4)) break block6;
                        for (Map.Entry entry : faceCount.entrySet()) {
                            if ((Integer)entry.getValue() == 4) continue;
                            diceInHand.removeIf(d -> d.getFace() == entry.getKey());
                        }
                        break block5;
                    }
                    if (faceCount.containsKey((Object)DiceFace.TWO) && faceCount.containsKey((Object)DiceFace.THREE) && faceCount.containsKey((Object)DiceFace.FOUR) && faceCount.containsKey((Object)DiceFace.FIVE) && faceCount.containsKey((Object)DiceFace.SIX) || faceCount.containsValue(2) && faceCount.containsValue(3)) break block5;
                    if (!faceCount.containsValue(3)) break block7;
                    for (Map.Entry entry : faceCount.entrySet()) {
                        if ((Integer)entry.getValue() == 3) continue;
                        diceInHand.removeIf(d -> d.getFace() == entry.getKey());
                    }
                    break block5;
                }
                if (faceCount.containsKey((Object)DiceFace.ONE) && faceCount.containsKey((Object)DiceFace.TWO) && faceCount.containsKey((Object)DiceFace.THREE) && faceCount.containsKey((Object)DiceFace.FOUR) && faceCount.containsKey((Object)DiceFace.FIVE)) break block5;
                if (!faceCount.containsValue(2) || faceCount.size() != 3) break block8;
                for (Map.Entry entry : faceCount.entrySet()) {
                    if ((Integer)entry.getValue() == 2) continue;
                    diceInHand.removeIf(d -> d.getFace() == entry.getKey());
                }
                break block5;
            }
            if (!faceCount.containsValue(2)) break block5;
            for (Map.Entry entry : faceCount.entrySet()) {
                if ((Integer)entry.getValue() == 2) continue;
                diceInHand.removeIf(d -> d.getFace() == entry.getKey());
            }
        }
        return diceInHand;
    }

    public static int getValue(List<Dice> dice) {
        HashMap<DiceFace, Integer> faceCount = new HashMap<DiceFace, Integer>();
        for (Dice d : dice) {
            faceCount.putIfAbsent(d.getFace(), 0);
            faceCount.put(d.getFace(), (Integer)faceCount.get((Object)d.getFace()) + 1);
        }
        if (faceCount.size() == 1) {
            Iterator<Object> iterator = faceCount.entrySet().iterator();
            if (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                return ((DiceFace)((Object)entry.getKey())).getValue() * 5;
            }
        } else if (faceCount.containsValue(4)) {
            for (Map.Entry entry : faceCount.entrySet()) {
                if ((Integer)entry.getValue() != 4) continue;
                return ((DiceFace)((Object)entry.getKey())).getValue() * 4;
            }
        } else {
            if (faceCount.containsKey((Object)DiceFace.TWO) && faceCount.containsKey((Object)DiceFace.THREE) && faceCount.containsKey((Object)DiceFace.FOUR) && faceCount.containsKey((Object)DiceFace.FIVE) && faceCount.containsKey((Object)DiceFace.SIX)) {
                return 20;
            }
            if (faceCount.containsValue(2) && faceCount.containsValue(3)) {
                int total = 0;
                for (Map.Entry entry : faceCount.entrySet()) {
                    total += ((DiceFace)((Object)entry.getKey())).getValue() * (Integer)entry.getValue();
                }
                return total;
            }
            if (faceCount.containsValue(3)) {
                for (Map.Entry entry : faceCount.entrySet()) {
                    if ((Integer)entry.getValue() != 3) continue;
                    return ((DiceFace)((Object)entry.getKey())).getValue() * 3;
                }
            } else {
                if (faceCount.containsKey((Object)DiceFace.ONE) && faceCount.containsKey((Object)DiceFace.TWO) && faceCount.containsKey((Object)DiceFace.THREE) && faceCount.containsKey((Object)DiceFace.FOUR) && faceCount.containsKey((Object)DiceFace.FIVE)) {
                    return 15;
                }
                if (faceCount.containsValue(2) && faceCount.size() == 3) {
                    int total = 0;
                    for (Map.Entry entry : faceCount.entrySet()) {
                        if ((Integer)entry.getValue() != 2) continue;
                        total += ((DiceFace)((Object)entry.getKey())).getValue() * 2;
                    }
                    return total;
                }
                if (faceCount.containsValue(2)) {
                    for (Map.Entry entry : faceCount.entrySet()) {
                        if ((Integer)entry.getValue() != 2) continue;
                        return ((DiceFace)((Object)entry.getKey())).getValue() * 2;
                    }
                }
            }
        }
        int total = 0;
        for (Map.Entry entry : faceCount.entrySet()) {
            total += ((DiceFace)((Object)entry.getKey())).getValue() * (Integer)entry.getValue();
        }
        return total;
    }

    public int getRanking() {
        return this.ranking;
    }

    public String getName() {
        return this.name;
    }

    public String getExample() {
        return this.example;
    }

    public String getExampleDescription() {
        return this.exampleDescription;
    }
}

