/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.dialogue.responses;

import com.lilithsthrone.game.character.npc.NPC;
import com.lilithsthrone.game.dialogue.DialogueFlagValue;
import com.lilithsthrone.game.dialogue.responses.Response;
import com.lilithsthrone.game.dialogue.utils.InventoryInteraction;
import com.lilithsthrone.game.dialogue.utils.ParserTag;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.main.Main;

public class ResponseTrade
extends Response {
    private NPC tradePartner;
    private String traderString;

    public ResponseTrade(String title, String tooltipText, NPC tradePartner) {
        super(title, tooltipText, null);
        this.tradePartner = tradePartner;
        this.traderString = null;
    }

    public ResponseTrade(String title, String tooltipText, String traderString, String effectsResponse) {
        super(title, tooltipText, null);
        this.fromExternalFile = true;
        this.traderString = traderString;
        this.effectsString = effectsResponse;
    }

    public void openTrade() {
        Main.game.getDialogueFlags().setFlag(DialogueFlagValue.removeTraderDescription, false);
        if (this.traderString != null && !this.traderString.isEmpty()) {
            Main.mainController.openInventory((NPC)UtilText.findFirstCharacterFromParserTarget(UtilText.parse(this.traderString, new ParserTag[0]).trim()), InventoryInteraction.TRADING);
        } else {
            Main.mainController.openInventory(this.tradePartner, InventoryInteraction.TRADING);
        }
    }

    @Override
    public boolean disabledOnNullDialogue() {
        return false;
    }

    @Override
    public boolean isTradeHighlight() {
        return true;
    }
}

