/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.dialogue.utils;

import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.effects.PerkManager;
import com.lilithsthrone.game.character.npc.NPC;
import com.lilithsthrone.game.character.persona.Relationship;
import com.lilithsthrone.game.dialogue.DialogueNode;
import com.lilithsthrone.game.dialogue.DialogueNodeType;
import com.lilithsthrone.game.dialogue.companions.CompanionManagement;
import com.lilithsthrone.game.dialogue.companions.OccupantDialogue;
import com.lilithsthrone.game.dialogue.companions.SlaveDialogue;
import com.lilithsthrone.game.dialogue.responses.Response;
import com.lilithsthrone.game.dialogue.responses.ResponseEffectsOnly;
import com.lilithsthrone.game.dialogue.utils.ParserTag;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.utils.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class CharactersPresentDialogue {
    public static String menuContent;
    public static String menuTitle;
    public static NPC characterViewed;
    private static NPC targetedCharacterForSex;
    private static NPC companionCharacter;
    public static final DialogueNode MENU;
    public static final DialogueNode AFTER_SEX;
    public static final DialogueNode PERKS;

    public static void resetContent(GameCharacter characterViewed) {
        CharactersPresentDialogue.characterViewed = characterViewed == null ? Main.game.getCharactersPresent().get(0) : (NPC)characterViewed;
        menuTitle = "\u5728\u573a\u89d2\u8272 (" + Util.capitaliseSentence(CharactersPresentDialogue.characterViewed.getName(true)) + ")";
        menuContent = CharactersPresentDialogue.characterViewed.getCharacterInformationScreen(true);
        if (Main.game.getPlayer().hasCompanion(CharactersPresentDialogue.characterViewed)) {
            if (CharactersPresentDialogue.characterViewed.isSlave() && CharactersPresentDialogue.characterViewed.getOwner().isPlayer()) {
                SlaveDialogue.initDialogue(CharactersPresentDialogue.characterViewed, true);
            } else {
                OccupantDialogue.initDialogue(CharactersPresentDialogue.characterViewed, false, true);
            }
            CompanionManagement.initManagement(MENU, 2, CharactersPresentDialogue.characterViewed);
        }
        targetedCharacterForSex = CharactersPresentDialogue.characterViewed;
        if (Main.game.getPlayer().getCompanions().size() > 1) {
            companionCharacter = (NPC)Main.game.getPlayer().getMainCompanion();
            if (Objects.equals(CharactersPresentDialogue.getCompanionCharacter(), targetedCharacterForSex)) {
                companionCharacter = (NPC)Main.game.getPlayer().getCompanions().stream().filter(npc -> !npc.equals(CharactersPresentDialogue.getCharacterViewed())).findFirst().get();
            }
        } else {
            companionCharacter = null;
        }
    }

    private static NPC getCharacterViewed() {
        return characterViewed;
    }

    private static NPC getTargetedCharacterForSex() {
        if (!Main.game.getCharactersPresent().contains(targetedCharacterForSex)) {
            targetedCharacterForSex = characterViewed;
            if (Objects.equals(CharactersPresentDialogue.getCompanionCharacter(), targetedCharacterForSex) && Main.game.getPlayer().getCompanions().size() > 1) {
                companionCharacter = (NPC)Main.game.getPlayer().getCompanions().stream().filter(npc -> !npc.equals(CharactersPresentDialogue.getCharacterViewed())).findFirst().get();
            }
        }
        return targetedCharacterForSex;
    }

    private static NPC getCompanionCharacter() {
        if (!Main.game.getCharactersPresent().contains(companionCharacter)) {
            if (Main.game.getPlayer().getCompanions().size() > 1) {
                companionCharacter = (NPC)Main.game.getPlayer().getMainCompanion();
                if (Objects.equals(companionCharacter, targetedCharacterForSex)) {
                    companionCharacter = (NPC)Main.game.getPlayer().getCompanions().stream().filter(npc -> !npc.equals(CharactersPresentDialogue.getCharacterViewed())).findFirst().get();
                }
            } else {
                companionCharacter = null;
            }
        }
        return companionCharacter;
    }

    private static String getTextFilePath() {
        if (targetedCharacterForSex.isRelatedTo(Main.game.getPlayer(), new Relationship[0])) {
            return "characters/offspring/slave";
        }
        return "misc/slaveDialogue";
    }

    static {
        characterViewed = null;
        MENU = new DialogueNode("", "", true){

            @Override
            public DialogueNodeType getDialogueNodeType() {
                return DialogueNodeType.CHARACTERS_PRESENT;
            }

            @Override
            public String getLabel() {
                return menuTitle;
            }

            @Override
            public String getContent() {
                return menuContent;
            }

            @Override
            public String getResponseTabTitle(int index) {
                if (Main.game.getPlayer().hasCompanion(characterViewed)) {
                    if (index == 0) {
                        return "\u7279\u6027";
                    }
                    if (index == 1) {
                        return UtilText.parse("[style.colourSex(\u6027\u4ea4)]", new ParserTag[0]);
                    }
                    if (index == 2) {
                        return UtilText.parse("[style.colourCompanion(\u7ba1\u7406)]", new ParserTag[0]);
                    }
                } else {
                    if (index == 0) {
                        return "\u7279\u6027";
                    }
                    if (index == 1) {
                        return "\u6027\u6280\u80fd";
                    }
                    if (index == 2) {
                        return "\u7ba1\u7406";
                    }
                }
                return null;
            }

            @Override
            public Response getResponse(int responseTab, final int index) {
                final List<NPC> charactersPresent = Main.game.getCharactersPresent();
                Collections.sort(charactersPresent, (c1, c2) -> Main.game.getPlayer().hasCompanion((GameCharacter)c1) ? 1 : 0);
                if (responseTab == 0) {
                    if (index == 0) {
                        return new ResponseEffectsOnly("\u8fd4\u56de", "\u505c\u6b62\u6d4f\u89c8\u5728\u573a\u89d2\u8272\u5e76\u56de\u5230\u6e38\u620f\u3002"){

                            @Override
                            public void effects() {
                                Main.game.getDialogueFlags().setManagementCompanion(null);
                                Main.mainController.openCharactersPresent();
                            }
                        };
                    }
                    if (index <= charactersPresent.size()) {
                        String title = "[npc.Name]";
                        String description = "\u4ed4\u7ec6\u5730\u6253\u91cf\u4e00\u4e0b[npc.name]\u3002";
                        if (charactersPresent.get(index - 1).equals(characterViewed)) {
                            if (!charactersPresent.get(index - 1).isRaceConcealed() || charactersPresent.get(index - 1).isPlayerKnowsName()) {
                                title = "[style.colourDisabled([npc.Name])]";
                                description = "\u4f60\u5df2\u7ecf\u5728\u770b[npc.name]\u4e86\uff01";
                            } else {
                                title = "[style.colourDisabled(\u672a\u77e5\u4eba\u7269)]";
                                description = "\u4f60\u4e0d\u77e5\u9053\u8fd9\u4eba\u957f\u4ec0\u4e48\u6837\uff01";
                            }
                        } else if (Main.game.getPlayer().hasCompanion(charactersPresent.get(index - 1))) {
                            title = "[style.colourCompanion([npc.Name])]";
                            description = "\u4ed4\u7ec6\u5730\u6253\u91cf\u4e00\u4e0b\u4f60\u7684[style.colourCompanion(\u540c\u4f34)]\uff0c[npc.name]\u3002";
                        }
                        return new Response(UtilText.parse((GameCharacter)charactersPresent.get(index - 1), title, new ParserTag[0]), UtilText.parse((GameCharacter)charactersPresent.get(index - 1), description, new ParserTag[0]), charactersPresent.get(index - 1).equals(characterViewed) ? null : MENU){

                            @Override
                            public void effects() {
                                characterViewed = (NPC)charactersPresent.get(index - 1);
                                menuTitle = "\u5728\u573a\u89d2\u8272 (" + Util.capitaliseSentence(((NPC)charactersPresent.get(index - 1)).getName(true)) + ")";
                                menuContent = ((NPC)charactersPresent.get(index - 1)).getCharacterInformationScreen(true);
                            }
                        };
                    }
                    return null;
                }
                if (responseTab == 1 && Main.game.getPlayer().hasCompanion(characterViewed)) {
                    if (index == 0) {
                        return new ResponseEffectsOnly("\u8fd4\u56de", "\u505c\u6b62\u6d4f\u89c8\u5728\u573a\u89d2\u8272\u5e76\u56de\u5230\u6e38\u620f\u3002"){

                            @Override
                            public void effects() {
                                Main.game.getDialogueFlags().setManagementCompanion(null);
                                Main.mainController.openCharactersPresent();
                            }
                        };
                    }
                    if (index > 0 && index < 5 && !characterViewed.isCompanionAvailableForSex(true)) {
                        if (index == 1) {
                            return new Response("\u6027\u4ea4", characterViewed.getCompanionSexRejectionReason(true), null);
                        }
                        return null;
                    }
                    if (index > 5 && index < 10 && !characterViewed.isCompanionAvailableForSex(false)) {
                        if (index == 6) {
                            return new Response("\u670d\u4ece\u5f0f\u6027\u7231", characterViewed.getCompanionSexRejectionReason(false), null);
                        }
                        return null;
                    }
                    if (characterViewed.isSlave() && characterViewed.getOwner().isPlayer()) {
                        return SlaveDialogue.SLAVE_START.getResponse(responseTab, index);
                    }
                    return OccupantDialogue.OCCUPANT_START.getResponse(responseTab, index);
                }
                if (responseTab == 2 && Main.game.getPlayer().hasCompanion(characterViewed)) {
                    return CompanionManagement.getManagementResponses(index);
                }
                return null;
            }
        };
        AFTER_SEX = new DialogueNode("\u79bb\u5f00", "", true){

            @Override
            public String getDescription() {
                return "\u4f60\u5df2\u7ecf\u723d\u8fc7\u4e86\uff0c\u79bb\u5f00\u8fd9\u91cc\u8ba9[npc.name]\u6062\u590d\u4e00\u4e0b\u5427\u3002";
            }

            @Override
            public String getContent() {
                if (Main.sex.getAllParticipants().size() > 2) {
                    ArrayList<GameCharacter> parsingCharacters = new ArrayList<GameCharacter>(Main.sex.getAllParticipants());
                    parsingCharacters.remove(Main.game.getPlayer());
                    return UtilText.parseFromXMLFile(CharactersPresentDialogue.getTextFilePath(), "AFTER_SEX_THREESOME", parsingCharacters);
                }
                if (Main.sex.getNumberOfOrgasms(CharactersPresentDialogue.getCharacterViewed()) >= CharactersPresentDialogue.getCharacterViewed().getOrgasmsBeforeSatisfied()) {
                    return UtilText.parseFromXMLFile(CharactersPresentDialogue.getTextFilePath(), "AFTER_SEX", CharactersPresentDialogue.getTargetedCharacterForSex());
                }
                return UtilText.parseFromXMLFile(CharactersPresentDialogue.getTextFilePath(), "AFTER_SEX_NO_ORGASM", CharactersPresentDialogue.getTargetedCharacterForSex());
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                if (index == 1) {
                    return new Response("\u7ee7\u7eed", "\u51b3\u5b9a\u63a5\u4e0b\u6765\u8be5\u505a\u4ec0\u4e48\u3002", AFTER_SEX){

                        @Override
                        public DialogueNode getNextDialogue() {
                            return Main.game.getDefaultDialogue(false);
                        }

                        @Override
                        public void effects() {
                            Main.game.setActiveNPC(null);
                        }
                    };
                }
                return null;
            }
        };
        PERKS = new DialogueNode("", "", true){

            @Override
            public DialogueNodeType getDialogueNodeType() {
                return DialogueNodeType.CHARACTERS_PRESENT;
            }

            @Override
            public String getLabel() {
                return UtilText.parse((GameCharacter)CharactersPresentDialogue.getCharacterViewed(), "[npc.NamePos]\u7684\u5929\u8d4b\u6811", new ParserTag[0]);
            }

            @Override
            public String getContent() {
                UtilText.nodeContentSB.setLength(0);
                UtilText.nodeContentSB.append(UtilText.parse((GameCharacter)characterViewed, "<details><summary>[style.boldPerk(\u5929\u8d4b\u4e0e\u7279\u6027\u4fe1\u606f)]</summary>[style.colourPerk(\u5929\u8d4b)](\u5706\u5f62\u56fe\u6807)\u5bf9\u4e8e[npc.namePos]\u7684\u5c5e\u6027\u6709\u6c38\u4e45\u63d0\u5347\u3002<br/>[style.colourPerk(\u7279\u6027)](\u65b9\u5f62\u56fe\u6807)\u4e3a[npc.Name]\u63d0\u4f9b\u7279\u6b8a\u6548\u679c\u3002\u4e0e\u5929\u8d4b\u4e0d\u540c\uff0c<b>\u7279\u6027\u5728\u52a0\u5165\u201c\u751f\u6548\u7279\u6027\u201d\u680f\u4e4b\u524d\u4e0d\u4f1a\u6709\u4efb\u4f55\u6548\u679c</b>\u3002<br/>\u5929\u8d4b\u9700\u9700\u8981\u5929\u8d4b\u70b9\u6570\u89e3\u9501\u3002[npc.Name]\u6bcf\u5f53\u5347\u7ea7\u65f6\u4fbf\u4f1a\u83b7\u5f97\u4e00\u70b9\u5929\u8d4b\u70b9\u6570\uff0c\u5e76\u4e14\u6bcf\u4e94\u7ea7\u83b7\u5f97\u989d\u5916\u4e24\u70b9\u5929\u8d4b\u70b9\u6570\u3002<br/><br/>\u9664\u4e86\u8fd9\u4e9b\u901a\u8fc7\u5929\u8d4b\u70b9\u89e3\u9501\u7684\u5929\u8d4b\u4ee5\u5916\uff0c\u8fd8\u5b58\u5728\u7740\u4e00\u4e9b\u901a\u8fc7\u7279\u6b8a\u4e8b\u4ef6\u89e3\u9501\u7684\u7279\u6b8a\u9690\u85cf\u5929\u8d4b\u3002</details>", new ParserTag[0]));
                UtilText.nodeContentSB.append(PerkManager.MANAGER.getPerkTreeDisplay(characterViewed, true));
                UtilText.nodeContentSB.append("</div>");
                if (!characterViewed.isElemental() && !characterViewed.isDoll()) {
                    UtilText.nodeContentSB.append("<div class='container-full-width' style='padding:8px; text-align:center;'><i>\u8bf7\u6ce8\u610f\u6b64\u5929\u8d4b\u6811\u4ecd\u5728\u65bd\u5de5\uff0c\u5e76\u975e\u6700\u7ec8\u7248\u672c\uff0c\u4ec5\u7528\u4e8e\u5c55\u793a\u6982\u5ff5\uff01</i></div>");
                }
                return UtilText.nodeContentSB.toString();
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                if (index == 6) {
                    return new Response("\u5929\u8d4b\u6811", UtilText.parse((GameCharacter)characterViewed, "\u4f60\u6b63\u5728\u5206\u914d\u5929\u8d4b\u70b9\u6570\u3002", new ParserTag[0]), null);
                }
                if (index == 7) {
                    return new Response("\u91cd\u7f6e\u5929\u8d4b", "\u91cd\u7f6e[npc.namePos]\u6240\u6709\u7684\u5929\u8d4b\u548c\u7279\u6027\uff0c\u9000\u56de\u6240\u6709\u6d88\u8017\u7684\u5929\u8d4b\u70b9\u3002(\u4e34\u65f6\u53ef\u7528\uff0c\u7531\u4e8e\u5929\u8d4b\u6811\u4ecd\u5728\u5f00\u53d1\u4e2d)", PERKS){

                        @Override
                        public void effects() {
                            characterViewed.resetPerksMap(false, false);
                        }
                    };
                }
                return MENU.getResponse(responseTab, index);
            }
        };
    }
}

