/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.dialogue.utils;

import com.lilithsthrone.game.PropertyValue;
import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.PlayerCharacter;
import com.lilithsthrone.game.character.body.coverings.AbstractBodyCoveringType;
import com.lilithsthrone.game.character.body.coverings.BodyCoveringCategory;
import com.lilithsthrone.game.character.body.coverings.BodyCoveringType;
import com.lilithsthrone.game.character.body.valueEnums.BodyMaterial;
import com.lilithsthrone.game.character.markings.Tattoo;
import com.lilithsthrone.game.character.markings.TattooCounterType;
import com.lilithsthrone.game.character.markings.TattooType;
import com.lilithsthrone.game.character.npc.NPC;
import com.lilithsthrone.game.character.race.AbstractRace;
import com.lilithsthrone.game.character.race.Race;
import com.lilithsthrone.game.dialogue.DialogueNode;
import com.lilithsthrone.game.dialogue.places.dominion.shoppingArcade.SuccubisSecrets;
import com.lilithsthrone.game.dialogue.responses.Response;
import com.lilithsthrone.game.dialogue.responses.ResponseTrade;
import com.lilithsthrone.game.dialogue.utils.BodyChanging;
import com.lilithsthrone.game.dialogue.utils.CharacterModificationUtils;
import com.lilithsthrone.game.dialogue.utils.ParserTag;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.game.inventory.InventorySlot;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.rendering.SVGImages;
import com.lilithsthrone.utils.Util;
import com.lilithsthrone.utils.colours.PresetColour;
import java.io.File;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CosmeticsDialogue {
    public static InventorySlot invSlotTattooToRemove = null;
    private static NPC beautician;
    private static DialogueNode returnToNode;
    public static final DialogueNode BEAUTICIAN_START;
    public static final DialogueNode BEAUTICIAN_COSMETICS;
    public static final DialogueNode BEAUTICIAN_HAIR;
    public static final DialogueNode BEAUTICIAN_SKIN_COLOUR;
    public static final DialogueNode BEAUTICIAN_EYES;
    public static final DialogueNode BEAUTICIAN_PIERCINGS;
    public static final DialogueNode BEAUTICIAN_OTHER;
    public static final DialogueNode BEAUTICIAN_TATTOOS;
    public static final DialogueNode BEAUTICIAN_TATTOOS_ADD;
    private static DialogueNode returnToNodeFromTattooSaveLoad;
    private static Map<String, Tattoo> loadedTattoosMap;
    public static String loadConfirmationName;
    public static String overwriteConfirmationName;
    public static String deleteConfirmationName;
    public static final DialogueNode TATTOO_SAVE_LOAD;

    public static void initDialogue(NPC beautician, GameCharacter target, DialogueNode returnToNode) {
        CosmeticsDialogue.beautician = beautician;
        CosmeticsDialogue.returnToNode = returnToNode;
        BodyChanging.setTarget(target);
    }

    private static Response getMainResponse(int index) {
        if (index == 1) {
            return new ResponseTrade("\u4ea4\u6613", UtilText.parse((GameCharacter)beautician, "\u8be2\u95ee[npc.name][npc.she]\u5356\u4ec0\u4e48\u5316\u5986\u54c1\u6216\u8005\u73e0\u5b9d\u3002", new ParserTag[0]), beautician);
        }
        if (index == 2) {
            if (Main.game.getCurrentDialogueNode() == BEAUTICIAN_COSMETICS) {
                return new Response("\u5986\u5bb9", "\u4f60\u6b63\u5728\u67e5\u770b\u6709\u4ec0\u4e48\u5316\u5986\u54c1\u2026\u2026", null);
            }
            if (!Main.game.getPlayer().isAbleToWearMakeup()) {
                return new Response("\u5986\u5bb9", UtilText.parse((GameCharacter)beautician, "\u7531\u4e8e\u4f60\u7684\u8eab\u4f53\u7531" + Main.game.getPlayer().getBodyMaterial().getName() + "\u6784\u6210\uff0c[npc.name]\u65e0\u6cd5\u5bf9\u4f60\u5316\u5986\uff01", new ParserTag[0]), null);
            }
            return new Response("\u5316\u5986", UtilText.parse((GameCharacter)beautician, "[npc.Name]\u53ef\u4ee5\u6d82\u4e0a\u5404\u79cd\u98ce\u683c\u548c\u989c\u8272\u7684\u53e3\u7ea2\u3001\u6307\u7532\u6cb9\u4ee5\u53ca\u5176\u4ed6\u5f62\u5f0f\u7684\u5986\u5bb9\u3002", new ParserTag[0]), BEAUTICIAN_COSMETICS);
        }
        if (index == 3) {
            if (Main.game.getCurrentDialogueNode() == BEAUTICIAN_HAIR) {
                return new Response("\u5934\u53d1", "\u4f60\u6b63\u5728\u67e5\u770b\u6709\u4ec0\u4e48\u53ef\u7528\u7684\u53d1\u578b\u2026\u2026", null);
            }
            return new Response("\u53d1\u578b", UtilText.parse((GameCharacter)beautician, "[npc.Name]\u53ef\u4ee5\u7ed9\u4f60\u7684[pc.hair]\u67d3\u8272\u3001\u505a\u9020\u578b\u3001\u4fee\u526a\u751a\u81f3\u5ef6\u957f\u3002", new ParserTag[0]), BEAUTICIAN_HAIR);
        }
        if (index == 4) {
            if (Main.game.getCurrentDialogueNode() == BEAUTICIAN_PIERCINGS) {
                return new Response("\u7a7f\u5b54", "\u4f60\u6b63\u5728\u67e5\u770b\u6709\u4ec0\u4e48\u53ef\u7528\u7684\u7a7f\u5b54\u2026\u2026", null);
            }
            return new Response("\u7a7f\u5b54", UtilText.parse((GameCharacter)beautician, "[npc.Name]\u53ef\u4ee5\u7ed9\u4f60\u7684\u8eab\u4f53\u5404\u5904\u505a\u7a7f\u5b54\u3002", new ParserTag[0]), BEAUTICIAN_PIERCINGS);
        }
        if (index == 5) {
            if (Main.game.getCurrentDialogueNode() == BEAUTICIAN_EYES) {
                return new Response("\u773c\u775b", "\u4f60\u6b63\u5728\u67e5\u770b\u6709\u4ec0\u4e48\u53ef\u4ee5\u5bf9\u4f60\u773c\u775b\u8fdb\u884c\u7684\u8c03\u6574\u2026\u2026", null);
            }
            return new Response("\u773c\u775b", UtilText.parse((GameCharacter)beautician, "[npc.Name]\u53ef\u4ee5\u66f4\u6362\u4f60\u773c\u775b\u7684\u989c\u8272\uff0c\u4e0d\u8fc7\u8fd9\u5bf9[npc.her]\u7684\u7075\u6c14\u8981\u6c42\u5f88\u9ad8\uff0c\u4ece\u800c\u4e5f\u5341\u5206\u6602\u8d35\u3002", new ParserTag[0]), BEAUTICIAN_EYES);
        }
        if (index == 6) {
            if (Main.game.getCurrentDialogueNode() == BEAUTICIAN_SKIN_COLOUR) {
                return new Response("\u4f53\u8868\u8986\u76d6", "\u4f60\u6b63\u5728\u67e5\u770b\u6709\u4ec0\u4e48\u53ef\u4ee5\u5bf9\u4f60\u4f53\u8868\u8fdb\u884c\u7684\u8c03\u6574\u2026\u2026", null);
            }
            return new Response("\u4f53\u8868", UtilText.parse((GameCharacter)beautician, "[npc.Name]\u53ef\u4ee5\u66f4\u6539\u4f60\u5404\u79cd\u7c7b\u578b\u4f53\u8868\u7684\u989c\u8272\uff0c\u5305\u62ec\u76ae\u80a4\u3001\u76ae\u6bdb\u3001\u7fbd\u6bdb\u7b49\u3002\u4e0d\u8fc7\u8fd9\u5bf9[npc.her]\u7684\u7075\u6c14\u8981\u6c42\u5f88\u9ad8\uff0c\u4ece\u800c\u4e5f\u5341\u5206\u6602\u8d35\u3002", new ParserTag[0]), BEAUTICIAN_SKIN_COLOUR){

                @Override
                public void effects() {
                    SuccubisSecrets.initCoveringsMap(Main.game.getPlayer());
                }
            };
        }
        if (index == 7) {
            if (Main.game.getCurrentDialogueNode() == BEAUTICIAN_OTHER) {
                return new Response("\u6742\u9879", "\u4f60\u6b63\u5728\u67e5\u770b\u6709\u4ec0\u4e48\u53ef\u7528\u7684\u6742\u9879\u670d\u52a1\u2026\u2026", null);
            }
            return new Response("\u6742\u9879", UtilText.parse((GameCharacter)beautician, "[npc.Name]\u63d0\u4f9b\u5404\u7c7b\u6742\u9879\u670d\u52a1\uff0c\u4f8b\u5982\u809b\u95e8\u6f02\u767d\u3002", new ParserTag[0]), BEAUTICIAN_OTHER);
        }
        if (index == 8) {
            if (Main.game.getCurrentDialogueNode() == BEAUTICIAN_TATTOOS) {
                return new Response("\u7eb9\u8eab", "\u4f60\u6b63\u5728\u67e5\u770b\u6709\u4ec0\u4e48\u53ef\u7528\u7684\u7eb9\u8eab\u2026\u2026", null);
            }
            return new Response("\u7eb9\u8eab", UtilText.parse((GameCharacter)beautician, "[npc.Name]\u53ef\u4ee5\u6dfb\u52a0\u6216\u79fb\u9664\u7eb9\u8eab\u3002[npc.her]\u751a\u81f3\u80fd\u6dfb\u52a0\u9644\u9b54\u4e86\u5965\u672f\u7684\u7eb9\u8eab\uff0c\u4f46\u770b\u4e0a\u53bb\u4e0d\u4fbf\u5b9c\u2026\u2026", new ParserTag[0]), BEAUTICIAN_TATTOOS);
        }
        if (index == 0) {
            return new Response("\u8fd4\u56de", "\u4f60\u5df2\u7ecf\u5bf9\u5916\u8868\u505a\u4e86\u8db3\u591f\u7684\u8c03\u6574\u4e86\u3002", returnToNode){

                @Override
                public void effects() {
                    Main.game.setResponseTab(0);
                }
            };
        }
        return null;
    }

    private static String getMoneyRemainingString() {
        return "<h6 style='text-align:center;'>\u4f60\u5f53\u524d\u62e5\u6709[style.moneyFormat([pc.money], span)]</h6>";
    }

    public static void initTattooSaveLoadDialogue(DialogueNode returnToNodeFromTattooSaveLoad) {
        Main.mainController.getWebEngine().executeScript("document.getElementById('hiddenPField').innerHTML=document.getElementById('tattoo_name').value;");
        CharacterModificationUtils.tattoo.getWriting().setText(Main.mainController.getWebEngine().getDocument().getElementById("hiddenPField").getTextContent());
        CharacterModificationUtils.tattoo.setName(CharacterModificationUtils.tattoo.getType().getName());
        CosmeticsDialogue.returnToNodeFromTattooSaveLoad = returnToNodeFromTattooSaveLoad;
    }

    public static DialogueNode getReturnToNodeFromTattooSaveLoad() {
        return returnToNodeFromTattooSaveLoad;
    }

    public static void initSaveLoadMenu() {
        loadedTattoosMap = new TreeMap<String, Tattoo>();
        for (File f : CosmeticsDialogue.getSavedTattoos()) {
            try {
                String name = Util.getFileIdentifier(f);
                Tattoo loadedTattoo = CosmeticsDialogue.loadTattoo(name);
                loadedTattoosMap.put(name, loadedTattoo);
            }
            catch (Exception exception) {}
        }
    }

    public static Map<String, Tattoo> getLoadedTattoosMap() {
        return loadedTattoosMap;
    }

    public static List<File> getSavedTattoos() {
        File[] directoryListing;
        ArrayList<File> filesList = new ArrayList<File>();
        File dir = new File("data/tattoos");
        if (dir.isDirectory() && (directoryListing = dir.listFiles((path, name) -> name.endsWith(".xml"))) != null) {
            filesList.addAll(Arrays.asList(directoryListing));
        }
        filesList.sort(Comparator.comparing(File::getName).reversed());
        return filesList;
    }

    private static String getSaveLoadRow(String baseName, Tattoo loadedTattoo, boolean altColour) {
        if (loadedTattoo != null) {
            String fileName = baseName + ".xml";
            boolean suitableSlot = loadedTattoo.getType().getSlotAvailability().contains((Object)CharacterModificationUtils.tattooInventorySlot);
            boolean specialEffectsLimitation = !Main.game.isInNewWorld() && (loadedTattoo.getCounter() != null || loadedTattoo.isGlowing() || loadedTattoo.getWriting() != null && loadedTattoo.getWriting().isGlow());
            return "<div class='container-full-width' style='padding:0; margin:0 0 4px 0;" + (altColour ? "background:#222;" : "") + " position:relative;'><div class='container-full-width' style='width:calc(75% - 16px); background:transparent;'><div class='container-full-width' style='width:10%; margin:0; padding:0; background:transparent; position:relative; float:left;'><div class='inventoryImage' style='width:100%;'><div class='inventoryImage-content'>" + loadedTattoo.getSVGString() + "</div><div class='overlay no-pointer' id='LOADED_TATTOO_" + baseName + "'></div></div></div><div style='width:calc(90% - 8px); padding:0; margin:0 0 0 8px; position:relative; float:left;'><h6 style='margin:0; padding:2px;'>" + (String)(!suitableSlot || specialEffectsLimitation ? "[style.boldBad(" + loadedTattoo.getName() + ")]" : loadedTattoo.getName()) + "</h6><p style='margin:0; padding:2px;'>[style.colourDisabled(data/tattoos/)]" + baseName + "[style.colourDisabled(.xml)]</p></div></div><div class='container-full-width' style='width:calc(25% - 16px);text-align:center; background:transparent;'>" + (Main.game.isStarted() && !Main.game.isInCombat() && !Main.game.isInSex() ? (fileName.equals(overwriteConfirmationName) ? "<div class='square-button saveIcon' id='OVERWRITE_" + baseName + "'><div class='square-button-content'>" + SVGImages.SVG_IMAGE_PROVIDER.getDiskSaveConfirm() + "</div></div>" : "<div class='square-button saveIcon' id='OVERWRITE_" + baseName + "'><div class='square-button-content'>" + SVGImages.SVG_IMAGE_PROVIDER.getDiskOverwrite() + "</div></div>") : "<div class='square-button saveIcon disabled'><div class='square-button-content'>" + SVGImages.SVG_IMAGE_PROVIDER.getDiskSaveDisabled() + "</div></div>") + (suitableSlot && !specialEffectsLimitation ? (fileName.equals(loadConfirmationName) ? "<div class='square-button saveIcon' id='LOAD_" + baseName + "'><div class='square-button-content'>" + SVGImages.SVG_IMAGE_PROVIDER.getDiskLoadConfirm() + "</div></div>" : "<div class='square-button saveIcon' id='LOAD_" + baseName + "'><div class='square-button-content'>" + SVGImages.SVG_IMAGE_PROVIDER.getDiskLoad() + "</div></div>") : "<div class='square-button saveIcon disabled'><div class='square-button-content'>" + SVGImages.SVG_IMAGE_PROVIDER.getDiskLoadDisabled() + "</div></div>") + (fileName.equals(deleteConfirmationName) ? "<div class='square-button saveIcon' id='DELETE_" + baseName + "'><div class='square-button-content'>" + SVGImages.SVG_IMAGE_PROVIDER.getDiskDeleteConfirm() + "</div></div>" : "<div class='square-button saveIcon' id='DELETE_" + baseName + "'><div class='square-button-content'>" + SVGImages.SVG_IMAGE_PROVIDER.getDiskDelete() + "</div></div>") + "</div></div>";
        }
        String svgString = CharacterModificationUtils.tattoo.getSVGString();
        return "<div class='container-full-width' style='padding:0; margin:0 0 4px 0;" + (altColour ? "background:#222;" : "") + "'><div class='container-full-width' style='width:calc(75% - 16px); background:transparent;'><div class='container-full-width' style='width:10%; margin:0; padding:0; background:transparent; position:relative; float:left;'><div class='inventoryImage' style='width:100%;'><div class='inventoryImage-content'>" + svgString + "</div><div class='overlay no-pointer' id='LOADED_TATTOO_CURRENT'></div></div></div><div style='width:calc(90% - 8px); padding:0; margin:0 0 0 8px; position:relative; float:left;'><form style='padding:0;margin:0;text-align:center;'><input type='text' id='new_save_name' placeholder='Enter File Name' style='padding:0;margin:0;width:100%;'></form></div></div><div class='container-full-width' style='width:calc(25% - 16px); text-align:center; background:transparent;'><div class='square-button saveIcon' id='NEW_SAVE' style='float:left;'><div class='square-button-content'>" + SVGImages.SVG_IMAGE_PROVIDER.getDiskSave() + "</div></div></div></div>";
    }

    public static void saveTattoo(String name, boolean allowOverwrite, DialogueNode dialogueNode) {
        File[] directoryListing;
        if ((name = Main.checkFileName(name)).isEmpty()) {
            return;
        }
        File dir = new File("data/");
        dir.mkdir();
        dir = new File("data/tattoos");
        dir.mkdir();
        if (dir.isDirectory() && (directoryListing = dir.listFiles((path, filename) -> filename.endsWith(".xml"))) != null) {
            for (File child : directoryListing) {
                if (!child.getName().equals(name + ".xml") || allowOverwrite) continue;
                Main.game.flashMessage(PresetColour.GENERIC_BAD, "\u540d\u79f0\u5df2\u5b58\u5728\uff01");
                return;
            }
        }
        try {
            Document doc = Main.getDocBuilder().newDocument();
            Element tattooCoreElement = doc.createElement("tattooSave");
            doc.appendChild(tattooCoreElement);
            Element tattooElement = CharacterModificationUtils.tattoo.saveAsXML(tattooCoreElement, doc);
            if (tattooElement.getElementsByTagName("effects").item(0) != null) {
                tattooElement.removeChild(tattooElement.getElementsByTagName("effects").item(0));
            }
            Transformer transformer1 = Main.transformerFactory.newTransformer();
            transformer1.setOutputProperty("omit-xml-declaration", "yes");
            StringWriter writer = new StringWriter();
            transformer1.transform(new DOMSource(doc), new StreamResult(writer));
            Transformer transformer = Main.transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            DOMSource source = new DOMSource(doc);
            String saveLocation = "data/tattoos/" + name + ".xml";
            StreamResult result = new StreamResult(saveLocation);
            transformer.transform(source, result);
        }
        catch (TransformerException tfe) {
            tfe.printStackTrace();
        }
        if (dialogueNode != null) {
            Main.game.setContent(new Response("", "", dialogueNode));
        }
        Main.game.flashMessage(PresetColour.GENERIC_GOOD, "\u7eb9\u8eab\u5df2\u4fdd\u5b58\uff01");
    }

    public static Tattoo loadTattoo(String name) {
        File file;
        if (CosmeticsDialogue.isLoadTattooAvailable(name) && (file = new File("data/tattoos/" + name + ".xml")).exists()) {
            try {
                Document doc = Main.getDocBuilder().parse(file);
                doc.getDocumentElement().normalize();
                Element rootElement = (Element)doc.getElementsByTagName("tattooSave").item(0);
                return Tattoo.loadFromXML((Element)rootElement.getElementsByTagName("tattoo").item(0), doc);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static boolean isLoadTattooAvailable(String name) {
        File file = new File("data/tattoos/" + name + ".xml");
        return file.exists();
    }

    public static void deleteTattoo(String name) {
        File file = new File("data/tattoos/" + name + ".xml");
        if (file.exists()) {
            try {
                file.delete();
                Main.game.setContent(new Response("", "", Main.game.getCurrentDialogueNode()));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else {
            Main.game.flashMessage(PresetColour.GENERIC_BAD, "\u672a\u627e\u5230\u6587\u4ef6\u2026\u2026");
        }
    }

    static {
        BEAUTICIAN_START = new DialogueNode("\u5316\u5986\u54c1", "", true){

            @Override
            public String getContent() {
                return "";
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                return CosmeticsDialogue.getMainResponse(index);
            }
        };
        BEAUTICIAN_COSMETICS = new DialogueNode("\u5316\u5986\u54c1", "", true){

            @Override
            public String getHeaderContent() {
                UtilText.nodeContentSB.setLength(0);
                UtilText.nodeContentSB.append(CosmeticsDialogue.getMoneyRemainingString());
                UtilText.nodeContentSB.append(CharacterModificationUtils.getKatesDivCoveringsNew(true, Race.NONE, BodyCoveringType.MAKEUP_BLUSHER, "\u816e\u7ea2", "\u816e\u7ea2(\u4e5f\u53eb\u80ed\u8102)\u88ab\u7528\u6765\u7c89\u9970\u8138\u988a\uff0c\u4ee5\u663e\u5f97\u66f4\u52a0\u5e74\u8f7b\u6216\u51f8\u663e\u98a7\u9aa8\u3002", true, true) + CharacterModificationUtils.getKatesDivCoveringsNew(true, Race.NONE, BodyCoveringType.MAKEUP_LIPSTICK, "\u53e3\u7ea2", "\u53e3\u7ea2\u88ab\u7528\u6765\u4e3a\u5634\u5507\u63d0\u4f9b\u8272\u5f69\u3001\u8d28\u5730\u6216\u4fdd\u62a4\u3002", true, true) + CharacterModificationUtils.getKatesDivCoveringsNew(true, Race.NONE, BodyCoveringType.MAKEUP_EYE_LINER, "\u773c\u7ebf", "\u773c\u7ebf\u7528\u4e8e\u773c\u5ed3\u5468\u56f4\uff0c\u6709\u52a9\u4e8e\u4fee\u9970\u773c\u578b\u6216\u7a81\u51fa\u4e0d\u540c\u7684\u7279\u5f81\u3002", true, true) + CharacterModificationUtils.getKatesDivCoveringsNew(true, Race.NONE, BodyCoveringType.MAKEUP_EYE_SHADOW, "\u773c\u5f71", "\u773c\u5f71\u7528\u6765\u8ba9\u4f7f\u7528\u8005\u7684\u773c\u775b\u66f4\u52a0\u51f8\u663e\u8ff7\u4eba\u3002", true, true) + CharacterModificationUtils.getKatesDivCoveringsNew(true, Race.NONE, BodyCoveringType.MAKEUP_NAIL_POLISH_HANDS, "\u6307\u7532\u6cb9", "\u6307\u7532\u6cb9\u7528\u4e8e\u7ed9[pc.hands]\u6dfb\u52a0\u8272\u5f69\u6216\u63d0\u4f9b\u4fdd\u62a4\u3002", true, true) + CharacterModificationUtils.getKatesDivCoveringsNew(true, Race.NONE, BodyCoveringType.MAKEUP_NAIL_POLISH_FEET, "\u811a\u8dbe\u7532\u6cb9", "\u811a\u8dbe\u7532\u6cb9\u7528\u4e8e\u7ed9[pc.feet]\u6dfb\u52a0\u8272\u5f69\u6216\u63d0\u4f9b\u4fdd\u62a4\u3002", true, true));
                return UtilText.nodeContentSB.toString();
            }

            @Override
            public String getContent() {
                return "";
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                return CosmeticsDialogue.getMainResponse(index);
            }

            @Override
            public boolean reloadOnRestore() {
                return true;
            }
        };
        BEAUTICIAN_HAIR = new DialogueNode("\u5934\u53d1", "", true){

            @Override
            public String getHeaderContent() {
                UtilText.nodeContentSB.setLength(0);
                UtilText.nodeContentSB.append(CosmeticsDialogue.getMoneyRemainingString());
                UtilText.nodeContentSB.append(CharacterModificationUtils.getKatesDivHairLengths(true, "\u5934\u53d1\u957f\u5ea6", "\u5934\u53d1\u957f\u5ea6\u51b3\u5b9a\u4e86\u4f60\u80fd\u505a\u7684\u53d1\u578b\u79cd\u7c7b\u3002\u5934\u53d1\u8d8a\u957f\uff0c\u53d1\u578b\u79cd\u7c7b\u5c31\u8d8a\u4e30\u5bcc\u3002") + CharacterModificationUtils.getKatesDivHairStyles(true, "\u53d1\u578b", "\u53d1\u578b\u662f\u5426\u53ef\u7528\u53d6\u51b3\u4e8e\u4f60\u7684\u5934\u53d1\u957f\u5ea6\u3002") + CharacterModificationUtils.getKatesDivCoveringsNew(true, Main.game.getPlayer().getHairType().getRace(), Main.game.getPlayer().getCovering(Main.game.getPlayer().getHairCovering()).getType(), "[pc.Hair]\u989c\u8272", "\u6240\u6709\u6bdb\u53d1\u7684\u6539\u53d8\u989c\u8272\u90fd\u662f\u6c38\u4e45\u7684\uff0c\u5982\u679c\u4f60\u4e4b\u540e\u53c8\u60f3\u8981\u6539\u53d8\u989c\u8272\uff0c\u90a3\u5c31\u5fc5\u987b\u518d\u6765\u627e\u51ef\u7279\u3002", true, true));
                return UtilText.nodeContentSB.toString();
            }

            @Override
            public String getContent() {
                return "";
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                return CosmeticsDialogue.getMainResponse(index);
            }

            @Override
            public boolean reloadOnRestore() {
                return true;
            }
        };
        BEAUTICIAN_SKIN_COLOUR = new DialogueNode("\u4f53\u8868\u8986\u76d6", "-", true){

            @Override
            public String getHeaderContent() {
                UtilText.nodeContentSB.setLength(0);
                UtilText.nodeContentSB.append(CosmeticsDialogue.getMoneyRemainingString());
                for (Map.Entry<AbstractBodyCoveringType, Util.Value<AbstractRace, List<String>>> entry : SuccubisSecrets.coveringsNamesMap.entrySet()) {
                    AbstractBodyCoveringType bct = entry.getKey();
                    AbstractRace race = entry.getValue().getKey();
                    PlayerCharacter target = Main.game.getPlayer();
                    Util.Value<String, String> titleDescription = SuccubisSecrets.getCoveringTitleDescription(target, bct, entry.getValue().getValue());
                    UtilText.nodeContentSB.append(CharacterModificationUtils.getKatesDivCoveringsNew(true, race, bct, titleDescription.getKey(), UtilText.parse((GameCharacter)target, titleDescription.getValue(), new ParserTag[0]), true, true));
                }
                return UtilText.nodeContentSB.toString();
            }

            @Override
            public String getContent() {
                return "";
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                return CosmeticsDialogue.getMainResponse(index);
            }

            @Override
            public boolean reloadOnRestore() {
                return true;
            }
        };
        BEAUTICIAN_EYES = new DialogueNode("\u773c\u775b", "-", true){

            @Override
            public String getHeaderContent() {
                UtilText.nodeContentSB.setLength(0);
                UtilText.nodeContentSB.append(CosmeticsDialogue.getMoneyRemainingString());
                UtilText.nodeContentSB.append(CharacterModificationUtils.getKatesDivCoveringsNew(true, Main.game.getPlayer().getEyeType().getRace(), Main.game.getPlayer().getEyeCovering(), "\u8679\u819c", "\u8679\u819c\u6307\u7684\u662f\u773c\u775b\u4e2d\u67d3\u8272\u7684\u90e8\u5206\uff0c\u8d1f\u8d23\u63a7\u5236\u77b3\u5b54\u7684\u76f4\u5f84\u548c\u5927\u5c0f\u3002", true, true) + CharacterModificationUtils.getKatesDivCoveringsNew(true, Race.NONE, Main.game.getPlayer().getBodyMaterial() != BodyMaterial.FLESH ? BodyCoveringType.getMaterialBodyCoveringType(Main.game.getPlayer().getBodyMaterial(), BodyCoveringCategory.EYE_PUPIL) : BodyCoveringType.EYE_PUPILS, "\u77b3\u5b54", "\u77b3\u5b54\u662f\u4f4d\u4e8e\u8679\u819c\u4e2d\u5fc3\u7684\u900f\u660e\u7269\u4f53\uff0c\u4ee5\u4fbf\u5149\u7ebf\u6253\u5728\u89c6\u7f51\u819c\u4e0a\u3002", true, true) + CharacterModificationUtils.getKatesDivCoveringsNew(true, Race.NONE, Main.game.getPlayer().getBodyMaterial() != BodyMaterial.FLESH ? BodyCoveringType.getMaterialBodyCoveringType(Main.game.getPlayer().getBodyMaterial(), BodyCoveringCategory.EYE_SCLERA) : BodyCoveringType.EYE_SCLERA, "\u5de9\u819c", "\u5de9\u819c\u662f\u773c\u775b\u4e2d\u8679\u819c\u5468\u56f4\u7684\u90e8\u5206(\u4e00\u822c\u662f\u767d\u8272)\u3002", true, true));
                return UtilText.nodeContentSB.toString();
            }

            @Override
            public String getContent() {
                return "";
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                return CosmeticsDialogue.getMainResponse(index);
            }

            @Override
            public boolean reloadOnRestore() {
                return true;
            }
        };
        BEAUTICIAN_PIERCINGS = new DialogueNode("\u7a7f\u5b54", "-", true){

            @Override
            public String getHeaderContent() {
                UtilText.nodeContentSB.setLength(0);
                UtilText.nodeContentSB.append(CosmeticsDialogue.getMoneyRemainingString());
                UtilText.nodeContentSB.append(CharacterModificationUtils.getKatesDivPiercings(false));
                return UtilText.nodeContentSB.toString();
            }

            @Override
            public String getContent() {
                return "";
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                return CosmeticsDialogue.getMainResponse(index);
            }

            @Override
            public boolean reloadOnRestore() {
                return true;
            }
        };
        BEAUTICIAN_OTHER = new DialogueNode("\u6742\u9879", "", true){

            @Override
            public String getHeaderContent() {
                UtilText.nodeContentSB.setLength(0);
                UtilText.nodeContentSB.append(CosmeticsDialogue.getMoneyRemainingString());
                UtilText.nodeContentSB.append(CharacterModificationUtils.getKatesDivAnalBleaching() + (Main.game.isFacialHairEnabled() ? CharacterModificationUtils.getKatesDivFacialHair(true, "\u80e1\u987b", "\u9762\u90e8\u53ef\u89c1\u7684\u4f53\u6bdb\u3002" + (Main.game.isFemaleFacialHairEnabled() ? "" : "\u5973\u6027\u5316\u89d2\u8272\u65e0\u6cd5\u957f\u51fa\u9762\u90e8\u6bdb\u53d1\u3002")) : "") + (Main.game.isPubicHairEnabled() ? CharacterModificationUtils.getKatesDivPubicHair(true, "\u9634\u6bdb", "\u751f\u6b96\u5668\u9644\u8fd1\u7684\u4f53\u6bdb\uff1b\u4f4d\u4e8e\u6027\u5668\u5b98\u548c\u4e0b\u4f53\u9644\u8fd1\u3002") : "") + (Main.game.isBodyHairEnabled() ? CharacterModificationUtils.getKatesDivUnderarmHair(true, "\u814b\u6bdb", "\u814b\u7a9d\u5904\u7684\u4f53\u6bdb\u3002") : "") + (Main.game.isAssHairEnabled() ? CharacterModificationUtils.getKatesDivAssHair(true, "\u809b\u6bdb", "\u809b\u95e8\u9644\u8fd1\u7684\u4f53\u6bdb\u3002") : ""));
                for (AbstractBodyCoveringType bct : BodyCoveringType.getAllBodyCoveringTypes()) {
                    if (!(Main.game.isFacialHairEnabled() && Main.game.getPlayer().getFacialHairType().getType() == bct || Main.game.isBodyHairEnabled() && Main.game.getPlayer().getUnderarmHairType().getType() == bct || Main.game.isAssHairEnabled() && Main.game.getPlayer().getAssHairType().getType() == bct) && (!Main.game.isPubicHairEnabled() || Main.game.getPlayer().getPubicHairType().getType() != bct)) continue;
                    UtilText.nodeContentSB.append(CharacterModificationUtils.getKatesDivCoveringsNew(true, Race.NONE, bct, "\u4f53\u6bdb", "\u4f60\u7684\u4f53\u6bdb\u3002", true, true));
                }
                return UtilText.nodeContentSB.toString();
            }

            @Override
            public String getContent() {
                return "";
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                return CosmeticsDialogue.getMainResponse(index);
            }

            @Override
            public boolean reloadOnRestore() {
                return true;
            }
        };
        BEAUTICIAN_TATTOOS = new DialogueNode("\u7eb9\u8eab", "-", true){

            @Override
            public String getContent() {
                UtilText.nodeContentSB.setLength(0);
                UtilText.nodeContentSB.append(CosmeticsDialogue.getMoneyRemainingString());
                UtilText.nodeContentSB.append(CharacterModificationUtils.getKatesDivTattoos());
                return UtilText.nodeContentSB.toString();
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                if (index == 11) {
                    return new Response("\u786e\u8ba4\u72b6\u6001\uff1a", "\u5f00\u542f\u7eb9\u8eab\u53bb\u9664\u786e\u8ba4\u3002\u542f\u7528\u65f6\uff0c\u9700\u8981\u70b9\u51fb\u4e24\u6b21\u624d\u80fd\u79fb\u9664\u7eb9\u8eab\u3002\u5173\u95ed\u65f6\u53ea\u9700\u8981\u4e00\u6b21\u70b9\u51fb\u3002", BEAUTICIAN_TATTOOS){

                        @Override
                        public String getTitle() {
                            return "\u786e\u8ba4\u72b6\u6001\uff1a" + (Main.getProperties().hasValue(PropertyValue.tattooRemovalConfirmations) ? "<span style='color:" + PresetColour.GENERIC_GOOD.toWebHexString() + ";'>\u5f00\u542f</span>" : "<span style='color:" + PresetColour.GENERIC_BAD.toWebHexString() + ";'>\u5173\u95ed</span>");
                        }

                        @Override
                        public void effects() {
                            Main.getProperties().setValue(PropertyValue.tattooRemovalConfirmations, !Main.getProperties().hasValue(PropertyValue.tattooRemovalConfirmations));
                            Main.getProperties().savePropertiesAsXML();
                        }
                    };
                }
                return CosmeticsDialogue.getMainResponse(index);
            }

            @Override
            public boolean reloadOnRestore() {
                return true;
            }
        };
        BEAUTICIAN_TATTOOS_ADD = new DialogueNode("\u7eb9\u8eab", "-", true){

            @Override
            public String getLabel() {
                return "\u7eb9\u8eab\uff1a" + Util.capitaliseSentence(CharacterModificationUtils.tattooInventorySlot.getTattooSlotName());
            }

            @Override
            public String getContent() {
                UtilText.nodeContentSB.setLength(0);
                UtilText.nodeContentSB.append(CharacterModificationUtils.getKatesDivTattoosAdd());
                return UtilText.nodeContentSB.toString();
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                final int value = CharacterModificationUtils.tattoo.getValue();
                if (index == 1) {
                    if (Main.game.getPlayer().getMoney() < (long)value) {
                        return new Response("\u5e94\u7528(" + UtilText.formatAsMoneyUncoloured(value, "span") + ")", "\u4f60\u6ca1\u6709\u8db3\u591f\u7684\u94b1\u7528\u6765\u7eb9\u7eb9\u8eab\uff01", null);
                    }
                    if (CharacterModificationUtils.tattoo.getType().equals(TattooType.getTattooTypeFromId("innoxia_misc_none")) && CharacterModificationUtils.tattoo.getWriting().getText().isEmpty() && CharacterModificationUtils.tattoo.getCounter().getType() == TattooCounterType.NONE) {
                        return new Response("\u5e94\u7528(" + UtilText.formatAsMoneyUncoloured(value, "span") + ")", "\u4f60\u9700\u8981\u9009\u62e9\u7eb9\u8eab\u7c7b\u578b\uff0c\u6dfb\u52a0\u4e00\u4e9b\u6587\u5b57\u6216\u8ba1\u6570\u6307\u793a\u624d\u80fd\u5f62\u6210\u5b8c\u6574\u7684\u7eb9\u8eab\uff01", null);
                    }
                    return new Response("\u5e94\u7528(" + UtilText.formatAsMoney(value, "span") + ")", UtilText.parse((GameCharacter)beautician, "\u544a\u8bc9[npc.name]\u4f60\u60f3\u8ba9[npc.herHim]\u5e2e\u4f60\u7eb9\u4e0a\u8fd9\u4e2a\u7eb9\u8eab\u3002", new ParserTag[0]), BEAUTICIAN_TATTOOS){

                        @Override
                        public void effects() {
                            Main.game.getTextStartStringBuilder().append(Main.game.getPlayer().incrementMoney(-value));
                            Main.mainController.getWebEngine().executeScript("document.getElementById('hiddenPField').innerHTML=document.getElementById('tattoo_name').value;");
                            CharacterModificationUtils.tattoo.getWriting().setText(Main.mainController.getWebEngine().getDocument().getElementById("hiddenPField").getTextContent());
                            CharacterModificationUtils.tattoo.setName(CharacterModificationUtils.tattoo.getType().getName());
                            Main.game.getPlayer().addTattoo(CharacterModificationUtils.tattooInventorySlot, CharacterModificationUtils.tattoo);
                        }
                    };
                }
                if (index == 2) {
                    return new Response("\u4fdd\u5b58/\u52a0\u8f7d", "\u4fdd\u5b58/\u52a0\u8f7d\u7eb9\u8eab\u9884\u8bbe\u3002", TATTOO_SAVE_LOAD){

                        @Override
                        public void effects() {
                            CosmeticsDialogue.initTattooSaveLoadDialogue(BEAUTICIAN_TATTOOS_ADD);
                        }
                    };
                }
                if (index == 0) {
                    return new Response("\u8fd4\u56de", "\u53d6\u6d88\u7eb9\u8eab\u5e76\u56de\u5230\u9009\u62e9\u83dc\u5355\u3002", BEAUTICIAN_TATTOOS);
                }
                return null;
            }

            @Override
            public boolean reloadOnRestore() {
                return true;
            }
        };
        loadConfirmationName = "";
        overwriteConfirmationName = "";
        deleteConfirmationName = "";
        TATTOO_SAVE_LOAD = new DialogueNode("\u4fdd\u5b58\u7eb9\u8eab\u6587\u4ef6", "", true){

            @Override
            public void applyPreParsingEffects() {
                CosmeticsDialogue.initSaveLoadMenu();
            }

            @Override
            public String getContent() {
                return "";
            }

            @Override
            public String getHeaderContent() {
                StringBuilder saveLoadSB = new StringBuilder();
                saveLoadSB.append("<div class='container-full-width' style='padding:0; margin:0 0 8px 0;'>\u53ea\u6709\u6807\u51c6\u5b57\u7b26(\u5b57\u6bcd\u548c\u6570\u5b57)\u624d\u80fd\u7528\u4e8e\u4fdd\u5b58\u6587\u4ef6\u540d\u3002<br/>\u60ac\u505c\u5728\u7eb9\u8eab\u56fe\u6807\u4e0a\u4ee5\u67e5\u770b\u8981\u4fdd\u5b58/\u8bfb\u53d6\u7684\u8be6\u7ec6\u4fe1\u606f\u3002" + (!Main.game.isInNewWorld() ? "<br/>\u82e5\u540d\u79f0\u4e3a[style.colourBad(\u7ea2\u8272)]\uff0c\u5219\u4ee3\u8868\u7531\u4e8e\u4e0e\u9009\u62e9\u7684\u8eab\u4f53\u90e8\u4f4d\u4e0d\u517c\u5bb9\u800c\u65e0\u6cd5\u8bfb\u53d6\u8be5\u7eb9\u8eab\uff0c\u6216\u7531\u4e8e\u7eb9\u8eab\u62e5\u6709\u4f60\u76ee\u524d\u65e0\u6cd5\u83b7\u53d6\u7684\u7279\u6b8a\u6548\u679c\uff01" : "<br/>\u82e5\u540d\u79f0\u4e3a[style.colourBad(\u7ea2\u8272)]\uff0c\u5219\u4ee3\u8868\u7531\u4e8e\u4e0e\u9009\u62e9\u7684\u8eab\u4f53\u90e8\u4f4d\u4e0d\u517c\u5bb9\u800c\u65e0\u6cd5\u8bfb\u53d6\u8be5\u7eb9\u8eab\u3002") + "</div><div class='container-full-width' style='padding:0; margin:0;'><div class='container-full-width' style='width:calc(75% - 16px); text-align:center; background:transparent;'>\u540d\u5b57</div><div class='container-full-width' style='width:calc(25% - 16px); text-align:center; background:transparent;'>\u8bfb\u6863 | \u5b58\u6863 | \u5220\u9664</div></div>");
                int i = 0;
                saveLoadSB.append(CosmeticsDialogue.getSaveLoadRow(null, null, i % 2 == 0));
                ++i;
                for (Map.Entry<String, Tattoo> entry : loadedTattoosMap.entrySet()) {
                    saveLoadSB.append(CosmeticsDialogue.getSaveLoadRow(entry.getKey(), entry.getValue(), i % 2 == 0));
                    ++i;
                }
                saveLoadSB.append("<p id='hiddenPField' style='display:none;'></p>");
                return saveLoadSB.toString();
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                if (index == 1) {
                    return new Response("\u786e\u8ba4\u72b6\u6001\uff1a", "\u5728\u70b9\u51fb\u8bfb\u53d6\u3001\u8986\u5199\u6216\u5220\u9664\u7eb9\u8eab\u65f6\u4f1a\u8fdb\u5165\u786e\u8ba4\u72b6\u6001\u3002\u542f\u7528\u65f6\uff0c\u9700\u8981\u8fdb\u884c\u4e24\u6b21\u70b9\u51fb\u624d\u80fd\u4f7f\u884c\u4e3a\u751f\u6548\u3002\u5173\u95ed\u65f6\u53ea\u9700\u8981\u4e00\u6b21\u70b9\u51fb\u3002", TATTOO_SAVE_LOAD){

                        @Override
                        public String getTitle() {
                            return "\u518d\u6b21\u786e\u8ba4\uff1a" + (Main.getProperties().hasValue(PropertyValue.overwriteWarning) ? "<span style='color:" + PresetColour.GENERIC_GOOD.toWebHexString() + ";'>\u5f00\u542f</span>" : "<span style='color:" + PresetColour.GENERIC_BAD.toWebHexString() + ";'>\u5173\u95ed</span>");
                        }

                        @Override
                        public void effects() {
                            loadConfirmationName = "";
                            overwriteConfirmationName = "";
                            deleteConfirmationName = "";
                            Main.getProperties().setValue(PropertyValue.overwriteWarning, !Main.getProperties().hasValue(PropertyValue.overwriteWarning));
                            Main.getProperties().savePropertiesAsXML();
                        }
                    };
                }
                if (index == 0) {
                    return new Response("\u8fd4\u56de", "\u8fd4\u56de\u7eb9\u8eab\u83dc\u5355\u3002", returnToNodeFromTattooSaveLoad);
                }
                return null;
            }
        };
    }
}

