/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.dialogue.utils;

import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.combat.spells.Spell;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.utils.colours.Colour;
import com.lilithsthrone.utils.colours.PresetColour;
import com.lilithsthrone.world.Cell;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum MapTravelType {
    WALK_SAFE("\u6b65\u884c (\u6700\u5b89\u5168)", "\u4f7f\u7528\u6700\u5b89\u5168\u7684\u8def\u5f84\u524d\u5f80\u76ee\u7684\u5730\u3002", "\u5728\u5730\u56fe\u4e0a\u70b9\u51fb\uff0c\u786e\u8ba4\u7ec8\u70b9\uff0c\u7136\u540e\u518d\u6b21\u70b9\u51fb\u524d\u5f80\u90a3\u91cc\u3002\u4f60\u53ef\u4ee5\u901a\u8fc7\u6309\u4f4fshift\u952e\u70b9\u51fb\u6765\u89c4\u5212\u8def\u5f84\u70b9\u3002", PresetColour.GENERIC_MINOR_GOOD){

        @Override
        public boolean isAvailable(Cell c, GameCharacter character) {
            return !character.isCaptive();
        }

        @Override
        public String getUnavailablilityDescription(Cell c, GameCharacter character) {
            if (character.isCaptive()) {
                return "\u5f53\u4f60\u662f\u4fd8\u864f\u65f6\u4f60\u4e0d\u80fd\u4f7f\u7528\u5feb\u901f\u65c5\u884c\uff01";
            }
            return "";
        }
    }
    ,
    WALK_DANGEROUS("\u6b65\u884c (\u6700\u5feb)", "\u4f7f\u7528\u6700\u5feb\u7684\u8def\u5f84\u524d\u5f80\u76ee\u7684\u5730\u3002", "\u5728\u5730\u56fe\u4e0a\u70b9\u51fb\uff0c\u786e\u8ba4\u7ec8\u70b9\uff0c\u7136\u540e\u518d\u6b21\u70b9\u51fb\u524d\u5f80\u90a3\u91cc\u3002\u4f60\u53ef\u4ee5\u901a\u8fc7\u6309\u4f4fshift\u952e\u70b9\u51fb\u6765\u89c4\u5212\u8def\u5f84\u70b9\u3002", PresetColour.GENERIC_MINOR_BAD){

        @Override
        public boolean isAvailable(Cell c, GameCharacter character) {
            return !character.isCaptive();
        }

        @Override
        public String getUnavailablilityDescription(Cell c, GameCharacter character) {
            if (character.isCaptive()) {
                return "\u5f53\u4f60\u662f\u4fd8\u864f\u65f6\u4f60\u4e0d\u80fd\u4f7f\u7528\u5feb\u901f\u65c5\u884c\uff01";
            }
            return "";
        }
    }
    ,
    FLYING("\u98de\u884c", "\u98de\u5f80\u76ee\u7684\u5730\u3002", "\u5728\u5730\u56fe\u4e0a\u70b9\u51fb\u4e00\u6b21\u6807\u8bb0\u4f60\u7684\u76ee\u7684\u5730\uff0c\u70b9\u51fb\u7b2c\u4e8c\u6b21\u5219\u4f1a\u524d\u5f80\u90a3\u91cc\u3002", PresetColour.SPELL_SCHOOL_AIR){

        @Override
        public boolean isAvailable(Cell c, GameCharacter character) {
            return !character.isCaptive() && character.isPartyAbleToFly() && character.getWorldLocation().isFlightEnabled();
        }

        @Override
        public String getUnavailablilityDescription(Cell c, GameCharacter character) {
            if (character.isCaptive()) {
                return "\u5f53\u4f60\u662f\u4fd8\u864f\u65f6\u4f60\u4e0d\u80fd\u4f7f\u7528\u5feb\u901f\u65c5\u884c\uff01";
            }
            if (!character.getWorldLocation().isFlightEnabled()) {
                return "\u4f60\u4e0d\u80fd\u5728\u8fd9\u4e2a\u533a\u57df\u98de\u884c\uff01";
            }
            if (!character.isAbleToFly()) {
                return "\u4f60\u8fd8\u4e0d\u80fd\u98de\u884c\uff01";
            }
            return "\u4e0d\u662f\u6240\u6709\u4f60\u7684\u540c\u4f34\u90fd\u80fd\u98de\u884c\uff01";
        }
    }
    ,
    TELEPORT("\u4f20\u9001", "\u4f20\u9001\u524d\u5f80\u76ee\u7684\u5730\u3002", "\u5728\u5730\u56fe\u4e0a\u70b9\u51fb\u4e00\u6b21\u6807\u8bb0\u4f60\u7684\u76ee\u7684\u5730\uff0c\u70b9\u51fb\u7b2c\u4e8c\u6b21\u5219\u4f1a\u524d\u5f80\u90a3\u91cc\u3002", PresetColour.SPELL_SCHOOL_ARCANE){

        @Override
        public boolean isAvailable(Cell c, GameCharacter character) {
            if (character.isCaptive()) {
                return false;
            }
            if (Main.game.isDebugMode()) {
                return true;
            }
            if (!character.getWorldLocation().getTeleportPermissions().isOutgoing() || c != null && !c.getType().getTeleportPermissions().isIncoming() || c != null && !c.getPlace().getPlaceType().getTeleportPermissions().isIncoming()) {
                return false;
            }
            return character.isAbleToTeleport() && character.getMana() >= Spell.TELEPORT.getModifiedCost(character);
        }

        @Override
        public String getUnavailablilityDescription(Cell c, GameCharacter character) {
            if (character.isCaptive()) {
                return "\u5f53\u4f60\u662f\u4fd8\u864f\u65f6\u4f60\u4e0d\u80fd\u4f7f\u7528\u5feb\u901f\u65c5\u884c\uff01";
            }
            if (!character.getWorldLocation().getTeleportPermissions().isOutgoing()) {
                return "\u4f60\u65e0\u6cd5\u4f20\u9001\u51fa\u533a\u57df'" + character.getWorldLocation().getName() + "'\u8fd9\u4e2a\u533a\u57df\uff01";
            }
            if (c != null && !c.getType().getTeleportPermissions().isIncoming()) {
                return "\u4f60\u65e0\u6cd5\u4f20\u9001\u8fdb\u533a\u57df'" + c.getType().getName() + "'\uff01";
            }
            if (c != null && !c.getPlace().getPlaceType().getTeleportPermissions().isIncoming()) {
                return "\u4f60\u65e0\u6cd5\u4f20\u9001\u8fdb\u5730\u5757\u201c" + c.getPlace().getName() + "\u201d\uff01";
            }
            if (!character.isAbleToTeleport()) {
                return character.getUnableToTeleportDescription();
            }
            return "\u65bd\u6cd5\u81f3\u5c11\u9700\u8981" + Spell.TELEPORT.getModifiedCost(character) + "\u7075\u6c14\uff01";
        }
    };

    private String name;
    private String description;
    private String useInstructions;
    private Colour colour;

    private MapTravelType(String name, String description, String useInstructions, Colour colour) {
        this.name = name;
        this.description = description;
        this.useInstructions = useInstructions;
        this.colour = colour;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getUseInstructions() {
        return this.useInstructions;
    }

    public Colour getColour() {
        return this.colour;
    }

    public abstract boolean isAvailable(Cell var1, GameCharacter var2);

    public abstract String getUnavailablilityDescription(Cell var1, GameCharacter var2);
}

