/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.dialogue.utils;

import com.lilithsthrone.game.character.EquipClothingSetting;
import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.npc.NPC;
import com.lilithsthrone.game.character.npc.misc.NPCOffspring;
import com.lilithsthrone.game.character.npc.misc.OffspringSeed;
import com.lilithsthrone.game.character.race.Race;
import com.lilithsthrone.game.character.race.RaceStage;
import com.lilithsthrone.game.character.race.Subspecies;
import com.lilithsthrone.game.dialogue.DialogueNode;
import com.lilithsthrone.game.dialogue.encounters.AbstractEncounter;
import com.lilithsthrone.game.dialogue.encounters.Encounter;
import com.lilithsthrone.game.dialogue.responses.Response;
import com.lilithsthrone.game.dialogue.utils.ParserTag;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.utils.Util;
import com.lilithsthrone.utils.colours.Colour;
import com.lilithsthrone.world.AbstractWorldType;
import com.lilithsthrone.world.WorldType;
import com.lilithsthrone.world.places.AbstractPlaceType;
import java.util.List;

public class OffspringMapDialogue {
    public static final DialogueNode OFFSPRING_CHOICE = new DialogueNode("\u540e\u4ee3\u5217\u8868", "-", true){
        List<OffspringSeed> offspringList;

        @Override
        public void applyPreParsingEffects() {
            this.offspringList = OffspringMapDialogue.getOffspringList();
        }

        @Override
        public String getContent() {
            UtilText.nodeContentSB.setLength(0);
            boolean noOffspring = this.offspringList.isEmpty();
            UtilText.nodeContentSB.append("<p>\u5730\u56fe\u7684\u5965\u672f\u9644\u9b54\u5728\u4f60\u9762\u524d\u6295\u5f71\u51fa\u4e00\u4efd\u4f60\u672a\u66fe\u8c0b\u9762\u7684\u540e\u4ee3\u540d\u5355\uff0c\u5e76\u5728\u5730\u56fe\u4e0a\u5c55\u793a\u51fa\u5bf9\u5e94\u7684\u51c6\u786e\u5730\u70b9\u3002" + (noOffspring ? "\u770b\u6765\u73b0\u5728\u4f60\u5e76\u6ca1\u6709\u9700\u8981\u5bfb\u627e\u7684\u6ca1\u89c1\u8fc7\u9762\u7684\u540e\u4ee3\u2026\u2026" : " \u5e78\u8fd0\u7684\u662f\uff0c\u770b\u8d77\u6765\u4f60\u7684\u4e00\u4e2a\u540e\u4ee3\u5c31\u5728\u8fd9\u4e2a\u533a\u57df\u3002\u4f60\u770b\u4e86\u770b\u5173\u952e\u4fe1\u606f\uff0c\u5f97\u77e5\u5bf9\u65b9\u662f\u2026\u2026") + "</p><p style='text-align:center;'>");
            if (Main.game.getOffspringNotSpawned(os -> true).isEmpty()) {
                UtilText.nodeContentSB.append("[style.colourDisabled(\u540e\u4ee3\u4e0d\u53ef\u7528)]");
            } else {
                String unknownFatherName;
                String unknownMotherName;
                boolean foundAnyInArea = false;
                List<OffspringSeed> offspringToShow = Main.game.getOffspringNotSpawned(npc -> this.offspringList.contains(npc));
                if (!offspringToShow.isEmpty()) {
                    foundAnyInArea = true;
                    UtilText.nodeContentSB.append("\u540e\u4ee3[style.colourMinorGood(\u53ef\u80fd\u5728\u8be5\u533a\u57df)]:<br/>");
                }
                for (OffspringSeed os2 : offspringToShow) {
                    UtilText.nodeContentSB.append("<span style='color:" + os2.getFemininity().getColour().toWebHexString() + ";'>" + Util.capitaliseSentence(os2.getName()) + "</span>");
                    unknownMotherName = "\u672a\u77e5";
                    if (os2.getMother() == null && !os2.getMotherName().equals("???")) {
                        unknownMotherName = os2.getMotherName();
                    }
                    unknownFatherName = "\u672a\u77e5";
                    if (os2.getFather() == null && !os2.getFatherName().equals("???")) {
                        unknownFatherName = os2.getFatherName();
                    }
                    UtilText.nodeContentSB.append(" (" + (String)(os2.isFeral() ? "<span style='color:" + RaceStage.FERAL.getColour().toWebHexString() + ";'>" + Util.capitaliseSentence(RaceStage.FERAL.getName()) + "</span> " : "") + "<span style='color:" + os2.getSubspecies().getColour(null).toWebHexString() + ";'>" + Util.capitaliseSentence(os2.getSubspecies().getName(os2.getBody())) + "</span>) \u6bcd\u4eb2\uff1a" + (os2.getMother() == null ? unknownMotherName : (os2.getMother().isPlayer() ? "[style.colourExcellent(\u4f60)]" : os2.getMother().getName(true))) + " \u7236\u4eb2\uff1a" + (os2.getFather() == null ? unknownFatherName : (os2.getFather().isPlayer() ? "[style.colourExcellent(\u4f60)]" : os2.getFather().getName(true))) + "<br/>");
                }
                offspringToShow = Main.game.getOffspringNotSpawned(npc -> !this.offspringList.contains(npc));
                if (!offspringToShow.isEmpty()) {
                    if (foundAnyInArea) {
                        UtilText.nodeContentSB.append("<br/>");
                    }
                    UtilText.nodeContentSB.append("\u540e\u4ee3[style.colourMinorBad(\u4e0d\u5728\u8be5\u533a\u57df)]:<br/>");
                }
                for (OffspringSeed os2 : offspringToShow) {
                    UtilText.nodeContentSB.append("[style.colourDisabled(" + Util.capitaliseSentence(os2.getName()) + ")]");
                    unknownMotherName = "\u672a\u77e5";
                    if (os2.getMother() == null && !os2.getMotherName().equals("???")) {
                        unknownMotherName = os2.getMotherName();
                    }
                    unknownFatherName = "\u672a\u77e5";
                    if (os2.getFather() == null && !os2.getFatherName().equals("???")) {
                        unknownFatherName = os2.getFatherName();
                    }
                    UtilText.nodeContentSB.append(" (<span style='color:" + os2.getSubspecies().getColour(null).toWebHexString() + ";'>" + Util.capitaliseSentence(os2.getSubspecies().getName(os2.getBody())) + "</span>) \u6bcd\u4eb2\uff1a" + (os2.getMother() == null ? unknownMotherName : (os2.getMother().isPlayer() ? "[style.colourExcellent(\u4f60)]" : os2.getMother().getName(true))) + " \u7236\u4eb2\uff1a" + (os2.getFather() == null ? unknownFatherName : (os2.getFather().isPlayer() ? "[style.colourExcellent(\u4f60)]" : os2.getFather().getName(true))) + "<br/>");
                }
            }
            UtilText.nodeContentSB.append("</p>");
            return UtilText.nodeContentSB.toString();
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            List<OffspringSeed> offspringToShow = Main.game.getOffspringNotSpawned(npc -> this.offspringList.contains(npc));
            offspringToShow.addAll(Main.game.getOffspringNotSpawned(npc -> !this.offspringList.contains(npc)));
            if (index == 0) {
                return new Response("\u8fd4\u56de", "\u8fd8\u662f\u51b3\u5b9a\u4e0d\u53bb\u5bfb\u627e\u8be5\u5730\u533a\u7684\u540e\u4ee3\u3002", Main.game.getDefaultDialogue(false));
            }
            if (index - 1 < offspringToShow.size()) {
                final OffspringSeed offspring = offspringToShow.get(index - 1);
                if (!this.offspringList.contains(offspring)) {
                    return new Response(offspring.getName(), "\u56e0\u4e3a" + offspring.getName() + "\u7684\u4e9a\u79cd\uff0c" + offspring.hisHer() + "\u5728\u8be5\u533a\u57df\u65e0\u6cd5\u627e\u5230\u2026\u2026", null);
                }
                return new Response(offspring.getName(), "\u5728\u9644\u9b54\u5730\u56fe\u7684\u5e2e\u52a9\u4e0b\uff0c\u4f60\u5f88\u5feb\u5c31\u4f1a\u5728\u8be5\u533a\u57df\u627e\u5230" + offspring.getName() + "\u2026\u2026", offspring.getEncounterDialogue()){

                    @Override
                    public Colour getHighlightColour() {
                        return offspring.getFemininity().getColour();
                    }

                    @Override
                    public void effects() {
                        NPCOffspring npc = new NPCOffspring(offspring);
                        npc.setLocation(Main.game.getPlayer(), true);
                        ((NPC)npc).equipClothing(EquipClothingSetting.getAllClothingSettings());
                        Main.game.setActiveNPC(npc);
                        Main.game.getTextStartStringBuilder().append("<p><i>" + UtilText.parse((GameCharacter)npc, "\u901a\u8fc7\u67e5\u8be2\u5730\u56fe\uff0c\u4f60\u5f88\u5feb\u627e\u5230\u4e86\u4f60\u7684[npc.daughter][npc.name]\uff0c\u6b63\u4f4f\u5728\u8fd9\u6761\u5c0f\u5df7\u786e\u5207\u67d0\u5904\u3002\u4f60\u6536\u597d\u5730\u56fe\uff0c\u5f00\u59cb\u5bfb\u627e[npc.herHim]\u2026\u2026", new ParserTag[0]) + "</i></p>");
                    }
                };
            }
            return null;
        }
    };

    private static List<OffspringSeed> getOffspringList() {
        AbstractWorldType worldType = Main.game.getPlayer().getWorldLocation();
        AbstractPlaceType placeType = Main.game.getPlayer().getLocationPlace().getPlaceType();
        AbstractEncounter enc = Main.game.getPlayer().getLocationPlace().getPlaceType().getEncounterType();
        return Main.game.getOffspringNotSpawned(os -> {
            if (os.getSubspecies().isAbleToNaturallySpawnInLocation(worldType, placeType)) {
                if (worldType == WorldType.HARPY_NEST) {
                    if (os.getHalfDemonSubspecies() == null) return true;
                    if (os.getHalfDemonSubspecies().getRace() == Race.HARPY) {
                        return true;
                    }
                } else {
                    if (os.getHalfDemonSubspecies() == null) return true;
                    if (os.getHalfDemonSubspecies().getRace() != Race.HARPY) return true;
                }
            }
            if (enc == Encounter.getEncounterFromId("innoxia_elis_alleyway")) {
                if (os.getSubspecies() == Subspecies.FOX_ASCENDANT) return true;
                if (os.getSubspecies() == Subspecies.FOX_ASCENDANT_ARCTIC) return true;
                if (os.getSubspecies() == Subspecies.FOX_ASCENDANT_FENNEC) return true;
            }
            if (enc == Encounter.DOMINION_ALLEY) {
                if (os.getSubspecies() == Subspecies.ANGEL) return true;
            }
            if (enc != Encounter.DOMINION_CANAL) return false;
            if (os.getSubspecies() == Subspecies.ALLIGATOR_MORPH) return true;
            if (os.getSubspecies() == Subspecies.SLIME) return true;
            if (os.getSubspecies() != Subspecies.RAT_MORPH) return false;
            return true;
        });
    }
}

