/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.dialogue.utils;

import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.combat.spells.Spell;
import com.lilithsthrone.game.combat.spells.SpellSchool;
import com.lilithsthrone.game.dialogue.DialogueNode;
import com.lilithsthrone.game.dialogue.DialogueNodeType;
import com.lilithsthrone.game.dialogue.responses.Response;
import com.lilithsthrone.game.dialogue.responses.ResponseEffectsOnly;
import com.lilithsthrone.game.dialogue.utils.ParserTag;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.utils.Util;
import java.util.ArrayList;

public class SpellManagement {
    private static GameCharacter spellOwner;
    private static GameCharacter spellTarget;
    private static DialogueNode dialogueReturn;
    private static DialogueNode spellScreenAfterCasting;
    private static Spell spell;
    public static final DialogueNode CHARACTER_SPELLS_ARCANE;
    public static final DialogueNode CHARACTER_SPELLS_EARTH;
    public static final DialogueNode CHARACTER_SPELLS_WATER;
    public static final DialogueNode CHARACTER_SPELLS_AIR;
    public static final DialogueNode CHARACTER_SPELLS_FIRE;
    public static final DialogueNode CHARACTER_SPELLS_MISC;
    public static final DialogueNode SPELL_CAST_DIALOGUE;

    public static GameCharacter getSpellOwner() {
        if (spellOwner == null) {
            return Main.game.getPlayer();
        }
        return spellOwner;
    }

    public static GameCharacter getSpellTarget() {
        if (spellTarget == null) {
            return Main.game.getPlayer();
        }
        return spellTarget;
    }

    public static DialogueNode getDialogueReturn() {
        return dialogueReturn;
    }

    public static void setSpellOwner(GameCharacter spellOwner, DialogueNode dialogueReturn) {
        SpellManagement.spellOwner = spellOwner;
        spellTarget = spellOwner;
        SpellManagement.dialogueReturn = dialogueReturn;
    }

    public static DialogueNode castSpell(Spell spell) {
        spellScreenAfterCasting = Main.game.getCurrentDialogueNode();
        SpellManagement.spell = spell;
        spell.performOnSelection(0, SpellManagement.getSpellOwner(), SpellManagement.getSpellTarget(), null, SpellManagement.getSpellOwner().getParty());
        Main.game.getTextStartStringBuilder().append("<p style='text-align:center;'><b>\u65bd\u653e\u201c<span style='color:" + spell.getSpellSchool().getColour().toWebHexString() + ";'>" + Util.capitaliseSentence(spell.getName()) + "</span>\u201d:</b><br/>" + spell.applyEffect(SpellManagement.getSpellOwner(), SpellManagement.getSpellTarget(), true, false) + "</p>");
        return SPELL_CAST_DIALOGUE;
    }

    private static Response getResponses1To9(int index) {
        if (index == 1) {
            if (Main.game.getCurrentDialogueNode() == CHARACTER_SPELLS_EARTH) {
                return new Response("\u571f", UtilText.parse(SpellManagement.getSpellOwner(), "\u4f60\u5df2\u7ecf\u5728\u6d4f\u89c8[npc.namePos]\u7684\u571f\u7cfb\u6cd5\u672f\uff01", new ParserTag[0]), null);
            }
            return new Response("\u571f", UtilText.parse(SpellManagement.getSpellOwner(), "\u6d4f\u89c8[npc.namePos]\u7684\u6cd5\u672f\u5e76\u5728\u5927\u5730\u5b66\u6d3e\u4e2d\u5347\u7ea7\u3002", new ParserTag[0]), CHARACTER_SPELLS_EARTH);
        }
        if (index == 2) {
            if (Main.game.getCurrentDialogueNode() == CHARACTER_SPELLS_WATER) {
                return new Response("\u6c34", UtilText.parse(SpellManagement.getSpellOwner(), "\u4f60\u5df2\u7ecf\u5728\u6d4f\u89c8[npc.namePos]\u7684\u6c34\u7cfb\u6cd5\u672f\uff01", new ParserTag[0]), null);
            }
            return new Response("\u6c34", UtilText.parse(SpellManagement.getSpellOwner(), "\u6d4f\u89c8[npc.namePos]\u7684\u6cd5\u672f\u5e76\u5728\u6fc0\u6d41\u5b66\u6d3e\u4e2d\u5347\u7ea7\u3002", new ParserTag[0]), CHARACTER_SPELLS_WATER);
        }
        if (index == 3) {
            if (Main.game.getCurrentDialogueNode() == CHARACTER_SPELLS_FIRE) {
                return new Response("\u706b", UtilText.parse(SpellManagement.getSpellOwner(), "\u4f60\u5df2\u7ecf\u5728\u6d4f\u89c8[npc.namePos]\u7684\u706b\u7cfb\u6cd5\u672f\uff01", new ParserTag[0]), null);
            }
            return new Response("\u706b", UtilText.parse(SpellManagement.getSpellOwner(), "\u6d4f\u89c8[npc.namePos]\u7684\u6cd5\u672f\u5e76\u5728\u70c8\u706b\u5b66\u6d3e\u4e2d\u5347\u7ea7\u3002", new ParserTag[0]), CHARACTER_SPELLS_FIRE);
        }
        if (index == 4) {
            if (Main.game.getCurrentDialogueNode() == CHARACTER_SPELLS_AIR) {
                return new Response("\u98ce", UtilText.parse(SpellManagement.getSpellOwner(), "\u4f60\u5df2\u7ecf\u5728\u6d4f\u89c8[npc.namePos]\u7684\u98ce\u7cfb\u6cd5\u672f\uff01", new ParserTag[0]), null);
            }
            return new Response("\u98ce", UtilText.parse(SpellManagement.getSpellOwner(), "\u6d4f\u89c8[npc.namePos]\u7684\u6cd5\u672f\u5e76\u5728\u5927\u6c14\u5b66\u6d3e\u4e2d\u5347\u7ea7\u3002", new ParserTag[0]), CHARACTER_SPELLS_AIR);
        }
        if (index == 5) {
            if (Main.game.getCurrentDialogueNode() == CHARACTER_SPELLS_ARCANE) {
                return new Response("\u5965\u672f", UtilText.parse(SpellManagement.getSpellOwner(), "\u4f60\u5df2\u7ecf\u5728\u6d4f\u89c8[npc.namePos]\u7684\u5965\u672f\u7cfb\u6cd5\u672f\uff01", new ParserTag[0]), null);
            }
            return new Response("\u5965\u672f", UtilText.parse(SpellManagement.getSpellOwner(), "\u6d4f\u89c8[npc.namePos]\u7684\u6cd5\u672f\u5e76\u5728\u5965\u672f\u7cfb\u5b66\u6d3e\u4e2d\u5347\u7ea7\u3002", new ParserTag[0]), CHARACTER_SPELLS_ARCANE);
        }
        if (index == 6) {
            if (Main.game.getCurrentDialogueNode() == CHARACTER_SPELLS_MISC) {
                return new Response("\u79d8\u672f", UtilText.parse(SpellManagement.getSpellOwner(), "\u4f60\u5df2\u7ecf\u5728\u6d4f\u89c8\u79d8\u672f\u4e86\uff01", new ParserTag[0]), null);
            }
            return new Response("\u79d8\u672f", UtilText.parse(SpellManagement.getSpellOwner(), "\u6d4f\u89c8\u4ece\u6b66\u5668\u6216\u7279\u6b8a\u4e8b\u4ef6\u4e2d\u83b7\u53d6\u7684\u79d8\u672f\u3002", new ParserTag[0]), CHARACTER_SPELLS_MISC);
        }
        if (index == 9) {
            return new ResponseEffectsOnly(UtilText.parse(SpellManagement.getSpellTarget(), "\u76ee\u6807\uff1a<b style='color:" + SpellManagement.getSpellTarget().getFemininity().getColour().toWebHexString() + ";'>[npc.Name]</b>", new ParserTag[0]), "\u5faa\u5207\u6362\u9009\u62e9\u65bd\u6cd5\u76ee\u6807\u3002"){

                @Override
                public void effects() {
                    ArrayList<GameCharacter> companions = Util.newArrayListOfValues(Main.game.getPlayer());
                    companions.addAll(Main.game.getPlayer().getCompanions());
                    if (!companions.isEmpty()) {
                        for (int i = 0; i < companions.size(); ++i) {
                            if (!((GameCharacter)companions.get(i)).equals(SpellManagement.getSpellTarget())) continue;
                            if (i == companions.size() - 1) {
                                spellTarget = (GameCharacter)companions.get(0);
                                break;
                            }
                            spellTarget = (GameCharacter)companions.get(i + 1);
                            break;
                        }
                    }
                    Main.game.updateResponses();
                }
            };
        }
        return null;
    }

    static {
        CHARACTER_SPELLS_ARCANE = new DialogueNode("\u5965\u672f\u6cd5\u672f", "", true){

            @Override
            public String getHeaderContent() {
                UtilText.nodeContentSB.setLength(0);
                UtilText.nodeContentSB.append("<div class='container-full-width' style='width:100%; padding:0; margin:0;'><div class='container-full-width' style='width:50%; padding:0; margin:0;'>" + Spell.getSpellTreesDisplay(SpellSchool.ARCANE, SpellManagement.getSpellOwner(), SpellManagement.getSpellTarget()) + "</div><div class='container-full-width' style='width:50%; padding:8px; margin:0;'>" + SpellSchool.ARCANE.getDescription() + "</div><div class='container-full-width inner' style='text-align:center;'>[style.boldArcane(\u5965\u672f\u5b66\u6d3e\u80fd\u529b\uff1a)] " + (!SpellManagement.getSpellOwner().isSpellSchoolSpecialAbilityUnlocked(SpellSchool.ARCANE) ? "[style.colourDisabled(" + SpellSchool.ARCANE.getPassiveBuff() + ")]<br/>(\u81f3\u5c11\u9700\u8981\u77e5\u9053<b>\u4e09</b>\u4e2a\u5965\u672f\u7cfb\u6cd5\u672f\u4ee5\u89e3\u9501\u3002)" : "[style.colourGood(" + SpellSchool.ARCANE.getPassiveBuff() + ")]") + "</div></div>");
                return UtilText.nodeContentSB.toString();
            }

            @Override
            public String getContent() {
                return "";
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                if (index >= 1 && index <= 9) {
                    return SpellManagement.getResponses1To9(index);
                }
                if (index == 10) {
                    return new Response("\u91cd\u7f6e\u5965\u672f\u7cfb", UtilText.parse(SpellManagement.getSpellOwner(), "\u91cd\u7f6e[npc.namePos]\u7684\u5965\u672f\u6cd5\u672f\u5347\u7ea7\uff0c\u6062\u590d\u4f7f\u7528\u7684\u70b9\u6570\uff0c\u4f46\u6cd5\u672f\u4e0d\u4f1a\u91cd\u7f6e\u3002", new ParserTag[0]), CHARACTER_SPELLS_ARCANE){

                        @Override
                        public void effects() {
                            SpellManagement.getSpellOwner().resetSpellUpgrades(SpellSchool.ARCANE);
                        }
                    };
                }
                if (index == 0) {
                    return new Response("\u8fd4\u56de", "\u8fd4\u56de\u5230\u4e0a\u4e00\u4e2a\u754c\u9762", dialogueReturn);
                }
                return null;
            }

            @Override
            public DialogueNodeType getDialogueNodeType() {
                if (SpellManagement.getSpellOwner().isPlayer()) {
                    return DialogueNodeType.PHONE;
                }
                return DialogueNodeType.OCCUPANT_MANAGEMENT;
            }
        };
        CHARACTER_SPELLS_EARTH = new DialogueNode("\u571f\u7cfb\u6cd5\u672f", "", true){

            @Override
            public String getHeaderContent() {
                UtilText.nodeContentSB.setLength(0);
                UtilText.nodeContentSB.append("<div class='container-full-width' style='width:100%; padding:0; margin:0;'><div class='container-full-width' style='width:50%; padding:0; margin:0;'>" + Spell.getSpellTreesDisplay(SpellSchool.EARTH, SpellManagement.getSpellOwner(), SpellManagement.getSpellTarget()) + "</div><div class='container-full-width' style='width:50%; padding:8px; margin:0;'>" + SpellSchool.EARTH.getDescription() + "</div><div class='container-full-width inner' style='text-align:center;'>[style.boldEarth(\u5927\u5730\u5b66\u6d3e\u80fd\u529b\uff1a)] " + (!SpellManagement.getSpellOwner().isSpellSchoolSpecialAbilityUnlocked(SpellSchool.EARTH) ? "[style.colourDisabled(" + SpellSchool.EARTH.getPassiveBuff() + ")]<br/>(\u81f3\u5c11\u9700\u8981\u77e5\u9053<b>\u4e09</b>\u4e2a\u571f\u7cfb\u6cd5\u672f\u4ee5\u89e3\u9501\u3002)" : "[style.colourGood(" + SpellSchool.EARTH.getPassiveBuff() + ")]") + "</div></div>");
                return UtilText.nodeContentSB.toString();
            }

            @Override
            public String getContent() {
                return "";
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                if (index >= 1 && index <= 9) {
                    return SpellManagement.getResponses1To9(index);
                }
                if (index == 10) {
                    return new Response("\u91cd\u7f6e\u571f\u7cfb", UtilText.parse(SpellManagement.getSpellOwner(), "\u91cd\u7f6e[npc.namePos]\u7684\u571f\u7cfb\u6cd5\u672f\u5347\u7ea7\uff0c\u6062\u590d\u4f7f\u7528\u7684\u70b9\u6570\uff0c\u4f46\u6cd5\u672f\u4e0d\u4f1a\u91cd\u7f6e\u3002", new ParserTag[0]), CHARACTER_SPELLS_EARTH){

                        @Override
                        public void effects() {
                            SpellManagement.getSpellOwner().resetSpellUpgrades(SpellSchool.EARTH);
                        }
                    };
                }
                if (index == 0) {
                    return new Response("\u8fd4\u56de", "\u8fd4\u56de\u5230\u4e0a\u4e00\u4e2a\u754c\u9762", dialogueReturn);
                }
                return null;
            }

            @Override
            public DialogueNodeType getDialogueNodeType() {
                if (SpellManagement.getSpellOwner().isPlayer()) {
                    return DialogueNodeType.PHONE;
                }
                return DialogueNodeType.OCCUPANT_MANAGEMENT;
            }
        };
        CHARACTER_SPELLS_WATER = new DialogueNode("\u6c34\u7cfb\u6cd5\u672f", "", true){

            @Override
            public String getHeaderContent() {
                UtilText.nodeContentSB.setLength(0);
                UtilText.nodeContentSB.append("<div class='container-full-width' style='width:100%; padding:0; margin:0;'><div class='container-full-width' style='width:50%; padding:0; margin:0;'>" + Spell.getSpellTreesDisplay(SpellSchool.WATER, SpellManagement.getSpellOwner(), SpellManagement.getSpellTarget()) + "</div><div class='container-full-width' style='width:50%; padding:8px; margin:0;'>" + SpellSchool.WATER.getDescription() + "</div><div class='container-full-width inner' style='text-align:center;'>[style.boldWater(\u6fc0\u6d41\u5b66\u6d3e\u80fd\u529b\uff1a)] " + (!SpellManagement.getSpellOwner().isSpellSchoolSpecialAbilityUnlocked(SpellSchool.WATER) ? "[style.colourDisabled(" + SpellSchool.WATER.getPassiveBuff() + ")]<br/>(\u81f3\u5c11\u9700\u8981\u77e5\u9053<b>\u4e09</b>\u4e2a\u6c34\u7cfb\u6cd5\u672f\u4ee5\u89e3\u9501\u3002)" : "[style.colourGood(" + SpellSchool.WATER.getPassiveBuff() + ")]") + "</div></div>");
                return UtilText.nodeContentSB.toString();
            }

            @Override
            public String getContent() {
                return "";
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                if (index >= 1 && index <= 9) {
                    return SpellManagement.getResponses1To9(index);
                }
                if (index == 10) {
                    return new Response("\u91cd\u7f6e\u6c34\u7cfb", UtilText.parse(SpellManagement.getSpellOwner(), "\u91cd\u7f6e[npc.namePos]\u7684\u6c34\u7cfb\u6cd5\u672f\u5347\u7ea7\uff0c\u6062\u590d\u4f7f\u7528\u7684\u70b9\u6570\uff0c\u4f46\u6cd5\u672f\u4e0d\u4f1a\u91cd\u7f6e\u3002", new ParserTag[0]), CHARACTER_SPELLS_WATER){

                        @Override
                        public void effects() {
                            SpellManagement.getSpellOwner().resetSpellUpgrades(SpellSchool.WATER);
                        }
                    };
                }
                if (index == 0) {
                    return new Response("\u8fd4\u56de", "\u8fd4\u56de\u5230\u4e0a\u4e00\u754c\u9762", dialogueReturn);
                }
                return null;
            }

            @Override
            public DialogueNodeType getDialogueNodeType() {
                if (SpellManagement.getSpellOwner().isPlayer()) {
                    return DialogueNodeType.PHONE;
                }
                return DialogueNodeType.OCCUPANT_MANAGEMENT;
            }
        };
        CHARACTER_SPELLS_AIR = new DialogueNode("\u98ce\u7cfb\u6cd5\u672f", "", true){

            @Override
            public String getHeaderContent() {
                UtilText.nodeContentSB.setLength(0);
                UtilText.nodeContentSB.append("<div class='container-full-width' style='width:100%; padding:0; margin:0;'><div class='container-full-width' style='width:50%; padding:0; margin:0;'>" + Spell.getSpellTreesDisplay(SpellSchool.AIR, SpellManagement.getSpellOwner(), SpellManagement.getSpellTarget()) + "</div><div class='container-full-width' style='width:50%; padding:8px; margin:0;'>" + SpellSchool.AIR.getDescription() + "</div><div class='container-full-width inner' style='text-align:center;'>[style.boldAir(\u5927\u6c14\u5b66\u6d3e\u80fd\u529b\uff1a)] " + (!SpellManagement.getSpellOwner().isSpellSchoolSpecialAbilityUnlocked(SpellSchool.AIR) ? "[style.colourDisabled(" + SpellSchool.AIR.getPassiveBuff() + ")]<br/>(\u81f3\u5c11\u9700\u8981\u77e5\u9053<b>\u4e09</b>\u4e2a\u98ce\u7cfb\u6cd5\u672f\u4ee5\u89e3\u9501\u3002)" : "[style.colourGood(" + SpellSchool.AIR.getPassiveBuff() + ")]") + "</div></div>");
                return UtilText.nodeContentSB.toString();
            }

            @Override
            public String getContent() {
                return "";
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                if (index >= 1 && index <= 9) {
                    return SpellManagement.getResponses1To9(index);
                }
                if (index == 10) {
                    return new Response("\u91cd\u7f6e\u98ce\u7cfb", UtilText.parse(SpellManagement.getSpellOwner(), "\u91cd\u7f6e[npc.namePos]\u7684\u98ce\u7cfb\u6cd5\u672f\u5347\u7ea7\uff0c\u6062\u590d\u4f7f\u7528\u7684\u70b9\u6570\uff0c\u4f46\u6cd5\u672f\u4e0d\u4f1a\u91cd\u7f6e\u3002", new ParserTag[0]), CHARACTER_SPELLS_AIR){

                        @Override
                        public void effects() {
                            SpellManagement.getSpellOwner().resetSpellUpgrades(SpellSchool.AIR);
                        }
                    };
                }
                if (index == 0) {
                    return new Response("\u8fd4\u56de", "\u8fd4\u56de\u5230\u4e0a\u4e00\u754c\u9762", dialogueReturn);
                }
                return null;
            }

            @Override
            public DialogueNodeType getDialogueNodeType() {
                if (SpellManagement.getSpellOwner().isPlayer()) {
                    return DialogueNodeType.PHONE;
                }
                return DialogueNodeType.OCCUPANT_MANAGEMENT;
            }
        };
        CHARACTER_SPELLS_FIRE = new DialogueNode("\u706b\u7cfb\u6cd5\u672f", "", true){

            @Override
            public String getHeaderContent() {
                UtilText.nodeContentSB.setLength(0);
                UtilText.nodeContentSB.append("<div class='container-full-width' style='width:100%; padding:0; margin:0;'><div class='container-full-width' style='width:50%; padding:0; margin:0;'>" + Spell.getSpellTreesDisplay(SpellSchool.FIRE, SpellManagement.getSpellOwner(), SpellManagement.getSpellTarget()) + "</div><div class='container-full-width' style='width:50%; padding:8px; margin:0;'>" + SpellSchool.FIRE.getDescription() + "</div><div class='container-full-width inner' style='text-align:center;'>[style.boldFire(\u70c8\u706b\u5b66\u6d3e\u80fd\u529b\uff1a)] " + (!SpellManagement.getSpellOwner().isSpellSchoolSpecialAbilityUnlocked(SpellSchool.FIRE) ? "[style.colourDisabled(" + SpellSchool.FIRE.getPassiveBuff() + ")]<br/>(\u81f3\u5c11\u9700\u8981\u77e5\u9053<b>\u4e09</b>\u4e2a\u706b\u7cfb\u6cd5\u672f\u4ee5\u89e3\u9501\u3002)" : "[style.colourGood(" + SpellSchool.FIRE.getPassiveBuff() + ")]") + "</div></div>");
                return UtilText.nodeContentSB.toString();
            }

            @Override
            public String getContent() {
                return "";
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                if (index >= 1 && index <= 9) {
                    return SpellManagement.getResponses1To9(index);
                }
                if (index == 10) {
                    return new Response("\u91cd\u7f6e\u706b\u7cfb", UtilText.parse(SpellManagement.getSpellOwner(), "\u91cd\u7f6e[npc.namePos]\u7684\u706b\u7cfb\u6cd5\u672f\u5347\u7ea7\uff0c\u6062\u590d\u4f7f\u7528\u7684\u70b9\u6570\uff0c\u4f46\u6cd5\u672f\u4e0d\u4f1a\u91cd\u7f6e\u3002", new ParserTag[0]), CHARACTER_SPELLS_FIRE){

                        @Override
                        public void effects() {
                            SpellManagement.getSpellOwner().resetSpellUpgrades(SpellSchool.FIRE);
                        }
                    };
                }
                if (index == 0) {
                    return new Response("\u8fd4\u56de", "\u8fd4\u56de\u5230\u4e0a\u4e00\u754c\u9762", dialogueReturn);
                }
                return null;
            }

            @Override
            public DialogueNodeType getDialogueNodeType() {
                if (SpellManagement.getSpellOwner().isPlayer()) {
                    return DialogueNodeType.PHONE;
                }
                return DialogueNodeType.OCCUPANT_MANAGEMENT;
            }
        };
        CHARACTER_SPELLS_MISC = new DialogueNode("\u9690\u79d8\u6cd5\u672f", "", true){

            @Override
            public String getHeaderContent() {
                UtilText.nodeContentSB.setLength(0);
                UtilText.nodeContentSB.append("<div class='container-full-width' style='width:100%; padding:0; margin:0;'><div class='container-full-width' style='width:50%; padding:0; margin:0;'>" + Spell.getSpellMiscTreeDisplay(SpellManagement.getSpellOwner(), SpellManagement.getSpellTarget()) + "</div><div class='container-full-width' style='width:50%; padding:8px; margin:0;'>\u867d\u7136\u6709\u8bb8\u591a\u6cd5\u672f\u5728\u76f8\u5bf9\u5bb9\u6613\u83b7\u5f97\u7684\u6cd5\u672f\u4e66\u4e2d\u5f97\u5230\u4e86\u8be6\u7ec6\u7684\u89e3\u91ca\uff0c\u4f46\u4e5f\u6709\u4e00\u4e9b\u6cd5\u672f\u6ca1\u6709\u88ab\u7f16\u76ee\u5e76\u8bb0\u5f55\u5728\u6848\u3002\u5c3d\u7ba1\u8fd9\u4e9b\u96be\u4ee5\u6349\u6478\u7684\u6cd5\u672f\u90fd\u5c5e\u4e8e\u6cd5\u672f\u7684\u4e94\u5927\u4e3b\u8981\u5b66\u6d3e\u4e4b\u4e00\uff0c\u4f46\u53ea\u5728\u6781\u5c11\u6570\u7684\u9b54\u6cd5\u4e66\u4e2d\u6709\u6240\u63d0\u53ca\uff0c\u5b83\u4eec\u901a\u5e38\u88ab\u5f52\u7c7b\u4e3a\u201c\u79d8\u672f\u201d\u3002<br/><br/>\u867d\u7136\u8fd9\u4e9b\u9b54\u6cd5\u65e0\u6cd5\u4ece\u4e66\u4e2d\u5b66\u4e60\uff0c\u4f46\u53ef\u4ee5\u901a\u8fc7\u88c5\u5907\u7279\u6b8a\u7684\u9b54\u6cd5\u6b66\u5668\u6765\u4f7f\u7528\u3002\u4e5f\u6709\u53ef\u80fd\u901a\u8fc7\u72ec\u7279\u7684\u4e8b\u4ef6\u83b7\u5f97\u8fd9\u4e9b\u6cd5\u672f\u2026\u2026</div><div class='container-full-width inner' style='text-align:center;'>[style.boldSpell(\u79d8\u672f)]\u4ece\u7279\u6b8a\u6b66\u5668\u6216\u72ec\u7279\u4e8b\u4ef6\u4e2d\u83b7\u53d6\u3002</div></div>");
                return UtilText.nodeContentSB.toString();
            }

            @Override
            public String getContent() {
                return "";
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                if (index >= 1 && index <= 9) {
                    return SpellManagement.getResponses1To9(index);
                }
                if (index == 0) {
                    return new Response("\u8fd4\u56de", "\u8fd4\u56de\u5230\u4e0a\u4e00\u754c\u9762", dialogueReturn);
                }
                return null;
            }

            @Override
            public DialogueNodeType getDialogueNodeType() {
                if (SpellManagement.getSpellOwner().isPlayer()) {
                    return DialogueNodeType.PHONE;
                }
                return DialogueNodeType.OCCUPANT_MANAGEMENT;
            }
        };
        SPELL_CAST_DIALOGUE = new DialogueNode("", "", true){

            @Override
            public int getSecondsPassed() {
                return 60;
            }

            @Override
            public String getLabel() {
                return Util.capitaliseSentence(spell.getName());
            }

            @Override
            public String getContent() {
                return "";
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                if (index == 1) {
                    return new Response("\u7ee7\u7eed", "\u56de\u5230\u6cd5\u672f\u7ba1\u7406\u754c\u9762\u3002", spellScreenAfterCasting);
                }
                return null;
            }

            @Override
            public DialogueNodeType getDialogueNodeType() {
                if (SpellManagement.getSpellOwner().isPlayer()) {
                    return DialogueNodeType.PHONE;
                }
                return DialogueNodeType.OCCUPANT_MANAGEMENT;
            }
        };
    }
}

