/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.inventory;

import com.lilithsthrone.game.inventory.AbstractCoreItem;
import com.lilithsthrone.game.inventory.AbstractCoreType;
import com.lilithsthrone.game.inventory.Rarity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;

class AbstractInventory<T extends AbstractCoreItem, U extends AbstractCoreType> {
    private final Comparator<T> comparator;
    private final Function<T, U> typeRetriever;
    private Map<T, Integer> duplicateCounts;

    AbstractInventory(Comparator<T> comparator, Function<T, U> typeRetriever) {
        this.comparator = comparator;
        this.typeRetriever = typeRetriever;
        this.duplicateCounts = new LinkedHashMap<T, Integer>();
    }

    AbstractInventory(AbstractInventory<T, U> inventoryToCopy) {
        this.comparator = inventoryToCopy.comparator;
        this.typeRetriever = inventoryToCopy.typeRetriever;
        this.duplicateCounts = new LinkedHashMap<T, Integer>(inventoryToCopy.duplicateCounts);
    }

    public void clear() {
        this.duplicateCounts.clear();
    }

    boolean isEmpty() {
        return this.duplicateCounts.isEmpty();
    }

    public void sort() {
        if (this.duplicateCounts.size() < 2) {
            return;
        }
        ArrayList<T> itemsToSort = new ArrayList<T>(this.duplicateCounts.keySet());
        itemsToSort.sort(this.comparator);
        LinkedHashMap<T, Integer> newlySortedMap = new LinkedHashMap<T, Integer>();
        for (AbstractCoreItem item : itemsToSort) {
            newlySortedMap.put(item, this.duplicateCounts.get(item));
        }
        this.duplicateCounts = newlySortedMap;
    }

    public void transform(Function<T, T> transformFunction) {
        LinkedHashMap<T, Integer> oldMap = new LinkedHashMap<T, Integer>(this.duplicateCounts);
        this.duplicateCounts.clear();
        for (Map.Entry e : oldMap.entrySet()) {
            AbstractCoreItem oldItem = (AbstractCoreItem)e.getKey();
            AbstractCoreItem newItem = (AbstractCoreItem)transformFunction.apply(oldItem);
            this.addItem(newItem, (Integer)e.getValue());
        }
    }

    Map<T, Integer> getDuplicateCounts() {
        return Collections.unmodifiableMap(this.duplicateCounts);
    }

    int getUniqueItemCount() {
        return this.duplicateCounts.size();
    }

    int getQuestEntryCount() {
        return (int)this.duplicateCounts.keySet().stream().filter(e -> e.getRarity().equals((Object)Rarity.QUEST)).count();
    }

    public int getTotalItemCount() {
        return this.duplicateCounts.values().stream().mapToInt(e -> e).sum();
    }

    public int getItemCount(T item) {
        return this.duplicateCounts.getOrDefault(item, 0);
    }

    void addFromMap(Map<T, Integer> map) {
        map.forEach(this::addItem);
    }

    void addItem(T item, int count) {
        try {
            this.duplicateCounts.merge(item, count, Math::addExact);
        }
        catch (ArithmeticException ex) {
            this.duplicateCounts.put(item, Integer.MAX_VALUE);
        }
    }

    boolean hasItem(T item) {
        return this.duplicateCounts.containsKey(item);
    }

    private boolean removeItem(T item) {
        return this.removeItem(item, 1);
    }

    boolean removeItem(T item, int count) {
        boolean hasItem = this.hasItem(item);
        if (hasItem) {
            int newValue = this.duplicateCounts.get(item) - count;
            if (newValue <= 0) {
                this.duplicateCounts.remove(item);
            } else {
                this.duplicateCounts.put(item, newValue);
            }
        }
        return hasItem;
    }

    private Optional<T> getItemByType(U type) {
        return this.duplicateCounts.keySet().stream().filter(item -> ((AbstractCoreType)this.typeRetriever.apply((AbstractCoreItem)item)).equals(type)).findAny();
    }

    private Optional<T> getItemByRarity(Rarity rarity) {
        return this.duplicateCounts.keySet().stream().filter(item -> ((AbstractCoreType)this.typeRetriever.apply((AbstractCoreItem)item)).getRarity().equals((Object)rarity)).findAny();
    }

    boolean hasItemType(U itemType) {
        return this.getItemByType(itemType).isPresent();
    }

    boolean removeAllItemsByRarity(Rarity rarity) {
        boolean removed = this.getItemByRarity(rarity).map(this::removeItem).orElse(false);
        while (removed) {
            removed = this.getItemByRarity(rarity).map(this::removeItem).orElse(false);
        }
        return removed;
    }

    boolean removeItemByType(U itemType, int count) {
        Optional<T> itemFound = this.getItemByType(itemType);
        if (!itemFound.isPresent()) {
            return false;
        }
        return this.removeItem((AbstractCoreItem)itemFound.get(), count);
    }
}

