/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.inventory;

import com.lilithsthrone.controller.xmlParsing.Element;
import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.effects.AbstractStatusEffect;
import com.lilithsthrone.game.character.effects.StatusEffect;
import com.lilithsthrone.game.inventory.InventorySlot;
import com.lilithsthrone.game.inventory.clothing.AbstractClothing;
import com.lilithsthrone.game.inventory.clothing.AbstractClothingType;
import com.lilithsthrone.game.inventory.weapon.AbstractWeapon;
import com.lilithsthrone.game.inventory.weapon.AbstractWeaponType;
import com.lilithsthrone.main.Main;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.w3c.dom.Document;

public abstract class AbstractSetBonus {
    private boolean mod;
    private String name;
    private int numberRequiredForCompleteSet;
    private boolean countDuplicates;
    private List<InventorySlot> blockedSlotsCountingTowardsFullSet;
    private String statusEffectId;
    private AbstractStatusEffect associatedStatusEffect;

    public AbstractSetBonus(String name, AbstractStatusEffect associatedStatusEffect, int numberRequiredForCompleteSet, List<InventorySlot> blockedSlotsCountingTowardsFullSet) {
        this.name = name;
        this.numberRequiredForCompleteSet = numberRequiredForCompleteSet;
        this.countDuplicates = true;
        this.blockedSlotsCountingTowardsFullSet = blockedSlotsCountingTowardsFullSet == null ? new ArrayList<InventorySlot>() : blockedSlotsCountingTowardsFullSet;
        this.associatedStatusEffect = associatedStatusEffect;
    }

    public AbstractSetBonus(File XMLFile, String author, boolean mod) {
        if (XMLFile.exists()) {
            try {
                Document doc = Main.getDocBuilder().parse(XMLFile);
                doc.getDocumentElement().normalize();
                Element coreElement = Element.getDocumentRootElement(XMLFile);
                this.mod = mod;
                this.name = coreElement.getMandatoryFirstOf("name").getTextContent();
                Element element = coreElement.getMandatoryFirstOf("numberRequiredForCompleteSet");
                this.numberRequiredForCompleteSet = Integer.valueOf(element.getTextContent());
                this.countDuplicates = true;
                if (!element.getAttribute("countDuplicates").isEmpty()) {
                    this.countDuplicates = Boolean.valueOf(element.getAttribute("countDuplicates"));
                }
                this.statusEffectId = coreElement.getMandatoryFirstOf("statusEffect").getTextContent();
                this.blockedSlotsCountingTowardsFullSet = new ArrayList<InventorySlot>();
                if (coreElement.getOptionalFirstOf("blockedSlotsCountingTowardsFullSet").isPresent()) {
                    for (Element e : coreElement.getMandatoryFirstOf("blockedSlotsCountingTowardsFullSet").getAllOf("slot")) {
                        InventorySlot slot = InventorySlot.valueOf(e.getTextContent());
                        this.blockedSlotsCountingTowardsFullSet.add(slot);
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                System.err.println("SetBonus was unable to be loaded from file! (" + XMLFile.getName() + ")\n" + String.valueOf(ex));
            }
        }
    }

    public boolean isMod() {
        return this.mod;
    }

    public boolean isCharacterWearingCompleteSet(GameCharacter target) {
        AbstractWeaponType type;
        int setCount = 0;
        for (InventorySlot slot : this.getBlockedSlotsCountingTowardsFullSet()) {
            if (slot.getBodyPartClothingBlock(target) == null) continue;
            ++setCount;
        }
        HashSet<AbstractClothingType> uniqueClothingTypes = new HashSet<AbstractClothingType>();
        HashSet<AbstractWeaponType> uniqueWeaponTypes = new HashSet<AbstractWeaponType>();
        boolean atLeastOneFound = false;
        for (AbstractClothing c : target.getClothingCurrentlyEquipped()) {
            AbstractClothingType type2 = c.getClothingType();
            if (type2.getClothingSet() != this || !this.isCountDuplicates() && uniqueClothingTypes.contains(type2)) continue;
            ++setCount;
            uniqueClothingTypes.add(type2);
            atLeastOneFound = true;
        }
        int weaponSetCount = 0;
        for (AbstractWeapon weapon : target.getMainWeaponArray()) {
            if (weapon == null || (type = weapon.getWeaponType()).getClothingSet() != this || !this.isCountDuplicates() && uniqueWeaponTypes.contains(type)) continue;
            ++weaponSetCount;
            uniqueWeaponTypes.add(type);
            atLeastOneFound = true;
        }
        for (AbstractWeapon weapon : target.getOffhandWeaponArray()) {
            if (weapon == null || (type = weapon.getWeaponType()).getClothingSet() != this || !this.isCountDuplicates() && uniqueWeaponTypes.contains(type)) continue;
            ++weaponSetCount;
            uniqueWeaponTypes.add(type);
            atLeastOneFound = true;
        }
        return atLeastOneFound && (setCount += Math.min(2, weaponSetCount)) >= this.getNumberRequiredForCompleteSet();
    }

    public String getName() {
        return this.name;
    }

    public boolean isCountDuplicates() {
        return this.countDuplicates;
    }

    public int getNumberRequiredForCompleteSet() {
        return this.numberRequiredForCompleteSet;
    }

    public AbstractStatusEffect getAssociatedStatusEffect() {
        if (this.associatedStatusEffect == null) {
            this.associatedStatusEffect = StatusEffect.getStatusEffectFromId(this.statusEffectId);
        }
        return this.associatedStatusEffect;
    }

    public List<InventorySlot> getBlockedSlotsCountingTowardsFullSet() {
        return this.blockedSlotsCountingTowardsFullSet;
    }
}

