/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.inventory;

import com.lilithsthrone.controller.xmlParsing.XMLUtil;
import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.body.CoverableArea;
import com.lilithsthrone.game.character.body.valueEnums.Femininity;
import com.lilithsthrone.game.character.body.valueEnums.GenitalArrangement;
import com.lilithsthrone.game.dialogue.utils.ParserTag;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.game.inventory.AbstractCoreItem;
import com.lilithsthrone.game.inventory.AbstractInventory;
import com.lilithsthrone.game.inventory.AbstractSetBonus;
import com.lilithsthrone.game.inventory.InventorySlot;
import com.lilithsthrone.game.inventory.ItemTag;
import com.lilithsthrone.game.inventory.Rarity;
import com.lilithsthrone.game.inventory.SetBonus;
import com.lilithsthrone.game.inventory.clothing.AbstractClothing;
import com.lilithsthrone.game.inventory.clothing.AbstractClothingType;
import com.lilithsthrone.game.inventory.clothing.BlockedParts;
import com.lilithsthrone.game.inventory.clothing.BodyPartClothingBlock;
import com.lilithsthrone.game.inventory.clothing.ClothingAccess;
import com.lilithsthrone.game.inventory.clothing.DisplacementType;
import com.lilithsthrone.game.inventory.item.AbstractFilledBreastPump;
import com.lilithsthrone.game.inventory.item.AbstractFilledCondom;
import com.lilithsthrone.game.inventory.item.AbstractItem;
import com.lilithsthrone.game.inventory.item.AbstractItemType;
import com.lilithsthrone.game.inventory.item.ItemType;
import com.lilithsthrone.game.inventory.weapon.AbstractWeapon;
import com.lilithsthrone.game.inventory.weapon.AbstractWeaponType;
import com.lilithsthrone.game.sex.SexPace;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.utils.Util;
import com.lilithsthrone.utils.Vector2i;
import com.lilithsthrone.utils.XMLSaving;
import com.lilithsthrone.utils.colours.PresetColour;
import com.lilithsthrone.utils.comparators.ClothingRarityComparator;
import com.lilithsthrone.utils.comparators.ClothingZLayerComparator;
import com.lilithsthrone.utils.comparators.InventoryClothingComparator;
import com.lilithsthrone.utils.comparators.InventoryItemComparator;
import com.lilithsthrone.utils.comparators.InventoryWeaponComparator;
import com.lilithsthrone.utils.comparators.ReverseClothingZLayerComparator;
import com.lilithsthrone.world.World;
import java.lang.invoke.CallSite;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class CharacterInventory
implements XMLSaving {
    public static boolean loadingFromFloorBackupCheck = false;
    private final AbstractInventory<AbstractWeapon, AbstractWeaponType> weaponSubInventory;
    private final AbstractInventory<AbstractClothing, AbstractClothingType> clothingSubInventory;
    private final AbstractInventory<AbstractItem, AbstractItemType> itemSubInventory;
    private final Map<String, List<InventorySlot>> unlockKeyMap;
    protected int essenceCount;
    protected long money;
    private Set<InventorySlot> dirtySlots;
    private AbstractClothing blockingClothing;
    protected BlockedParts extraBlockedParts;
    private AbstractWeapon[] mainWeapon;
    private AbstractWeapon[] offhandWeapon;
    private List<AbstractClothing> clothingCurrentlyEquipped;
    private final Map<AbstractSetBonus, Integer> clothingSetCount;
    private boolean floorInventory;
    private int maxInventorySpace;
    private StringBuilder tempSB;
    private StringBuilder equipTextSB = new StringBuilder();
    private Set<AbstractClothing> incompatibleUnequippableClothing = new HashSet<AbstractClothing>();
    private Set<AbstractClothing> incompatibleRemovableClothing = new HashSet<AbstractClothing>();
    private Map<AbstractClothing, DisplacementType> clothingToRemove = new HashMap<AbstractClothing, DisplacementType>();
    private AbstractClothing initialClothingCheck = null;
    private StringBuilder unableToDisplaceText = new StringBuilder();
    private Map<AbstractClothing, List<AbstractClothing>> displacementClothingChecked;
    private StringBuilder unableToReplaceText = new StringBuilder();
    private Map<AbstractClothing, DisplacementType> previousDisplacements;

    public CharacterInventory(boolean floorInventory, int money) {
        this(floorInventory, money, 32);
    }

    public CharacterInventory(boolean floorInventory, int money, int maxInventorySpace) {
        this.floorInventory = floorInventory;
        this.money = money;
        this.weaponSubInventory = new AbstractInventory<AbstractWeapon, AbstractWeaponType>(new InventoryWeaponComparator(), AbstractWeapon::getWeaponType);
        this.clothingSubInventory = new AbstractInventory<AbstractClothing, AbstractClothingType>(new InventoryClothingComparator(), AbstractClothing::getClothingType);
        this.itemSubInventory = new AbstractInventory<AbstractItem, AbstractItemType>(new InventoryItemComparator(), AbstractItem::getItemType);
        this.dirtySlots = new HashSet<InventorySlot>();
        this.essenceCount = 0;
        this.unlockKeyMap = new HashMap<String, List<InventorySlot>>();
        this.mainWeapon = new AbstractWeapon[3];
        this.offhandWeapon = new AbstractWeapon[3];
        this.clothingCurrentlyEquipped = new ArrayList<AbstractClothing>();
        this.clothingSetCount = new HashMap<AbstractSetBonus, Integer>();
        for (AbstractSetBonus clothingSet : SetBonus.getAllSetBonuses()) {
            this.clothingSetCount.put(clothingSet, 0);
        }
        this.maxInventorySpace = maxInventorySpace;
    }

    public static CharacterInventory getCopyOfInventory(CharacterInventory inventoryToCopy) {
        Document doc = Main.getDocBuilder().newDocument();
        Element mainNode = doc.createElement("mainNode");
        inventoryToCopy.saveAsXML(mainNode, doc);
        CharacterInventory newInventory = CharacterInventory.loadFromXML(mainNode, doc);
        return newInventory;
    }

    @Override
    public Element saveAsXML(Element parentElement, Document doc) {
        Element e;
        int i;
        Element characterInventory = doc.createElement("characterInventory");
        parentElement.appendChild(characterInventory);
        XMLUtil.createXMLElementWithValue(doc, characterInventory, "floorInventory", String.valueOf(this.floorInventory));
        XMLUtil.createXMLElementWithValue(doc, characterInventory, "money", String.valueOf(this.getMoney()));
        XMLUtil.createXMLElementWithValue(doc, characterInventory, "essenceCount", String.valueOf(this.getEssenceCount()));
        if (this.extraBlockedParts != null) {
            Element innerElement = doc.createElement("extraBlockedParts");
            characterInventory.appendChild(innerElement);
            this.extraBlockedParts.saveAsXML(innerElement, doc);
        }
        Element dirtySlotsElement = doc.createElement("dirtySlots");
        characterInventory.appendChild(dirtySlotsElement);
        for (InventorySlot inventorySlot : this.getDirtySlots()) {
            Element element = doc.createElement("dirtySlot");
            dirtySlotsElement.appendChild(element);
            XMLUtil.addAttribute(doc, element, "slot", inventorySlot.toString());
        }
        if (!this.unlockKeyMap.isEmpty()) {
            Element innerElement = doc.createElement("unlockKeyMap");
            characterInventory.appendChild(innerElement);
            for (Map.Entry<String, List<InventorySlot>> entry : this.unlockKeyMap.entrySet()) {
                Element element = doc.createElement("character");
                innerElement.appendChild(element);
                XMLUtil.addAttribute(doc, element, "id", entry.getKey());
                for (InventorySlot slot : entry.getValue()) {
                    Element elementSlot = doc.createElement("slot");
                    element.appendChild(elementSlot);
                    XMLUtil.addAttribute(doc, elementSlot, "id", slot.toString());
                }
            }
        }
        for (i = 0; i < this.mainWeapon.length; ++i) {
            AbstractWeapon abstractWeapon = this.mainWeapon[i];
            if (abstractWeapon == null) continue;
            Element element = doc.createElement("mainWeapon" + i);
            characterInventory.appendChild(element);
            abstractWeapon.saveAsXML(element, doc);
        }
        for (i = 0; i < this.offhandWeapon.length; ++i) {
            AbstractWeapon abstractWeapon = this.offhandWeapon[i];
            if (abstractWeapon == null) continue;
            Element element = doc.createElement("offhandWeapon" + i);
            characterInventory.appendChild(element);
            abstractWeapon.saveAsXML(element, doc);
        }
        Element clothingEquipped = doc.createElement("clothingEquipped");
        characterInventory.appendChild(clothingEquipped);
        for (AbstractClothing abstractClothing : this.getClothingCurrentlyEquipped()) {
            abstractClothing.saveAsXML(clothingEquipped, doc);
        }
        if (!this.getAllItemsInInventory().isEmpty()) {
            Element element = doc.createElement("itemsInInventory");
            characterInventory.appendChild(element);
            for (Map.Entry<AbstractItem, Integer> entry : this.getAllItemsInInventory().entrySet()) {
                e = entry.getKey().saveAsXML(element, doc);
                int value = 1;
                if (entry.getValue() != null) {
                    value = entry.getValue();
                }
                XMLUtil.addAttribute(doc, e, "count", String.valueOf(value));
            }
        }
        if (!this.getAllClothingInInventory().isEmpty()) {
            Element element = doc.createElement("clothingInInventory");
            characterInventory.appendChild(element);
            for (Map.Entry<AbstractClothing, Integer> entry : this.getAllClothingInInventory().entrySet()) {
                e = entry.getKey().saveAsXML(element, doc);
                int value = 1;
                if (entry.getValue() != null) {
                    value = entry.getValue();
                }
                XMLUtil.addAttribute(doc, e, "count", String.valueOf(value));
            }
        }
        if (!this.getAllWeaponsInInventory().isEmpty()) {
            Element element = doc.createElement("weaponsInInventory");
            characterInventory.appendChild(element);
            for (Map.Entry<AbstractWeapon, Integer> entry : this.getAllWeaponsInInventory().entrySet()) {
                e = entry.getKey().saveAsXML(element, doc);
                int value = 1;
                if (entry.getValue() != null) {
                    value = entry.getValue();
                }
                XMLUtil.addAttribute(doc, e, "count", String.valueOf(value));
            }
        }
        return characterInventory;
    }

    public static CharacterInventory loadFromXML(Element parentElement, Document doc) {
        Element e;
        Element e2;
        Element unlockKeyMapContainerElement;
        int i;
        NodeList nodes;
        CharacterInventory inventory = new CharacterInventory(false, 0);
        try {
            inventory.floorInventory = Boolean.valueOf(((Element)parentElement.getElementsByTagName("floorInventory").item(0)).getAttribute("value"));
        }
        catch (Exception ex) {
            inventory.floorInventory = loadingFromFloorBackupCheck;
        }
        inventory.setMoney(Long.valueOf(((Element)parentElement.getElementsByTagName("money").item(0)).getAttribute("value")));
        if (parentElement.getElementsByTagName("essences").item(0) != null) {
            inventory.setEssenceCount(Integer.valueOf(((Element)parentElement.getElementsByTagName("essences").item(0)).getAttribute("value")));
        } else {
            inventory.setEssenceCount(Integer.valueOf(((Element)parentElement.getElementsByTagName("essenceCount").item(0)).getAttribute("value")));
        }
        try {
            nodes = parentElement.getElementsByTagName("extraBlockedParts");
            Element extraBlockedPartsElement = (Element)nodes.item(0);
            if (extraBlockedPartsElement != null) {
                inventory.setExtraBlockedParts(BlockedParts.loadFromXML((Element)extraBlockedPartsElement.getElementsByTagName("blockedParts").item(0), doc, "CharacterInventory extraBlockedParts"));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        nodes = parentElement.getElementsByTagName("dirtySlots");
        Element dirtySlotContainerElement = (Element)nodes.item(0);
        if (dirtySlotContainerElement != null) {
            NodeList dirtySlotEntries = dirtySlotContainerElement.getElementsByTagName("dirtySlot");
            for (i = 0; i < dirtySlotEntries.getLength(); ++i) {
                Element e3 = (Element)dirtySlotEntries.item(i);
                InventorySlot slot = InventorySlot.valueOf(e3.getAttribute("slot"));
                inventory.addDirtySlot(slot);
            }
        }
        if ((unlockKeyMapContainerElement = (Element)(nodes = parentElement.getElementsByTagName("unlockKeyMap")).item(0)) != null) {
            NodeList characterIDs = unlockKeyMapContainerElement.getElementsByTagName("character");
            for (int i2 = 0; i2 < characterIDs.getLength(); ++i2) {
                e2 = (Element)characterIDs.item(i2);
                String id = e2.getAttribute("id");
                NodeList slots = e2.getElementsByTagName("slot");
                ArrayList<InventorySlot> loadedSlots = new ArrayList<InventorySlot>();
                for (int j = 0; j < slots.getLength(); ++j) {
                    Element slotElement = (Element)slots.item(j);
                    try {
                        InventorySlot slot = InventorySlot.valueOf(slotElement.getAttribute("id"));
                        loadedSlots.add(slot);
                        continue;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
                inventory.unlockKeyMap.put(id, loadedSlots);
            }
        }
        if ((nodes = parentElement.getElementsByTagName("mainWeapon")).getLength() > 0 && nodes.item(0) != null) {
            AbstractWeapon weapon = AbstractWeapon.loadFromXML((Element)((Element)nodes.item(0)).getElementsByTagName("weapon").item(0), doc);
            if (weapon != null) {
                inventory.equipMainWeapon(0, weapon);
            }
        } else {
            for (i = 0; i < inventory.mainWeapon.length; ++i) {
                AbstractWeapon weapon;
                nodes = parentElement.getElementsByTagName("mainWeapon" + i);
                if (nodes.getLength() <= 0 || nodes.item(0) == null || (weapon = AbstractWeapon.loadFromXML((Element)((Element)nodes.item(0)).getElementsByTagName("weapon").item(0), doc)) == null) continue;
                inventory.equipMainWeapon(i, weapon);
            }
        }
        nodes = parentElement.getElementsByTagName("offhandWeapon");
        if (nodes.getLength() > 0 && nodes.item(0) != null) {
            AbstractWeapon weapon = AbstractWeapon.loadFromXML((Element)((Element)nodes.item(0)).getElementsByTagName("weapon").item(0), doc);
            if (weapon != null) {
                inventory.equipOffhandWeapon(0, weapon);
            }
        } else {
            for (int i3 = 0; i3 < inventory.offhandWeapon.length; ++i3) {
                AbstractWeapon weapon;
                nodes = parentElement.getElementsByTagName("offhandWeapon" + i3);
                if (nodes.getLength() <= 0 || nodes.item(0) == null || (weapon = AbstractWeapon.loadFromXML((Element)((Element)nodes.item(0)).getElementsByTagName("weapon").item(0), doc)) == null) continue;
                inventory.equipOffhandWeapon(i3, weapon);
            }
        }
        NodeList clothingEquipped = ((Element)parentElement.getElementsByTagName("clothingEquipped").item(0)).getElementsByTagName("clothing");
        for (int i4 = 0; i4 < clothingEquipped.getLength(); ++i4) {
            e2 = (Element)clothingEquipped.item(i4);
            AbstractClothing clothing = AbstractClothing.loadFromXML(e2, doc);
            if (clothing == null) continue;
            inventory.getClothingCurrentlyEquipped().add(clothing);
            if (clothing.getSlotEquippedTo() != null) continue;
            clothing.setSlotEquippedTo(clothing.getClothingType().getEquipSlots().get(0));
        }
        nodes = parentElement.getElementsByTagName("itemsInInventory");
        if (nodes.getLength() > 0 && nodes.item(0) != null) {
            NodeList itemsInInventory = ((Element)nodes.item(0)).getElementsByTagName("item");
            HashMap<AbstractItem, Integer> itemMapToAdd = new HashMap<AbstractItem, Integer>();
            for (int i5 = 0; i5 < itemsInInventory.getLength(); ++i5) {
                e = (Element)itemsInInventory.item(i5);
                int count = Integer.parseInt(e.getAttribute("count"));
                String id = e.getAttribute("id");
                if (id.equals("GIFT_ROSE")) {
                    inventory.addClothing(Main.game.getItemGen().generateClothing("innoxia_hair_rose", PresetColour.CLOTHING_RED_DARK, PresetColour.CLOTHING_GREEN_DARK, null, false), count);
                    continue;
                }
                if (id.equals(ItemType.getIdFromItemType(ItemType.CONDOM_USED)) || id.equals(ItemType.getIdFromItemType(ItemType.CONDOM_USED_WEBBING))) {
                    itemMapToAdd.put(AbstractFilledCondom.loadFromXML(e, doc), count);
                    continue;
                }
                if (id.equals(ItemType.getIdFromItemType(ItemType.MOO_MILKER_FULL))) {
                    itemMapToAdd.put(AbstractFilledBreastPump.loadFromXML(e, doc), count);
                    continue;
                }
                AbstractItem itemLoadedFromXML = AbstractItem.loadFromXML(e, doc);
                if (itemLoadedFromXML == null) continue;
                itemMapToAdd.put(itemLoadedFromXML, count);
            }
            inventory.addItems(itemMapToAdd);
        }
        if ((nodes = parentElement.getElementsByTagName("clothingInInventory")).getLength() > 0 && nodes.item(0) != null) {
            Element clothingInInventory = (Element)nodes.item(0);
            NodeList clothingElements = clothingInInventory.getElementsByTagName("clothing");
            for (int i6 = 0; i6 < clothingElements.getLength(); ++i6) {
                e = (Element)clothingElements.item(i6);
                for (int clothingCount = 0; clothingCount < Integer.valueOf(e.getAttribute("count")); ++clothingCount) {
                    AbstractClothing clothing = AbstractClothing.loadFromXML(e, doc);
                    if (clothing == null) continue;
                    inventory.addClothing(clothing);
                }
            }
        }
        if ((nodes = parentElement.getElementsByTagName("weaponsInInventory")).getLength() > 0 && nodes.item(0) != null) {
            Element weaponsInInventory = (Element)nodes.item(0);
            NodeList weaponElements = weaponsInInventory.getElementsByTagName("weapon");
            for (int i7 = 0; i7 < weaponElements.getLength(); ++i7) {
                e = (Element)weaponElements.item(i7);
                for (int weaponCount = 0; weaponCount < Integer.valueOf(e.getAttribute("count")); ++weaponCount) {
                    AbstractWeapon weapon = AbstractWeapon.loadFromXML(e, doc);
                    if (weapon == null) continue;
                    inventory.addWeapon(weapon);
                }
            }
        }
        return inventory;
    }

    public boolean isEmpty() {
        for (int i = 0; i < 3; ++i) {
            if (this.mainWeapon[i] == null && this.offhandWeapon[i] == null) continue;
            return false;
        }
        return this.money == 0L && this.clothingSubInventory.isEmpty() && this.weaponSubInventory.isEmpty() && this.itemSubInventory.isEmpty() && this.essenceCount == 0 && this.dirtySlots.isEmpty() && this.clothingCurrentlyEquipped.isEmpty();
    }

    public long getMoney() {
        return this.money;
    }

    public void setMoney(long newValue) {
        this.money = Math.max(0L, newValue);
    }

    public void incrementMoney(long increment) {
        try {
            this.setMoney(Math.addExact(this.money, increment));
        }
        catch (ArithmeticException ex) {
            this.setMoney(Long.MAX_VALUE);
        }
    }

    public int getEssenceCount() {
        return this.essenceCount;
    }

    public void setEssenceCount(int essenceCount) {
        this.essenceCount = Math.max(0, essenceCount);
    }

    public void incrementEssenceCount(int increment) {
        try {
            this.setEssenceCount(Math.addExact(this.essenceCount, increment));
        }
        catch (ArithmeticException ex) {
            this.setEssenceCount(Integer.MAX_VALUE);
        }
    }

    public Map<String, List<InventorySlot>> getUnlockKeyMap() {
        return this.unlockKeyMap;
    }

    public void addToUnlockKeyMap(String id, InventorySlot slot) {
        this.unlockKeyMap.putIfAbsent(id, new ArrayList());
        this.unlockKeyMap.get(id).add(slot);
    }

    public boolean removeFromUnlockKeyMap(String id, InventorySlot slot) {
        if (this.unlockKeyMap.containsKey(id)) {
            boolean removed = this.unlockKeyMap.get(id).remove((Object)slot);
            if (this.unlockKeyMap.get(id).isEmpty()) {
                this.unlockKeyMap.remove(id);
            }
            return removed;
        }
        return false;
    }

    public int getMaximumInventorySpace() {
        if (this.floorInventory) {
            return Integer.MAX_VALUE;
        }
        return 150;
    }

    public void clearNonEquippedInventory(boolean clearMoney) {
        this.clothingSubInventory.clear();
        this.weaponSubInventory.clear();
        this.itemSubInventory.clear();
        if (clearMoney) {
            this.money = 0L;
        }
    }

    public boolean isInventoryFull() {
        return this.getInventorySlotsTaken() >= this.getMaximumInventorySpace();
    }

    public int getInventorySlotsTaken() {
        return this.getUniqueWeaponCount() - this.getUniqueQuestWeaponCount() + this.getUniqueClothingCount() - this.getUniqueQuestClothingCount() + this.getUniqueItemCount() - this.getUniqueQuestItemCount();
    }

    public boolean isAnyQuestItemPresent() {
        return this.getUniqueQuestWeaponCount() > 0 || this.getUniqueQuestClothingCount() > 0 || this.getUniqueQuestItemCount() > 0;
    }

    public void setExtraBlockedParts(BlockedParts extraBlockedParts) {
        this.extraBlockedParts = extraBlockedParts;
    }

    public BlockedParts getExtraBlockedParts() {
        return this.extraBlockedParts;
    }

    private void sortItemDuplicates() {
        this.itemSubInventory.sort();
    }

    private void sortWeaponDuplicates() {
        this.weaponSubInventory.sort();
    }

    private void sortClothingDuplicates() {
        this.clothingSubInventory.sort();
    }

    public void sortInventory() {
        this.sortItemDuplicates();
        this.sortWeaponDuplicates();
        this.sortClothingDuplicates();
    }

    public int getNonEquippedValue() {
        int value = 0;
        for (Map.Entry<AbstractItem, Integer> entry : this.getAllItemsInInventory().entrySet()) {
            value += entry.getKey().getValue() * entry.getValue();
        }
        for (Map.Entry<AbstractCoreItem, Integer> entry : this.getAllClothingInInventory().entrySet()) {
            value += ((AbstractClothing)entry.getKey()).getValue() * entry.getValue();
        }
        for (Map.Entry<AbstractCoreItem, Integer> entry : this.getAllWeaponsInInventory().entrySet()) {
            value += ((AbstractWeapon)entry.getKey()).getValue() * entry.getValue();
        }
        return value;
    }

    public int getEquippedValue() {
        int value = 0;
        for (AbstractClothing clothing : this.getClothingCurrentlyEquipped()) {
            value += clothing.getValue();
        }
        for (AbstractWeapon weapon : this.getMainWeaponArray()) {
            if (weapon == null) continue;
            value += weapon.getValue();
        }
        for (AbstractWeapon weapon : this.getOffhandWeaponArray()) {
            if (weapon == null) continue;
            value += weapon.getValue();
        }
        return value;
    }

    public Map<AbstractItem, Integer> getAllItemsInInventory() {
        return this.itemSubInventory.getDuplicateCounts();
    }

    public int getTotalItemCount() {
        return this.itemSubInventory.getTotalItemCount();
    }

    public int getUniqueItemCount() {
        return this.itemSubInventory.getUniqueItemCount();
    }

    public int getUniqueQuestItemCount() {
        return this.itemSubInventory.getQuestEntryCount();
    }

    public int getItemCount(AbstractItem item) {
        return this.itemSubInventory.getItemCount(item);
    }

    private void addItems(Map<AbstractItem, Integer> itemMap) {
        this.itemSubInventory.addFromMap(itemMap);
        if (Main.game.isStarted()) {
            this.sortItemDuplicates();
        }
    }

    public boolean addItem(AbstractItem item, int count) {
        if (item == null) {
            return false;
        }
        boolean canAddItem = this.canAddItem(item);
        if (canAddItem) {
            this.itemSubInventory.addItem(item, count);
            if (Main.game.isStarted()) {
                this.sortItemDuplicates();
            }
        }
        return canAddItem;
    }

    public boolean addItem(AbstractItem item) {
        return this.addItem(item, 1);
    }

    public boolean canAddItem(AbstractItem item) {
        return !this.isInventoryFull() || this.hasItem(item) || item.getRarity() == Rarity.QUEST;
    }

    public boolean removeItem(AbstractItem item) {
        return this.removeItem(item, 1);
    }

    public boolean removeItem(AbstractItem item, int count) {
        return this.itemSubInventory.removeItem(item, count);
    }

    public boolean hasItem(AbstractItem item) {
        return this.itemSubInventory.hasItem(item);
    }

    public boolean hasItemType(AbstractItemType item) {
        return this.itemSubInventory.hasItemType(item);
    }

    public boolean removeItemByType(AbstractItemType itemType) {
        return this.removeItemByType(itemType, 1);
    }

    public boolean removeItemByType(AbstractItemType itemType, int count) {
        return this.itemSubInventory.removeItemByType(itemType, count);
    }

    public boolean removeAllItemsByRarity(Rarity rarity) {
        return this.itemSubInventory.removeAllItemsByRarity(rarity);
    }

    public boolean dropItem(AbstractItem item, World world, Vector2i location) {
        return this.dropItem(item, 1, world, location);
    }

    public boolean dropItem(AbstractItem item, int count, World world, Vector2i location) {
        if (this.hasItem(item)) {
            world.getCell(location).getInventory().addItem(item, count);
            this.removeItem(item, count);
            return true;
        }
        return false;
    }

    public Map<AbstractWeapon, Integer> getAllWeaponsInInventory() {
        return this.weaponSubInventory.getDuplicateCounts();
    }

    public int getTotalWeaponCount() {
        return this.weaponSubInventory.getTotalItemCount();
    }

    public int getUniqueWeaponCount() {
        return this.weaponSubInventory.getUniqueItemCount();
    }

    public int getUniqueQuestWeaponCount() {
        return this.weaponSubInventory.getQuestEntryCount();
    }

    public int getWeaponCount(AbstractWeapon weapon) {
        return this.weaponSubInventory.getItemCount(weapon);
    }

    public boolean addWeapon(AbstractWeapon weapon, int count) {
        if (weapon == null) {
            return false;
        }
        if (this.canAddWeapon(weapon)) {
            this.weaponSubInventory.addItem(weapon, count);
            if (Main.game.isStarted()) {
                this.sortWeaponDuplicates();
            }
            return true;
        }
        return false;
    }

    public boolean addWeapon(AbstractWeapon weapon) {
        return this.addWeapon(weapon, 1);
    }

    public boolean canAddWeapon(AbstractWeapon weapon) {
        return !this.isInventoryFull() || this.hasWeapon(weapon) || weapon.getRarity() == Rarity.QUEST;
    }

    public boolean removeWeapon(AbstractWeapon weapon) {
        return this.removeWeapon(weapon, 1);
    }

    public boolean removeWeapon(AbstractWeapon weapon, int count) {
        return this.weaponSubInventory.removeItem(weapon, count);
    }

    public boolean hasWeapon(AbstractWeapon weapon) {
        return this.weaponSubInventory.hasItem(weapon);
    }

    public boolean hasWeaponType(AbstractWeaponType weapon) {
        return this.weaponSubInventory.hasItemType(weapon);
    }

    public boolean removeWeaponByType(AbstractWeaponType weaponType) {
        return this.weaponSubInventory.removeItemByType(weaponType, 1);
    }

    public boolean removeAllWeaponsByRarity(Rarity rarity) {
        return this.weaponSubInventory.removeAllItemsByRarity(rarity);
    }

    public boolean dropWeapon(AbstractWeapon weapon, World world, Vector2i location) {
        return this.dropWeapon(weapon, 1, world, location);
    }

    public boolean dropWeapon(AbstractWeapon weapon, int count, World world, Vector2i location) {
        if (this.hasWeapon(weapon)) {
            world.getCell(location).getInventory().addWeapon(weapon, count);
            this.removeWeapon(weapon, count);
            return true;
        }
        return false;
    }

    public AbstractWeapon getMainWeapon(int armRow) {
        return this.mainWeapon[armRow];
    }

    public AbstractWeapon[] getMainWeaponArray() {
        return this.mainWeapon;
    }

    public void equipMainWeapon(int armRow, AbstractWeapon weapon) {
        if (armRow >= 3) {
            throw new IllegalArgumentException("Equipping main weapon failed! Row was passed in as " + armRow + ", but maximum arm rows is 3!");
        }
        this.mainWeapon[armRow] = weapon;
    }

    public void unequipMainWeapon(int armRow) {
        this.mainWeapon[armRow] = null;
    }

    public AbstractWeapon getOffhandWeapon(int armRow) {
        return this.offhandWeapon[armRow];
    }

    public AbstractWeapon[] getOffhandWeaponArray() {
        return this.offhandWeapon;
    }

    public void equipOffhandWeapon(int armRow, AbstractWeapon weapon) {
        if (armRow >= 3) {
            throw new IllegalArgumentException("Equipping main weapon failed! Row was passed in as " + armRow + ", but maximum arm rows is 3!");
        }
        this.offhandWeapon[armRow] = weapon;
    }

    public void unequipOffhandWeapon(int armRow) {
        this.offhandWeapon[armRow] = null;
    }

    public Map<AbstractClothing, Integer> getAllClothingInInventory() {
        return this.clothingSubInventory.getDuplicateCounts();
    }

    public int getTotalClothingCount() {
        return this.clothingSubInventory.getTotalItemCount();
    }

    public int getUniqueClothingCount() {
        return this.clothingSubInventory.getUniqueItemCount();
    }

    public int getUniqueQuestClothingCount() {
        return this.clothingSubInventory.getQuestEntryCount();
    }

    public int getClothingCount(AbstractClothing clothing) {
        return this.clothingSubInventory.getItemCount(clothing);
    }

    public boolean addClothing(AbstractClothing clothing, int count) {
        if (clothing == null) {
            return false;
        }
        if (this.canAddClothing(clothing)) {
            this.clothingSubInventory.addItem(clothing, count);
            if (Main.game.isStarted()) {
                this.sortClothingDuplicates();
            }
            return true;
        }
        return false;
    }

    public boolean addClothing(AbstractClothing clothing) {
        return this.addClothing(clothing, 1);
    }

    public boolean canAddClothing(AbstractClothing clothing) {
        return !this.isInventoryFull() || this.hasClothing(clothing) || clothing.getRarity() == Rarity.QUEST;
    }

    public boolean removeClothing(AbstractClothing clothing) {
        return this.removeClothing(clothing, 1);
    }

    public boolean removeClothing(AbstractClothing clothing, int count) {
        return this.clothingSubInventory.removeItem(clothing, count);
    }

    public boolean hasClothing(AbstractClothing clothing) {
        return this.clothingSubInventory.hasItem(clothing);
    }

    public boolean hasClothingType(AbstractClothingType type, boolean includeEquipped) {
        return this.clothingSubInventory.hasItemType(type) || includeEquipped && this.hasEquippedClothingType(type);
    }

    public boolean hasEquippedClothingType(AbstractClothingType type) {
        return this.getClothingCurrentlyEquipped().stream().anyMatch(c -> c.getClothingType().equals(type));
    }

    public boolean removeClothingByType(AbstractClothingType clothingType) {
        return this.clothingSubInventory.removeItemByType(clothingType, 1);
    }

    public boolean removeClothingByName(String nameToMatch) {
        AbstractClothing clothing = null;
        for (AbstractClothing c : this.getAllClothingInInventory().keySet()) {
            if (!c.getName().equalsIgnoreCase(nameToMatch)) continue;
            clothing = c;
            break;
        }
        if (clothing != null) {
            this.removeClothing(clothing, 1);
            return true;
        }
        return false;
    }

    public boolean removeAllClothingByRarity(Rarity rarity) {
        return this.clothingSubInventory.removeAllItemsByRarity(rarity);
    }

    public boolean dropClothing(AbstractClothing clothing, World world, Vector2i location) {
        return this.dropClothing(clothing, 1, world, location);
    }

    public boolean dropClothing(AbstractClothing clothing, int count, World world, Vector2i location) {
        if (this.hasClothing(clothing)) {
            world.getCell(location).getInventory().addClothing(clothing, count);
            this.removeClothing(clothing, count);
            return true;
        }
        return false;
    }

    public boolean isAnyClothingDirty() {
        for (AbstractClothing c : this.getClothingCurrentlyEquipped()) {
            if (!c.isDirty()) continue;
            return true;
        }
        return false;
    }

    public void cleanAllClothing(boolean includeNotEquippedClothing) {
        if (!this.isAnyClothingDirty() && !includeNotEquippedClothing) {
            return;
        }
        if (includeNotEquippedClothing) {
            this.clothingSubInventory.transform(c -> {
                c.setDirty(null, false);
                return c;
            });
        }
        for (AbstractClothing c2 : this.clothingCurrentlyEquipped) {
            c2.setDirty(null, false);
        }
    }

    public List<AbstractClothing> getClothingCurrentlyEquipped() {
        return this.clothingCurrentlyEquipped;
    }

    public Map<InventorySlot, List<AbstractClothing>> getInventorySlotsConcealed(GameCharacter character) {
        HashMap<InventorySlot, List<AbstractClothing>> concealedMap = new HashMap<InventorySlot, List<AbstractClothing>>();
        HashSet<InventorySlot> itemConcealed = new HashSet<InventorySlot>();
        HashSet<InventorySlot> itemRevealed = new HashSet<InventorySlot>();
        for (AbstractClothing c : this.getClothingCurrentlyEquipped()) {
            itemConcealed.clear();
            itemRevealed.clear();
            for (BlockedParts bp : c.getBlockedPartsMap(character, c.getSlotEquippedTo())) {
                if (!c.getDisplacedList().contains((Object)bp.displacementType)) {
                    itemConcealed.addAll(bp.concealedSlots);
                    for (InventorySlot inventorySlot : bp.concealedSlots) {
                        if (this.getClothingInSlot(inventorySlot) == null || !this.getClothingInSlot(inventorySlot).getItemTags().contains((Object)ItemTag.REVEALS_CONCEALABLE_SLOT)) continue;
                        itemRevealed.add(inventorySlot);
                    }
                    continue;
                }
                itemRevealed.addAll(bp.concealedSlots);
            }
            itemConcealed.removeAll(itemRevealed);
            for (InventorySlot slot : itemConcealed) {
                concealedMap.putIfAbsent(slot, new ArrayList());
                ((List)concealedMap.get((Object)slot)).add(c);
            }
        }
        for (AbstractClothing c : this.getClothingCurrentlyEquipped()) {
            InventorySlot clothingSlot = c.getSlotEquippedTo();
            for (InventorySlot is : c.getIncompatibleSlots(character, clothingSlot)) {
                if (!concealedMap.containsKey((Object)clothingSlot) || concealedMap.containsKey((Object)is)) continue;
                concealedMap.remove((Object)clothingSlot);
            }
            if (!concealedMap.containsKey((Object)clothingSlot)) continue;
            boolean remove = false;
            for (Map.Entry entry : concealedMap.entrySet()) {
                if (!((List)entry.getValue()).contains(c) || ((List)entry.getValue()).size() != 1) continue;
                remove = true;
                break;
            }
            if (!remove) continue;
            concealedMap.remove((Object)clothingSlot);
        }
        if (this.getExtraBlockedParts() != null) {
            for (InventorySlot slot : this.getExtraBlockedParts().concealedSlots) {
                if (concealedMap.containsKey((Object)slot)) continue;
                concealedMap.put(slot, new ArrayList());
            }
        }
        return concealedMap;
    }

    public List<AbstractClothing> getVisibleClothingConcealingSlot(GameCharacter character, InventorySlot slot) {
        List<Object> visibleClothing = new ArrayList<AbstractClothing>();
        if (this.getClothingInSlot(slot) != null) {
            visibleClothing.add(this.getClothingInSlot(slot));
        }
        if (this.getInventorySlotsConcealed(character).get((Object)slot) != null) {
            visibleClothing.addAll((Collection)this.getInventorySlotsConcealed(character).get((Object)slot));
        }
        if (!visibleClothing.isEmpty()) {
            List slotsToCheck = visibleClothing.stream().map(c -> c.getSlotEquippedTo()).collect(Collectors.toList());
            HashSet slotsAlreadyChecked = new HashSet(slotsToCheck);
            while (!slotsToCheck.isEmpty()) {
                for (InventorySlot checkSlot : new ArrayList(slotsToCheck)) {
                    List<AbstractClothing> checkClothingSlot = this.getInventorySlotsConcealed(character).get((Object)checkSlot);
                    if (checkClothingSlot != null && !checkClothingSlot.isEmpty()) {
                        visibleClothing = visibleClothing.stream().filter(cl -> cl.getSlotEquippedTo() != checkSlot).collect(Collectors.toList());
                        for (AbstractClothing c2 : checkClothingSlot) {
                            visibleClothing.add(c2);
                            if (slotsAlreadyChecked.contains((Object)c2.getSlotEquippedTo())) continue;
                            slotsToCheck.add(c2.getSlotEquippedTo());
                            slotsAlreadyChecked.add(c2.getSlotEquippedTo());
                        }
                    }
                    slotsToCheck.remove((Object)checkSlot);
                }
            }
        }
        return new ArrayList<AbstractClothing>(new HashSet(visibleClothing));
    }

    public AbstractClothing getClothingInSlot(InventorySlot invSlot) {
        AbstractClothing clothingInSlot = null;
        for (AbstractClothing clothing : this.clothingCurrentlyEquipped) {
            if (clothing.getSlotEquippedTo() != invSlot) continue;
            clothingInSlot = clothing;
            break;
        }
        return clothingInSlot;
    }

    public int getClothingSetCount(AbstractSetBonus clothingSet) {
        return this.clothingSetCount.get(clothingSet);
    }

    public boolean isFloorInventory() {
        return this.floorInventory;
    }

    public String calculateClothingAndWeaponsPostTransformation(GameCharacter character) {
        BodyPartClothingBlock block;
        AbstractWeapon weapon;
        int i;
        this.tempSB = new StringBuilder();
        ArrayList<AbstractClothing> clothingToRemove = new ArrayList<AbstractClothing>();
        for (AbstractClothing c : new ArrayList<AbstractClothing>(this.clothingCurrentlyEquipped)) {
            BodyPartClothingBlock block2 = c.getSlotEquippedTo().getBodyPartClothingBlock(character);
            if (block2 != null && Collections.disjoint(block2.getRequiredTags(), c.getItemTags())) {
                this.transformationIncompatible(character, c, clothingToRemove, UtilText.parse(character, block2.getDescription(), new ParserTag[0]));
                continue;
            }
            if (c.isCanBeEquipped(character, c.getSlotEquippedTo())) continue;
            this.transformationIncompatible(character, c, clothingToRemove, c.getCannotBeEquippedText(character, c.getSlotEquippedTo()));
        }
        InventorySlot[] slots = InventorySlot.mainWeaponSlots;
        for (i = 0; i < character.getMainWeaponArray().length; ++i) {
            weapon = character.getMainWeaponArray()[i];
            block = slots[i].getBodyPartClothingBlock(character);
            if (weapon == null || character.getArmRows() - 1 >= i && (block == null || !Collections.disjoint(block.getRequiredTags(), weapon.getItemTags()))) continue;
            this.transformationIncompatibleWeapon(character, weapon, character.unequipMainWeapon(i, false, true));
        }
        slots = InventorySlot.offhandWeaponSlots;
        for (i = 0; i < character.getOffhandWeaponArray().length; ++i) {
            weapon = character.getOffhandWeaponArray()[i];
            block = slots[i].getBodyPartClothingBlock(character);
            if (weapon == null || character.getArmRows() - 1 >= i && (block == null || !Collections.disjoint(block.getRequiredTags(), weapon.getItemTags()))) continue;
            this.transformationIncompatibleWeapon(character, weapon, character.unequipOffhandWeapon(i, false, true));
        }
        return this.tempSB.toString();
    }

    private void transformationIncompatible(GameCharacter character, AbstractClothing c, List<AbstractClothing> clothingRemovalList, String description) {
        if (this.tempSB.length() != 0) {
            this.tempSB.append("<br/><br/>");
        }
        this.tempSB.append("<br/><span style='color:" + PresetColour.GENERIC_BAD.toWebHexString() + ";'>" + UtilText.parse(character, description, new ParserTag[0]) + "</span>");
        c.setSealed(false);
        if (c.isDiscardedOnUnequip(c.getSlotEquippedTo())) {
            this.tempSB.append(character.unequipClothingIntoVoid(c, true, character));
        } else {
            this.tempSB.append(character.unequipClothingIntoInventory(c, true, character));
        }
        clothingRemovalList.add(c);
    }

    private void transformationIncompatibleWeapon(GameCharacter character, AbstractWeapon w, String description) {
        if (this.tempSB.length() != 0) {
            this.tempSB.append("<br/><br/>");
        }
        this.tempSB.append("<br/><span style='color:" + PresetColour.GENERIC_BAD.toWebHexString() + ";'>" + UtilText.parse(character, "\u7531\u4e8e[npc.name]\u5931\u53bb\u4e86\u989d\u5916\u7684\u624b\u81c2\uff0c\u65e0\u6cd5\u518d\u63e1\u6301" + w.getName() + "\uff01", new ParserTag[0]) + "</span>");
        this.tempSB.append("<br/>" + description);
    }

    public String getEquipDescription() {
        return this.equipTextSB.toString();
    }

    public void resetEquipDescription() {
        this.equipTextSB.setLength(0);
    }

    public boolean isAbleToEquip(AbstractClothing newClothing, InventorySlot slotToEquipInto, boolean equipIfAble, boolean automaticClothingManagement, GameCharacter characterClothingOwner, GameCharacter characterClothingEquipper) {
        this.displacementClothingChecked = new HashMap<AbstractClothing, List<AbstractClothing>>();
        this.clothingToRemove.clear();
        this.equipTextSB.setLength(0);
        BodyPartClothingBlock block = slotToEquipInto.getBodyPartClothingBlock(characterClothingOwner);
        if (block != null && Collections.disjoint(block.getRequiredTags(), newClothing.getItemTags())) {
            this.equipTextSB.append("[style.colourBad(" + UtilText.parse(characterClothingOwner, block.getDescription(), new ParserTag[0]) + ")]");
            return false;
        }
        if (!newClothing.isAbleToBeEquipped(characterClothingOwner, slotToEquipInto).getKey().booleanValue()) {
            this.equipTextSB.append("[style.colourBad(" + newClothing.isAbleToBeEquipped(characterClothingOwner, slotToEquipInto).getValue() + ")]");
            return false;
        }
        if (this.getClothingInSlot(slotToEquipInto) != null && this.getClothingInSlot(slotToEquipInto).isSealed()) {
            if (characterClothingOwner.isPlayer()) {
                this.equipTextSB.append("\u4f60\u65e0\u6cd5\u88c5\u5907" + newClothing.getName() + "\uff0c\u56e0\u4e3a\u4f60<b style='color:" + PresetColour.SEALED.toWebHexString() + ";'>\u88ab\u5c01\u5370\u7684</b>" + this.getClothingInSlot(slotToEquipInto).getName() + "\u65e0\u6cd5\u88ab\u79fb\u9664\uff01");
            } else {
                this.equipTextSB.append(UtilText.parse(characterClothingOwner, "[npc.Name]\u65e0\u6cd5\u88c5\u5907" + newClothing.getName() + "\uff0c\u56e0\u4e3a[npc.her]<b style='color:" + PresetColour.SEALED.toWebHexString() + ";'>\u88ab\u5c01\u5370\u7684</b>" + this.getClothingInSlot(slotToEquipInto).getName() + "\u65e0\u6cd5\u88ab\u79fb\u9664\uff01", new ParserTag[0]));
            }
            return false;
        }
        this.incompatibleUnequippableClothing.clear();
        this.incompatibleRemovableClothing.clear();
        for (InventorySlot inventorySlot : newClothing.getIncompatibleSlots(characterClothingOwner, slotToEquipInto)) {
            if (this.getClothingInSlot(inventorySlot) == null) continue;
            if (!this.isAbleToUnequip(this.getClothingInSlot(inventorySlot), false, automaticClothingManagement, characterClothingOwner, characterClothingEquipper, false)) {
                this.incompatibleUnequippableClothing.add(this.getClothingInSlot(inventorySlot));
                continue;
            }
            this.clothingToRemove.put(this.getClothingInSlot(inventorySlot), DisplacementType.REMOVE_OR_EQUIP);
            this.incompatibleRemovableClothing.add(this.getClothingInSlot(inventorySlot));
        }
        for (AbstractClothing abstractClothing : this.clothingCurrentlyEquipped) {
            if (!abstractClothing.getIncompatibleSlots(characterClothingOwner, abstractClothing.getSlotEquippedTo()).contains((Object)slotToEquipInto)) continue;
            if (!this.isAbleToUnequip(abstractClothing, false, automaticClothingManagement, characterClothingOwner, characterClothingEquipper, false)) {
                this.incompatibleUnequippableClothing.add(abstractClothing);
                continue;
            }
            this.clothingToRemove.put(abstractClothing, DisplacementType.REMOVE_OR_EQUIP);
            this.incompatibleRemovableClothing.add(abstractClothing);
        }
        if (!this.incompatibleUnequippableClothing.isEmpty()) {
            for (AbstractClothing abstractClothing : this.incompatibleUnequippableClothing) {
                if (!abstractClothing.isSealed()) continue;
                this.equipTextSB.append((String)(characterClothingOwner.isPlayer() ? "<br/>\u4f60\u65e0\u6cd5\u88c5\u5907" + newClothing.getName() + "\uff0c\u56e0\u4e3a\u4f60<b style='color:" + PresetColour.SEALED.toWebHexString() + ";'>\u88ab\u5c01\u5370\u7684</b>" + abstractClothing.getName() + "\u6321\u4f4f\u4e86\u3002" : UtilText.parse(characterClothingOwner, "<br/>[npc.Name]\u65e0\u6cd5\u88c5\u5907" + newClothing.getName() + "\uff0c\u56e0\u4e3a[npc.her]<b style='color:" + PresetColour.SEALED.toWebHexString() + ";'>\u88ab\u5c01\u5370\u7684</b>" + abstractClothing.getName() + "\u6321\u4f4f\u4e86\u3002", new ParserTag[0])));
            }
            return false;
        }
        for (BlockedParts blockedParts : newClothing.getBlockedPartsMap(characterClothingOwner, slotToEquipInto)) {
            if (blockedParts.displacementType != DisplacementType.REMOVE_OR_EQUIP) continue;
            if (blockedParts.clothingAccessRequired == null) break;
            for (AbstractClothing equippedClothing : this.clothingCurrentlyEquipped) {
                for (BlockedParts bpEquipped : equippedClothing.getBlockedPartsMap(characterClothingOwner, equippedClothing.getSlotEquippedTo())) {
                    for (ClothingAccess caBlocked : bpEquipped.clothingAccessBlocked) {
                        if (!blockedParts.clothingAccessRequired.contains((Object)caBlocked) || equippedClothing.getDisplacedList().contains((Object)bpEquipped.displacementType) || this.isDisplacementAvailableFromElsewhere(characterClothingOwner, equippedClothing, caBlocked)) continue;
                        if (!this.clothingToRemove.containsKey(equippedClothing)) {
                            if (automaticClothingManagement && this.isAbleToBeDisplaced(equippedClothing, bpEquipped.displacementType, false, automaticClothingManagement, characterClothingOwner, characterClothingEquipper, true)) {
                                this.clothingToRemove.put(equippedClothing, bpEquipped.displacementType);
                                continue;
                            }
                            this.equipTextSB.append((String)(characterClothingOwner.isPlayer() ? "<br/>\u4f60\u7684<b style='color:" + PresetColour.GENERIC_BAD.toWebHexString() + ";'>" + equippedClothing.getName() + "</b>\u963b\u6b62\u4e86\u4f60\u88c5\u5907" + newClothing.getName() + "\uff01" : UtilText.parse(characterClothingOwner, "<br/>[npc.NamePos]\u7684<b style='color:" + PresetColour.GENERIC_BAD.toWebHexString() + ";'>" + equippedClothing.getName() + "</b>\u963b\u6b62\u4e86[npc.herHim]\u88c5\u5907" + newClothing.getName() + "\uff01", new ParserTag[0])));
                            this.blockingClothing = equippedClothing;
                            return false;
                        }
                        if (this.isAbleToUnequip(equippedClothing, false, automaticClothingManagement, characterClothingOwner, characterClothingEquipper, false)) {
                            this.clothingToRemove.put(equippedClothing, DisplacementType.REMOVE_OR_EQUIP);
                            continue;
                        }
                        if (equippedClothing.isSealed()) {
                            this.equipTextSB.append((String)(characterClothingOwner.isPlayer() ? "<br/>\u4f60\u65e0\u6cd5\u88c5\u5907" + newClothing.getName() + "\uff0c\u56e0\u4e3a\u4f60<b style='color:" + PresetColour.SEALED.toWebHexString() + ";'>\u88ab\u5c01\u5370\u7684</b>" + equippedClothing.getName() + "\u6321\u4f4f\u4e86\uff01" : UtilText.parse(characterClothingOwner, "<br/>[npc.Name]\u65e0\u6cd5\u88c5\u5907" + newClothing.getName() + "\uff0c\u56e0\u4e3a[npc.her]<b style='color:" + PresetColour.SEALED.toWebHexString() + ";'>\u88ab\u5c01\u5370\u7684</b>" + equippedClothing.getName() + "\u6321\u4f4f\u4e86\uff01", new ParserTag[0])));
                        } else {
                            this.equipTextSB.append((String)(characterClothingOwner.isPlayer() ? "<br/>\u4f60\u65e0\u6cd5\u88c5\u5907" + newClothing.getName() + "\uff0c\u56e0\u4e3a\u4f60\u7684" + equippedClothing.getName() + "\u6321\u4f4f\u4e86\uff01" : UtilText.parse(characterClothingOwner, "<br/>[npc.Name]\u65e0\u6cd5\u88c5\u5907" + newClothing.getName() + "\uff0c\u56e0\u4e3a[npc.her]\u7684" + equippedClothing.getName() + "\u6321\u4f4f\u4e86\uff01", new ParserTag[0])));
                        }
                        this.blockingClothing = equippedClothing;
                        return false;
                    }
                }
            }
        }
        if (equipIfAble) {
            this.equipTextSB = new StringBuilder();
            if (automaticClothingManagement || this.clothingToRemove.size() == this.incompatibleRemovableClothing.size() + 1) {
                AbstractSetBonus abstractSetBonus;
                if (this.getClothingInSlot(slotToEquipInto) != null) {
                    AbstractClothing equippedClothing = this.getClothingInSlot(slotToEquipInto);
                    if (this.isAbleToUnequip(equippedClothing, false, automaticClothingManagement, characterClothingOwner, characterClothingEquipper, false)) {
                        this.clothingToRemove.put(equippedClothing, DisplacementType.REMOVE_OR_EQUIP);
                    } else {
                        if (equippedClothing.isSealed()) {
                            this.equipTextSB.append((String)(characterClothingOwner.isPlayer() ? "\u4f60\u65e0\u6cd5\u88c5\u5907" + newClothing.getName() + "\uff0c\u56e0\u4e3a\u4f60<b style='color:" + PresetColour.SEALED.toWebHexString() + ";'>\u88ab\u5c01\u5370\u7684</b>" + equippedClothing.getName() + "\u6321\u4f4f\u4e86\uff01" : UtilText.parse(characterClothingOwner, "[npc.Name]\u65e0\u6cd5\u88c5\u5907" + newClothing.getName() + "\uff0c\u56e0\u4e3a[npc.her]<b style='color:" + PresetColour.SEALED.toWebHexString() + ";'>\u88ab\u5c01\u5370\u7684</b>" + equippedClothing.getName() + "\u6321\u4f4f\u4e86\uff01", new ParserTag[0])));
                        } else {
                            this.equipTextSB.append((String)(characterClothingOwner.isPlayer() ? "\u4f60\u65e0\u6cd5\u88c5\u5907" + newClothing.getName() + "\uff0c\u56e0\u4e3a\u4f60\u7684" + equippedClothing.getName() + "\u6321\u4f4f\u4e86\uff01" : UtilText.parse(characterClothingOwner, "[npc.Name]\u65e0\u6cd5\u88c5\u5907" + newClothing.getName() + "\uff0c\u56e0\u4e3a[npc.her]\u7684" + equippedClothing.getName() + "\u6321\u4f4f\u4e86\uff01", new ParserTag[0])));
                        }
                        this.blockingClothing = equippedClothing;
                        return false;
                    }
                }
                ArrayList<AbstractClothing> tempClothingList = new ArrayList<AbstractClothing>();
                for (AbstractClothing abstractClothing : this.clothingToRemove.keySet()) {
                    if (tempClothingList.contains(abstractClothing)) continue;
                    tempClothingList.add(abstractClothing);
                }
                for (AbstractClothing abstractClothing : this.incompatibleRemovableClothing) {
                    if (tempClothingList.contains(abstractClothing)) continue;
                    tempClothingList.add(abstractClothing);
                }
                tempClothingList.sort(new ClothingZLayerComparator());
                ArrayList<AbstractClothing> arrayList = new ArrayList<AbstractClothing>();
                for (AbstractClothing c : tempClothingList) {
                    if (!this.incompatibleRemovableClothing.contains(c) && c != this.getClothingInSlot(slotToEquipInto)) {
                        arrayList.add(c);
                    }
                    this.equipTextSB.append((this.equipTextSB.length() == 0 ? "" : "<br/>") + (String)(!this.clothingToRemove.containsKey(c) || this.clothingToRemove.get(c) == DisplacementType.REMOVE_OR_EQUIP ? c.onUnequipText(characterClothingOwner, characterClothingEquipper, Main.game.isInSex() ? Main.sex.getSexPace(characterClothingEquipper) == SexPace.DOM_ROUGH : false) : (characterClothingOwner.isPlayer() ? "\u4f60" + this.clothingToRemove.get(c).getDescription() + "\u4f60\u7684" + c.getName() + "\u3002" : "[npc.Name]" + this.clothingToRemove.get(c).getDescriptionThirdPerson() + "[npc.her]\u7684" + c.getName() + "\u3002")));
                }
                for (AbstractClothing c : this.incompatibleRemovableClothing) {
                    if (!characterClothingOwner.isInventoryFull() || characterClothingOwner.hasClothing(c)) {
                        this.equipTextSB.append("<br/>" + characterClothingOwner.addedItemToInventoryText(c));
                    } else {
                        this.equipTextSB.append("<br/>" + characterClothingOwner.droppedItemText(c));
                    }
                    String oldEquipText = this.equipTextSB.toString();
                    if (Main.game.isInNewWorld()) {
                        characterClothingOwner.unequipClothingIntoInventory(c, true, characterClothingEquipper);
                    } else {
                        characterClothingOwner.unequipClothingOntoFloor(c, true, characterClothingEquipper);
                    }
                    this.equipTextSB.setLength(0);
                    this.equipTextSB.append(oldEquipText);
                }
                newClothing.getDisplacedList().clear();
                if (this.getClothingInSlot(slotToEquipInto) != null) {
                    if (this.getClothingInSlot(slotToEquipInto).isDiscardedOnUnequip(slotToEquipInto)) {
                        String string = this.equipTextSB.toString();
                        characterClothingOwner.unequipClothingIntoVoid(this.getClothingInSlot(slotToEquipInto), true, characterClothingEquipper);
                        this.equipTextSB.setLength(0);
                        this.equipTextSB.append(string);
                    } else {
                        if ((!characterClothingOwner.isInventoryFull() || characterClothingOwner.hasClothing(this.getClothingInSlot(slotToEquipInto))) && Main.game.isInNewWorld()) {
                            this.equipTextSB.append("<br/>" + characterClothingOwner.addedItemToInventoryText(this.getClothingInSlot(slotToEquipInto)));
                        } else {
                            this.equipTextSB.append("<br/>" + characterClothingOwner.droppedItemText(this.getClothingInSlot(slotToEquipInto)));
                        }
                        String string = this.equipTextSB.toString();
                        if (Main.game.isInNewWorld()) {
                            characterClothingOwner.unequipClothingIntoInventory(this.getClothingInSlot(slotToEquipInto), true, characterClothingEquipper);
                        } else {
                            characterClothingOwner.unequipClothingOntoFloor(this.getClothingInSlot(slotToEquipInto), true, characterClothingEquipper);
                        }
                        this.equipTextSB.setLength(0);
                        this.equipTextSB.append(string);
                    }
                }
                this.clothingCurrentlyEquipped.add(newClothing);
                newClothing.setSlotEquippedTo(slotToEquipInto);
                this.equipTextSB.append((this.equipTextSB.length() == 0 ? "" : "<br/>") + newClothing.onEquipApplyEffects(characterClothingOwner, characterClothingEquipper, Main.game.isInSex() ? Main.sex.getSexPace(characterClothingEquipper) == SexPace.DOM_ROUGH : false));
                arrayList.sort(new ReverseClothingZLayerComparator());
                if (!arrayList.isEmpty()) {
                    this.equipTextSB.append((String)(characterClothingOwner.isPlayer() ? "<br/>\u4f60\u6062\u590d\u4e86\u4f60\u7684" + Util.clothesToStringList(arrayList, false) + "\u3002" : UtilText.parse(characterClothingOwner, "<br/>[npc.Name]\u6062\u590d\u4e86[npc.her]\u7684" + Util.clothesToStringList(arrayList, false) + "\u3002", new ParserTag[0])));
                }
                if (newClothing.getItemTags().contains((Object)ItemTag.PROVIDES_KEY) && newClothing.isSealed()) {
                    this.equipTextSB.append(UtilText.parse(characterClothingEquipper, "<br/>[style.italicsGood([npc.Name]\u83b7\u5f97\u4e86\u89e3\u9501" + newClothing.getName() + "\u7684\u94a5\u5319\uff01)]", new ParserTag[0]));
                }
                if ((abstractSetBonus = newClothing.getClothingType().getClothingSet()) != null) {
                    this.clothingSetCount.merge(abstractSetBonus, 1, Integer::sum);
                }
            }
            this.clothingCurrentlyEquipped.sort(new ClothingRarityComparator());
        } else if (this.clothingToRemove.isEmpty()) {
            this.equipTextSB.append(Util.capitaliseSentence(newClothing.getName(true)) + "\u53ef\u4ee5\u88c5\u5907\u3002");
        } else {
            this.equipTextSB.append(Util.capitaliseSentence("\u5728\u88c5\u5907" + newClothing.getClothingType().getDeterminer()) + newClothing.getName() + "\u4e4b\u524d\uff0c\u5fc5\u987b\u5148\u79fb\u9664" + Util.clothesToStringList(this.clothingToRemove.keySet(), false) + "\u3002");
        }
        return true;
    }

    public void forceUnequipClothingIntoVoid(GameCharacter characterClothingOwner, GameCharacter characterRemovingClothing, AbstractClothing clothing) {
        clothing.onUnequipApplyEffects(characterClothingOwner, characterRemovingClothing, false);
        this.clothingCurrentlyEquipped.remove(clothing);
        clothing.getDisplacedList().clear();
    }

    public boolean isAbleToUnequip(AbstractClothing clothing, boolean unequipIfAble, boolean automaticClothingManagement, GameCharacter characterClothingOwner, GameCharacter characterRemovingClothing) {
        return this.isAbleToUnequip(clothing, unequipIfAble, automaticClothingManagement, characterClothingOwner, characterRemovingClothing, false);
    }

    private boolean isAbleToUnequip(AbstractClothing clothing, boolean unequipIfAble, boolean automaticClothingManagement, GameCharacter characterClothingOwner, GameCharacter characterRemovingClothing, boolean continuingIsAbleToEquip) {
        if (!continuingIsAbleToEquip) {
            this.initialClothingCheck = clothing;
            this.clothingToRemove.clear();
            this.equipTextSB.setLength(0);
        }
        if (!unequipIfAble) {
            if (characterClothingOwner == null) {
                characterClothingOwner = Main.game.getPlayer();
            }
            if (characterRemovingClothing == null) {
                characterRemovingClothing = Main.game.getPlayer();
            }
        }
        if (clothing.isSealed()) {
            this.equipTextSB.append((String)(characterClothingOwner.isPlayer() ? "\u4f60\u7684" + clothing.getName() + "\u65e0\u6cd5\u88ab\u79fb\u9664\uff0c\u56e0\u4e3a\u88ab<b style='color:" + PresetColour.SEALED.toWebHexString() + ";'>\u5c01\u5370</b>\u4e86\uff01" : UtilText.parse(characterClothingOwner, "[npc.NamePos]\u7684" + clothing.getName() + "\u65e0\u6cd5\u88ab\u79fb\u9664\uff0c\u56e0\u4e3a\u88ab<b style='color:" + PresetColour.SEALED.toWebHexString() + ";'>\u5c01\u5370</b>\u4e86\uff01", new ParserTag[0])));
            this.blockingClothing = clothing;
            return false;
        }
        if (!continuingIsAbleToEquip) {
            this.clothingToRemove.put(clothing, DisplacementType.REMOVE_OR_EQUIP);
        }
        BlockedParts removeEquipBlockedParts = null;
        for (BlockedParts blockedParts : clothing.getBlockedPartsMap(characterClothingOwner, clothing.getSlotEquippedTo())) {
            if (blockedParts.displacementType != DisplacementType.REMOVE_OR_EQUIP || blockedParts.clothingAccessRequired == null) continue;
            removeEquipBlockedParts = blockedParts;
        }
        if (removeEquipBlockedParts != null) {
            ArrayList<AbstractClothing> equippedClothingSorted = new ArrayList<AbstractClothing>(this.clothingCurrentlyEquipped);
            equippedClothingSorted.sort(new ClothingZLayerComparator());
            equippedClothingSorted.remove(clothing);
            equippedClothingSorted.remove(this.initialClothingCheck);
            for (AbstractClothing abstractClothing : equippedClothingSorted) {
                for (BlockedParts bpEquipped : abstractClothing.getBlockedPartsMap(characterClothingOwner, abstractClothing.getSlotEquippedTo())) {
                    for (ClothingAccess caBlocked : bpEquipped.clothingAccessBlocked) {
                        if (!removeEquipBlockedParts.clothingAccessRequired.contains((Object)caBlocked) || abstractClothing.getDisplacedList().contains((Object)bpEquipped.displacementType) || this.isDisplacementAvailableFromElsewhere(characterClothingOwner, abstractClothing, caBlocked)) continue;
                        if (bpEquipped.displacementType == DisplacementType.REMOVE_OR_EQUIP) {
                            if (this.isAbleToUnequip(abstractClothing, false, automaticClothingManagement, characterClothingOwner, characterRemovingClothing, true)) {
                                this.clothingToRemove.put(abstractClothing, DisplacementType.REMOVE_OR_EQUIP);
                                continue;
                            }
                            this.equipTextSB.append((String)(characterClothingOwner.isPlayer() ? "<br/>\u4f60\u7684" + clothing.getName() + "\u65e0\u6cd5\u5378\u4e0b\uff0c\u56e0\u4e3a\u4f60\u7684" + abstractClothing.getName() + "\u6321\u4f4f\u4e86\u3002" : UtilText.parse(characterClothingOwner, "<br/>[npc.NamePos]\u7684" + clothing.getName() + "\u65e0\u6cd5\u5378\u4e0b\uff0c\u56e0\u4e3a[npc.her]\u7684" + abstractClothing.getName() + "\u6321\u4f4f\u4e86\u3002", new ParserTag[0])));
                            this.blockingClothing = abstractClothing;
                            return false;
                        }
                        if (this.clothingToRemove.containsKey(abstractClothing) || abstractClothing.getDisplacedList().contains((Object)bpEquipped.displacementType)) continue;
                        if (automaticClothingManagement) {
                            this.clothingToRemove.put(abstractClothing, bpEquipped.displacementType);
                            continue;
                        }
                        this.equipTextSB.append((String)(characterClothingOwner.isPlayer() ? "\u4f60\u7684<b style='color:" + PresetColour.GENERIC_BAD.toWebHexString() + ";'>" + abstractClothing.getName() + "</b>\u963b\u6b62\u4e86\u4f60\u7684" + clothing.getName() + "\u88ab\u79fb\u9664\uff01" : UtilText.parse(characterClothingOwner, "[npc.NamePos]\u7684<b style='color:" + PresetColour.GENERIC_BAD.toWebHexString() + ";'>" + abstractClothing.getName() + "</b>\u963b\u6b62\u4e86[npc.her]\u7684" + clothing.getName() + "\u88ab\u79fb\u9664\uff01", new ParserTag[0])));
                        this.blockingClothing = abstractClothing;
                        return false;
                    }
                }
            }
        }
        if (continuingIsAbleToEquip && !unequipIfAble) {
            return true;
        }
        if (!automaticClothingManagement && this.clothingToRemove.size() > 1) {
            HashSet<AbstractClothing> blockingClothingSet = new HashSet<AbstractClothing>(this.clothingToRemove.keySet());
            blockingClothingSet.removeIf(c -> c == clothing);
            this.equipTextSB.append((String)(characterClothingOwner.isPlayer() ? "\u5728\u79fb\u9664" + clothing.getName() + "\u4e4b\u524d\uff0c\u4f60\u5fc5\u987b\u5148\u79fb\u9664" + Util.clothesToStringList(blockingClothingSet, false) + "\u3002" : UtilText.parse(characterClothingOwner, "\u5728\u79fb\u9664" + clothing.getName() + "\u4e4b\u524d\uff0c[npc.name]\u5fc5\u987b\u5148\u79fb\u9664" + Util.clothesToStringList(blockingClothingSet, false) + "\u3002", new ParserTag[0])));
            this.blockingClothing = blockingClothingSet.stream().findAny().orElse(this.blockingClothing);
            return false;
        }
        if (unequipIfAble) {
            ArrayList<AbstractClothing> tempClothingList = new ArrayList<AbstractClothing>();
            tempClothingList.addAll(this.clothingToRemove.keySet());
            tempClothingList.sort(new ClothingZLayerComparator());
            tempClothingList.remove(clothing);
            tempClothingList.add(clothing);
            HashMap<AbstractClothing, CallSite> hashMap = new HashMap<AbstractClothing, CallSite>();
            for (Map.Entry<AbstractClothing, DisplacementType> entry : this.clothingToRemove.entrySet()) {
                AbstractClothing c2 = entry.getKey();
                DisplacementType dt = entry.getValue();
                hashMap.put(c2, (CallSite)((Object)((this.equipTextSB.length() == 0 ? "" : "<br/>") + (dt == DisplacementType.REMOVE_OR_EQUIP ? (c2 == clothing ? c2.onUnequipApplyEffects(characterClothingOwner, characterRemovingClothing, Main.game.isInSex() ? Main.sex.getSexPace(characterRemovingClothing) == SexPace.DOM_ROUGH : false) : c2.onUnequipText(characterClothingOwner, characterRemovingClothing, Main.game.isInSex() ? Main.sex.getSexPace(characterRemovingClothing) == SexPace.DOM_ROUGH : false)) : c2.getClothingType().displaceText(characterClothingOwner, characterRemovingClothing, c2.getSlotEquippedTo(), dt, Main.game.isInSex() ? Main.sex.getSexPace(characterRemovingClothing) == SexPace.DOM_ROUGH : false)))));
            }
            for (AbstractClothing abstractClothing : tempClothingList) {
                this.equipTextSB.append((String)hashMap.get(abstractClothing));
            }
            this.clothingCurrentlyEquipped.remove(clothing);
            clothing.setSlotEquippedTo(null);
            clothing.getDisplacedList().clear();
            ArrayList<AbstractClothing> arrayList = new ArrayList<AbstractClothing>();
            arrayList.addAll(this.clothingToRemove.keySet());
            arrayList.remove(clothing);
            arrayList.sort(new ReverseClothingZLayerComparator());
            if (!arrayList.isEmpty() && !continuingIsAbleToEquip) {
                this.equipTextSB.append((String)(characterClothingOwner.isPlayer() ? "<br/>\u4f60\u6062\u590d\u4e86\u4f60\u7684" + Util.clothesToStringList(arrayList, false) + "\u3002" : UtilText.parse(characterClothingOwner, "<br/>\u4f60\u6062\u590d\u4e86[npc.namePos]\u7684" + Util.clothesToStringList(arrayList, false) + "\u3002", new ParserTag[0])));
            }
            if (clothing.getClothingType().getClothingSet() != null) {
                this.clothingSetCount.put(clothing.getClothingType().getClothingSet(), this.clothingSetCount.get(clothing.getClothingType().getClothingSet()) - 1);
            }
            this.clothingCurrentlyEquipped.sort(new ClothingRarityComparator());
        }
        return true;
    }

    public String getDisplaceDescription() {
        return this.unableToDisplaceText.toString();
    }

    public void appendToDisplaceDescription(String textToAppend) {
        this.unableToDisplaceText.append(textToAppend);
    }

    public boolean isAbleToBeDisplaced(AbstractClothing clothing, DisplacementType dt, boolean displaceIfAble, boolean automaticClothingManagement, GameCharacter characterClothingOwner, GameCharacter characterRemovingClothing) {
        return this.isAbleToBeDisplaced(clothing, dt, displaceIfAble, automaticClothingManagement, characterClothingOwner, characterRemovingClothing, false);
    }

    public boolean isAbleToBeDisplaced(AbstractClothing clothing, DisplacementType dt, boolean displaceIfAble, boolean automaticClothingManagement, GameCharacter characterClothingOwner, GameCharacter characterRemovingClothing, boolean continuingIsAbleToEquip) {
        if (!continuingIsAbleToEquip) {
            this.displacementClothingChecked = new HashMap<AbstractClothing, List<AbstractClothing>>();
        }
        this.displacementClothingChecked.putIfAbsent(clothing, new ArrayList());
        if (!displaceIfAble) {
            if (characterClothingOwner == null) {
                characterClothingOwner = Main.game.getPlayer();
            }
            if (characterRemovingClothing == null) {
                characterRemovingClothing = Main.game.getPlayer();
            }
        }
        if (dt == DisplacementType.REMOVE_OR_EQUIP) {
            return this.isAbleToUnequip(clothing, displaceIfAble, automaticClothingManagement, characterClothingOwner, characterRemovingClothing, true);
        }
        if (!continuingIsAbleToEquip) {
            this.clothingToRemove.clear();
            this.equipTextSB.setLength(0);
        }
        boolean displacementTypeFound = false;
        for (BlockedParts blockedParts : clothing.getBlockedPartsMap(characterClothingOwner, clothing.getSlotEquippedTo())) {
            if (blockedParts.displacementType != dt) continue;
            displacementTypeFound = true;
            if (blockedParts.clothingAccessRequired == null) break;
            for (AbstractClothing equippedClothing : this.clothingCurrentlyEquipped) {
                if (this.displacementClothingChecked.get(clothing).contains(equippedClothing)) continue;
                this.displacementClothingChecked.get(clothing).add(equippedClothing);
                if (equippedClothing == clothing) continue;
                for (BlockedParts bpEquipped : equippedClothing.getBlockedPartsMap(characterClothingOwner, equippedClothing.getSlotEquippedTo())) {
                    for (ClothingAccess caBlocked : bpEquipped.clothingAccessBlocked) {
                        if (!blockedParts.clothingAccessRequired.contains((Object)caBlocked) || !(automaticClothingManagement ? this.isAbleToBeDisplaced(equippedClothing, bpEquipped.displacementType, false, true, characterClothingOwner, characterRemovingClothing, true) : !equippedClothing.getDisplacedList().contains((Object)bpEquipped.displacementType)) || this.isDisplacementAvailableFromElsewhere(characterClothingOwner, equippedClothing, caBlocked)) continue;
                        if (bpEquipped.displacementType != DisplacementType.REMOVE_OR_EQUIP) {
                            if (equippedClothing.getDisplacedList().contains((Object)bpEquipped.displacementType)) continue;
                            if (automaticClothingManagement) {
                                this.clothingToRemove.put(equippedClothing, bpEquipped.displacementType);
                                continue;
                            }
                            this.unableToDisplaceText = new StringBuilder(Util.capitaliseSentence(clothing.getClothingType().getDeterminer()) + clothing.getName() + "\u65e0\u6cd5\u88ab\u79fb\u5f00\uff0c\u56e0\u4e3a" + equippedClothing.getClothingType().getDeterminer() + equippedClothing.getName() + "\u6321\u4f4f\u4e86\u3002");
                            this.blockingClothing = equippedClothing;
                            return false;
                        }
                        if (automaticClothingManagement && this.isAbleToUnequip(equippedClothing, false, automaticClothingManagement, characterClothingOwner, characterRemovingClothing, true)) {
                            this.clothingToRemove.put(equippedClothing, DisplacementType.REMOVE_OR_EQUIP);
                            continue;
                        }
                        this.unableToDisplaceText = new StringBuilder(Util.capitaliseSentence(clothing.getClothingType().getDeterminer()) + clothing.getName() + "\u65e0\u6cd5\u88ab\u79fb\u5f00\uff0c\u56e0\u4e3a" + equippedClothing.getClothingType().getDeterminer() + equippedClothing.getName() + "\u6321\u4f4f\u4e86\u3002");
                        this.blockingClothing = equippedClothing;
                        return false;
                    }
                }
            }
        }
        if (!displacementTypeFound) {
            new IllegalArgumentException("The supplied clothing (" + clothing.getClothingType().getId() + ") cannot be displaced in this manner (" + dt.getDescription() + ")!").printStackTrace();
            return false;
        }
        if (displaceIfAble) {
            if (clothing.getDisplacedList().contains((Object)dt)) {
                this.unableToDisplaceText = new StringBuilder(Util.capitaliseSentence(clothing.getClothingType().getDeterminer()) + clothing.getName() + "\u5df2\u7ecf\u88ab\u79fb\u5f00\u4e86\uff01");
                return false;
            }
            clothing.getDisplacedList().add(dt);
            ArrayList<AbstractClothing> tempClothingList = new ArrayList<AbstractClothing>();
            tempClothingList.addAll(this.clothingToRemove.keySet());
            tempClothingList.sort(new ClothingZLayerComparator());
            this.unableToDisplaceText = new StringBuilder();
            for (AbstractClothing c : tempClothingList) {
                this.unableToDisplaceText.append((this.unableToDisplaceText.length() == 0 ? "" : "<br/>") + (this.clothingToRemove.get(c) == DisplacementType.REMOVE_OR_EQUIP ? c.onUnequipText(characterClothingOwner, characterRemovingClothing, Main.game.isInSex() ? Main.sex.getSexPace(characterRemovingClothing) == SexPace.DOM_ROUGH : false) : c.getClothingType().displaceText(characterClothingOwner, characterRemovingClothing, c.getSlotEquippedTo(), this.clothingToRemove.get(c), Main.game.isInSex() ? Main.sex.getSexPace(characterRemovingClothing) == SexPace.DOM_ROUGH : false)));
            }
            this.unableToDisplaceText.append((String)(this.unableToDisplaceText.length() == 0 ? "" : "<br/><span style='color:" + PresetColour.GENERIC_ARCANE.toWebHexString() + ";'>") + clothing.getClothingType().displaceText(characterClothingOwner, characterRemovingClothing, clothing.getSlotEquippedTo(), dt, Main.game.isInSex() ? Main.sex.getSexPace(characterRemovingClothing) == SexPace.DOM_ROUGH : false) + "</span>");
            ArrayList<AbstractClothing> arrayList = new ArrayList<AbstractClothing>();
            arrayList.addAll(this.clothingToRemove.keySet());
            arrayList.remove(clothing);
            arrayList.sort(new ReverseClothingZLayerComparator());
            if (!arrayList.isEmpty()) {
                this.unableToDisplaceText.append(UtilText.parse(characterClothingOwner, "<br/>\u4f60\u6062\u590d\u4e86[npc.namePos]\u7684", new ParserTag[0]) + Util.clothesToStringList(arrayList, false) + "\u3002");
            }
            return true;
        }
        this.unableToDisplaceText = new StringBuilder(Util.capitaliseSentence(clothing.getClothingType().getDeterminer()) + clothing.getName() + "\u53ef\u4ee5\u88ab\u79fb\u5f00\u3002");
        return true;
    }

    public String getReplaceDescription() {
        return this.unableToReplaceText.toString();
    }

    public boolean isAbleToBeReplaced(AbstractClothing clothing, DisplacementType dt, boolean replaceIfAble, boolean automaticClothingManagement, GameCharacter characterClothingOwner, GameCharacter characterRemovingClothing) {
        if (dt == DisplacementType.REMOVE_OR_EQUIP) {
            throw new IllegalArgumentException("Can't replace DisplacementType.REMOVE_OR_EQUIP!");
        }
        if (automaticClothingManagement) {
            this.clothingToRemove.clear();
        }
        boolean displacementTypeFound = false;
        for (BlockedParts blockedParts : clothing.getBlockedPartsMap(characterClothingOwner, clothing.getSlotEquippedTo())) {
            if (blockedParts.displacementType != dt) continue;
            displacementTypeFound = true;
            if (blockedParts.clothingAccessRequired == null) break;
            for (AbstractClothing equippedClothing : this.clothingCurrentlyEquipped) {
                for (BlockedParts bpEquipped : equippedClothing.getBlockedPartsMap(characterClothingOwner, equippedClothing.getSlotEquippedTo())) {
                    for (ClothingAccess caBlocked : bpEquipped.clothingAccessBlocked) {
                        if (!blockedParts.clothingAccessRequired.contains((Object)caBlocked) || equippedClothing.getDisplacedList().contains((Object)bpEquipped.displacementType) || this.isDisplacementAvailableFromElsewhere(characterClothingOwner, equippedClothing, caBlocked)) continue;
                        if (bpEquipped.displacementType != DisplacementType.REMOVE_OR_EQUIP && !this.clothingToRemove.containsKey(equippedClothing)) {
                            if (equippedClothing.getDisplacedList().contains((Object)bpEquipped.displacementType)) continue;
                            if (automaticClothingManagement) {
                                this.clothingToRemove.put(equippedClothing, bpEquipped.displacementType);
                                continue;
                            }
                            this.unableToReplaceText = new StringBuilder(Util.capitaliseSentence(clothing.getClothingType().getDeterminer()) + clothing.getName() + "\u65e0\u6cd5\u6062\u590d\uff0c\u56e0\u4e3a" + equippedClothing.getClothingType().getDeterminer() + equippedClothing.getName() + "\u6321\u4f4f\u4e86\u3002");
                            this.blockingClothing = equippedClothing;
                            return false;
                        }
                        if (this.isAbleToUnequip(equippedClothing, false, automaticClothingManagement, characterClothingOwner, characterRemovingClothing, true)) {
                            this.clothingToRemove.put(equippedClothing, DisplacementType.REMOVE_OR_EQUIP);
                            continue;
                        }
                        this.unableToReplaceText = new StringBuilder(Util.capitaliseSentence(clothing.getClothingType().getDeterminer()) + clothing.getName() + "\u65e0\u6cd5\u6062\u590d\uff0c\u56e0\u4e3a" + equippedClothing.getClothingType().getDeterminer() + equippedClothing.getName() + "\u6321\u4f4f\u4e86\u3002");
                        this.blockingClothing = equippedClothing;
                        return false;
                    }
                }
            }
        }
        if (!displacementTypeFound) {
            throw new IllegalArgumentException("The supplied clothing cannot be replaced in this manner!");
        }
        if (replaceIfAble) {
            if (!clothing.getDisplacedList().contains((Object)dt)) {
                this.unableToReplaceText = new StringBuilder(Util.capitaliseSentence(clothing.getClothingType().getDeterminer()) + clothing.getName() + "\u5df2\u7ecf\u6062\u590d\u4e86\uff01");
                return false;
            }
            clothing.getDisplacedList().remove((Object)dt);
            ArrayList<AbstractClothing> tempClothingList = new ArrayList<AbstractClothing>();
            tempClothingList.addAll(this.clothingToRemove.keySet());
            tempClothingList.sort(new ClothingZLayerComparator());
            this.unableToReplaceText = new StringBuilder();
            for (AbstractClothing c : tempClothingList) {
                this.unableToReplaceText.append((this.unableToReplaceText.length() == 0 ? "" : "<br/>") + (this.clothingToRemove.get(c) == DisplacementType.REMOVE_OR_EQUIP ? (c == clothing ? c.onUnequipApplyEffects(characterClothingOwner, characterRemovingClothing, Main.game.isInSex() ? Main.sex.getSexPace(characterRemovingClothing) == SexPace.DOM_ROUGH : false) : c.onUnequipText(characterClothingOwner, characterRemovingClothing, Main.game.isInSex() ? Main.sex.getSexPace(characterRemovingClothing) == SexPace.DOM_ROUGH : false)) : c.getClothingType().displaceText(characterClothingOwner, characterRemovingClothing, c.getSlotEquippedTo(), this.clothingToRemove.get(c), Main.game.isInSex() ? Main.sex.getSexPace(characterRemovingClothing) == SexPace.DOM_ROUGH : false)));
            }
            this.unableToReplaceText.append((String)(this.unableToReplaceText.length() == 0 ? "" : "<br/><span style='color:" + PresetColour.GENERIC_GOOD.toWebHexString() + ";'>") + clothing.getClothingType().replaceText(characterClothingOwner, characterRemovingClothing, clothing.getSlotEquippedTo(), dt, Main.game.isInSex() ? Main.sex.getSexPace(characterRemovingClothing) == SexPace.DOM_ROUGH : false) + "</span>");
            ArrayList<AbstractClothing> arrayList = new ArrayList<AbstractClothing>();
            arrayList.addAll(this.clothingToRemove.keySet());
            arrayList.sort(new ReverseClothingZLayerComparator());
            if (!arrayList.isEmpty()) {
                this.unableToReplaceText.append(UtilText.parse(characterClothingOwner, "<br/>\u4f60\u6062\u590d\u4e86[npc.namePos]\u7684", new ParserTag[0]) + Util.clothesToStringList(arrayList, false) + "\u3002");
            }
            return true;
        }
        this.unableToReplaceText = new StringBuilder(Util.capitaliseSentence(clothing.getClothingType().getDeterminer()) + clothing.getName() + "\u53ef\u4ee5\u6062\u590d\u539f\u72b6\u3002");
        return true;
    }

    private boolean isDisplacementAvailableFromElsewhere(GameCharacter character, AbstractClothing clothing, ClothingAccess accessRequired) {
        for (BlockedParts bp : clothing.getBlockedPartsMap(character, clothing.getSlotEquippedTo())) {
            if (!bp.clothingAccessBlocked.contains((Object)accessRequired) || !clothing.getDisplacedList().contains((Object)bp.displacementType)) continue;
            return true;
        }
        return false;
    }

    public boolean isAbleToAccessCoverableArea(GameCharacter character, CoverableArea area, boolean byRemovingClothing) {
        return this.getClothingBlockingCoverableAreaAccess(character, area, byRemovingClothing) == null;
    }

    public AbstractClothing getClothingBlockingCoverableAreaAccess(GameCharacter character, CoverableArea area, boolean byRemovingClothing) {
        List<AbstractClothing> blockingClothingList = this.getBlockingCoverableAreaClothingList(character, area, byRemovingClothing);
        if (!blockingClothingList.isEmpty()) {
            for (AbstractClothing c : blockingClothingList) {
                if (!c.isSealed()) continue;
                return c;
            }
            return blockingClothingList.get(0);
        }
        return null;
    }

    public List<AbstractClothing> getBlockingCoverableAreaClothingList(GameCharacter character, CoverableArea area, boolean byRemovingClothing) {
        ArrayList<AbstractClothing> blockingClothingList = new ArrayList<AbstractClothing>();
        for (AbstractClothing clothing : this.clothingCurrentlyEquipped) {
            List<BlockedParts> blockedPartsMap = clothing.getBlockedPartsMap(character, clothing.getSlotEquippedTo());
            if (blockedPartsMap == null) {
                System.err.println("Clothing error in getBlockingCoverableAreaClothingList(): blockedPartsMap is returning null!");
                System.err.println(clothing.getName() + " | " + clothing.getClothingType().getId() + " (" + String.valueOf((Object)clothing.getSlotEquippedTo()) + ")");
                new IllegalArgumentException().printStackTrace();
                continue;
            }
            for (BlockedParts bp : blockedPartsMap) {
                if (!bp.blockedBodyParts.contains((Object)area) || clothing.getDisplacedList().contains((Object)bp.displacementType)) continue;
                if (byRemovingClothing) {
                    if (bp.displacementType == DisplacementType.REMOVE_OR_EQUIP) {
                        if (this.isAbleToUnequip(clothing, false, byRemovingClothing, null, null) || this.isCoverableAreaExposedFromElsewhere(character, clothing, area)) continue;
                        blockingClothingList.add(clothing);
                        continue;
                    }
                    if (this.isAbleToBeDisplaced(clothing, bp.displacementType, false, byRemovingClothing, null, null) || this.isCoverableAreaExposedFromElsewhere(character, clothing, area)) continue;
                    blockingClothingList.add(clothing);
                    continue;
                }
                if (this.isCoverableAreaExposedFromElsewhere(character, clothing, area)) continue;
                blockingClothingList.add(clothing);
            }
        }
        return blockingClothingList;
    }

    private boolean isCoverableAreaExposedFromElsewhere(GameCharacter character, AbstractClothing clothing, CoverableArea area) {
        for (BlockedParts bp : clothing.getBlockedPartsMap(character, clothing.getSlotEquippedTo())) {
            if (!bp.blockedBodyParts.contains((Object)area) || !clothing.getDisplacedList().contains((Object)bp.displacementType)) continue;
            return true;
        }
        return false;
    }

    public AbstractMap.SimpleEntry<AbstractClothing, DisplacementType> getNextClothingToRemoveForCoverableAreaAccess(GameCharacter character, CoverableArea coverableArea) {
        ArrayList<AbstractClothing> zLayerSortedList = new ArrayList<AbstractClothing>(this.clothingCurrentlyEquipped);
        zLayerSortedList.sort(new ClothingZLayerComparator());
        for (AbstractClothing clothing : zLayerSortedList) {
            for (BlockedParts bp : clothing.getBlockedPartsMap(character, clothing.getSlotEquippedTo())) {
                if (!bp.blockedBodyParts.contains((Object)coverableArea) || clothing.getDisplacedList().contains((Object)bp.displacementType) || this.isCoverableAreaExposedFromElsewhere(character, clothing, coverableArea)) continue;
                return this.findNextClothingDisplacement(character, coverableArea, clothing, bp.displacementType, zLayerSortedList, true);
            }
        }
        return null;
    }

    public AbstractMap.SimpleEntry<AbstractClothing, DisplacementType> findNextClothingDisplacement(GameCharacter character, CoverableArea coverableArea, AbstractClothing clothingToRemove, DisplacementType displacement, List<AbstractClothing> zLayerSortedList, boolean initialMethodCall) {
        if (initialMethodCall) {
            this.previousDisplacements = new HashMap<AbstractClothing, DisplacementType>();
            this.previousDisplacements.put(clothingToRemove, displacement);
        }
        for (BlockedParts bp : clothingToRemove.getBlockedPartsMap(character, clothingToRemove.getSlotEquippedTo())) {
            if (bp.displacementType != displacement) continue;
            for (ClothingAccess ca : bp.clothingAccessRequired) {
                for (AbstractClothing clothing : zLayerSortedList) {
                    if (clothing == clothingToRemove) continue;
                    for (BlockedParts bpIterated : clothing.getBlockedPartsMap(character, clothing.getSlotEquippedTo())) {
                        if (!bpIterated.clothingAccessBlocked.contains((Object)ca) || clothing.getDisplacedList().contains((Object)bpIterated.displacementType) || bp.displacementType != DisplacementType.REMOVE_OR_EQUIP && this.isCoverableAreaExposedFromElsewhere(character, clothing, coverableArea)) continue;
                        if (this.previousDisplacements.containsKey(clothing) && this.previousDisplacements.get(clothing).equals((Object)bpIterated.displacementType)) {
                            System.err.println("findNextClothingDisplacement() error: " + clothing.getName() + " is interfering with " + clothingToRemove.getName());
                            return new AbstractMap.SimpleEntry<AbstractClothing, DisplacementType>(clothing, bpIterated.displacementType);
                        }
                        this.previousDisplacements.put(clothing, bpIterated.displacementType);
                        return this.findNextClothingDisplacement(character, coverableArea, clothing, bpIterated.displacementType, zLayerSortedList, false);
                    }
                }
            }
        }
        return new AbstractMap.SimpleEntry<AbstractClothing, DisplacementType>(clothingToRemove, displacement);
    }

    public boolean isCoverableAreaExposed(GameCharacter character, CoverableArea area, boolean justVisible) {
        if (area == CoverableArea.TESTICLES) {
            return this.isCoverableAreaExposed(character, CoverableArea.PENIS, justVisible);
        }
        if (area == CoverableArea.ANUS && character.getGenitalArrangement() == GenitalArrangement.CLOACA) {
            return this.isCoverableAreaExposed(character, CoverableArea.VAGINA, justVisible);
        }
        if (this.getExtraBlockedParts() != null && justVisible && this.getExtraBlockedParts().blockedBodyParts.contains((Object)area)) {
            return false;
        }
        if (area == CoverableArea.BREASTS_CROTCH || area == CoverableArea.NIPPLES_CROTCH) {
            switch (character.getLegConfiguration()) {
                case ARACHNID: 
                case BIPEDAL: 
                case CEPHALOPOD: 
                case TAIL: 
                case TAIL_LONG: 
                case AVIAN: 
                case WINGED_BIPED: {
                    return this.isCoverableAreaExposed(character, CoverableArea.STOMACH, justVisible);
                }
                case QUADRUPEDAL: {
                    List<AbstractClothing> clothingBlocking = this.getBlockingCoverableAreaClothingList(character, CoverableArea.THIGHS, false);
                    clothingBlocking.removeIf(c -> !c.getItemTags().contains((Object)ItemTag.FITS_TAUR_BODY) || c.getItemTags().contains((Object)ItemTag.TRANSPARENT));
                    return clothingBlocking.isEmpty();
                }
            }
        }
        if (justVisible) {
            List<AbstractClothing> clothingBlocking = this.getBlockingCoverableAreaClothingList(character, area, false);
            clothingBlocking.removeIf(c -> c.getItemTags().contains((Object)ItemTag.TRANSPARENT));
            return clothingBlocking.isEmpty();
        }
        return this.isAbleToAccessCoverableArea(character, area, false);
    }

    public int getClothingAverageFemininity() {
        if (this.clothingCurrentlyEquipped.isEmpty()) {
            return 50;
        }
        int average = 50;
        for (AbstractClothing c : this.clothingCurrentlyEquipped) {
            if (c.getClothingType().getFemininityRestriction() == Femininity.FEMININE) {
                average += 75;
                continue;
            }
            if (c.getClothingType().getFemininityRestriction() == Femininity.MASCULINE) {
                average += 25;
                continue;
            }
            average += 50;
        }
        return average /= this.clothingCurrentlyEquipped.size() + 1;
    }

    public AbstractClothing getLowestZLayerCoverableArea(GameCharacter character, CoverableArea area) {
        AbstractClothing c = null;
        List<AbstractClothing> clothingBlocking = null;
        if (area == CoverableArea.BREASTS_CROTCH || area == CoverableArea.NIPPLES_CROTCH) {
            switch (character.getLegConfiguration()) {
                case ARACHNID: 
                case BIPEDAL: 
                case CEPHALOPOD: 
                case TAIL: 
                case TAIL_LONG: 
                case AVIAN: 
                case WINGED_BIPED: {
                    clothingBlocking = this.getBlockingCoverableAreaClothingList(character, CoverableArea.STOMACH, false);
                    break;
                }
                case QUADRUPEDAL: {
                    clothingBlocking = this.getBlockingCoverableAreaClothingList(character, CoverableArea.THIGHS, false);
                    clothingBlocking.removeIf(clothing -> !clothing.getItemTags().contains((Object)ItemTag.FITS_TAUR_BODY) || clothing.getItemTags().contains((Object)ItemTag.TRANSPARENT));
                }
            }
        } else {
            clothingBlocking = this.getBlockingCoverableAreaClothingList(character, area, false);
        }
        for (AbstractClothing clothing2 : clothingBlocking) {
            if (c != null && clothing2.getSlotEquippedTo().getZLayer() >= c.getSlotEquippedTo().getZLayer()) continue;
            c = clothing2;
        }
        return c;
    }

    public AbstractClothing getHighestZLayerCoverableArea(GameCharacter character, CoverableArea area) {
        AbstractClothing c = null;
        List<AbstractClothing> clothingBlocking = null;
        if (area == CoverableArea.BREASTS_CROTCH || area == CoverableArea.NIPPLES_CROTCH) {
            switch (character.getLegConfiguration()) {
                case ARACHNID: 
                case BIPEDAL: 
                case CEPHALOPOD: 
                case TAIL: 
                case TAIL_LONG: 
                case AVIAN: 
                case WINGED_BIPED: {
                    clothingBlocking = this.getBlockingCoverableAreaClothingList(character, CoverableArea.STOMACH, false);
                    break;
                }
                case QUADRUPEDAL: {
                    clothingBlocking = this.getBlockingCoverableAreaClothingList(character, CoverableArea.THIGHS, false);
                    clothingBlocking.removeIf(clothing -> !clothing.getItemTags().contains((Object)ItemTag.FITS_TAUR_BODY) || clothing.getItemTags().contains((Object)ItemTag.TRANSPARENT));
                }
            }
        } else {
            clothingBlocking = this.getBlockingCoverableAreaClothingList(character, area, false);
        }
        for (AbstractClothing clothing2 : clothingBlocking) {
            if (c != null && clothing2.getSlotEquippedTo().getZLayer() <= c.getSlotEquippedTo().getZLayer()) continue;
            c = clothing2;
        }
        return c;
    }

    public AbstractClothing getBlockingClothing() {
        return this.blockingClothing;
    }

    public boolean isSlotIncompatible(GameCharacter clothingOwner, InventorySlot slot) {
        for (AbstractClothing ct : this.clothingCurrentlyEquipped) {
            for (InventorySlot incompatibleSlot : ct.getIncompatibleSlots(clothingOwner, ct.getSlotEquippedTo())) {
                if (incompatibleSlot != slot) continue;
                return true;
            }
        }
        return false;
    }

    public Set<InventorySlot> getDirtySlots() {
        return this.dirtySlots;
    }

    public boolean isDirtySlot(InventorySlot slot) {
        return this.dirtySlots.contains((Object)slot);
    }

    public boolean addDirtySlot(InventorySlot slot) {
        return this.dirtySlots.add(slot);
    }

    public boolean removeDirtySlot(InventorySlot slot) {
        return this.dirtySlots.remove((Object)slot);
    }

    public void cleanAllDirtySlots() {
        this.dirtySlots.clear();
    }
}

