/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.inventory.clothing;

import com.lilithsthrone.controller.xmlParsing.Element;
import com.lilithsthrone.controller.xmlParsing.XMLLoadException;
import com.lilithsthrone.controller.xmlParsing.XMLMissingTagException;
import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.body.CoverableArea;
import com.lilithsthrone.game.character.body.valueEnums.Femininity;
import com.lilithsthrone.game.character.body.valueEnums.OrificeModifier;
import com.lilithsthrone.game.character.body.valueEnums.PenetrationModifier;
import com.lilithsthrone.game.character.npc.NPC;
import com.lilithsthrone.game.dialogue.utils.InventoryDialogue;
import com.lilithsthrone.game.dialogue.utils.ParserTag;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.game.inventory.AbstractCoreType;
import com.lilithsthrone.game.inventory.AbstractSetBonus;
import com.lilithsthrone.game.inventory.ColourReplacement;
import com.lilithsthrone.game.inventory.InventorySlot;
import com.lilithsthrone.game.inventory.ItemTag;
import com.lilithsthrone.game.inventory.Rarity;
import com.lilithsthrone.game.inventory.SetBonus;
import com.lilithsthrone.game.inventory.clothing.AbstractClothing;
import com.lilithsthrone.game.inventory.clothing.BlockedParts;
import com.lilithsthrone.game.inventory.clothing.ClothingAccess;
import com.lilithsthrone.game.inventory.clothing.ClothingType;
import com.lilithsthrone.game.inventory.clothing.DisplacementDescriptionType;
import com.lilithsthrone.game.inventory.clothing.DisplacementType;
import com.lilithsthrone.game.inventory.clothing.Sticker;
import com.lilithsthrone.game.inventory.clothing.StickerCategory;
import com.lilithsthrone.game.inventory.enchanting.AbstractItemEffectType;
import com.lilithsthrone.game.inventory.enchanting.ItemEffect;
import com.lilithsthrone.game.inventory.enchanting.ItemEffectType;
import com.lilithsthrone.game.inventory.item.AbstractItem;
import com.lilithsthrone.game.inventory.item.ItemType;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.rendering.Pattern;
import com.lilithsthrone.rendering.SVGImages;
import com.lilithsthrone.utils.SvgUtil;
import com.lilithsthrone.utils.Util;
import com.lilithsthrone.utils.colours.Colour;
import com.lilithsthrone.utils.colours.ColourListPresets;
import com.lilithsthrone.utils.colours.PresetColour;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public abstract class AbstractClothingType
extends AbstractCoreType {
    public static final Colour DEFAULT_COLOUR_VALUE = PresetColour.CLOTHING_BLACK;
    private String determiner;
    private String name;
    private String namePlural;
    private String description;
    private String pathNamePrefix;
    private String pathName;
    private Map<InventorySlot, String> pathNameEquipped;
    private String authorDescription;
    private boolean appendColourName;
    private boolean appendEnchantmentPostfix;
    private boolean plural;
    private boolean isMod;
    private boolean isColourDerivedFromPattern;
    private int baseValue;
    private float physicalResistance;
    private int femininityMinimum;
    private int femininityMaximum;
    private Femininity femininityRestriction;
    private List<InventorySlot> equipSlots;
    private int penetrationSelfLength;
    private int penetrationSelfGirth;
    private Set<PenetrationModifier> penetrationSelfModifiers;
    private int penetrationOtherLength;
    private int penetrationOtherGirth;
    private Set<PenetrationModifier> penetrationOtherModifiers;
    private int orificeSelfLabiaSize;
    private int orificeSelfClitSize;
    private int orificeSelfClitGirth;
    private int orificeSelfDepth;
    private float orificeSelfCapacity;
    private int orificeSelfElasticity;
    private int orificeSelfPlasticity;
    private int orificeSelfWetness;
    private Set<OrificeModifier> orificeSelfModifiers;
    private int orificeOtherLabiaSize;
    private int orificeOtherClitSize;
    private int orificeOtherClitGirth;
    private int orificeOtherDepth;
    private float orificeOtherCapacity;
    private int orificeOtherElasticity;
    private int orificeOtherPlasticity;
    private int orificeOtherWetness;
    private Set<OrificeModifier> orificeOtherModifiers;
    protected List<ItemEffect> effects;
    private Map<String, String> SVGStringMap;
    private Map<String, String> SVGStringEquippedMap;
    private boolean isPatternAvailable;
    private boolean isPatternAvailableInitCompleted;
    private Map<StickerCategory, List<Sticker>> stickers;
    protected Map<InventorySlot, List<BlockedParts>> blockedPartsMap;
    protected Map<InventorySlot, List<InventorySlot>> incompatibleSlotsMap;
    protected Map<InventorySlot, List<DisplacementType>> displacementTypesAvailableWithoutNONE;
    private AbstractSetBonus clothingSet;
    private Rarity rarity;
    private List<ColourReplacement> colourReplacements;
    public Map<Integer, Integer> copyGenerationColours;
    private float patternChance;
    private List<Pattern> defaultPatterns;
    private List<ColourReplacement> patternColourReplacements;
    private Map<InventorySlot, List<ItemTag>> itemTags;
    private Map<InventorySlot, Map<DisplacementType, Map<DisplacementDescriptionType, String>>> displacementDescriptions;
    static Map<AbstractSetBonus, List<AbstractClothingType>> clothingSetMap = new HashMap<AbstractSetBonus, List<AbstractClothingType>>();

    protected AbstractClothingType(int baseValue, String determiner, boolean plural, String name, String namePlural, String description, float physicalResistance, Femininity femininityRestriction, InventorySlot equipSlot, Rarity rarity, AbstractSetBonus clothingSet, String pathName, List<ItemEffect> effects, List<BlockedParts> blockedPartsList, List<InventorySlot> incompatibleSlotsList, List<Colour> availablePrimaryColours, List<Colour> availablePrimaryDyeColours, List<Colour> availableSecondaryColours, List<Colour> availableSecondaryDyeColours, List<Colour> availableTertiaryColours, List<Colour> availableTertiaryDyeColours, List<ItemTag> itemTags) {
        this(baseValue, determiner, plural, name, namePlural, description, physicalResistance, femininityRestriction, Util.newArrayListOfValues(equipSlot), rarity, clothingSet, pathName, null, effects, Util.newHashMapOfValues(new Util.Value<InventorySlot, ArrayList>(equipSlot, blockedPartsList == null ? new ArrayList() : blockedPartsList)), Util.newHashMapOfValues(new Util.Value<InventorySlot, ArrayList>(equipSlot, incompatibleSlotsList == null ? new ArrayList() : incompatibleSlotsList)), availablePrimaryColours, availablePrimaryDyeColours, availableSecondaryColours, availableSecondaryDyeColours, availableTertiaryColours, availableTertiaryDyeColours, Util.newHashMapOfValues(new Util.Value<InventorySlot, ArrayList>(equipSlot, itemTags == null ? new ArrayList() : itemTags)));
    }

    public AbstractClothingType(int baseValue, String determiner, boolean plural, String name, String namePlural, String description, float physicalResistance, Femininity femininityRestriction, List<InventorySlot> equipSlots, Rarity rarity, AbstractSetBonus clothingSet, String pathName, Map<InventorySlot, String> pathNameEquipped, List<ItemEffect> effects, Map<InventorySlot, List<BlockedParts>> blockedPartsMap, Map<InventorySlot, List<InventorySlot>> incompatibleSlotsMap, List<Colour> availablePrimaryColours, List<Colour> availablePrimaryDyeColours, List<Colour> availableSecondaryColours, List<Colour> availableSecondaryDyeColours, List<Colour> availableTertiaryColours, List<Colour> availableTertiaryDyeColours, Map<InventorySlot, List<ItemTag>> itemTags) {
        this.baseValue = baseValue;
        this.isMod = false;
        this.isColourDerivedFromPattern = false;
        this.appendColourName = true;
        this.appendEnchantmentPostfix = true;
        this.determiner = determiner;
        this.plural = plural;
        this.name = name;
        this.namePlural = namePlural;
        this.description = description;
        this.physicalResistance = physicalResistance;
        this.setUpFemininity(femininityRestriction);
        this.femininityRestriction = femininityRestriction;
        this.equipSlots = equipSlots;
        this.rarity = rarity;
        this.clothingSet = clothingSet;
        this.pathName = pathName;
        this.pathNameEquipped = pathNameEquipped;
        this.isPatternAvailable = false;
        this.isPatternAvailableInitCompleted = false;
        this.effects = effects != null ? new ArrayList<ItemEffect>(effects) : new ArrayList<ItemEffect>();
        if (blockedPartsMap != null) {
            this.blockedPartsMap = blockedPartsMap;
        } else {
            this.blockedPartsMap = new HashMap<InventorySlot, List<BlockedParts>>();
            for (InventorySlot inventorySlot : equipSlots) {
                this.blockedPartsMap.put(inventorySlot, new ArrayList());
            }
        }
        for (Map.Entry entry : this.blockedPartsMap.entrySet()) {
            for (BlockedParts bp : (List)entry.getValue()) {
                bp.concealedSlots.removeIf(concealedSlot -> concealedSlot == entry.getKey());
            }
        }
        if (incompatibleSlotsMap != null) {
            this.incompatibleSlotsMap = incompatibleSlotsMap;
        } else {
            this.incompatibleSlotsMap = new HashMap<InventorySlot, List<InventorySlot>>();
            for (InventorySlot inventorySlot : equipSlots) {
                this.incompatibleSlotsMap.put(inventorySlot, new ArrayList());
            }
        }
        this.copyGenerationColours = new HashMap<Integer, Integer>();
        this.setUpColours(true, availablePrimaryColours, availablePrimaryDyeColours, true, availableSecondaryColours, availableSecondaryDyeColours, true, availableTertiaryColours, availableTertiaryDyeColours);
        this.patternChance = 0.0f;
        this.defaultPatterns = new ArrayList<Pattern>(Pattern.getAllDefaultPatterns());
        this.setUpPatternColours(null, null, null, null, null, null);
        this.populateEmptyPatternColours();
        this.stickers = new HashMap<StickerCategory, List<Sticker>>();
        this.itemTags = new HashMap<InventorySlot, List<ItemTag>>();
        if (itemTags != null) {
            this.itemTags = itemTags;
        } else {
            for (InventorySlot inventorySlot : this.equipSlots) {
                this.itemTags.put(inventorySlot, new ArrayList());
            }
        }
        this.authorDescription = "";
        this.finalSetUp();
    }

    /*
     * WARNING - void declaration
     */
    public AbstractClothingType(File clothingXMLFile, String author) throws XMLLoadException {
        boolean debug = false;
        try {
            Object relatedSlot;
            Element clothingElement = Element.getDocumentRootElement(clothingXMLFile);
            Element coreAttributes = null;
            try {
                coreAttributes = clothingElement.getMandatoryFirstOf("coreAtributes");
            }
            catch (XMLMissingTagException ex) {
                coreAttributes = clothingElement.getMandatoryFirstOf("coreAttributes");
            }
            if (debug) {
                System.out.println("1");
            }
            this.isMod = true;
            this.name = coreAttributes.getMandatoryFirstOf("name").getTextContent();
            this.namePlural = coreAttributes.getMandatoryFirstOf("namePlural").getTextContent();
            this.description = coreAttributes.getMandatoryFirstOf("description").getTextContent();
            this.determiner = coreAttributes.getMandatoryFirstOf("determiner").getTextContent();
            if (debug) {
                System.out.println("2");
            }
            this.appendColourName = !coreAttributes.getMandatoryFirstOf("name").getAttribute("appendColourName").isEmpty() ? Boolean.valueOf(coreAttributes.getMandatoryFirstOf("name").getAttribute("appendColourName")) : true;
            this.appendEnchantmentPostfix = !coreAttributes.getMandatoryFirstOf("name").getAttribute("appendEnchantmentPostfix").isEmpty() ? Boolean.valueOf(coreAttributes.getMandatoryFirstOf("name").getAttribute("appendEnchantmentPostfix")) : true;
            this.plural = Boolean.valueOf(coreAttributes.getMandatoryFirstOf("namePlural").getAttribute("pluralByDefault"));
            this.baseValue = Integer.valueOf(coreAttributes.getMandatoryFirstOf("value").getTextContent());
            this.physicalResistance = Float.valueOf(coreAttributes.getMandatoryFirstOf("physicalResistance").getTextContent()).floatValue();
            this.rarity = Rarity.valueOf(coreAttributes.getMandatoryFirstOf("rarity").getTextContent());
            try {
                this.equipSlots = coreAttributes.getMandatoryFirstOf("equipSlots").getAllOf("slot").stream().map(e -> InventorySlot.valueOf(e.getTextContent())).collect(Collectors.toList());
            }
            catch (Exception ex) {
                InventorySlot slot = InventorySlot.valueOf(coreAttributes.getMandatoryFirstOf("slot").getTextContent());
                this.equipSlots = Util.newArrayListOfValues(slot);
            }
            this.authorDescription = coreAttributes.getOptionalFirstOf("clothingAuthorTag").isPresent() ? coreAttributes.getMandatoryFirstOf("clothingAuthorTag").getTextContent() : (coreAttributes.getOptionalFirstOf("authorTag").isPresent() ? coreAttributes.getMandatoryFirstOf("authorTag").getTextContent() : (!author.equalsIgnoreCase("innoxia") ? "\u4e00\u5f20\u4ed4\u7ec6\u8d34\u5728" + (this.plural ? this.namePlural : this.name) + "\u4e0a\u7684\u6807\u7b7e\u544a\u8bc9\u4f60" + (this.plural ? "\u5b83\u662f" : "\u5b83\u662f") + "\u7531'" + Util.capitaliseSentence(author) + "'\u5236\u4f5c\u7684\u3002" : ""));
            this.femininityRestriction = Femininity.valueOf(coreAttributes.getMandatoryFirstOf("femininity").getTextContent());
            this.setUpFemininity(this.femininityRestriction);
            if (debug) {
                System.out.println("3");
            }
            this.effects = coreAttributes.getMandatoryFirstOf("effects").getAllOf("effect").stream().map(e -> ItemEffect.loadFromXML(e.getInnerElement(), e.getDocument())).filter(Objects::nonNull).collect(Collectors.toList());
            try {
                this.blockedPartsMap = new HashMap<InventorySlot, List<BlockedParts>>();
                for (Element blockedPartsElement : coreAttributes.getAllOf("blockedPartsList")) {
                    relatedSlot = InventorySlot.valueOf(blockedPartsElement.getAttribute("slot"));
                    List blockedPartsList = blockedPartsElement.getAllOf("blockedParts").stream().map(e -> BlockedParts.loadFromXML(e.getInnerElement(), e.getDocument(), clothingXMLFile.getAbsolutePath())).collect(Collectors.toList());
                    this.blockedPartsMap.put((InventorySlot)((Object)relatedSlot), blockedPartsList);
                }
            }
            catch (Exception ex) {
                List blockedPartsList = coreAttributes.getMandatoryFirstOf("blockedPartsList").getAllOf("blockedParts").stream().map(e -> BlockedParts.loadFromXML(e.getInnerElement(), e.getDocument(), clothingXMLFile.getAbsolutePath())).collect(Collectors.toList());
                this.blockedPartsMap = Util.newHashMapOfValues(new Util.Value(this.getEquipSlots().get(0), blockedPartsList));
            }
            try {
                this.incompatibleSlotsMap = new HashMap<InventorySlot, List<InventorySlot>>();
                for (Element incompatibleSlotsElement : coreAttributes.getAllOf("incompatibleSlots")) {
                    relatedSlot = InventorySlot.valueOf(incompatibleSlotsElement.getAttribute("slot"));
                    List incompatibleSlotsList = incompatibleSlotsElement.getAllOf("slot").stream().map(Element::getTextContent).map(InventorySlot::valueOf).collect(Collectors.toList());
                    this.incompatibleSlotsMap.put((InventorySlot)((Object)relatedSlot), incompatibleSlotsList);
                }
            }
            catch (Exception ex) {
                List incompatibleSlotsList = coreAttributes.getMandatoryFirstOf("incompatibleSlots").getAllOf("slot").stream().map(Element::getTextContent).map(InventorySlot::valueOf).collect(Collectors.toList());
                this.incompatibleSlotsMap = Util.newHashMapOfValues(new Util.Value(this.getEquipSlots().get(0), incompatibleSlotsList));
            }
            this.itemTags = new HashMap<InventorySlot, List<ItemTag>>();
            for (Element itemTagsElement : coreAttributes.getAllOf("itemTags")) {
                if (itemTagsElement.getAttribute("slot").isEmpty()) {
                    for (InventorySlot slot : this.equipSlots) {
                        this.itemTags.putIfAbsent(slot, new ArrayList());
                        this.itemTags.get((Object)slot).addAll(Util.toEnumList(itemTagsElement.getAllOf("tag"), ItemTag.class));
                    }
                    for (Element e2 : itemTagsElement.getAllOf("tag")) {
                        boolean found = false;
                        switch (e2.getTextContent()) {
                            case "DILDO_TINY": {
                                this.penetrationOtherLength = 8;
                                found = true;
                                break;
                            }
                            case "DILDO_AVERAGE": {
                                this.penetrationOtherLength = 15;
                                found = true;
                                break;
                            }
                            case "DILDO_LARGE": {
                                this.penetrationOtherLength = 25;
                                found = true;
                                break;
                            }
                            case "DILDO_HUGE": {
                                this.penetrationOtherLength = 35;
                                found = true;
                                break;
                            }
                            case "DILDO_ENORMOUS": {
                                this.penetrationOtherLength = 45;
                                found = true;
                                break;
                            }
                            case "DILDO_GIGANTIC": {
                                this.penetrationOtherLength = 55;
                                found = true;
                                break;
                            }
                            case "DILDO_STALLION": {
                                this.penetrationOtherLength = 81;
                                found = true;
                            }
                        }
                        if (!found) continue;
                        this.penetrationSelfGirth = 2;
                        for (InventorySlot slot : this.equipSlots) {
                            this.itemTags.get((Object)slot).add(ItemTag.DILDO_OTHER);
                        }
                    }
                    continue;
                }
                relatedSlot = InventorySlot.valueOf(itemTagsElement.getAttribute("slot"));
                this.itemTags.putIfAbsent((InventorySlot)((Object)relatedSlot), new ArrayList());
                this.itemTags.get(relatedSlot).addAll(Util.toEnumList(itemTagsElement.getAllOf("tag"), ItemTag.class));
            }
            if (debug) {
                System.out.println("4");
            }
            this.displacementDescriptions = new HashMap<InventorySlot, Map<DisplacementType, Map<DisplacementDescriptionType, String>>>();
            Consumer<String> loadItemMoveDescriptions = repositionDescListTag -> clothingElement.getAllOf((String)repositionDescListTag).stream().forEach(descriptionList -> {
                DisplacementType type = DisplacementType.valueOf(descriptionList.getAttribute("type"));
                InventorySlot slot = null;
                try {
                    slot = InventorySlot.valueOf(descriptionList.getAttribute("slot"));
                }
                catch (Exception ex) {
                    slot = this.getEquipSlots().get(0);
                }
                this.displacementDescriptions.putIfAbsent(slot, new HashMap());
                this.displacementDescriptions.get((Object)slot).putIfAbsent(type, new HashMap());
                Map<DisplacementDescriptionType, String> universalMap = this.displacementDescriptions.get((Object)slot).get((Object)type);
                Function<Map, Consumer> putTagContentTo = mapToPutIn -> tagName -> descriptionList.getOptionalFirstOf((String)tagName).ifPresent(desc -> mapToPutIn.put(DisplacementDescriptionType.byTagsPath(repositionDescListTag + " " + desc.getTagName()), desc.getTextContent()));
                Consumer toUniversalMap = putTagContentTo.apply(universalMap);
                toUniversalMap.accept("playerNPC");
                toUniversalMap.accept("playerNPCRough");
                toUniversalMap.accept("playerSelf");
                toUniversalMap.accept("NPCPlayer");
                toUniversalMap.accept("NPCPlayerRough");
                toUniversalMap.accept("NPCSelf");
                toUniversalMap.accept("NPCOtherNPC");
                toUniversalMap.accept("NPCOtherNPCRough");
                toUniversalMap.accept("self");
                toUniversalMap.accept("other");
                toUniversalMap.accept("otherRough");
                if (this.displacementDescriptions.get((Object)slot).get((Object)type).isEmpty()) {
                    this.displacementDescriptions.get((Object)slot).remove((Object)type);
                }
            });
            loadItemMoveDescriptions.accept("replacementText");
            loadItemMoveDescriptions.accept("displacementText");
            if (debug) {
                System.out.println("5");
            }
            Predicate<Element> filterEmptyElements = element -> !element.getTextContent().isEmpty();
            this.clothingSet = coreAttributes.getOptionalFirstOf("clothingSet").filter(filterEmptyElements).map(Element::getTextContent).map(SetBonus::getSetBonusFromId).orElse(null);
            this.pathNamePrefix = clothingXMLFile.getParentFile().getAbsolutePath() + "/";
            this.pathName = this.pathNamePrefix + coreAttributes.getMandatoryFirstOf("imageName").getTextContent();
            this.pathNameEquipped = new HashMap<InventorySlot, String>();
            try {
                for (Element imageNameElement : coreAttributes.getAllOf("imageEquippedName")) {
                    InventorySlot relatedSlot2 = InventorySlot.valueOf(imageNameElement.getAttribute("slot"));
                    this.pathNameEquipped.put(relatedSlot2, imageNameElement.getTextContent());
                }
            }
            catch (Exception ex) {
                String path = coreAttributes.getOptionalFirstOf("imageEquippedName").filter(filterEmptyElements).map(e -> e.getTextContent()).filter(s -> !s.equals(this.pathName)).orElse(null);
                this.pathNameEquipped.put(this.getEquipSlots().get(0), path);
            }
            Function<Element, List> getColoursFromElement = colorsElement -> {
                String values = colorsElement.getAttribute("values");
                try {
                    if (values.isEmpty()) {
                        ArrayList<Colour> colours = new ArrayList<Colour>();
                        for (Element element : colorsElement.getAllOf("colour")) {
                            colours.add(PresetColour.getColourFromId(element.getTextContent()));
                        }
                        return colours;
                    }
                    return ColourListPresets.getColourListFromId(values);
                }
                catch (Exception e) {
                    System.err.println("AAAAAAAAAAAAA");
                    AbstractClothingType.printHelpfulErrorForEnumValueMismatches(e);
                    throw new IllegalStateException("Colour tag reading failure: " + colorsElement.getTagName() + " " + e.getMessage(), e);
                }
            };
            this.copyGenerationColours = new HashMap<Integer, Integer>();
            boolean primaryRecolourAllowed = true;
            if (coreAttributes.getOptionalFirstOf("primaryColours").isPresent() && !coreAttributes.getMandatoryFirstOf("primaryColours").getAttribute("recolouringAllowed").isEmpty()) {
                primaryRecolourAllowed = Boolean.valueOf(coreAttributes.getMandatoryFirstOf("primaryColours").getAttribute("recolouringAllowed"));
            }
            if (coreAttributes.getOptionalFirstOf("primaryColours").isPresent() && !coreAttributes.getMandatoryFirstOf("primaryColours").getAttribute("copyColourIndex").isEmpty()) {
                this.copyGenerationColours.put(0, Integer.valueOf(coreAttributes.getMandatoryFirstOf("primaryColours").getAttribute("copyColourIndex")));
            }
            List importedPrimaryColours = coreAttributes.getOptionalFirstOf("primaryColours").map(getColoursFromElement::apply).orElseGet(ArrayList::new);
            List importedPrimaryColoursDye = coreAttributes.getOptionalFirstOf("primaryColoursDye").map(getColoursFromElement::apply).orElseGet(ArrayList::new);
            boolean secondaryRecolourAllowed = true;
            if (coreAttributes.getOptionalFirstOf("secondaryColours").isPresent() && !coreAttributes.getMandatoryFirstOf("secondaryColours").getAttribute("recolouringAllowed").isEmpty()) {
                secondaryRecolourAllowed = Boolean.valueOf(coreAttributes.getMandatoryFirstOf("secondaryColours").getAttribute("recolouringAllowed"));
            }
            if (coreAttributes.getOptionalFirstOf("secondaryColours").isPresent() && !coreAttributes.getMandatoryFirstOf("secondaryColours").getAttribute("copyColourIndex").isEmpty()) {
                this.copyGenerationColours.put(1, Integer.valueOf(coreAttributes.getMandatoryFirstOf("secondaryColours").getAttribute("copyColourIndex")));
            }
            List importedSecondaryColours = coreAttributes.getOptionalFirstOf("secondaryColours").map(getColoursFromElement::apply).orElseGet(ArrayList::new);
            List importedSecondaryColoursDye = coreAttributes.getOptionalFirstOf("secondaryColoursDye").map(getColoursFromElement::apply).orElseGet(ArrayList::new);
            boolean tertiaryRecolourAllowed = true;
            if (coreAttributes.getOptionalFirstOf("tertiaryColours").isPresent() && !coreAttributes.getMandatoryFirstOf("tertiaryColours").getAttribute("recolouringAllowed").isEmpty()) {
                tertiaryRecolourAllowed = Boolean.valueOf(coreAttributes.getMandatoryFirstOf("tertiaryColours").getAttribute("recolouringAllowed"));
            }
            if (coreAttributes.getOptionalFirstOf("tertiaryColours").isPresent() && !coreAttributes.getMandatoryFirstOf("tertiaryColours").getAttribute("copyColourIndex").isEmpty()) {
                this.copyGenerationColours.put(2, Integer.valueOf(coreAttributes.getMandatoryFirstOf("tertiaryColours").getAttribute("copyColourIndex")));
            }
            List importedTertiaryColours = coreAttributes.getOptionalFirstOf("tertiaryColours").map(getColoursFromElement::apply).orElseGet(ArrayList::new);
            List importedTertiaryColoursDye = coreAttributes.getOptionalFirstOf("tertiaryColoursDye").map(getColoursFromElement::apply).orElseGet(ArrayList::new);
            this.setUpColours(primaryRecolourAllowed, importedPrimaryColours, importedPrimaryColoursDye, secondaryRecolourAllowed, importedSecondaryColours, importedSecondaryColoursDye, tertiaryRecolourAllowed, importedTertiaryColours, importedTertiaryColoursDye);
            if (coreAttributes.getOptionalFirstOf("customColours").isPresent()) {
                Element customColoursElement = coreAttributes.getMandatoryFirstOf("customColours");
                for (Element e3 : customColoursElement.getAllOf("customColour")) {
                    try {
                        ArrayList<String> replacementStrings = new ArrayList<String>();
                        int i = 0;
                        while (!e3.getAttribute("c" + i).isEmpty()) {
                            replacementStrings.add(e3.getAttribute("c" + i));
                            ++i;
                        }
                        boolean recolourAllowed = true;
                        if (!e3.getAttribute("recolouringAllowed").isEmpty()) {
                            recolourAllowed = Boolean.valueOf(e3.getAttribute("recolouringAllowed"));
                        }
                        if (!e3.getAttribute("copyColourIndex").isEmpty()) {
                            this.copyGenerationColours.put(this.colourReplacements.size(), Integer.valueOf(e3.getAttribute("copyColourIndex")));
                        }
                        List defaultColours = getColoursFromElement.apply(e3.getMandatoryFirstOf("defaultColours"));
                        List extraColours = getColoursFromElement.apply(e3.getMandatoryFirstOf("extraColours"));
                        this.colourReplacements.add(new ColourReplacement(recolourAllowed, replacementStrings, defaultColours, extraColours));
                    }
                    catch (Exception ex) {
                        System.err.println("Error in loading customColours from clothing: " + this.getName());
                    }
                }
            }
            if (this.colourReplacements.isEmpty()) {
                throw new Exception("AbstractClothingType (" + clothingXMLFile.getName() + "): colourReplacements is empty!");
            }
            if (coreAttributes.getOptionalFirstOf("defaultPatterns").isPresent()) {
                String patternChanceStr = coreAttributes.getMandatoryFirstOf("defaultPatterns").getAttribute("patternChance");
                this.patternChance = patternChanceStr.length() > 0 ? Float.valueOf(patternChanceStr).floatValue() : 0.0f;
                this.isColourDerivedFromPattern = Boolean.valueOf(coreAttributes.getMandatoryFirstOf("defaultPatterns").getAttribute("colourNameDerivedFromPattern"));
            } else {
                this.patternChance = 0.0f;
                this.isColourDerivedFromPattern = false;
            }
            Function<Element, List> getPatternsFromElement = patternsElement -> {
                try {
                    return patternsElement.getAllOf("pattern").stream().map(Element::getTextContent).map(Pattern::getPatternByIdOrName).collect(Collectors.toList());
                }
                catch (Exception e) {
                    AbstractClothingType.printHelpfulErrorForEnumValueMismatches(e);
                    throw new IllegalStateException("Pattern tag reading failure: " + patternsElement.getTagName() + " " + e.getMessage(), e);
                }
            };
            Function<Element, List> getPatternColoursFromElement = colorsElement -> {
                String values = colorsElement.getAttribute("values");
                try {
                    if (values.isEmpty()) {
                        if (colorsElement.getOptionalFirstOf("colour").isPresent()) {
                            return colorsElement.getAllOf("colour").stream().map(Element::getTextContent).map(PresetColour::getColourFromId).collect(Collectors.toList());
                        }
                        return new ArrayList<Colour>(ColourListPresets.ALL);
                    }
                    return new ArrayList<Colour>(ColourListPresets.ALL);
                }
                catch (Exception e) {
                    AbstractClothingType.printHelpfulErrorForEnumValueMismatches(e);
                    throw new IllegalStateException("Colour tag reading failure: " + colorsElement.getTagName() + " " + e.getMessage(), e);
                }
            };
            this.defaultPatterns = coreAttributes.getOptionalFirstOf("defaultPatterns").map(getPatternsFromElement::apply).orElse(new ArrayList<Pattern>(Pattern.getAllDefaultPatterns()));
            this.setUpPatternColours((List<Colour>)coreAttributes.getOptionalFirstOf("patternPrimaryColours").map(getPatternColoursFromElement::apply).orElse(new ArrayList<Colour>(ColourListPresets.ALL)), coreAttributes.getOptionalFirstOf("patternPrimaryColoursDye").map(getPatternColoursFromElement::apply).orElse(null), (List<Colour>)coreAttributes.getOptionalFirstOf("patternSecondaryColours").map(getPatternColoursFromElement::apply).orElse(new ArrayList<Colour>(ColourListPresets.ALL)), coreAttributes.getOptionalFirstOf("patternSecondaryColoursDye").map(getPatternColoursFromElement::apply).orElse(null), (List<Colour>)coreAttributes.getOptionalFirstOf("patternTertiaryColours").map(getPatternColoursFromElement::apply).orElse(new ArrayList<Colour>(ColourListPresets.ALL)), coreAttributes.getOptionalFirstOf("patternTertiaryColoursDye").map(getPatternColoursFromElement::apply).orElse(null));
            if (coreAttributes.getOptionalFirstOf("customPatternColours").isPresent()) {
                Element customColoursElement = coreAttributes.getMandatoryFirstOf("customPatternColours");
                for (Element e4 : customColoursElement.getAllOf("customColour")) {
                    try {
                        ArrayList<String> replacementStrings = new ArrayList<String>();
                        int i = 0;
                        while (!e4.getAttribute("c" + i).isEmpty()) {
                            replacementStrings.add(e4.getAttribute("c" + i));
                            ++i;
                        }
                        List defaultColours = getColoursFromElement.apply(e4.getMandatoryFirstOf("defaultColours"));
                        List extraColours = getColoursFromElement.apply(e4.getMandatoryFirstOf("extraColours"));
                        this.patternColourReplacements.add(new ColourReplacement(true, replacementStrings, defaultColours, extraColours));
                    }
                    catch (Exception ex) {
                        System.err.println("Error in loading customColours from clothing: " + this.getName());
                    }
                }
            }
            this.populateEmptyPatternColours();
            this.stickers = new HashMap<StickerCategory, List<Sticker>>();
            if (clothingElement.getOptionalFirstOf("stickers").isPresent()) {
                Element stickersElement = clothingElement.getMandatoryFirstOf("stickers");
                for (Element categoryElement : stickersElement.getAllOf("category")) {
                    String categoryId = categoryElement.getAttribute("id");
                    if (categoryId.isEmpty()) continue;
                    int priority = 10;
                    if (!categoryElement.getAttribute("priority").isEmpty()) {
                        priority = Integer.valueOf(categoryElement.getAttribute("priority"));
                    }
                    String categoryName = categoryId;
                    if (categoryElement.getOptionalFirstOf("categoryName").isPresent()) {
                        categoryName = categoryElement.getMandatoryFirstOf("categoryName").getTextContent();
                    }
                    StickerCategory category = new StickerCategory(categoryId, categoryName, priority);
                    this.stickers.put(category, new ArrayList());
                    for (Element stickerElement : categoryElement.getAllOf("sticker")) {
                        void var48_77;
                        String stickerId = stickerElement.getAttribute("id");
                        int stickerPriority = 10;
                        if (!stickerElement.getAttribute("priority").isEmpty()) {
                            stickerPriority = Integer.valueOf(stickerElement.getAttribute("priority"));
                        }
                        String stickerName = stickerId;
                        if (stickerElement.getOptionalFirstOf("stickerName").isPresent()) {
                            stickerName = stickerElement.getMandatoryFirstOf("stickerName").getTextContent();
                        }
                        boolean stickerDefaultSticker = false;
                        if (!stickerElement.getAttribute("defaultSticker").isEmpty()) {
                            stickerDefaultSticker = Boolean.valueOf(stickerElement.getAttribute("defaultSticker"));
                        }
                        int stickerZLayer = 1;
                        if (!stickerElement.getAttribute("zLayer").isEmpty()) {
                            stickerZLayer = Integer.valueOf(stickerElement.getAttribute("zLayer"));
                        }
                        Colour colourDisabled = PresetColour.TEXT_GREY_DARK;
                        if (!stickerElement.getAttribute("colourDisabled").isEmpty()) {
                            String colourDefinition = stickerElement.getAttribute("colourDisabled");
                            if (PresetColour.getAllColourIds().contains(colourDefinition)) {
                                colourDisabled = PresetColour.getColourFromId(colourDefinition);
                            } else {
                                try {
                                    colourDisabled = new Colour(false, Util.newColour(Integer.valueOf(colourDefinition, 16)), Util.newColour(Integer.valueOf(colourDefinition, 16)), "");
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                        }
                        Colour colourSelected = PresetColour.GENERIC_GOOD;
                        if (!stickerElement.getAttribute("colourSelected").isEmpty()) {
                            String colourDefinition = stickerElement.getAttribute("colourSelected");
                            if (PresetColour.getAllColourIds().contains(colourDefinition)) {
                                colourSelected = PresetColour.getColourFromId(colourDefinition);
                            } else {
                                try {
                                    colourSelected = new Colour(false, Util.newColour(Integer.valueOf(colourDefinition, 16)), Util.newColour(Integer.valueOf(colourDefinition, 16)), "");
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                        }
                        String stickerNamePrefix = "";
                        int stickerPrefixPriority = 1;
                        if (stickerElement.getOptionalFirstOf("namePrefix").isPresent()) {
                            Element namePrefixElement = stickerElement.getMandatoryFirstOf("namePrefix");
                            stickerNamePrefix = namePrefixElement.getTextContent();
                            if (!namePrefixElement.getAttribute("priority").isEmpty()) {
                                stickerPrefixPriority = Integer.valueOf(namePrefixElement.getAttribute("priority"));
                            }
                        }
                        String stickerNamePostfix = "";
                        int stickerPostfixPriority = 1;
                        if (stickerElement.getOptionalFirstOf("namePostfix").isPresent()) {
                            Element namePostfixElement = stickerElement.getMandatoryFirstOf("namePostfix");
                            stickerNamePostfix = namePostfixElement.getTextContent();
                            if (!namePostfixElement.getAttribute("priority").isEmpty()) {
                                stickerPostfixPriority = Integer.valueOf(namePostfixElement.getAttribute("priority"));
                            }
                        }
                        String stickerDescription = "";
                        boolean stickerDescriptionFullReplacement = false;
                        int stickerDescriptionPriority = 1;
                        if (stickerElement.getOptionalFirstOf("descriptionModification").isPresent()) {
                            Element descriptionElement = stickerElement.getMandatoryFirstOf("descriptionModification");
                            stickerDescription = descriptionElement.getTextContent();
                            if (!descriptionElement.getAttribute("fullReplacement").isEmpty()) {
                                stickerDescriptionFullReplacement = Boolean.valueOf(descriptionElement.getAttribute("fullReplacement"));
                            }
                            if (!descriptionElement.getAttribute("priority").isEmpty()) {
                                stickerDescriptionPriority = Integer.valueOf(descriptionElement.getAttribute("priority"));
                            }
                        }
                        HashMap<InventorySlot, Map<Integer, String>> stickerSvgPaths = new HashMap<InventorySlot, Map<Integer, String>>();
                        boolean svgImageFound = false;
                        for (Element svgPathElement : stickerElement.getAllOf("imageName")) {
                            Iterator<Element> path = "";
                            if (!svgPathElement.getTextContent().isEmpty()) {
                                path = clothingXMLFile.getParentFile().getAbsolutePath() + "/" + svgPathElement.getTextContent();
                                svgImageFound = true;
                            }
                            Object var48_79 = null;
                            if (!svgPathElement.getAttribute("slot").isEmpty()) {
                                InventorySlot inventorySlot = InventorySlot.valueOf(svgPathElement.getAttribute("slot"));
                            }
                            int zLayer = stickerZLayer;
                            if (!svgPathElement.getAttribute("zLayer").isEmpty()) {
                                zLayer = Integer.valueOf(svgPathElement.getAttribute("zLayer"));
                            }
                            for (InventorySlot equipSlot : this.getEquipSlots()) {
                                void var48_81;
                                stickerSvgPaths.putIfAbsent(equipSlot, new HashMap());
                                if (var48_81 != null && var48_81 != equipSlot) continue;
                                ((Map)stickerSvgPaths.get((Object)equipSlot)).put(zLayer, path);
                            }
                        }
                        if (!svgImageFound && stickerElement.getAttribute("colourSelected").isEmpty()) {
                            colourSelected = PresetColour.TEXT_GREY;
                        }
                        ArrayList<ItemTag> stickerAddedTags = new ArrayList<ItemTag>();
                        if (stickerElement.getOptionalFirstOf("itemTagsAdded").isPresent()) {
                            Element tagsElement = stickerElement.getMandatoryFirstOf("itemTagsAdded");
                            for (Element element2 : tagsElement.getAllOf("tag")) {
                                stickerAddedTags.add(ItemTag.valueOf(element2.getTextContent()));
                            }
                        }
                        ArrayList<ItemTag> stickerRemovedTags = new ArrayList<ItemTag>();
                        if (stickerElement.getOptionalFirstOf("itemTagsRemoved").isPresent()) {
                            Element tagsElement = stickerElement.getMandatoryFirstOf("itemTagsRemoved");
                            for (Element tag2 : tagsElement.getAllOf("tag")) {
                                stickerRemovedTags.add(ItemTag.valueOf(tag2.getTextContent()));
                            }
                        }
                        String stickerUnavailabilityText = "";
                        String string = "";
                        boolean showDisabledButton = true;
                        if (stickerElement.getOptionalFirstOf("unavailabilityText").isPresent()) {
                            stickerUnavailabilityText = stickerElement.getMandatoryFirstOf("unavailabilityText").getTextContent();
                            if (!stickerElement.getMandatoryFirstOf("unavailabilityText").getAttribute("showDisabledButton").isEmpty()) {
                                showDisabledButton = Boolean.valueOf(stickerElement.getMandatoryFirstOf("unavailabilityText").getAttribute("showDisabledButton"));
                            }
                        }
                        if (stickerElement.getOptionalFirstOf("availabilityText").isPresent()) {
                            String string2 = stickerElement.getMandatoryFirstOf("availabilityText").getTextContent();
                        }
                        Sticker sticker = new Sticker(stickerId, stickerName, stickerPriority, stickerDefaultSticker, colourDisabled, colourSelected, stickerNamePrefix, stickerPrefixPriority, stickerNamePostfix, stickerPostfixPriority, stickerDescription, stickerDescriptionFullReplacement, stickerDescriptionPriority, stickerSvgPaths, stickerAddedTags, stickerRemovedTags, showDisabledButton, stickerUnavailabilityText, (String)var48_77);
                        this.stickers.get(category).add(sticker);
                    }
                }
            }
            Element sexSelfAttributes = null;
            try {
                sexSelfAttributes = clothingElement.getMandatoryFirstOf("sexAttributesSelf");
                if (sexSelfAttributes.getOptionalFirstOf("penetration").isPresent()) {
                    Element penetrationAttributes = sexSelfAttributes.getMandatoryFirstOf("penetration");
                    if (penetrationAttributes.getInnerElement().hasChildNodes()) {
                        for (InventorySlot slot : this.equipSlots) {
                            this.itemTags.get((Object)slot).add(ItemTag.DILDO_SELF);
                        }
                    }
                    if (penetrationAttributes.getOptionalFirstOf("length").isPresent()) {
                        this.penetrationSelfLength = Integer.valueOf(penetrationAttributes.getMandatoryFirstOf("length").getTextContent());
                    }
                    if (penetrationAttributes.getOptionalFirstOf("girth").isPresent()) {
                        this.penetrationSelfGirth = Integer.valueOf(penetrationAttributes.getMandatoryFirstOf("girth").getTextContent());
                    }
                    if (penetrationAttributes.getOptionalFirstOf("modifiers").isPresent()) {
                        this.penetrationSelfModifiers = penetrationAttributes.getMandatoryFirstOf("modifiers").getAllOf("mod").stream().map(e -> PenetrationModifier.valueOf(e.getTextContent())).collect(Collectors.toSet());
                    }
                }
                if (sexSelfAttributes.getOptionalFirstOf("orifice").isPresent()) {
                    Element orificeAttributes = sexSelfAttributes.getMandatoryFirstOf("orifice");
                    if (orificeAttributes.getInnerElement().hasChildNodes()) {
                        for (InventorySlot slot : this.equipSlots) {
                            this.itemTags.get((Object)slot).add(ItemTag.ONAHOLE_SELF);
                        }
                    }
                    this.orificeSelfLabiaSize = 2;
                    this.orificeSelfClitSize = 0;
                    this.orificeSelfClitGirth = 3;
                    this.orificeSelfDepth = 25;
                    this.orificeSelfCapacity = 2.0f;
                    this.orificeSelfElasticity = 1;
                    this.orificeSelfPlasticity = 0;
                    this.orificeSelfWetness = 0;
                    this.orificeSelfModifiers = new HashSet<OrificeModifier>();
                    if (orificeAttributes.getOptionalFirstOf("labiaSize").isPresent()) {
                        this.orificeSelfLabiaSize = Integer.valueOf(orificeAttributes.getMandatoryFirstOf("labiaSize").getTextContent());
                    }
                    if (orificeAttributes.getOptionalFirstOf("clitSize").isPresent()) {
                        this.orificeSelfClitSize = Integer.valueOf(orificeAttributes.getMandatoryFirstOf("clitSize").getTextContent());
                    }
                    if (orificeAttributes.getOptionalFirstOf("clitGirth").isPresent()) {
                        this.orificeSelfClitGirth = Integer.valueOf(orificeAttributes.getMandatoryFirstOf("clitGirth").getTextContent());
                    }
                    if (orificeAttributes.getOptionalFirstOf("depth").isPresent()) {
                        this.orificeSelfDepth = Integer.valueOf(orificeAttributes.getMandatoryFirstOf("depth").getTextContent());
                    }
                    if (orificeAttributes.getOptionalFirstOf("capacity").isPresent()) {
                        this.orificeSelfCapacity = Float.valueOf(orificeAttributes.getMandatoryFirstOf("capacity").getTextContent()).floatValue();
                    }
                    if (orificeAttributes.getOptionalFirstOf("elasticity").isPresent()) {
                        this.orificeSelfElasticity = Integer.valueOf(orificeAttributes.getMandatoryFirstOf("elasticity").getTextContent());
                    }
                    if (orificeAttributes.getOptionalFirstOf("plasticity").isPresent()) {
                        this.orificeSelfPlasticity = Integer.valueOf(orificeAttributes.getMandatoryFirstOf("plasticity").getTextContent());
                    }
                    if (orificeAttributes.getOptionalFirstOf("wetness").isPresent()) {
                        this.orificeSelfWetness = Integer.valueOf(orificeAttributes.getMandatoryFirstOf("wetness").getTextContent());
                    }
                    if (orificeAttributes.getOptionalFirstOf("modifiers").isPresent()) {
                        this.orificeSelfModifiers = orificeAttributes.getMandatoryFirstOf("modifiers").getAllOf("mod").stream().map(e -> OrificeModifier.valueOf(e.getTextContent())).collect(Collectors.toSet());
                    }
                }
            }
            catch (XMLMissingTagException orificeAttributes) {
                // empty catch block
            }
            Element otherSexAttributes = null;
            try {
                otherSexAttributes = clothingElement.getMandatoryFirstOf("sexAttributesOther");
                if (otherSexAttributes.getOptionalFirstOf("penetration").isPresent()) {
                    Element penetrationAttributes = otherSexAttributes.getMandatoryFirstOf("penetration");
                    if (penetrationAttributes.getInnerElement().hasChildNodes()) {
                        for (InventorySlot slot : this.equipSlots) {
                            this.itemTags.get((Object)slot).add(ItemTag.DILDO_OTHER);
                        }
                    }
                    if (penetrationAttributes.getOptionalFirstOf("length").isPresent()) {
                        this.penetrationOtherLength = Integer.valueOf(penetrationAttributes.getMandatoryFirstOf("length").getTextContent());
                    }
                    if (penetrationAttributes.getOptionalFirstOf("girth").isPresent()) {
                        this.penetrationOtherGirth = Integer.valueOf(penetrationAttributes.getMandatoryFirstOf("girth").getTextContent());
                    }
                    if (penetrationAttributes.getOptionalFirstOf("modifiers").isPresent()) {
                        this.penetrationOtherModifiers = penetrationAttributes.getMandatoryFirstOf("modifiers").getAllOf("mod").stream().map(e -> PenetrationModifier.valueOf(e.getTextContent())).collect(Collectors.toSet());
                    }
                }
                if (otherSexAttributes.getOptionalFirstOf("orifice").isPresent()) {
                    Element orificeAttributes = otherSexAttributes.getMandatoryFirstOf("orifice");
                    if (orificeAttributes.getInnerElement().hasChildNodes()) {
                        for (InventorySlot slot : this.equipSlots) {
                            this.itemTags.get((Object)slot).add(ItemTag.ONAHOLE_OTHER);
                        }
                    }
                    this.orificeOtherLabiaSize = 2;
                    this.orificeOtherClitSize = 0;
                    this.orificeOtherClitGirth = 3;
                    this.orificeOtherDepth = 25;
                    this.orificeOtherCapacity = 2.0f;
                    this.orificeOtherElasticity = 1;
                    this.orificeOtherPlasticity = 0;
                    this.orificeOtherWetness = 0;
                    this.orificeOtherModifiers = new HashSet<OrificeModifier>();
                    if (orificeAttributes.getOptionalFirstOf("labiaSize").isPresent()) {
                        this.orificeOtherLabiaSize = Integer.valueOf(orificeAttributes.getMandatoryFirstOf("labiaSize").getTextContent());
                    }
                    if (orificeAttributes.getOptionalFirstOf("clitSize").isPresent()) {
                        this.orificeOtherClitSize = Integer.valueOf(orificeAttributes.getMandatoryFirstOf("clitSize").getTextContent());
                    }
                    if (orificeAttributes.getOptionalFirstOf("clitGirth").isPresent()) {
                        this.orificeOtherClitGirth = Integer.valueOf(orificeAttributes.getMandatoryFirstOf("clitGirth").getTextContent());
                    }
                    if (orificeAttributes.getOptionalFirstOf("depth").isPresent()) {
                        this.orificeOtherDepth = Integer.valueOf(orificeAttributes.getMandatoryFirstOf("depth").getTextContent());
                    }
                    if (orificeAttributes.getOptionalFirstOf("capacity").isPresent()) {
                        this.orificeOtherCapacity = Float.valueOf(orificeAttributes.getMandatoryFirstOf("capacity").getTextContent()).floatValue();
                    }
                    if (orificeAttributes.getOptionalFirstOf("elasticity").isPresent()) {
                        this.orificeOtherElasticity = Integer.valueOf(orificeAttributes.getMandatoryFirstOf("elasticity").getTextContent());
                    }
                    if (orificeAttributes.getOptionalFirstOf("plasticity").isPresent()) {
                        this.orificeOtherPlasticity = Integer.valueOf(orificeAttributes.getMandatoryFirstOf("plasticity").getTextContent());
                    }
                    if (orificeAttributes.getOptionalFirstOf("wetness").isPresent()) {
                        this.orificeOtherWetness = Integer.valueOf(orificeAttributes.getMandatoryFirstOf("wetness").getTextContent());
                    }
                    if (orificeAttributes.getOptionalFirstOf("modifiers").isPresent()) {
                        this.orificeOtherModifiers = orificeAttributes.getMandatoryFirstOf("modifiers").getAllOf("mod").stream().map(e -> OrificeModifier.valueOf(e.getTextContent())).collect(Collectors.toSet());
                    }
                }
            }
            catch (XMLMissingTagException xMLMissingTagException) {
                // empty catch block
            }
            this.finalSetUp();
        }
        catch (XMLMissingTagException ex) {
            throw new XMLLoadException(ex, clothingXMLFile);
        }
        catch (Exception e5) {
            System.out.println(e5);
            throw new XMLLoadException(e5, clothingXMLFile);
        }
    }

    private void setUpFemininity(Femininity femininity) {
        if (femininity == null || femininity == Femininity.ANDROGYNOUS) {
            this.femininityMinimum = 0;
            this.femininityMaximum = 100;
        } else if (femininity == Femininity.FEMININE) {
            this.femininityMinimum = Femininity.ANDROGYNOUS.getMinimumFemininity();
            this.femininityMaximum = 100;
        } else if (femininity == Femininity.MASCULINE) {
            this.femininityMinimum = 0;
            this.femininityMaximum = Femininity.ANDROGYNOUS.getMaximumFemininity();
        }
    }

    private void setUpColours(boolean primaryRecolouringAllowed, List<Colour> availablePrimaryColours, List<Colour> availablePrimaryDyeColours, boolean secondaryRecolouringAllowed, List<Colour> availableSecondaryColours, List<Colour> availableSecondaryDyeColours, boolean tertiaryRecolouringAllowed, List<Colour> availableTertiaryColours, List<Colour> availableTertiaryDyeColours) {
        this.colourReplacements = new ArrayList<ColourReplacement>();
        if (availablePrimaryColours != null && !availablePrimaryColours.isEmpty() || availablePrimaryDyeColours != null && !availablePrimaryDyeColours.isEmpty()) {
            this.colourReplacements.add(new ColourReplacement(primaryRecolouringAllowed, ColourReplacement.DEFAULT_PRIMARY_REPLACEMENTS, availablePrimaryColours, availablePrimaryDyeColours));
        }
        if (availableSecondaryColours != null && !availableSecondaryColours.isEmpty() || availableSecondaryDyeColours != null && !availableSecondaryDyeColours.isEmpty()) {
            this.colourReplacements.add(new ColourReplacement(secondaryRecolouringAllowed, ColourReplacement.DEFAULT_SECONDARY_REPLACEMENTS, availableSecondaryColours, availableSecondaryDyeColours));
        }
        if (availableTertiaryColours != null && !availableTertiaryColours.isEmpty() || availableTertiaryDyeColours != null && !availableTertiaryDyeColours.isEmpty()) {
            this.colourReplacements.add(new ColourReplacement(tertiaryRecolouringAllowed, ColourReplacement.DEFAULT_TERTIARY_REPLACEMENTS, availableTertiaryColours, availableTertiaryDyeColours));
        }
    }

    private void setUpPatternColours(List<Colour> availablePatternPrimaryColours, List<Colour> availablePatternPrimaryDyeColours, List<Colour> availablePatternSecondaryColours, List<Colour> availablePatternSecondaryDyeColours, List<Colour> availablePatternTertiaryColours, List<Colour> availablePatternTertiaryDyeColours) {
        this.patternColourReplacements = new ArrayList<ColourReplacement>();
        if (availablePatternPrimaryColours != null && !availablePatternPrimaryColours.isEmpty() || availablePatternPrimaryDyeColours != null && !availablePatternPrimaryDyeColours.isEmpty()) {
            this.patternColourReplacements.add(new ColourReplacement(true, ColourReplacement.DEFAULT_PATTERN_PRIMARY_REPLACEMENTS, availablePatternPrimaryColours, availablePatternPrimaryDyeColours));
        }
        if (availablePatternSecondaryColours != null && !availablePatternSecondaryColours.isEmpty() || availablePatternSecondaryDyeColours != null && !availablePatternSecondaryDyeColours.isEmpty()) {
            this.patternColourReplacements.add(new ColourReplacement(true, ColourReplacement.DEFAULT_PATTERN_SECONDARY_REPLACEMENTS, availablePatternSecondaryColours, availablePatternSecondaryDyeColours));
        }
        if (availablePatternTertiaryColours != null && !availablePatternTertiaryColours.isEmpty() || availablePatternTertiaryDyeColours != null && !availablePatternTertiaryDyeColours.isEmpty()) {
            this.patternColourReplacements.add(new ColourReplacement(true, ColourReplacement.DEFAULT_PATTERN_TERTIARY_REPLACEMENTS, availablePatternTertiaryColours, availablePatternTertiaryDyeColours));
        }
    }

    private void populateEmptyPatternColours() {
        if (this.patternColourReplacements.size() == 0) {
            this.patternColourReplacements.add(new ColourReplacement(true, ColourReplacement.DEFAULT_PATTERN_PRIMARY_REPLACEMENTS, ColourListPresets.ALL, null));
        }
        if (this.patternColourReplacements.size() == 1) {
            this.patternColourReplacements.add(new ColourReplacement(true, ColourReplacement.DEFAULT_PATTERN_SECONDARY_REPLACEMENTS, ColourListPresets.ALL, null));
        }
        if (this.patternColourReplacements.size() == 2) {
            this.patternColourReplacements.add(new ColourReplacement(true, ColourReplacement.DEFAULT_PATTERN_TERTIARY_REPLACEMENTS, ColourListPresets.ALL, null));
        }
    }

    private static void printHelpfulErrorForEnumValueMismatches(Exception ex) {
        HashMap<Class<ColourListPresets>, Set<String>> possibleEnumValues = new HashMap<Class<ColourListPresets>, Set<String>>();
        possibleEnumValues.put(ColourListPresets.class, ColourListPresets.getIdToColourListMap().keySet());
        String exMessage = ex.getMessage();
        if (exMessage.startsWith("No ColourListPreset constant")) {
            for (Map.Entry possibleMatch : possibleEnumValues.entrySet()) {
                if (!exMessage.contains(((Class)possibleMatch.getKey()).getCanonicalName())) continue;
                StringJoiner valueLister = new StringJoiner(",");
                Arrays.asList((Set)possibleMatch.getValue()).forEach(enumValue -> valueLister.add(enumValue.toString()));
                System.err.println("Possible values for " + ((Class)possibleMatch.getKey()).getSimpleName() + " are " + valueLister.toString());
            }
        }
    }

    private void finalSetUp() {
        this.displacementTypesAvailableWithoutNONE = new HashMap<InventorySlot, List<DisplacementType>>();
        for (Map.Entry<InventorySlot, List<BlockedParts>> entry : this.blockedPartsMap.entrySet()) {
            this.displacementTypesAvailableWithoutNONE.put(entry.getKey(), new ArrayList());
            for (BlockedParts blockedParts : entry.getValue()) {
                if (blockedParts.displacementType == DisplacementType.REMOVE_OR_EQUIP) continue;
                this.displacementTypesAvailableWithoutNONE.get((Object)entry.getKey()).add(blockedParts.displacementType);
            }
            Collections.sort(this.displacementTypesAvailableWithoutNONE.get((Object)entry.getKey()));
        }
        this.SVGStringMap = new HashMap<String, String>();
        this.SVGStringEquippedMap = new HashMap<String, String>();
        for (Map.Entry<InventorySlot, List<BlockedParts>> entry : this.blockedPartsMap.entrySet()) {
            for (BlockedParts blockedParts : entry.getValue()) {
                if (blockedParts.blockedBodyParts.contains((Object)CoverableArea.PENIS) && !blockedParts.clothingAccessBlocked.contains((Object)ClothingAccess.PENIS)) {
                    blockedParts.clothingAccessBlocked.add(ClothingAccess.PENIS);
                }
                if (!blockedParts.blockedBodyParts.contains((Object)CoverableArea.VAGINA) || blockedParts.clothingAccessBlocked.contains((Object)ClothingAccess.VAGINA)) continue;
                blockedParts.clothingAccessBlocked.add(ClothingAccess.VAGINA);
            }
        }
        for (Map.Entry<InventorySlot, List<Object>> entry : this.itemTags.entrySet()) {
            block10: for (ItemTag itemTag : entry.getValue()) {
                switch (itemTag) {
                    case PLUGS_ANUS: 
                    case SEALS_ANUS: {
                        if (!this.blockedPartsMap.containsKey((Object)InventorySlot.ANUS)) break;
                        for (BlockedParts bp : this.blockedPartsMap.get((Object)InventorySlot.ANUS)) {
                            if (bp.displacementType != DisplacementType.REMOVE_OR_EQUIP || bp.blockedBodyParts.contains((Object)CoverableArea.ANUS)) continue;
                            bp.blockedBodyParts.add(CoverableArea.ANUS);
                        }
                        continue block10;
                    }
                    case PLUGS_NIPPLES: 
                    case SEALS_NIPPLES: {
                        if (!this.blockedPartsMap.containsKey((Object)InventorySlot.NIPPLE)) break;
                        for (BlockedParts bp : this.blockedPartsMap.get((Object)InventorySlot.NIPPLE)) {
                            if (bp.displacementType != DisplacementType.REMOVE_OR_EQUIP || bp.blockedBodyParts.contains((Object)CoverableArea.NIPPLES)) continue;
                            bp.blockedBodyParts.add(CoverableArea.NIPPLES);
                        }
                        continue block10;
                    }
                    case PLUGS_VAGINA: 
                    case SEALS_VAGINA: {
                        if (!this.blockedPartsMap.containsKey((Object)InventorySlot.VAGINA)) break;
                        for (BlockedParts bp : this.blockedPartsMap.get((Object)InventorySlot.VAGINA)) {
                            if (bp.displacementType != DisplacementType.REMOVE_OR_EQUIP || bp.blockedBodyParts.contains((Object)CoverableArea.VAGINA)) continue;
                            bp.blockedBodyParts.add(CoverableArea.VAGINA);
                        }
                        continue block10;
                    }
                }
            }
        }
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o) && o instanceof AbstractClothingType && ((AbstractClothingType)o).getName().equals(this.getName()) && ((AbstractClothingType)o).getPathName().equals(this.getPathName()) && ((AbstractClothingType)o).getPhysicalResistance() == this.getPhysicalResistance() && ((AbstractClothingType)o).femininityMaximum == this.femininityMaximum && ((AbstractClothingType)o).femininityMinimum == this.femininityMinimum && ((AbstractClothingType)o).femininityRestriction == this.femininityRestriction && ((AbstractClothingType)o).getEquipSlots().equals(this.getEquipSlots()) && ((AbstractClothingType)o).getEffects().equals(this.getEffects()) && ((AbstractClothingType)o).getClothingSet() == this.getClothingSet() && ((AbstractClothingType)o).getRarity() == this.getRarity();
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.getName().hashCode();
        result = 31 * result + this.getPathName().hashCode();
        result = 31 * result + Float.floatToIntBits(this.getPhysicalResistance());
        result = 31 * result + this.femininityMinimum;
        result = 31 * result + this.femininityMinimum;
        if (this.femininityRestriction != null) {
            result = 31 * result + this.femininityRestriction.hashCode();
        }
        result = 31 * result + this.getEquipSlots().hashCode();
        result = 31 * result + this.getEffects().hashCode();
        if (this.getClothingSet() != null) {
            result = 31 * result + this.getClothingSet().hashCode();
        }
        result = 31 * result + this.getRarity().hashCode();
        return result;
    }

    public String getId() {
        return ClothingType.getIdFromClothingType(this);
    }

    public int getBaseValue() {
        return this.baseValue;
    }

    public static List<AbstractClothingType> getClothingInSet(AbstractSetBonus set) {
        if (clothingSetMap.get(set) != null) {
            return clothingSetMap.get(set);
        }
        ArrayList<AbstractClothingType> setOfClothing = new ArrayList<AbstractClothingType>();
        for (AbstractClothingType c : ClothingType.getAllClothing()) {
            if (c.getClothingSet() != set) continue;
            setOfClothing.add(c);
        }
        clothingSetMap.put(set, setOfClothing);
        return setOfClothing;
    }

    public static String getEquipDescriptions(GameCharacter clothingOwner, GameCharacter clothingEquipper, boolean rough, String playerEquipping, String playerEquippingNpc, String playerEquippingNpcRough, String npcEquipping, String npcEquippingPlayer, String npcEquippingPlayerRough, String npcEquippingOtherNPC, String npcEquippingOtherNPCRough) {
        if (clothingEquipper.isPlayer()) {
            if (clothingOwner.isPlayer()) {
                return UtilText.parse(clothingOwner, playerEquipping, new ParserTag[0]);
            }
            if (rough && playerEquippingNpcRough != null) {
                return UtilText.parse(clothingOwner, playerEquippingNpcRough, new ParserTag[0]);
            }
            return UtilText.parse(clothingOwner, playerEquippingNpc, new ParserTag[0]);
        }
        if (clothingOwner.isPlayer()) {
            if (rough && npcEquippingPlayerRough != null) {
                return UtilText.parse(clothingEquipper, npcEquippingPlayerRough, new ParserTag[0]);
            }
            return UtilText.parse(clothingEquipper, npcEquippingPlayer, new ParserTag[0]);
        }
        if (clothingOwner.equals(clothingEquipper)) {
            return UtilText.parse(clothingOwner, npcEquipping, new ParserTag[0]);
        }
        if (rough && npcEquippingOtherNPCRough != null) {
            return UtilText.parse(clothingEquipper, clothingOwner, npcEquippingOtherNPCRough, new ParserTag[0]);
        }
        if (npcEquippingOtherNPC != null) {
            return UtilText.parse(clothingEquipper, clothingOwner, npcEquippingOtherNPC, new ParserTag[0]);
        }
        return UtilText.parse(clothingEquipper, clothingOwner, "[npc1.Name]\u63a7\u5236\u7740[npc2.namePos]\u7684\u8863\u7269\u3002", new ParserTag[0]);
    }

    public String equipText(GameCharacter clothingOwner, GameCharacter clothingEquipper, InventorySlot slotToEquipInto, boolean rough, AbstractClothing clothing, boolean applyEffects) {
        String condomEquip;
        NPC interactingTarget;
        if (clothing.isCondom(slotToEquipInto) && applyEffects && (interactingTarget = Main.game.isInSex() && !Main.sex.isMasturbation() && Main.sex.getTargetedPartner(clothingEquipper) != null && Main.sex.getTargetedPartner(clothingEquipper) instanceof NPC ? (NPC)Main.sex.getTargetedPartner(clothingEquipper) : InventoryDialogue.getInventoryNPC()) != null && (condomEquip = interactingTarget.getCondomEquipEffects(this, clothingEquipper, clothingOwner, rough)) != null) {
            return condomEquip;
        }
        if (clothingOwner == null || clothingEquipper == null || !Main.game.isStarted()) {
            return "";
        }
        if (this.displacementDescriptions != null && this.displacementDescriptions.get((Object)slotToEquipInto) != null && !this.displacementDescriptions.get((Object)slotToEquipInto).isEmpty()) {
            if (clothingOwner.equals(clothingEquipper)) {
                if (this.displacementDescriptions.get((Object)slotToEquipInto) != null && this.displacementDescriptions.get((Object)slotToEquipInto).containsKey((Object)DisplacementType.REMOVE_OR_EQUIP) && this.displacementDescriptions.get((Object)slotToEquipInto).get((Object)DisplacementType.REMOVE_OR_EQUIP).containsKey((Object)DisplacementDescriptionType.REPLACEMENT_SELF)) {
                    return UtilText.parse(clothingOwner, this.displacementDescriptions.get((Object)slotToEquipInto).get((Object)DisplacementType.REMOVE_OR_EQUIP).get((Object)DisplacementDescriptionType.REPLACEMENT_SELF), new ParserTag[0]);
                }
                return UtilText.parse(clothingOwner, "[npc.Name]\u88c5\u5907\u4e86" + clothing.getName() + "\u3002", new ParserTag[0]);
            }
            if (rough) {
                if (this.displacementDescriptions.get((Object)slotToEquipInto) != null && this.displacementDescriptions.get((Object)slotToEquipInto).containsKey((Object)DisplacementType.REMOVE_OR_EQUIP) && this.displacementDescriptions.get((Object)slotToEquipInto).get((Object)DisplacementType.REMOVE_OR_EQUIP).containsKey((Object)DisplacementDescriptionType.REPLACEMENT_ROUGH)) {
                    return UtilText.parse(clothingEquipper, clothingOwner, this.displacementDescriptions.get((Object)slotToEquipInto).get((Object)DisplacementType.REMOVE_OR_EQUIP).get((Object)DisplacementDescriptionType.REPLACEMENT_ROUGH), new ParserTag[0]);
                }
                return UtilText.parse(clothingEquipper, clothingOwner, "[npc.Name]\u8ba9[npc2.name]\u88c5\u5907\u4e0a" + clothing.getName() + "\u3002", new ParserTag[0]);
            }
            if (this.displacementDescriptions.get((Object)slotToEquipInto) != null && this.displacementDescriptions.get((Object)slotToEquipInto).containsKey((Object)DisplacementType.REMOVE_OR_EQUIP) && this.displacementDescriptions.get((Object)slotToEquipInto).get((Object)DisplacementType.REMOVE_OR_EQUIP).containsKey((Object)DisplacementDescriptionType.REPLACEMENT)) {
                return UtilText.parse(clothingEquipper, clothingOwner, this.displacementDescriptions.get((Object)slotToEquipInto).get((Object)DisplacementType.REMOVE_OR_EQUIP).get((Object)DisplacementDescriptionType.REPLACEMENT), new ParserTag[0]);
            }
            return UtilText.parse(clothingEquipper, clothingOwner, "[npc.Name]\u7c97\u66b4\u5730\u5f3a\u8feb[npc2.name]\u88c5\u5907\u4e0a" + clothing.getName() + "\u3002", new ParserTag[0]);
        }
        try {
            if (clothingEquipper.isPlayer()) {
                if (clothingOwner.isPlayer()) {
                    if (this.displacementDescriptions != null && this.displacementDescriptions.get((Object)slotToEquipInto) != null && this.displacementDescriptions.get((Object)slotToEquipInto).containsKey((Object)DisplacementType.REMOVE_OR_EQUIP) && this.displacementDescriptions.get((Object)slotToEquipInto).get((Object)DisplacementType.REMOVE_OR_EQUIP).containsKey((Object)DisplacementDescriptionType.REPLACEMENT_SELF)) {
                        return this.displacementDescriptions.get((Object)slotToEquipInto).get((Object)DisplacementType.REMOVE_OR_EQUIP).get((Object)DisplacementDescriptionType.REPLACEMENT_SELF);
                    }
                    return "\u4f60\u88c5\u5907\u4e0a" + clothing.getName() + "\u3002";
                }
                if (rough) {
                    if (this.displacementDescriptions != null && this.displacementDescriptions.get((Object)slotToEquipInto) != null && this.displacementDescriptions.get((Object)slotToEquipInto).containsKey((Object)DisplacementType.REMOVE_OR_EQUIP) && this.displacementDescriptions.get((Object)slotToEquipInto).get((Object)DisplacementType.REMOVE_OR_EQUIP).containsKey((Object)DisplacementDescriptionType.REPLACEMENT_ROUGH)) {
                        return UtilText.parse(clothingOwner, this.displacementDescriptions.get((Object)slotToEquipInto).get((Object)DisplacementType.REMOVE_OR_EQUIP).get((Object)DisplacementDescriptionType.REPLACEMENT_ROUGH), new ParserTag[0]);
                    }
                    return UtilText.parse(clothingOwner, "\u4f60\u7c97\u66b4\u5730\u628a" + clothing.getName(true) + "\u5f3a\u884c\u88c5\u5907\u7ed9[npc.name]\u3002", new ParserTag[0]);
                }
                if (this.displacementDescriptions != null && this.displacementDescriptions.get((Object)slotToEquipInto) != null && this.displacementDescriptions.get((Object)slotToEquipInto).containsKey((Object)DisplacementType.REMOVE_OR_EQUIP) && this.displacementDescriptions.get((Object)slotToEquipInto).get((Object)DisplacementType.REMOVE_OR_EQUIP).containsKey((Object)DisplacementDescriptionType.REPLACEMENT)) {
                    return UtilText.parse(clothingOwner, this.displacementDescriptions.get((Object)slotToEquipInto).get((Object)DisplacementType.REMOVE_OR_EQUIP).get((Object)DisplacementDescriptionType.REPLACEMENT), new ParserTag[0]);
                }
                return UtilText.parse(clothingOwner, "\u4f60\u628a" + clothing.getName(true) + "\u7a7f\u5728[npc.name]\u8eab\u4e0a\u3002", new ParserTag[0]);
            }
            if (clothingOwner.isPlayer()) {
                if (rough) {
                    if (this.displacementDescriptions != null && this.displacementDescriptions.get((Object)slotToEquipInto) != null && this.displacementDescriptions.get((Object)slotToEquipInto).containsKey((Object)DisplacementType.REMOVE_OR_EQUIP) && this.displacementDescriptions.get((Object)slotToEquipInto).get((Object)DisplacementType.REMOVE_OR_EQUIP).containsKey((Object)DisplacementDescriptionType.REPLACEMENT_ROUGH)) {
                        return UtilText.parse(clothingEquipper, this.displacementDescriptions.get((Object)slotToEquipInto).get((Object)DisplacementType.REMOVE_OR_EQUIP).get((Object)DisplacementDescriptionType.REPLACEMENT_ROUGH), new ParserTag[0]);
                    }
                    return UtilText.parse(clothingEquipper, "[npc.Name]\u7c97\u66b4\u5730\u628a" + clothing.getName(true) + "\u5f3a\u884c\u88c5\u5907\u7ed9\u4f60\u3002", new ParserTag[0]);
                }
                if (this.displacementDescriptions != null && this.displacementDescriptions.get((Object)slotToEquipInto) != null && this.displacementDescriptions.get((Object)slotToEquipInto).containsKey((Object)DisplacementType.REMOVE_OR_EQUIP) && this.displacementDescriptions.get((Object)slotToEquipInto).get((Object)DisplacementType.REMOVE_OR_EQUIP).containsKey((Object)DisplacementDescriptionType.REPLACEMENT)) {
                    return UtilText.parse(clothingEquipper, this.displacementDescriptions.get((Object)slotToEquipInto).get((Object)DisplacementType.REMOVE_OR_EQUIP).get((Object)DisplacementDescriptionType.REPLACEMENT), new ParserTag[0]);
                }
                return UtilText.parse(clothingEquipper, "[npc.Name]\u628a" + clothing.getName(true) + "\u7a7f\u5728\u4f60\u8eab\u4e0a\u3002", new ParserTag[0]);
            }
            if (clothingOwner.equals(clothingEquipper)) {
                if (this.displacementDescriptions != null && this.displacementDescriptions.get((Object)slotToEquipInto) != null && this.displacementDescriptions.get((Object)slotToEquipInto).containsKey((Object)DisplacementType.REMOVE_OR_EQUIP) && this.displacementDescriptions.get((Object)slotToEquipInto).get((Object)DisplacementType.REMOVE_OR_EQUIP).containsKey((Object)DisplacementDescriptionType.REPLACEMENT_SELF)) {
                    return UtilText.parse(clothingOwner, this.displacementDescriptions.get((Object)slotToEquipInto).get((Object)DisplacementType.REMOVE_OR_EQUIP).get((Object)DisplacementDescriptionType.REPLACEMENT_SELF), new ParserTag[0]);
                }
                return UtilText.parse(clothingOwner, "[npc.Name]\u88c5\u5907\u4e86" + clothing.getName(true) + "\u3002", new ParserTag[0]);
            }
            if (rough) {
                if (this.displacementDescriptions != null && this.displacementDescriptions.get((Object)slotToEquipInto) != null && this.displacementDescriptions.get((Object)slotToEquipInto).containsKey((Object)DisplacementType.REMOVE_OR_EQUIP) && this.displacementDescriptions.get((Object)slotToEquipInto).get((Object)DisplacementType.REMOVE_OR_EQUIP).containsKey((Object)DisplacementDescriptionType.NPC_ON_NPC_REPLACEMENT_ROUGH)) {
                    return UtilText.parse(clothingEquipper, clothingOwner, this.displacementDescriptions.get((Object)slotToEquipInto).get((Object)DisplacementType.REMOVE_OR_EQUIP).get((Object)DisplacementDescriptionType.NPC_ON_NPC_REPLACEMENT_ROUGH), new ParserTag[0]);
                }
                return UtilText.parse(clothingEquipper, clothingOwner, "[npc.Name]\u7c97\u66b4\u5730\u903c\u8feb[npc2.name]\u88c5\u5907\u4e0a" + clothing.getName(true) + "\u3002", new ParserTag[0]);
            }
            if (this.displacementDescriptions != null && this.displacementDescriptions.get((Object)slotToEquipInto) != null && this.displacementDescriptions.get((Object)slotToEquipInto).containsKey((Object)DisplacementType.REMOVE_OR_EQUIP) && this.displacementDescriptions.get((Object)slotToEquipInto).get((Object)DisplacementType.REMOVE_OR_EQUIP).containsKey((Object)DisplacementDescriptionType.NPC_ON_NPC_REPLACEMENT)) {
                return UtilText.parse(clothingEquipper, clothingOwner, this.displacementDescriptions.get((Object)slotToEquipInto).get((Object)DisplacementType.REMOVE_OR_EQUIP).get((Object)DisplacementDescriptionType.NPC_ON_NPC_REPLACEMENT), new ParserTag[0]);
            }
            return UtilText.parse(clothingEquipper, clothingOwner, "[npc.Name]\u8ba9[npc2.name]\u88c5\u5907\u4e0a" + clothing.getName(true) + "\u3002", new ParserTag[0]);
        }
        catch (Exception ex) {
            System.err.println(this.getName() + " failed to generate equip text.");
            ex.printStackTrace();
            return "";
        }
    }

    public String unequipText(GameCharacter clothingOwner, GameCharacter clothingRemover, InventorySlot slotToUnequipFrom, boolean rough, AbstractClothing clothing, boolean applyEffects) {
        if (clothingOwner == null || clothingRemover == null) {
            return "";
        }
        if (this.displacementDescriptions != null && !this.displacementDescriptions.isEmpty()) {
            if (clothingOwner.equals(clothingRemover)) {
                if (this.displacementDescriptions.get((Object)slotToUnequipFrom) != null && this.displacementDescriptions.get((Object)slotToUnequipFrom).containsKey((Object)DisplacementType.REMOVE_OR_EQUIP) && this.displacementDescriptions.get((Object)slotToUnequipFrom).get((Object)DisplacementType.REMOVE_OR_EQUIP).containsKey((Object)DisplacementDescriptionType.DISPLACEMENT_SELF)) {
                    return UtilText.parse(clothingOwner, this.displacementDescriptions.get((Object)slotToUnequipFrom).get((Object)DisplacementType.REMOVE_OR_EQUIP).get((Object)DisplacementDescriptionType.DISPLACEMENT_SELF), new ParserTag[0]);
                }
                return UtilText.parse(clothingOwner, "[npc.Name]\u89e3\u9664\u4e86" + clothing.getName() + "\u7684\u88c5\u5907\u3002", new ParserTag[0]);
            }
            if (rough) {
                if (this.displacementDescriptions.get((Object)slotToUnequipFrom) != null && this.displacementDescriptions.get((Object)slotToUnequipFrom).containsKey((Object)DisplacementType.REMOVE_OR_EQUIP) && this.displacementDescriptions.get((Object)slotToUnequipFrom).get((Object)DisplacementType.REMOVE_OR_EQUIP).containsKey((Object)DisplacementDescriptionType.DISPLACEMENT_ROUGH)) {
                    return UtilText.parse(clothingRemover, clothingOwner, this.displacementDescriptions.get((Object)slotToUnequipFrom).get((Object)DisplacementType.REMOVE_OR_EQUIP).get((Object)DisplacementDescriptionType.DISPLACEMENT_ROUGH), new ParserTag[0]);
                }
                return UtilText.parse(clothingRemover, clothingOwner, "[npc.Name]\u7c97\u66b4\u5730\u89e3\u9664\u4e86[npc2.namePos]\u7684" + clothing.getName() + "\u3002", new ParserTag[0]);
            }
            if (this.displacementDescriptions.get((Object)slotToUnequipFrom) != null && this.displacementDescriptions.get((Object)slotToUnequipFrom).containsKey((Object)DisplacementType.REMOVE_OR_EQUIP) && this.displacementDescriptions.get((Object)slotToUnequipFrom).get((Object)DisplacementType.REMOVE_OR_EQUIP).containsKey((Object)DisplacementDescriptionType.DISPLACEMENT)) {
                return UtilText.parse(clothingRemover, clothingOwner, this.displacementDescriptions.get((Object)slotToUnequipFrom).get((Object)DisplacementType.REMOVE_OR_EQUIP).get((Object)DisplacementDescriptionType.DISPLACEMENT), new ParserTag[0]);
            }
            return UtilText.parse(clothingRemover, clothingOwner, "[npc.Name]\u8ba9[npc2.name]\u89e3\u9664\u4e86" + clothing.getName() + "\u7684\u88c5\u5907\u3002", new ParserTag[0]);
        }
        if (clothingRemover.isPlayer()) {
            if (clothingOwner.isPlayer()) {
                if (this.displacementDescriptions != null && this.displacementDescriptions.get((Object)slotToUnequipFrom) != null && this.displacementDescriptions.get((Object)slotToUnequipFrom).containsKey((Object)DisplacementType.REMOVE_OR_EQUIP) && this.displacementDescriptions.get((Object)slotToUnequipFrom).get((Object)DisplacementType.REMOVE_OR_EQUIP).containsKey((Object)DisplacementDescriptionType.DISPLACEMENT_SELF)) {
                    return this.displacementDescriptions.get((Object)slotToUnequipFrom).get((Object)DisplacementType.REMOVE_OR_EQUIP).get((Object)DisplacementDescriptionType.DISPLACEMENT_SELF);
                }
                return "\u4f60\u89e3\u9664\u4e86" + clothing.getName() + "\u7684\u88c5\u5907\u3002";
            }
            if (rough) {
                if (this.displacementDescriptions != null && this.displacementDescriptions.get((Object)slotToUnequipFrom) != null && this.displacementDescriptions.get((Object)slotToUnequipFrom).containsKey((Object)DisplacementType.REMOVE_OR_EQUIP) && this.displacementDescriptions.get((Object)slotToUnequipFrom).get((Object)DisplacementType.REMOVE_OR_EQUIP).containsKey((Object)DisplacementDescriptionType.DISPLACEMENT_ROUGH)) {
                    return UtilText.parse(clothingOwner, this.displacementDescriptions.get((Object)slotToUnequipFrom).get((Object)DisplacementType.REMOVE_OR_EQUIP).get((Object)DisplacementDescriptionType.DISPLACEMENT_ROUGH), new ParserTag[0]);
                }
                return UtilText.parse(clothingOwner, "\u4f60\u7c97\u66b4\u5730\u8131\u4e0b" + clothing.getName() + "\u3002", new ParserTag[0]);
            }
            if (this.displacementDescriptions != null && this.displacementDescriptions.get((Object)slotToUnequipFrom) != null && this.displacementDescriptions.get((Object)slotToUnequipFrom).containsKey((Object)DisplacementType.REMOVE_OR_EQUIP) && this.displacementDescriptions.get((Object)slotToUnequipFrom).get((Object)DisplacementType.REMOVE_OR_EQUIP).containsKey((Object)DisplacementDescriptionType.DISPLACEMENT)) {
                return UtilText.parse(clothingOwner, this.displacementDescriptions.get((Object)slotToUnequipFrom).get((Object)DisplacementType.REMOVE_OR_EQUIP).get((Object)DisplacementDescriptionType.DISPLACEMENT), new ParserTag[0]);
            }
            return UtilText.parse(clothingOwner, "\u4f60\u8131\u4e0b" + clothing.getName() + "\u3002", new ParserTag[0]);
        }
        if (clothingOwner.isPlayer()) {
            if (rough) {
                if (this.displacementDescriptions != null && this.displacementDescriptions.get((Object)slotToUnequipFrom) != null && this.displacementDescriptions.get((Object)slotToUnequipFrom).containsKey((Object)DisplacementType.REMOVE_OR_EQUIP) && this.displacementDescriptions.get((Object)slotToUnequipFrom).get((Object)DisplacementType.REMOVE_OR_EQUIP).containsKey((Object)DisplacementDescriptionType.DISPLACEMENT_ROUGH)) {
                    return UtilText.parse(clothingRemover, this.displacementDescriptions.get((Object)slotToUnequipFrom).get((Object)DisplacementType.REMOVE_OR_EQUIP).get((Object)DisplacementDescriptionType.DISPLACEMENT_ROUGH), new ParserTag[0]);
                }
                return UtilText.parse(clothingRemover, "[npc.Name]\u7c97\u66b4\u5730\u8131\u4e0b\u4f60\u7684" + clothing.getName() + "\u3002", new ParserTag[0]);
            }
            if (this.displacementDescriptions != null && this.displacementDescriptions.get((Object)slotToUnequipFrom) != null && this.displacementDescriptions.get((Object)slotToUnequipFrom).containsKey((Object)DisplacementType.REMOVE_OR_EQUIP) && this.displacementDescriptions.get((Object)slotToUnequipFrom).get((Object)DisplacementType.REMOVE_OR_EQUIP).containsKey((Object)DisplacementDescriptionType.DISPLACEMENT)) {
                return UtilText.parse(clothingRemover, this.displacementDescriptions.get((Object)slotToUnequipFrom).get((Object)DisplacementType.REMOVE_OR_EQUIP).get((Object)DisplacementDescriptionType.DISPLACEMENT), new ParserTag[0]);
            }
            return UtilText.parse(clothingRemover, "[npc.Name]\u8131\u4e0b\u4f60\u7684" + clothing.getName() + "\u3002", new ParserTag[0]);
        }
        if (clothingOwner.equals(clothingRemover)) {
            if (this.displacementDescriptions != null && this.displacementDescriptions.get((Object)slotToUnequipFrom) != null && this.displacementDescriptions.get((Object)slotToUnequipFrom).containsKey((Object)DisplacementType.REMOVE_OR_EQUIP) && this.displacementDescriptions.get((Object)slotToUnequipFrom).get((Object)DisplacementType.REMOVE_OR_EQUIP).containsKey((Object)DisplacementDescriptionType.DISPLACEMENT_SELF)) {
                return UtilText.parse(clothingOwner, this.displacementDescriptions.get((Object)slotToUnequipFrom).get((Object)DisplacementType.REMOVE_OR_EQUIP).get((Object)DisplacementDescriptionType.DISPLACEMENT_SELF), new ParserTag[0]);
            }
            return UtilText.parse(clothingOwner, "[npc.Name]\u89e3\u9664\u4e86" + clothing.getName() + "\u7684\u88c5\u5907\u3002", new ParserTag[0]);
        }
        if (rough) {
            if (this.displacementDescriptions != null && this.displacementDescriptions.get((Object)slotToUnequipFrom) != null && this.displacementDescriptions.get((Object)slotToUnequipFrom).containsKey((Object)DisplacementType.REMOVE_OR_EQUIP) && this.displacementDescriptions.get((Object)slotToUnequipFrom).get((Object)DisplacementType.REMOVE_OR_EQUIP).containsKey((Object)DisplacementDescriptionType.NPC_ON_NPC_DISPLACEMENT_ROUGH)) {
                return UtilText.parse(clothingRemover, clothingOwner, this.displacementDescriptions.get((Object)slotToUnequipFrom).get((Object)DisplacementType.REMOVE_OR_EQUIP).get((Object)DisplacementDescriptionType.NPC_ON_NPC_DISPLACEMENT_ROUGH), new ParserTag[0]);
            }
            return UtilText.parse(clothingRemover, clothingOwner, "[npc.Name]\u7c97\u66b4\u5730\u5f3a\u8feb[npc2.name]\u88c5\u5907\u4e0a" + clothing.getName(true) + "\u3002", new ParserTag[0]);
        }
        if (this.displacementDescriptions != null && this.displacementDescriptions.get((Object)slotToUnequipFrom) != null && this.displacementDescriptions.get((Object)slotToUnequipFrom).containsKey((Object)DisplacementType.REMOVE_OR_EQUIP) && this.displacementDescriptions.get((Object)slotToUnequipFrom).get((Object)DisplacementType.REMOVE_OR_EQUIP).containsKey((Object)DisplacementDescriptionType.NPC_ON_NPC_DISPLACEMENT)) {
            return UtilText.parse(clothingRemover, clothingOwner, this.displacementDescriptions.get((Object)slotToUnequipFrom).get((Object)DisplacementType.REMOVE_OR_EQUIP).get((Object)DisplacementDescriptionType.NPC_ON_NPC_DISPLACEMENT), new ParserTag[0]);
        }
        return UtilText.parse(clothingRemover, clothingOwner, "[npc.Name]\u8ba9[npc2.name]\u88c5\u5907\u4e0a" + clothing.getName(true) + "\u3002", new ParserTag[0]);
    }

    public String displaceText(GameCharacter clothingOwner, GameCharacter clothingRemover, InventorySlot slotClothingIsEquippedTo, DisplacementType dt, boolean rough) {
        if (clothingOwner == null || clothingRemover == null) {
            return "";
        }
        if (this.displacementDescriptions != null && !this.displacementDescriptions.isEmpty()) {
            if (clothingOwner.equals(clothingRemover)) {
                if (this.displacementDescriptions.get((Object)slotClothingIsEquippedTo) != null && this.displacementDescriptions.get((Object)slotClothingIsEquippedTo).containsKey((Object)dt) && this.displacementDescriptions.get((Object)slotClothingIsEquippedTo).get((Object)dt).containsKey((Object)DisplacementDescriptionType.DISPLACEMENT_SELF)) {
                    return UtilText.parse(clothingOwner, this.displacementDescriptions.get((Object)slotClothingIsEquippedTo).get((Object)dt).get((Object)DisplacementDescriptionType.DISPLACEMENT_SELF), new ParserTag[0]);
                }
                return UtilText.parse(clothingOwner, "[npc.Name]" + (clothingRemover.isPlayer() ? dt.getDescription() : dt.getDescriptionThirdPerson()) + "[npc.her]" + this.getName() + "\u3002", new ParserTag[0]);
            }
            if (rough) {
                if (this.displacementDescriptions.get((Object)slotClothingIsEquippedTo) != null && this.displacementDescriptions.get((Object)slotClothingIsEquippedTo).containsKey((Object)dt) && this.displacementDescriptions.get((Object)slotClothingIsEquippedTo).get((Object)dt).containsKey((Object)DisplacementDescriptionType.DISPLACEMENT_ROUGH)) {
                    return UtilText.parse(clothingRemover, clothingOwner, this.displacementDescriptions.get((Object)slotClothingIsEquippedTo).get((Object)dt).get((Object)DisplacementDescriptionType.DISPLACEMENT_ROUGH), new ParserTag[0]);
                }
                return UtilText.parse(clothingRemover, clothingOwner, "[npc.Name]\u7c97\u66b4\u5730" + (clothingRemover.isPlayer() ? dt.getDescription() : dt.getDescriptionThirdPerson()) + "[npc2.namePos]" + this.getName() + "\u3002", new ParserTag[0]);
            }
            if (this.displacementDescriptions.get((Object)slotClothingIsEquippedTo) != null && this.displacementDescriptions.get((Object)slotClothingIsEquippedTo).containsKey((Object)dt) && this.displacementDescriptions.get((Object)slotClothingIsEquippedTo).get((Object)dt).containsKey((Object)DisplacementDescriptionType.DISPLACEMENT)) {
                return UtilText.parse(clothingRemover, clothingOwner, this.displacementDescriptions.get((Object)slotClothingIsEquippedTo).get((Object)dt).get((Object)DisplacementDescriptionType.DISPLACEMENT), new ParserTag[0]);
            }
            return UtilText.parse(clothingRemover, clothingOwner, "[npc.Name]" + (clothingRemover.isPlayer() ? dt.getDescription() : dt.getDescriptionThirdPerson()) + "[npc2.namePos]" + this.getName() + "\u3002", new ParserTag[0]);
        }
        if (clothingRemover.isPlayer()) {
            if (clothingOwner.isPlayer()) {
                if (this.displacementDescriptions != null && this.displacementDescriptions.get((Object)slotClothingIsEquippedTo) != null && this.displacementDescriptions.get((Object)slotClothingIsEquippedTo).containsKey((Object)dt) && this.displacementDescriptions.get((Object)slotClothingIsEquippedTo).get((Object)dt).containsKey((Object)DisplacementDescriptionType.DISPLACEMENT_SELF)) {
                    return this.displacementDescriptions.get((Object)slotClothingIsEquippedTo).get((Object)dt).get((Object)DisplacementDescriptionType.DISPLACEMENT_SELF);
                }
                return "\u4f60" + dt.getDescription() + this.getName() + "\u3002";
            }
            if (rough) {
                if (this.displacementDescriptions != null && this.displacementDescriptions.get((Object)slotClothingIsEquippedTo) != null && this.displacementDescriptions.get((Object)slotClothingIsEquippedTo).containsKey((Object)dt) && this.displacementDescriptions.get((Object)slotClothingIsEquippedTo).get((Object)dt).containsKey((Object)DisplacementDescriptionType.DISPLACEMENT_ROUGH)) {
                    return UtilText.parse(clothingOwner, this.displacementDescriptions.get((Object)slotClothingIsEquippedTo).get((Object)dt).get((Object)DisplacementDescriptionType.DISPLACEMENT_ROUGH), new ParserTag[0]);
                }
                return UtilText.parse(clothingOwner, "\u4f60\u7c97\u66b4\u5730" + dt.getDescription() + "[npc.namePos]" + this.getName() + "\u3002", new ParserTag[0]);
            }
            if (this.displacementDescriptions != null && this.displacementDescriptions.get((Object)slotClothingIsEquippedTo) != null && this.displacementDescriptions.get((Object)slotClothingIsEquippedTo).containsKey((Object)dt) && this.displacementDescriptions.get((Object)slotClothingIsEquippedTo).get((Object)dt).containsKey((Object)DisplacementDescriptionType.DISPLACEMENT)) {
                return UtilText.parse(clothingOwner, this.displacementDescriptions.get((Object)slotClothingIsEquippedTo).get((Object)dt).get((Object)DisplacementDescriptionType.DISPLACEMENT), new ParserTag[0]);
            }
            return UtilText.parse(clothingOwner, "\u4f60" + dt.getDescription() + "[npc.namePos]" + this.getName() + "\u3002", new ParserTag[0]);
        }
        if (clothingOwner.isPlayer()) {
            if (rough) {
                if (this.displacementDescriptions != null && this.displacementDescriptions.get((Object)slotClothingIsEquippedTo) != null && this.displacementDescriptions.get((Object)slotClothingIsEquippedTo).containsKey((Object)dt) && this.displacementDescriptions.get((Object)slotClothingIsEquippedTo).get((Object)dt).containsKey((Object)DisplacementDescriptionType.DISPLACEMENT_ROUGH)) {
                    return UtilText.parse(clothingRemover, this.displacementDescriptions.get((Object)slotClothingIsEquippedTo).get((Object)dt).get((Object)DisplacementDescriptionType.DISPLACEMENT_ROUGH), new ParserTag[0]);
                }
                return UtilText.parse(clothingRemover, "[npc.Name]\u7c97\u66b4\u5730" + dt.getDescriptionThirdPerson() + "\u4f60\u7684" + this.getName() + "\u3002", new ParserTag[0]);
            }
            if (this.displacementDescriptions != null && this.displacementDescriptions.get((Object)slotClothingIsEquippedTo) != null && this.displacementDescriptions.get((Object)slotClothingIsEquippedTo).containsKey((Object)dt) && this.displacementDescriptions.get((Object)slotClothingIsEquippedTo).get((Object)dt).containsKey((Object)DisplacementDescriptionType.DISPLACEMENT)) {
                return UtilText.parse(clothingRemover, this.displacementDescriptions.get((Object)slotClothingIsEquippedTo).get((Object)dt).get((Object)DisplacementDescriptionType.DISPLACEMENT), new ParserTag[0]);
            }
            return UtilText.parse(clothingRemover, "[npc.Name]" + dt.getDescriptionThirdPerson() + "\u4f60\u7684" + this.getName() + "\u3002", new ParserTag[0]);
        }
        if (clothingOwner.equals(clothingRemover)) {
            if (this.displacementDescriptions != null && this.displacementDescriptions.get((Object)slotClothingIsEquippedTo) != null && this.displacementDescriptions.get((Object)slotClothingIsEquippedTo).containsKey((Object)dt) && this.displacementDescriptions.get((Object)slotClothingIsEquippedTo).get((Object)dt).containsKey((Object)DisplacementDescriptionType.DISPLACEMENT_SELF)) {
                return UtilText.parse(clothingRemover, this.displacementDescriptions.get((Object)slotClothingIsEquippedTo).get((Object)dt).get((Object)DisplacementDescriptionType.DISPLACEMENT_SELF), new ParserTag[0]);
            }
            return UtilText.parse(clothingOwner, "[npc.Name]" + dt.getDescriptionThirdPerson() + "[npc.her]\u7684" + this.getName() + "\u3002", new ParserTag[0]);
        }
        if (rough) {
            if (this.displacementDescriptions != null && this.displacementDescriptions.get((Object)slotClothingIsEquippedTo) != null && this.displacementDescriptions.get((Object)slotClothingIsEquippedTo).containsKey((Object)dt) && this.displacementDescriptions.get((Object)slotClothingIsEquippedTo).get((Object)dt).containsKey((Object)DisplacementDescriptionType.NPC_ON_NPC_DISPLACEMENT_ROUGH)) {
                return UtilText.parse(clothingRemover, clothingOwner, this.displacementDescriptions.get((Object)slotClothingIsEquippedTo).get((Object)dt).get((Object)DisplacementDescriptionType.NPC_ON_NPC_DISPLACEMENT_ROUGH), new ParserTag[0]);
            }
            return UtilText.parse(clothingRemover, clothingOwner, "[npc.Name]\u7c97\u66b4\u5730 " + dt.getDescriptionThirdPerson() + "[npc2.namePos]" + this.getName() + "\u3002", new ParserTag[0]);
        }
        if (this.displacementDescriptions != null && this.displacementDescriptions.get((Object)slotClothingIsEquippedTo) != null && this.displacementDescriptions.get((Object)slotClothingIsEquippedTo).containsKey((Object)dt) && this.displacementDescriptions.get((Object)slotClothingIsEquippedTo).get((Object)dt).containsKey((Object)DisplacementDescriptionType.NPC_ON_NPC_DISPLACEMENT)) {
            return UtilText.parse(clothingRemover, clothingOwner, this.displacementDescriptions.get((Object)slotClothingIsEquippedTo).get((Object)dt).get((Object)DisplacementDescriptionType.NPC_ON_NPC_DISPLACEMENT), new ParserTag[0]);
        }
        return UtilText.parse(clothingRemover, clothingOwner, "[npc.Name]" + dt.getDescriptionThirdPerson() + "[npc2.namePos]" + this.getName() + "\u3002", new ParserTag[0]);
    }

    public String replaceText(GameCharacter clothingOwner, GameCharacter clothingRemover, InventorySlot slotClothingIsEquippedTo, DisplacementType dt, boolean rough) {
        if (clothingOwner == null || clothingRemover == null) {
            return "";
        }
        if (this.displacementDescriptions != null && !this.displacementDescriptions.isEmpty()) {
            if (clothingOwner.equals(clothingRemover)) {
                if (this.displacementDescriptions.get((Object)slotClothingIsEquippedTo) != null && this.displacementDescriptions.get((Object)slotClothingIsEquippedTo).containsKey((Object)dt) && this.displacementDescriptions.get((Object)slotClothingIsEquippedTo).get((Object)dt).containsKey((Object)DisplacementDescriptionType.REPLACEMENT_SELF)) {
                    return UtilText.parse(clothingOwner, this.displacementDescriptions.get((Object)slotClothingIsEquippedTo).get((Object)dt).get((Object)DisplacementDescriptionType.REPLACEMENT_SELF), new ParserTag[0]);
                }
                return UtilText.parse(clothingOwner, "[npc.Name]" + (clothingRemover.isPlayer() ? dt.getOppositeDescription() : dt.getOppositeDescriptionThirdPerson()) + "[npc.her]\u7684" + this.getName() + "\u3002", new ParserTag[0]);
            }
            if (rough) {
                if (this.displacementDescriptions.get((Object)slotClothingIsEquippedTo) != null && this.displacementDescriptions.get((Object)slotClothingIsEquippedTo).containsKey((Object)dt) && this.displacementDescriptions.get((Object)slotClothingIsEquippedTo).get((Object)dt).containsKey((Object)DisplacementDescriptionType.REPLACEMENT_ROUGH)) {
                    return UtilText.parse(clothingRemover, clothingOwner, this.displacementDescriptions.get((Object)slotClothingIsEquippedTo).get((Object)dt).get((Object)DisplacementDescriptionType.REPLACEMENT_ROUGH), new ParserTag[0]);
                }
                return UtilText.parse(clothingRemover, clothingOwner, "[npc.Name]" + (clothingRemover.isPlayer() ? dt.getOppositeDescription() : dt.getOppositeDescriptionThirdPerson()) + "[npc2.namePos]" + this.getName() + "\u3002", new ParserTag[0]);
            }
            if (this.displacementDescriptions.get((Object)slotClothingIsEquippedTo) != null && this.displacementDescriptions.get((Object)slotClothingIsEquippedTo).containsKey((Object)dt) && this.displacementDescriptions.get((Object)slotClothingIsEquippedTo).get((Object)dt).containsKey((Object)DisplacementDescriptionType.REPLACEMENT)) {
                return UtilText.parse(clothingRemover, clothingOwner, this.displacementDescriptions.get((Object)slotClothingIsEquippedTo).get((Object)dt).get((Object)DisplacementDescriptionType.REPLACEMENT), new ParserTag[0]);
            }
            return UtilText.parse(clothingRemover, clothingOwner, "[npc.Name]\u7c97\u66b4\u5730" + (clothingRemover.isPlayer() ? dt.getOppositeDescription() : dt.getOppositeDescriptionThirdPerson()) + "[npc2.namePos]" + this.getName() + "\u3002", new ParserTag[0]);
        }
        if (clothingRemover.isPlayer()) {
            if (clothingOwner.isPlayer()) {
                if (this.displacementDescriptions != null && this.displacementDescriptions.get((Object)slotClothingIsEquippedTo) != null && this.displacementDescriptions.get((Object)slotClothingIsEquippedTo).containsKey((Object)dt) && this.displacementDescriptions.get((Object)slotClothingIsEquippedTo).get((Object)dt).containsKey((Object)DisplacementDescriptionType.REPLACEMENT_SELF)) {
                    return this.displacementDescriptions.get((Object)slotClothingIsEquippedTo).get((Object)dt).get((Object)DisplacementDescriptionType.REPLACEMENT_SELF);
                }
                return "\u4f60" + dt.getOppositeDescription() + this.getName() + "\u3002";
            }
            if (rough) {
                if (this.displacementDescriptions != null && this.displacementDescriptions.get((Object)slotClothingIsEquippedTo) != null && this.displacementDescriptions.get((Object)slotClothingIsEquippedTo).containsKey((Object)dt) && this.displacementDescriptions.get((Object)slotClothingIsEquippedTo).get((Object)dt).containsKey((Object)DisplacementDescriptionType.REPLACEMENT_ROUGH)) {
                    return UtilText.parse(clothingOwner, this.displacementDescriptions.get((Object)slotClothingIsEquippedTo).get((Object)dt).get((Object)DisplacementDescriptionType.REPLACEMENT_ROUGH), new ParserTag[0]);
                }
                return UtilText.parse(clothingOwner, "\u4f60\u7c97\u66b4\u5730" + dt.getOppositeDescription() + "[npc.namePos]" + this.getName() + "\u3002", new ParserTag[0]);
            }
            if (this.displacementDescriptions != null && this.displacementDescriptions.get((Object)slotClothingIsEquippedTo) != null && this.displacementDescriptions.get((Object)slotClothingIsEquippedTo).containsKey((Object)dt) && this.displacementDescriptions.get((Object)slotClothingIsEquippedTo).get((Object)dt).containsKey((Object)DisplacementDescriptionType.REPLACEMENT)) {
                return UtilText.parse(clothingOwner, this.displacementDescriptions.get((Object)slotClothingIsEquippedTo).get((Object)dt).get((Object)DisplacementDescriptionType.REPLACEMENT), new ParserTag[0]);
            }
            return UtilText.parse(clothingOwner, "\u4f60" + dt.getOppositeDescription() + "[npc.namePos]" + this.getName() + "\u3002", new ParserTag[0]);
        }
        if (clothingOwner.isPlayer()) {
            if (rough) {
                if (this.displacementDescriptions != null && this.displacementDescriptions.get((Object)slotClothingIsEquippedTo) != null && this.displacementDescriptions.get((Object)slotClothingIsEquippedTo).containsKey((Object)dt) && this.displacementDescriptions.get((Object)slotClothingIsEquippedTo).get((Object)dt).containsKey((Object)DisplacementDescriptionType.REPLACEMENT_ROUGH)) {
                    return UtilText.parse(clothingRemover, this.displacementDescriptions.get((Object)slotClothingIsEquippedTo).get((Object)dt).get((Object)DisplacementDescriptionType.REPLACEMENT_ROUGH), new ParserTag[0]);
                }
                return UtilText.parse(clothingRemover, "[npc.Name]\u7c97\u66b4\u5730" + dt.getOppositeDescriptionThirdPerson() + "\u4f60\u7684" + this.getName() + "\u3002", new ParserTag[0]);
            }
            if (this.displacementDescriptions != null && this.displacementDescriptions.get((Object)slotClothingIsEquippedTo) != null && this.displacementDescriptions.get((Object)slotClothingIsEquippedTo).containsKey((Object)dt) && this.displacementDescriptions.get((Object)slotClothingIsEquippedTo).get((Object)dt).containsKey((Object)DisplacementDescriptionType.REPLACEMENT)) {
                return UtilText.parse(clothingRemover, this.displacementDescriptions.get((Object)slotClothingIsEquippedTo).get((Object)dt).get((Object)DisplacementDescriptionType.REPLACEMENT), new ParserTag[0]);
            }
            return UtilText.parse(clothingRemover, "[npc.Name]" + dt.getOppositeDescriptionThirdPerson() + "\u4f60\u7684" + this.getName() + "\u3002", new ParserTag[0]);
        }
        if (clothingOwner.equals(clothingRemover)) {
            if (this.displacementDescriptions != null && this.displacementDescriptions.get((Object)slotClothingIsEquippedTo) != null && this.displacementDescriptions.get((Object)slotClothingIsEquippedTo).containsKey((Object)dt) && this.displacementDescriptions.get((Object)slotClothingIsEquippedTo).get((Object)dt).containsKey((Object)DisplacementDescriptionType.REPLACEMENT_SELF)) {
                return UtilText.parse(clothingRemover, this.displacementDescriptions.get((Object)slotClothingIsEquippedTo).get((Object)dt).get((Object)DisplacementDescriptionType.REPLACEMENT_SELF), new ParserTag[0]);
            }
            return UtilText.parse(clothingOwner, "[npc.Name]" + dt.getOppositeDescriptionThirdPerson() + "[npc.her]" + this.getName() + "\u3002", new ParserTag[0]);
        }
        if (rough) {
            if (this.displacementDescriptions != null && this.displacementDescriptions.get((Object)slotClothingIsEquippedTo) != null && this.displacementDescriptions.get((Object)slotClothingIsEquippedTo).containsKey((Object)dt) && this.displacementDescriptions.get((Object)slotClothingIsEquippedTo).get((Object)dt).containsKey((Object)DisplacementDescriptionType.NPC_ON_NPC_REPLACEMENT_ROUGH)) {
                return UtilText.parse(clothingRemover, clothingOwner, this.displacementDescriptions.get((Object)slotClothingIsEquippedTo).get((Object)dt).get((Object)DisplacementDescriptionType.NPC_ON_NPC_REPLACEMENT_ROUGH), new ParserTag[0]);
            }
            return UtilText.parse(clothingRemover, clothingOwner, "[npc.Name]\u7c97\u66b4\u5730" + dt.getOppositeDescriptionThirdPerson() + "[npc2.namePos]" + this.getName() + "\u3002", new ParserTag[0]);
        }
        if (this.displacementDescriptions != null && this.displacementDescriptions.get((Object)slotClothingIsEquippedTo) != null && this.displacementDescriptions.get((Object)slotClothingIsEquippedTo).containsKey((Object)dt) && this.displacementDescriptions.get((Object)slotClothingIsEquippedTo).get((Object)dt).containsKey((Object)DisplacementDescriptionType.NPC_ON_NPC_REPLACEMENT)) {
            return UtilText.parse(clothingRemover, clothingOwner, this.displacementDescriptions.get((Object)slotClothingIsEquippedTo).get((Object)dt).get((Object)DisplacementDescriptionType.NPC_ON_NPC_REPLACEMENT), new ParserTag[0]);
        }
        return UtilText.parse(clothingRemover, clothingOwner, "[npc.Name]" + dt.getOppositeDescriptionThirdPerson() + "[npc2.namePos]" + this.getName() + "\u3002", new ParserTag[0]);
    }

    public boolean isAppendColourName() {
        return this.appendColourName;
    }

    public boolean isAppendEnchantmentPostfix() {
        return this.appendEnchantmentPostfix;
    }

    public String getDeterminer() {
        return this.determiner;
    }

    public Boolean isPlural() {
        return this.plural;
    }

    public String getName() {
        if (this.isPlural().booleanValue()) {
            return this.namePlural;
        }
        return this.name;
    }

    public String getNamePlural() {
        return this.namePlural;
    }

    public String getDescription() {
        return this.description;
    }

    public String getAuthorDescription() {
        return this.authorDescription;
    }

    public int getFemininityMinimum() {
        if (Main.getProperties().getClothingFemininityLevel() == 0 || Main.getProperties().getClothingFemininityLevel() == 1 && this.femininityMinimum > 0) {
            return 0;
        }
        return this.femininityMinimum;
    }

    public int getFemininityMaximum() {
        if (Main.getProperties().getClothingFemininityLevel() == 0 || Main.getProperties().getClothingFemininityLevel() == 2 && this.femininityMinimum < 100) {
            return 100;
        }
        return this.femininityMaximum;
    }

    public Femininity getFemininityRestriction() {
        if (Main.getProperties().getClothingFemininityLevel() == 0 || Main.getProperties().getClothingFemininityLevel() == 1 && this.femininityRestriction == Femininity.FEMININE || Main.getProperties().getClothingFemininityLevel() == 2 && this.femininityRestriction == Femininity.MASCULINE) {
            return Femininity.ANDROGYNOUS;
        }
        return this.femininityRestriction;
    }

    public Femininity getCoreFemininityRestriction() {
        return this.femininityRestriction;
    }

    @Deprecated
    public InventorySlot getSlot() {
        return this.equipSlots.get(0);
    }

    public List<InventorySlot> getEquipSlots() {
        return this.equipSlots;
    }

    public boolean isConcealsSlot(GameCharacter character, InventorySlot slotToCheck) {
        return Main.game.getItemGen().generateClothing(this, false).isConcealsSlot(character, this.getEquipSlots().get(0), slotToCheck);
    }

    public boolean isConcealsCoverableArea(GameCharacter character, CoverableArea area) {
        return Main.game.getItemGen().generateClothing(this, false).isConcealsCoverableArea(character, this.getEquipSlots().get(0), area);
    }

    public String getPathName() {
        return this.pathName;
    }

    public String getPathNameEquipped(GameCharacter characterEquippedTo, InventorySlot invSlot) {
        if (this.pathNameEquipped.get((Object)invSlot) == null) {
            return null;
        }
        String parsedPath = UtilText.parse(characterEquippedTo, this.pathNameEquipped.get((Object)invSlot), new ParserTag[0]).trim();
        if (parsedPath.isEmpty()) {
            return null;
        }
        return this.pathNamePrefix + parsedPath;
    }

    public AbstractSetBonus getClothingSet() {
        return this.clothingSet;
    }

    public ColourReplacement getColourReplacement(int index) {
        if (index > this.colourReplacements.size() - 1) {
            return null;
        }
        return this.colourReplacements.get(index);
    }

    public List<ColourReplacement> getColourReplacements() {
        return this.colourReplacements;
    }

    private static String generateIdentifier(InventorySlot slotEquippedTo, List<Colour> colours, String pattern, List<Colour> patternColours, Map<String, String> stickers) {
        return AbstractClothingType.generateIdentifier(null, slotEquippedTo, colours, pattern, patternColours, stickers);
    }

    private static String generateIdentifier(GameCharacter character, InventorySlot slotEquippedTo, List<Colour> colours, String pattern, List<Colour> patternColours, Map<String, String> stickers) {
        StringBuilder sb = new StringBuilder(slotEquippedTo.toString());
        if (character != null) {
            sb.append(character.getId());
        }
        for (Colour colour : colours) {
            sb.append(colour.getId());
        }
        if (pattern == null) {
            sb.append("\u65e0\u8303\u5f0f");
        } else {
            sb.append(pattern);
        }
        for (Colour colour : patternColours) {
            sb.append(colour.getId());
        }
        if (stickers == null || stickers.isEmpty()) {
            sb.append("\u65e0\u6807\u7b7e");
        } else {
            for (Map.Entry entry : stickers.entrySet()) {
                sb.append((String)entry.getKey() + (String)entry.getValue());
            }
        }
        return sb.toString();
    }

    private void addSVGStringMapping(InventorySlot slotEquippedTo, List<Colour> colours, String pattern, List<Colour> patternColours, Map<String, String> stickers, String svgString) {
        this.SVGStringMap.put(AbstractClothingType.generateIdentifier(slotEquippedTo, colours, pattern, patternColours, stickers), svgString);
    }

    private void addSVGStringEquippedMapping(InventorySlot slotEquippedTo, List<Colour> colours, String pattern, List<Colour> patternColours, Map<String, String> stickers, String svgString) {
        this.SVGStringEquippedMap.put(AbstractClothingType.generateIdentifier(slotEquippedTo, colours, pattern, patternColours, stickers), svgString);
    }

    private String getSVGStringFromMap(InventorySlot slotEquippedTo, List<Colour> colours, String pattern, List<Colour> patternColours, Map<String, String> stickers) {
        return this.SVGStringMap.get(AbstractClothingType.generateIdentifier(slotEquippedTo, colours, pattern, patternColours, stickers));
    }

    private String getSVGStringFromEquippedMap(GameCharacter character, InventorySlot slotEquippedTo, List<Colour> colours, String pattern, List<Colour> patternColours, Map<String, String> stickers) {
        return this.SVGStringEquippedMap.get(AbstractClothingType.generateIdentifier(character, slotEquippedTo, colours, pattern, patternColours, stickers));
    }

    public String getSVGImage() {
        ArrayList<Colour> colours = new ArrayList<Colour>();
        for (ColourReplacement cr : this.getColourReplacements()) {
            colours.add(cr.getFirstOfDefaultColours());
        }
        return this.getSVGImage(null, this.getEquipSlots().get(0), colours, false, null, new ArrayList<Colour>(), null);
    }

    public String getSVGImage(InventorySlot slotEquippedTo) {
        ArrayList<Colour> colours = new ArrayList<Colour>();
        for (ColourReplacement cr : this.getColourReplacements()) {
            colours.add(cr.getFirstOfDefaultColours());
        }
        return this.getSVGImage(null, slotEquippedTo, colours, false, null, new ArrayList<Colour>(), null);
    }

    public String getSVGImageRandomColour(boolean randomPrimary, boolean randomSecondary, boolean randomTertiary) {
        return this.getSVGImageRandomColour(this.getEquipSlots().get(0), randomPrimary, randomSecondary, randomTertiary);
    }

    public String getSVGImageRandomColour(InventorySlot slotEquippedTo, boolean randomPrimary, boolean randomSecondary, boolean randomTertiary) {
        ArrayList<Colour> colours = new ArrayList<Colour>();
        for (int i = 0; i < this.getColourReplacements().size(); ++i) {
            ColourReplacement cr = this.getColourReplacements().get(i);
            if (i == 0 && randomPrimary || i == 1 && randomPrimary || i == 2 && randomTertiary) {
                colours.add(cr.getRandomOfDefaultColours());
                continue;
            }
            colours.add(cr.getFirstOfDefaultColours());
        }
        return this.getSVGImage(null, slotEquippedTo, colours, false, null, new ArrayList<Colour>(), null);
    }

    public String getSVGImage(InventorySlot slotEquippedTo, List<Colour> colours, String pattern, List<Colour> patternColours, Map<String, String> stickers) {
        return this.getSVGImage(null, slotEquippedTo, colours, false, pattern, patternColours, stickers);
    }

    public String getSVGEquippedImage(GameCharacter character, InventorySlot slotEquippedTo, List<Colour> colours, String pattern, List<Colour> patternColours, Map<String, String> stickers) {
        return this.getSVGImage(character, slotEquippedTo, colours, true, pattern, patternColours, stickers);
    }

    /*
     * WARNING - void declaration
     */
    private String getSVGImage(GameCharacter character, InventorySlot slotEquippedTo, List<Colour> colours, boolean equippedVariant, String pattern, List<Colour> patternColours, Map<String, String> stickers) {
        if (stickers == null) {
            stickers = new HashMap<String, String>();
            for (Map.Entry<StickerCategory, List<Sticker>> entry : this.getStickers().entrySet()) {
                void var10_11;
                if (stickers.containsKey(entry.getKey().getId())) continue;
                Object var10_12 = null;
                for (Sticker sticker : entry.getValue()) {
                    if (var10_11 != null && !sticker.isDefaultSticker()) continue;
                    Sticker sticker2 = sticker;
                }
                if (var10_11 == null) continue;
                stickers.put(entry.getKey().getId(), var10_11.getId());
            }
        }
        if (this.equals(ClothingType.HIPS_CONDOMS)) {
            if (!colours.isEmpty()) {
                try {
                    InputStream is = this.getClass().getResourceAsStream("/com/lilithsthrone/res/clothing/belt_used_condoms_base_back.svg");
                    Object s = "<div style='width:100%;height:100%;position:absolute;left:0;bottom:0;padding:0;margin:0'>" + Util.inputStreamToString(is) + "</div>";
                    is.close();
                    s = this.getSVGWithHandledPattern((String)s, pattern, patternColours);
                    s = SvgUtil.colourReplacement(this.getId(), colours, this.getColourReplacements(), (String)s);
                    if (!equippedVariant) {
                        is = this.getClass().getResourceAsStream("/com/lilithsthrone/res/clothing/belt_used_condoms_base_front.svg");
                        s = (String)s + "<div style='width:100%;height:100%;position:absolute;left:0;bottom:0;padding:0;margin:0'>" + Util.inputStreamToString(is) + "</div>";
                        s = this.getSVGWithHandledPattern((String)s, pattern, patternColours);
                        s = SvgUtil.colourReplacement(this.getId(), colours, this.getColourReplacements(), (String)s);
                        is.close();
                        this.addSVGStringEquippedMapping(slotEquippedTo, colours, pattern, patternColours, stickers, (String)s);
                        return s;
                    }
                    ArrayList<Colour> arrayList = new ArrayList<Colour>();
                    if (character != null) {
                        for (AbstractItem abstractItem : character.getAllItemsInInventory().keySet()) {
                            if (!abstractItem.getItemType().equals(ItemType.CONDOM_USED)) continue;
                            for (int count = 0; count < character.getItemCount(abstractItem); ++count) {
                                if (arrayList.size() >= 8) continue;
                                arrayList.add(abstractItem.getColour(0));
                                is = this.getClass().getResourceAsStream("/com/lilithsthrone/res/clothing/belt_used_condoms_" + arrayList.size() + "_back.svg");
                                s = (String)s + "<div style='width:100%;height:100%;position:absolute;left:0;bottom:0;padding:0;margin:0'>" + Util.inputStreamToString(is) + "</div>";
                                s = this.getSVGWithHandledPattern((String)s, pattern, patternColours);
                                s = SvgUtil.colourReplacement(this.getId(), Util.newArrayListOfValues(abstractItem.getColour(0)), Util.newArrayListOfValues(new ColourReplacement(true, ColourReplacement.DEFAULT_PRIMARY_REPLACEMENTS, ColourListPresets.ALL, null)), (String)s);
                                is.close();
                            }
                        }
                    }
                    is.close();
                    is = this.getClass().getResourceAsStream("/com/lilithsthrone/res/clothing/belt_used_condoms_base_front.svg");
                    s = (String)s + "<div style='width:100%;height:100%;position:absolute;left:0;bottom:0;padding:0;margin:0'>" + Util.inputStreamToString(is) + "</div>";
                    s = this.getSVGWithHandledPattern((String)s, pattern, patternColours);
                    s = SvgUtil.colourReplacement(this.getId(), colours, this.getColourReplacements(), (String)s);
                    is.close();
                    int i = 1;
                    for (Colour c : arrayList) {
                        is = this.getClass().getResourceAsStream("/com/lilithsthrone/res/clothing/belt_used_condoms_" + i + "_front.svg");
                        s = (String)s + "<div style='width:100%;height:100%;position:absolute;left:0;bottom:0;padding:0;margin:0'>" + Util.inputStreamToString(is) + "</div>";
                        s = this.getSVGWithHandledPattern((String)s, pattern, patternColours);
                        s = SvgUtil.colourReplacement(this.getId(), Util.newArrayListOfValues(c), Util.newArrayListOfValues(new ColourReplacement(true, ColourReplacement.DEFAULT_PRIMARY_REPLACEMENTS, ColourListPresets.ALL, null)), (String)s);
                        is.close();
                        ++i;
                    }
                    return s;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        } else {
            HashMap<String, String> handledStickers = new HashMap<String, String>(stickers);
            for (Map.Entry entry : this.getStickers().entrySet()) {
                if (stickers.containsKey(((StickerCategory)entry.getKey()).getId())) continue;
                Sticker sticker = null;
                for (Sticker s : (List)entry.getValue()) {
                    if (sticker != null && !s.isDefaultSticker()) continue;
                    sticker = s;
                }
                handledStickers.put(((StickerCategory)entry.getKey()).getId(), sticker.getId());
            }
            if (equippedVariant && this.pathNameEquipped != null && this.getPathNameEquipped(character, slotEquippedTo) != null) {
                stringFromMap = this.getSVGStringFromEquippedMap(character, slotEquippedTo, colours, pattern, patternColours, handledStickers);
                if (stringFromMap != null && !this.equals(ClothingType.WRIST_WOMENS_WATCH) && !this.equals(ClothingType.WRIST_MENS_WATCH)) {
                    return stringFromMap;
                }
                if (!colours.isEmpty()) {
                    try {
                        if (this.isMod) {
                            List<String> list = Files.readAllLines(Paths.get(this.getPathNameEquipped(character, slotEquippedTo), new String[0]));
                            sb = new StringBuilder();
                            for (String line : list) {
                                sb.append(line);
                            }
                            s = sb.toString();
                        } else {
                            InputStream inputStream = this.getClass().getResourceAsStream("/com/lilithsthrone/res/" + this.getPathNameEquipped(character, slotEquippedTo) + ".svg");
                            s = Util.inputStreamToString(inputStream);
                            inputStream.close();
                        }
                        s = this.getSVGWithHandledPattern((String)s, pattern, patternColours);
                        s = this.getSVGWithHandledStickers(slotEquippedTo, (String)s, handledStickers);
                        s = SvgUtil.colourReplacement(this.getId(), colours, this.getColourReplacements(), (String)s);
                        s = (String)s + (String)(this.equals(ClothingType.WRIST_WOMENS_WATCH) ? "<div style='width:100%;height:100%;position:absolute;left:0;top:0;-webkit-transform: rotate(" + (float)(Main.game.getMinutesPassed() % 1440L) / 2.0f + "deg);'>" + SVGImages.SVG_IMAGE_PROVIDER.getWomensWatchHourHand(colours, this.getColourReplacements()) + "</div><div style='width:100%;height:100%;position:absolute;left:0;top:0;-webkit-transform: rotate(" + Main.game.getMinutesPassed() % 60L * 6L + "deg);'>" + SVGImages.SVG_IMAGE_PROVIDER.getWomensWatchMinuteHand(colours, this.getColourReplacements()) + "</div>" : "") + (String)(this.equals(ClothingType.WRIST_MENS_WATCH) ? "<div style='width:100%;height:100%;position:absolute;left:0;top:0;-webkit-transform: rotate(" + (float)(Main.game.getMinutesPassed() % 1440L) / 2.0f + "deg);'>" + SVGImages.SVG_IMAGE_PROVIDER.getMensWatchHourHand(colours, this.getColourReplacements()) + "</div><div style='width:100%;height:100%;position:absolute;left:0;top:0;-webkit-transform: rotate(" + Main.game.getMinutesPassed() % 60L * 6L + "deg);'>" + SVGImages.SVG_IMAGE_PROVIDER.getMensWatchMinuteHand(colours, this.getColourReplacements()) + "</div>" : "");
                        return s;
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            } else {
                stringFromMap = this.getSVGStringFromMap(slotEquippedTo, colours, pattern, patternColours, handledStickers);
                if (stringFromMap != null && !this.equals(ClothingType.WRIST_WOMENS_WATCH) && !this.equals(ClothingType.WRIST_MENS_WATCH)) {
                    return stringFromMap;
                }
                if (!colours.isEmpty()) {
                    try {
                        if (this.isMod) {
                            List<String> list = Files.readAllLines(Paths.get(this.pathName, new String[0]));
                            sb = new StringBuilder();
                            for (String line : list) {
                                sb.append(line);
                            }
                            s = sb.toString();
                        } else {
                            InputStream inputStream = this.getClass().getResourceAsStream("/com/lilithsthrone/res/" + this.pathName + ".svg");
                            s = Util.inputStreamToString(inputStream);
                            inputStream.close();
                        }
                        s = this.getSVGWithHandledPattern((String)s, pattern, patternColours);
                        s = this.getSVGWithHandledStickers(slotEquippedTo, (String)s, handledStickers);
                        s = SvgUtil.colourReplacement(this.getId(), colours, this.getColourReplacements(), (String)s);
                        s = (String)s + (String)(this.equals(ClothingType.WRIST_WOMENS_WATCH) ? "<div style='width:100%;height:100%;position:absolute;left:0;top:0;-webkit-transform: rotate(" + (float)(Main.game.getMinutesPassed() % 1440L) / 2.0f + "deg);'>" + SVGImages.SVG_IMAGE_PROVIDER.getWomensWatchHourHand(colours, this.getColourReplacements()) + "</div><div style='width:100%;height:100%;position:absolute;left:0;top:0;-webkit-transform: rotate(" + Main.game.getMinutesPassed() % 60L * 6L + "deg);'>" + SVGImages.SVG_IMAGE_PROVIDER.getWomensWatchMinuteHand(colours, this.getColourReplacements()) + "</div>" : "") + (String)(this.equals(ClothingType.WRIST_MENS_WATCH) ? "<div style='width:100%;height:100%;position:absolute;left:0;top:0;-webkit-transform: rotate(" + (float)(Main.game.getMinutesPassed() % 1440L) / 2.0f + "deg);'>" + SVGImages.SVG_IMAGE_PROVIDER.getMensWatchHourHand(colours, this.getColourReplacements()) + "</div><div style='width:100%;height:100%;position:absolute;left:0;top:0;-webkit-transform: rotate(" + Main.game.getMinutesPassed() % 60L * 6L + "deg);'>" + SVGImages.SVG_IMAGE_PROVIDER.getMensWatchMinuteHand(colours, this.getColourReplacements()) + "</div>" : "");
                        this.addSVGStringMapping(slotEquippedTo, colours, pattern, patternColours, stickers, (String)s);
                        return s;
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            }
        }
        return "";
    }

    private String getSVGWithHandledStickers(InventorySlot slotEquippedTo, String s, Map<String, String> handledStickers) {
        StringBuilder sb;
        List<String> lines;
        Util.Value value;
        ArrayList<Util.Value<Integer, String>> svgRendering = new ArrayList<Util.Value<Integer, String>>();
        block4: for (Map.Entry<StickerCategory, List<Sticker>> typeStickers : this.getStickers().entrySet()) {
            if (!handledStickers.containsKey(typeStickers.getKey().getId())) continue;
            String string = handledStickers.get(typeStickers.getKey().getId());
            for (Sticker stickerFromType : typeStickers.getValue()) {
                if (!stickerFromType.getId().equals(string)) continue;
                for (Map.Entry entry : stickerFromType.getSvgPaths().get((Object)slotEquippedTo).entrySet()) {
                    svgRendering.add(new Util.Value<Integer, String>((Integer)entry.getKey(), (String)entry.getValue()));
                }
                continue block4;
            }
        }
        Collections.sort(svgRendering, (v1, v2) -> (Integer)v1.getKey() - (Integer)v2.getKey());
        Object finalSvg = "";
        Iterator iterator = svgRendering.iterator();
        while (iterator.hasNext() && (Integer)(value = (Util.Value)iterator.next()).getKey() < 0) {
            if (((String)value.getValue()).isEmpty()) continue;
            try {
                lines = Files.readAllLines(Paths.get((String)value.getValue(), new String[0]));
                sb = new StringBuilder();
                for (String string : lines) {
                    sb.append(string);
                }
                finalSvg = (String)finalSvg + "<div style='width:100%;height:100%;position:absolute;left:0;top:0;'>" + sb.toString() + "</div>";
            }
            catch (IOException ex) {
                System.err.println("Error: getSVGWithHandledStickers() Code 2");
                ex.printStackTrace();
            }
        }
        s = (String)finalSvg + "<div style='width:100%;height:100%;position:absolute;left:0;top:0;'>" + (String)s + "</div>";
        finalSvg = "";
        for (Util.Value value2 : svgRendering) {
            if ((Integer)value2.getKey() <= 0 || ((String)value2.getValue()).isEmpty()) continue;
            try {
                lines = Files.readAllLines(Paths.get((String)value2.getValue(), new String[0]));
                sb = new StringBuilder();
                for (String string : lines) {
                    sb.append(string);
                }
                finalSvg = (String)finalSvg + "<div style='width:100%;height:100%;position:absolute;left:0;top:0;'>" + sb.toString() + "</div>";
            }
            catch (IOException ex) {
                System.err.println("Error: getSVGWithHandledStickers() Code 2");
                ex.printStackTrace();
            }
        }
        s = (String)s + (String)finalSvg;
        return s;
    }

    public boolean isPatternAvailable() {
        if (!this.isPatternAvailable && !this.isPatternAvailableInitCompleted) {
            this.isPatternAvailable = this.getSVGImage().contains("patternLayer");
            this.isPatternAvailableInitCompleted = true;
        }
        return this.isPatternAvailable;
    }

    private String getSVGWithHandledPattern(String s, String pattern, List<Colour> patternColours) {
        this.isPatternAvailableInitCompleted = true;
        if (!s.contains("patternLayer")) {
            return s;
        }
        if (!this.isPatternAvailable) {
            this.isPatternAvailable = true;
        }
        return SvgUtil.getSVGWithHandledPattern("\u670d\u88c5\u5f15\u8d77\u9519\u8bef\uff1a" + this.getName(), s, pattern, patternColours, this.getPatternColourReplacements());
    }

    public float getPatternChance() {
        return this.patternChance;
    }

    public List<Pattern> getDefaultPatterns() {
        return this.defaultPatterns;
    }

    public ColourReplacement getPatternColourReplacement(int index) {
        if (index > this.patternColourReplacements.size() - 1) {
            return null;
        }
        return this.patternColourReplacements.get(index);
    }

    public List<ColourReplacement> getPatternColourReplacements() {
        return this.patternColourReplacements;
    }

    public Map<StickerCategory, List<Sticker>> getStickers() {
        return this.stickers;
    }

    @Override
    public Rarity getRarity() {
        return this.rarity;
    }

    public List<ItemEffect> getEffects() {
        return this.effects;
    }

    public boolean isAbleToBeSold() {
        return this.getRarity() != Rarity.QUEST;
    }

    public boolean isAbleToBeDropped() {
        return this.getRarity() != Rarity.QUEST;
    }

    public float getPhysicalResistance() {
        return this.physicalResistance;
    }

    public int getEnchantmentLimit() {
        return 100;
    }

    public AbstractItemEffectType getEnchantmentEffect() {
        return ItemEffectType.CLOTHING;
    }

    public AbstractClothingType getEnchantmentItemType(List<ItemEffect> effects) {
        return this;
    }

    public List<ItemTag> getItemTags(InventorySlot slotEquippedTo) {
        if (!this.itemTags.containsKey((Object)slotEquippedTo)) {
            return new ArrayList<ItemTag>();
        }
        return this.itemTags.get((Object)slotEquippedTo);
    }

    public List<ItemTag> getDefaultItemTags() {
        return this.itemTags.get((Object)this.equipSlots.get(0));
    }

    public boolean isDefaultSlotCondom(InventorySlot slotEquippedTo) {
        return this.getItemTags(slotEquippedTo).contains((Object)ItemTag.CONDOM);
    }

    public boolean isDefaultSlotCondom() {
        return this.getDefaultItemTags().contains((Object)ItemTag.CONDOM);
    }

    public boolean isColourDerivedFromPattern() {
        return this.isColourDerivedFromPattern;
    }

    public int getPenetrationSelfLength() {
        return this.penetrationSelfLength;
    }

    public int getPenetrationSelfGirth() {
        return this.penetrationSelfGirth;
    }

    public Set<PenetrationModifier> getPenetrationSelfModifiers() {
        if (this.penetrationSelfModifiers == null) {
            return new HashSet<PenetrationModifier>();
        }
        return this.penetrationSelfModifiers;
    }

    public int getPenetrationOtherLength() {
        return this.penetrationOtherLength;
    }

    public int getPenetrationOtherGirth() {
        return this.penetrationOtherGirth;
    }

    public Set<PenetrationModifier> getPenetrationOtherModifiers() {
        if (this.penetrationOtherModifiers == null) {
            return new HashSet<PenetrationModifier>();
        }
        return this.penetrationOtherModifiers;
    }

    public int getOrificeSelfLabiaSize() {
        return this.orificeSelfLabiaSize;
    }

    public int getOrificeSelfClitSize() {
        return this.orificeSelfClitSize;
    }

    public int getOrificeSelfClitGirth() {
        return this.orificeSelfClitGirth;
    }

    public int getOrificeSelfDepth() {
        return this.orificeSelfDepth;
    }

    public float getOrificeSelfCapacity() {
        return this.orificeSelfCapacity;
    }

    public int getOrificeSelfElasticity() {
        return this.orificeSelfElasticity;
    }

    public int getOrificeSelfPlasticity() {
        return this.orificeSelfPlasticity;
    }

    public int getOrificeSelfWetness() {
        return this.orificeSelfWetness;
    }

    public Set<OrificeModifier> getOrificeSelfModifiers() {
        if (this.orificeSelfModifiers == null) {
            return new HashSet<OrificeModifier>();
        }
        return this.orificeSelfModifiers;
    }

    public int getOrificeOtherLabiaSize() {
        return this.orificeOtherLabiaSize;
    }

    public int getOrificeOtherClitSize() {
        return this.orificeOtherClitSize;
    }

    public int getOrificeOtherClitGirth() {
        return this.orificeOtherClitGirth;
    }

    public int getOrificeOtherDepth() {
        return this.orificeOtherDepth;
    }

    public float getOrificeOtherCapacity() {
        return this.orificeOtherCapacity;
    }

    public int getOrificeOtherElasticity() {
        return this.orificeOtherElasticity;
    }

    public int getOrificeOtherPlasticity() {
        return this.orificeOtherPlasticity;
    }

    public int getOrificeOtherWetness() {
        return this.orificeOtherWetness;
    }

    public Set<OrificeModifier> getOrificeOtherModifiers() {
        if (this.orificeOtherModifiers == null) {
            return new HashSet<OrificeModifier>();
        }
        return this.orificeOtherModifiers;
    }
}

