/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.inventory.clothing;

import com.lilithsthrone.game.inventory.InventorySlot;
import com.lilithsthrone.game.inventory.ItemTag;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.utils.colours.Colour;
import java.util.List;
import java.util.Map;

public class Sticker {
    private String id;
    private String name;
    private int priority;
    private boolean defaultSticker;
    private Colour colourDisabled;
    private Colour colourSelected;
    private String namePrefix;
    private int namePrefixPriority;
    private String namePostfix;
    private int namePostfixPriority;
    private String description;
    private boolean descriptionFullReplacement;
    private int descriptionPriority;
    private Map<InventorySlot, Map<Integer, String>> svgPaths;
    private List<ItemTag> tagsApplied;
    private List<ItemTag> tagsRemoved;
    private boolean showDisabledButton;
    private String unavailabilityText;
    private String availabilityText;

    public Sticker(String id, String name, int priority, boolean defaultSticker, Colour colourDisabled, Colour colourSelected, String namePrefix, int namePrefixPriority, String namePostfix, int namePostfixPriority, String description, boolean descriptionFullReplacement, int descriptionPriority, Map<InventorySlot, Map<Integer, String>> svgPaths, List<ItemTag> tagsApplied, List<ItemTag> tagsRemoved, boolean showDisabledButton, String unavailabilityText, String availabilityText) {
        this.id = id.replaceAll("'", "").replaceAll("\"", "").toLowerCase();
        this.name = name;
        this.priority = priority;
        this.defaultSticker = defaultSticker;
        this.colourDisabled = colourDisabled;
        this.colourSelected = colourSelected;
        this.namePrefix = namePrefix;
        this.namePrefixPriority = namePrefixPriority;
        this.namePostfix = namePostfix;
        this.namePostfixPriority = namePostfixPriority;
        this.description = description;
        this.descriptionFullReplacement = descriptionFullReplacement;
        this.descriptionPriority = descriptionPriority;
        this.svgPaths = svgPaths;
        this.tagsApplied = tagsApplied;
        this.tagsRemoved = tagsRemoved;
        this.showDisabledButton = showDisabledButton;
        this.unavailabilityText = unavailabilityText;
        this.availabilityText = availabilityText;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public int getPriority() {
        return this.priority;
    }

    public boolean isDefaultSticker() {
        return this.defaultSticker;
    }

    public Colour getColourDisabled() {
        return this.colourDisabled;
    }

    public Colour getColourSelected() {
        return this.colourSelected;
    }

    public String getNamePrefix() {
        return this.namePrefix;
    }

    public int getNamePrefixPriority() {
        return this.namePrefixPriority;
    }

    public String getNamePostfix() {
        return this.namePostfix;
    }

    public int getNamePostfixPriority() {
        return this.namePostfixPriority;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isDescriptionFullReplacement() {
        return this.descriptionFullReplacement;
    }

    public int getDescriptionPriority() {
        return this.descriptionPriority;
    }

    public Map<InventorySlot, Map<Integer, String>> getSvgPaths() {
        return this.svgPaths;
    }

    public List<ItemTag> getTagsApplied() {
        return this.tagsApplied;
    }

    public List<ItemTag> getTagsRemoved() {
        return this.tagsRemoved;
    }

    public boolean isShowDisabledButton() {
        return this.showDisabledButton;
    }

    public String getUnavailabilityText() {
        if (Main.game.isAllStickersUnlocked()) {
            return "";
        }
        return this.unavailabilityText;
    }

    public String getAvailabilityText() {
        if (Main.game.isAllStickersUnlocked()) {
            return "";
        }
        return this.availabilityText;
    }
}

