/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.inventory.enchanting;

import com.lilithsthrone.game.character.effects.Perk;
import com.lilithsthrone.game.character.fetishes.Fetish;
import com.lilithsthrone.game.character.markings.AbstractTattooType;
import com.lilithsthrone.game.character.markings.Tattoo;
import com.lilithsthrone.game.combat.spells.SpellSchool;
import com.lilithsthrone.game.dialogue.places.dominion.lilayashome.LilayaDressingRoomDialogue;
import com.lilithsthrone.game.dialogue.utils.EnchantmentDialogue;
import com.lilithsthrone.game.inventory.AbstractCoreItem;
import com.lilithsthrone.game.inventory.clothing.AbstractClothing;
import com.lilithsthrone.game.inventory.clothing.AbstractClothingType;
import com.lilithsthrone.game.inventory.enchanting.ItemEffect;
import com.lilithsthrone.game.inventory.enchanting.TFModifier;
import com.lilithsthrone.game.inventory.item.AbstractItem;
import com.lilithsthrone.game.inventory.item.AbstractItemType;
import com.lilithsthrone.game.inventory.item.ItemType;
import com.lilithsthrone.game.inventory.weapon.AbstractWeapon;
import com.lilithsthrone.game.inventory.weapon.AbstractWeaponType;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.rendering.SVGImages;
import com.lilithsthrone.utils.SvgUtil;
import com.lilithsthrone.utils.Util;
import com.lilithsthrone.utils.colours.Colour;
import com.lilithsthrone.utils.colours.PresetColour;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class EnchantingUtils {
    public static final int FLAME_COST_MODIFER = 500;
    private static Set<TFModifier> freePrimaryModifiers = Util.newHashSetOfValues(TFModifier.TF_MOD_WETNESS, TFModifier.TF_MILK, TFModifier.TF_MILK_CROTCH, TFModifier.TF_CUM, TFModifier.TF_GIRLCUM);
    private static Set<TFModifier> freeSecondaryModifiers = Util.newHashSetOfValues(TFModifier.TF_MOD_WETNESS, TFModifier.TF_MOD_REGENERATION, TFModifier.TF_MOD_CUM_EXPULSION);

    public static AbstractItem craftItem(AbstractCoreItem ingredient, List<ItemEffect> effects) {
        AbstractItem craftedItem = null;
        craftedItem = Main.game.getItemGen().generateItem((AbstractItemType)ingredient.getEnchantmentItemType(effects));
        ArrayList<ItemEffect> effectsToBeAdded = new ArrayList<ItemEffect>();
        effectsToBeAdded.addAll(effects);
        craftedItem.setItemEffects(effectsToBeAdded);
        if (!EnchantmentDialogue.getOutputName().equals(ingredient.getName())) {
            craftedItem.setName(EnchantmentDialogue.getOutputName());
        } else if (!ingredient.getName().equals(craftedItem.getName())) {
            craftedItem.setName(ingredient.getName());
        }
        craftedItem.setColour(0, ingredient.getEnchantmentEffect().getColour());
        craftedItem.setSVGString(EnchantingUtils.getSVGString(ingredient, effectsToBeAdded));
        return craftedItem;
    }

    public static AbstractClothing craftClothing(AbstractCoreItem ingredient, List<ItemEffect> effects) {
        AbstractClothing craftedClothing = null;
        ArrayList<ItemEffect> effectsToBeAdded = new ArrayList<ItemEffect>(effects);
        craftedClothing = Main.game.getItemGen().generateClothing((AbstractClothingType)ingredient.getEnchantmentItemType(effects), ((AbstractClothing)ingredient).getColours(), effectsToBeAdded);
        craftedClothing.setPattern(((AbstractClothing)ingredient).getPattern());
        craftedClothing.setPatternColours(((AbstractClothing)ingredient).getPatternColours());
        if (Main.game.getCurrentDialogueNode() == LilayaDressingRoomDialogue.OUTFIT_EDITOR_ITEM_ENCHANT) {
            craftedClothing.setName(LilayaDressingRoomDialogue.getOutputName());
        } else if (!EnchantmentDialogue.getOutputName().equals(ingredient.getName())) {
            craftedClothing.setName(EnchantmentDialogue.getOutputName());
        } else if (!ingredient.getName().equals(craftedClothing.getName())) {
            craftedClothing.setName(ingredient.getName());
        }
        craftedClothing.setEnchantmentKnown(null, true);
        craftedClothing.setStickers(((AbstractClothing)ingredient).getStickers());
        return craftedClothing;
    }

    public static Tattoo craftTattoo(AbstractCoreItem ingredient, List<ItemEffect> effects) {
        ArrayList<ItemEffect> effectsToBeAdded = new ArrayList<ItemEffect>(effects);
        Tattoo newTattoo = new Tattoo(((Tattoo)ingredient).getType(), ((Tattoo)ingredient).getPrimaryColour(), ((Tattoo)ingredient).getSecondaryColour(), ((Tattoo)ingredient).getTertiaryColour(), ((Tattoo)ingredient).isGlowing(), ((Tattoo)ingredient).getWriting(), ((Tattoo)ingredient).getCounter());
        newTattoo.setEffects(effectsToBeAdded);
        if (!EnchantmentDialogue.getOutputName().equals(ingredient.getName())) {
            newTattoo.setName(EnchantmentDialogue.getOutputName());
        } else if (!ingredient.getName().equals(newTattoo.getName())) {
            newTattoo.setName(ingredient.getName());
        }
        return newTattoo;
    }

    public static AbstractWeapon craftWeapon(AbstractCoreItem ingredient, List<ItemEffect> effects) {
        AbstractWeapon craftedWeapon = null;
        ArrayList<ItemEffect> effectsToBeAdded = new ArrayList<ItemEffect>();
        effectsToBeAdded.addAll(effects);
        craftedWeapon = Main.game.getItemGen().generateWeapon((AbstractWeaponType)ingredient.getEnchantmentItemType(effects), ((AbstractWeapon)ingredient).getDamageType(), ((AbstractWeapon)ingredient).getColours());
        craftedWeapon.setEffects(effectsToBeAdded);
        if (Main.game.getCurrentDialogueNode() == LilayaDressingRoomDialogue.OUTFIT_EDITOR_ITEM_ENCHANT) {
            craftedWeapon.setName(LilayaDressingRoomDialogue.getOutputName());
        } else if (!EnchantmentDialogue.getOutputName().equals(ingredient.getName())) {
            craftedWeapon.setName(EnchantmentDialogue.getOutputName());
        } else if (!ingredient.getName().equals(craftedWeapon.getName())) {
            craftedWeapon.setName(ingredient.getName());
        }
        return craftedWeapon;
    }

    public static String getPotionName(AbstractCoreItem ingredient, List<ItemEffect> effects) {
        if (ingredient.getEnchantmentItemType(effects) instanceof AbstractClothingType || ingredient.getEnchantmentItemType(effects) instanceof AbstractTattooType || ingredient.getEnchantmentItemType(effects) instanceof AbstractWeaponType) {
            return ingredient.getName();
        }
        if (((AbstractItem)ingredient).getItemType().getId().equals(ItemType.ORIENTATION_HYPNO_WATCH.getId())) {
            if (effects.isEmpty() || effects.get(0).getPrimaryModifier() == TFModifier.REMOVAL) {
                return "\u50ac\u7720\u6000\u8868";
            }
            if (effects.get(0).getPrimaryModifier() == TFModifier.ORIENTATION_GYNEPHILIC) {
                return "\u5973\u6027\u604b\u50ac\u7720\u6000\u8868";
            }
            if (effects.get(0).getPrimaryModifier() == TFModifier.ORIENTATION_AMBIPHILIC) {
                return "\u53cc\u6027\u604b\u50ac\u7720\u6000\u8868";
            }
            if (effects.get(0).getPrimaryModifier() == TFModifier.ORIENTATION_ANDROPHILIC) {
                return "\u7537\u6027\u604b\u50ac\u7720\u6000\u8868";
            }
            return "\u8a00\u8bed\u4fee\u6539\u50ac\u7720\u6000\u8868";
        }
        String potionName = ((AbstractItemType)ingredient.getEnchantmentItemType(effects)).getName(false);
        String potionDescriptor = "";
        String potionSuffix = "";
        String potionPreSuffix = "";
        if (ingredient != null) {
            if (!ingredient.getEffects().isEmpty()) {
                try {
                    potionDescriptor = ingredient.getEffects().get(0).getItemEffectType().getPotionDescriptor();
                }
                catch (Exception ex) {
                    System.err.println("EnchantingUtils: getPotionName() error 1.");
                }
            } else if (ingredient instanceof AbstractItem) {
                potionDescriptor = ((AbstractItem)ingredient).getItemType().getPotionDescriptor();
            }
        }
        String finalPotionName = (String)(potionDescriptor == null || potionDescriptor.isEmpty() ? "" : Util.capitaliseSentence(potionDescriptor)) + potionName;
        for (ItemEffect ie : effects) {
            if (ie.getPrimaryModifier() == null || ie.getPrimaryModifier() == TFModifier.NONE) continue;
            potionSuffix = ie.getPrimaryModifier().getDescriptor();
            if (ie.getSecondaryModifier() != TFModifier.NONE) {
                potionPreSuffix = ie.getSecondaryModifier() == TFModifier.ARCANE_BOOST && ie.getPotency().isNegative() ? "\u559d\u5149\u7684" : ie.getSecondaryModifier().getDescriptor();
            }
            if (potionSuffix == "") break;
            if (potionPreSuffix != "") {
                if (ie.getSecondaryModifier().isSoloDescriptor()) {
                    finalPotionName = finalPotionName + potionPreSuffix + "\u7684";
                    break;
                }
                finalPotionName = finalPotionName + potionPreSuffix + "\u7684" + potionSuffix;
                break;
            }
            finalPotionName = finalPotionName + "\u7684" + potionSuffix;
            break;
        }
        return Util.capitaliseSentence(finalPotionName);
    }

    private static boolean isEffectFreeForWaterSchool(ItemEffect effect) {
        return freePrimaryModifiers.contains((Object)effect.getPrimaryModifier()) || freeSecondaryModifiers.contains((Object)effect.getSecondaryModifier());
    }

    private static boolean isEffectFreeForBondageApplier(ItemEffect effect) {
        return Main.game.getPlayer().hasFetish(Fetish.FETISH_BONDAGE_APPLIER) && (effect.getSecondaryModifier() == TFModifier.CLOTHING_SEALING || effect.getSecondaryModifier() == TFModifier.CLOTHING_ENSLAVEMENT || effect.getSecondaryModifier() == TFModifier.CLOTHING_SERVITUDE);
    }

    private static boolean isEffectFreeForRemovingPositiveAttribute(ItemEffect effect) {
        if (EnchantingUtils.isEffectFreeForBondageApplier(effect)) {
            return true;
        }
        if (effect.getPrimaryModifier() == TFModifier.CLOTHING_ATTRIBUTE || effect.getPrimaryModifier() == TFModifier.CLOTHING_MAJOR_ATTRIBUTE) {
            return !effect.getPotency().isNegative();
        }
        return TFModifier.getTFRacialBodyPartsList().contains((Object)effect.getPrimaryModifier());
    }

    private static int applyDiscountsForPerksAndFetishes(AbstractCoreItem ingredient, int cost) {
        if (Main.game.getPlayer().hasFetish(Fetish.FETISH_TRANSFORMATION_GIVING) && ingredient instanceof AbstractItem) {
            cost /= 2;
        }
        if (Main.game.getPlayer().hasPerkAnywhereInTree(Perk.CLOTHING_ENCHANTER) && ingredient instanceof AbstractClothing) {
            cost /= 2;
        }
        if (Main.game.getPlayer().hasPerkAnywhereInTree(Perk.WEAPON_ENCHANTER) && ingredient instanceof AbstractWeapon) {
            cost /= 2;
        }
        return cost;
    }

    public static int getModifierEffectCost(boolean addingEffect, AbstractCoreItem ingredient, ItemEffect effect) {
        if (!(ingredient instanceof Tattoo) && Main.game.getPlayer().isSpellSchoolSpecialAbilityUnlocked(SpellSchool.WATER) && EnchantingUtils.isEffectFreeForWaterSchool(effect)) {
            return 0;
        }
        if (!addingEffect && EnchantingUtils.isEffectFreeForRemovingPositiveAttribute(effect)) {
            return 0;
        }
        int cost = effect.getCost();
        if (addingEffect && EnchantingUtils.isEffectFreeForBondageApplier(effect)) {
            return 0;
        }
        return EnchantingUtils.applyDiscountsForPerksAndFetishes(ingredient, cost);
    }

    public static int getCost(AbstractCoreItem ingredient, List<ItemEffect> effects) {
        HashMap<ItemEffect, Integer> effectCount = new HashMap<ItemEffect, Integer>();
        for (ItemEffect ie : effects) {
            effectCount.merge(ie, 1, Integer::sum);
        }
        for (ItemEffect ie : ingredient.getEffects()) {
            if (effects.contains(ie)) {
                if ((Integer)effectCount.get(ie) <= 0 && EnchantingUtils.isEffectFreeForRemovingPositiveAttribute(ie)) continue;
                effectCount.merge(ie, -1, Integer::sum);
                continue;
            }
            if (EnchantingUtils.isEffectFreeForRemovingPositiveAttribute(ie)) continue;
            effectCount.merge(ie, 1, Integer::sum);
        }
        if (!(ingredient instanceof Tattoo) && Main.game.getPlayer().isSpellSchoolSpecialAbilityUnlocked(SpellSchool.WATER)) {
            effectCount.keySet().removeIf(EnchantingUtils::isEffectFreeForWaterSchool);
        }
        if (!(ingredient instanceof Tattoo)) {
            effectCount.keySet().removeIf(EnchantingUtils::isEffectFreeForBondageApplier);
        }
        int cost = 0;
        for (Map.Entry entry : effectCount.entrySet()) {
            int costIncrement = ((ItemEffect)entry.getKey()).getCost() * Math.abs((Integer)entry.getValue());
            cost += costIncrement;
        }
        return EnchantingUtils.applyDiscountsForPerksAndFetishes(ingredient, cost);
    }

    public static String getSVGString(AbstractCoreItem ingredient, List<ItemEffect> effects) {
        if (ingredient.getEnchantmentItemType(effects) instanceof AbstractClothingType || ingredient.getEnchantmentItemType(effects) instanceof AbstractTattooType || ingredient.getEnchantmentItemType(effects) instanceof AbstractWeaponType) {
            return ingredient.getSVGString();
        }
        if (((AbstractItem)ingredient).getItemType().getId().equals(ItemType.ORIENTATION_HYPNO_WATCH.getId())) {
            if (effects.isEmpty() || effects.get(0).getPrimaryModifier() == null || effects.get(0).getPrimaryModifier() == TFModifier.REMOVAL) {
                return SVGImages.SVG_IMAGE_PROVIDER.getHypnoWatchBase();
            }
            if (effects.get(0).getPrimaryModifier() == TFModifier.ORIENTATION_GYNEPHILIC) {
                return SVGImages.SVG_IMAGE_PROVIDER.getHypnoWatchGynephilic();
            }
            if (effects.get(0).getPrimaryModifier() == TFModifier.ORIENTATION_AMBIPHILIC) {
                return SVGImages.SVG_IMAGE_PROVIDER.getHypnoWatchAmbiphilic();
            }
            if (effects.get(0).getPrimaryModifier() == TFModifier.ORIENTATION_ANDROPHILIC) {
                return SVGImages.SVG_IMAGE_PROVIDER.getHypnoWatchAndrophilic();
            }
            if (effects.get(0).getPrimaryModifier() == TFModifier.PERSONALITY_TRAIT_SPEECH_LISP || effects.get(0).getPrimaryModifier() == TFModifier.PERSONALITY_TRAIT_SPEECH_STUTTER || effects.get(0).getPrimaryModifier() == TFModifier.PERSONALITY_TRAIT_SPEECH_SLOVENLY) {
                if (effects.get(0).getPotency().isNegative()) {
                    return SVGImages.SVG_IMAGE_PROVIDER.getHypnoWatchSpeechRemove();
                }
                return SVGImages.SVG_IMAGE_PROVIDER.getHypnoWatchSpeechAdd();
            }
        }
        StringBuilder SVGImageSB = new StringBuilder();
        SVGImageSB.append("<div style='width:100%;height:100%;position:absolute;left:0;bottom:0;'>" + SVGImages.SVG_IMAGE_PROVIDER.getRefinedBackgroundMap().get(ingredient.getEnchantmentEffect().getColour()) + "</div>");
        String s = ((AbstractItemType)ingredient.getEnchantmentItemType(effects)).getSVGString();
        Colour colour = PresetColour.CLOTHING_BLUE_LIGHT;
        for (ItemEffect ie : effects) {
            if (ie.getPrimaryModifier() == null || ie.getPrimaryModifier() == TFModifier.NONE) continue;
            colour = ie.getPrimaryModifier().getColour();
            break;
        }
        s = SvgUtil.colourReplacement(((AbstractItem)ingredient).getItemType().getId(), colour, null, null, s);
        SVGImageSB.append("<div style='width:100%;height:100%;position:absolute;left:0;bottom:0;'>" + s + "</div>");
        for (ItemEffect ie : effects) {
            if (ie.getSecondaryModifier() == null || ie.getSecondaryModifier() == TFModifier.NONE) continue;
            SVGImageSB.append("<div style='width:100%;height:100%;position:absolute;left:0;bottom:0;'>" + SVGImages.SVG_IMAGE_PROVIDER.getRefinedSwirlsMap().get(ie.getSecondaryModifier().getColour()) + "</div>");
            break;
        }
        return SVGImageSB.toString();
    }

    public static String getImportedSVGString(AbstractCoreItem item, Colour importedColour, List<ItemEffect> effects) {
        if (((AbstractItem)item).getItemType().getId().equals(ItemType.ORIENTATION_HYPNO_WATCH.getId())) {
            if (effects.isEmpty() || effects.get(0).getPrimaryModifier() == null || effects.get(0).getPrimaryModifier() == TFModifier.REMOVAL) {
                return SVGImages.SVG_IMAGE_PROVIDER.getHypnoWatchBase();
            }
            if (effects.get(0).getPrimaryModifier() == TFModifier.ORIENTATION_GYNEPHILIC) {
                return SVGImages.SVG_IMAGE_PROVIDER.getHypnoWatchGynephilic();
            }
            if (effects.get(0).getPrimaryModifier() == TFModifier.ORIENTATION_AMBIPHILIC) {
                return SVGImages.SVG_IMAGE_PROVIDER.getHypnoWatchAmbiphilic();
            }
            if (effects.get(0).getPrimaryModifier() == TFModifier.ORIENTATION_ANDROPHILIC) {
                return SVGImages.SVG_IMAGE_PROVIDER.getHypnoWatchAndrophilic();
            }
            if (effects.get(0).getPrimaryModifier() == TFModifier.PERSONALITY_TRAIT_SPEECH_LISP || effects.get(0).getPrimaryModifier() == TFModifier.PERSONALITY_TRAIT_SPEECH_STUTTER || effects.get(0).getPrimaryModifier() == TFModifier.PERSONALITY_TRAIT_SPEECH_SLOVENLY) {
                if (effects.get(0).getPotency().isNegative()) {
                    return SVGImages.SVG_IMAGE_PROVIDER.getHypnoWatchSpeechRemove();
                }
                return SVGImages.SVG_IMAGE_PROVIDER.getHypnoWatchSpeechAdd();
            }
        }
        StringBuilder SVGImageSB = new StringBuilder();
        String importedColourString = SVGImages.SVG_IMAGE_PROVIDER.getRefinedBackgroundMap().get(importedColour);
        if (importedColourString == null || importedColourString.isEmpty() || importedColourString.equals("null")) {
            importedColourString = SVGImages.SVG_IMAGE_PROVIDER.getRefinedBackgroundMap().get(effects.get(0).getItemEffectType().getColour());
        }
        SVGImageSB.append("<div style='width:100%;height:100%;position:absolute;left:0;bottom:0;'>" + importedColourString + "</div>");
        String s = item.getSVGString();
        Colour colour = PresetColour.CLOTHING_BLUE_LIGHT;
        for (ItemEffect ie : effects) {
            if (ie.getPrimaryModifier() == null || ie.getPrimaryModifier() == TFModifier.NONE) continue;
            colour = ie.getPrimaryModifier().getColour();
            break;
        }
        s = s.replaceAll("#ff2a2a", colour.getShades()[0]);
        s = s.replaceAll("#ff5555|#f55", colour.getShades()[1]);
        s = s.replaceAll("#ff8080", colour.getShades()[2]);
        s = s.replaceAll("#ffaaaa|#faa", colour.getShades()[3]);
        s = s.replaceAll("#ffd5d5", colour.getShades()[4]);
        SVGImageSB.append("<div style='width:100%;height:100%;position:absolute;left:0;bottom:0;'>" + s + "</div>");
        for (ItemEffect ie : effects) {
            if (ie.getSecondaryModifier() == null || ie.getSecondaryModifier() == TFModifier.NONE) continue;
            SVGImageSB.append("<div style='width:100%;height:100%;position:absolute;left:0;bottom:0;'>" + SVGImages.SVG_IMAGE_PROVIDER.getRefinedSwirlsMap().get(ie.getSecondaryModifier().getColour()) + "</div>");
            break;
        }
        return SVGImageSB.toString();
    }
}

