/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.inventory.enchanting;

import com.lilithsthrone.utils.colours.Colour;
import com.lilithsthrone.utils.colours.PresetColour;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public enum TFPotency {
    MAJOR_DRAIN("\u4e25\u91cd\u524a\u5f31", PresetColour.GENERIC_TERRIBLE, 8, -3, true),
    DRAIN("\u524a\u5f31", PresetColour.GENERIC_BAD, 4, -2, true),
    MINOR_DRAIN("\u8f7b\u5fae\u524a\u5f31", PresetColour.GENERIC_MINOR_BAD, 1, -1, true),
    MINOR_BOOST("\u8f7b\u5fae\u589e\u76ca", PresetColour.GENERIC_MINOR_GOOD, 1, 1, true),
    BOOST("\u589e\u76ca", PresetColour.GENERIC_GOOD, 4, 2, true),
    MAJOR_BOOST("\u5f3a\u529b\u589e\u76ca", PresetColour.GENERIC_EXCELLENT, 8, 3, true),
    SPECIAL("\u7279\u6b8a", PresetColour.ATTRIBUTE_CORRUPTION, 8, 3, false);

    private static List<TFPotency> allPotencies;
    private String name;
    private Colour colour;
    private int value;
    private int clothingBonusValue;
    private boolean availableForEnchanting;

    private TFPotency(String name, Colour colour, int value, int clothingBonusValue, boolean availableForEnchanting) {
        this.name = name;
        this.colour = colour;
        this.value = value;
        this.clothingBonusValue = clothingBonusValue;
        this.availableForEnchanting = availableForEnchanting;
    }

    public String getName() {
        return this.name;
    }

    public Colour getColour() {
        return this.colour;
    }

    public int getValue() {
        return this.value;
    }

    public int getClothingBonusValue() {
        return this.clothingBonusValue;
    }

    public boolean isAvailableForEnchanting() {
        return this.availableForEnchanting;
    }

    public boolean isNegative() {
        return this == MINOR_DRAIN || this == DRAIN || this == MAJOR_DRAIN;
    }

    public static List<TFPotency> getAllPotencies() {
        return allPotencies;
    }

    public static TFPotency getRandomWeightedPositivePotency() {
        double rnd = Math.random();
        if (rnd < 0.6) {
            return MINOR_BOOST;
        }
        if (rnd < 0.9) {
            return BOOST;
        }
        return MAJOR_BOOST;
    }

    public static TFPotency getRandomWeightedNegativePotency() {
        double rnd = Math.random();
        if (rnd < 0.6) {
            return MAJOR_DRAIN;
        }
        if (rnd < 0.9) {
            return DRAIN;
        }
        return MAJOR_DRAIN;
    }

    static {
        allPotencies = new ArrayList<TFPotency>();
        Collections.addAll(allPotencies, TFPotency.values());
        allPotencies.removeIf(p -> !p.isAvailableForEnchanting());
    }
}

