/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.inventory.item;

import com.lilithsthrone.controller.xmlParsing.XMLUtil;
import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.effects.AbstractStatusEffect;
import com.lilithsthrone.game.character.effects.EffectBenefit;
import com.lilithsthrone.game.character.race.Race;
import com.lilithsthrone.game.dialogue.DialogueNodeType;
import com.lilithsthrone.game.dialogue.responses.Response;
import com.lilithsthrone.game.dialogue.utils.ParserTag;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.game.inventory.AbstractCoreItem;
import com.lilithsthrone.game.inventory.AbstractCoreType;
import com.lilithsthrone.game.inventory.ItemTag;
import com.lilithsthrone.game.inventory.enchanting.AbstractItemEffectType;
import com.lilithsthrone.game.inventory.enchanting.EnchantingUtils;
import com.lilithsthrone.game.inventory.enchanting.ItemEffect;
import com.lilithsthrone.game.inventory.item.AbstractItemType;
import com.lilithsthrone.game.inventory.item.ItemType;
import com.lilithsthrone.game.inventory.item.SvgInformation;
import com.lilithsthrone.game.sex.sexActions.SexActionUtility;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.utils.Util;
import com.lilithsthrone.utils.XMLSaving;
import com.lilithsthrone.utils.colours.PresetColour;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class AbstractItem
extends AbstractCoreItem
implements XMLSaving {
    protected AbstractItemType itemType;
    protected List<ItemEffect> itemEffects;

    public AbstractItem(AbstractItemType itemType) {
        super(itemType.getName(false), itemType.getNamePlural(false), itemType.getSVGString(), itemType.getColourShades().get(0), itemType.getRarity(), null, itemType.getItemTags());
        this.itemType = itemType;
        this.itemEffects = itemType.getEffects();
    }

    @Override
    public boolean equals(Object o) {
        if (super.equals(o)) {
            return o instanceof AbstractItem && ((AbstractItem)o).getItemType().equals(this.itemType) && ((AbstractItem)o).getEffects().equals(this.itemEffects);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.itemType.hashCode();
        result = 31 * result + this.itemEffects.hashCode();
        return result;
    }

    @Override
    public Element saveAsXML(Element parentElement, Document doc) {
        Element element = doc.createElement("item");
        parentElement.appendChild(element);
        XMLUtil.addAttribute(doc, element, "id", this.getItemType().getId());
        XMLUtil.addAttribute(doc, element, "name", this.getName());
        if (this.getColour(0) != null) {
            XMLUtil.addAttribute(doc, element, "colour", this.getColour(0).getId());
        }
        if (!this.getEffects().isEmpty()) {
            Element innerElement = doc.createElement("itemEffects");
            element.appendChild(innerElement);
            for (ItemEffect ie : this.getEffects()) {
                ie.saveAsXML(innerElement, doc);
            }
        }
        return element;
    }

    public static AbstractItem loadFromXML(Element parentElement, Document doc) {
        try {
            AbstractItemType it = ItemType.getItemTypeFromId(parentElement.getAttribute("id"));
            if (it == null) {
                System.err.println("Warning: An instance of AbstractItem was unable to be imported, due to AbstractItemType not existing. (" + parentElement.getAttribute("id") + ")");
                return null;
            }
            AbstractItem item = Main.game.getItemGen().generateItem(it);
            if (!parentElement.getAttribute("name").isEmpty()) {
                item.setName(parentElement.getAttribute("name"));
            }
            ArrayList<ItemEffect> effectsToBeAdded = new ArrayList<ItemEffect>();
            Element ieElement = (Element)parentElement.getElementsByTagName("itemEffects").item(0);
            if (ieElement != null) {
                NodeList element = ieElement.getElementsByTagName("effect");
                for (int i = 0; i < element.getLength(); ++i) {
                    Element e = (Element)element.item(i);
                    ItemEffect itemEffect = ItemEffect.loadFromXML(e, doc);
                    if (itemEffect == null) continue;
                    effectsToBeAdded.add(itemEffect);
                }
                item.setItemEffects(effectsToBeAdded);
            }
            item.setColour(0, parentElement.getAttribute("colour").isEmpty() ? PresetColour.GENERIC_ARCANE : PresetColour.getColourFromId(parentElement.getAttribute("colour")));
            if (!effectsToBeAdded.isEmpty() && (item.getItemType().getId().equals(ItemType.ELIXIR.getId()) || item.getItemType().getId().equals(ItemType.POTION.getId()) || item.getItemType().getId().equals(ItemType.ORIENTATION_HYPNO_WATCH.getId()))) {
                item.setSVGString(EnchantingUtils.getImportedSVGString(item, item.getColour(0), effectsToBeAdded));
            }
            return item;
        }
        catch (Exception ex) {
            System.err.println("Warning: An instance of AbstractItem was unable to be imported. (" + parentElement.getAttribute("id") + ")");
            ex.printStackTrace();
            return null;
        }
    }

    public AbstractItemType getItemType() {
        return this.itemType;
    }

    public boolean isBreakOutOfInventory() {
        if (this.getItemType().isBreakOutOfInventory()) {
            return true;
        }
        for (ItemEffect effect : this.getEffects()) {
            if (!effect.getItemEffectType().isBreakOutOfInventory()) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<ItemEffect> getEffects() {
        return this.itemEffects;
    }

    public void setItemEffects(List<ItemEffect> itemEffects) {
        this.itemEffects = itemEffects;
    }

    public String applyEffect(GameCharacter user, GameCharacter target) {
        final StringBuilder sb = new StringBuilder();
        String targetNameBeforeEffects = UtilText.parse(target, "[npc.Name]", new ParserTag[0]);
        for (ItemEffect itemEffect : this.getEffects()) {
            sb.append(UtilText.parse(target, itemEffect.applyEffect(user, target, 1), new ParserTag[0]));
        }
        sb.append(UtilText.parse(target, user, this.getItemType().getSpecialEffect(), new ParserTag[0]));
        if (this.getItemType().getAppliedStatusEffects() != null) {
            for (Map.Entry entry : this.getItemType().getAppliedStatusEffects().entrySet()) {
                int time;
                boolean added;
                AbstractStatusEffect se = (AbstractStatusEffect)entry.getKey();
                String conditional = (String)((Util.Value)entry.getValue()).getKey();
                boolean conditionalParsed = Boolean.valueOf(UtilText.parse(user, target, conditional, new ParserTag[0]).trim());
                if (!conditionalParsed || !(added = target.addStatusEffect(se, time = ((Integer)((Util.Value)entry.getValue()).getValue()).intValue()))) continue;
                String timeDesc = time + "\u56de\u5408";
                if (!se.isCombatEffect()) {
                    int timeMinutes = time / 60;
                    timeDesc = timeMinutes > 180 ? timeMinutes / 60 + "\u5c0f\u65f6" : timeMinutes + "\u5206\u949f";
                }
                sb.append(UtilText.parse(target, "<p style='text-align:center; padding-top:0; margin-top:0;'>[npc.NameIsFull]\u73b0\u5728" + (se.getBeneficialStatus() == EffectBenefit.DETRIMENTAL ? "\u6b63\u5728\u906d\u53d7[style.italicsBad(" : (se.getBeneficialStatus() == EffectBenefit.BENEFICIAL ? "\u6b63\u5728\u53d7\u5230[style.italicsGood(" : "\u6b63\u5728\u53d7\u5230")) + se.getName(target) + (se.getBeneficialStatus() == EffectBenefit.NEUTRAL ? "" : ")]") + "\u7684\u5f71\u54cd\uff0c\u6301\u7eed" + timeDesc + "\uff01</p>", new ParserTag[0]));
            }
        }
        for (ItemTag itemTag : this.getItemTags()) {
            int intoxicationLevel = 0;
            switch (itemTag) {
                case CAFFEINATED_005: {
                    intoxicationLevel = 5;
                    break;
                }
                case CAFFEINATED_010: {
                    intoxicationLevel = 10;
                    break;
                }
                case CAFFEINATED_015: {
                    intoxicationLevel = 15;
                    break;
                }
                case CAFFEINATED_020: {
                    intoxicationLevel = 20;
                    break;
                }
                case CAFFEINATED_025: {
                    intoxicationLevel = 25;
                    break;
                }
                case CAFFEINATED_030: {
                    intoxicationLevel = 30;
                    break;
                }
                case CAFFEINATED_040: {
                    intoxicationLevel = 40;
                    break;
                }
                case CAFFEINATED_050: {
                    intoxicationLevel = 50;
                    break;
                }
                case CAFFEINATED_075: {
                    intoxicationLevel = 75;
                    break;
                }
                case CAFFEINATED_100: {
                    intoxicationLevel = 100;
                    break;
                }
            }
            if (intoxicationLevel <= 0 || target.getRace() != Race.getRaceFromId("charisma_spider")) continue;
            sb.append(UtilText.parse(target, "<p style='text-align:center;'>\u7531\u4e8e\u5176\u8718\u86db\u7684\u751f\u7406\u7279\u5f81\uff0c" + this.getName() + "\u4e2d\u7684\u5496\u5561\u56e0\u5c31\u50cf\u9152\u7cbe\u4e00\u6837\uff0c\u4f7f[npc.she]\u611f\u5230\u9010\u6e10\u559d\u9189\u4e86\u2026\u2026</p>", new ParserTag[0]));
            sb.append(target.incrementAlcoholLevel((float)intoxicationLevel / 100.0f));
            break;
        }
        if (this.getItemType().isBreakOutOfInventory() && Main.game.getCurrentDialogueNode().getDialogueNodeType() == DialogueNodeType.INVENTORY && !Main.game.isInCombat()) {
            if (Main.game.isInSex()) {
                Main.game.setContent(new Response(Util.capitaliseSentence(this.getItemType().getUseName()) + (String)(user.equals(target) ? " (\u81ea\u5df1)" : " (" + targetNameBeforeEffects + ")"), "", Main.sex.SEX_DIALOGUE){

                    @Override
                    public void effects() {
                        Main.mainController.openInventory();
                        Main.sex.setUsingItemText(sb.toString());
                        Main.sex.endSexTurn(SexActionUtility.PLAYER_USE_ITEM);
                        Main.sex.setSexStarted(true);
                    }
                });
            } else {
                Main.game.setContent(new Response("", "", Main.game.getDefaultDialogue(false)){

                    @Override
                    public boolean isStripContent() {
                        return true;
                    }

                    @Override
                    public void effects() {
                        Main.game.appendToTextStartStringBuilder(sb.toString());
                    }
                });
            }
        }
        return sb.toString();
    }

    @Override
    public int getEnchantmentLimit() {
        return this.itemType.getEnchantmentLimit();
    }

    @Override
    public AbstractItemEffectType getEnchantmentEffect() {
        return this.itemType.getEnchantmentEffect();
    }

    @Override
    public AbstractCoreType getEnchantmentItemType(List<ItemEffect> effects) {
        return this.itemType.getEnchantmentItemType(effects);
    }

    public String getName(boolean withDeterminer, boolean withRarityColour) {
        return UtilText.parse((AbstractCoreItem)this, (withDeterminer ? (!this.itemType.getDeterminer().equalsIgnoreCase("a") && !this.itemType.getDeterminer().equalsIgnoreCase("an") ? this.itemType.getDeterminer() : UtilText.generateSingularDeterminer(this.name)) : "") + " " + (withRarityColour ? " <span style='color: " + this.rarity.getColour().toWebHexString() + ";'>" + this.name + "</span>" : " " + this.name), new ParserTag[0]);
    }

    @Override
    public String getDisplayName(boolean withRarityColour) {
        return UtilText.parse((AbstractCoreItem)this, Util.capitaliseSentence((!this.itemType.getDeterminer().equalsIgnoreCase("a") && !this.itemType.getDeterminer().equalsIgnoreCase("an") ? this.itemType.getDeterminer() : UtilText.generateSingularDeterminer(this.name)) + " " + (String)(withRarityColour ? "<span style='color: " + this.rarity.getColour().toWebHexString() + ";'>" + this.name + "</span>" : this.name)), new ParserTag[0]);
    }

    @Override
    public String getDisplayNamePlural(boolean withRarityColour) {
        return UtilText.parse((AbstractCoreItem)this, Util.capitaliseSentence((String)(withRarityColour ? "<span style='color: " + this.rarity.getColour().toWebHexString() + ";'>" + this.namePlural + "</span>" : this.namePlural)), new ParserTag[0]);
    }

    public String getTypeDescription(GameCharacter characterEquippedOn) {
        String description = this.getItemType().getDescription();
        return UtilText.parse(characterEquippedOn, (AbstractCoreItem)this, description, new ParserTag[0]);
    }

    @Override
    public String getDescription(GameCharacter characterEquippedOn) {
        return this.getTypeDescription(characterEquippedOn);
    }

    @Override
    public int getValue() {
        float modifier = 1.0f;
        if (this.getEffects().size() > 0) {
            for (ItemEffect ie : this.getEffects()) {
                if (ie.getPotency() == null) continue;
                float modIncrease = 0.0f;
                switch (ie.getPotency()) {
                    case MAJOR_BOOST: {
                        modIncrease = 0.05f;
                        break;
                    }
                    case BOOST: {
                        modIncrease = 0.025f;
                        break;
                    }
                    case MINOR_BOOST: {
                        modIncrease = 0.01f;
                        break;
                    }
                }
                modifier += modIncrease;
            }
        }
        return (int)((float)this.itemType.getValue() * modifier);
    }

    public boolean isAppendItemEffectLinesToTooltip() {
        return this.getItemType().isAppendItemEffectLinesToTooltip();
    }

    public List<String> getEffectTooltipLines() {
        return this.getItemType().getEffectTooltipLines();
    }

    public String getExtraDescription(GameCharacter user, GameCharacter target) {
        StringBuilder sb = new StringBuilder();
        sb.append("<p><b>\u6548\u679c\uff1a</b>");
        for (ItemEffect ie : this.getEffects()) {
            for (String s : ie.getEffectsDescription(user, target)) {
                sb.append("<br/>" + s);
            }
        }
        for (String s : this.getEffectTooltipLines()) {
            sb.append("<br/>" + s);
        }
        for (ItemTag it : this.getItemTags()) {
            for (String s : it.getClothingTooltipAdditions()) {
                sb.append("<br/>" + s);
            }
        }
        sb.append("</p><p>" + (this.getItemType().isPlural() ? "\u8be5\u7269\u54c1\u4ef7\u503c\u4e3a" : "\u8be5\u7269\u54c1\u4ef7\u503c\u4e3a") + UtilText.formatAsMoney(this.getValue()) + "\u3002</p>");
        return sb.toString();
    }

    public List<String> getExtraDescriptions(GameCharacter characterOwner) {
        ArrayList<String> descriptionsList = new ArrayList<String>();
        for (ItemTag it : this.getItemType().getItemTags()) {
            descriptionsList.addAll(it.getClothingTooltipAdditions());
        }
        return descriptionsList;
    }

    public List<SvgInformation> getPathNameInformation() {
        return this.itemType.getPathNameInformation();
    }

    public boolean isConsumedOnUse() {
        return this.itemType.isConsumedOnUse();
    }

    public String getUseDescription(GameCharacter user, GameCharacter target) {
        return this.itemType.getUseDescription(user, target);
    }

    public boolean isAbleToBeUsedFromInventory() {
        return this.itemType.isAbleToBeUsedFromInventory();
    }

    public String getUnableToBeUsedFromInventoryDescription() {
        return this.itemType.getUnableToBeUsedFromInventoryDescription();
    }

    public boolean isAbleToBeUsedWhileTrading() {
        return this.itemType.isAbleToBeUsedWhileTrading();
    }

    public String getUnableToBeUsedWhileTradingDescription() {
        return this.itemType.getUnableToBeUsedWhileTradingDescription();
    }

    public boolean isAbleToBeUsed(GameCharacter user, GameCharacter target) {
        return this.itemType.isAbleToBeUsed(user, target);
    }

    public String getUnableToBeUsedDescription(GameCharacter user, GameCharacter target) {
        return this.itemType.getUnableToBeUsedDescription(user, target);
    }

    public boolean isAbleToBeUsedInCombatAllies() {
        return !this.isBreakOutOfInventory() && this.itemType.isAbleToBeUsedInCombatAllies();
    }

    public boolean isAbleToBeUsedInCombatEnemies() {
        return !this.isBreakOutOfInventory() && this.itemType.isAbleToBeUsedInCombatEnemies();
    }

    public boolean isAbleToBeUsedInSex() {
        return this.itemType.isAbleToBeUsedInSex();
    }

    public boolean isGift() {
        return this.itemType.isGift();
    }

    public boolean isTypeOneOf(String ... itemType) {
        return Stream.of(itemType).anyMatch(it -> this.getItemType().equals(ItemType.getItemTypeFromId(it)));
    }

    @Override
    public Set<ItemTag> getItemTags() {
        return new HashSet<ItemTag>(this.getItemType().getItemTags());
    }
}

