/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.inventory.outfit;

import com.lilithsthrone.controller.xmlParsing.XMLUtil;
import com.lilithsthrone.game.dialogue.places.dominion.lilayashome.LilayaDressingRoomDialogue;
import com.lilithsthrone.game.inventory.InventorySlot;
import com.lilithsthrone.game.inventory.clothing.AbstractClothing;
import com.lilithsthrone.game.inventory.weapon.AbstractWeapon;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.utils.XMLSaving;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Outfit
implements XMLSaving {
    private long gameCreationID = Main.game.getId();
    private String name;
    private Map<InventorySlot, AbstractWeapon> weapons;
    private Map<InventorySlot, AbstractClothing> clothing;
    private InventorySlot iconSlotPriority;
    private Set<InventorySlot> ignoredSlots;

    public Outfit() {
        this("outfit", new HashMap<InventorySlot, AbstractWeapon>(), new HashMap<InventorySlot, AbstractClothing>());
    }

    public Outfit(String name, Map<InventorySlot, AbstractWeapon> weapons, Map<InventorySlot, AbstractClothing> clothing) {
        this.name = name;
        if (weapons == null) {
            this.weapons = new HashMap<InventorySlot, AbstractWeapon>();
        }
        this.weapons = weapons;
        if (clothing == null) {
            this.clothing = new HashMap<InventorySlot, AbstractClothing>();
        }
        this.clothing = clothing;
        this.iconSlotPriority = null;
        this.ignoredSlots = new HashSet<InventorySlot>();
    }

    public boolean equals(Object o) {
        return o instanceof Outfit && ((Outfit)o).gameCreationID == this.gameCreationID && ((Outfit)o).getName().equals(this.name) && ((Outfit)o).getWeapons().equals(this.weapons) && ((Outfit)o).getClothing().equals(this.clothing) && Objects.equals((Object)((Outfit)o).iconSlotPriority, (Object)this.iconSlotPriority) && ((Outfit)o).getIgnoredSlots().equals(this.ignoredSlots);
    }

    public int hashCode() {
        int result = 17;
        if (this.name != null) {
            result = 31 * result + this.name.hashCode();
        }
        if (this.weapons != null) {
            result = 31 * result + this.weapons.hashCode();
        }
        if (this.clothing != null) {
            result = 31 * result + this.clothing.hashCode();
        }
        if (this.iconSlotPriority != null) {
            result = 31 * result + this.iconSlotPriority.hashCode();
        }
        if (this.ignoredSlots != null) {
            result = 31 * result + this.ignoredSlots.hashCode();
        }
        result = 31 * result + Long.hashCode(this.gameCreationID);
        return result;
    }

    public long getGameCreationID() {
        return this.gameCreationID;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public InventorySlot getIconSlotPriority() {
        return this.iconSlotPriority;
    }

    public void setIconSlotPriority(InventorySlot iconSlotPriority) {
        this.iconSlotPriority = iconSlotPriority;
    }

    public Map<InventorySlot, AbstractWeapon> getWeapons() {
        return this.weapons;
    }

    public void addWeapon(InventorySlot slot, AbstractWeapon weaponItem) {
        this.removeIgnoredSlot(slot);
        if (weaponItem == null) {
            this.weapons.remove((Object)slot);
        } else {
            this.weapons.put(slot, weaponItem);
        }
    }

    public Map<InventorySlot, AbstractClothing> getClothing() {
        return this.clothing;
    }

    public void addClothing(InventorySlot slot, AbstractClothing clothingItem) {
        this.removeIgnoredSlot(slot);
        if (clothingItem == null) {
            this.clothing.remove((Object)slot);
        } else {
            this.clothing.put(slot, clothingItem);
        }
    }

    public void clearSlot(InventorySlot slot) {
        if (slot.isWeapon()) {
            this.addWeapon(slot, null);
        } else {
            this.addClothing(slot, null);
        }
        if (this.iconSlotPriority == slot) {
            slot = null;
        }
    }

    public Set<InventorySlot> getIgnoredSlots() {
        return this.ignoredSlots;
    }

    public boolean removeIgnoredSlot(InventorySlot ignoredSlot) {
        return this.ignoredSlots.remove((Object)ignoredSlot);
    }

    public boolean addIgnoredSlot(InventorySlot ignoredSlot) {
        this.clearSlot(ignoredSlot);
        return this.ignoredSlots.add(ignoredSlot);
    }

    @Override
    public Element saveAsXML(Element parentElement, Document doc) {
        Element innerElement;
        Element element = doc.createElement("outfit");
        parentElement.appendChild(element);
        XMLUtil.addAttribute(doc, element, "gameCreationID", String.valueOf(this.gameCreationID));
        XMLUtil.addAttribute(doc, element, "name", this.name);
        if (this.iconSlotPriority != null) {
            XMLUtil.addAttribute(doc, element, "iconSlotPriority", this.iconSlotPriority.toString());
        }
        if (!this.getWeapons().isEmpty()) {
            innerElement = doc.createElement("weapons");
            element.appendChild(innerElement);
            for (Map.Entry<InventorySlot, AbstractWeapon> entry : this.getWeapons().entrySet()) {
                Element weaponElement = doc.createElement("weaponWrapper");
                innerElement.appendChild(weaponElement);
                XMLUtil.addAttribute(doc, weaponElement, "slot", entry.getKey().toString());
                entry.getValue().saveAsXML(weaponElement, doc);
            }
        }
        if (!this.getClothing().isEmpty()) {
            innerElement = doc.createElement("clothing");
            element.appendChild(innerElement);
            for (Map.Entry entry : this.getClothing().entrySet()) {
                Element clothingElement = doc.createElement("clothingWrapper");
                innerElement.appendChild(clothingElement);
                XMLUtil.addAttribute(doc, clothingElement, "slot", ((InventorySlot)((Object)entry.getKey())).toString());
                ((AbstractClothing)entry.getValue()).saveAsXML(clothingElement, doc);
            }
        }
        if (!this.getIgnoredSlots().isEmpty()) {
            innerElement = doc.createElement("ignoredSlots");
            element.appendChild(innerElement);
            for (InventorySlot inventorySlot : this.getIgnoredSlots()) {
                Element e = doc.createElement("slot");
                e.setTextContent(inventorySlot.toString());
                innerElement.appendChild(e);
            }
        }
        return element;
    }

    public static Outfit loadFromXML(Element parentElement, Document doc) {
        Element e;
        int i;
        Element element2;
        long newID = -1L;
        String newName = "outfit";
        InventorySlot newIconSlotPriority = null;
        HashMap<InventorySlot, AbstractWeapon> newWeapons = new HashMap<InventorySlot, AbstractWeapon>();
        HashMap<InventorySlot, AbstractClothing> newClothing = new HashMap<InventorySlot, AbstractClothing>();
        HashSet<InventorySlot> newIgnoredSlots = new HashSet<InventorySlot>();
        try {
            newID = Long.valueOf(parentElement.getAttribute("gameCreationID"));
        }
        catch (Exception ex) {
            System.err.println("Warning: An instance of Outfit was missing the 'gameCreationID' Attribute. (Using '-1' as ID instead.)");
        }
        try {
            newName = parentElement.getAttribute("name");
        }
        catch (Exception ex) {
            System.err.println("Warning: An instance of Outfit was missing the 'name' Attribute. (Using 'outfit' as name instead.)");
        }
        if (parentElement.hasAttribute("iconSlotPriority")) {
            try {
                newIconSlotPriority = InventorySlot.valueOf(parentElement.getAttribute("iconSlotPriority"));
            }
            catch (Exception ex) {
                System.err.println("Warning: An instance of iconSlotPriority failed to load");
            }
        }
        try {
            element2 = (Element)parentElement.getElementsByTagName("weapons").item(0);
            if (element2 != null) {
                NodeList weaponElements = element2.getElementsByTagName("weaponWrapper");
                for (i = 0; i < weaponElements.getLength(); ++i) {
                    e = (Element)weaponElements.item(i);
                    newWeapons.put(InventorySlot.valueOf(e.getAttribute("slot")), AbstractWeapon.loadFromXML((Element)e.getElementsByTagName("weapon").item(0), doc));
                }
            }
        }
        catch (Exception element2) {
            // empty catch block
        }
        try {
            element2 = (Element)parentElement.getElementsByTagName("clothing").item(0);
            if (element2 != null) {
                NodeList clothingElements = element2.getElementsByTagName("clothingWrapper");
                for (i = 0; i < clothingElements.getLength(); ++i) {
                    e = (Element)clothingElements.item(i);
                    newClothing.put(InventorySlot.valueOf(e.getAttribute("slot")), AbstractClothing.loadFromXML((Element)e.getElementsByTagName("clothing").item(0), doc));
                }
            }
        }
        catch (Exception element3) {
            // empty catch block
        }
        try {
            element2 = (Element)parentElement.getElementsByTagName("ignoredSlots").item(0);
            if (element2 != null) {
                NodeList slotElements = element2.getElementsByTagName("slot");
                for (i = 0; i < slotElements.getLength(); ++i) {
                    e = (Element)slotElements.item(i);
                    newIgnoredSlots.add(InventorySlot.valueOf(e.getTextContent()));
                }
            }
        }
        catch (Exception element4) {
            // empty catch block
        }
        Outfit newOutfit = new Outfit(newName, newWeapons, newClothing);
        newOutfit.gameCreationID = newID;
        newOutfit.ignoredSlots = newIgnoredSlots;
        if (newIconSlotPriority != null) {
            newOutfit.iconSlotPriority = newIconSlotPriority;
        }
        return newOutfit;
    }

    public String getIconSVG() {
        if (this.iconSlotPriority != null) {
            if (this.clothing.get((Object)this.iconSlotPriority) != null) {
                return this.clothing.get((Object)this.iconSlotPriority).getSVGString();
            }
            if (this.weapons.get((Object)this.iconSlotPriority) != null) {
                return this.weapons.get((Object)this.iconSlotPriority).getSVGString();
            }
        }
        int maxValue = 0;
        AbstractClothing maxValueClothing = null;
        for (AbstractClothing c : this.clothing.values()) {
            if (c.getValue() <= maxValue) continue;
            maxValueClothing = c;
            maxValue = c.getValue();
        }
        if (maxValueClothing != null) {
            return maxValueClothing.getSVGString();
        }
        maxValue = 0;
        AbstractWeapon maxValueWeapon = null;
        for (AbstractWeapon w : this.weapons.values()) {
            if (w.getValue() <= maxValue) continue;
            maxValueWeapon = w;
            maxValue = w.getValue();
        }
        if (maxValueWeapon != null) {
            return maxValueWeapon.getSVGString();
        }
        return "";
    }

    public int getCost() {
        int cost = 0;
        for (AbstractClothing c : this.clothing.values()) {
            cost += c.getValue();
        }
        for (AbstractWeapon w : this.weapons.values()) {
            cost += w.getValue();
        }
        return cost;
    }

    public int getEssenceCost() {
        int cost = 0;
        for (AbstractClothing c : this.clothing.values()) {
            cost += LilayaDressingRoomDialogue.getClothingEssenceCost(c);
        }
        for (AbstractWeapon w : this.weapons.values()) {
            cost += LilayaDressingRoomDialogue.getWeaponEssenceCost(w);
        }
        return cost;
    }
}

