/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.inventory.weapon;

import com.lilithsthrone.controller.xmlParsing.XMLUtil;
import com.lilithsthrone.game.Game;
import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.attributes.AbstractAttribute;
import com.lilithsthrone.game.character.attributes.Attribute;
import com.lilithsthrone.game.combat.Attack;
import com.lilithsthrone.game.combat.DamageType;
import com.lilithsthrone.game.combat.moves.AbstractCombatMove;
import com.lilithsthrone.game.combat.moves.CombatMove;
import com.lilithsthrone.game.combat.spells.Spell;
import com.lilithsthrone.game.combat.spells.SpellSchool;
import com.lilithsthrone.game.dialogue.utils.ParserTag;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.game.inventory.AbstractCoreItem;
import com.lilithsthrone.game.inventory.AbstractCoreType;
import com.lilithsthrone.game.inventory.InventorySlot;
import com.lilithsthrone.game.inventory.ItemTag;
import com.lilithsthrone.game.inventory.Rarity;
import com.lilithsthrone.game.inventory.clothing.BodyPartClothingBlock;
import com.lilithsthrone.game.inventory.enchanting.AbstractItemEffectType;
import com.lilithsthrone.game.inventory.enchanting.ItemEffect;
import com.lilithsthrone.game.inventory.enchanting.ItemEffectType;
import com.lilithsthrone.game.inventory.enchanting.TFModifier;
import com.lilithsthrone.game.inventory.enchanting.TFPotency;
import com.lilithsthrone.game.inventory.weapon.AbstractWeaponType;
import com.lilithsthrone.game.inventory.weapon.WeaponType;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.utils.Util;
import com.lilithsthrone.utils.XMLSaving;
import com.lilithsthrone.utils.colours.Colour;
import com.lilithsthrone.utils.colours.PresetColour;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class AbstractWeapon
extends AbstractCoreItem
implements XMLSaving {
    private AbstractWeaponType weaponType;
    protected List<ItemEffect> effects;
    private DamageType damageType;
    private AbstractAttribute coreEnchantment;
    private List<Spell> spells;
    private List<AbstractCombatMove> combatMoves;

    public AbstractWeapon(AbstractWeaponType weaponType, DamageType damageType, List<Colour> colours) {
        super(weaponType.getName(), weaponType.getNamePlural(), weaponType.getPathName(), damageType.getMultiplierAttribute().getColour(), weaponType.getRarity(), null);
        this.weaponType = weaponType;
        this.damageType = damageType;
        this.colours = new ArrayList<Colour>(colours);
        if (colours.size() < weaponType.getColourReplacements(false).size()) {
            for (int i = colours.size(); i < weaponType.getColourReplacements(false).size(); ++i) {
                this.setColour(i, weaponType.getColourReplacements(false).get(i).getFirstOfDefaultColours());
            }
        }
        this.coreEnchantment = null;
        this.spells = new ArrayList<Spell>(weaponType.getSpells(damageType));
        this.combatMoves = new ArrayList<AbstractCombatMove>(weaponType.getCombatMoves(damageType));
        this.effects = new ArrayList<ItemEffect>();
        if (weaponType.getEffects() != null) {
            for (ItemEffect effect : weaponType.getEffects()) {
                if (effect.getSecondaryModifier() == TFModifier.DAMAGE_WEAPON) {
                    switch (damageType) {
                        case FIRE: {
                            this.effects.add(new ItemEffect(ItemEffectType.WEAPON, TFModifier.CLOTHING_ATTRIBUTE, TFModifier.DAMAGE_FIRE, effect.getPotency(), 0));
                            break;
                        }
                        case ICE: {
                            this.effects.add(new ItemEffect(ItemEffectType.WEAPON, TFModifier.CLOTHING_ATTRIBUTE, TFModifier.DAMAGE_ICE, effect.getPotency(), 0));
                            break;
                        }
                        case LUST: {
                            this.effects.add(new ItemEffect(ItemEffectType.WEAPON, TFModifier.CLOTHING_ATTRIBUTE, TFModifier.DAMAGE_LUST, effect.getPotency(), 0));
                            break;
                        }
                        case MISC: 
                        case UNARMED: 
                        case HEALTH: {
                            break;
                        }
                        case PHYSICAL: {
                            this.effects.add(new ItemEffect(ItemEffectType.WEAPON, TFModifier.CLOTHING_ATTRIBUTE, TFModifier.DAMAGE_PHYSICAL, effect.getPotency(), 0));
                            break;
                        }
                        case POISON: {
                            this.effects.add(new ItemEffect(ItemEffectType.WEAPON, TFModifier.CLOTHING_ATTRIBUTE, TFModifier.DAMAGE_POISON, effect.getPotency(), 0));
                        }
                    }
                    continue;
                }
                if (effect.getSecondaryModifier() == TFModifier.RESISTANCE_WEAPON) {
                    switch (damageType) {
                        case FIRE: {
                            this.effects.add(new ItemEffect(ItemEffectType.WEAPON, TFModifier.CLOTHING_ATTRIBUTE, TFModifier.RESISTANCE_FIRE, effect.getPotency(), 0));
                            break;
                        }
                        case ICE: {
                            this.effects.add(new ItemEffect(ItemEffectType.WEAPON, TFModifier.CLOTHING_ATTRIBUTE, TFModifier.RESISTANCE_ICE, effect.getPotency(), 0));
                            break;
                        }
                        case LUST: {
                            this.effects.add(new ItemEffect(ItemEffectType.WEAPON, TFModifier.CLOTHING_ATTRIBUTE, TFModifier.RESISTANCE_LUST, effect.getPotency(), 0));
                            break;
                        }
                        case MISC: 
                        case UNARMED: 
                        case HEALTH: {
                            break;
                        }
                        case PHYSICAL: {
                            this.effects.add(new ItemEffect(ItemEffectType.WEAPON, TFModifier.CLOTHING_ATTRIBUTE, TFModifier.RESISTANCE_PHYSICAL, effect.getPotency(), 0));
                            break;
                        }
                        case POISON: {
                            this.effects.add(new ItemEffect(ItemEffectType.WEAPON, TFModifier.CLOTHING_ATTRIBUTE, TFModifier.RESISTANCE_POISON, effect.getPotency(), 0));
                        }
                    }
                    continue;
                }
                this.effects.add(effect);
            }
        }
        int highestEnchantment = 0;
        for (AbstractAttribute a : new HashSet<AbstractAttribute>(this.getAttributeModifiers().keySet())) {
            if (this.getAttributeModifiers().get(a) <= highestEnchantment) continue;
            this.coreEnchantment = a;
            highestEnchantment = this.getAttributeModifiers().get(a);
        }
    }

    public AbstractWeapon(AbstractWeapon weapon) {
        this(weapon.getWeaponType(), weapon.getDamageType(), weapon.getColours());
        if (!weapon.getWeaponType().isSpellRegenOnDamageTypeChange()) {
            this.spells = new ArrayList<Spell>(weapon.getSpells());
        }
        if (!weapon.getWeaponType().isCombatMoveRegenOnDamageTypeChange()) {
            this.combatMoves = new ArrayList<AbstractCombatMove>(weapon.getCombatMoves());
        }
        this.setEffects(new ArrayList<ItemEffect>(weapon.getEffects()));
        int highestEnchantment = 0;
        for (AbstractAttribute a : new HashSet<AbstractAttribute>(this.getAttributeModifiers().keySet())) {
            if (this.getAttributeModifiers().get(a) <= highestEnchantment) continue;
            this.coreEnchantment = a;
            highestEnchantment = this.getAttributeModifiers().get(a);
        }
        if (!weapon.name.isEmpty()) {
            this.setName(weapon.name);
        }
    }

    public String getId() {
        StringBuilder sb = new StringBuilder();
        sb.append(WeaponType.getIdFromWeaponType(this.getWeaponType()));
        for (Colour colour : this.getColours()) {
            sb.append(colour.getId());
        }
        sb.append(this.getDamageType().toString());
        sb.append(this.getCoreEnchantment() == null ? "ne" : this.getCoreEnchantment().toString());
        for (Spell s : this.getSpells()) {
            sb.append(s.toString());
        }
        for (ItemEffect ie : this.getEffects()) {
            sb.append(ie.getId());
        }
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o) && o instanceof AbstractWeapon && ((AbstractWeapon)o).getWeaponType().equals(this.getWeaponType()) && ((AbstractWeapon)o).getColours().equals(this.getColours()) && ((AbstractWeapon)o).getDamageType() == this.getDamageType() && ((AbstractWeapon)o).getCoreEnchantment() == this.getCoreEnchantment() && ((AbstractWeapon)o).getSpells().equals(this.getSpells()) && ((AbstractWeapon)o).getEffects().equals(this.getEffects());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.getWeaponType().hashCode();
        result = 31 * result + this.getDamageType().hashCode();
        result = 31 * result + this.getColours().hashCode();
        if (this.getCoreEnchantment() != null) {
            result = 31 * result + this.getCoreEnchantment().hashCode();
        }
        result = 31 * result + this.getSpells().hashCode();
        result = 31 * result + this.getEffects().hashCode();
        return result;
    }

    @Override
    public Element saveAsXML(Element parentElement, Document doc) {
        Element innerElement;
        Element element = doc.createElement("weapon");
        parentElement.appendChild(element);
        XMLUtil.addAttribute(doc, element, "id", this.getWeaponType().getId());
        XMLUtil.addAttribute(doc, element, "name", this.name);
        XMLUtil.addAttribute(doc, element, "damageType", this.getDamageType().toString());
        XMLUtil.addAttribute(doc, element, "coreEnchantment", this.getCoreEnchantment() == null ? "null" : Attribute.getIdFromAttribute(this.getCoreEnchantment()));
        if (!this.getColours().isEmpty()) {
            innerElement = doc.createElement("colours");
            element.appendChild(innerElement);
            for (int i = 0; i < this.getColours().size(); ++i) {
                Element colourElement = doc.createElement("colour");
                innerElement.appendChild(colourElement);
                colourElement.setAttribute("i", String.valueOf(i));
                if (this.getColour(i) == null) {
                    colourElement.setTextContent(PresetColour.CLOTHING_BLACK.getId());
                    continue;
                }
                colourElement.setTextContent(this.getColour(i).getId());
            }
        }
        innerElement = doc.createElement("effects");
        element.appendChild(innerElement);
        for (ItemEffect ie : this.getEffects()) {
            ie.saveAsXML(innerElement, doc);
        }
        innerElement = doc.createElement("spells");
        element.appendChild(innerElement);
        for (Spell s : this.getSpells()) {
            Element spell = doc.createElement("spell");
            innerElement.appendChild(spell);
            XMLUtil.addAttribute(doc, spell, "value", s.toString());
        }
        innerElement = doc.createElement("combatMoves");
        element.appendChild(innerElement);
        for (AbstractCombatMove cm : this.getCombatMoves()) {
            Element move = doc.createElement("move");
            innerElement.appendChild(move);
            XMLUtil.addAttribute(doc, move, "value", cm.getIdentifier());
        }
        return element;
    }

    /*
     * Unable to fully structure code
     */
    public static AbstractWeapon loadFromXML(Element parentElement, Document doc) {
        weapon = null;
        try {
            id = parentElement.getAttribute("id");
            weapon = Main.game.getItemGen().generateWeapon(WeaponType.getWeaponTypeFromId(id), DamageType.valueOf(parentElement.getAttribute("damageType")));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println("Warning: An instance of AbstractWeapon was unable to be imported. (" + parentElement.getAttribute("id") + ")");
            return null;
        }
        if (weapon == null) {
            System.err.println("Warning: An instance of AbstractWeapon was unable to be imported. (" + parentElement.getAttribute("id") + ")");
            return null;
        }
        if (!parentElement.getAttribute("name").isEmpty()) {
            weapon.setName(parentElement.getAttribute("name"));
        }
        if (!parentElement.getAttribute("coreEnchantment").equals("null")) {
            try {
                weapon.coreEnchantment = Attribute.getAttributeFromId(parentElement.getAttribute("coreEnchantment"));
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (!Main.isVersionOlderThan(Game.loadingVersion, "0.3.7.8")) {
            colourElement = (Element)parentElement.getElementsByTagName("colours").item(0);
            if (colourElement != null) {
                nodes = colourElement.getElementsByTagName("colour");
                for (i = 0; i < nodes.getLength(); ++i) {
                    cElement = (Element)nodes.item(i);
                    weapon.setColour(Integer.valueOf(cElement.getAttribute("i")), PresetColour.getColourFromId(cElement.getTextContent()));
                }
            }
        } else {
            try {
                if (Main.isVersionOlderThan(Game.loadingVersion, "0.3.7.4") && weapon.getWeaponType().equals(WeaponType.getWeaponTypeFromId("innoxia_bow_shortbow"))) ** GOTO lbl42
                if (!parentElement.getAttribute("colourPrimary").isEmpty()) {
                    weapon.setColour(0, PresetColour.getColourFromId(parentElement.getAttribute("colourPrimary")));
                }
                if (!parentElement.getAttribute("colourSecondary").isEmpty()) {
                    weapon.setColour(1, PresetColour.getColourFromId(parentElement.getAttribute("colourSecondary")));
                }
                if (parentElement.getAttribute("colourTertiary").isEmpty()) ** GOTO lbl42
                weapon.setColour(2, PresetColour.getColourFromId(parentElement.getAttribute("colourTertiary")));
            }
            catch (Exception colourElement) {
                // empty catch block
            }
        }
lbl42:
        // 5 sources

        if (!Main.isVersionOlderThan(Game.loadingVersion, "0.2.10.5")) {
            try {
                weapon.getEffects().clear();
                element = (Element)parentElement.getElementsByTagName("effects").item(0);
                effectElements = element.getElementsByTagName("effect");
                for (i = 0; i < effectElements.getLength(); ++i) {
                    e = (Element)effectElements.item(i);
                    ie = ItemEffect.loadFromXML(e, doc);
                    if (ie == null) continue;
                    weapon.addEffect(ie);
                }
            }
            catch (Exception element) {
                // empty catch block
            }
        }
        weapon.spells = new ArrayList<Spell>();
        element = (Element)parentElement.getElementsByTagName("spells").item(0);
        spellElements = element.getElementsByTagName("spell");
        for (i = 0; i < spellElements.getLength(); ++i) {
            e = (Element)spellElements.item(i);
            try {
                weaponId = e.getAttribute("value");
                if (weaponId.equals("DARK_SIREN_BANEFUL_FISSURE")) {
                    weaponId = "DARK_SIREN_SIRENS_CALL";
                }
                weapon.spells.add(Spell.valueOf(weaponId));
                continue;
            }
            catch (Exception weaponId) {
                // empty catch block
            }
        }
        weapon.combatMoves = new ArrayList<AbstractCombatMove>();
        element = (Element)parentElement.getElementsByTagName("combatMoves").item(0);
        if (element != null) {
            combatMoveElements = element.getElementsByTagName("move");
            for (i = 0; i < combatMoveElements.getLength(); ++i) {
                e = (Element)combatMoveElements.item(i);
                try {
                    identifier = e.getAttribute("value");
                    weapon.combatMoves.add(CombatMove.getCombatMoveFromId(identifier));
                    continue;
                }
                catch (Exception var8_16) {
                    // empty catch block
                }
            }
        }
        return weapon;
    }

    public abstract String onEquip(GameCharacter var1);

    public abstract String onUnequip(GameCharacter var1);

    public String getTypeDescription(GameCharacter characterEquippedOn) {
        String description = this.getWeaponType().getDescription();
        return UtilText.parse(characterEquippedOn, (AbstractCoreItem)this, description, new ParserTag[0]);
    }

    @Override
    public String getDescription(GameCharacter character) {
        StringBuilder descriptionSB = new StringBuilder();
        if (character == null || !character.hasWeaponEquipped(this)) {
            character = Main.game.getPlayer();
        }
        int essenceCost = this.getWeaponType().getArcaneCost();
        String damageName = "<span style='color:" + this.damageType.getMultiplierAttribute().getColour().toWebHexString() + ";'>\u4f24\u5bb3</span>";
        descriptionSB.append("<p>");
        descriptionSB.append("<span style='color:" + this.getRarity().getColour().toWebHexString() + ";'>" + Util.capitaliseSentence(this.getRarity().getName()) + "</span> | " + (this.getWeaponType().isUsingUnarmedCalculation() ? "[style.colourUnarmed(\u5f92\u624b)]" : (this.getWeaponType().isMelee() ? "[style.colourMelee(\u8fd1\u6218)]" : "[style.colourRanged(\u8fdc\u7a0b)]")) + "<br/>");
        descriptionSB.append(this.getWeaponType().isTwoHanded() ? "\u53cc\u624b" : "\u5355\u624b");
        if (this.getWeaponType().isOneShot()) {
            descriptionSB.append(" - [style.colourYellow(\u5355\u53d1)]");
        }
        descriptionSB.append("<br/>");
        if (essenceCost > 0) {
            descriptionSB.append((this.getWeaponType().isMelee() ? "\u6bcf\u6b21\u653b\u51fb" : "\u5c04\u51fb") + "\u6d88\u8017[style.colourArcane(" + essenceCost + "\u5965\u672f\u7cbe\u534e)]\u3002<br/>");
        }
        if (this.getWeaponType().isUsingUnarmedCalculation()) {
            descriptionSB.append("\u5305\u62ec[style.boldUnarmed(" + character.getUnarmedDamage() + "\u5f92\u624b\u4f24\u5bb3)]<br/>");
        }
        descriptionSB.append(Attack.getMinimumDamage(character, null, Attack.MAIN, this) + "-" + Attack.getMaximumDamage(character, null, Attack.MAIN, this) + damageName + "<br/>");
        int targetNumber = 2;
        for (Util.Value<Integer, Integer> value : this.getWeaponType().getAoeDamage()) {
            int aoeChance = value.getKey();
            String position = Util.intToPosition(targetNumber);
            descriptionSB.append("[style.boldAqua(\u8303\u56f4\u4f24\u5bb3)]:<span style='color:" + (aoeChance <= 25 ? PresetColour.GENERIC_BAD : (aoeChance <= 50 ? PresetColour.GENERIC_MINOR_BAD : (aoeChance <= 75 ? PresetColour.GENERIC_MINOR_GOOD : PresetColour.GENERIC_GOOD))).toWebHexString() + ";'>" + aoeChance + "%</span>\u6982\u7387\u9020\u6210" + Attack.getMinimumDamage(character, null, Attack.MAIN, this, value.getValue().intValue()) + " - " + Attack.getMaximumDamage(character, null, Attack.MAIN, this, value.getValue().intValue()) + " " + damageName + "\u5bf9\u4e8e" + UtilText.generateSingularDeterminer(position) + position + "\u4e2a\u654c\u4eba\uff01<br/>");
            ++targetNumber;
        }
        if (this.getWeaponType().isOneShot()) {
            int chanceToRecoverTurn = (int)this.getWeaponType().getOneShotChanceToRecoverAfterTurn();
            int n = (int)this.getWeaponType().getOneShotChanceToRecoverAfterCombat();
            descriptionSB.append("<span style='color:" + (chanceToRecoverTurn <= 25 ? PresetColour.GENERIC_BAD : (chanceToRecoverTurn <= 50 ? PresetColour.GENERIC_MINOR_BAD : (chanceToRecoverTurn <= 75 ? PresetColour.GENERIC_MINOR_GOOD : PresetColour.GENERIC_GOOD))).toWebHexString() + "'>" + chanceToRecoverTurn + "%</span>\u6709\u6982\u7387[style.colourBlueLight(\u4f7f\u7528\u540e)]\u6062\u590d<br/>");
            descriptionSB.append("<span style='color:" + (n <= 25 ? PresetColour.GENERIC_BAD : (n <= 50 ? PresetColour.GENERIC_MINOR_BAD : (n <= 75 ? PresetColour.GENERIC_MINOR_GOOD : PresetColour.GENERIC_GOOD))).toWebHexString() + ";'>" + n + "%</span>\u6709\u6982\u7387[style.colourCombat(\u6218\u6597\u540e)]\u6062\u590d<br/>");
        }
        descriptionSB.append("</p>");
        descriptionSB.append("<p>");
        descriptionSB.append(this.getTypeDescription(character));
        descriptionSB.append("<br/>");
        descriptionSB.append("\u8be5\u7269\u54c1\u4ef7\u503c\u4e3a\uff1a" + UtilText.formatAsMoney(this.getValue()));
        if (Main.game.isEnchantmentCapacityEnabled()) {
            descriptionSB.append("<br/>");
            descriptionSB.append("\u8be5\u7269\u54c1" + UtilText.addDeterminer(Attribute.ENCHANTMENT_LIMIT.getName()) + "\u7a0b\u5ea6\u4e3a\uff1a");
            if (this.getEnchantmentCapacityCost() == 0) {
                descriptionSB.append("[style.colourDisabled(" + UtilText.formatAsEnchantmentCapacityUncoloured(this.getEnchantmentCapacityCost(), "span") + ")]");
            } else {
                descriptionSB.append(UtilText.formatAsEnchantmentCapacity(this.getEnchantmentCapacityCost(), "span"));
            }
        }
        descriptionSB.append("</p>");
        if (this.getWeaponType().getPhysicalResistance() > 0.0f) {
            descriptionSB.append("<p>" + (this.getWeaponType().isPlural() ? "\u5e26\u6709\u88c5\u7532\uff0c\u80fd\u591f\u63d0\u4f9b" : "\u5e26\u6709\u88c5\u7532\uff0c\u80fd\u591f\u63d0\u4f9b") + " " + this.getWeaponType().getPhysicalResistance() + " [style.colourResPhysical(" + Attribute.RESISTANCE_PHYSICAL.getName() + ")].</p>");
        }
        if (!this.getEffects().isEmpty() || !this.getWeaponType().getExtraEffects().isEmpty()) {
            descriptionSB.append("<p>\u6548\u679c:");
            for (ItemEffect itemEffect : this.getEffects()) {
                if (itemEffect.getPrimaryModifier() == TFModifier.CLOTHING_ATTRIBUTE || itemEffect.getPrimaryModifier() == TFModifier.CLOTHING_MAJOR_ATTRIBUTE) continue;
                for (String s : itemEffect.getEffectsDescription(Main.game.getPlayer(), Main.game.getPlayer())) {
                    descriptionSB.append("<br/>" + s);
                }
            }
            for (String string : this.getWeaponType().getExtraEffects()) {
                descriptionSB.append("<br/>" + string);
            }
            for (Map.Entry entry : this.getAttributeModifiers().entrySet()) {
                descriptionSB.append("<br/>" + ((AbstractAttribute)entry.getKey()).getFormattedValue(((Integer)entry.getValue()).intValue()));
            }
            descriptionSB.append("</p>");
        }
        if (!this.spells.isEmpty()) {
            descriptionSB.append("<p>\u5176\u5965\u672f\u80fd\u91cf\u8d4b\u4e88\u4e86\u4f60\u91ca\u653e");
            int i = 0;
            for (Spell s : this.spells) {
                if (i != 0) {
                    if (i + 1 == this.spells.size()) {
                        descriptionSB.append("\u3001");
                    } else {
                        descriptionSB.append("\u3001");
                    }
                }
                descriptionSB.append("<span style='color:" + s.getSpellSchool().getColour().toWebHexString() + ";'>" + Util.capitaliseSentence(s.getName()) + "</span>");
                ++i;
            }
            descriptionSB.append("\u7684\u80fd\u529b\u3002</p>");
        }
        if (!this.combatMoves.isEmpty()) {
            descriptionSB.append("<p>\u88c5\u5907\u540e\uff0c\u80fd\u591f\u89e3\u9501\u6218\u6597\u52a8\u4f5c:");
            ArrayList<String> combatMoveNames = new ArrayList<String>();
            descriptionSB.append("[style.italicsCombat(");
            for (AbstractCombatMove cm : this.combatMoves) {
                combatMoveNames.add(cm.getName(0, character));
            }
            descriptionSB.append(Util.stringsToStringList(combatMoveNames, true));
            descriptionSB.append(")]</p>");
        }
        if (this.getWeaponType().getClothingSet() != null) {
            descriptionSB.append("<p>\u662f<span style='color:" + PresetColour.RARITY_EPIC.toWebHexString() + ";'>" + this.getWeaponType().getClothingSet().getName() + "</span>\u5957\u88c5\u7684\u4e00\u90e8\u5206\u3002</p>");
        }
        return UtilText.parse((AbstractCoreItem)this, descriptionSB.toString(), new ParserTag[0]);
    }

    @Override
    public Rarity getRarity() {
        if (this.rarity == Rarity.COMMON) {
            if (this.getWeaponType().getClothingSet() != null) {
                return Rarity.EPIC;
            }
            if (this.getEffects().size() > 1) {
                return Rarity.RARE;
            }
            if (!this.getEffects().isEmpty()) {
                return Rarity.UNCOMMON;
            }
        }
        return this.rarity;
    }

    @Override
    public int getValue() {
        float modifier = 1.0f;
        if (this.getRarity() == Rarity.JINXED) {
            modifier -= 0.25f;
        }
        if (this.getEffects() != null) {
            List types = this.effects.stream().map(ItemEffect::getPrimaryModifier).collect(Collectors.toList());
            float typeModifier = 0.025f;
            boolean clothingBonus = false;
            if (types.contains((Object)TFModifier.CLOTHING_MAJOR_ATTRIBUTE)) {
                typeModifier = 0.5f;
                clothingBonus = true;
            } else if (types.contains((Object)TFModifier.CLOTHING_ATTRIBUTE) || types.contains((Object)TFModifier.DAMAGE_WEAPON) || types.contains((Object)TFModifier.RESISTANCE_WEAPON)) {
                typeModifier = 0.2f;
                clothingBonus = true;
            }
            List potencies = this.effects.stream().map(ItemEffect::getPotency).collect(Collectors.toList());
            if (potencies.contains((Object)TFPotency.MAJOR_BOOST)) {
                modifier += (float)(clothingBonus ? TFPotency.MAJOR_BOOST.getClothingBonusValue() : TFPotency.MAJOR_BOOST.getValue()) * typeModifier;
            } else if (potencies.contains((Object)TFPotency.BOOST)) {
                modifier += (float)(clothingBonus ? TFPotency.BOOST.getClothingBonusValue() : TFPotency.BOOST.getValue()) * typeModifier;
            } else if (potencies.contains((Object)TFPotency.MINOR_BOOST)) {
                modifier += (float)(clothingBonus ? TFPotency.MINOR_BOOST.getClothingBonusValue() : TFPotency.MINOR_BOOST.getValue()) * typeModifier;
            }
        }
        modifier += this.getSpells().size() > 0 ? 0.2f : 0.0f;
        modifier += (float)this.effects.size() * 0.01f;
        if (this.getWeaponType().getClothingSet() != null) {
            modifier += 1.0f;
        }
        modifier = Math.max(0.25f, modifier);
        return Math.max(1, (int)((float)this.getWeaponType().getBaseValue() * modifier));
    }

    public List<String> getExtraDescriptions(GameCharacter characterOwner) {
        ArrayList<String> descriptionsList = new ArrayList<String>();
        for (ItemTag it : this.getWeaponType().getItemTags()) {
            descriptionsList.addAll(it.getClothingTooltipAdditions());
        }
        return descriptionsList;
    }

    public DamageType getDamageType() {
        return this.damageType;
    }

    public void setDamageType(DamageType damageType) {
        this.damageType = damageType;
    }

    public AbstractWeaponType getWeaponType() {
        return this.weaponType;
    }

    public String getName(boolean withDeterminer, boolean withRarityColour) {
        return UtilText.parse((AbstractCoreItem)this, (String)(withDeterminer ? (!this.weaponType.getDeterminer().equalsIgnoreCase("a") && !this.weaponType.getDeterminer().equalsIgnoreCase("an") ? this.weaponType.getDeterminer() : UtilText.generateSingularDeterminer(this.getWeaponType().isAppendDamageName() ? this.damageType.getWeaponDescriptor() : this.name)) : "") + (String)(this.getWeaponType().isAppendDamageName() ? (withRarityColour ? "<span style='color:" + this.damageType.getMultiplierAttribute().getColour().toWebHexString() + ";'>" + this.damageType.getWeaponDescriptor() + "</span>" : this.damageType.getWeaponDescriptor()) : "") + (withRarityColour ? "<span style='color: " + this.rarity.getColour().toWebHexString() + ";'>" + this.name + "</span>" : " " + this.name), new ParserTag[0]);
    }

    @Override
    public String getDisplayName(boolean withRarityColour) {
        return UtilText.parse((AbstractCoreItem)this, (String)(this.getWeaponType().isAppendDamageName() ? "<span style='color:" + this.damageType.getMultiplierAttribute().getColour().toWebHexString() + ";'>" + Util.capitaliseSentence(this.damageType.getWeaponDescriptor()) + "</span>" : "") + (String)(withRarityColour ? " <span style='color: " + this.rarity.getColour().toWebHexString() + ";'>" + this.name + "</span>" : this.name), new ParserTag[0]);
    }

    @Override
    public String getDisplayNamePlural(boolean withRarityColour) {
        return UtilText.parse((AbstractCoreItem)this, (String)(this.getWeaponType().isAppendDamageName() ? "<span style='color:" + this.damageType.getMultiplierAttribute().getColour().toWebHexString() + ";'>" + Util.capitaliseSentence(this.damageType.getWeaponDescriptor()) + "</span>" : "") + (String)(withRarityColour ? " <span style='color: " + this.rarity.getColour().toWebHexString() + ";'>" + this.namePlural + "</span>" : this.namePlural), new ParserTag[0]);
    }

    @Override
    public String getSVGString() {
        return this.weaponType.getSVGImage(this.damageType, this.getColours());
    }

    public String getSVGEquippedString(GameCharacter owner) {
        return this.weaponType.getSVGEquippedImage(owner, this.damageType, this.getColours());
    }

    public List<Spell> getSpells() {
        return this.spells;
    }

    public List<AbstractCombatMove> getCombatMoves() {
        return this.combatMoves;
    }

    public AbstractAttribute getCoreEnchantment() {
        return this.coreEnchantment;
    }

    public SpellSchool getSpellSchool() {
        return this.getDamageType().getSpellSchool();
    }

    public boolean isAbleToBeUsed(GameCharacter user, GameCharacter target) {
        return this.getWeaponType().isAbleToBeUsed(user, target);
    }

    public String getUnableToBeUsedDescription() {
        return this.getWeaponType().getUnableToBeUsedDescription();
    }

    public String applyExtraEffects(GameCharacter user, GameCharacter target, boolean isHit, boolean isCritical) {
        return this.getWeaponType().applyExtraEffects(user, target, isHit, isCritical).trim();
    }

    @Override
    public List<ItemEffect> getEffects() {
        return this.effects;
    }

    public void setEffects(List<ItemEffect> effects) {
        this.effects = new ArrayList<ItemEffect>(effects);
    }

    public void addEffect(ItemEffect effect) {
        this.effects.add(effect);
    }

    @Override
    public Map<AbstractAttribute, Integer> getAttributeModifiers() {
        this.attributeModifiers.clear();
        for (ItemEffect ie : this.getEffects()) {
            if (ie.getPrimaryModifier() != TFModifier.CLOTHING_ATTRIBUTE && ie.getPrimaryModifier() != TFModifier.CLOTHING_MAJOR_ATTRIBUTE || !Main.game.isEnchantmentCapacityEnabled() && ie.getSecondaryModifier() == TFModifier.ENCHANTMENT_LIMIT) continue;
            if (this.attributeModifiers.containsKey(ie.getSecondaryModifier().getAssociatedAttribute())) {
                this.attributeModifiers.put(ie.getSecondaryModifier().getAssociatedAttribute(), (Integer)this.attributeModifiers.get(ie.getSecondaryModifier().getAssociatedAttribute()) + ie.getPotency().getClothingBonusValue());
                continue;
            }
            this.attributeModifiers.put(ie.getSecondaryModifier().getAssociatedAttribute(), ie.getPotency().getClothingBonusValue());
        }
        return this.attributeModifiers;
    }

    public int getEnchantmentCapacityCost() {
        HashMap noCorruption = new HashMap();
        this.getAttributeModifiers().entrySet().stream().filter(ent -> ent.getKey() != Attribute.FERTILITY && ent.getKey() != Attribute.VIRILITY).forEach(ent -> noCorruption.put((AbstractAttribute)ent.getKey(), !((AbstractAttribute)ent.getKey()).isAffectedByEnchantmentCost() ? 0 : (Integer)ent.getValue() * (ent.getKey() == Attribute.MAJOR_CORRUPTION ? -1 : 1)));
        return noCorruption.values().stream().reduce(0, (a, b) -> a + Math.max(0, b));
    }

    @Override
    public int getEnchantmentLimit() {
        return this.weaponType.getEnchantmentLimit();
    }

    @Override
    public AbstractItemEffectType getEnchantmentEffect() {
        return this.weaponType.getEnchantmentEffect();
    }

    @Override
    public AbstractCoreType getEnchantmentItemType(List<ItemEffect> effects) {
        return this.weaponType.getEnchantmentItemType(effects);
    }

    @Override
    public Set<ItemTag> getItemTags() {
        return new HashSet<ItemTag>(this.getWeaponType().getItemTags());
    }

    public boolean isCanBeEquipped(GameCharacter clothingOwner, InventorySlot slot) {
        return this.isAbleToBeEquipped(clothingOwner, slot).getKey();
    }

    public String getCannotBeEquippedText(GameCharacter clothingOwner, InventorySlot slot) {
        return UtilText.parse(clothingOwner, this.isAbleToBeEquipped(clothingOwner, slot).getValue(), new ParserTag[0]);
    }

    public Util.Value<Boolean, String> isAbleToBeEquipped(GameCharacter clothingOwner, InventorySlot slot) {
        BodyPartClothingBlock block = slot.getBodyPartClothingBlock(clothingOwner);
        Set<ItemTag> tags = this.getItemTags();
        if (this.getWeaponType().getItemTags().contains((Object)ItemTag.UNIQUE_NO_NPC_EQUIP) && !clothingOwner.isPlayer()) {
            return new Util.Value<Boolean, String>(false, UtilText.parse("[style.colourBad(\u4f60\u53ea\u80fd\u88c5\u5907\u8fd9\u4ef6\u6b66\u5668\uff01)]", new ParserTag[0]));
        }
        if (block != null && Collections.disjoint(block.getRequiredTags(), tags)) {
            return new Util.Value<Boolean, String>(false, UtilText.parse("[style.colourBad(" + UtilText.parse(clothingOwner, block.getDescription(), new ParserTag[0]) + ")]", new ParserTag[0]));
        }
        return new Util.Value<Boolean, String>(true, "");
    }
}

