/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.occupantManagement.slave;

import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.body.CoverableArea;
import com.lilithsthrone.game.character.effects.Perk;
import com.lilithsthrone.game.character.effects.StatusEffect;
import com.lilithsthrone.game.character.fetishes.Fetish;
import com.lilithsthrone.game.character.npc.NPC;
import com.lilithsthrone.game.character.npc.NPCFlagValue;
import com.lilithsthrone.game.dialogue.DialogueFlagValue;
import com.lilithsthrone.game.dialogue.eventLog.EventLogEntry;
import com.lilithsthrone.game.dialogue.utils.ParserTag;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.game.inventory.InventorySlot;
import com.lilithsthrone.game.inventory.clothing.AbstractClothing;
import com.lilithsthrone.game.inventory.clothing.ClothingType;
import com.lilithsthrone.game.inventory.clothing.DisplacementType;
import com.lilithsthrone.game.occupantManagement.MilkingRoom;
import com.lilithsthrone.game.occupantManagement.slave.SlaveJobFlag;
import com.lilithsthrone.game.occupantManagement.slave.SlaveJobSetting;
import com.lilithsthrone.game.occupantManagement.slave.SlavePermissionSetting;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.utils.Util;
import com.lilithsthrone.utils.colours.Colour;
import com.lilithsthrone.utils.colours.PresetColour;
import com.lilithsthrone.world.AbstractWorldType;
import com.lilithsthrone.world.Cell;
import com.lilithsthrone.world.World;
import com.lilithsthrone.world.WorldType;
import com.lilithsthrone.world.places.AbstractPlaceType;
import com.lilithsthrone.world.places.PlaceType;
import com.lilithsthrone.world.places.PlaceUpgrade;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum SlaveJob {
    IDLE(PresetColour.BASE_GREY_DARK, 0.05f, -1, 0.0f, "\u7a7a\u95f2", "\u7a7a\u95f2", "\u4e0d\u7ed9\u8be5\u89d2\u8272\u5206\u914d\u5de5\u4f5c\u3002", 0.0f, 0.0f, 0, 0.0f, 0.0f, null, null, null, null, Util.newArrayListOfValues(SlaveJobFlag.INTERACTION_SEX, SlaveJobFlag.INTERACTION_BONDING, SlaveJobFlag.GUEST_CAN_WORK), null, null){

        @Override
        public boolean isAvailable(int hour, GameCharacter character) {
            return true;
        }

        private Cell getSlaveLoungeCell(GameCharacter slave) {
            Random rnd = new Random();
            rnd.setSeed(Main.game.getSecondsPassed());
            if (!slave.hasSlavePermissionSetting(SlavePermissionSetting.GENERAL_HOUSE_FREEDOM) || rnd.nextFloat() < 0.25f) {
                return null;
            }
            int hour = Main.game.getHourOfDay();
            if (slave.isSleepingAtHour(hour) || rnd.nextFloat() < 0.05f) {
                return null;
            }
            if (rnd.nextFloat() < 0.25f && slave.hasStatusEffect(StatusEffect.OVERWORKED_1) || rnd.nextFloat() < 0.5f && slave.hasStatusEffect(StatusEffect.OVERWORKED_2) || slave.hasStatusEffect(StatusEffect.OVERWORKED_3)) {
                return null;
            }
            List<Cell> cells = Main.game.getWorlds().get(WorldType.LILAYAS_HOUSE_GROUND_FLOOR).getCells(PlaceUpgrade.LILAYA_SLAVE_LOUNGE);
            cells.addAll(Main.game.getWorlds().get(WorldType.LILAYAS_HOUSE_FIRST_FLOOR).getCells(PlaceUpgrade.LILAYA_SLAVE_LOUNGE));
            cells.removeIf(c -> Main.game.getCharactersPresent((Cell)c).size() > 8);
            if (!cells.isEmpty()) {
                if (slave.isShy() && rnd.nextFloat() < 0.8f) {
                    cells.sort((c1, c2) -> c2.getCharactersPresentIds().size() - c1.getCharactersPresentIds().size());
                } else {
                    cells.sort((c1, c2) -> c1.getCharactersPresentIds().size() - c2.getCharactersPresentIds().size());
                }
                return cells.get(0);
            }
            return null;
        }

        @Override
        public void sendToWorkLocation(GameCharacter slave) {
            Cell lounge = this.getSlaveLoungeCell(slave);
            if (lounge == null) {
                slave.returnToHome();
            } else {
                slave.setLocation(lounge);
            }
        }

        @Override
        public Cell getWorkDestinationCell(GameCharacter slave) {
            Cell lounge = this.getSlaveLoungeCell(slave);
            if (lounge == null) {
                return slave.getHomeCell();
            }
            return lounge;
        }
    }
    ,
    CLEANING(PresetColour.BASE_BLUE_LIGHT, 0.05f, 20, 2.0f, "\u5973\u4ec6", "\u7537\u4ec6", "\u5b89\u6392\u8be5\u89d2\u8272\u534f\u52a9\u841d\u4e1d\u7ef4\u6301\u623f\u5c4b\u6e05\u6d01\uff0c\u62db\u5f85\u5ba2\u4eba\uff0c\u4ee5\u53ca\u505a\u5176\u4ed6\u67af\u71e5\u7684\u5bb6\u52a1\u3002", 0.0f, 0.5f, 80, 0.0f, 0.1f, null, null, null, null, Util.newArrayListOfValues(SlaveJobFlag.EXPERIENCE_GAINS, SlaveJobFlag.INTERACTION_SEX, SlaveJobFlag.INTERACTION_BONDING, SlaveJobFlag.GUEST_CAN_WORK), WorldType.LILAYAS_HOUSE_GROUND_FLOOR, PlaceType.LILAYA_HOME_CORRIDOR){

        @Override
        public void sendToWorkLocation(GameCharacter slave) {
            if (slave.getLocationPlace().getPlaceType().equals(PlaceType.LILAYA_HOME_CORRIDOR)) {
                slave.moveToAdjacentMatchingCellType(false, new AbstractPlaceType[0]);
            } else {
                AbstractWorldType worldTypeToUse = WorldType.LILAYAS_HOUSE_FIRST_FLOOR;
                if (Math.random() > 0.5) {
                    worldTypeToUse = WorldType.LILAYAS_HOUSE_GROUND_FLOOR;
                }
                slave.setRandomLocation(worldTypeToUse, PlaceType.LILAYA_HOME_CORRIDOR, false);
            }
        }
    }
    ,
    SECURITY(PresetColour.BASE_CRIMSON, 0.05f, 8, 2.0f, "\u4fdd\u5b89", "\u4fdd\u5b89", "\u5b89\u6392\u8be5\u89d2\u8272\u62c5\u4efb\u4fdd\u5b89\u3002\u603b\u6709\u4e00\u540d\u4fdd\u5b89\u88ab\u5b89\u7f6e\u5728\u5165\u53e3\uff0c\u800c\u5176\u4ed6\u7684\u5219\u5728\u8d70\u5eca\u5de1\u903b\u3002", 0.0f, 0.5f, 80, 0.0f, 0.1f, Util.newArrayListOfValues(SlaveJobSetting.SECURITY_ENTRANCE_PRIORITY, SlaveJobSetting.SECURITY_ANSWER_DOOR), Util.newArrayListOfValues(SlaveJobSetting.SECURITY_ANSWER_DOOR), null, null, Util.newArrayListOfValues(SlaveJobFlag.EXPERIENCE_GAINS, SlaveJobFlag.INTERACTION_SEX, SlaveJobFlag.INTERACTION_BONDING, SlaveJobFlag.GUEST_CAN_WORK), WorldType.LILAYAS_HOUSE_GROUND_FLOOR, PlaceType.LILAYA_HOME_ENTRANCE_HALL){

        private void moveToCorridor(GameCharacter slave) {
            if (slave.getLocationPlace().getPlaceType().equals(PlaceType.LILAYA_HOME_CORRIDOR)) {
                slave.moveToAdjacentMatchingCellType(false, new AbstractPlaceType[0]);
            } else {
                AbstractWorldType worldTypeToUse = WorldType.LILAYAS_HOUSE_FIRST_FLOOR;
                if (Math.random() > 0.5) {
                    worldTypeToUse = WorldType.LILAYAS_HOUSE_GROUND_FLOOR;
                }
                slave.setRandomLocation(worldTypeToUse, PlaceType.LILAYA_HOME_CORRIDOR, false);
            }
        }

        @Override
        public void sendToWorkLocation(GameCharacter slave) {
            Optional<NPC> guardAtEntrance = Main.game.getCharactersPresent(WorldType.LILAYAS_HOUSE_GROUND_FLOOR, PlaceType.LILAYA_HOME_ENTRANCE_HALL).stream().filter(npc -> npc.isSlave() && npc.isAtWork()).findFirst();
            if (slave.getLocationPlaceType() == PlaceType.LILAYA_HOME_ENTRANCE_HALL || !guardAtEntrance.isPresent() || guardAtEntrance.isPresent() && !guardAtEntrance.get().hasSlaveJobSetting(SECURITY, SlaveJobSetting.SECURITY_ENTRANCE_PRIORITY) && slave.hasSlaveJobSetting(SECURITY, SlaveJobSetting.SECURITY_ENTRANCE_PRIORITY)) {
                if (guardAtEntrance.isPresent() && slave.getLocationPlaceType() != PlaceType.LILAYA_HOME_ENTRANCE_HALL) {
                    this.moveToCorridor(guardAtEntrance.get());
                }
                slave.setLocation(WorldType.LILAYAS_HOUSE_GROUND_FLOOR, PlaceType.LILAYA_HOME_ENTRANCE_HALL, false);
            } else {
                this.moveToCorridor(slave);
            }
        }
    }
    ,
    LIBRARY(PresetColour.BASE_TEAL, 0.05f, 5, 1.5f, "\u56fe\u4e66\u7ba1\u7406\u5458", "\u56fe\u4e66\u7ba1\u7406\u5458", "\u5b89\u6392\u8be5\u89d2\u8272\u5728\u8389\u83b1\u96c5\u7684\u56fe\u4e66\u9986\u5de5\u4f5c\u3002", 0.0f, 0.25f, 80, 0.0f, 0.1f, null, null, null, null, Util.newArrayListOfValues(SlaveJobFlag.EXPERIENCE_GAINS, SlaveJobFlag.INTERACTION_SEX, SlaveJobFlag.INTERACTION_BONDING, SlaveJobFlag.GUEST_CAN_WORK), WorldType.LILAYAS_HOUSE_GROUND_FLOOR, PlaceType.LILAYA_HOME_LIBRARY),
    KITCHEN(PresetColour.BASE_TAN, 0.05f, 5, 2.0f, "\u53a8\u5e08", "\u53a8\u5e08", "\u5b89\u6392\u8be5\u89d2\u8272\u5728\u8389\u83b1\u96c5\u7684\u53a8\u623f\u62c5\u4efb\u53a8\u5e08\u3002", 0.0f, 0.25f, 80, 0.0f, 0.05f, null, null, null, null, Util.newArrayListOfValues(SlaveJobFlag.EXPERIENCE_GAINS, SlaveJobFlag.INTERACTION_SEX, SlaveJobFlag.INTERACTION_BONDING, SlaveJobFlag.GUEST_CAN_WORK), WorldType.LILAYAS_HOUSE_GROUND_FLOOR, PlaceType.LILAYA_HOME_KITCHEN),
    GARDEN(PresetColour.BASE_GREEN, 0.05f, 4, 2.0f, "\u56ed\u4e01", "\u56ed\u4e01", "\u5b89\u6392\u8be5\u89d2\u8272\u5728\u8389\u83b1\u96c5\u7684\u5ead\u9662\u82b1\u56ed\u4e2d\u62c5\u4efb\u56ed\u4e01\u3002", 0.0f, 0.25f, 80, 0.0f, 0.05f, null, null, null, null, Util.newArrayListOfValues(SlaveJobFlag.EXPERIENCE_GAINS, SlaveJobFlag.INTERACTION_SEX, SlaveJobFlag.INTERACTION_BONDING, SlaveJobFlag.GUEST_CAN_WORK), WorldType.LILAYAS_HOUSE_GROUND_FLOOR, PlaceType.LILAYA_HOME_GARDEN),
    LAB_ASSISTANT(PresetColour.BASE_GREEN_LIME, 0.05f, 1, 1.5f, "\u5b9e\u9a8c\u5ba4\u52a9\u624b", "\u5b9e\u9a8c\u5ba4\u52a9\u624b", "\u5b89\u6392\u8be5\u89d2\u8272\u5728\u5b9e\u9a8c\u5ba4\u534f\u52a9\u8389\u83b1\u96c5\u3002", 0.0f, 0.25f, 100, 0.0f, 0.2f, null, null, null, null, Util.newArrayListOfValues(SlaveJobFlag.EXPERIENCE_GAINS, SlaveJobFlag.INTERACTION_BONDING, SlaveJobFlag.GUEST_CAN_WORK), WorldType.LILAYAS_HOUSE_GROUND_FLOOR, PlaceType.LILAYA_HOME_LAB){

        @Override
        public boolean isAvailable(int hour, GameCharacter character) {
            if (hour < 6 || hour >= 22) {
                return false;
            }
            return super.isAvailable(hour, character);
        }

        @Override
        public String getAvailabilityText(int hour, GameCharacter character) {
            if (hour < 6 || hour >= 22) {
                return "\u8389\u83b1\u96c5\u7761\u89c9\u65f6\uff0c\u4e0d\u80fd\u6709\u4eba\u5728\u5b9e\u9a8c\u5ba4\u5de5\u4f5c\uff01";
            }
            return super.getAvailabilityText(hour, character);
        }
    }
    ,
    TEST_SUBJECT(PresetColour.BASE_RED_LIGHT, 0.5f, 5, 3.0f, "\u6d4b\u8bd5\u7528\u5177", "\u6d4b\u8bd5\u7528\u5177", "\u5141\u8bb8\u8389\u83b1\u96c5\u5c06\u8be5\u5974\u96b6\u5f53\u4f5c\u5b9e\u9a8c\u7684\u7528\u5177\u3002", -0.5f, 0.5f, 150, 0.0f, 0.0f, Util.newArrayListOfValues(SlaveJobSetting.TEST_SUBJECT_ALLOW_TRANSFORMATIONS_FEMALE, SlaveJobSetting.TEST_SUBJECT_ALLOW_TRANSFORMATIONS_MALE), null, null, null, Util.newArrayListOfValues(SlaveJobFlag.EXPERIENCE_GAINS, SlaveJobFlag.CLEANING_UNAVAILABLE), WorldType.LILAYAS_HOUSE_GROUND_FLOOR, PlaceType.LILAYA_HOME_LAB){

        @Override
        public float getAffectionGain(GameCharacter slave) {
            if (slave.isDoll()) {
                return 0.0f;
            }
            if (slave.hasFetish(Fetish.FETISH_TRANSFORMATION_RECEIVING)) {
                return 0.5f;
            }
            return -0.5f;
        }

        @Override
        public boolean isHidden(GameCharacter character) {
            return character.isDoll();
        }

        @Override
        public boolean isAvailable(int hour, GameCharacter character) {
            if (hour < 6 || hour >= 22) {
                return false;
            }
            return super.isAvailable(hour, character);
        }

        @Override
        public String getAvailabilityText(int hour, GameCharacter character) {
            if (hour < 6 || hour >= 22) {
                return "\u8389\u83b1\u96c5\u7761\u89c9\u65f6\uff0c\u4e0d\u80fd\u6709\u4eba\u5728\u5b9e\u9a8c\u5ba4\u5de5\u4f5c\uff01";
            }
            return super.getAvailabilityText(hour, character);
        }
    }
    ,
    DOLL_STATUE(PresetColour.BASE_GOLD, 0.5f, -1, 0.0f, "\u96d5\u50cf", "\u96d5\u50cf", "\u547d\u4ee4\u4f60\u7684\u73a9\u5076\u53bb\u6307\u5b9a\u4f4d\u7f6e\u4fdd\u6301\u4e0d\u52a8\u3002", 0.0f, 0.0f, 0, 0.0f, 0.0f, null, null, Util.newHashMapOfValues(new Util.Value<String, ArrayList<SlaveJobSetting>>("\u96d5\u50cf\u59ff\u52bf", Util.newArrayListOfValues(SlaveJobSetting.DOLL_STATUE_ARTISTIC, SlaveJobSetting.DOLL_STATUE_ATTENTION, SlaveJobSetting.DOLL_STATUE_STANDING_SPLIT, SlaveJobSetting.DOLL_STATUE_MISSIONARY, SlaveJobSetting.DOLL_STATUE_ALL_FOURS, SlaveJobSetting.DOLL_STATUE_SQUATTING, SlaveJobSetting.DOLL_STATUE_BRIDGE))), Util.newArrayListOfValues(SlaveJobSetting.DOLL_STATUE_ARTISTIC), Util.newArrayListOfValues(SlaveJobFlag.CLEANING_UNAVAILABLE), WorldType.LILAYAS_HOUSE_GROUND_FLOOR, PlaceType.LILAYA_HOME_CORRIDOR){

        @Override
        public boolean isHidden(GameCharacter character) {
            return !character.isDoll();
        }

        @Override
        public boolean isAvailable(int hour, GameCharacter character) {
            return character.isDoll() && !character.getHomeWorldLocation().equals(WorldType.getWorldTypeFromId("innoxia_dominion_sex_shop"));
        }

        @Override
        public String getAvailabilityText(int hour, GameCharacter character) {
            if (!character.isDoll()) {
                return "\u53ea\u6709\u73a9\u5076\u80fd\u80dc\u4efb\u626e\u6f14\u96d5\u50cf\u7684\u5de5\u4f5c\u2026\u2026";
            }
            if (character.getHomeWorldLocation().equals(WorldType.getWorldTypeFromId("innoxia_dominion_sex_shop"))) {
                return "\u5728\u6d1b\u7ef4\u8036\u7eb3\u5962\u4f88\u54c1\u5e97\u6682\u5b58\u7684\u73a9\u5076\u65e0\u6cd5\u5de5\u4f5c\u3002\u8bf7\u5148\u5c06\u5176\u79fb\u52a8\u5230\u73a9\u5076\u8d2e\u85cf\u5ba4\uff01";
            }
            return "\u8be5\u5de5\u4f5c\u53ef\u7528\uff01";
        }

        @Override
        public void sendToWorkLocation(GameCharacter slave) {
            if (slave.getSlaveStationWorldType() == null || slave.getSlaveStationLocation() == null) {
                Random rnd = new Random(slave.getBirthday().getYear() + slave.getBirthday().getDayOfYear() + slave.getBirthday().getHour() + slave.getBirthday().getMinute());
                AbstractWorldType worldType = rnd.nextFloat() < 0.5f ? WorldType.LILAYAS_HOUSE_GROUND_FLOOR : WorldType.LILAYAS_HOUSE_FIRST_FLOOR;
                World world = Main.game.getWorlds().get(worldType);
                slave.setLocation(world.getRandomCell(PlaceType.LILAYA_HOME_CORRIDOR, rnd));
            } else {
                slave.setLocation(slave.getSlaveStationWorldType(), slave.getSlaveStationLocation(), false);
            }
        }
    }
    ,
    PUBLIC_STOCKS(PresetColour.BASE_PINK_LIGHT, 0.5f, 5, 2.0f, "\u8089\u4fbf\u5668", "\u8089\u4fbf\u5668", "\u5b89\u6392\u8be5\u89d2\u8272\u88ab\u9501\u5728\u5974\u96b6\u5df7\u7684\u516c\u7528\u9888\u624b\u67b7\u4e0a\u3002", -5.0f, 1.0f, 0, 0.0f, 0.0f, Util.newArrayListOfValues(SlaveJobSetting.SEX_ORAL, SlaveJobSetting.SEX_VAGINAL, SlaveJobSetting.SEX_ANAL, SlaveJobSetting.SEX_NIPPLES), Util.newArrayListOfValues(SlaveJobSetting.SEX_ORAL, SlaveJobSetting.SEX_VAGINAL, SlaveJobSetting.SEX_ANAL), null, null, Util.newArrayListOfValues(SlaveJobFlag.EXPERIENCE_GAINS, SlaveJobFlag.CLEANING_UNAVAILABLE), WorldType.SLAVER_ALLEY, PlaceType.SLAVER_ALLEY_PUBLIC_STOCKS){

        @Override
        public float getAffectionGain(GameCharacter slave) {
            if (slave.isDoll()) {
                return 0.0f;
            }
            if (slave.hasFetish(Fetish.FETISH_NON_CON_SUB)) {
                return 1.0f;
            }
            return -5.0f;
        }
    }
    ,
    PROSTITUTE(PresetColour.BASE_PINK_DEEP, 0.5f, 10, 2.5f, "\u5993\u5973", "\u5993\u5973", "\u5b89\u6392\u8be5\u5974\u96b6\u5728\u201c\u5929\u4f7f\u4e4b\u543b\u201d\u5993\u9662\u505a\u5993\u5973\u3002", -0.25f, 0.5f, 200, 0.0f, 0.5f, Util.newArrayListOfValues(SlaveJobSetting.SEX_ORAL, SlaveJobSetting.SEX_VAGINAL, SlaveJobSetting.SEX_ANAL, SlaveJobSetting.SEX_NIPPLES, SlaveJobSetting.SEX_ORAL_DOM, SlaveJobSetting.SEX_VAGINAL_DOM, SlaveJobSetting.SEX_ANAL_DOM, SlaveJobSetting.SEX_NIPPLES_DOM), Util.newArrayListOfValues(SlaveJobSetting.SEX_ORAL, SlaveJobSetting.SEX_VAGINAL, SlaveJobSetting.SEX_ANAL), null, null, Util.newArrayListOfValues(SlaveJobFlag.EXPERIENCE_GAINS, SlaveJobFlag.INTERACTION_BONDING), WorldType.ANGELS_KISS_FIRST_FLOOR, PlaceType.ANGELS_KISS_BEDROOM){

        @Override
        public float getAffectionGain(GameCharacter slave) {
            if (slave.isDoll()) {
                return 0.0f;
            }
            if (slave.hasTraitActivated(Perk.NYMPHOMANIAC)) {
                return 1.0f;
            }
            return -0.25f;
        }

        @Override
        public boolean isAvailable(int hour, GameCharacter character) {
            if (!Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.prostitutionLicenseObtained)) {
                return false;
            }
            return super.isAvailable(hour, character);
        }

        @Override
        public String getAvailabilityText(int hour, GameCharacter character) {
            if (!Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.prostitutionLicenseObtained)) {
                return "\u4f60\u8fd8\u6ca1\u6709\u4ece\u5b89\u5409\u5c14\u90a3\u91cc\u53d6\u5f97\u8bb8\u53ef\uff0c\u65e0\u6cd5\u8ba9\u5974\u96b6\u5728\u5979\u7684\u5993\u9662\u5de5\u4f5c\uff01";
            }
            if (Main.game.getOccupancyUtil().getCharactersWorkingJob(hour, this) >= this.getSlaveLimit()) {
                return "\u5b89\u6392\u4e3a\u8be5\u5de5\u4f5c\u7684\u5974\u96b6\u6570\u91cf\u5df2\u7ecf\u8fbe\u5230\u6700\u5927\uff01";
            }
            if (character.getHomeLocationPlace().getPlaceType().equals(PlaceType.SLAVER_ALLEY_SLAVERY_ADMINISTRATION)) {
                return "\u5728\u5974\u96b6\u7ba1\u7406\u5c40\u6682\u7559\u5ba4\u7684\u5974\u96b6\u65e0\u6cd5\u5de5\u4f5c\u3002\u8bf7\u5148\u5c06\u5176\u79fb\u52a8\u5230\u4e00\u4e2a\u623f\u95f4\uff01";
            }
            if (character.getHomeWorldLocation().equals(WorldType.getWorldTypeFromId("innoxia_dominion_sex_shop"))) {
                return "\u5728\u6d1b\u7ef4\u8036\u7eb3\u5962\u4f88\u54c1\u5e97\u6682\u5b58\u7684\u73a9\u5076\u65e0\u6cd5\u5de5\u4f5c\u3002\u8bf7\u5148\u5c06\u5176\u79fb\u52a8\u5230\u73a9\u5076\u8d2e\u85cf\u5ba4\uff01";
            }
            return "\u8be5\u5de5\u4f5c\u53ef\u7528\uff01";
        }
    }
    ,
    MILKING(PresetColour.BASE_YELLOW_LIGHT, 1.0f, -1, 2.0f, "\u5976\u725b", "\u5976\u725b", "\u5b89\u6392\u8be5\u5974\u96b6\u5230\u6324\u5976\u53f0\u4e0a\uff0c\u4ece\u4ed6\u4eec\u8eab\u4e0a\u69a8\u53d6\u4e73\u6c41\u3001\u7cbe\u6db2\u3001\u7231\u6db2\u3002", -0.25f, 1.0f, 0, 0.0f, 0.0f, Util.newArrayListOfValues(SlaveJobSetting.MILKING_MILK, SlaveJobSetting.MILKING_MILK_CROTCH, SlaveJobSetting.MILKING_CUM, SlaveJobSetting.MILKING_GIRLCUM, SlaveJobSetting.MILKING_MILK_AUTO_SELL, SlaveJobSetting.MILKING_MILK_CROTCH_AUTO_SELL, SlaveJobSetting.MILKING_CUM_AUTO_SELL, SlaveJobSetting.MILKING_GIRLCUM_AUTO_SELL, SlaveJobSetting.MILKING_TEAR_HYMEN), Util.newArrayListOfValues(SlaveJobSetting.MILKING_MILK, SlaveJobSetting.MILKING_MILK_CROTCH, SlaveJobSetting.MILKING_CUM, SlaveJobSetting.MILKING_GIRLCUM), Util.newHashMapOfValues(new Util.Value<String, ArrayList<SlaveJobSetting>>("\u623f\u95f4\u504f\u597d", Util.newArrayListOfValues(SlaveJobSetting.MILKING_INDUSTRIAL, SlaveJobSetting.MILKING_REGULAR, SlaveJobSetting.MILKING_ARTISAN, SlaveJobSetting.MILKING_NO_PREFERENCE))), Util.newArrayListOfValues(SlaveJobSetting.MILKING_NO_PREFERENCE), Util.newArrayListOfValues(SlaveJobFlag.EXPERIENCE_GAINS, SlaveJobFlag.INTERACTION_BONDING, SlaveJobFlag.CLEANING_UNAVAILABLE, SlaveJobFlag.SPECIAL_UNIFORM), WorldType.LILAYAS_HOUSE_GROUND_FLOOR, PlaceType.LILAYA_HOME_ROOM_WINDOW_GROUND_FLOOR){

        @Override
        public int getSlaveLimit() {
            return Main.game.getOccupancyUtil().getMilkingRooms().size() * 8;
        }

        @Override
        public float getAffectionGain(GameCharacter slave) {
            Cell c;
            if (slave.isDoll()) {
                return 0.0f;
            }
            float aff = this.affectionGain;
            if (slave.hasFetish(Fetish.FETISH_LACTATION_SELF) && (slave.hasSlaveJobSetting(MILKING, SlaveJobSetting.MILKING_MILK) || slave.hasSlaveJobSetting(MILKING, SlaveJobSetting.MILKING_MILK_CROTCH)) || slave.hasFetish(Fetish.FETISH_CUM_STUD) && slave.hasSlaveJobSetting(MILKING, SlaveJobSetting.MILKING_CUM)) {
                aff = 0.25f;
            }
            return aff + ((c = this.getWorkDestinationCell(slave)) == null ? 0.0f : c.getPlace().getHourlyAffectionChange());
        }

        @Override
        public boolean isAvailable(int hour, GameCharacter character) {
            return character.getSlaveJob(hour) == this || !character.getHomeLocationPlace().getPlaceType().equals(PlaceType.SLAVER_ALLEY_SLAVERY_ADMINISTRATION) && !character.getHomeWorldLocation().equals(WorldType.getWorldTypeFromId("innoxia_dominion_sex_shop")) && Main.game.getOccupancyUtil().getCharactersWorkingJob(hour, MILKING) < this.getSlaveLimit();
        }

        @Override
        public String getAvailabilityText(int hour, GameCharacter character) {
            if (!this.isAvailable(hour, character)) {
                return "\u6324\u5976\u95f4\u7a7a\u95f4\u4e0d\u8db3\uff01";
            }
            if (character.getHomeLocationPlace().getPlaceType().equals(PlaceType.SLAVER_ALLEY_SLAVERY_ADMINISTRATION)) {
                return "\u5728\u5974\u96b6\u7ba1\u7406\u5c40\u6682\u7559\u5ba4\u7684\u5974\u96b6\u65e0\u6cd5\u5de5\u4f5c\u3002\u8bf7\u5148\u5c06\u5176\u79fb\u52a8\u5230\u4e00\u4e2a\u623f\u95f4\uff01";
            }
            if (character.getHomeWorldLocation().equals(WorldType.getWorldTypeFromId("innoxia_dominion_sex_shop"))) {
                return "\u5728\u6d1b\u7ef4\u8036\u7eb3\u5962\u4f88\u54c1\u5e97\u6682\u5b58\u7684\u73a9\u5076\u65e0\u6cd5\u5de5\u4f5c\u3002\u8bf7\u5148\u5c06\u5176\u79fb\u52a8\u5230\u73a9\u5076\u8d2e\u85cf\u5ba4\uff01";
            }
            return super.getAvailabilityText(hour, character);
        }

        @Override
        public AbstractWorldType getWorldLocation(GameCharacter character) {
            Cell c = MilkingRoom.getMilkingCell(character, false);
            if (c == null) {
                return null;
            }
            return c.getType();
        }

        @Override
        public AbstractPlaceType getPlaceLocation(GameCharacter character) {
            Cell c = MilkingRoom.getMilkingCell(character, false);
            if (c == null) {
                return null;
            }
            return c.getPlace().getPlaceType();
        }

        @Override
        public Cell getWorkDestinationCell(GameCharacter slave) {
            return MilkingRoom.getMilkingCell(slave, false);
        }

        @Override
        public void sendToWorkLocation(GameCharacter slave) {
            Cell c = MilkingRoom.getMilkingCell(slave, false);
            if (c != null) {
                if (c.getType() != slave.getWorldLocation() || c.getLocation() != slave.getLocation()) {
                    slave.setLocation(c.getType(), c.getLocation(), false);
                }
            } else {
                slave.returnToHome();
            }
        }

        @Override
        public void applyJobStartEffects(GameCharacter slave) {
            Cell c = MilkingRoom.getMilkingCell(slave, false);
            if (c != null) {
                AbstractClothing clothing;
                ArrayList<AbstractClothing> clothingRemoved = new ArrayList<AbstractClothing>();
                boolean equipBreastPumps = false;
                boolean equipUdderPumps = false;
                boolean equipPenisPump = false;
                boolean equipVaginaPump = false;
                if (MilkingRoom.getActualMilkPerHour(slave) > 0 && slave.hasSlaveJobSetting(this, SlaveJobSetting.MILKING_MILK)) {
                    clothingRemoved.addAll(slave.displaceClothingForAccess(CoverableArea.NIPPLES, null, true, false).keySet());
                    clothing = slave.getClothingInSlot(InventorySlot.NIPPLE);
                    if (clothing != null) {
                        if (!clothing.isMilkingEquipment()) {
                            clothingRemoved.add(clothing);
                            slave.unequipClothingIntoInventory(clothing, true, slave);
                            equipBreastPumps = true;
                        }
                    } else {
                        equipBreastPumps = true;
                    }
                }
                if (MilkingRoom.getActualCrotchMilkPerHour(slave) > 0 && slave.hasSlaveJobSetting(this, SlaveJobSetting.MILKING_MILK_CROTCH)) {
                    clothingRemoved.addAll(slave.displaceClothingForAccess(CoverableArea.NIPPLES_CROTCH, null, true, false).keySet());
                    clothing = slave.getClothingInSlot(InventorySlot.STOMACH);
                    if (clothing != null) {
                        if (!clothing.isMilkingEquipment()) {
                            clothingRemoved.add(clothing);
                            slave.unequipClothingIntoInventory(clothing, true, slave);
                            equipUdderPumps = true;
                        }
                    } else {
                        equipUdderPumps = true;
                    }
                }
                if (MilkingRoom.getActualCumPerHour(slave) > 0 && slave.hasSlaveJobSetting(this, SlaveJobSetting.MILKING_CUM)) {
                    clothingRemoved.addAll(slave.displaceClothingForAccess(CoverableArea.PENIS, null, true, false).keySet());
                    clothing = slave.getClothingInSlot(InventorySlot.PENIS);
                    if (clothing != null) {
                        if (!clothing.isMilkingEquipment()) {
                            clothingRemoved.add(clothing);
                            slave.unequipClothingIntoInventory(clothing, true, slave);
                            equipPenisPump = true;
                        }
                    } else {
                        equipPenisPump = true;
                    }
                }
                if (MilkingRoom.getActualGirlcumPerHour(slave) > 0 && slave.hasSlaveJobSetting(this, SlaveJobSetting.MILKING_GIRLCUM) && (!slave.hasHymen() || slave.hasSlaveJobSetting(this, SlaveJobSetting.MILKING_TEAR_HYMEN))) {
                    clothingRemoved.addAll(slave.displaceClothingForAccess(CoverableArea.VAGINA, null, true, false).keySet());
                    clothing = slave.getClothingInSlot(InventorySlot.VAGINA);
                    if (clothing != null) {
                        if (!clothing.isMilkingEquipment()) {
                            clothingRemoved.add(clothing);
                            slave.unequipClothingIntoInventory(clothing, true, slave);
                            equipVaginaPump = true;
                        }
                    } else {
                        equipVaginaPump = true;
                    }
                }
                if (equipBreastPumps) {
                    slave.equipClothingFromNowhere(Main.game.getItemGen().generateClothing(ClothingType.getClothingTypeFromId("innoxia_milking_breast_pumps"), false), InventorySlot.NIPPLE, true, slave);
                }
                if (equipUdderPumps) {
                    slave.equipClothingFromNowhere(Main.game.getItemGen().generateClothing(ClothingType.getClothingTypeFromId("innoxia_milking_breast_pumps"), false), InventorySlot.STOMACH, true, slave);
                }
                if (equipPenisPump) {
                    slave.equipClothingFromNowhere(Main.game.getItemGen().generateClothing(ClothingType.getClothingTypeFromId("innoxia_milking_penis_pump"), false), true, slave);
                }
                if (equipVaginaPump) {
                    slave.equipClothingFromNowhere(Main.game.getItemGen().generateClothing(ClothingType.getClothingTypeFromId("innoxia_milking_vagina_pump"), false), true, slave);
                }
                MilkingRoom room = Main.game.getOccupancyUtil().getMilkingRoom(c.getType(), c.getLocation());
                for (AbstractClothing cl2 : clothingRemoved) {
                    if (!cl2.isMilkingEquipment()) continue;
                    slave.removeClothing(cl2);
                }
                clothingRemoved.removeIf(cl -> cl.isMilkingEquipment());
                for (AbstractClothing clothing2 : clothingRemoved) {
                    if (clothing2.isMilkingEquipment()) {
                        throw new IllegalAccessError();
                    }
                    room.addClothingRemovedForMilking(slave, clothing2);
                }
            }
        }

        @Override
        public void applyJobEndEffects(GameCharacter slave) {
            MilkingRoom room = Main.game.getOccupancyUtil().getMilkingRoom(slave.getWorldLocation(), slave.getLocation());
            if (room != null) {
                List<AbstractClothing> clothingRemoved;
                AbstractClothing pump = slave.getClothingInSlot(InventorySlot.NIPPLE);
                if (pump != null && pump.getClothingType().equals(ClothingType.getClothingTypeFromId("innoxia_milking_breast_pumps"))) {
                    slave.forceUnequipClothingIntoVoid(slave, pump);
                }
                if ((pump = slave.getClothingInSlot(InventorySlot.STOMACH)) != null && pump.getClothingType().equals(ClothingType.getClothingTypeFromId("innoxia_milking_breast_pumps"))) {
                    slave.forceUnequipClothingIntoVoid(slave, pump);
                }
                if ((pump = slave.getClothingInSlot(InventorySlot.PENIS)) != null && pump.getClothingType().equals(ClothingType.getClothingTypeFromId("innoxia_milking_penis_pump"))) {
                    slave.forceUnequipClothingIntoVoid(slave, pump);
                }
                if ((pump = slave.getClothingInSlot(InventorySlot.VAGINA)) != null && pump.getClothingType().equals(ClothingType.getClothingTypeFromId("innoxia_milking_vagina_pump"))) {
                    slave.forceUnequipClothingIntoVoid(slave, pump);
                }
                if ((clothingRemoved = room.getClothingRemovedForMilking().get(slave.getId())) != null) {
                    for (AbstractClothing clothing : clothingRemoved) {
                        if (slave.getClothingCurrentlyEquipped().contains(clothing)) {
                            for (DisplacementType dt : new ArrayList<DisplacementType>(clothing.getDisplacedList())) {
                                slave.isAbleToBeReplaced(slave.getClothingInSlot(clothing.getSlotEquippedTo()), dt, true, true, slave);
                            }
                            continue;
                        }
                        if (slave.hasClothing(clothing)) {
                            slave.equipClothingFromInventory(clothing, true, slave, slave);
                            continue;
                        }
                        if (!slave.getCell().getInventory().hasClothing(clothing)) continue;
                        slave.equipClothingFromGround(clothing, true, slave);
                    }
                    room.clearClothingRemovedForMilking(slave);
                }
            }
        }
    }
    ,
    OFFICE(PresetColour.BASE_LILAC, 0.05f, 4, 2.0f, "\u529e\u516c\u5ba4\u804c\u5458", "\u529e\u516c\u5ba4\u804c\u5458", "\u5b89\u6392\u8be5\u89d2\u8272\u5230\u4f60\u5728\u8389\u83b1\u96c5\u5bb6\u91cc\u5e03\u7f6e\u7684\u529e\u516c\u5ba4\u5de5\u4f5c\u3002", 0.0f, 0.0f, 100, 0.0f, 1.0f, null, null, null, null, Util.newArrayListOfValues(SlaveJobFlag.EXPERIENCE_GAINS, SlaveJobFlag.INTERACTION_SEX, SlaveJobFlag.INTERACTION_BONDING, SlaveJobFlag.GUEST_CAN_WORK), WorldType.LILAYAS_HOUSE_GROUND_FLOOR, PlaceType.LILAYA_HOME_ROOM_WINDOW_GROUND_FLOOR){

        private Cell getOfficeCell() {
            List<Cell> cells = Main.game.getWorlds().get(WorldType.LILAYAS_HOUSE_GROUND_FLOOR).getCells(PlaceUpgrade.LILAYA_OFFICE);
            if (!cells.isEmpty()) {
                return cells.get(0);
            }
            cells = Main.game.getWorlds().get(WorldType.LILAYAS_HOUSE_FIRST_FLOOR).getCells(PlaceUpgrade.LILAYA_OFFICE);
            if (!cells.isEmpty()) {
                return cells.get(0);
            }
            return null;
        }

        @Override
        public int getSlaveLimit() {
            if (this.getOfficeCell() == null) {
                return 0;
            }
            return 4;
        }

        @Override
        public String getAvailabilityText(int hour, GameCharacter character) {
            if (!this.isAvailable(hour, character)) {
                return "\u529e\u516c\u5ba4\u7a7a\u95f4\u4e0d\u8db3\uff0c\u65e0\u6cd5\u5b89\u6392\u8be5\u5de5\u4f5c\uff01";
            }
            if (character.getHomeLocationPlace().getPlaceType().equals(PlaceType.SLAVER_ALLEY_SLAVERY_ADMINISTRATION)) {
                return "\u5728\u5974\u96b6\u7ba1\u7406\u5c40\u6682\u7559\u5ba4\u7684\u5974\u96b6\u65e0\u6cd5\u5de5\u4f5c\u3002\u8bf7\u5148\u5c06\u5176\u79fb\u52a8\u5230\u4e00\u4e2a\u623f\u95f4\uff01";
            }
            if (character.getHomeWorldLocation().equals(WorldType.getWorldTypeFromId("innoxia_dominion_sex_shop"))) {
                return "\u5728\u6d1b\u7ef4\u8036\u7eb3\u5962\u4f88\u54c1\u5e97\u6682\u5b58\u7684\u73a9\u5076\u65e0\u6cd5\u5de5\u4f5c\u3002\u8bf7\u5148\u5c06\u5176\u79fb\u52a8\u5230\u73a9\u5076\u8d2e\u85cf\u5ba4\uff01";
            }
            return super.getAvailabilityText(hour, character);
        }

        @Override
        public AbstractWorldType getWorldLocation(GameCharacter character) {
            Cell c = this.getOfficeCell();
            if (c == null) {
                return null;
            }
            return c.getType();
        }

        @Override
        public AbstractPlaceType getPlaceLocation(GameCharacter character) {
            Cell c = this.getOfficeCell();
            if (c == null) {
                return null;
            }
            return c.getPlace().getPlaceType();
        }

        @Override
        public Cell getWorkDestinationCell(GameCharacter slave) {
            return this.getOfficeCell();
        }

        @Override
        public void sendToWorkLocation(GameCharacter slave) {
            Cell c = this.getOfficeCell();
            if (c != null) {
                if (c.getType() != slave.getWorldLocation() || c.getLocation() != slave.getLocation()) {
                    slave.setLocation(c.getType(), c.getLocation(), false);
                }
            } else {
                slave.returnToHome();
            }
        }
    }
    ,
    BEDROOM(PresetColour.BASE_PERIWINKLE, 0.05f, 4, 0.0f, "\u5367\u5ba4\u7684\u5974\u96b6", "\u5367\u5ba4\u7684\u5974\u96b6", "\u5b89\u6392\u8be5\u5974\u96b6\u5728\u4f60\u7684\u5367\u5ba4\u7b49\u5019\u3002", 0.0f, 0.25f, 0, 0.0f, 0.0f, Util.newArrayListOfValues(SlaveJobSetting.BEDROOM_GREETING, SlaveJobSetting.BEDROOM_CLEAN, SlaveJobSetting.BEDROOM_WAKE_UP, SlaveJobSetting.BEDROOM_HELP_WASH), Util.newArrayListOfValues(SlaveJobSetting.BEDROOM_GREETING, SlaveJobSetting.BEDROOM_CLEAN), Util.newHashMapOfValues(new Util.Value<String, ArrayList<SlaveJobSetting>>("\u7761\u7720\u5b89\u6392", Util.newArrayListOfValues(SlaveJobSetting.BEDROOM_SLEEP_FLOOR, SlaveJobSetting.BEDROOM_SLEEP_ON_BED, SlaveJobSetting.BEDROOM_SLEEP_IN_BED))), Util.newArrayListOfValues(SlaveJobSetting.BEDROOM_SLEEP_ON_BED), Util.newArrayListOfValues(SlaveJobFlag.EXPERIENCE_GAINS, SlaveJobFlag.INTERACTION_SEX, SlaveJobFlag.INTERACTION_BONDING), WorldType.LILAYAS_HOUSE_FIRST_FLOOR, PlaceType.LILAYA_HOME_ROOM_PLAYER){

        @Override
        public void applyJobEndEffects(GameCharacter slave) {
            ((NPC)slave).removeFlag(NPCFlagValue.slaveBedroomHadSleepSex);
        }
    }
    ,
    SPA(PresetColour.BASE_AQUA, 0.05f, 8, 1.5f, "\u6c34\u7597\u4ec6\u5f79", "\u6c34\u7597\u4ec6\u5f79", "\u5b89\u6392\u8be5\u5974\u96b6\u5230\u4f60\u7684\u79c1\u4eba\u6c34\u7597\u4e2d\u5fc3\uff0c\u968f\u65f6\u51c6\u5907\u597d\u7ed9\u4f60\u6309\u6469\u6216\u8005\u6ee1\u8db3\u4f60\u7684\u8981\u6c42\u3002", 0.5f, -0.1f, 0, 0.0f, 0.0f, Util.newArrayListOfValues(SlaveJobSetting.SPA_BATHING, SlaveJobSetting.SPA_STRIP_TO_BATHE, SlaveJobSetting.SPA_MASSAGE), Util.newArrayListOfValues(SlaveJobSetting.SPA_BATHING, SlaveJobSetting.SPA_STRIP_TO_BATHE, SlaveJobSetting.SPA_MASSAGE), Util.newHashMapOfValues(new Util.Value[0]), Util.newArrayListOfValues(new SlaveJobSetting[0]), Util.newArrayListOfValues(SlaveJobFlag.EXPERIENCE_GAINS, SlaveJobFlag.INTERACTION_SEX, SlaveJobFlag.INTERACTION_BONDING), WorldType.LILAYAS_HOUSE_GROUND_FLOOR, PlaceType.LILAYA_HOME_SPA){

        @Override
        public int getSlaveLimit() {
            if (Main.game.getWorlds().get(WorldType.LILAYAS_HOUSE_GROUND_FLOOR).getCell(PlaceType.LILAYA_HOME_SPA) == null) {
                return 0;
            }
            return super.getSlaveLimit();
        }

        @Override
        public boolean isAvailable(int hour, GameCharacter character) {
            if (Main.game.getWorlds().get(WorldType.LILAYAS_HOUSE_GROUND_FLOOR).getCell(PlaceType.LILAYA_HOME_SPA) == null) {
                return false;
            }
            return super.isAvailable(hour, character);
        }

        @Override
        public String getAvailabilityText(int hour, GameCharacter character) {
            if (Main.game.getWorlds().get(WorldType.LILAYAS_HOUSE_GROUND_FLOOR).getCell(PlaceType.LILAYA_HOME_SPA) == null) {
                return "\u6c34\u7597\u4e2d\u5fc3\u5347\u7ea7\u540e\u624d\u80fd\u5b89\u6392\u8be5\u5de5\u4f5c\uff01";
            }
            return super.getAvailabilityText(hour, character);
        }

        @Override
        public AbstractWorldType getWorldLocation(GameCharacter character) {
            return WorldType.LILAYAS_HOUSE_GROUND_FLOOR;
        }
    }
    ,
    SPA_RECEPTIONIST(PresetColour.BASE_BLUE_STEEL, 0.05f, 2, 2.0f, "\u6c34\u7597\u6587\u5458", "\u6c34\u7597\u6587\u5458", "\u5b89\u6392\u8be5\u5974\u96b6\u5728\u4f60\u7684\u79c1\u4eba\u6c34\u7597\u4e2d\u5fc3\u7684\u524d\u53f0\u5de5\u4f5c\u3002", 0.0f, 0.05f, 0, 0.0f, 0.0f, Util.newArrayListOfValues(SlaveJobSetting.SPA_SHOWERING), null, null, null, Util.newArrayListOfValues(SlaveJobFlag.EXPERIENCE_GAINS, SlaveJobFlag.INTERACTION_SEX, SlaveJobFlag.INTERACTION_BONDING), WorldType.LILAYAS_HOUSE_GROUND_FLOOR, PlaceType.LILAYA_HOME_SPA){

        @Override
        public int getSlaveLimit() {
            if (Main.game.getWorlds().get(WorldType.LILAYAS_HOUSE_GROUND_FLOOR).getCell(PlaceType.LILAYA_HOME_SPA) == null) {
                return 0;
            }
            return super.getSlaveLimit();
        }

        @Override
        public boolean isAvailable(int hour, GameCharacter character) {
            if (Main.game.getWorlds().get(WorldType.LILAYAS_HOUSE_GROUND_FLOOR).getCell(PlaceType.LILAYA_HOME_SPA) == null) {
                return false;
            }
            return super.isAvailable(hour, character);
        }

        @Override
        public String getAvailabilityText(int hour, GameCharacter character) {
            if (Main.game.getWorlds().get(WorldType.LILAYAS_HOUSE_GROUND_FLOOR).getCell(PlaceType.LILAYA_HOME_SPA) == null) {
                return "\u6c34\u7597\u4e2d\u5fc3\u5347\u7ea7\u540e\u624d\u80fd\u5b89\u6392\u8be5\u5de5\u4f5c\uff01";
            }
            return super.getAvailabilityText(hour, character);
        }

        @Override
        public AbstractWorldType getWorldLocation(GameCharacter character) {
            return WorldType.LILAYAS_HOUSE_GROUND_FLOOR;
        }

        @Override
        public AbstractPlaceType getPlaceLocation(GameCharacter character) {
            if (Main.game.getWorlds().get(WorldType.LILAYAS_HOUSE_GROUND_FLOOR).getCells(PlaceUpgrade.LILAYA_SPA).isEmpty()) {
                return PlaceType.LILAYA_HOME_FOUNTAIN;
            }
            return Main.game.getWorlds().get(WorldType.LILAYAS_HOUSE_GROUND_FLOOR).getCells(PlaceUpgrade.LILAYA_SPA).get(0).getPlace().getPlaceType();
        }

        @Override
        public Cell getWorkDestinationCell(GameCharacter slave) {
            if (Main.game.getWorlds().get(WorldType.LILAYAS_HOUSE_GROUND_FLOOR).getCells(PlaceUpgrade.LILAYA_SPA).isEmpty()) {
                return Main.game.getWorlds().get(WorldType.LILAYAS_HOUSE_GROUND_FLOOR).getCells(PlaceType.LILAYA_HOME_FOUNTAIN).get(0);
            }
            return Main.game.getWorlds().get(WorldType.LILAYAS_HOUSE_GROUND_FLOOR).getCells(PlaceUpgrade.LILAYA_SPA).get(0);
        }

        @Override
        public void sendToWorkLocation(GameCharacter slave) {
            Cell c = this.getWorkDestinationCell(slave);
            if (c != null) {
                if (c.getType() != slave.getWorldLocation() || c.getLocation() != slave.getLocation()) {
                    slave.setLocation(c.getType(), c.getLocation(), false);
                }
            } else {
                slave.returnToHome();
            }
        }
    }
    ,
    DINING_HALL(PresetColour.BASE_ORANGE_LIGHT, 0.05f, 6, 2.0f, "\u670d\u52a1\u5458", "\u670d\u52a1\u5458", "\u5b89\u6392\u8be5\u89d2\u8272\u5728\u9910\u5385\u9001\u9910\u3002", 0.0f, 0.5f, 50, 0.0f, 0.05f, null, null, null, null, Util.newArrayListOfValues(SlaveJobFlag.EXPERIENCE_GAINS, SlaveJobFlag.INTERACTION_SEX, SlaveJobFlag.INTERACTION_BONDING, SlaveJobFlag.GUEST_CAN_WORK), WorldType.LILAYAS_HOUSE_GROUND_FLOOR, PlaceType.LILAYA_HOME_ROOM_WINDOW_GROUND_FLOOR){

        @Override
        public int getSlaveLimit() {
            return (Main.game.getWorlds().get(WorldType.LILAYAS_HOUSE_GROUND_FLOOR).getCells(PlaceUpgrade.LILAYA_DINING_HALL).size() + Main.game.getWorlds().get(WorldType.LILAYAS_HOUSE_FIRST_FLOOR).getCells(PlaceUpgrade.LILAYA_DINING_HALL).size()) * 6;
        }

        private Cell getDiningHallCell() {
            List<Cell> cells = Main.game.getWorlds().get(WorldType.LILAYAS_HOUSE_GROUND_FLOOR).getCells(PlaceUpgrade.LILAYA_DINING_HALL);
            cells.addAll(Main.game.getWorlds().get(WorldType.LILAYAS_HOUSE_FIRST_FLOOR).getCells(PlaceUpgrade.LILAYA_DINING_HALL));
            if (!cells.isEmpty()) {
                cells.sort((c1, c2) -> Main.game.getCharactersPresent((Cell)c1).size() - Main.game.getCharactersPresent((Cell)c2).size());
                return cells.get(0);
            }
            return null;
        }

        @Override
        public AbstractWorldType getWorldLocation(GameCharacter character) {
            Cell c = this.getDiningHallCell();
            if (c == null) {
                return null;
            }
            return c.getType();
        }

        @Override
        public AbstractPlaceType getPlaceLocation(GameCharacter character) {
            Cell c = this.getDiningHallCell();
            if (c == null) {
                return null;
            }
            return c.getPlace().getPlaceType();
        }

        @Override
        public Cell getWorkDestinationCell(GameCharacter slave) {
            return this.getDiningHallCell();
        }

        @Override
        public void sendToWorkLocation(GameCharacter slave) {
            Cell c = this.getDiningHallCell();
            if (c != null) {
                if (!(c.getType() == slave.getWorldLocation() && c.getLocation() == slave.getLocation() || Main.game.getCharactersPresent(c).size() >= Main.game.getCharactersPresent(slave.getCell()).size() - 1 && slave.getCell().getPlace().getPlaceUpgrades().contains(PlaceUpgrade.LILAYA_DINING_HALL))) {
                    slave.setLocation(c.getType(), c.getLocation(), false);
                }
            } else {
                slave.returnToHome();
            }
        }

        @Override
        public boolean isAvailable(int hour, GameCharacter character) {
            if (this.getDiningHallCell() == null) {
                return false;
            }
            return super.isAvailable(hour, character);
        }

        @Override
        public String getAvailabilityText(int hour, GameCharacter character) {
            if (this.getDiningHallCell() == null) {
                return "\u9910\u5385\u5347\u7ea7\u540e\u624d\u80fd\u5b89\u6392\u8be5\u5de5\u4f5c\uff01";
            }
            return super.getAvailabilityText(hour, character);
        }
    };

    private Colour colour;
    private float hourlyEventChance;
    private int slaveLimit;
    private float hourlyStaminaDrain;
    private String nameFeminine;
    private String nameMasculine;
    private String description;
    private float obedienceGain;
    protected float affectionGain;
    private int income;
    private float obedienceIncomeModifier;
    private float affectionIncomeModifier;
    private List<SlaveJobSetting> mutualSettings;
    private List<SlaveJobSetting> defaultMutualSettings;
    private Map<String, List<SlaveJobSetting>> mutuallyExclusiveSettings;
    private List<SlaveJobSetting> defaultMutuallyExclusiveSettings;
    private List<SlaveJobFlag> flags;
    private AbstractWorldType worldLocation;
    private AbstractPlaceType placeLocation;

    private SlaveJob(Colour colour, float hourlyEventChance, int slaveLimit, float hourlyStaminaDrain, String nameFeminine, String nameMasculine, String description, float affectionGain, float obedienceGain, int income, float affectionIncomeModifier, float obedienceIncomeModifier, List<SlaveJobSetting> mutualSettings, List<SlaveJobSetting> defaultMutualSettings, Map<String, List<SlaveJobSetting>> mutuallyExclusiveSettings, List<SlaveJobSetting> defaultMutuallyExclusiveSettings, List<SlaveJobFlag> flags, AbstractWorldType worldLocation, AbstractPlaceType placeLocation) {
        this.colour = colour;
        this.hourlyEventChance = hourlyEventChance;
        this.slaveLimit = slaveLimit;
        this.hourlyStaminaDrain = hourlyStaminaDrain;
        this.nameFeminine = nameFeminine;
        this.nameMasculine = nameMasculine;
        this.description = description;
        this.obedienceGain = obedienceGain;
        this.affectionGain = affectionGain;
        this.income = income;
        this.obedienceIncomeModifier = obedienceIncomeModifier;
        this.affectionIncomeModifier = affectionIncomeModifier;
        this.mutualSettings = mutualSettings == null ? new ArrayList<SlaveJobSetting>() : mutualSettings;
        this.defaultMutualSettings = defaultMutualSettings == null ? new ArrayList<SlaveJobSetting>() : defaultMutualSettings;
        this.mutuallyExclusiveSettings = mutuallyExclusiveSettings == null ? new HashMap<String, List<SlaveJobSetting>>() : mutuallyExclusiveSettings;
        this.defaultMutuallyExclusiveSettings = defaultMutuallyExclusiveSettings == null ? new ArrayList<SlaveJobSetting>() : defaultMutuallyExclusiveSettings;
        this.flags = flags == null ? new ArrayList<SlaveJobFlag>() : flags;
        Collections.sort(this.flags);
        this.worldLocation = worldLocation;
        this.placeLocation = placeLocation;
    }

    public Colour getColour() {
        return this.colour;
    }

    public float getHourlyEventChance() {
        return this.hourlyEventChance;
    }

    public int getSlaveLimit() {
        return this.slaveLimit;
    }

    public float getHourlyStaminaDrain(GameCharacter character) {
        if (character.isDoll()) {
            return 0.0f;
        }
        return this.hourlyStaminaDrain;
    }

    public String getName(GameCharacter character) {
        if (character.isFeminine()) {
            return this.nameFeminine;
        }
        return this.nameMasculine;
    }

    public String getNameFeminine() {
        return this.nameFeminine;
    }

    public String getNameMasculine() {
        return this.nameMasculine;
    }

    public String getDescription() {
        return this.description;
    }

    public float getObedienceGain(GameCharacter slave) {
        if (slave.isDoll()) {
            return 0.0f;
        }
        Cell c = this.getWorkDestinationCell(slave);
        return this.obedienceGain + (c == null ? 0.0f : c.getPlace().getHourlyObedienceChange());
    }

    public float getAffectionGain(GameCharacter slave) {
        if (slave.isDoll()) {
            return 0.0f;
        }
        Cell c = this.getWorkDestinationCell(slave);
        return this.affectionGain + (c == null ? 0.0f : c.getPlace().getHourlyAffectionChange());
    }

    public int getIncome() {
        return this.income;
    }

    public int getFinalHourlyIncomeAfterModifiers(GameCharacter character) {
        int value = (int)Math.max(0.0f, (float)this.income + this.getAffectionIncomeModifier() * character.getAffection(Main.game.getPlayer()) + this.getObedienceIncomeModifier() * character.getObedienceValue());
        if (this == MILKING) {
            int milked;
            value = 0;
            if (character.getBreastRawStoredMilkValue() > 0.0f && character.hasSlaveJobSetting(this, SlaveJobSetting.MILKING_MILK) && character.hasSlaveJobSetting(this, SlaveJobSetting.MILKING_MILK_AUTO_SELL)) {
                milked = MilkingRoom.getActualMilkPerHour(character);
                value = (int)((double)value + Math.ceil((float)milked * character.getMilk().getValuePerMl()));
            }
            if (character.hasBreastsCrotch() && character.getBreastCrotchRawStoredMilkValue() > 0.0f && character.hasSlaveJobSetting(this, SlaveJobSetting.MILKING_MILK_CROTCH) && character.hasSlaveJobSetting(this, SlaveJobSetting.MILKING_MILK_CROTCH_AUTO_SELL)) {
                milked = MilkingRoom.getActualCrotchMilkPerHour(character);
                value = (int)((double)value + Math.ceil((float)milked * character.getMilkCrotch().getValuePerMl()));
            }
            if (character.hasPenis() && character.getPenisRawStoredCumValue() > 0.0f && character.hasSlaveJobSetting(this, SlaveJobSetting.MILKING_CUM) && character.hasSlaveJobSetting(this, SlaveJobSetting.MILKING_CUM_AUTO_SELL)) {
                milked = MilkingRoom.getActualCumPerHour(character);
                value = (int)((double)value + Math.ceil((float)milked * character.getCum().getValuePerMl()));
            }
            if (character.hasVagina() && character.hasSlaveJobSetting(this, SlaveJobSetting.MILKING_GIRLCUM) && character.hasSlaveJobSetting(this, SlaveJobSetting.MILKING_GIRLCUM_AUTO_SELL)) {
                milked = MilkingRoom.getActualGirlcumPerHour(character);
                value = (int)((double)value + Math.ceil((float)milked * character.getGirlcum().getValuePerMl()));
            }
        }
        if (character.isSlave()) {
            if (character.getOwner().hasTrait(Perk.JOB_OFFICE_WORKER, true)) {
                return (int)(1.25f * (float)value);
            }
            if ((character.getOwner().hasTrait(Perk.JOB_MAID, true) || character.getOwner().hasTrait(Perk.JOB_BUTLER, true)) && this == CLEANING) {
                return 2 * value;
            }
        }
        return value;
    }

    public static int getFinalDailyIncomeAfterModifiers(GameCharacter character) {
        int value = 0;
        for (int i = 0; i < 24; ++i) {
            value += character.getSlaveJob(i).getFinalHourlyIncomeAfterModifiers(character);
        }
        return value;
    }

    public float getObedienceIncomeModifier() {
        return this.obedienceIncomeModifier;
    }

    public float getAffectionIncomeModifier() {
        return this.affectionIncomeModifier;
    }

    public List<SlaveJobSetting> getMutualSettings() {
        return this.mutualSettings;
    }

    public List<SlaveJobSetting> getDefaultMutualSettings() {
        return this.defaultMutualSettings;
    }

    public Map<String, List<SlaveJobSetting>> getMutuallyExclusiveSettings() {
        return this.mutuallyExclusiveSettings;
    }

    public List<SlaveJobSetting> getDefaultMutuallyExclusiveSettings() {
        return this.defaultMutuallyExclusiveSettings;
    }

    public List<SlaveJobFlag> getFlags() {
        return this.flags;
    }

    public boolean hasFlag(SlaveJobFlag flag) {
        return this.flags.contains((Object)flag);
    }

    public AbstractWorldType getWorldLocation(GameCharacter character) {
        return this.worldLocation;
    }

    public AbstractPlaceType getPlaceLocation(GameCharacter character) {
        return this.placeLocation;
    }

    public Cell getWorkDestinationCell(GameCharacter slave) {
        AbstractWorldType wType = this.getWorldLocation(slave);
        if (wType == null) {
            return null;
        }
        return Main.game.getWorlds().get(wType).getRandomUnoccupiedCell(this.getPlaceLocation(slave));
    }

    public void sendToWorkLocation(GameCharacter slave) {
        if (this.getWorldLocation(slave) != null && this.getPlaceLocation(slave) != null && (this.getWorldLocation(slave) != slave.getWorldLocation() || this.getPlaceLocation(slave) != slave.getLocationPlace().getPlaceType())) {
            slave.setRandomUnoccupiedLocation(this.getWorldLocation(slave), this.getPlaceLocation(slave), false);
        }
    }

    public boolean isAvailable(int hour, GameCharacter character) {
        return character.getSlaveJob(hour) == this || !character.getHomeLocationPlace().getPlaceType().equals(PlaceType.SLAVER_ALLEY_SLAVERY_ADMINISTRATION) && !character.getHomeWorldLocation().equals(WorldType.getWorldTypeFromId("innoxia_dominion_sex_shop")) && Main.game.getOccupancyUtil().getCharactersWorkingJob(hour, this) < this.getSlaveLimit();
    }

    public boolean isHidden(GameCharacter character) {
        return false;
    }

    public String getAvailabilityText(int hour, GameCharacter character) {
        if (Main.game.getOccupancyUtil().getCharactersWorkingJob(hour, this) >= this.getSlaveLimit()) {
            return "\u5b89\u6392\u4e3a\u8be5\u5de5\u4f5c\u7684\u89d2\u8272\u6570\u91cf\u5df2\u7ecf\u8fbe\u5230\u6700\u5927\uff01";
        }
        if (character.getHomeLocationPlace().getPlaceType().equals(PlaceType.SLAVER_ALLEY_SLAVERY_ADMINISTRATION)) {
            return "\u5728\u5974\u96b6\u7ba1\u7406\u5c40\u6682\u7559\u5ba4\u7684\u5974\u96b6\u65e0\u6cd5\u5de5\u4f5c\u3002\u8bf7\u5148\u5c06\u5176\u79fb\u52a8\u5230\u4e00\u4e2a\u623f\u95f4\uff01";
        }
        if (character.getHomeWorldLocation().equals(WorldType.getWorldTypeFromId("innoxia_dominion_sex_shop"))) {
            return "\u5728\u6d1b\u7ef4\u8036\u7eb3\u5962\u4f88\u54c1\u5e97\u6682\u5b58\u7684\u73a9\u5076\u65e0\u6cd5\u5de5\u4f5c\u3002\u8bf7\u5148\u5c06\u5176\u79fb\u52a8\u5230\u73a9\u5076\u8d2e\u85cf\u5ba4\uff01";
        }
        if (!character.isSlave() && character.isSleepingAtHour(hour)) {
            return UtilText.parse(character, "[npc.Name]\u73b0\u5728\u6b63\u5728\u8c01\u5bb6\uff0c\u800c\u4e14[npc.she]\u5e76\u975e\u4f60\u7684\u5974\u96b6\uff0c\u4f60\u65e0\u6cd5\u5f3a\u5236\u8981\u6c42[npc.herHim]\u73b0\u5728\u5de5\u4f5c\uff01", new ParserTag[0]);
        }
        return "\u8be5\u5de5\u4f5c\u4e0d\u53ef\u7528\uff01";
    }

    public EventLogEntry getHourlyEvent(long hour, NPC slave, List<NPC> otherNPCsPresent) {
        return null;
    }

    public void applyJobStartEffects(GameCharacter slave) {
    }

    public void applyJobEndEffects(GameCharacter slave) {
    }
}

