/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.occupantManagement.slaveEvent;

import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.occupantManagement.slaveEvent.SlaveEventType;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum SlaveEvent {
    WASHED_BODY(SlaveEventType.MISCELLANEOUS, "\u6d17\u51c0\u8eab\u4f53", "[npc.Name]\u6d17\u51c0\u4e86\u8eab\u4f53\u3002"){

        @Override
        public void applyEffects(GameCharacter character) {
            character.washAllOrifices(true);
            character.cleanAllDirtySlots(true);
            character.calculateStatusEffects(0);
        }
    }
    ,
    WASHED_CLOTHES(SlaveEventType.MISCELLANEOUS, "\u6d17\u51c0\u8863\u7269", "[npc.Name]\u6d17\u4e86[npc.her]\u7684\u8863\u7269\u3002"){

        @Override
        public void applyEffects(GameCharacter character) {
            character.cleanAllDirtySlots(false);
            character.cleanAllClothing(true, false);
            character.calculateStatusEffects(0);
        }
    }
    ,
    MIDDAY_UPDATE(SlaveEventType.MISCELLANEOUS, "\u6b63\u5348\u66f4\u65b0", ""),
    DAILY_UPDATE(SlaveEventType.MISCELLANEOUS, "\u6bcf\u65e5\u66f4\u65b0", ""),
    SLAVE_SEX(SlaveEventType.SEX, "[style.boldSex(Sex)]", "[npc.Name]\u548c\u5176\u4ed6\u5974\u96b6\u505a\u7231\u4e86\u2026\u2026"),
    SLAVE_BONDING(SlaveEventType.BONDING, "[style.boldAffection(\u7f81\u7eca)]", "[npc.Name]\u548c\u53e6\u4e00\u4e2a\u5974\u96b6\u8fdb\u884c\u4e86\u4ea4\u6d41\u2026\u2026"),
    GAVE_BIRTH(SlaveEventType.SEX, "[style.boldExcellent(Gave birth)]", "\u8389\u83b1\u96c5\u7ed9[npc.name]\u63a5\u751f\u4e86\u3002"),
    GAVE_BIRTH_INCUBATION(SlaveEventType.SEX, "[style.boldExcellent(Laid eggs)]", "\u8389\u83b1\u96c5\u5e2e[npc.name]\u4ea7\u4e0b\u4e86[npc.she]\u6b63\u5728\u5b75\u7684\u5375\u3002"),
    JOB_MILK_MILKED(SlaveEventType.JOB, "\u4ea7\u5976", ""),
    JOB_TEST_SUBJECT(SlaveEventType.JOB, "\u6d4b\u8bd5\u7528\u5177", "[npc.Name]\u88ab\u8389\u83b1\u96c5\u505a\u4e86\u8f6c\u5316\u5b9e\u9a8c\u2026\u2026"),
    JOB_PUBLIC_STOCKS(SlaveEventType.JOB, "\u9501\u5728\u9888\u624b\u67b7\u4e0a", "[npc.Name]\u88ab\u9501\u5728\u4e86\u5974\u96b6\u5df7\u7684\u516c\u5171\u9888\u624b\u67b7\u4e0a\u2026\u2026"),
    JOB_PROSTITUTE(SlaveEventType.JOB, "\u5356\u6deb", "[npc.Name]\u5728\u5929\u4f7f\u4e4b\u543b\u5f53\u5993\u5973\u3002");

    private SlaveEventType type;
    private String name;
    private String description;

    private SlaveEvent(SlaveEventType type, String name, String description) {
        this.type = type;
        this.name = name;
        this.description = description;
    }

    public SlaveEventType getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public void applyEffects(GameCharacter character) {
    }
}

