/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.settings;

import com.lilithsthrone.utils.Util;
import java.util.regex.Pattern;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;

public class KeyCodeWithModifiers {
    private final KeyCode keyCode;
    private final boolean controlModifier;
    private final boolean shiftModifier;

    public static KeyCodeWithModifiers fromString(String source) {
        if (source == null || source.isEmpty()) {
            return null;
        }
        boolean usesShiftModifier = false;
        boolean usesControlModifier = false;
        KeyCode keyCode = null;
        if (!source.equals("+") && source.contains("+")) {
            String[] splitted = source.split(Pattern.quote("+"));
            for (int i = 0; i < splitted.length - 1; ++i) {
                if ("SHIFT".equals(splitted[i])) {
                    usesShiftModifier = true;
                    continue;
                }
                if (!"CTRL".equals(splitted[i])) continue;
                usesControlModifier = true;
            }
            keyCode = KeyCode.valueOf(splitted[splitted.length - 1]);
        } else {
            keyCode = KeyCode.valueOf(source);
        }
        return new KeyCodeWithModifiers(keyCode, usesControlModifier, usesShiftModifier);
    }

    public KeyCodeWithModifiers(KeyCode keyCode) {
        this(keyCode, false, false);
    }

    public KeyCodeWithModifiers(KeyCode keyCode, boolean controlModifier, boolean shiftModifier) {
        this.keyCode = keyCode;
        this.controlModifier = controlModifier;
        this.shiftModifier = shiftModifier;
    }

    public KeyCode getKeyCode() {
        return this.keyCode;
    }

    public boolean isControlModifier() {
        return this.controlModifier;
    }

    public boolean isShiftModifier() {
        return this.shiftModifier;
    }

    public boolean matches(KeyEvent keyEvent) {
        return keyEvent.getCode() == this.keyCode && keyEvent.isControlDown() == this.controlModifier && keyEvent.isShiftDown() == this.shiftModifier;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.controlModifier ? 1231 : 1237);
        result = 31 * result + (this.keyCode == null ? 0 : this.keyCode.hashCode());
        result = 31 * result + (this.shiftModifier ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        KeyCodeWithModifiers other = (KeyCodeWithModifiers)obj;
        return this.keyCode == other.keyCode && this.shiftModifier == other.shiftModifier && this.controlModifier == other.controlModifier;
    }

    public String toString() {
        return (this.shiftModifier ? "SHIFT+" : "") + (this.controlModifier ? "CTRL+" : "") + this.keyCode.toString();
    }

    public String getFullName() {
        return (this.shiftModifier ? "SHIFT+" : "") + (this.controlModifier ? "CTRL+" : "") + this.keyCode.getName();
    }

    public String asHotkey() {
        return (this.shiftModifier ? "SHIFT + " : "") + (this.controlModifier ? "CTRL + " : "") + Util.getKeyCodeCharacter(this.keyCode);
    }
}

