/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.rendering;

import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.rendering.Artist;
import com.lilithsthrone.rendering.ArtistWebsite;
import com.lilithsthrone.utils.Util;
import com.lilithsthrone.utils.colours.Colour;
import com.lilithsthrone.utils.colours.PresetColour;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Artwork {
    private final GameCharacter character;
    private final Artist artist;
    private int index;
    private final List<String> clothedImages;
    private final List<String> partialImages;
    private final List<String> nakedImages;
    public static List<Artist> allArtists = new ArrayList<Artist>();
    public static Artist customArtist = new Artist("Custom", PresetColour.BASE_GREY, "custom", new ArrayList<ArtistWebsite>());

    public Artwork(GameCharacter character, File folder, Artist artist) {
        this.character = character;
        this.artist = artist;
        this.index = 0;
        this.clothedImages = new ArrayList<String>();
        this.partialImages = new ArrayList<String>();
        this.nakedImages = new ArrayList<String>();
        for (File f : folder.listFiles((dir, name) -> name.toLowerCase().endsWith(".jpg") || name.toLowerCase().endsWith(".png") || name.toLowerCase().endsWith(".gif"))) {
            if (f.getName().startsWith("partial")) {
                this.partialImages.add(f.getAbsolutePath());
                continue;
            }
            if (f.getName().startsWith("naked")) {
                this.nakedImages.add(f.getAbsolutePath());
                continue;
            }
            this.clothedImages.add(f.getAbsolutePath());
        }
    }

    public Artist getArtist() {
        return this.artist;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        if ((index %= this.getTotalArtworkCount()) < 0) {
            index = this.getTotalArtworkCount() + index;
        }
        this.index = index;
    }

    public void incrementIndex(int increment) {
        this.setIndex(this.index + increment);
    }

    public int getTotalArtworkCount() {
        return this.getFilteredImages(this.clothedImages).size() + this.getFilteredImages(this.partialImages).size() + this.getFilteredImages(this.nakedImages).size();
    }

    public boolean isCurrentImageClothed() {
        return this.index < this.getFilteredImages(this.clothedImages).size();
    }

    public File getCurrentImage() {
        String path;
        if (this.getTotalArtworkCount() == 0) {
            return null;
        }
        try {
            path = this.index < this.getFilteredImages(this.clothedImages).size() ? this.getFilteredImages(this.clothedImages).get(this.index) : (this.index < this.getFilteredImages(this.clothedImages).size() + this.getFilteredImages(this.partialImages).size() ? this.getFilteredImages(this.partialImages).get(this.index - this.getFilteredImages(this.clothedImages).size()) : this.getFilteredImages(this.nakedImages).get(this.index - this.getFilteredImages(this.clothedImages).size() - this.getFilteredImages(this.partialImages).size()));
        }
        catch (IndexOutOfBoundsException ex) {
            path = this.getFilteredImages(this.clothedImages).get(0);
        }
        if (path.isEmpty()) {
            return null;
        }
        return new File(path);
    }

    private List<String> getFilteredImages(List<String> images) {
        ArrayList<String> filteredImages = new ArrayList<String>(images);
        if (Main.game.isStarted()) {
            filteredImages.removeIf(s -> s.toLowerCase().contains("#penis") && !this.character.hasPenisIgnoreDildo());
            filteredImages.removeIf(s -> s.toLowerCase().contains("#nopenis") && this.character.hasPenisIgnoreDildo());
            filteredImages.removeIf(s -> s.toLowerCase().contains("#vagina") && !this.character.hasVagina());
            filteredImages.removeIf(s -> s.toLowerCase().contains("#novagina") && this.character.hasVagina());
            filteredImages.removeIf(s -> s.toLowerCase().contains("#preg") && !this.character.isVisiblyPregnant());
            filteredImages.removeIf(s -> s.toLowerCase().contains("#nopreg") && this.character.isVisiblyPregnant());
            filteredImages.removeIf(s -> s.toLowerCase().contains("#udders") && (!Main.game.isUdderContentEnabled() || !this.character.hasBreastsCrotch()));
            filteredImages.removeIf(s -> s.toLowerCase().contains("#noudders") && Main.game.isUdderContentEnabled() && this.character.hasBreastsCrotch());
            filteredImages.removeIf(s -> s.toLowerCase().contains("#multiboob") && this.character.getBreastRows() == 1);
            filteredImages.removeIf(s -> s.toLowerCase().contains("#nomultiboob") && this.character.getBreastRows() > 1);
        }
        return filteredImages;
    }

    public List<String> getAllImagePaths() {
        ArrayList<String> imagePaths = new ArrayList<String>();
        imagePaths.addAll(this.clothedImages);
        imagePaths.addAll(this.partialImages);
        imagePaths.addAll(this.nakedImages);
        return imagePaths;
    }

    static {
        File dir = new File("res/images/characters");
        if (dir.exists()) {
            FilenameFilter textFilter = (dir1, name) -> name.toLowerCase().endsWith(".xml");
            for (File subFile : dir.listFiles(textFilter)) {
                if (!subFile.exists()) continue;
                try {
                    Document doc = Main.getDocBuilder().parse(subFile);
                    doc.getDocumentElement().normalize();
                    Element artistElement = (Element)doc.getElementsByTagName("artist").item(0);
                    String artistName = artistElement.getAttribute("name");
                    String colourId = artistElement.getAttribute("colour");
                    Colour colour = colourId.startsWith("#") ? new Colour(false, Util.newColour(colourId), Util.newColour(colourId), "") : PresetColour.getColourFromId(colourId);
                    String folderName = artistElement.getAttribute("folderName");
                    ArrayList<ArtistWebsite> websites = new ArrayList<ArtistWebsite>();
                    NodeList nodes = artistElement.getElementsByTagName("website");
                    for (int i = 0; i < nodes.getLength(); ++i) {
                        Element websiteNode = (Element)nodes.item(i);
                        websites.add(new ArtistWebsite(websiteNode.getAttribute("title"), websiteNode.getAttribute("url")));
                    }
                    allArtists.add(new Artist(artistName, colour, folderName, websites));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            allArtists.add(customArtist);
        }
    }
}

