/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.rendering;

import com.lilithsthrone.rendering.CachedImage;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Base64;

public class CachedGif
extends CachedImage {
    private String thumbnailString;

    @Override
    public boolean load(File f) {
        CachedImage firstFrame = new CachedImage();
        if (!firstFrame.load(f)) {
            return false;
        }
        this.thumbnailString = firstFrame.getThumbnailString();
        this.percentageWidth = firstFrame.getPercentageWidth();
        this.width = firstFrame.getWidth();
        this.height = firstFrame.getHeight();
        if (f.length() / 1024L > 10240L) {
            this.imageString = firstFrame.getImageString();
            System.err.println("Warning: Animated image " + f.getName() + " is too large. Using first frame instead.");
        } else {
            try {
                this.imageString = "data:image/gif;base64," + Base64.getEncoder().encodeToString(Files.readAllBytes(f.toPath()));
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }

    @Override
    public String getThumbnailString() {
        return this.thumbnailString;
    }
}

