/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.rendering;

import com.lilithsthrone.controller.xmlParsing.Element;
import com.lilithsthrone.controller.xmlParsing.XMLLoadException;
import com.lilithsthrone.controller.xmlParsing.XMLMissingTagException;
import com.lilithsthrone.game.inventory.ColourReplacement;
import com.lilithsthrone.utils.SvgUtil;
import com.lilithsthrone.utils.Util;
import com.lilithsthrone.utils.colours.Colour;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;

public class Pattern {
    private static Map<String, Pattern> allPatterns = new TreeMap<String, Pattern>();
    private static Map<String, Pattern> defaultPatterns = new TreeMap<String, Pattern>();
    private String id;
    private String name;
    private String displayName;
    private String baseSVGString;
    private Map<String, String> SVGStringMap;

    public Pattern(String id, String name, File xmlFile) {
        this.id = id;
        this.name = name;
        this.SVGStringMap = new HashMap<String, String>();
        this.baseSVGString = "";
        if (!name.equals("none")) {
            try {
                String fileName = xmlFile.getParent() + File.separator + name + ".svg";
                File patternFile = new File(fileName);
                List<String> lines = Files.readAllLines(patternFile.toPath());
                StringBuilder sb = new StringBuilder();
                for (String line : lines) {
                    sb.append(line);
                }
                this.baseSVGString = sb.toString();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static Pattern loadFromFile(String id, File patternXMLFile) {
        try {
            Element patternElement = Element.getDocumentRootElement(patternXMLFile);
            String loadedDisplayName = patternElement.getMandatoryFirstOf("name").getTextContent();
            boolean loadedDefaultPattern = Boolean.valueOf(patternElement.getMandatoryFirstOf("defaultPattern").getTextContent());
            String loadedPatternName = patternElement.getMandatoryFirstOf("patternName").getTextContent().replace(".svg", "");
            Pattern pattern = new Pattern(id, loadedPatternName, patternXMLFile);
            pattern.displayName = loadedDisplayName;
            allPatterns.put(id, pattern);
            if (loadedDefaultPattern) {
                defaultPatterns.put(id, pattern);
            }
            return pattern;
        }
        catch (XMLLoadException e) {
            e.printStackTrace();
        }
        catch (XMLMissingTagException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static Pattern getPattern(String id) {
        return allPatterns.get(id);
    }

    public static Pattern getPatternByName(String name) {
        for (Pattern pattern : allPatterns.values()) {
            if (!Objects.equals(pattern.getName(), name)) continue;
            return pattern;
        }
        return null;
    }

    public static Pattern getPatternByIdOrName(String idOrName) {
        if (allPatterns.containsKey(idOrName)) {
            return Pattern.getPattern(idOrName);
        }
        return Pattern.getPatternByName(idOrName);
    }

    public static String getPatternIdByName(String name) {
        for (Pattern pattern : allPatterns.values()) {
            if (!Objects.equals(pattern.getName(), name)) continue;
            return pattern.getId();
        }
        return name;
    }

    public static List<Pattern> getAllPatterns() {
        return new ArrayList<Pattern>(allPatterns.values());
    }

    public static List<Pattern> getAllDefaultPatterns() {
        return new ArrayList<Pattern>(defaultPatterns.values());
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getNiceName() {
        if (this.displayName != null && this.displayName.length() > 0) {
            return this.displayName;
        }
        return this.name.replace('_', ' ');
    }

    public boolean isRecolourAvailable(ColourReplacement colourReplacement) {
        for (String s : colourReplacement.getColourReplacements()) {
            if (!this.baseSVGString.contains(s)) continue;
            return true;
        }
        return false;
    }

    private String generateIdentifier(List<Colour> colours) {
        StringBuilder sb = new StringBuilder(this.getId());
        for (Colour c : colours) {
            sb.append(c.getId());
        }
        return sb.toString();
    }

    public String getSVGString(List<Colour> patternColours, List<ColourReplacement> patternColourReplacements) {
        if (!this.SVGStringMap.containsKey(this.generateIdentifier(patternColours))) {
            this.generateSVGImage(patternColours, patternColourReplacements);
        }
        return this.SVGStringMap.get(this.generateIdentifier(patternColours));
    }

    private void generateSVGImage(List<Colour> patternColours, List<ColourReplacement> patternColourReplacements) {
        this.SVGStringMap.put(this.generateIdentifier(patternColours), SvgUtil.colourReplacementPattern(this.getId(), patternColours, patternColourReplacements, this.baseSVGString));
    }

    static {
        Pattern nonePattern = new Pattern("none", "none", null);
        allPatterns.put("none", nonePattern);
        defaultPatterns.put("none", nonePattern);
        Map<String, Map<String, File>> moddedFilesMap = Util.getExternalModFilesById("/items/patterns");
        for (Map.Entry<String, Map<String, File>> entry : moddedFilesMap.entrySet()) {
            for (Map.Entry<String, File> innerEntry : entry.getValue().entrySet()) {
                try {
                    Pattern.loadFromFile(innerEntry.getKey(), innerEntry.getValue());
                }
                catch (Exception ex) {
                    System.err.println("Loading modded pattern failed at 'Pattern'. File path: " + innerEntry.getValue().getAbsolutePath());
                    System.err.println("Actual exception: ");
                    ex.printStackTrace(System.err);
                }
            }
        }
        Map<String, Map<String, File>> filesMap = Util.getExternalFilesById("res/patterns");
        for (Map.Entry<String, Map<String, File>> entry : filesMap.entrySet()) {
            for (Map.Entry<String, File> innerEntry : entry.getValue().entrySet()) {
                try {
                    Pattern.loadFromFile(innerEntry.getKey(), innerEntry.getValue());
                }
                catch (Exception ex) {
                    System.err.println("Loading pattern failed at 'Pattern'. File path: " + innerEntry.getValue().getAbsolutePath());
                    System.err.println("Actual exception: ");
                    ex.printStackTrace(System.err);
                }
            }
        }
    }
}

