/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.utils;

import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class NumberMap<K, V extends Number>
extends AbstractMap<K, V>
implements Map<K, V> {
    private final Map<K, V> map = new HashMap();
    private final Class<V> cls;

    public NumberMap(Class<V> cls) {
        this.cls = cls;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public V put(K key, V value) throws ClassCastException, UnsupportedOperationException {
        if (Double.class.isAssignableFrom(this.cls)) {
            Double corrected = ((Number)value).doubleValue();
            return (V)this.map.put(key, corrected);
        }
        if (Float.class.isAssignableFrom(this.cls)) {
            Float corrected = Float.valueOf(((Number)value).floatValue());
            return (V)this.map.put(key, corrected);
        }
        if (Integer.class.isAssignableFrom(this.cls)) {
            Integer corrected = ((Number)value).intValue();
            return (V)this.map.put(key, corrected);
        }
        throw new UnsupportedOperationException("NumberMap not implemented for " + this.cls.getName());
    }
}

