/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.utils;

import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.effects.AbstractPerk;
import com.lilithsthrone.game.character.effects.PerkCategory;
import com.lilithsthrone.game.character.effects.PerkManager;
import com.lilithsthrone.game.character.effects.TreeEntry;
import com.lilithsthrone.game.dialogue.DialogueNode;
import com.lilithsthrone.game.dialogue.responses.Response;
import com.lilithsthrone.game.dialogue.utils.MapTravelType;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.utils.Node;
import com.lilithsthrone.utils.PerkNode;
import com.lilithsthrone.utils.Util;
import com.lilithsthrone.utils.Vector2i;
import com.lilithsthrone.world.AbstractWorldType;
import com.lilithsthrone.world.Cell;
import com.lilithsthrone.world.WorldType;
import com.lilithsthrone.world.places.PlaceType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;

public class Pathing {
    private static List<Cell> pathingCells = new ArrayList<Cell>();
    private static Vector2i endPoint = new Vector2i(0, 0);
    private static AbstractWorldType destinationWorld = WorldType.DOMINION;
    private static int travelTime = 0;
    private static int dangerousTiles = 0;
    private static boolean impossibleDestination = true;
    private static MapTravelType mapTravelType = MapTravelType.WALK_SAFE;

    public static List<Cell> aStarPathing(Cell[][] grid, Vector2i start, Vector2i end, boolean preferSafe) {
        return Pathing.aStarPathing(grid, start.getX(), start.getY(), end.getX(), end.getY(), preferSafe);
    }

    public static List<Cell> aStarPathing(Cell[][] grid, Vector2i start, int endX, int endY, boolean preferSafe) {
        return Pathing.aStarPathing(grid, start.getX(), start.getY(), endX, endY, preferSafe);
    }

    public static List<Cell> aStarPathing(Cell[][] grid, int startX, int startY, int endX, int endY, boolean preferSafe) {
        Node n;
        ArrayList<Cell> path = new ArrayList<Cell>();
        impossibleDestination = true;
        Node[][] nodeArray = new Node[grid.length][grid[0].length];
        for (int i = 0; i < grid.length; ++i) {
            for (int j = 0; j < grid[0].length; ++j) {
                nodeArray[i][j] = new Node(null, i, j, 0, 0, 0);
            }
        }
        PriorityQueue<Node> openList = new PriorityQueue<Node>(10, new Comparator<Node>(){

            @Override
            public int compare(Node o1, Node o2) {
                return o1.getF() - o2.getF();
            }
        });
        ArrayList<Node> closedList = new ArrayList<Node>();
        openList.add(nodeArray[startX][startY]);
        while (!openList.isEmpty()) {
            n = (Node)openList.poll();
            closedList.add(n);
            if (n.getX() == endX && n.getY() == endY) {
                impossibleDestination = false;
                break;
            }
            for (int i = -1; i <= 1; ++i) {
                for (int j = -1; j <= 1; ++j) {
                    if (i == 0 && j == 0 || n.getX() + i < 0 || n.getX() + i >= grid.length || n.getY() + j < 0 || n.getY() + j >= grid[0].length || closedList.contains(nodeArray[n.getX() + i][n.getY() + j])) continue;
                    Cell c = grid[n.getX() + i][n.getY() + j];
                    int time = Main.game.getModifierTravelTime(c.getPlace().getPlaceType().isLand(), c.getDialogue(false) != null ? c.getDialogue(false).getSecondsPassed() : 10000);
                    int g = (i == 0 || j == 0 ? 10 : (c.getType().equals(WorldType.WORLD_MAP) ? 12 : 1000000)) + time + (c.getPlace().getPlaceType().equals(PlaceType.GENERIC_IMPASSABLE) ? 100000000 : 0) + (preferSafe && c.getPlace().getPlaceType() != null && c.getPlace().getPlaceType().isDangerous() ? 100000 : 0);
                    if (!openList.contains(nodeArray[n.getX() + i][n.getY() + j])) {
                        nodeArray[n.getX() + i][n.getY() + j].setParent(n);
                        nodeArray[n.getX() + i][n.getY() + j].setG(n.getG() + g);
                        nodeArray[n.getX() + i][n.getY() + j].setH(Math.abs(n.getX() + i - endX) + Math.abs(n.getX() + j - endY));
                        nodeArray[n.getX() + i][n.getY() + j].setF();
                        openList.add(nodeArray[n.getX() + i][n.getY() + j]);
                        continue;
                    }
                    if (n.getG() + g >= nodeArray[n.getX() + i][n.getY() + j].getG()) continue;
                    openList.remove(nodeArray[n.getX() + i][n.getY() + j]);
                    nodeArray[n.getX() + i][n.getY() + j].setParent(n);
                    nodeArray[n.getX() + i][n.getY() + j].setG(n.getG() + g);
                    nodeArray[n.getX() + i][n.getY() + j].setF();
                    openList.add(nodeArray[n.getX() + i][n.getY() + j]);
                }
            }
        }
        n = nodeArray[endX][endY];
        while (n.getParent() != null) {
            path.add(grid[n.getX()][n.getY()]);
            n = n.getParent();
        }
        Collections.reverse(path);
        return path;
    }

    public static void walkPathNoEffects(GameCharacter character, AbstractWorldType worldType, Vector2i end, boolean preferSafe, float percentageTravel) {
        Pathing.walkPathNoEffects(character, Main.game.getWorlds().get(worldType).getCellGrid(), end, preferSafe, percentageTravel);
    }

    private static void walkPathNoEffects(GameCharacter character, Cell[][] grid, Vector2i end, boolean preferSafe, float percentageTravel) {
        List<Cell> cells = Pathing.aStarPathing(grid, character.getLocation(), end, preferSafe);
        int cellsToTravel = Math.max(1, (int)((float)cells.size() * percentageTravel));
        int cellsTravelled = 0;
        for (Cell c : cells) {
            character.setLocation(c.getType(), c.getLocation(), false);
            if (++cellsTravelled <= cellsToTravel) continue;
            break;
        }
    }

    public static Response walkPath(MapTravelType travelType) {
        int totalTimePassed = 0;
        for (Cell c : Pathing.getPathingCells()) {
            Main.game.getPlayer().setLocation(c.getType(), c.getLocation(), false);
            DialogueNode dialogue = c.getDialogue(true);
            if (dialogue == null) continue;
            totalTimePassed += Main.game.getModifierTravelTime(c.getPlace().getPlaceType().isLand(), dialogue.getSecondsPassed());
            if (dialogue.isTravelDisabled()) {
                final int time = totalTimePassed;
                Main.game.getPlayer().setLocation(c.getType(), c.getLocation(), false);
                return new Response("", "", dialogue){

                    @Override
                    public int getSecondsPassed() {
                        return time;
                    }

                    @Override
                    public void effects() {
                        Main.game.getTextStartStringBuilder().append("<p style='text-align:center;'>[style.italicsBad(\u4f60\u7684\u884c\u8fdb\u88ab\u4e2d\u65ad\u4e86\uff01)]</p>");
                    }
                };
            }
            if (totalTimePassed < 7200) continue;
            Main.game.getPlayer().setActive(false);
            Main.game.endTurn(totalTimePassed);
            Main.game.getPlayer().setActive(true);
            totalTimePassed = 0;
        }
        Cell destination = Pathing.getPathingCells().get(Pathing.getPathingCells().size() - 1);
        Main.game.getPlayer().setLocation(destination.getType(), destination.getLocation(), false);
        Main.game.getPlayer().setActive(false);
        Main.game.endTurn(totalTimePassed);
        Main.game.getPlayer().setActive(true);
        return new Response("", "", destination.getDialogue(false));
    }

    public static void initPathingVariables() {
        if (!Pathing.getMapTravelType().isAvailable(null, Main.game.getPlayer())) {
            Pathing.setMapTravelType(MapTravelType.WALK_SAFE);
        }
        Pathing.setPathingCells(new ArrayList<Cell>(), new Vector2i(-1, -1));
        destinationWorld = Main.game.getPlayer().getWorldLocation();
    }

    public static List<Cell> getPathingCells() {
        return pathingCells;
    }

    public static void setPathingCells(List<Cell> pathingCells, Vector2i endPoint) {
        Pathing.pathingCells = pathingCells;
        Pathing.endPoint = endPoint;
        travelTime = Pathing.calculateTravelTime(Pathing.pathingCells, true);
        dangerousTiles = Pathing.calculateDangerousTiles(Pathing.pathingCells);
    }

    public static void appendPathingCells(List<Cell> pathingCells, Vector2i endPoint) {
        Pathing.pathingCells.addAll(pathingCells);
        Pathing.endPoint = endPoint;
        travelTime = Pathing.calculateTravelTime(Pathing.pathingCells, true);
        dangerousTiles = Pathing.calculateDangerousTiles(Pathing.pathingCells);
    }

    public static Vector2i getEndPoint() {
        return endPoint;
    }

    private static int calculateTravelTime(List<Cell> cellRoute, boolean withModifiedTravelTime) {
        int seconds = 0;
        for (Cell c : cellRoute) {
            DialogueNode dialogue = c.getDialogue(false);
            if (dialogue == null) continue;
            if (withModifiedTravelTime) {
                seconds += Main.game.getModifierTravelTime(c.getPlace().getPlaceType().isLand(), dialogue.getSecondsPassed());
                continue;
            }
            seconds += dialogue.getSecondsPassed();
        }
        return seconds;
    }

    private static int calculateDangerousTiles(List<Cell> cellRoute) {
        int dangerous = 0;
        for (Cell c : cellRoute) {
            if (!c.getPlace().getPlaceType().isDangerous()) continue;
            ++dangerous;
        }
        return dangerous;
    }

    public static void setEndPoint(Vector2i endPoint, Cell cell, AbstractWorldType worldForRecalculatingFlyTime) {
        Pathing.endPoint = endPoint;
        if (worldForRecalculatingFlyTime != null) {
            List<Cell> route = Pathing.aStarPathing(Main.game.getWorlds().get(worldForRecalculatingFlyTime).getCellGrid(), Main.game.getPlayer().getLocation(), endPoint, false);
            travelTime = Pathing.calculateTravelTime(route, false) / 10;
        }
        dangerousTiles = cell.getPlace().getPlaceType().isDangerous() ? 1 : 0;
        destinationWorld = cell.getType();
    }

    public static MapTravelType getMapTravelType() {
        return mapTravelType;
    }

    public static void setMapTravelType(MapTravelType mapTravelType) {
        Pathing.mapTravelType = mapTravelType;
    }

    public static int getDangerousTilesCrossed() {
        return dangerousTiles;
    }

    public static int getTravelTime() {
        return travelTime;
    }

    public static AbstractWorldType getDestinationWorld() {
        return destinationWorld;
    }

    public static boolean isImpossibleDestination() {
        return impossibleDestination;
    }

    public static List<TreeEntry<PerkCategory, AbstractPerk>> aStarPathingPerkTree(GameCharacter character, TreeEntry<PerkCategory, AbstractPerk> destination) {
        List<TreeEntry<PerkCategory, AbstractPerk>> startingPerks = PerkManager.getStartingPerks(character);
        TreeEntry<PerkCategory, AbstractPerk> start = startingPerks.get(0);
        for (TreeEntry<PerkCategory, AbstractPerk> perk : startingPerks) {
            if (perk.getCategory() != destination.getCategory()) continue;
            start = perk;
        }
        return Pathing.aStarPathingPerkTree(PerkManager.MANAGER.getPerkTree(character), start, destination);
    }

    public static List<TreeEntry<PerkCategory, AbstractPerk>> aStarPathingPerkTree(Map<Integer, Map<PerkCategory, List<TreeEntry<PerkCategory, AbstractPerk>>>> perkTree, TreeEntry<PerkCategory, AbstractPerk> start, TreeEntry<PerkCategory, AbstractPerk> destination) {
        ArrayList<TreeEntry<PerkCategory, AbstractPerk>> perkList = new ArrayList<TreeEntry<PerkCategory, AbstractPerk>>();
        for (Map<PerkCategory, List<TreeEntry<PerkCategory, AbstractPerk>>> entry1 : perkTree.values()) {
            for (List<TreeEntry<PerkCategory, AbstractPerk>> entry2 : entry1.values()) {
                for (TreeEntry<PerkCategory, AbstractPerk> entry3 : entry2) {
                    if (entry3.getRow() <= 0) continue;
                    perkList.add(entry3);
                }
            }
        }
        ArrayList<TreeEntry<PerkCategory, AbstractPerk>> path = new ArrayList<TreeEntry<PerkCategory, AbstractPerk>>();
        ArrayList<PerkNode> nodeArray = new ArrayList<PerkNode>();
        PerkNode startNode = null;
        for (int i = 0; i < perkList.size(); ++i) {
            PerkNode createdNode = new PerkNode(null, (TreeEntry)perkList.get(i), 0, 0, 0);
            if (((TreeEntry)perkList.get(i)).equals(start)) {
                startNode = createdNode;
            }
            nodeArray.add(createdNode);
        }
        PriorityQueue<PerkNode> openList = new PriorityQueue<PerkNode>(10, new Comparator<PerkNode>(){

            @Override
            public int compare(PerkNode o1, PerkNode o2) {
                return o1.getF() - o2.getF();
            }
        });
        ArrayList<PerkNode> closedList = new ArrayList<PerkNode>();
        openList.add(startNode);
        PerkNode n = null;
        PerkNode destinationNode = null;
        while (!openList.isEmpty()) {
            n = (PerkNode)openList.poll();
            closedList.add(n);
            if (n.getPerkTreeEntry().equals(destination)) {
                destinationNode = n;
                break;
            }
            for (TreeEntry link : Util.mergeLists(n.getPerkTreeEntry().getSiblingLinks(), n.getPerkTreeEntry().getChildLinks())) {
                boolean containsLink = false;
                PerkNode closedNode = null;
                for (PerkNode node : closedList) {
                    if (!node.getPerkTreeEntry().equals(link)) continue;
                    containsLink = true;
                    break;
                }
                for (PerkNode node : nodeArray) {
                    if (!node.getPerkTreeEntry().equals(link)) continue;
                    closedNode = node;
                    break;
                }
                if (containsLink) continue;
                int g = 1;
                if (!openList.contains(closedNode)) {
                    closedNode.setParent(n);
                    closedNode.setG(n.getG() + g);
                    closedNode.setH(1);
                    closedNode.setF();
                    openList.add(closedNode);
                    continue;
                }
                if (n.getG() + g >= closedNode.getG()) continue;
                openList.remove(closedNode);
                closedNode.setParent(n);
                closedNode.setG(n.getG() + g);
                closedNode.setF();
                openList.add(closedNode);
            }
        }
        n = destinationNode;
        path.add(n.getPerkTreeEntry());
        while (n.getParent() != null) {
            path.add(n.getParent().getPerkTreeEntry());
            n = n.getParent();
        }
        Collections.reverse(path);
        return path;
    }
}

