/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.utils;

import com.lilithsthrone.game.inventory.ColourReplacement;
import com.lilithsthrone.rendering.Pattern;
import com.lilithsthrone.utils.Util;
import com.lilithsthrone.utils.colours.BaseColour;
import com.lilithsthrone.utils.colours.Colour;
import com.lilithsthrone.utils.colours.PresetColour;
import java.util.ArrayList;
import java.util.List;

public class SvgUtil {
    private static final List<ColourReplacement> DEFAULT_COLOUR_REPLACEMENT_LIST = new ArrayList<ColourReplacement>();

    public static String colourReplacementPattern(String gradientReplacementID, List<Colour> patternColours, List<ColourReplacement> patternColourReplacements, String inputString) {
        String s = inputString;
        StringBuilder idReplacement = new StringBuilder(gradientReplacementID);
        for (Colour c : patternColours) {
            idReplacement.append(c.getId());
        }
        s = s.replaceAll("linearGradient\\d|innoGrad\\d|radialGradient\\d", idReplacement.toString() + "$0");
        s = SvgUtil.sanitizeImageString(s, false);
        for (int i = 0; i < patternColourReplacements.size(); ++i) {
            List<String> replacements = patternColourReplacements.get(i).getColourReplacements();
            String[] shades = i < patternColours.size() ? patternColours.get(i).getShades(replacements.size()) : patternColourReplacements.get(i).getFirstOfDefaultColours().getShades(replacements.size());
            for (int j = 0; j < replacements.size(); ++j) {
                Object replacementString = replacements.get(j);
                if (((String)replacementString).charAt(1) == ((String)replacementString).charAt(2) && ((String)replacementString).charAt(3) == ((String)replacementString).charAt(4) && ((String)replacementString).charAt(5) == ((String)replacementString).charAt(6)) {
                    replacementString = (String)replacementString + "|#" + ((String)replacementString).charAt(1) + ((String)replacementString).charAt(3) + ((String)replacementString).charAt(5) + "(?!\\d)";
                }
                s = s.replaceAll((String)replacementString, shades[j]);
            }
        }
        return s;
    }

    public static String colourReplacement(String gradientReplacementID, Colour colour, String inputString) {
        return SvgUtil.colourReplacement(gradientReplacementID, Util.newArrayListOfValues(colour), null, inputString);
    }

    public static String colourReplacement(String gradientReplacementID, Colour colour, Colour colourSecondary, Colour colourTertiary, String inputString) {
        return SvgUtil.colourReplacement(gradientReplacementID, Util.newArrayListOfValues(colour, colourSecondary, colourTertiary), null, inputString);
    }

    public static String colourReplacement(String gradientReplacementID, Colour colour, Colour colourSecondary, Colour colourTertiary, Colour colourQuaternary, String inputString) {
        return SvgUtil.colourReplacement(gradientReplacementID, Util.newArrayListOfValues(colour, colourSecondary, colourTertiary, colourQuaternary), null, inputString);
    }

    public static String colourReplacement(String gradientReplacementID, List<Colour> colours, List<ColourReplacement> colourReplacements, String inputString) {
        String s = inputString;
        if (gradientReplacementID != null) {
            StringBuilder idReplacement = new StringBuilder(gradientReplacementID);
            for (Colour c : colours) {
                idReplacement.append(c.getId());
            }
            s = s.replaceAll("linearGradient\\d|innoGrad\\d|radialGradient\\d", idReplacement.toString() + "$0");
        }
        s = SvgUtil.sanitizeImageString(s, true);
        if (colourReplacements == null) {
            colourReplacements = DEFAULT_COLOUR_REPLACEMENT_LIST;
        }
        for (int i = 0; i < colourReplacements.size(); ++i) {
            List<String> replacements = colourReplacements.get(i).getColourReplacements();
            String[] shades = i < colours.size() ? colours.get(i).getShades(replacements.size()) : colourReplacements.get(i).getFirstOfDefaultColours().getShades(replacements.size());
            for (int j = 0; j < replacements.size(); ++j) {
                Object replacementString = replacements.get(j);
                if (((String)replacementString).charAt(1) == ((String)replacementString).charAt(2) && ((String)replacementString).charAt(3) == ((String)replacementString).charAt(4) && ((String)replacementString).charAt(5) == ((String)replacementString).charAt(6)) {
                    replacementString = (String)replacementString + "|#" + ((String)replacementString).charAt(1) + ((String)replacementString).charAt(3) + ((String)replacementString).charAt(5) + "(?!\\d)";
                }
                s = s.replaceAll(((String)replacementString).toLowerCase(), shades[j]);
            }
        }
        return s;
    }

    public static String colourReplacement(String gradientReplacementID, BaseColour colour, String inputString) {
        return SvgUtil.colourReplacement(gradientReplacementID, colour, null, null, inputString);
    }

    public static String colourReplacement(String gradientReplacementID, BaseColour colour, BaseColour colourSecondary, BaseColour colourTertiary, String inputString) {
        String s = inputString;
        if (gradientReplacementID != null) {
            s = s.replaceAll("linearGradient\\d|innoGrad\\d|radialGradient\\d", gradientReplacementID + colour.toString() + (colourSecondary != null ? colourSecondary.toString() : "") + (colourTertiary != null ? colourTertiary.toString() : "") + "$0");
        }
        s = SvgUtil.sanitizeImageString(s, true);
        if (colour != null) {
            s = s.replaceAll("#ff2a2a", colour.getShades()[0]);
            s = s.replaceAll("#ff5555|#f55(?!\\d)", colour.getShades()[1]);
            s = s.replaceAll("#ff8080", colour.getShades()[2]);
            s = s.replaceAll("#ffaaaa|#faa(?!\\d)", colour.getShades()[3]);
            s = s.replaceAll("#ffd5d5", colour.getShades()[4]);
        }
        if (colourSecondary != null) {
            s = s.replaceAll("#ff7f2a", colourSecondary.getShades()[0]);
            s = s.replaceAll("#ff9955|#f95(?!\\d)", colourSecondary.getShades()[1]);
            s = s.replaceAll("#ffb380", colourSecondary.getShades()[2]);
            s = s.replaceAll("#ffccaa|#fca(?!\\d)", colourSecondary.getShades()[3]);
            s = s.replaceAll("#ffe6d5", colourSecondary.getShades()[4]);
        }
        if (colourTertiary != null) {
            s = s.replaceAll("#ffd42a", colourTertiary.getShades()[0]);
            s = s.replaceAll("#ffdd55|#fd5(?!\\d)", colourTertiary.getShades()[1]);
            s = s.replaceAll("#ffe680", colourTertiary.getShades()[2]);
            s = s.replaceAll("#ffeeaa|#fea(?!\\d)", colourTertiary.getShades()[3]);
            s = s.replaceAll("#fff6d5", colourTertiary.getShades()[4]);
        }
        return s;
    }

    public static String colourReplacement(String gradientReplacementID, String colour, String inputString) {
        String s = inputString;
        if (gradientReplacementID != null) {
            s = s.replaceAll("linearGradient\\d|innoGrad\\d|radialGradient\\d", gradientReplacementID + colour.toString() + "$0");
        }
        s = SvgUtil.sanitizeImageString(s, true);
        if (colour != null) {
            s = s.replaceAll("#ff2a2a", colour);
            s = s.replaceAll("#ff5555|#f55(?!\\d)", colour);
            s = s.replaceAll("#ff8080", colour);
            s = s.replaceAll("#ffaaaa|#faa(?!\\d)", colour);
            s = s.replaceAll("#ffd5d5", colour);
        }
        return s;
    }

    public static String getSVGWithHandledPattern(String errorId, String s, String pattern, List<Colour> patternColours, List<ColourReplacement> patternColourReplacements) {
        String loadedPattern;
        String returnable;
        int defEndIndex;
        int firstShapeStartIndex;
        if (!s.contains("patternLayer")) {
            return s;
        }
        if (pattern == null || pattern.equals("none")) {
            return s;
        }
        int patternLayerStartIndex = s.indexOf("patternLayer");
        int patternLayerEndIndex = s.indexOf("</g>", patternLayerStartIndex);
        Object newClipMask = "<clipPath id=\"internalPatternClip\">";
        int lastShapeEndIndex = firstShapeStartIndex = s.indexOf("<path", patternLayerStartIndex);
        boolean continueSetUp = true;
        while (continueSetUp) {
            int currentShapeStartIndex = s.indexOf("<path", lastShapeEndIndex);
            int currentShapeEndIndex = s.indexOf("/>", currentShapeStartIndex);
            if (currentShapeEndIndex > patternLayerEndIndex || currentShapeEndIndex == -1 || currentShapeStartIndex == -1) {
                continueSetUp = false;
                continue;
            }
            newClipMask = (String)newClipMask + s.substring(currentShapeStartIndex, currentShapeEndIndex) + " />";
            lastShapeEndIndex = currentShapeEndIndex;
        }
        newClipMask = (String)newClipMask + "</clipPath>";
        int defIndex = s.indexOf("<defs");
        if (defIndex > 0) {
            defEndIndex = s.indexOf("</defs>");
            returnable = s.substring(0, defEndIndex) + (String)newClipMask;
        } else {
            defEndIndex = s.indexOf(62) + 1;
            returnable = s.substring(0, defEndIndex) + "<defs>" + (String)newClipMask + "</defs>";
        }
        try {
            loadedPattern = Pattern.getPattern(pattern).getSVGString(patternColours, patternColourReplacements);
        }
        catch (Exception ex) {
            System.err.println("Error in pattern loading method getSVGWithHandledPattern(): " + errorId);
            return s;
        }
        Object newPattern = "";
        int firstPatternShapeStartIndex = loadedPattern.indexOf("<path");
        int firstRectStartIndex = loadedPattern.indexOf("<rect");
        if (firstRectStartIndex != -1 && firstRectStartIndex < firstPatternShapeStartIndex || firstPatternShapeStartIndex == -1) {
            firstPatternShapeStartIndex = firstRectStartIndex;
        }
        int lastPatternShapeEndIndex = firstPatternShapeStartIndex;
        boolean continuePatternSetUp = true;
        while (continuePatternSetUp) {
            int currentShapeEndIndex;
            int currentShapeStartIndex = loadedPattern.indexOf("<path", lastPatternShapeEndIndex);
            int currentRectStartIndex = loadedPattern.indexOf("<rect", lastPatternShapeEndIndex);
            if (currentRectStartIndex != -1 && currentRectStartIndex < currentShapeStartIndex || currentShapeStartIndex == -1) {
                currentShapeStartIndex = currentRectStartIndex;
            }
            if ((currentShapeEndIndex = loadedPattern.indexOf("/>", currentShapeStartIndex)) == -1 || currentShapeStartIndex == -1) {
                continuePatternSetUp = false;
                continue;
            }
            newPattern = (String)newPattern + loadedPattern.substring(currentShapeStartIndex, currentShapeEndIndex) + "clip-path=\"url(#internalPatternClip)\"/>";
            lastPatternShapeEndIndex = currentShapeEndIndex;
        }
        returnable = returnable + s.substring(defEndIndex, firstShapeStartIndex) + (String)newPattern + s.substring(patternLayerEndIndex);
        return returnable;
    }

    private static String sanitizeImageString(String imageString, boolean sanitizeSizes) {
        String s = imageString;
        s = s.replaceFirst("<\\?xml[^?]*\\?>", "");
        if (sanitizeSizes) {
            s = s.replaceFirst("width=\"100%\"", "");
            s = s.replaceFirst("height=\"100%\"", "");
        }
        return s;
    }

    static {
        DEFAULT_COLOUR_REPLACEMENT_LIST.add(new ColourReplacement(true, ColourReplacement.DEFAULT_PRIMARY_REPLACEMENTS, PresetColour.getAllPresetColours(), null));
        DEFAULT_COLOUR_REPLACEMENT_LIST.add(new ColourReplacement(true, ColourReplacement.DEFAULT_SECONDARY_REPLACEMENTS, PresetColour.getAllPresetColours(), null));
        DEFAULT_COLOUR_REPLACEMENT_LIST.add(new ColourReplacement(true, ColourReplacement.DEFAULT_TERTIARY_REPLACEMENTS, PresetColour.getAllPresetColours(), null));
        DEFAULT_COLOUR_REPLACEMENT_LIST.add(new ColourReplacement(true, ColourReplacement.DEFAULT_QUATERNARY_REPLACEMENTS, PresetColour.getAllPresetColours(), null));
    }
}

