/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.utils;

import com.lilithsthrone.controller.xmlParsing.Element;
import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.body.CoverableArea;
import com.lilithsthrone.game.character.race.AbstractSubspecies;
import com.lilithsthrone.game.dialogue.utils.ParserTag;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.game.inventory.InventorySlot;
import com.lilithsthrone.game.inventory.clothing.AbstractClothing;
import com.lilithsthrone.game.inventory.clothing.DisplacementType;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.utils.Units;
import com.lilithsthrone.utils.colours.Colour;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.Scanner;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javafx.scene.input.KeyCode;
import javafx.scene.paint.Color;
import org.w3c.dom.Document;

public class Util {
    public static Random random = new Random();
    private static Map<KeyCode, String> KEY_NAMES = new LinkedHashMap<KeyCode, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(KeyCode.ADD, "+");
            this.put(KeyCode.ALT, "Alt");
            this.put(KeyCode.AMPERSAND, "&");
            this.put(KeyCode.ASTERISK, "*");
            this.put(KeyCode.BACK_QUOTE, "\"");
            this.put(KeyCode.BACK_SLASH, "\\");
            this.put(KeyCode.BACK_SPACE, "Back space");
            this.put(KeyCode.BRACELEFT, "{");
            this.put(KeyCode.BRACERIGHT, "}");
            this.put(KeyCode.CAPS, "Caps");
            this.put(KeyCode.CLOSE_BRACKET, "]");
            this.put(KeyCode.COLON, ":");
            this.put(KeyCode.COMMA, ",");
            this.put(KeyCode.CONTROL, "Ctrl");
            this.put(KeyCode.DELETE, "Delete");
            this.put(KeyCode.DIVIDE, "/");
            this.put(KeyCode.DOLLAR, "$");
            this.put(KeyCode.DOWN, "Down");
            this.put(KeyCode.END, "End");
            this.put(KeyCode.ENTER, "Enter");
            this.put(KeyCode.EQUALS, "=");
            this.put(KeyCode.ESCAPE, "Esc");
            this.put(KeyCode.EURO_SIGN, "&euro;");
            this.put(KeyCode.EXCLAMATION_MARK, "!");
            this.put(KeyCode.GREATER, ">");
            this.put(KeyCode.KP_DOWN, "Down");
            this.put(KeyCode.KP_LEFT, "Left");
            this.put(KeyCode.KP_RIGHT, "Right");
            this.put(KeyCode.KP_UP, "Up");
            this.put(KeyCode.LEFT, "Left");
            this.put(KeyCode.LEFT_PARENTHESIS, "(");
            this.put(KeyCode.LESS, "<");
            this.put(KeyCode.MINUS, "-");
            this.put(KeyCode.NUMPAD0, "0");
            this.put(KeyCode.NUMPAD1, "1");
            this.put(KeyCode.NUMPAD2, "2");
            this.put(KeyCode.NUMPAD3, "3");
            this.put(KeyCode.NUMPAD4, "4");
            this.put(KeyCode.NUMPAD5, "5");
            this.put(KeyCode.NUMPAD6, "6");
            this.put(KeyCode.NUMPAD7, "7");
            this.put(KeyCode.NUMPAD8, "9");
            this.put(KeyCode.NUMPAD9, "9");
            this.put(KeyCode.OPEN_BRACKET, "[");
            this.put(KeyCode.PAGE_DOWN, "Pg Dn");
            this.put(KeyCode.PAGE_UP, "Pg Up");
            this.put(KeyCode.PERIOD, ".");
            this.put(KeyCode.PLUS, "+");
            this.put(KeyCode.POUND, "&pound;");
            this.put(KeyCode.POWER, "^");
            this.put(KeyCode.QUOTE, "\"");
            this.put(KeyCode.RIGHT, "Right");
            this.put(KeyCode.RIGHT_PARENTHESIS, ")");
            this.put(KeyCode.SEMICOLON, ";");
            this.put(KeyCode.SHIFT, "Sft");
            this.put(KeyCode.SLASH, "/");
            this.put(KeyCode.SPACE, "Space");
            this.put(KeyCode.SUBTRACT, "-");
            this.put(KeyCode.TAB, "Tab");
        }
    };
    private static String[] numbersLessThanTwenty = new String[]{"\u96f6", "\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d", "\u4e03", "\u516b", "\u4e5d", "\u5341", "\u5341\u4e00", "\u5341\u4e8c", "\u5341\u4e09", "\u5341\u56db", "\u5341\u4e94", "\u5341\u516d", "\u5341\u4e03", "\u5341\u516b", "\u5341\u4e5d"};
    private static String[] positionsLessThanTwenty = new String[]{"\u96f6", "\u7b2c\u4e00", "\u7b2c\u4e8c", "\u7b2c\u4e09", "\u7b2c\u56db", "\u7b2c\u4e94", "\u7b2c\u516d", "\u7b2c\u4e03", "\u7b2c\u516b", "\u7b2c\u4e5d", "\u7b2c\u5341", "\u7b2c\u5341\u4e00", "\u7b2c\u5341\u4e8c", "\u7b2c\u5341\u4e09", "\u7b2c\u5341\u56db", "\u7b2c\u5341\u4e94", "\u7b2c\u5341\u516d", "\u7b2c\u5341\u4e03", "\u7b2c\u5341\u516b", "\u7b2c\u5341\u4e5d"};
    private static String[] tensGreaterThanNineteen = new String[]{"", "", "\u4e8c\u5341", "\u4e09\u5341", "\u56db\u5341", "\u4e94\u5341", "\u516d\u5341", "\u4e03\u5341", "\u516b\u5341", "\u4e5d\u5341"};
    static String[] digits = new String[]{"\u96f6", "\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d", "\u4e03", "\u516b", "\u4e5d"};
    static String[] lower_base = new String[]{"", "\u5341", "\u767e", "\u5343"};
    static String[] upper_base = new String[]{"", "\u4e07", "\u4ebf", "\u5146", "\u4eac", "\u5793"};
    private static String[] primarySequence = new String[]{"\u4e3b\u8981", "\u6b21\u8981", "\u4e09\u7ea7", "\u56db\u7ea7", "\u4e94\u7ea7", "\u516d\u7ea7", "\u4e03\u7ea7", "\u516b\u7ea7", "\u4e5d\u7ea7", "\u5341\u7ea7"};
    private static final TreeMap<Integer, String> numeralMap = new TreeMap();
    private static String[] zhengPhase;
    private static Pattern endOfSentence;
    public static String[] bimboWords;
    private static String[] broWords;
    private static String[] muteSexSounds;
    private static String[] muffledSounds;
    private static String[] sexSounds;
    private static String[] sexSoundsResisting;
    private static String[] drunkSounds;
    private static Map<String, String> slovenlySpeechReplacementMap;
    private static Map<String, List<String>> errorLogMap;

    public static String inputStreamToString(InputStream is) {
        if (is == null) {
            return "";
        }
        try (Scanner s = new Scanner(is);){
            String string = s.useDelimiter("\\A").hasNext() ? s.next() : "";
            return string;
        }
    }

    public static Color midpointColor(Color first, Color second) {
        double r = (first.getRed() + second.getRed()) / 2.0;
        double g = (first.getGreen() + second.getGreen()) / 2.0;
        double b = (first.getBlue() + second.getBlue()) / 2.0;
        return Color.color(r, g, b);
    }

    public static String toWebHexString(Color colour) {
        String c = colour.toString().substring(2, 8);
        return "#" + c;
    }

    public static Color newColour(String colourString) {
        int hex = Integer.valueOf(colourString.substring(1), 16);
        return Util.newColour((hex & 0xFF0000) >> 16, (hex & 0xFF00) >> 8, hex & 0xFF);
    }

    public static Color newColour(double r, double g, double b) {
        return Color.color(r / 255.0, g / 255.0, b / 255.0);
    }

    public static Color newColour(int hex) {
        return Util.newColour((hex & 0xFF0000) >> 16, (hex & 0xFF00) >> 8, hex & 0xFF);
    }

    public static float getModifiedDropoffValue(float input, float maxValue) {
        if (Math.abs(input) > Math.abs(maxValue)) {
            input = Math.signum(input) * maxValue;
        }
        if (input < maxValue / 2.0f) {
            return input;
        }
        float excess = Math.abs(input) - Math.abs(maxValue / 2.0f);
        float value = excess / Math.abs(maxValue) * 2.0f;
        float multiplier = (float)(Math.sin((double)value * 1.5707963267948966) / 2.0);
        return (float)Math.round((maxValue / 2.0f + multiplier * (maxValue / 2.0f)) * 100.0f) / 100.0f;
    }

    public static Map<String, Map<String, File>> getExternalModFilesById(String containingFolderId) {
        return Util.getExternalModFilesById(containingFolderId, null, null);
    }

    public static Map<String, Map<String, File>> getExternalModFilesById(String containingFolderId, String filterFolderName, String filterPathName) {
        File[] directoryListing;
        File dir = new File("res/mods");
        HashMap<String, Map<String, File>> returnMap = new HashMap<String, Map<String, File>>();
        if (dir.exists() && dir.isDirectory() && (directoryListing = dir.listFiles()) != null) {
            for (File directory : directoryListing) {
                String modAuthorName = directory.getName();
                returnMap.putIfAbsent(modAuthorName, new HashMap());
                File modAuthorDirectory = new File(directory.getAbsolutePath() + containingFolderId);
                Util.populateMapFiles(modAuthorName, directory.getName() + "_", modAuthorDirectory, returnMap, filterFolderName, filterPathName);
            }
        }
        return returnMap;
    }

    public static Map<String, Map<String, File>> getExternalFilesById(String containingFolderId) {
        return Util.getExternalFilesById(containingFolderId, null, null);
    }

    public static Map<String, Map<String, File>> getExternalFilesById(String containingFolderId, String filterFolderName, String filterPathName) {
        File[] authorDirectoriesListing;
        File dir = new File(containingFolderId);
        HashMap<String, Map<String, File>> returnMap = new HashMap<String, Map<String, File>>();
        if (dir.exists() && dir.isDirectory() && (authorDirectoriesListing = dir.listFiles()) != null) {
            for (File authorDirectory : authorDirectoriesListing) {
                if (!authorDirectory.isDirectory()) continue;
                String authorName = authorDirectory.getName();
                returnMap.putIfAbsent(authorName, new HashMap());
                Util.populateMapFiles(authorName, authorDirectory.getName() + "_", authorDirectory, returnMap, filterFolderName, filterPathName);
            }
        }
        return returnMap;
    }

    private static Map<String, Map<String, File>> populateMapFiles(String modAuthorName, String idPrefix, File directory, Map<String, Map<String, File>> returnMap, String filterFolderName, String filterPathName) {
        File[] additionalDirectories;
        File[] innerDirectoryListing;
        if ((filterFolderName == null || filterFolderName.equalsIgnoreCase(directory.getName())) && (innerDirectoryListing = directory.listFiles((path, filename) -> filename.toLowerCase().endsWith(".xml"))) != null) {
            for (File innerChild : innerDirectoryListing) {
                if (filterPathName != null && !filterPathName.equalsIgnoreCase(innerChild.getName().split("\\.")[0])) continue;
                try {
                    String id = (idPrefix != null ? idPrefix : "") + innerChild.getName().split("\\.")[0];
                    returnMap.get(modAuthorName).put(id, innerChild);
                }
                catch (Exception ex) {
                    System.err.println("Loading external mod files failed at Util.getExternalModFilesById()");
                    System.err.println("File path: " + innerChild.getAbsolutePath());
                    ex.printStackTrace();
                }
            }
        }
        if ((additionalDirectories = directory.listFiles()) != null) {
            for (File f : additionalDirectories) {
                if (!f.isDirectory()) continue;
                Util.populateMapFiles(modAuthorName, (idPrefix != null ? idPrefix : "") + f.getName() + "_", f, returnMap, filterFolderName, filterPathName);
            }
        }
        return returnMap;
    }

    public static String getXmlRootElementName(File XMLFile) {
        try {
            Document doc = Main.getDocBuilder().parse(XMLFile);
            doc.getDocumentElement().normalize();
            Element coreElement = Element.getDocumentRootElement(XMLFile);
            return coreElement.getTagName();
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
            return "";
        }
    }

    @SafeVarargs
    public static <T, S> LinkedHashMap<T, S> newHashMapOfValues(Value<T, S> ... values) {
        LinkedHashMap<T, S> map = new LinkedHashMap<T, S>();
        for (Value<T, S> v : values) {
            if (v == null) continue;
            map.put(v.getKey(), v.getValue());
        }
        return map;
    }

    public String keyCodeToShortString(KeyCode keyCode) {
        switch (keyCode) {
            case OPEN_BRACKET: {
                return "[";
            }
            case CLOSE_BRACKET: {
                return "]";
            }
            case UP: {
                return "Up";
            }
            case DOWN: {
                return "Down";
            }
            case LEFT: {
                return "Left";
            }
            case RIGHT: {
                return "Right";
            }
        }
        return keyCode.toString();
    }

    public static void openLinkInDefaultBrowser(String url) {
        Runtime runtime = Runtime.getRuntime();
        try {
            runtime.exec("xdg-open " + url);
        }
        catch (IOException e0) {
            Desktop desktop = Desktop.getDesktop();
            try {
                desktop.browse(new URI(url));
            }
            catch (IOException | URISyntaxException e) {
                e.printStackTrace();
                e0.printStackTrace();
            }
        }
    }

    public static String getFileTime(File file) {
        try {
            Instant fileTime = Files.getLastModifiedTime(file.toPath(), new LinkOption[0]).toInstant();
            return Units.dateTime(fileTime);
        }
        catch (IOException e) {
            e.printStackTrace();
            return "\u672a\u77e5";
        }
    }

    @SafeVarargs
    public static <U> ArrayList<U> newArrayListOfValues(U ... values) {
        ArrayList<U> list = new ArrayList<U>(Arrays.asList(values));
        list.removeIf(e -> e == null);
        return list;
    }

    @SafeVarargs
    public static <U> ArrayList<U> newArrayListOfValuesKeepNulls(U ... values) {
        ArrayList<U> list = new ArrayList<U>(Arrays.asList(values));
        return list;
    }

    @SafeVarargs
    public static <U> ArrayList<U> mergeLists(List<U> ... lists) {
        ArrayList<U> mergedList = new ArrayList<U>();
        for (List<U> list : lists) {
            if (list == null) continue;
            for (U value : list) {
                mergedList.add(value);
            }
        }
        return mergedList;
    }

    @SafeVarargs
    public static <U> ArrayList<U> mergeCollectionsToList(Collection<U> ... collections) {
        ArrayList<U> mergedList = new ArrayList<U>();
        for (Collection<U> collection : collections) {
            if (collection == null) continue;
            for (U value : collection) {
                mergedList.add(value);
            }
        }
        return mergedList;
    }

    @SafeVarargs
    public static <U> HashSet<U> newHashSetOfValues(U ... values) {
        return new HashSet<U>(Arrays.asList(values));
    }

    @SafeVarargs
    public static <U, T> Map<U, List<T>> mergeMaps(Map<U, List<T>> ... maps) {
        HashMap mergedMap = new HashMap();
        for (Map<U, List<T>> map : maps) {
            if (map == null) continue;
            for (Map.Entry<U, List<T>> entry : map.entrySet()) {
                mergedMap.putIfAbsent(entry.getKey(), new ArrayList());
                ((List)mergedMap.get(entry.getKey())).addAll((Collection)entry.getValue());
            }
        }
        return mergedMap;
    }

    public static <T> boolean checkWeightedMap(Map<T, Integer> map, boolean printWarning) {
        if (map.isEmpty()) {
            return true;
        }
        boolean hasPositiveValue = false;
        for (Integer weight : map.values()) {
            if (weight > 0) {
                hasPositiveValue = true;
                continue;
            }
            if (weight >= 0) continue;
            if (printWarning) {
                System.err.println("Warning: negative weights within weighted map!\nFirst 10 elements: " + map.entrySet().stream().limit(10L).map(e -> e.getKey().toString() + "=" + ((Integer)e.getValue()).toString()).collect(Collectors.joining(", ")));
                if (Main.DEBUG) {
                    new IllegalArgumentException().printStackTrace();
                }
            }
            return false;
        }
        if (printWarning && !hasPositiveValue) {
            System.err.println("Warning: all weights are zero in weighted map!\nFirst 10 elements: " + map.entrySet().stream().limit(10L).map(e -> e.getKey().toString() + "=" + ((Integer)e.getValue()).toString()).collect(Collectors.joining(", ")));
            if (Main.DEBUG) {
                new IllegalArgumentException().printStackTrace();
            }
        }
        return hasPositiveValue;
    }

    public static <T> boolean checkWeightedFloatMap(Map<T, Float> map, boolean printWarning) {
        if (map.isEmpty()) {
            return true;
        }
        boolean hasPositiveValue = false;
        for (Float weight : map.values()) {
            if (weight.floatValue() > 0.0f) {
                hasPositiveValue = true;
                continue;
            }
            if (!(weight.floatValue() < 0.0f)) continue;
            if (printWarning) {
                System.err.println("Warning: negative weights within weighted map!\nFirst 10 elements: " + map.entrySet().stream().limit(10L).map(e -> e.getKey().toString() + "=" + ((Float)e.getValue()).toString()).collect(Collectors.joining(", ")));
                if (Main.DEBUG) {
                    new IllegalArgumentException().printStackTrace();
                }
            }
            return false;
        }
        if (printWarning && !hasPositiveValue) {
            System.err.println("Warning: all weights are zero in weighted map!\nFirst 10 elements: " + map.entrySet().stream().limit(10L).map(e -> e.getKey().toString() + "=" + ((Float)e.getValue()).toString()).collect(Collectors.joining(", ")));
            if (Main.DEBUG) {
                new IllegalArgumentException().printStackTrace();
            }
        }
        return hasPositiveValue;
    }

    public static <T> T getHighestProbabilityEntryFromWeightedMap(Map<T, Integer> map) {
        Util.checkWeightedMap(map, true);
        T top = null;
        int high = 0;
        for (Map.Entry<T, Integer> entry : map.entrySet()) {
            if (entry.getValue() <= high) continue;
            high = entry.getValue();
            top = entry.getKey();
        }
        return top;
    }

    public static <T> T getRandomObjectFromWeightedMap(Map<T, Integer> map) {
        return Util.getRandomObjectFromWeightedMap(map, random);
    }

    public static <T> T getRandomObjectFromWeightedMap(Map<T, Integer> map, Random rnd) {
        Util.checkWeightedMap(map, true);
        int total = 0;
        for (int i : map.values()) {
            total += i;
        }
        if (total == 0) {
            return null;
        }
        int choice = rnd.nextInt(total) + 1;
        total = 0;
        for (Map.Entry<T, Integer> entry : map.entrySet()) {
            if (choice > (total += entry.getValue().intValue())) continue;
            return entry.getKey();
        }
        return null;
    }

    public static <T> T getRandomObjectFromWeightedFloatMap(Map<T, Float> map) {
        Util.checkWeightedFloatMap(map, true);
        float total = 0.0f;
        for (float f : map.values()) {
            total += f;
        }
        float choice = (float)(Math.random() * (double)total);
        total = 0.0f;
        for (Map.Entry<T, Float> entry : map.entrySet()) {
            if (!(choice <= (total += entry.getValue().floatValue()))) continue;
            return entry.getKey();
        }
        return null;
    }

    static String intBlockToString(int integer, boolean isLower, char charTwo) {
        if (integer == 2 && !isLower) {
            return String.valueOf(charTwo);
        }
        StringBuilder sb = new StringBuilder();
        String intStr = Integer.toString(integer);
        int n = intStr.length();
        for (int i = 0; i < n; ++i) {
            int num = intStr.charAt(i) - 48;
            if (num == 0 && sb.length() > 0 && sb.charAt(sb.length() - 1) == '\u96f6') continue;
            String digit = digits[num];
            if (num == 2 && n - 1 - i != 0 && n - 1 - i != 1) {
                sb.append('\u4e24');
            } else {
                sb.append(digit);
            }
            if (num != 0) {
                sb.append(lower_base[n - 1 - i]);
            }
            if (isLower || sb.length() <= 1 || sb.charAt(0) != '\u4e00' || sb.charAt(1) != '\u5341') continue;
            sb.deleteCharAt(0);
        }
        if (sb.length() == 0) {
            return "";
        }
        if (sb.charAt(sb.length() - 1) == '\u96f6') {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public static String intToString(long integer) {
        return Util.intToString(integer, true);
    }

    public static String intToString(long integer, boolean withLiang) {
        if (integer == 0L) {
            return "\u96f6";
        }
        StringBuilder sb = new StringBuilder();
        String minus = "";
        if (integer < 0L) {
            minus = "\u8d1f";
            integer = -integer;
        }
        int upper_cap = 0;
        while (integer > 0L) {
            int upper = (int)(integer % 10000L);
            if (sb.length() == 1 || sb.length() > 1 && sb.charAt(1) != '\u5343') {
                sb.insert(0, '\u96f6');
            }
            sb.insert(0, Util.intBlockToString(upper, integer / 10000L > 0L, withLiang ? (char)'\u4e24' : '\u4e8c') + upper_base[upper_cap]);
            integer /= 10000L;
            ++upper_cap;
        }
        sb.insert(0, minus);
        return sb.toString();
    }

    public static String intToStringOld(long integer) {
        boolean minus = integer < 0L;
        integer = Math.abs(integer);
        int i = 0;
        StringBuilder sb = new StringBuilder();
        while (integer > 0L) {
            StringBuilder innerSB = new StringBuilder();
            int thousandths = (int)(integer % 1000L);
            int hundred = thousandths / 100;
            if (hundred > 0) {
                innerSB.append(numbersLessThanTwenty[hundred] + "\u767e");
            }
            int tens = thousandths % 100;
            if (thousandths % 100 > 0) {
                if (innerSB.length() > 0) {
                    innerSB.append("");
                }
                if (tens < 20) {
                    innerSB.append(numbersLessThanTwenty[thousandths % 100]);
                } else {
                    innerSB.append(tensGreaterThanNineteen[tens / 10]);
                    if (tens % 10 > 0) {
                        innerSB.append(" ");
                        innerSB.append(numbersLessThanTwenty[tens % 10]);
                    }
                }
            }
            if (innerSB.length() > 0) {
                switch (i) {
                    case 1: {
                        innerSB.append("\u5343");
                        break;
                    }
                    case 2: {
                        innerSB.append("\u767e\u4e07");
                        break;
                    }
                    case 3: {
                        innerSB.append("\u5341\u4ebf");
                        break;
                    }
                    case 4: {
                        innerSB.append("\u4e07\u4ebf");
                        break;
                    }
                    case 5: {
                        innerSB.append("\u4e07\u4ebf");
                        break;
                    }
                    case 6: {
                        innerSB.append(" \u4e07\u4ebf");
                        break;
                    }
                    case 7: {
                        innerSB.append(" sextillion");
                    }
                }
            }
            if (sb.length() > 0) {
                innerSB.append(", ");
            }
            sb.insert(0, innerSB.toString());
            integer /= 1000L;
            ++i;
        }
        if (minus) {
            sb.insert(0, "minus ");
        }
        return sb.toString();
    }

    public static String intToIndividualNumbersString(int integer) {
        LinkedList<String> stringStack = new LinkedList<String>();
        boolean negative = false;
        if (integer < 0) {
            negative = true;
            integer = Math.abs(integer);
        }
        while (integer > 0) {
            stringStack.push(numbersLessThanTwenty[integer % 10]);
            integer /= 10;
        }
        StringBuilder sb = new StringBuilder();
        if (negative) {
            sb.append("\u8d1f");
        }
        while (!stringStack.isEmpty()) {
            sb.append((String)stringStack.pop());
            if (stringStack.isEmpty()) continue;
            sb.append("-");
        }
        return sb.toString();
    }

    public static String intToPrimarySequence(int integer) {
        if (integer > 0 && integer <= primarySequence.length) {
            return primarySequence[integer - 1];
        }
        return Util.intToString(integer);
    }

    public static String intToDate(int integer) {
        int remainderHundred = integer % 100;
        if (remainderHundred <= 10 || remainderHundred > 20) {
            if (integer % 10 == 1) {
                return integer + "\u65e5";
            }
            if (integer % 10 == 2) {
                return integer + "\u65e5";
            }
            if (integer % 10 == 3) {
                return integer + "\u65e5";
            }
        }
        return integer + "\u65e5";
    }

    public static String intToCount(int integer) {
        if (integer == 1) {
            return "\u4e00\u6b21";
        }
        if (integer == 2) {
            return "\u4e24\u6b21";
        }
        return Util.intToString(integer) + "\u6b21";
    }

    public static String intToPosition(int integer) {
        return "\u7b2c" + Util.intToString(integer, false);
    }

    public static String intToPositionOld(int integer) {
        Object intToString = "";
        if (integer < 0) {
            intToString = "\u8d1f";
        }
        if ((integer = Math.abs(integer)) >= 100000) {
            return String.valueOf(integer);
        }
        if (integer >= 1000) {
            intToString = integer / 1000 < 20 ? (String)intToString + numbersLessThanTwenty[integer / 1000] + "\u5343" : (String)intToString + tensGreaterThanNineteen[integer / 10000] + (String)(integer / 1000 % 10 != 0 ? numbersLessThanTwenty[integer / 1000 % 10] : "") + "\u5343";
        }
        if (integer >= 100) {
            if (integer >= 1000 && integer % 1000 != 0) {
                intToString = (String)intToString;
            }
            if (((String)intToString).isEmpty() || (integer %= 1000) >= 100) {
                intToString = (String)intToString + numbersLessThanTwenty[integer / 100] + "\u767e";
            }
            if (integer % 100 != 0) {
                intToString = (String)intToString;
                integer %= 100;
            }
        }
        if (integer % 100 < 20) {
            if (integer % 100 == 0) {
                if (((String)intToString).isEmpty()) {
                    return "\u96f6";
                }
            } else {
                intToString = (String)intToString + positionsLessThanTwenty[integer % 100];
            }
        } else {
            intToString = (String)intToString + tensGreaterThanNineteen[integer % 100 / 10] + (String)(integer % 10 != 0 ? positionsLessThanTwenty[integer % 10] : "");
        }
        return intToString;
    }

    public static String intToNumerals(int integer) {
        if (integer <= 0) {
            return "0";
        }
        int l = numeralMap.floorKey(integer);
        if (integer == l) {
            return numeralMap.get(integer);
        }
        return numeralMap.get(l) + Util.intToNumerals(integer - l);
    }

    public static String intToTally(int integer, int max) {
        int i;
        StringBuilder numeralSB = new StringBuilder();
        int limit = Math.min(integer, max);
        for (i = 0; i < limit / 5; ++i) {
            numeralSB.append("<strike>IIII</strike> ");
        }
        for (i = 0; i < limit % 5; ++i) {
            numeralSB.append("I");
        }
        if (limit < integer) {
            numeralSB.append("\u2026\u2026 (\u5171\u8ba1\uff1a" + integer + ")");
        }
        return numeralSB.toString();
    }

    public static String intToZheng(int integer, int max) {
        StringBuilder numeralSB = new StringBuilder();
        int limit = Math.min(integer, max);
        for (int i = 0; i < limit / 5; ++i) {
            numeralSB.append("\u6b63");
        }
        if (limit % 5 != 0) {
            numeralSB.append(zhengPhase[limit % 5 - 1]);
        }
        if (limit < integer) {
            numeralSB.append("\u2026\u2026(\u5171\u8ba1\uff1a" + integer + ")");
        }
        return numeralSB.toString();
    }

    public static String getKeyCodeCharacter(KeyCode code) {
        String name = KEY_NAMES.get((Object)code);
        return name != null ? name : code.getName();
    }

    public static String capitaliseSentence(String sentence) {
        if (sentence == null || sentence.isEmpty()) {
            return sentence;
        }
        int openingCurly = 0;
        int closingCurly = 0;
        int openingAngular = 0;
        int closingAngular = 0;
        int openingSquare = 0;
        int closingSquare = 0;
        for (int i = 0; i < sentence.length(); ++i) {
            if (sentence.charAt(i) == '(') {
                ++openingCurly;
            } else if (sentence.charAt(i) == '<') {
                ++openingAngular;
            } else if (sentence.charAt(i) == '[') {
                ++openingSquare;
            }
            if (openingCurly == closingCurly && openingAngular == closingAngular && openingSquare == closingSquare && sentence.charAt(i) != ' ') {
                return (i > 0 ? sentence.substring(0, i) : "") + Character.toUpperCase(sentence.charAt(i)) + sentence.substring(i + 1);
            }
            if (sentence.charAt(i) == ')') {
                ++closingCurly;
                continue;
            }
            if (sentence.charAt(i) == '>') {
                ++closingAngular;
                continue;
            }
            if (sentence.charAt(i) != ']') continue;
            ++closingSquare;
        }
        return Character.toUpperCase(sentence.charAt(0)) + sentence.substring(1);
    }

    public static boolean isVowel(char c) {
        return "AEIOUaeiou".indexOf(c) != -1;
    }

    public static String addStutter(String sentence, int frequency) {
        StringBuilder modifiedSentence = new StringBuilder();
        int openingCurly = 0;
        int closingCurly = 0;
        int openingAngular = 0;
        int closingAngular = 0;
        int openingSquare = 0;
        int closingSquare = 0;
        float chance = 1.0f / (float)frequency;
        for (int i = sentence.length() - 1; i >= 0; --i) {
            if (sentence.charAt(i) == '(') {
                ++openingCurly;
            } else if (sentence.charAt(i) == ')') {
                ++closingCurly;
            } else if (sentence.charAt(i) == '<') {
                ++openingAngular;
            } else if (sentence.charAt(i) == '>') {
                ++closingAngular;
            } else if (sentence.charAt(i) == '[') {
                ++openingSquare;
            } else if (sentence.charAt(i) == ']') {
                ++closingSquare;
            }
            if (sentence.charAt(i) == ' ' && Character.isLetter(sentence.charAt(i + 1)) && openingCurly == closingCurly && openingAngular == closingAngular && openingSquare == closingSquare && Math.random() < (double)chance) {
                modifiedSentence.append("-");
                modifiedSentence.append(sentence.charAt(i + 1));
            }
            modifiedSentence.append(sentence.charAt(i));
        }
        modifiedSentence.reverse();
        return modifiedSentence.toString();
    }

    private static boolean isEndOfSentence(char c) {
        return endOfSentence.matcher(String.valueOf(c)).matches();
    }

    public static String insertIntoSentences(String sentence, int frequency, String[] inserts, boolean middle) {
        boolean debug = false;
        ArrayList<String> splitSentence = new ArrayList<String>();
        ArrayList<String> conditionalTags = Util.newArrayListOfValues("#ENDIF", "#ELSEIF", "#ELSE", "#IF");
        int openingCurly = 0;
        int closingCurly = 0;
        int openingSquare = 0;
        int closingSquare = 0;
        int conditionalHashIndex = -1;
        int conditionalHashIndexEnd = -1;
        StringBuilder currentString = new StringBuilder();
        for (int i2 = 0; i2 < sentence.length(); ++i2) {
            boolean noBrackets = openingCurly == closingCurly && openingSquare == closingSquare;
            boolean opening = false;
            boolean conditionalHashFound = false;
            if (sentence.charAt(i2) == '(') {
                ++openingCurly;
                opening = true;
            } else if (sentence.charAt(i2) == ')') {
                ++closingCurly;
            } else if (sentence.charAt(i2) == '[') {
                ++openingSquare;
                opening = true;
            } else if (sentence.charAt(i2) == ']') {
                ++closingSquare;
            } else if (sentence.charAt(i2) == '#') {
                conditionalHashFound = true;
                conditionalHashIndex = i2;
                for (String s : conditionalTags) {
                    try {
                        if (!sentence.substring(conditionalHashIndex, conditionalHashIndex + s.length()).equals(s)) continue;
                        conditionalHashIndexEnd = conditionalHashIndex + s.length();
                        break;
                    }
                    catch (Exception exception) {
                    }
                }
            }
            if (conditionalHashFound) {
                splitSentence.add(currentString.toString());
                currentString.setLength(0);
                currentString.append(sentence.charAt(i2));
                continue;
            }
            if (conditionalHashIndex > -1) {
                if (i2 == conditionalHashIndexEnd) {
                    conditionalHashIndex = -1;
                    conditionalHashIndexEnd = -1;
                    splitSentence.add(currentString.toString());
                    currentString.setLength(0);
                }
                currentString.append(sentence.charAt(i2));
                continue;
            }
            if (!noBrackets && openingCurly == closingCurly && openingSquare == closingSquare || noBrackets && (openingCurly != closingCurly || openingSquare != closingSquare)) {
                if (!opening) {
                    currentString.append(sentence.charAt(i2));
                }
                splitSentence.add(currentString.toString());
                currentString.setLength(0);
                if (!opening) continue;
                currentString.append(sentence.charAt(i2));
                continue;
            }
            currentString.append(sentence.charAt(i2));
        }
        if (currentString.length() > 0) {
            splitSentence.add(currentString.toString());
        }
        ArrayList<Object> finalSplitSentence = new ArrayList<Object>();
        for (String s : splitSentence) {
            if (!(s.contains("#") || s.contains("[") || s.contains("("))) {
                Collections.addAll(finalSplitSentence, s.split("(?<=(\\s))"));
                continue;
            }
            finalSplitSentence.add(s);
        }
        ArrayList<Integer> availableIndexes = new ArrayList<Integer>();
        ArrayList<Integer> availableCommaIndexes = new ArrayList<Integer>();
        for (int i3 = 0; i3 < finalSplitSentence.size(); ++i3) {
            String s = (String)finalSplitSentence.get(i3);
            if (!s.matches(".*[a-zA-Z,]+.*") || s.contains("#") || s.contains("[") || s.contains("(") || s.contains("~") || Util.isEndOfSentence(s.charAt(s.length() - 1)) || i3 != finalSplitSentence.size() - 1 && Util.isEndOfSentence(((String)finalSplitSentence.get(i3 + 1)).charAt(0))) continue;
            if (s.contains(",")) {
                availableCommaIndexes.add(i3);
            } else if (!s.endsWith(". ")) {
                availableIndexes.add(i3);
            }
            if (!debug) continue;
            System.out.println(s);
        }
        int totalInserts = Math.max(1, (int)(1.0f / (float)frequency * (float)availableIndexes.size() + (float)availableCommaIndexes.size()));
        ArrayList<String> availableInserts = new ArrayList<String>();
        Collections.addAll(availableInserts, inserts);
        ArrayList<String> availableCommaInserts = new ArrayList<String>(availableInserts);
        availableInserts.removeIf(i -> i.contains(","));
        availableCommaInserts.removeIf(i -> !i.contains(","));
        if (debug) {
            System.out.println("Total inserts:" + totalInserts);
        }
        ArrayList<String> insertPool = new ArrayList<String>();
        while (!((availableIndexes.isEmpty() || availableInserts.isEmpty() && availableCommaInserts.isEmpty()) && (availableCommaIndexes.isEmpty() || availableCommaInserts.isEmpty()) || totalInserts <= 0)) {
            String sentenceToReplace;
            int randomindex;
            if (!availableCommaIndexes.isEmpty() && !availableCommaInserts.isEmpty()) {
                randomindex = (Integer)Util.randomItemFrom(availableCommaIndexes);
                sentenceToReplace = (String)finalSplitSentence.get(randomindex);
                if (insertPool.isEmpty()) {
                    insertPool.addAll(availableCommaInserts);
                }
                ArrayList<String> arrayList = new ArrayList<String>(insertPool);
                String adjacentLeft = randomindex > 0 ? (String)finalSplitSentence.get(randomindex - 1) : "";
                String adjacentRight = randomindex < finalSplitSentence.size() - 1 ? (String)finalSplitSentence.get(randomindex + 1) : "";
                arrayList.removeIf(i -> i.contains(adjacentLeft.trim().replaceAll("[,.!?]", "")));
                arrayList.removeIf(i -> i.contains(sentenceToReplace.trim().replaceAll("[,.!?]", "")));
                arrayList.removeIf(i -> i.contains(adjacentRight.trim().replaceAll("[,.!?]", "")));
                if (debug) {
                    System.out.println("comma adjL: " + adjacentLeft);
                    System.out.println("comma adjR: " + adjacentRight);
                }
                if (arrayList.isEmpty()) {
                    ArrayList arrayList2 = new ArrayList(insertPool);
                }
                String insert = (String)Util.randomItemFrom(insertPool);
                if (insertPool.size() != availableCommaInserts.size()) {
                    insertPool = new ArrayList(availableCommaInserts);
                }
                insertPool.removeIf(i -> i.equals(insert));
                finalSplitSentence.set(randomindex, sentenceToReplace.replaceFirst(",", insert));
                availableIndexes.remove((Object)(randomindex - 1));
                availableCommaIndexes.remove((Object)(randomindex - 1));
                availableCommaIndexes.remove((Object)randomindex);
                availableCommaIndexes.remove((Object)(randomindex + 1));
                availableIndexes.remove((Object)(randomindex + 1));
                --totalInserts;
                continue;
            }
            if (availableIndexes.isEmpty() || availableInserts.isEmpty() && availableCommaInserts.isEmpty()) continue;
            randomindex = (Integer)Util.randomItemFrom(availableIndexes);
            sentenceToReplace = (String)finalSplitSentence.get(randomindex);
            ArrayList<String> availableInsertsPool = !availableInserts.isEmpty() ? availableInserts : availableCommaInserts;
            if (insertPool.isEmpty()) {
                insertPool.addAll(availableInsertsPool);
            }
            ArrayList<String> adjacentsRemovedPool = new ArrayList<String>(insertPool);
            String adjacentLeft = randomindex > 0 ? (String)finalSplitSentence.get(randomindex - 1) : "";
            String adjacentRight = randomindex < finalSplitSentence.size() - 1 ? (String)finalSplitSentence.get(randomindex + 1) : "";
            adjacentsRemovedPool.removeIf(i -> i.contains(adjacentLeft.trim().replaceAll("[,.!?]", "")));
            adjacentsRemovedPool.removeIf(i -> i.contains(sentenceToReplace.trim().replaceAll("[,.!?]", "")));
            adjacentsRemovedPool.removeIf(i -> i.contains(adjacentRight.trim().replaceAll("[,.!?]", "")));
            if (debug) {
                System.out.println("adjL: " + adjacentLeft);
                System.out.println("adjR: " + adjacentRight);
            }
            if (adjacentsRemovedPool.isEmpty()) {
                adjacentsRemovedPool = new ArrayList(insertPool);
            }
            String string = (String)Util.randomItemFrom(adjacentsRemovedPool);
            if (insertPool.size() != availableInsertsPool.size()) {
                insertPool = new ArrayList(availableInsertsPool);
            }
            insertPool.removeIf(i -> i.equals(insert));
            if (sentenceToReplace.contains(" ")) {
                finalSplitSentence.set(randomindex, sentenceToReplace.replaceFirst(" ", string + " "));
            } else if (!Character.isUpperCase(sentenceToReplace.charAt(0))) {
                finalSplitSentence.set(randomindex, string + " " + sentenceToReplace);
            } else {
                finalSplitSentence.set(randomindex, sentenceToReplace + string);
            }
            availableIndexes.remove((Object)(randomindex - 1));
            availableIndexes.remove((Object)randomindex);
            availableIndexes.remove((Object)(randomindex + 1));
            --totalInserts;
        }
        StringBuilder sb = new StringBuilder();
        for (String string : finalSplitSentence) {
            sb.append(string);
        }
        if (debug) {
            System.out.println("-----");
            System.out.println(sb.toString());
        }
        return sb.toString();
    }

    private static String insertIntoSentences(String sentence, int frequency, String[] inserts) {
        return Util.insertIntoSentences(sentence, frequency, inserts, true);
    }

    public static String addBimbo(String sentence, int frequency) {
        sentence = Util.insertIntoSentences(sentence, frequency, bimboWords);
        StringBuilder utilitiesStringBuilder = new StringBuilder();
        utilitiesStringBuilder.append(sentence);
        if (!(sentence.endsWith("~") || sentence.endsWith("-") || sentence.endsWith("#ENDIF"))) {
            int deleteindex = utilitiesStringBuilder.length() - 1;
            if (sentence.endsWith("?!")) {
                deleteindex = utilitiesStringBuilder.length() - 2;
            } else if (sentence.endsWith("...")) {
                deleteindex = utilitiesStringBuilder.length() - 3;
            }
            switch (random.nextInt(6)) {
                case 0: {
                    CharSequence cs = utilitiesStringBuilder.subSequence(deleteindex, utilitiesStringBuilder.length());
                    utilitiesStringBuilder.delete(deleteindex, utilitiesStringBuilder.length());
                    utilitiesStringBuilder.append("\u5565\u7684");
                    utilitiesStringBuilder.append(cs);
                    break;
                }
                case 1: {
                    utilitiesStringBuilder.delete(deleteindex, utilitiesStringBuilder.length());
                    utilitiesStringBuilder.append("\uff0c\u61c2\u5427\uff1f");
                    break;
                }
            }
        }
        String returnString = utilitiesStringBuilder.toString();
        returnString = returnString.replaceAll("\u4f60\u597d", "\u563f");
        returnString = returnString.replaceAll("\u4f60\u597d", "\u563f");
        returnString = returnString.replaceAll("\u518d\u89c1", "\u62dc\u62dc");
        returnString = returnString.replaceAll("\u518d\u89c1", "\u62dc\u62dc");
        return returnString;
    }

    public static String addBro(String sentence, int frequency) {
        sentence = Util.insertIntoSentences(sentence, frequency, broWords);
        StringBuilder utilitiesStringBuilder = new StringBuilder();
        utilitiesStringBuilder.append(sentence);
        if (!(sentence.endsWith("~") || sentence.endsWith("-") || sentence.endsWith("#ENDIF"))) {
            switch (random.nextInt(6)) {
                case 0: {
                    char end = utilitiesStringBuilder.charAt(utilitiesStringBuilder.length() - 1);
                    utilitiesStringBuilder.deleteCharAt(utilitiesStringBuilder.length() - 1);
                    utilitiesStringBuilder.append("\u5565\u7684");
                    utilitiesStringBuilder.append(end);
                    break;
                }
                case 1: {
                    utilitiesStringBuilder.deleteCharAt(utilitiesStringBuilder.length() - 1);
                    utilitiesStringBuilder.append(UtilText.returnStringAtRandom("\uff0c\u662f\u5417\uff1f", "\uff0c\u77e5\u9053\u5427\u54e5\u4eec\uff1f"));
                    break;
                }
            }
        }
        return utilitiesStringBuilder.toString();
    }

    public static String replaceWithMute(String sentence, boolean sexMoans) {
        int length = Math.max(1, sentence.split(" ").length / 3);
        StringBuilder muteSB = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            if (sexMoans) {
                muteSB.append(muteSexSounds[random.nextInt(muteSexSounds.length)]);
                continue;
            }
            muteSB.append("\u2026\u2026");
        }
        muteSB.deleteCharAt(muteSB.length() - 1);
        return muteSB.toString();
    }

    public static String addMuffle(String sentence, int frequency) {
        return Util.insertIntoSentences(sentence, frequency, muffledSounds);
    }

    public static String replaceWithMuffle(String sentence, int wordToMuffleRatio) {
        int muffles = sentence.split(" ").length / wordToMuffleRatio;
        StringBuilder muffleSB = new StringBuilder();
        for (int i = 0; i < muffles; ++i) {
            muffleSB.append(muffledSounds[random.nextInt(muffledSounds.length)]);
        }
        muffleSB.delete(0, 1);
        return muffleSB.toString();
    }

    public static String addSexSounds(String sentence, int frequency, boolean resisting) {
        return Util.insertIntoSentences(sentence, frequency, resisting ? sexSoundsResisting : sexSounds);
    }

    public static String addDrunkSlur(String sentence, int frequency) {
        String[] split;
        sentence = Util.insertIntoSentences(sentence, frequency, drunkSounds, false);
        for (String s : split = sentence.split("\\[(.*?)\\]")) {
            String[] splitConditional;
            for (String s2 : splitConditional = s.split("#IF\\((.*?)\\)|#ELSEIF\\((.*?)\\)")) {
                String sReplace = s2.replaceAll("Hi ", "Heeey ").replaceAll("yes", "yesh").replaceAll("Is", "Ish").replaceAll("is", "ish").replaceAll("It's", "It'sh").replaceAll("it's", "it'sh").replaceAll("So", "Sho").replaceAll("so", "sho");
                sentence = sentence.replace(s2, sReplace);
            }
        }
        return sentence;
    }

    public static String applySlovenlySpeech(String sentence) {
        String modifiedSentence = sentence;
        for (Map.Entry<String, String> entry : slovenlySpeechReplacementMap.entrySet()) {
            modifiedSentence = modifiedSentence.replaceAll("([^A-Za-z0-9\\.]|^)" + entry.getKey() + "([^A-Za-z0-9\\]])", "$1" + entry.getValue() + "$2");
        }
        modifiedSentence = modifiedSentence.replaceAll("ing([^A-Za-z0-9\\]])", "in'$1");
        return modifiedSentence;
    }

    public static String applyLisp(String sentence) {
        StringBuilder modifiedSentence = new StringBuilder();
        int openingCurly = 0;
        int closingCurly = 0;
        int openingAngular = 0;
        int closingAngular = 0;
        int openingSquare = 0;
        int closingSquare = 0;
        for (int i = sentence.length() - 1; i >= 0; --i) {
            if (sentence.charAt(i) == '(') {
                ++openingCurly;
            } else if (sentence.charAt(i) == ')') {
                ++closingCurly;
            } else if (sentence.charAt(i) == '<') {
                ++openingAngular;
            } else if (sentence.charAt(i) == '>') {
                ++closingAngular;
            } else if (sentence.charAt(i) == '[') {
                ++openingSquare;
            } else if (sentence.charAt(i) == ']') {
                ++closingSquare;
            }
            if (openingCurly == closingCurly && openingAngular == closingAngular && openingSquare == closingSquare) {
                if (sentence.charAt(i) == 's' || sentence.charAt(i) == 'z') {
                    modifiedSentence.append(">i/<ht>i<");
                    continue;
                }
                if (sentence.charAt(i) == 'S' && i - 1 >= 0 && sentence.charAt(i - 1) != 'L' || sentence.charAt(i) == 'Z') {
                    modifiedSentence.append(">i/<hT>i<");
                    continue;
                }
                modifiedSentence.append(sentence.charAt(i));
                continue;
            }
            modifiedSentence.append(sentence.charAt(i));
        }
        modifiedSentence.reverse();
        return modifiedSentence.toString();
    }

    private static <T> String toStringList(Collection<T> items, Function<T, String> stringExtractor, String combiningWord) {
        Iterator<T> itemIterator = items.iterator();
        StringBuilder utilitiesStringBuilder = new StringBuilder();
        try {
            T currentItem = itemIterator.next();
            utilitiesStringBuilder.append(stringExtractor.apply(currentItem));
            if (itemIterator.hasNext()) {
                currentItem = itemIterator.next();
                while (itemIterator.hasNext()) {
                    utilitiesStringBuilder.append("\u3001" + stringExtractor.apply(currentItem));
                    currentItem = itemIterator.next();
                }
                utilitiesStringBuilder.append((items.size() > 2 ? "" : "") + combiningWord + stringExtractor.apply(currentItem));
            }
        }
        catch (NoSuchElementException ex) {
            System.err.println("Util.toStringList() error - NoSuchElementException! (It's probably nothing to worry about...)");
            ex.printStackTrace();
        }
        return utilitiesStringBuilder.toString();
    }

    public static String subspeciesToStringList(Collection<AbstractSubspecies> subspecies, boolean capitalise) {
        return Util.toStringList(subspecies, o -> "<span style='color:" + o.getColour(null).toWebHexString() + ";'>" + (capitalise ? Util.capitaliseSentence(o.getNamePlural(null)) : o.getNamePlural(null)) + "</span>", "\u3001");
    }

    public static String charactersToStringListOfNames(Collection<GameCharacter> characters) {
        return Util.charactersToStringListOfNames(characters, false);
    }

    public static String charactersToStringListOfNames(Collection<GameCharacter> characters, boolean withColouring) {
        return Util.toStringList(characters, c -> UtilText.parse(c, (String)(withColouring ? "<span style='color:" + c.getFemininity().getColour().toWebHexString() + ";'>" : "") + "[npc.name]" + (withColouring ? "</span>" : ""), new ParserTag[0]), "\u3001");
    }

    public static String clothesToStringList(Collection<AbstractClothing> clothingSet, boolean capitalise) {
        return Util.toStringList(clothingSet, o -> capitalise ? Util.capitaliseSentence(o.getClothingType().getName()) : o.getClothingType().getName(), "\u3001");
    }

    public static String setToStringListCoverableArea(Set<CoverableArea> coverableAreaSet) {
        return Util.toStringList(coverableAreaSet, o -> Util.capitaliseSentence(o.getName()), "\u3001");
    }

    public static String stringsToStringList(List<String> list, boolean capitalise) {
        return Util.toStringList(list, o -> capitalise ? Util.capitaliseSentence(o) : o, "\u548c");
    }

    public static String stringsToStringChoice(List<String> list, boolean capitalise) {
        return Util.toStringList(list, o -> capitalise ? Util.capitaliseSentence(o) : o, "\u6216");
    }

    public static String coloursToStringList(Collection<Colour> colourSet) {
        return Util.toStringList(colourSet, Colour::getName, "\u3001");
    }

    public static String coverableAreaListToStringList(List<CoverableArea> coverableAreaCollection) {
        return Util.toStringList(coverableAreaCollection, CoverableArea::getName, "\u3001");
    }

    public static String inventorySlotsToStringList(List<InventorySlot> inventorySlots) {
        return Util.toStringList(inventorySlots, InventorySlot::getName, "\u3001");
    }

    public static String inventorySlotsToParsedStringList(List<InventorySlot> inventorySlots, GameCharacter owner) {
        return Util.toStringList(inventorySlots, slot -> slot.getNameOfAssociatedPart(owner), "\u3001");
    }

    public static String tattooInventorySlotsToStringList(List<InventorySlot> inventorySlots) {
        return Util.toStringList(inventorySlots, InventorySlot::getTattooSlotName, "\u3001");
    }

    public static String displacementTypesToStringList(List<DisplacementType> displacedList) {
        return Util.toStringList(displacedList, DisplacementType::getDescriptionPast, "\u3001");
    }

    public static <Any> Any randomItemFrom(List<Any> list) {
        if (list.isEmpty()) {
            return null;
        }
        return list.get(random.nextInt(list.size()));
    }

    public static <Any> Any randomItemFrom(Set<Any> set) {
        ArrayList<Any> list = new ArrayList<Any>(set);
        return Util.randomItemFrom(list);
    }

    public static <Any> Any randomItemFrom(Any[] array) {
        return array[random.nextInt(array.length)];
    }

    public static int randomItemFrom(int[] array) {
        return array[random.nextInt(array.length)];
    }

    @SafeVarargs
    public static <Any> Any randomItemFromValues(Any ... values) {
        return values[random.nextInt(values.length)];
    }

    public static String getClosestStringMatch(String input, Collection<String> choices, int maxDistance) {
        if (input.isEmpty() || choices.contains(input)) {
            return input;
        }
        int stringMatchDistance = Integer.MAX_VALUE;
        String closestString = input;
        for (String choice : choices) {
            int newDistance = Util.getLevenshteinDistance(input, choice);
            if (newDistance >= stringMatchDistance) continue;
            closestString = choice;
            stringMatchDistance = newDistance;
        }
        if (stringMatchDistance > maxDistance) {
            System.err.println("Warning: getClosestStringMatch() did not find a close enough match for '" + input + "'; returning null. (Closest match was '" + closestString + "' at distance: " + stringMatchDistance + ")");
            return null;
        }
        if (stringMatchDistance > 0) {
            System.err.println("Warning: getClosestStringMatch() did not find an exact match for '" + input + "'; returning '" + closestString + "' instead. (Distance: " + stringMatchDistance + ")");
            if (Main.DEBUG) {
                new IllegalArgumentException().printStackTrace(System.err);
            }
        }
        return closestString;
    }

    public static String getClosestStringMatch(String input, Collection<String> choices) {
        return Util.getClosestStringMatch(input, choices, Integer.MAX_VALUE);
    }

    private static String unordered(String input, int prefix) {
        String p = "";
        String r = input;
        int prefixLen = 0;
        for (int i = 0; i < prefix; ++i) {
            int idx = input.indexOf(95, prefixLen);
            if (idx < 0) {
                p = input;
                r = "";
                break;
            }
            prefixLen = idx + 1;
            p = input.substring(0, prefixLen);
            r = input.substring(prefixLen);
        }
        return p + Arrays.stream(r.split("_")).sorted().collect(Collectors.joining("_"));
    }

    public static String getClosestStringMatchUnordered(String input, Collection<String> choices) {
        return Util.getClosestStringMatchUnordered(input, 0, choices);
    }

    public static String getClosestStringMatchUnordered(String inputRaw, int prefix, Collection<String> choices) {
        String unorderedInput;
        if (inputRaw.isEmpty() || choices.contains(inputRaw)) {
            return inputRaw;
        }
        String input = inputRaw.replaceAll("[ -]", "_");
        if (choices.contains(input)) {
            System.err.println("Warning: getClosestStringMatchUnordered() did not find an exact match for '" + inputRaw + "'; returning '" + input + "' instead. (Invalid word delimiter)");
            return input;
        }
        Map unorderedChoices = choices.stream().collect(Collectors.toMap(s -> Util.unordered(s, prefix), Function.identity(), (a, b) -> {
            System.err.println("Warning: keeping " + a + " and discarding " + b + "!");
            return a;
        }));
        if (unorderedChoices.containsKey(unorderedInput = Util.unordered(input, prefix))) {
            String unorderedMatch = (String)unorderedChoices.get(unorderedInput);
            System.err.println("Warning: getClosestStringMatchUnordered() did not find an exact match for '" + inputRaw + "'; returning '" + unorderedMatch + "' instead. (Reordered words)");
            return unorderedMatch;
        }
        int distance = Integer.MAX_VALUE;
        String closestString = input;
        for (String unorderedChoice : unorderedChoices.keySet()) {
            int newDistance = Util.getLevenshteinDistance(unorderedInput, unorderedChoice);
            if (newDistance >= distance) continue;
            closestString = (String)unorderedChoices.get(unorderedChoice);
            distance = newDistance;
        }
        if (distance > 0) {
            System.err.println("Warning: getClosestStringMatchUnordered() did not find an exact match for '" + inputRaw + "'; returning '" + closestString + "' instead. (Distance: " + distance + ")");
        }
        return closestString;
    }

    public static int getLevenshteinDistance(String inputOne, String inputTwo) {
        inputOne = inputOne.toLowerCase();
        inputTwo = inputTwo.toLowerCase();
        int[] costs = new int[inputTwo.length() + 1];
        for (int j = 0; j < costs.length; ++j) {
            costs[j] = j;
        }
        for (int i = 1; i <= inputOne.length(); ++i) {
            costs[0] = i;
            int nw = i - 1;
            for (int j = 1; j <= inputTwo.length(); ++j) {
                int cj = Math.min(1 + Math.min(costs[j], costs[j - 1]), inputOne.charAt(i - 1) == inputTwo.charAt(j - 1) ? nw : nw + 1);
                nw = costs[j];
                costs[j] = cj;
            }
        }
        return costs[inputTwo.length()];
    }

    public static void logGetNpcByIdError(String method, String id) {
        if (Main.DEBUG) {
            errorLogMap.putIfAbsent(method, new ArrayList());
            if (!errorLogMap.get(method).contains(id)) {
                System.err.println("Main.game.getNPCById(" + id + ") returning null in method: " + method);
                errorLogMap.get(method).add(id);
            }
        }
    }

    public static String getFileName(File f) {
        return f.getName().substring(0, f.getName().lastIndexOf(46));
    }

    public static String getFileIdentifier(File f) {
        return f.getName().substring(0, f.getName().lastIndexOf(46)).replaceAll("'", "Q");
    }

    public static String getFileName(String filePath) {
        return filePath.substring(0, filePath.lastIndexOf(46));
    }

    public static String getFileIdentifier(String filePath) {
        return filePath.substring(0, filePath.lastIndexOf(46)).replaceAll("'", "Q");
    }

    public static <T extends Enum<T>> List<T> toEnumList(Collection<Element> elements, Class<T> enumType) {
        return elements.stream().map(Element::getTextContent).map(x -> {
            try {
                return Enum.valueOf(enumType, x);
            }
            catch (Exception e) {
                return null;
            }
        }).filter(x -> x != null).collect(Collectors.toList());
    }

    static {
        numeralMap.put(1000, "M");
        numeralMap.put(900, "CM");
        numeralMap.put(500, "D");
        numeralMap.put(400, "CD");
        numeralMap.put(100, "C");
        numeralMap.put(90, "XC");
        numeralMap.put(50, "L");
        numeralMap.put(40, "XL");
        numeralMap.put(10, "X");
        numeralMap.put(9, "IX");
        numeralMap.put(5, "V");
        numeralMap.put(4, "IV");
        numeralMap.put(1, "I");
        zhengPhase = new String[]{"\u4e28", "\u4e04", "\u4e0a", "\u6b62"};
        endOfSentence = Pattern.compile("[,.!?\uff0c\u3002\uff01\uff1f\u3001]");
        bimboWords = new String[]{"\uff0c\u8fd9\u4e2a\uff0c", "\uff0c\u90a3\u4e2a\uff0c", "\uff0c\u5c31\u662f\u8bf4\uff0c", "\uff0c\u55ef\uff0c", "\uff0c\u5443\uff0c", "\uff0c\u554a\uff0c"};
        broWords = new String[]{"\uff0c\u5c31\u662f\u8bf4\uff0c", "\uff0c\u54e5\u4eec\uff0c", "\uff0c\u5144\u5f1f\uff0c", "\uff0c\u8fd9\u4e2a\uff0c", "\uff0c\u55ef\uff0c", "\uff0c\u5443\uff0c", "\uff0c\u554a\uff0c"};
        muteSexSounds = new String[]{"\u2026\u2026~\u54e6\u54e6\uff01~", "\u2026\u2026~\u55ef\u55ef\uff01~", "\u2026\u2026~\u554a\u554a\uff01~"};
        muffledSounds = new String[]{"~\u55ef\u54fc~", "~\u55ef~", "~\u55ef\u989d~"};
        sexSounds = new String[]{" ~\u554a\u554a\uff01~", " ~\u55ef\u55ef\uff01~", " ~\u54e6\u54e6\uff01~"};
        sexSoundsResisting = new String[]{"~\u554a\uff01~", " ~\u4e0d\uff01~", " ~\u5443\u554a\uff01~"};
        drunkSounds = new String[]{"~\u55dd\uff01~"};
        slovenlySpeechReplacementMap = new LinkedHashMap<String, String>();
        slovenlySpeechReplacementMap.put("What are", "Wot's");
        slovenlySpeechReplacementMap.put("what are", "wot's");
        slovenlySpeechReplacementMap.put("Are", "Is");
        slovenlySpeechReplacementMap.put("are", "is");
        slovenlySpeechReplacementMap.put("You're", "You's");
        slovenlySpeechReplacementMap.put("you're", "you's");
        slovenlySpeechReplacementMap.put("Your", "Yer");
        slovenlySpeechReplacementMap.put("your", "yer");
        slovenlySpeechReplacementMap.put("You ", "Ya ");
        slovenlySpeechReplacementMap.put("you", "ya");
        slovenlySpeechReplacementMap.put("Yourself", "Yerself");
        slovenlySpeechReplacementMap.put("yourself", "yerself");
        slovenlySpeechReplacementMap.put("You'd", "You's");
        slovenlySpeechReplacementMap.put("you'd", "you's");
        slovenlySpeechReplacementMap.put("Her", "'Er");
        slovenlySpeechReplacementMap.put("her", "'er");
        slovenlySpeechReplacementMap.put("His", "'Is");
        slovenlySpeechReplacementMap.put("his", "'is");
        slovenlySpeechReplacementMap.put("Going to", "Gonna");
        slovenlySpeechReplacementMap.put("going to", "gonna");
        slovenlySpeechReplacementMap.put("To", "Ta");
        slovenlySpeechReplacementMap.put("to", "ta");
        slovenlySpeechReplacementMap.put("Into", "Inta");
        slovenlySpeechReplacementMap.put("into", "inta");
        slovenlySpeechReplacementMap.put("The", "Da");
        slovenlySpeechReplacementMap.put("the", "da");
        slovenlySpeechReplacementMap.put("Them", "Dem");
        slovenlySpeechReplacementMap.put("them", "dem");
        slovenlySpeechReplacementMap.put("They", "Dey");
        slovenlySpeechReplacementMap.put("they", "dey");
        slovenlySpeechReplacementMap.put("These", "Dese");
        slovenlySpeechReplacementMap.put("these", "dese");
        slovenlySpeechReplacementMap.put("And", "'An");
        slovenlySpeechReplacementMap.put("and", "an'");
        slovenlySpeechReplacementMap.put("Of", "O'");
        slovenlySpeechReplacementMap.put("of", "o'");
        slovenlySpeechReplacementMap.put("Who", "'O");
        slovenlySpeechReplacementMap.put("who", "'o");
        slovenlySpeechReplacementMap.put("Whoever", "'Oever");
        slovenlySpeechReplacementMap.put("whoever", "'oever");
        slovenlySpeechReplacementMap.put("Was", "Were");
        slovenlySpeechReplacementMap.put("was", "were");
        slovenlySpeechReplacementMap.put("What", "Wot");
        slovenlySpeechReplacementMap.put("what", "wot");
        slovenlySpeechReplacementMap.put("Isn't", "Ain't");
        slovenlySpeechReplacementMap.put("isn't", "ain't");
        slovenlySpeechReplacementMap.put("Aren't", "Ain't");
        slovenlySpeechReplacementMap.put("aren't", "ain't");
        slovenlySpeechReplacementMap.put("This one", "This 'un");
        slovenlySpeechReplacementMap.put("this one", "this 'un");
        slovenlySpeechReplacementMap.put("That one", "That 'un");
        slovenlySpeechReplacementMap.put("that one", "that 'un");
        slovenlySpeechReplacementMap.put("Before", "'Afore");
        slovenlySpeechReplacementMap.put("before", "'afore");
        slovenlySpeechReplacementMap.put("Give me", "Gimme");
        slovenlySpeechReplacementMap.put("give me", "gimme");
        slovenlySpeechReplacementMap.put("We're", "We's");
        slovenlySpeechReplacementMap.put("we're", "we's");
        slovenlySpeechReplacementMap.put("So that", "So's");
        slovenlySpeechReplacementMap.put("so that", "so's");
        slovenlySpeechReplacementMap.put("Have not", "'Aven't");
        slovenlySpeechReplacementMap.put("have not", "'aven't");
        slovenlySpeechReplacementMap.put("Haven't", "'Aven't");
        slovenlySpeechReplacementMap.put("haven't", "'aven't");
        slovenlySpeechReplacementMap.put("Have", "'Ave");
        slovenlySpeechReplacementMap.put("have", "'ave");
        slovenlySpeechReplacementMap.put("Here", "'Ere");
        slovenlySpeechReplacementMap.put("here", "'ere");
        slovenlySpeechReplacementMap.put("My", "Me");
        slovenlySpeechReplacementMap.put("my", "me");
        slovenlySpeechReplacementMap.put("Myself", "Meself");
        slovenlySpeechReplacementMap.put("myself", "meself");
        slovenlySpeechReplacementMap.put("That", "Dat");
        slovenlySpeechReplacementMap.put("that", "dat");
        slovenlySpeechReplacementMap.put("Some", "Sum");
        slovenlySpeechReplacementMap.put("some", "sum");
        slovenlySpeechReplacementMap.put("This", "Dis");
        slovenlySpeechReplacementMap.put("this", "dis");
        slovenlySpeechReplacementMap.put("For", "Fer");
        slovenlySpeechReplacementMap.put("for", "fer");
        slovenlySpeechReplacementMap.put("Very", "Real");
        slovenlySpeechReplacementMap.put("very", "real");
        slovenlySpeechReplacementMap.put("Yes", "Yeah");
        slovenlySpeechReplacementMap.put("yes", "yeah");
        slovenlySpeechReplacementMap.put("Hurry", "'Urry");
        slovenlySpeechReplacementMap.put("hurry", "'urry");
        slovenlySpeechReplacementMap.put("Doesn't", "Don't");
        slovenlySpeechReplacementMap.put("doesn't", "don't");
        slovenlySpeechReplacementMap.put("Because", "'Cause");
        slovenlySpeechReplacementMap.put("because", "'cause");
        errorLogMap = new HashMap<String, List<String>>();
    }

    public static class Value<T, S> {
        private T key;
        private S value;

        public Value(T key, S value) {
            this.key = key;
            this.value = value;
        }

        public T getKey() {
            return this.key;
        }

        public S getValue() {
            return this.value;
        }
    }
}

