/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.utils.colours;

import com.lilithsthrone.utils.Util;
import javafx.scene.paint.Color;

public enum BaseColour {
    WHITE(Util.newColour(0xFFFFFF), Util.newColour(0x636363)),
    SILVER(Util.newColour(0xF3F3F3), Util.newColour(0x636363)),
    PLATINUM(Util.newColour(15001058), Util.newColour(15001058)),
    ROSE(Util.newColour(15450879), Util.newColour(12058854)),
    INDIGO(Util.newColour(9864172), Util.newColour(9864172)),
    LILAC(Util.newColour(13148872), Util.newColour(13148872)),
    LILAC_LIGHT(Util.newColour(14471423), Util.newColour(14471423)),
    PURPLE_DARK(Util.newColour(9653503), Util.newColour(0x6000D6)),
    PURPLE(Util.newColour(12157183), Util.newColour(9715199)),
    PURPLE_LIGHT(Util.newColour(14323711), Util.newColour(12931839)),
    PINK_SALMON(Util.newColour(0xFF99C9), Util.newColour(16734117)),
    PINK(Util.newColour(16739290), Util.newColour(16715715)),
    PINK_LIGHT(Util.newColour(16099583), Util.newColour(13575870)),
    PINK_PALE(Util.newColour(16111359), Util.newColour(14200290)),
    PINK_DEEP(Util.newColour(0xFF33CC), Util.newColour(0xFF33CC)),
    MAGENTA(Util.newColour(16716914), Util.newColour(16716914)),
    CRIMSON(Util.newColour(16726109), Util.newColour(16726109)),
    RED(Util.newColour(15359350), Util.newColour(14490944)),
    RED_DARK(Util.newColour(10884673), Util.newColour(9830418)),
    RED_LIGHT(Util.newColour(15635878), Util.newColour(15291247)),
    ROSE_GOLD(Util.newColour(15188411), Util.newColour(15188411)),
    TAN(Util.newColour(15582353), Util.newColour(14454062)),
    BROWN_LIGHT(Util.newColour(14268067), Util.newColour(12418651)),
    BROWN(Util.newColour(13673355), Util.newColour(11891018)),
    BROWN_DARK(Util.newColour(10450779), Util.newColour(7887173)),
    AUBURN(Util.newColour(13592148), Util.newColour(12273973)),
    ORANGE_LIGHT(Util.newColour(16756108), Util.newColour(16413759)),
    ORANGE(Util.newColour(16750960), Util.newColour(16402176)),
    ORANGE_DARK(Util.newColour(14253147), Util.newColour(14253147)),
    AMBER(Util.newColour(16762194), Util.newColour(12418560)),
    GINGER(Util.newColour(16748871), Util.newColour(0xF06000)),
    COPPER(Util.newColour(13922091), Util.newColour(12149287)),
    BRONZE(Util.newColour(13467442), Util.newColour(13467442)),
    BRASS(Util.newColour(11240215), Util.newColour(11240215)),
    GOLD(Util.newColour(0xFFCC00), Util.newColour(13411072)),
    YELLOW(Util.newColour(15527003), Util.newColour(12896000)),
    YELLOW_LIGHT(Util.newColour(16316601), Util.newColour(12690479)),
    YELLOW_PALE(Util.newColour(16316633), Util.newColour(14269249)),
    GREEN_LIME(Util.newColour(11852167), Util.newColour(8633916)),
    GREEN_LIGHT(Util.newColour(9433023), Util.newColour(1948011)),
    GREEN(Util.newColour(5757822), Util.newColour(878651)),
    GREEN_DARK(Util.newColour(2135878), Util.newColour(2135878)),
    AQUA(Util.newColour(0x61FFFF), Util.newColour(39321)),
    TEAL(Util.newColour(7126193), Util.newColour(4428681)),
    PERIWINKLE(Util.newColour(0xCCCCFF), Util.newColour(0xCCCCFF)),
    BLUE_LIGHT(Util.newColour(10087423), Util.newColour(42961)),
    BLUE(Util.newColour(380415), Util.newColour(25210)),
    BLUE_DARK(Util.newColour(37055), Util.newColour(11843)),
    BLUE_STEEL(Util.newColour(10991570), Util.newColour(5665188)),
    BLUE_PALE(Util.newColour(14285055), Util.newColour(6929617)),
    GREY_LIGHT(Util.newColour(0xD3D3D3), Util.newColour(0x999999)),
    GREY(Util.newColour(0xB3B3B3), Util.newColour(0x777777)),
    GREY_DARK(Util.newColour(0x999999), Util.newColour(0x515151)),
    PITCH_BLACK(Util.newColour(0x222222), Util.newColour(0x222222)),
    BLACK(Util.newColour(0x777777), Util.newColour(0x1F1F1F));

    private Color colour;
    private Color lightColour;

    private BaseColour(Color colour, Color lightColour) {
        this.colour = colour;
        this.lightColour = lightColour;
    }

    public Color getColour() {
        return this.colour;
    }

    public Color getLightColour() {
        return this.lightColour;
    }

    public String toWebHexString() {
        return this.getColour().toString().substring(2, 8);
    }

    public String[] getShades() {
        String[] shadesString = new String[5];
        float luminosity = -0.3f;
        int red = Integer.parseInt(this.colour.toString().substring(2, 4), 16);
        int gre = Integer.parseInt(this.colour.toString().substring(4, 6), 16);
        int blu = Integer.parseInt(this.colour.toString().substring(6, 8), 16);
        for (int i = 0; i < 5; ++i) {
            int r = red + (int)((float)red * ((float)i * 0.15f + luminosity));
            r = Math.max(Math.min(r, 255), 0);
            int g = gre + (int)((float)gre * ((float)i * 0.15f + luminosity));
            g = Math.max(Math.min(g, 255), 0);
            int b = blu + (int)((float)blu * ((float)i * 0.15f + luminosity));
            b = Math.max(Math.min(b, 255), 0);
            shadesString[i] = String.format("#%02X%02X%02X", r, g, b);
        }
        return shadesString;
    }
}

