/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.utils.colours;

import com.lilithsthrone.controller.xmlParsing.Element;
import com.lilithsthrone.game.PropertyValue;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.utils.Util;
import com.lilithsthrone.utils.colours.BaseColour;
import com.lilithsthrone.utils.colours.ColourTag;
import com.lilithsthrone.utils.colours.PresetColour;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javafx.scene.paint.Color;
import org.w3c.dom.Document;

public class Colour {
    private boolean mod;
    private boolean fromExternalFile;
    private boolean metallic;
    private Color colour;
    private Color lightColour;
    private Color coveringIconColour;
    private String name;
    private List<String> formattingNames;
    private Colour colourLinkLighter = null;
    private Colour colourLinkDarker = null;
    private List<ColourTag> tags;

    public Colour(Color colour) {
        this.metallic = false;
        this.colour = colour;
        this.lightColour = colour;
        this.coveringIconColour = null;
        this.name = "";
        this.tags = null;
    }

    public Colour(boolean metallic, Color colour, Color lightColour, String name) {
        this.mod = false;
        this.fromExternalFile = false;
        this.metallic = metallic;
        this.colour = colour;
        this.lightColour = lightColour;
        this.coveringIconColour = null;
        this.name = name;
        this.tags = null;
    }

    public Colour(boolean metallic, BaseColour colour, String name) {
        this.mod = false;
        this.fromExternalFile = false;
        this.metallic = metallic;
        this.colour = colour.getColour();
        this.lightColour = colour.getLightColour();
        this.coveringIconColour = null;
        this.name = name;
        this.tags = null;
    }

    public Colour(boolean metallic, Color colour, Color lightColour, String name, List<String> formattingNames) {
        this.mod = false;
        this.fromExternalFile = false;
        this.metallic = metallic;
        this.colour = colour;
        this.lightColour = lightColour;
        this.coveringIconColour = null;
        this.name = name;
        this.formattingNames = formattingNames;
        this.tags = null;
    }

    public Colour(boolean metallic, BaseColour colour, String name, List<String> formattingNames) {
        this.mod = false;
        this.fromExternalFile = false;
        this.metallic = metallic;
        this.colour = colour.getColour();
        this.lightColour = colour.getLightColour();
        this.coveringIconColour = null;
        this.name = name;
        this.formattingNames = formattingNames;
        this.tags = null;
    }

    public Colour(File XMLFile, String author, boolean mod) {
        if (XMLFile.exists()) {
            try {
                Document doc = Main.getDocBuilder().parse(XMLFile);
                doc.getDocumentElement().normalize();
                Element coreElement = Element.getDocumentRootElement(XMLFile);
                this.mod = mod;
                this.fromExternalFile = true;
                this.metallic = Boolean.valueOf(coreElement.getMandatoryFirstOf("metallic").getTextContent());
                this.name = coreElement.getMandatoryFirstOf("name").getTextContent();
                this.colour = Util.newColour(Integer.parseInt(coreElement.getMandatoryFirstOf("colour").getTextContent(), 16));
                this.lightColour = Util.newColour(Integer.parseInt(coreElement.getMandatoryFirstOf("lightColour").getTextContent(), 16));
                if (coreElement.getOptionalFirstOf("coveringIconColour").isPresent() && !coreElement.getMandatoryFirstOf("coveringIconColour").getTextContent().isEmpty()) {
                    try {
                        this.coveringIconColour = Util.newColour(Integer.parseInt(coreElement.getMandatoryFirstOf("coveringIconColour").getTextContent(), 16));
                    }
                    catch (Exception ex) {
                        System.err.println("coveringIconColour failure in '" + this.name + "':\n" + ex.getMessage());
                    }
                }
                this.formattingNames = new ArrayList<String>();
                if (coreElement.getOptionalFirstOf("formattingNames").isPresent()) {
                    for (Element e : coreElement.getMandatoryFirstOf("formattingNames").getAllOf("name")) {
                        this.formattingNames.add(e.getTextContent());
                    }
                }
                this.tags = new ArrayList<ColourTag>();
                if (coreElement.getOptionalFirstOf("tags").isPresent()) {
                    for (Element e : coreElement.getMandatoryFirstOf("tags").getAllOf("tag")) {
                        this.tags.add(ColourTag.valueOf(e.getTextContent()));
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                System.err.println("Colour was unable to be loaded from file! (" + XMLFile.getName() + ")\n" + String.valueOf(ex));
            }
        }
    }

    public boolean isMod() {
        return this.mod;
    }

    public boolean isFromExternalFile() {
        return this.fromExternalFile;
    }

    public String toWebHexString() {
        return "#" + this.getColor().toString().substring(2, 8);
    }

    public String toRGBA(double alpha) {
        Color color = Color.web(this.toWebHexString());
        return "rgba(" + (int)(color.getRed() * 255.0) + ", " + (int)(color.getGreen() * 255.0) + ",  " + (int)(color.getBlue() * 255.0) + ", " + alpha + ")";
    }

    public String getCoveringIconColour() {
        if (this.coveringIconColour != null) {
            return "#" + this.coveringIconColour.toString().substring(2, 8);
        }
        return "#" + this.colour.toString().substring(2, 8);
    }

    public Color getColor() {
        if (Main.getProperties() != null) {
            if (Main.getProperties().hasValue(PropertyValue.lightTheme)) {
                return this.lightColour;
            }
            return this.colour;
        }
        return this.colour;
    }

    public boolean isDesaturated() {
        return false;
    }

    public boolean isMetallic() {
        return this.metallic;
    }

    public List<String> getRainbowColours() {
        return null;
    }

    public boolean isRainbow() {
        return this.getRainbowColours() != null;
    }

    public String getRainbowDiv(int rainbowPixels) {
        if (this.getRainbowColours() == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("repeating-linear-gradient(135deg,");
        int i = 0;
        for (String s : this.getRainbowColours()) {
            sb.append(" " + s + " " + i * rainbowPixels + "px, " + s + " " + (i + 1) * rainbowPixels + "px,");
            ++i;
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(");");
        return sb.toString();
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        if (PresetColour.getAllPresetColours().contains(this)) {
            return PresetColour.getIdFromColour(this);
        }
        return this.toWebHexString().replaceAll("#", "");
    }

    public String toString() {
        System.err.println("Warning! Colour.toString() was called instead of getId()");
        return this.getId();
    }

    public Colour setLinkedColourDarker(Colour colourLinkDarker) {
        this.colourLinkDarker = colourLinkDarker;
        colourLinkDarker.colourLinkLighter = this;
        return this;
    }

    public Colour getLinkedColourDarker() {
        return this.colourLinkDarker;
    }

    public List<Colour> getDarkerLinkedColours() {
        ArrayList<Colour> darkerList = new ArrayList<Colour>();
        Colour darker = this.getLinkedColourDarker();
        if (darker == null) {
            return darkerList;
        }
        darkerList.add(darker);
        while (darker.getLinkedColourDarker() != null) {
            darker = darker.getLinkedColourDarker();
            darkerList.add(darker);
        }
        Collections.reverse(darkerList);
        return darkerList;
    }

    public Colour setLinkedColourLighter(Colour colourLinkLighter) {
        this.colourLinkLighter = colourLinkLighter;
        colourLinkLighter.colourLinkDarker = this;
        return this;
    }

    public Colour getLinkedColourLighter() {
        return this.colourLinkLighter;
    }

    public List<Colour> getLighterLinkedColours() {
        ArrayList<Colour> lighterList = new ArrayList<Colour>();
        Colour lighter = this.getLinkedColourLighter();
        if (lighter == null) {
            return lighterList;
        }
        lighterList.add(lighter);
        while (lighter.getLinkedColourLighter() != null) {
            lighter = lighter.getLinkedColourLighter();
            lighterList.add(lighter);
        }
        return lighterList;
    }

    public String[] getShades() {
        return this.getShades(5);
    }

    public String[] getShades(int shadesCount) {
        return this.getShades(shadesCount, false, 1.0f);
    }

    public String[] getShadesRgbaFormat(float opacity) {
        return this.getShades(5, true, opacity);
    }

    public String[] getShadesRgbaFormat(int shadesCount, float opacity) {
        return this.getShades(shadesCount, true, opacity);
    }

    private String[] getShades(int shadesCount, boolean rgba, float opacity) {
        String[] shadesString = new String[shadesCount];
        float luminosity = -0.5f;
        float increment = Math.abs(luminosity) * 2.0f / (float)(shadesCount - 1);
        int red = Integer.parseInt(this.colour.toString().substring(2, 4), 16);
        int gre = Integer.parseInt(this.colour.toString().substring(4, 6), 16);
        int blu = Integer.parseInt(this.colour.toString().substring(6, 8), 16);
        for (int i = 0; i < shadesCount; ++i) {
            int r = red + (int)((float)red * ((float)i * increment + luminosity));
            r = Math.max(Math.min(r, 255), 0);
            int g = gre + (int)((float)gre * ((float)i * increment + luminosity));
            g = Math.max(Math.min(g, 255), 0);
            int b = blu + (int)((float)blu * ((float)i * increment + luminosity));
            b = Math.max(Math.min(b, 255), 0);
            shadesString[i] = rgba ? "rgba(" + r + "," + g + "," + b + ", " + opacity + ")" : String.format("#%02X%02X%02X", r, g, b);
        }
        return shadesString;
    }

    public List<String> getFormattingNames() {
        return this.formattingNames;
    }

    public List<ColourTag> getTags() {
        if (this.tags == null) {
            return new ArrayList<ColourTag>();
        }
        return this.tags;
    }

    public boolean isOneOf(Colour ... values) {
        return Arrays.asList(values).contains(this);
    }

    public Colour getDesaturatedVersion() {
        double desaturationValue = 0.5;
        double brightnessValue = 0.9;
        final String id = this.getId();
        return new Colour(this.isMetallic(), this.colour.deriveColor(0.0, desaturationValue, brightnessValue, 1.0), this.lightColour.deriveColor(0.0, desaturationValue, brightnessValue, 1.0), "\u6697" + this.getName()){

            @Override
            public String getId() {
                return id + "_DESAT";
            }

            @Override
            public boolean isDesaturated() {
                return true;
            }
        };
    }
}

