/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.utils.comparators;

import com.lilithsthrone.game.inventory.enchanting.AbstractItemEffectType;
import com.lilithsthrone.game.inventory.enchanting.ItemEffect;
import com.lilithsthrone.game.inventory.enchanting.ItemEffectType;
import java.util.Comparator;

public class ItemEffectComparator
implements Comparator<ItemEffect> {
    @Override
    public int compare(ItemEffect first, ItemEffect second) {
        boolean secondTypeImportant;
        AbstractItemEffectType firstType = first.getItemEffectType();
        boolean firstTypeImportant = firstType == ItemEffectType.CLOTHING || firstType == ItemEffectType.WEAPON;
        AbstractItemEffectType secondType = second.getItemEffectType();
        boolean bl = secondTypeImportant = secondType == ItemEffectType.CLOTHING || secondType == ItemEffectType.WEAPON;
        if (firstTypeImportant && !secondTypeImportant) {
            return 1;
        }
        if (!firstTypeImportant && secondTypeImportant) {
            return -1;
        }
        int primaryComparison = first.getPrimaryModifier().compareTo(second.getPrimaryModifier());
        if (primaryComparison != 0) {
            return primaryComparison;
        }
        int secondaryComparison = first.getSecondaryModifier().compareTo(second.getSecondaryModifier());
        if (secondaryComparison != 0) {
            return secondaryComparison;
        }
        int potencyComparison = first.getPotency().compareTo(second.getPotency());
        if (potencyComparison != 0) {
            return potencyComparison;
        }
        int limitComparison = first.getLimit() - second.getLimit();
        if (potencyComparison != 0) {
            return limitComparison;
        }
        return 0;
    }
}

