/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.utils.time;

import com.lilithsthrone.utils.time.DayPeriod;
import com.lilithsthrone.utils.time.SolarElevationAngle;
import java.time.LocalDateTime;
import java.time.temporal.ChronoField;

public class DateAndTime {
    private static final boolean DEBUG = false;

    private static double sin(double deg) {
        return Math.sin(Math.toRadians(deg));
    }

    private static double cos(double deg) {
        return Math.cos(Math.toRadians(deg));
    }

    private static double asin(double x) {
        return Math.toDegrees(Math.asin(x));
    }

    private static double acos(double x) {
        return Math.toDegrees(Math.acos(x));
    }

    private static double julianDate(LocalDateTime date) {
        int years = Math.abs(-4713 - date.getYear()) - 1;
        int leapYearSwitch = 6295;
        int leapYears = 0;
        if (years > leapYearSwitch) {
            int extraYears = years % leapYearSwitch;
            leapYears = 1 + (leapYearSwitch - 1) / 4 + extraYears / 4 - extraYears / 100 + extraYears / 400;
        } else {
            leapYears = years / 4;
        }
        double day = date.get(ChronoField.DAY_OF_YEAR);
        double julianDate = (double)years * 365.0 + day + (double)leapYears - 10.0 - 0.5;
        return julianDate;
    }

    private static double julianDay(LocalDateTime date) {
        return DateAndTime.julianDate(date) - 2451545.0 + 8.0E-4;
    }

    private static double meanSolarNoon(double julianDay, double longitudeWest) {
        return julianDay - longitudeWest / 360.0;
    }

    private static double solarMeanAnomaly(double meanSolarNoon) {
        return (357.5291 + 0.98560028 * meanSolarNoon) % 360.0;
    }

    private static double equationOfTheCenter(double solarMeanAnomaly) {
        return 1.9148 * DateAndTime.sin(solarMeanAnomaly) + 0.02 * DateAndTime.sin(2.0 * solarMeanAnomaly) + 3.0E-4 * DateAndTime.sin(3.0 * solarMeanAnomaly);
    }

    private static double eclipticLongitude(double solarMeanAnomaly, double equationOfTheCenter) {
        return (solarMeanAnomaly + equationOfTheCenter + 180.0 + 102.9372) % 360.0;
    }

    private static double solarTransit(double meanSolarNoon, double solarMeanAnomaly, double eclipticLongitude) {
        return 2451545.0 + meanSolarNoon + 0.0053 * DateAndTime.sin(solarMeanAnomaly) - 0.0069 * DateAndTime.sin(2.0 * eclipticLongitude);
    }

    private static double declinationOfTheSun(double eclipticLongitude) {
        return DateAndTime.asin(DateAndTime.sin(eclipticLongitude) * DateAndTime.sin(23.44));
    }

    private static double hourAngle(double declinationOfTheSun, SolarElevationAngle angle, double latitude) {
        return DateAndTime.acos((DateAndTime.sin(angle.getAngle()) - DateAndTime.sin(latitude) * DateAndTime.sin(declinationOfTheSun)) / (DateAndTime.cos(latitude) * DateAndTime.cos(declinationOfTheSun)));
    }

    private static double sunrise(double solarTransit, double hourAngle) {
        return solarTransit - hourAngle / 360.0;
    }

    private static double sunset(double solarTransit, double hourAngle) {
        return solarTransit + hourAngle / 360.0;
    }

    public static LocalDateTime julianDayToDate(double julianDate) {
        double Q = julianDate;
        int Z = (int)Q;
        int W = (int)(((double)Z - 1867216.25) / 36524.25);
        int X = W / 4;
        int A = Z + 1 + W - X;
        int B = A + 1524;
        int C = (int)(((double)B - 122.1) / 365.25);
        int D = (int)(365.25 * (double)C);
        int E = (int)((double)(B - D) / 30.6001);
        int F = (int)(30.6001 * (double)E);
        int day = (int)((double)(B - D - F) + (Q - (double)Z));
        int month = E - 1 <= 12 ? E - 1 : E - 13;
        int year = month == 1 || month == 2 ? C - 4715 : C - 4716;
        double dayFraction = julianDate % 1.0;
        int hours = Math.min(23, (int)(dayFraction * 24.0));
        int minutes = Math.min(59, (int)((dayFraction * 24.0 - (double)hours) * 60.0));
        int seconds = Math.min(59, (int)(dayFraction * 24.0 * 3600.0 - (double)(hours * 3600 + minutes * 60) + 0.5));
        try {
            return LocalDateTime.of(year, month, day, hours, minutes, seconds).plusDays(1L);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static LocalDateTime[] getTimeOfSolarElevationChange(LocalDateTime date, SolarElevationAngle angle, double latitude, double longitudeWest) {
        double sunset;
        LocalDateTime sunsetLDT;
        LocalDateTime sunriseLDT;
        double declinationOfTheSun;
        double hourAngle;
        double equationOfTheCenter;
        double eclipticLongitude;
        double solarMeanAnomaly;
        double julianDay = DateAndTime.julianDay(date);
        double meanSolarNoon = DateAndTime.meanSolarNoon(julianDay, longitudeWest);
        double solarTransit = DateAndTime.solarTransit(meanSolarNoon, solarMeanAnomaly = DateAndTime.solarMeanAnomaly(meanSolarNoon), eclipticLongitude = DateAndTime.eclipticLongitude(solarMeanAnomaly, equationOfTheCenter = DateAndTime.equationOfTheCenter(solarMeanAnomaly)));
        double sunrise = DateAndTime.sunrise(solarTransit, hourAngle = DateAndTime.hourAngle(declinationOfTheSun = DateAndTime.declinationOfTheSun(eclipticLongitude), angle, latitude));
        LocalDateTime localDateTime = sunriseLDT = Double.isNaN(sunrise) ? null : DateAndTime.julianDayToDate(sunrise);
        if (sunriseLDT != null) {
            sunriseLDT = LocalDateTime.of(date.getYear(), date.getMonth(), date.getDayOfMonth(), sunriseLDT.getHour(), sunriseLDT.getMinute(), sunriseLDT.getSecond(), sunriseLDT.getNano());
        }
        LocalDateTime localDateTime2 = sunsetLDT = Double.isNaN(sunset = DateAndTime.sunset(solarTransit, hourAngle)) ? null : DateAndTime.julianDayToDate(sunset);
        if (sunsetLDT != null) {
            sunsetLDT = LocalDateTime.of(date.getYear(), date.getMonth(), date.getDayOfMonth(), sunsetLDT.getHour(), sunsetLDT.getMinute(), sunsetLDT.getSecond(), sunsetLDT.getNano());
        }
        return new LocalDateTime[]{sunriseLDT, sunsetLDT};
    }

    public static DayPeriod getDayPeriod(LocalDateTime date, double latitude, double longitudeWest) {
        LocalDateTime[] times = DateAndTime.getTimeOfSolarElevationChange(date, SolarElevationAngle.SUN_ALTITUDE_SUNRISE_SUNSET, latitude, longitudeWest);
        if (times[0] == null || date.isAfter(times[0]) && date.isBefore(times[1])) {
            return DayPeriod.DAY;
        }
        times = DateAndTime.getTimeOfSolarElevationChange(date, SolarElevationAngle.SUN_ALTITUDE_CIVIL_TWILIGHT, latitude, longitudeWest);
        if (times[0] == null || date.isAfter(times[0]) && date.isBefore(times[1])) {
            return DayPeriod.CIVIL_TWILIGHT;
        }
        times = DateAndTime.getTimeOfSolarElevationChange(date, SolarElevationAngle.SUN_ALTITUDE_NAUTICAL_TWILIGHT, latitude, longitudeWest);
        if (times[0] == null || date.isAfter(times[0]) && date.isBefore(times[1])) {
            return DayPeriod.NAUTICAL_TWILIGHT;
        }
        times = DateAndTime.getTimeOfSolarElevationChange(date, SolarElevationAngle.SUN_ALTITUDE_ASTRONOMICAL_TWILIGHT, latitude, longitudeWest);
        if (times[0] == null || date.isAfter(times[0]) && date.isBefore(times[1])) {
            return DayPeriod.ASTRONOMICAL_TWILIGHT;
        }
        return DayPeriod.NIGHT;
    }
}

