/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.world;

import com.lilithsthrone.controller.xmlParsing.Element;
import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.npc.misc.NPCOffspring;
import com.lilithsthrone.game.dialogue.utils.ParserTag;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.utils.Util;
import com.lilithsthrone.utils.colours.Colour;
import com.lilithsthrone.utils.colours.PresetColour;
import com.lilithsthrone.world.TeleportPermissions;
import com.lilithsthrone.world.WorldRegion;
import com.lilithsthrone.world.WorldType;
import com.lilithsthrone.world.places.AbstractPlaceType;
import com.lilithsthrone.world.places.PlaceType;
import java.awt.Color;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Document;

public abstract class AbstractWorldType {
    private boolean mod;
    private boolean fromExternalFile;
    private String author;
    private WorldRegion worldRegion;
    private String name;
    private String fileLocation;
    private Colour colour;
    private String sexBlockedReason;
    private boolean usesFile;
    private boolean loiteringEnabled;
    private boolean flightEnabled;
    private boolean discoveredOnStart;
    private boolean revealedOnStart;
    private boolean furniturePresent;
    private String deskName;
    private boolean wallsPresent;
    private String wallName;
    private int majorAreaIndex;
    private String offspringTextFilePath;
    private AbstractPlaceType globalMapLocation;
    private AbstractPlaceType standardPlace;
    private AbstractPlaceType entryFromGlobalMapLocation;
    private TeleportPermissions teleportPermissions;
    private Map<Color, AbstractPlaceType> placesMap;

    public AbstractWorldType(WorldRegion worldRegion, String name, Colour colour, boolean loiteringEnabled, boolean flightEnabled, TeleportPermissions teleportPermissions, String fileLocation, AbstractPlaceType globalMapLocation, AbstractPlaceType entryFromGlobalMapLocation, Map<Color, AbstractPlaceType> placesMap) {
        this.worldRegion = worldRegion;
        this.name = name;
        this.colour = colour;
        this.standardPlace = null;
        this.sexBlockedReason = "";
        this.globalMapLocation = globalMapLocation;
        this.entryFromGlobalMapLocation = entryFromGlobalMapLocation;
        this.loiteringEnabled = loiteringEnabled;
        this.flightEnabled = flightEnabled;
        this.discoveredOnStart = false;
        this.revealedOnStart = false;
        this.furniturePresent = false;
        this.deskName = "\u684c\u5b50";
        this.wallsPresent = true;
        this.wallName = "\u5899\u58c1";
        this.offspringTextFilePath = "characters/offspring/dominionAlleyway";
        this.teleportPermissions = teleportPermissions;
        this.fileLocation = fileLocation;
        this.usesFile = true;
        this.placesMap = placesMap;
        this.majorAreaIndex = 0;
    }

    public AbstractWorldType(File XMLFile, String author, boolean mod) {
        if (XMLFile.exists()) {
            try {
                Document doc = Main.getDocBuilder().parse(XMLFile);
                doc.getDocumentElement().normalize();
                Element coreElement = Element.getDocumentRootElement(XMLFile);
                this.fileLocation = XMLFile.getAbsolutePath().replace("worldType.xml", "map.png");
                this.mod = mod;
                this.fromExternalFile = true;
                this.author = author;
                this.worldRegion = WorldRegion.valueOf(coreElement.getMandatoryFirstOf("worldRegion").getTextContent());
                this.name = coreElement.getMandatoryFirstOf("name").getTextContent();
                String colourId = coreElement.getMandatoryFirstOf("colour").getTextContent();
                this.colour = colourId.startsWith("#") ? new Colour(false, Util.newColour(colourId), Util.newColour(colourId), "") : PresetColour.getColourFromId(colourId);
                this.sexBlockedReason = coreElement.getOptionalFirstOf("sexBlockedReason").isPresent() ? coreElement.getMandatoryFirstOf("sexBlockedReason").getTextContent() : null;
                this.usesFile = true;
                this.furniturePresent = false;
                this.deskName = "\u684c\u5b50";
                if (coreElement.getOptionalFirstOf("furniturePresent").isPresent()) {
                    this.furniturePresent = Boolean.valueOf(coreElement.getMandatoryFirstOf("furniturePresent").getTextContent().trim());
                    if (!coreElement.getMandatoryFirstOf("furniturePresent").getAttribute("deskName").isEmpty()) {
                        this.deskName = coreElement.getMandatoryFirstOf("furniturePresent").getAttribute("deskName");
                    }
                }
                this.wallsPresent = false;
                this.wallName = "\u5899\u58c1";
                if (coreElement.getOptionalFirstOf("wallsPresent").isPresent()) {
                    this.wallsPresent = Boolean.valueOf(coreElement.getMandatoryFirstOf("wallsPresent").getTextContent().trim());
                    if (!coreElement.getMandatoryFirstOf("wallsPresent").getAttribute("wallName").isEmpty()) {
                        this.wallName = coreElement.getMandatoryFirstOf("wallsPresent").getAttribute("wallName");
                    }
                }
                this.majorAreaIndex = coreElement.getOptionalFirstOf("majorAreaIndex").isPresent() ? Integer.valueOf(coreElement.getMandatoryFirstOf("majorAreaIndex").getTextContent().trim()) : 0;
                this.loiteringEnabled = Boolean.valueOf(coreElement.getMandatoryFirstOf("loiteringEnabled").getTextContent().trim());
                this.flightEnabled = Boolean.valueOf(coreElement.getMandatoryFirstOf("flightEnabled").getTextContent().trim());
                this.discoveredOnStart = Boolean.valueOf(coreElement.getMandatoryFirstOf("visibleFromStart").getTextContent().trim());
                this.revealedOnStart = Boolean.valueOf(coreElement.getMandatoryFirstOf("fullyRevealedFromStart").getTextContent().trim());
                this.globalMapLocation = PlaceType.getPlaceTypeFromId(coreElement.getMandatoryFirstOf("globalMapLocation").getTextContent().trim());
                this.standardPlace = PlaceType.getPlaceTypeFromId(coreElement.getMandatoryFirstOf("standardPlace").getTextContent().trim());
                this.entryFromGlobalMapLocation = PlaceType.getPlaceTypeFromId(coreElement.getMandatoryFirstOf("entryFromGlobalMapLocation").getTextContent().trim());
                this.teleportPermissions = TeleportPermissions.valueOf(coreElement.getMandatoryFirstOf("teleportPermissions").getTextContent());
                this.placesMap = new HashMap<Color, AbstractPlaceType>();
                for (Element e : coreElement.getMandatoryFirstOf("places").getAllOf("place")) {
                    try {
                        this.placesMap.put(Color.decode(e.getAttribute("colour")), PlaceType.getPlaceTypeFromId(e.getTextContent()));
                    }
                    catch (Exception ex) {
                        System.err.println("WorldType loading error in '" + XMLFile.getName() + "': PlaceType '" + e.getTextContent() + "' not recognised! (Not added)");
                    }
                }
                this.offspringTextFilePath = "characters/offspring/dominionAlleyway";
                if (coreElement.getOptionalFirstOf("offspringTextFilePath").isPresent() && !coreElement.getMandatoryFirstOf("offspringTextFilePath").getTextContent().isEmpty()) {
                    this.offspringTextFilePath = coreElement.getMandatoryFirstOf("offspringTextFilePath").getTextContent();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                System.err.println("WorldType was unable to be loaded from file! (" + XMLFile.getName() + ")\n" + String.valueOf(ex));
            }
        }
    }

    public boolean equals(Object o) {
        return super.equals(o) && o instanceof AbstractWorldType && ((AbstractWorldType)o).getPlacesMap().equals(this.getPlacesMap()) && ((AbstractWorldType)o).getFileLocation().equals(this.getFileLocation());
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.getFileLocation().hashCode();
        result = 31 * result + this.getPlacesMap().hashCode();
        return result;
    }

    public String toString() {
        System.err.println("Warning: AbstractWorldType's toString() method is being called!");
        return super.toString();
    }

    public String getOffspringTextFilePath(NPCOffspring o) {
        return this.offspringTextFilePath;
    }

    public boolean isMod() {
        return this.mod;
    }

    public boolean isFromExternalFile() {
        return this.fromExternalFile;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getId() {
        return WorldType.getIdFromWorldType(this);
    }

    public WorldRegion getWorldRegion() {
        return this.worldRegion;
    }

    public String getName() {
        return this.name;
    }

    public Colour getColour() {
        return this.colour;
    }

    public boolean isLoiteringEnabled() {
        return this.loiteringEnabled;
    }

    public boolean isDiscoveredOnStart() {
        return this.discoveredOnStart;
    }

    public boolean isRevealedOnStart() {
        return this.revealedOnStart;
    }

    public AbstractPlaceType getStandardPlace() {
        return this.standardPlace;
    }

    public AbstractPlaceType getGlobalMapLocation() {
        return this.globalMapLocation;
    }

    public AbstractPlaceType getEntryFromGlobalMapLocation() {
        return this.entryFromGlobalMapLocation;
    }

    public String getFileLocation() {
        return this.fileLocation;
    }

    public boolean isUsesFile() {
        return this.usesFile;
    }

    public Map<Color, AbstractPlaceType> getPlacesMap() {
        return this.placesMap;
    }

    public TeleportPermissions getTeleportPermissions() {
        return this.teleportPermissions;
    }

    public boolean isFlightEnabled() {
        return this.flightEnabled;
    }

    public boolean isSexBlocked(GameCharacter character) {
        return this.getSexBlockedReason(character) != null && !this.getSexBlockedReason(character).isEmpty();
    }

    public String getSexBlockedReason(GameCharacter character) {
        if (this.isFromExternalFile() && this.sexBlockedReason != null) {
            return UtilText.parse(character, this.sexBlockedReason, new ParserTag[0]);
        }
        return this.sexBlockedReason;
    }

    public boolean isFurniturePresent() {
        return this.furniturePresent;
    }

    public String getDeskName() {
        return this.deskName;
    }

    public boolean isWallsPresent() {
        return this.wallsPresent;
    }

    public String getWallName() {
        return this.wallName;
    }

    public int getMajorAreaIndex() {
        if (this.majorAreaIndex <= 0) {
            return Integer.MAX_VALUE;
        }
        return this.majorAreaIndex;
    }

    public boolean isMajorArea() {
        return this.getMajorAreaIndex() > 0 && this.getMajorAreaIndex() != Integer.MAX_VALUE;
    }
}

