/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.world;

import com.lilithsthrone.controller.xmlParsing.XMLUtil;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.utils.Util;
import com.lilithsthrone.utils.Vector2i;
import com.lilithsthrone.utils.XMLSaving;
import com.lilithsthrone.world.AbstractWorldType;
import com.lilithsthrone.world.Cell;
import com.lilithsthrone.world.WorldType;
import com.lilithsthrone.world.places.AbstractPlaceType;
import com.lilithsthrone.world.places.AbstractPlaceUpgrade;
import com.lilithsthrone.world.places.PlaceType;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class World
implements XMLSaving {
    public final int WORLD_WIDTH;
    public final int WORLD_HEIGHT;
    public static final int CELL_SIZE = 64;
    private Cell[][] grid;
    private AbstractWorldType worldType;

    public World(int worldWidth, int worldHeight, Cell[][] grid, AbstractWorldType worldType) {
        this.WORLD_WIDTH = worldWidth;
        this.WORLD_HEIGHT = worldHeight;
        this.grid = grid;
        this.worldType = worldType;
    }

    @Override
    public Element saveAsXML(Element parentElement, Document doc) {
        Element element = doc.createElement("world");
        parentElement.appendChild(element);
        XMLUtil.addAttribute(doc, element, "worldType", WorldType.getIdFromWorldType(this.getWorldType()));
        XMLUtil.addAttribute(doc, element, "width", String.valueOf(this.WORLD_WIDTH));
        XMLUtil.addAttribute(doc, element, "height", String.valueOf(this.WORLD_HEIGHT));
        Element innerElement = doc.createElement("grid");
        element.appendChild(innerElement);
        for (int i = 0; i < this.grid.length; ++i) {
            for (int j = 0; j < this.grid[0].length; ++j) {
                if (this.grid[i][j].getPlace().getPlaceType().equals(PlaceType.GENERIC_IMPASSABLE)) continue;
                this.grid[i][j].saveAsXML(innerElement, doc);
            }
        }
        return element;
    }

    public static World loadFromXML(Element parentElement, Document doc) {
        AbstractWorldType type = WorldType.EMPTY;
        String worldType = parentElement.getAttribute("worldType");
        type = WorldType.getWorldTypeFromId(worldType);
        int width = Integer.valueOf(parentElement.getAttribute("width"));
        int height = Integer.valueOf(parentElement.getAttribute("height"));
        Cell[][] newGrid = new Cell[width][height];
        for (int i = 0; i < width; ++i) {
            for (int j = 0; j < height; ++j) {
                newGrid[i][j] = new Cell(type, new Vector2i(i, j));
                newGrid[i][j].getPlace().setPlaceType(PlaceType.GENERIC_IMPASSABLE);
            }
        }
        NodeList cells = ((Element)parentElement.getElementsByTagName("grid").item(0)).getElementsByTagName("cell");
        for (int i = 0; i < cells.getLength(); ++i) {
            Cell c;
            Element e = (Element)cells.item(i);
            newGrid[c.getLocation().getX()][c.getLocation().getY()] = c = Cell.loadFromXML(e, doc, type);
        }
        return new World(width, height, newGrid, type);
    }

    public Cell getCell(int i, int j) {
        if (i < 0 || j < 0 || i >= this.WORLD_WIDTH || j >= this.WORLD_HEIGHT) {
            return null;
        }
        return this.grid[i][j];
    }

    public Cell getCell(Vector2i vec) {
        try {
            return this.grid[vec.getX()][vec.getY()];
        }
        catch (Exception ex) {
            System.err.println("Error in WorldType: " + WorldType.getIdFromWorldType(this.getWorldType()));
            throw ex;
        }
    }

    public Cell getCell(AbstractPlaceType place) {
        for (int i = 0; i < this.grid.length; ++i) {
            for (int j = 0; j < this.grid[0].length; ++j) {
                if (!this.grid[i][j].getPlace().getPlaceType().equals(place)) continue;
                return this.grid[i][j];
            }
        }
        return null;
    }

    public List<Cell> getCells(AbstractPlaceType place) {
        ArrayList<Cell> cellsFound = new ArrayList<Cell>();
        for (int i = 0; i < this.grid.length; ++i) {
            for (int j = 0; j < this.grid[0].length; ++j) {
                if (!this.grid[i][j].getPlace().getPlaceType().equals(place)) continue;
                cellsFound.add(this.grid[i][j]);
            }
        }
        return cellsFound;
    }

    public List<Cell> getCells(AbstractPlaceUpgrade placeUpgrade) {
        ArrayList<Cell> cellsFound = new ArrayList<Cell>();
        for (int i = 0; i < this.grid.length; ++i) {
            for (int j = 0; j < this.grid[0].length; ++j) {
                if (!this.grid[i][j].getPlace().getPlaceUpgrades().contains(placeUpgrade)) continue;
                cellsFound.add(this.grid[i][j]);
            }
        }
        return cellsFound;
    }

    public Cell getClosestCell(Vector2i location, AbstractPlaceType place) {
        float distance = 10000.0f;
        Cell closestCell = null;
        for (int i = 0; i < this.grid.length; ++i) {
            for (int j = 0; j < this.grid[0].length; ++j) {
                float newDistance;
                if (!this.grid[i][j].getPlace().getPlaceType().equals(place) || !((newDistance = Vector2i.getDistance(location, this.grid[i][j].getLocation())) < distance)) continue;
                closestCell = this.grid[i][j];
                distance = newDistance;
            }
        }
        return closestCell;
    }

    public float getClosestCellDistance(Vector2i location, AbstractPlaceType place) {
        float distance = 10000.0f;
        for (int i = 0; i < this.grid.length; ++i) {
            for (int j = 0; j < this.grid[0].length; ++j) {
                float newDistance;
                if (!this.grid[i][j].getPlace().getPlaceType().equals(place) || !((newDistance = Vector2i.getDistance(location, this.grid[i][j].getLocation())) < distance)) continue;
                distance = newDistance;
            }
        }
        return distance;
    }

    public Cell getRandomUnoccupiedCell(AbstractPlaceType place) {
        ArrayList<Cell> cells = new ArrayList<Cell>();
        for (int i = 0; i < this.grid.length; ++i) {
            for (int j = 0; j < this.grid[0].length; ++j) {
                if (!this.grid[i][j].getPlace().getPlaceType().equals(place) || !Main.game.getCharactersPresent(this.grid[i][j]).isEmpty()) continue;
                cells.add(this.grid[i][j]);
            }
        }
        if (cells.isEmpty()) {
            return this.getRandomCell(place);
        }
        return (Cell)cells.get(Util.random.nextInt(cells.size()));
    }

    public Cell getRandomCell(AbstractPlaceType place) {
        return this.getRandomCell(place, Util.random);
    }

    public Cell getRandomCell(AbstractPlaceType place, Random random) {
        ArrayList<Cell> corridorCells = new ArrayList<Cell>();
        for (int i = 0; i < this.grid.length; ++i) {
            for (int j = 0; j < this.grid[0].length; ++j) {
                if (!this.grid[i][j].getPlace().getPlaceType().equals(place)) continue;
                corridorCells.add(this.grid[i][j]);
            }
        }
        if (corridorCells.isEmpty()) {
            return null;
        }
        return (Cell)corridorCells.get(random.nextInt(corridorCells.size()));
    }

    public Cell[][] getCellGrid() {
        return this.grid;
    }

    public AbstractWorldType getWorldType() {
        return this.worldType;
    }

    public void setCellType(AbstractWorldType worldType) {
        this.worldType = worldType;
    }

    public Cell[][] getGrid() {
        return this.grid;
    }

    public void setGrid(Cell[][] grid) {
        this.grid = grid;
    }
}

