/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.world;

import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.npc.misc.NPCOffspring;
import com.lilithsthrone.game.dialogue.utils.ParserTag;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.utils.Util;
import com.lilithsthrone.utils.colours.PresetColour;
import com.lilithsthrone.world.AbstractWorldType;
import com.lilithsthrone.world.TeleportPermissions;
import com.lilithsthrone.world.WorldRegion;
import com.lilithsthrone.world.places.AbstractGlobalPlaceType;
import com.lilithsthrone.world.places.AbstractPlaceType;
import com.lilithsthrone.world.places.PlaceType;
import java.awt.Color;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WorldType {
    public static AbstractWorldType EMPTY;
    public static AbstractWorldType WORLD_MAP;
    public static AbstractWorldType DOMINION;
    public static AbstractWorldType MUSEUM;
    public static AbstractWorldType MUSEUM_LOST;
    public static AbstractWorldType LILAYAS_HOUSE_GROUND_FLOOR;
    public static AbstractWorldType LILAYAS_HOUSE_FIRST_FLOOR;
    public static AbstractWorldType ZARANIX_HOUSE_FIRST_FLOOR;
    public static AbstractWorldType ZARANIX_HOUSE_GROUND_FLOOR;
    public static AbstractWorldType HARPY_NEST;
    public static AbstractWorldType SLAVER_ALLEY;
    public static AbstractWorldType BOUNTY_HUNTER_LODGE;
    public static AbstractWorldType BOUNTY_HUNTER_LODGE_UPSTAIRS;
    public static AbstractWorldType SHOPPING_ARCADE;
    public static AbstractWorldType TEXTILES_WAREHOUSE;
    public static AbstractWorldType ENFORCER_HQ;
    public static AbstractWorldType ENFORCER_WAREHOUSE;
    public static AbstractWorldType CITY_HALL;
    public static AbstractWorldType HOME_IMPROVEMENTS;
    public static AbstractWorldType DOMINION_EXPRESS;
    public static AbstractWorldType ANGELS_KISS_GROUND_FLOOR;
    public static AbstractWorldType ANGELS_KISS_FIRST_FLOOR;
    public static AbstractWorldType NIGHTLIFE_CLUB;
    public static AbstractWorldType DADDYS_APARTMENT;
    public static AbstractWorldType FELICIA_APARTMENT;
    public static AbstractWorldType HELENAS_APARTMENT;
    public static AbstractWorldType NYANS_APARTMENT;
    public static AbstractWorldType SUBMISSION;
    public static AbstractWorldType LYSSIETH_PALACE;
    public static AbstractWorldType IMP_FORTRESS_ALPHA;
    public static AbstractWorldType IMP_FORTRESS_DEMON;
    public static AbstractWorldType IMP_FORTRESS_FEMALES;
    public static AbstractWorldType IMP_FORTRESS_MALES;
    public static AbstractWorldType BAT_CAVERNS;
    public static AbstractWorldType SLIME_QUEENS_LAIR_GROUND_FLOOR;
    public static AbstractWorldType SLIME_QUEENS_LAIR_FIRST_FLOOR;
    public static AbstractWorldType GAMBLING_DEN;
    public static AbstractWorldType RAT_WARRENS;
    public static AbstractWorldType REBEL_BASE;
    private static List<AbstractWorldType> allWorldTypes;
    private static Map<AbstractWorldType, String> worldToIdMap;
    private static Map<String, AbstractWorldType> idToWorldMap;

    public static List<AbstractWorldType> getAllWorldTypes() {
        return new ArrayList<AbstractWorldType>(allWorldTypes);
    }

    public static AbstractWorldType getWorldTypeFromId(String id) {
        id = id.replace("_worldType", "");
        id.replaceAll("SEWERS", "SUBMISSION");
        if (id.equals("SUPPLIER_DEN")) {
            return TEXTILES_WAREHOUSE;
        }
        id = Util.getClosestStringMatch(id, idToWorldMap.keySet());
        return idToWorldMap.get(id);
    }

    public static String getIdFromWorldType(AbstractWorldType placeType) {
        return worldToIdMap.get(placeType);
    }

    static {
        Field[] fieldArray;
        EMPTY = new AbstractWorldType(WorldRegion.MISC, "\u7a7a\u7f6e\u57df(\u6682\u5b58\u4e16\u754c)", PresetColour.BASE_BROWN, false, true, TeleportPermissions.NONE, "/com/lilithsthrone/res/map/empty.png", (AbstractPlaceType)PlaceType.WORLD_MAP_DOMINION, PlaceType.GENERIC_EMPTY_TILE, (Map)Util.newHashMapOfValues(new Util.Value<Color, AbstractPlaceType>(new Color(0xFFFFFF), PlaceType.GENERIC_IMPASSABLE), new Util.Value<Color, AbstractPlaceType>(new Color(0xFF0000), PlaceType.GENERIC_EMPTY_TILE), new Util.Value<Color, AbstractPlaceType>(new Color(0xFFFF00), PlaceType.GENERIC_HOLDING_CELL), new Util.Value<Color, AbstractPlaceType>(new Color(33023), PlaceType.GENERIC_MUSEUM), new Util.Value<Color, AbstractPlaceType>(new Color(0xFF00FF), PlaceType.GENERIC_CLUB_HOLDING_CELL))){};
        WORLD_MAP = new AbstractWorldType(WorldRegion.MISC, "\u8389\u8389\u4e1d\u7684\u738b\u56fd", PresetColour.BASE_TAN, true, true, TeleportPermissions.BOTH, "/com/lilithsthrone/res/map/global/world_map.png", null, null, (Map)Util.newHashMapOfValues(new Util.Value<Color, AbstractGlobalPlaceType>(new Color(6396286), PlaceType.WORLD_MAP_THICK_JUNGLE), new Util.Value<Color, AbstractGlobalPlaceType>(new Color(8506536), PlaceType.WORLD_MAP_JUNGLE), new Util.Value<Color, AbstractGlobalPlaceType>(new Color(11761584), PlaceType.WORLD_MAP_JUNGLE_CITY), new Util.Value<Color, AbstractGlobalPlaceType>(new Color(0x696969), PlaceType.WORLD_MAP_FOOTHILLS), new Util.Value<Color, AbstractGlobalPlaceType>(new Color(0xC1C1C1), PlaceType.WORLD_MAP_MOUNTAINS), new Util.Value<Color, AbstractGlobalPlaceType>(new Color(0xE0E0E0), PlaceType.WORLD_MAP_SNOWY_MOUNTAINS), new Util.Value<Color, AbstractGlobalPlaceType>(new Color(0xFFFFFF), PlaceType.WORLD_MAP_SNOWY_VALLEY), new Util.Value<Color, AbstractGlobalPlaceType>(new Color(0xADFFFF), PlaceType.WORLD_MAP_GLACIAL_LAKE), new Util.Value<Color, AbstractGlobalPlaceType>(new Color(8716543), PlaceType.WORLD_MAP_DOMINION), new Util.Value<Color, AbstractGlobalPlaceType>(new Color(13365717), PlaceType.WORLD_MAP_GRASSLANDS), new Util.Value<Color, AbstractGlobalPlaceType>(new Color(14876631), PlaceType.WORLD_MAP_FIELDS), new Util.Value<Color, AbstractGlobalPlaceType>(new Color(11846800), PlaceType.WORLD_MAP_FOREST), new Util.Value<Color, AbstractGlobalPlaceType>(new Color(13976750), PlaceType.WORLD_MAP_FIELDS_CITY), new Util.Value<Color, AbstractGlobalPlaceType>(new Color(10011784), PlaceType.WORLD_MAP_YOUKO_FOREST), new Util.Value<Color, AbstractGlobalPlaceType>(new Color(6481619), PlaceType.WORLD_MAP_WILD_RIVER), new Util.Value<Color, AbstractGlobalPlaceType>(new Color(11009256), PlaceType.WORLD_MAP_RIVER), new Util.Value<Color, AbstractGlobalPlaceType>(new Color(0xC4FCFF), PlaceType.WORLD_MAP_SEA), new Util.Value<Color, AbstractGlobalPlaceType>(new Color(8545456), PlaceType.WORLD_MAP_SEA_CITY), new Util.Value<Color, AbstractGlobalPlaceType>(new Color(15466436), PlaceType.WORLD_MAP_ARID_GRASSLAND), new Util.Value<Color, AbstractGlobalPlaceType>(new Color(13887152), PlaceType.WORLD_MAP_ARID_SAVANNAH), new Util.Value<Color, AbstractGlobalPlaceType>(new Color(16773060), PlaceType.WORLD_MAP_DESERT), new Util.Value<Color, AbstractGlobalPlaceType>(new Color(16764490), PlaceType.WORLD_MAP_SAND_DUNES), new Util.Value<Color, AbstractGlobalPlaceType>(new Color(13976670), PlaceType.WORLD_MAP_DESERT_CITY), new Util.Value<Color, AbstractGlobalPlaceType>(new Color(16744704), PlaceType.WORLD_MAP_VOLCANO), new Util.Value<Color, AbstractGlobalPlaceType>(new Color(0x3B3B3B), PlaceType.WORLD_MAP_LAVA_FLOWS))){

            @Override
            public boolean isDiscoveredOnStart() {
                return true;
            }
        };
        DOMINION = new AbstractWorldType(WorldRegion.DOMINION, "\u5fa1\u57ce\u533a", PresetColour.BASE_PURPLE, true, true, TeleportPermissions.BOTH, "/com/lilithsthrone/res/map/dominion/dominion.png", (AbstractPlaceType)PlaceType.WORLD_MAP_DOMINION, PlaceType.DOMINION_PLAZA, (Map)Util.newHashMapOfValues(new Util.Value<Color, AbstractPlaceType>(new Color(0xFFFFFF), PlaceType.GENERIC_IMPASSABLE), new Util.Value<Color, AbstractPlaceType>(new Color(0x808080), PlaceType.DOMINION_STREET), new Util.Value<Color, AbstractPlaceType>(new Color(0x404040), PlaceType.DOMINION_BOULEVARD), new Util.Value<Color, AbstractPlaceType>(new Color(0x808000), PlaceType.DOMINION_EXIT_TO_SUBMISSION), new Util.Value<Color, AbstractPlaceType>(new Color(12550144), PlaceType.DOMINION_BACK_ALLEYS_SAFE), new Util.Value<Color, AbstractPlaceType>(new Color(0xC10000), PlaceType.DOMINION_BACK_ALLEYS), new Util.Value<Color, AbstractPlaceType>(new Color(0x5B0000), PlaceType.DOMINION_DARK_ALLEYS), new Util.Value<Color, AbstractPlaceType>(new Color(4240639), PlaceType.DOMINION_ALLEYS_CANAL_CROSSING), new Util.Value<Color, AbstractPlaceType>(new Color(33023), PlaceType.DOMINION_CANAL), new Util.Value<Color, AbstractPlaceType>(new Color(16512), PlaceType.DOMINION_CANAL_END), new Util.Value<Color, AbstractPlaceType>(new Color(0), PlaceType.DOMINION_DEMON_HOME_GATE), new Util.Value<Color, AbstractPlaceType>(new Color(0xFF80FF), PlaceType.DOMINION_DEMON_HOME), new Util.Value<Color, AbstractPlaceType>(new Color(16748800), PlaceType.DOMINION_DEMON_HOME_ARTHUR), new Util.Value<Color, AbstractPlaceType>(new Color(16728255), PlaceType.DOMINION_DEMON_HOME_SEX_SHOP), new Util.Value<Color, AbstractPlaceType>(new Color(0x8000FF), PlaceType.DOMINION_CITY_HALL), new Util.Value<Color, AbstractPlaceType>(new Color(8339520), PlaceType.DOMINION_BANK), new Util.Value<Color, AbstractPlaceType>(new Color(0xFF00FF), PlaceType.DOMINION_LILITHS_TOWER), new Util.Value<Color, AbstractPlaceType>(new Color(0x8080FF), PlaceType.DOMINION_EXIT_WEST), new Util.Value<Color, AbstractPlaceType>(new Color(16730624), PlaceType.DOMINION_EXIT_NORTH), new Util.Value<Color, AbstractPlaceType>(new Color(32832), PlaceType.DOMINION_EXIT_EAST), new Util.Value<Color, AbstractPlaceType>(new Color(0xFFFF80), PlaceType.DOMINION_EXIT_SOUTH), new Util.Value<Color, AbstractPlaceType>(new Color(32896), PlaceType.DOMINION_STREET_HARPY_NESTS), new Util.Value<Color, AbstractPlaceType>(new Color(65408), PlaceType.DOMINION_HARPY_NESTS_ENTRANCE), new Util.Value<Color, AbstractPlaceType>(new Color(16384), PlaceType.DOMINION_PLAZA), new Util.Value<Color, AbstractPlaceType>(new Color(65535), PlaceType.DOMINION_AUNTS_HOME), new Util.Value<Color, AbstractPlaceType>(new Color(0xFFFF00), PlaceType.DOMINION_SHOPPING_ARCADE), new Util.Value<Color, AbstractPlaceType>(new Color(255), PlaceType.DOMINION_ENFORCER_HQ), new Util.Value<Color, AbstractPlaceType>(new Color(128), PlaceType.DOMINION_NIGHTLIFE_DISTRICT), new Util.Value<Color, AbstractPlaceType>(new Color(0xFF0000), PlaceType.DOMINION_SLAVER_ALLEY), new Util.Value<Color, AbstractPlaceType>(new Color(4980480), PlaceType.DOMINION_PARK), new Util.Value<Color, AbstractPlaceType>(new Color(0xFF4000), PlaceType.DOMINION_RED_LIGHT_DISTRICT), new Util.Value<Color, AbstractPlaceType>(new Color(0xFFBF00), PlaceType.DOMINION_HOME_IMPROVEMENT), new Util.Value<Color, AbstractPlaceType>(new Color(0xFF0080), PlaceType.DOMINION_WAREHOUSES), new Util.Value<Color, AbstractPlaceType>(new Color(9258318), PlaceType.DOMINION_CALLIE_BAKERY))){

            @Override
            public int getMajorAreaIndex() {
                return 1;
            }
        };
        MUSEUM = new AbstractWorldType(WorldRegion.OLD_WORLD, "\u535a\u7269\u9986", PresetColour.BASE_BROWN, false, true, TeleportPermissions.NONE, "/com/lilithsthrone/res/map/prologue/museum.png", (AbstractPlaceType)PlaceType.WORLD_MAP_DOMINION, PlaceType.MUSEUM_ENTRANCE, (Map)Util.newHashMapOfValues(new Util.Value<Color, AbstractPlaceType>(new Color(0xFFFFFF), PlaceType.GENERIC_IMPASSABLE), new Util.Value<Color, AbstractPlaceType>(new Color(0xFF0000), PlaceType.MUSEUM_ENTRANCE), new Util.Value<Color, AbstractPlaceType>(new Color(0x8000FF), PlaceType.MUSEUM_CROWDS), new Util.Value<Color, AbstractPlaceType>(new Color(33023), PlaceType.MUSEUM_OFFICE), new Util.Value<Color, AbstractPlaceType>(new Color(0xFFFF00), PlaceType.MUSEUM_STAGE), new Util.Value<Color, AbstractPlaceType>(new Color(0xFF8000), PlaceType.MUSEUM_ROOM), new Util.Value<Color, AbstractPlaceType>(new Color(65280), PlaceType.MUSEUM_STAIRS), new Util.Value<Color, AbstractPlaceType>(new Color(0x808080), PlaceType.MUSEUM_LOBBY))){

            @Override
            public boolean isRevealedOnStart() {
                return true;
            }

            @Override
            public boolean isFurniturePresent() {
                return true;
            }
        };
        MUSEUM_LOST = new AbstractWorldType(WorldRegion.OLD_WORLD, "\u535a\u7269\u9986", PresetColour.BASE_BROWN, false, true, TeleportPermissions.NONE, "/com/lilithsthrone/res/map/prologue/museum_lost.png", (AbstractPlaceType)PlaceType.WORLD_MAP_DOMINION, PlaceType.MUSEUM_MIRROR, (Map)Util.newHashMapOfValues(new Util.Value<Color, AbstractPlaceType>(new Color(0xFFFFFF), PlaceType.GENERIC_IMPASSABLE), new Util.Value<Color, AbstractPlaceType>(new Color(0xFF8000), PlaceType.MUSEUM_ROOM), new Util.Value<Color, AbstractPlaceType>(new Color(65280), PlaceType.MUSEUM_MIRROR), new Util.Value<Color, AbstractPlaceType>(new Color(0x808080), PlaceType.MUSEUM_CORRIDOR))){

            @Override
            public boolean isRevealedOnStart() {
                return true;
            }

            @Override
            public boolean isFurniturePresent() {
                return true;
            }
        };
        LILAYAS_HOUSE_GROUND_FLOOR = new AbstractWorldType(WorldRegion.DOMINION, "\u8389\u83b1\u96c5\u7684\u5bb6 \u4e00\u697c", PresetColour.BASE_BLUE_LIGHT, true, false, TeleportPermissions.BOTH, "/com/lilithsthrone/res/map/dominion/lilayasHome/lilayas_home_ground_floor.png", (AbstractPlaceType)PlaceType.WORLD_MAP_DOMINION, PlaceType.LILAYA_HOME_ENTRANCE_HALL, (Map)Util.newHashMapOfValues(new Util.Value<Color, AbstractPlaceType>(new Color(0xFFFFFF), PlaceType.GENERIC_IMPASSABLE), new Util.Value<Color, AbstractPlaceType>(new Color(0x808080), PlaceType.LILAYA_HOME_CORRIDOR), new Util.Value<Color, AbstractPlaceType>(new Color(0xFF0000), PlaceType.LILAYA_HOME_ENTRANCE_HALL), new Util.Value<Color, AbstractPlaceType>(new Color(32768), PlaceType.LILAYA_HOME_GARDEN), new Util.Value<Color, AbstractPlaceType>(new Color(0xFF8000), PlaceType.LILAYA_HOME_LAB), new Util.Value<Color, AbstractPlaceType>(new Color(0xFFFF00), PlaceType.LILAYA_HOME_BIRTHING_ROOM), new Util.Value<Color, AbstractPlaceType>(new Color(0xFF80FF), PlaceType.LILAYA_HOME_KITCHEN), new Util.Value<Color, AbstractPlaceType>(new Color(65535), PlaceType.LILAYA_HOME_LIBRARY), new Util.Value<Color, AbstractPlaceType>(new Color(0x8000FF), PlaceType.LILAYA_HOME_FOUNTAIN), new Util.Value<Color, AbstractPlaceType>(new Color(0xFF0080), PlaceType.LILAYA_HOME_ROOM_GARDEN_GROUND_FLOOR), new Util.Value<Color, AbstractPlaceType>(new Color(0xFF00FF), PlaceType.LILAYA_HOME_ROOM_WINDOW_GROUND_FLOOR), new Util.Value<Color, AbstractPlaceType>(new Color(65280), PlaceType.LILAYA_HOME_STAIR_UP), new Util.Value<Color, AbstractPlaceType>(new Color(65408), PlaceType.LILAYA_HOME_STAIR_UP_SECONDARY))){

            @Override
            public boolean isRevealedOnStart() {
                return true;
            }

            @Override
            public boolean isFurniturePresent() {
                return true;
            }
        };
        LILAYAS_HOUSE_FIRST_FLOOR = new AbstractWorldType(WorldRegion.DOMINION, "\u8389\u83b1\u96c5\u7684\u5bb6 \u4e8c\u697c", PresetColour.BASE_BLUE_LIGHT, true, false, TeleportPermissions.BOTH, "/com/lilithsthrone/res/map/dominion/lilayasHome/lilayas_home_first_floor.png", (AbstractPlaceType)PlaceType.WORLD_MAP_DOMINION, PlaceType.LILAYA_HOME_STAIR_DOWN, (Map)Util.newHashMapOfValues(new Util.Value<Color, AbstractPlaceType>(new Color(0xFFFFFF), PlaceType.GENERIC_IMPASSABLE), new Util.Value<Color, AbstractPlaceType>(new Color(0x808080), PlaceType.LILAYA_HOME_CORRIDOR), new Util.Value<Color, AbstractPlaceType>(new Color(0xFF00FF), PlaceType.LILAYA_HOME_ROOM_WINDOW_FIRST_FLOOR), new Util.Value<Color, AbstractPlaceType>(new Color(0xFF0080), PlaceType.LILAYA_HOME_ROOM_GARDEN_FIRST_FLOOR), new Util.Value<Color, AbstractPlaceType>(new Color(0xFF80FF), PlaceType.LILAYA_HOME_ROOM_LILAYA), new Util.Value<Color, AbstractPlaceType>(new Color(33023), PlaceType.LILAYA_HOME_ROOM_ROSE), new Util.Value<Color, AbstractPlaceType>(new Color(65535), PlaceType.LILAYA_HOME_ROOM_PLAYER), new Util.Value<Color, AbstractPlaceType>(new Color(0xFF0000), PlaceType.LILAYA_HOME_STAIR_DOWN), new Util.Value<Color, AbstractPlaceType>(new Color(0xFF8000), PlaceType.LILAYA_HOME_STAIR_DOWN_SECONDARY))){

            @Override
            public boolean isRevealedOnStart() {
                return true;
            }

            @Override
            public boolean isFurniturePresent() {
                return true;
            }
        };
        ZARANIX_HOUSE_FIRST_FLOOR = new AbstractWorldType(WorldRegion.DOMINION, "\u624e\u62c9\u5c3c\u514b\u65af\u7684\u5bb6 \u4e8c\u697c", PresetColour.BASE_CRIMSON, false, false, TeleportPermissions.OUTGOING_ONLY, "/com/lilithsthrone/res/map/dominion/zaranixHome/first_floor.png", (AbstractPlaceType)PlaceType.WORLD_MAP_DOMINION, PlaceType.ZARANIX_FF_STAIRS, (Map)Util.newHashMapOfValues(new Util.Value<Color, AbstractPlaceType>(new Color(0xFFFFFF), PlaceType.GENERIC_IMPASSABLE), new Util.Value<Color, AbstractPlaceType>(new Color(0x808080), PlaceType.ZARANIX_FF_CORRIDOR), new Util.Value<Color, AbstractPlaceType>(new Color(65280), PlaceType.ZARANIX_FF_STAIRS), new Util.Value<Color, AbstractPlaceType>(new Color(0xFF80FF), PlaceType.ZARANIX_FF_OFFICE), new Util.Value<Color, AbstractPlaceType>(new Color(0xFF00FF), PlaceType.ZARANIX_FF_ROOM), new Util.Value<Color, AbstractPlaceType>(new Color(0x8000FF), PlaceType.ZARANIX_FF_MAID))){

            @Override
            public String getSexBlockedReason(GameCharacter character) {
                return "\u4f60\u4e0d\u80fd\u5728\u624e\u62c9\u5c3c\u514b\u65af\u7684\u516c\u5bd3\u91cc\u505a\u7231\uff01";
            }

            @Override
            public boolean isFurniturePresent() {
                return true;
            }
        };
        ZARANIX_HOUSE_GROUND_FLOOR = new AbstractWorldType(WorldRegion.DOMINION, "\u624e\u62c9\u5c3c\u514b\u65af\u7684\u5bb6 \u4e00\u697c", PresetColour.BASE_CRIMSON, false, false, TeleportPermissions.OUTGOING_ONLY, "/com/lilithsthrone/res/map/dominion/zaranixHome/ground_floor.png", (AbstractPlaceType)PlaceType.WORLD_MAP_DOMINION, PlaceType.ZARANIX_GF_ENTRANCE, (Map)Util.newHashMapOfValues(new Util.Value<Color, AbstractPlaceType>(new Color(0xFFFFFF), PlaceType.GENERIC_IMPASSABLE), new Util.Value<Color, AbstractPlaceType>(new Color(0x808080), PlaceType.ZARANIX_GF_CORRIDOR), new Util.Value<Color, AbstractPlaceType>(new Color(65280), PlaceType.ZARANIX_GF_STAIRS), new Util.Value<Color, AbstractPlaceType>(new Color(0xFF0000), PlaceType.ZARANIX_GF_ENTRANCE), new Util.Value<Color, AbstractPlaceType>(new Color(0xFFFF00), PlaceType.ZARANIX_GF_LOUNGE), new Util.Value<Color, AbstractPlaceType>(new Color(0xFF00FF), PlaceType.ZARANIX_GF_ROOM), new Util.Value<Color, AbstractPlaceType>(new Color(0x8000FF), PlaceType.ZARANIX_GF_MAID), new Util.Value<Color, AbstractPlaceType>(new Color(65535), PlaceType.ZARANIX_GF_GARDEN_ROOM), new Util.Value<Color, AbstractPlaceType>(new Color(32768), PlaceType.ZARANIX_GF_GARDEN), new Util.Value<Color, AbstractPlaceType>(new Color(0xFF8000), PlaceType.ZARANIX_GF_GARDEN_ENTRY))){

            @Override
            public String getSexBlockedReason(GameCharacter character) {
                return "\u4f60\u4e0d\u80fd\u5728\u624e\u62c9\u5c3c\u514b\u65af\u7684\u516c\u5bd3\u91cc\u505a\u7231\uff01";
            }

            @Override
            public boolean isFurniturePresent() {
                return true;
            }
        };
        HARPY_NEST = new AbstractWorldType(WorldRegion.HARPY_NESTS, "\u54c8\u6bd4\u4e4b\u5de2", PresetColour.BASE_CRIMSON, true, true, TeleportPermissions.BOTH, "/com/lilithsthrone/res/map/dominion/harpyNests/harpyNests.png", (AbstractPlaceType)PlaceType.WORLD_MAP_DOMINION, PlaceType.HARPY_NESTS_ENTRANCE_ENFORCER_POST, (Map)Util.newHashMapOfValues(new Util.Value<Color, AbstractPlaceType>(new Color(0xFFFFFF), PlaceType.GENERIC_IMPASSABLE), new Util.Value<Color, AbstractPlaceType>(new Color(0x808080), PlaceType.HARPY_NESTS_WALKWAYS), new Util.Value<Color, AbstractPlaceType>(new Color(0x404040), PlaceType.HARPY_NESTS_WALKWAYS_BRIDGE), new Util.Value<Color, AbstractPlaceType>(new Color(65408), PlaceType.HARPY_NESTS_ENTRANCE_ENFORCER_POST), new Util.Value<Color, AbstractPlaceType>(new Color(0xFF0000), PlaceType.HARPY_NESTS_HARPY_NEST_RED), new Util.Value<Color, AbstractPlaceType>(new Color(0xFF00FF), PlaceType.HARPY_NESTS_HARPY_NEST_PINK), new Util.Value<Color, AbstractPlaceType>(new Color(0xFFFF00), PlaceType.HARPY_NESTS_HARPY_NEST_YELLOW), new Util.Value<Color, AbstractPlaceType>(new Color(16748800), PlaceType.HARPY_NESTS_HELENAS_NEST))){

            @Override
            public int getMajorAreaIndex() {
                return 2;
            }

            @Override
            public String getOffspringTextFilePath(NPCOffspring o) {
                return "characters/offspring/harpyNests";
            }
        };
        SLAVER_ALLEY = new AbstractWorldType(WorldRegion.DOMINION, "\u5974\u96b6\u5df7", PresetColour.BASE_RED, true, true, TeleportPermissions.BOTH, "/com/lilithsthrone/res/map/dominion/slaverAlley/slaverAlley.png", (AbstractPlaceType)PlaceType.WORLD_MAP_DOMINION, PlaceType.SLAVER_ALLEY_ENTRANCE, (Map)Util.newHashMapOfValues(new Util.Value<Color, AbstractPlaceType>(new Color(0xFFFFFF), PlaceType.GENERIC_IMPASSABLE), new Util.Value<Color, AbstractPlaceType>(new Color(0x808080), PlaceType.SLAVER_ALLEY_PATH), new Util.Value<Color, AbstractPlaceType>(new Color(0xFF0000), PlaceType.SLAVER_ALLEY_ENTRANCE), new Util.Value<Color, AbstractPlaceType>(new Color(0xFF80FF), PlaceType.SLAVER_ALLEY_STALL_FEMALES), new Util.Value<Color, AbstractPlaceType>(new Color(33023), PlaceType.SLAVER_ALLEY_STALL_MALES), new Util.Value<Color, AbstractPlaceType>(new Color(0xFF8000), PlaceType.SLAVER_ALLEY_STALL_ANAL), new Util.Value<Color, AbstractPlaceType>(new Color(0xFF00FF), PlaceType.SLAVER_ALLEY_STALL_VAGINAL), new Util.Value<Color, AbstractPlaceType>(new Color(0xFF8080), PlaceType.SLAVER_ALLEY_STALL_ORAL), new Util.Value<Color, AbstractPlaceType>(new Color(0x404040), PlaceType.SLAVER_ALLEY_STATUE), new Util.Value<Color, AbstractPlaceType>(new Color(2211781), PlaceType.SLAVER_ALLEY_MARKET_STALL_EXCLUSIVE), new Util.Value<Color, AbstractPlaceType>(new Color(16512), PlaceType.SLAVER_ALLEY_MARKET_STALL_BULK), new Util.Value<Color, AbstractPlaceType>(new Color(32768), PlaceType.SLAVER_ALLEY_CAFE), new Util.Value<Color, AbstractPlaceType>(new Color(26112), PlaceType.SLAVER_ALLEY_CAFE_2), new Util.Value<Color, AbstractPlaceType>(new Color(19712), PlaceType.SLAVER_ALLEY_CAFE_3), new Util.Value<Color, AbstractPlaceType>(new Color(13056), PlaceType.SLAVER_ALLEY_CAFE_4), new Util.Value<Color, AbstractPlaceType>(new Color(0xBFFF00), PlaceType.SLAVER_ALLEY_BOUNTY_HUNTERS), new Util.Value<Color, AbstractPlaceType>(new Color(255), PlaceType.SLAVER_ALLEY_SLAVERY_ADMINISTRATION), new Util.Value<Color, AbstractPlaceType>(new Color(0xFF0080), PlaceType.SLAVER_ALLEY_SCARLETTS_SHOP), new Util.Value<Color, AbstractPlaceType>(new Color(0xFFFF00), PlaceType.SLAVER_ALLEY_AUCTIONING_BLOCK), new Util.Value<Color, AbstractPlaceType>(new Color(65280), PlaceType.SLAVER_ALLEY_PUBLIC_STOCKS))){};
        BOUNTY_HUNTER_LODGE = new AbstractWorldType(WorldRegion.DOMINION, "\u9508\u9879\u5708\u9152\u9986", PresetColour.BASE_COPPER, false, false, TeleportPermissions.BOTH, "/com/lilithsthrone/res/map/dominion/slaverAlley/bountyHunterLodge/bountyHunterLodge.png", (AbstractPlaceType)PlaceType.WORLD_MAP_DOMINION, PlaceType.BOUNTY_HUNTER_LODGE_ENTRANCE, (Map)Util.newHashMapOfValues(new Util.Value<Color, AbstractPlaceType>(new Color(0xFFFFFF), PlaceType.GENERIC_IMPASSABLE), new Util.Value<Color, AbstractPlaceType>(new Color(0x808080), PlaceType.BOUNTY_HUNTER_LODGE_FLOOR), new Util.Value<Color, AbstractPlaceType>(new Color(0xFF0000), PlaceType.BOUNTY_HUNTER_LODGE_ENTRANCE), new Util.Value<Color, AbstractPlaceType>(new Color(0xFF8000), PlaceType.BOUNTY_HUNTER_LODGE_BOUNTY_BOARD), new Util.Value<Color, AbstractPlaceType>(new Color(65280), PlaceType.BOUNTY_HUNTER_LODGE_BAR), new Util.Value<Color, AbstractPlaceType>(new Color(0xFFFF00), PlaceType.BOUNTY_HUNTER_LODGE_SEATING), new Util.Value<Color, AbstractPlaceType>(new Color(65535), PlaceType.BOUNTY_HUNTER_LODGE_STAIRS))){};
        BOUNTY_HUNTER_LODGE_UPSTAIRS = new AbstractWorldType(WorldRegion.DOMINION, "\u9508\u9879\u5708\u9152\u9986(\u697c\u4e0a)", PresetColour.BASE_COPPER, false, false, TeleportPermissions.BOTH, "/com/lilithsthrone/res/map/dominion/slaverAlley/bountyHunterLodge/bountyHunterLodgeUpstairs.png", (AbstractPlaceType)PlaceType.WORLD_MAP_DOMINION, PlaceType.BOUNTY_HUNTER_LODGE_ENTRANCE, (Map)Util.newHashMapOfValues(new Util.Value<Color, AbstractPlaceType>(new Color(0xFFFFFF), PlaceType.GENERIC_IMPASSABLE), new Util.Value<Color, AbstractPlaceType>(new Color(0x808080), PlaceType.BOUNTY_HUNTER_LODGE_UPSTAIRS_CORRIDOR), new Util.Value<Color, AbstractPlaceType>(new Color(0xFFFF00), PlaceType.BOUNTY_HUNTER_LODGE_UPSTAIRS_ROOM), new Util.Value<Color, AbstractPlaceType>(new Color(0xFF8000), PlaceType.BOUNTY_HUNTER_LODGE_UPSTAIRS_ROOM_DOBERMANNS), new Util.Value<Color, AbstractPlaceType>(new Color(0xFF80FF), PlaceType.BOUNTY_HUNTER_LODGE_UPSTAIRS_ROOM_SHADOW_SILENCE), new Util.Value<Color, AbstractPlaceType>(new Color(65535), PlaceType.BOUNTY_HUNTER_LODGE_UPSTAIRS_STAIRS))){};
        SHOPPING_ARCADE = new AbstractWorldType(WorldRegion.DOMINION, "\u8d2d\u7269\u4e2d\u5fc3", PresetColour.BASE_YELLOW, true, true, TeleportPermissions.BOTH, "/com/lilithsthrone/res/map/dominion/shoppingArcade/shoppingArcade.png", (AbstractPlaceType)PlaceType.WORLD_MAP_DOMINION, PlaceType.SHOPPING_ARCADE_ENTRANCE, (Map)Util.newHashMapOfValues(new Util.Value<Color, AbstractPlaceType>(new Color(0xFFFFFF), PlaceType.GENERIC_IMPASSABLE), new Util.Value<Color, AbstractPlaceType>(new Color(0x808080), PlaceType.SHOPPING_ARCADE_PATH), new Util.Value<Color, AbstractPlaceType>(new Color(0xFF0000), PlaceType.SHOPPING_ARCADE_ENTRANCE), new Util.Value<Color, AbstractPlaceType>(new Color(65535), PlaceType.SHOPPING_ARCADE_RALPHS_SHOP), new Util.Value<Color, AbstractPlaceType>(new Color(0xFFFF00), PlaceType.SHOPPING_ARCADE_NYANS_SHOP), new Util.Value<Color, AbstractPlaceType>(new Color(33023), PlaceType.SHOPPING_ARCADE_VICKYS_SHOP), new Util.Value<Color, AbstractPlaceType>(new Color(0x8000FF), PlaceType.SHOPPING_ARCADE_PIXS_GYM), new Util.Value<Color, AbstractPlaceType>(new Color(0xFF8000), PlaceType.SHOPPING_ARCADE_KATES_SHOP), new Util.Value<Color, AbstractPlaceType>(new Color(0xFF00FF), PlaceType.SHOPPING_ARCADE_GENERIC_SHOP), new Util.Value<Color, AbstractPlaceType>(new Color(32768), PlaceType.SHOPPING_ARCADE_ASHLEYS_SHOP), new Util.Value<Color, AbstractPlaceType>(new Color(65280), PlaceType.SHOPPING_ARCADE_RESTAURANT), new Util.Value<Color, AbstractPlaceType>(new Color(0x808000), PlaceType.SHOPPING_ARCADE_ANTIQUES), new Util.Value<Color, AbstractPlaceType>(new Color(0xFF8080), PlaceType.SHOPPING_ARCADE_TOILETS))){

            @Override
            public boolean isRevealedOnStart() {
                return true;
            }

            @Override
            public String getSexBlockedReason(GameCharacter character) {
                if (character != null && !character.getLocationPlace().getPlaceType().equals(PlaceType.SHOPPING_ARCADE_PATH)) {
                    return "\u8fd9\u4e0d\u662f\u4e00\u4e2a\u9002\u5408\u505a\u7231\u7684\u597d\u5730\u65b9\uff01";
                }
                return "";
            }

            @Override
            public boolean isFurniturePresent() {
                return true;
            }
        };
        TEXTILES_WAREHOUSE = new AbstractWorldType(WorldRegion.DOMINION, "\u51ef\u8bb0\u7eba\u7ec7", PresetColour.GENERIC_ARCANE, false, false, TeleportPermissions.OUTGOING_ONLY, "/com/lilithsthrone/res/map/dominion/textilesWarehouse/textilesWarehouse.png", (AbstractPlaceType)PlaceType.WORLD_MAP_DOMINION, PlaceType.TEXTILE_WAREHOUSE_ENTRANCE, (Map)Util.newHashMapOfValues(new Util.Value<Color, AbstractPlaceType>(new Color(0xFFFFFF), PlaceType.GENERIC_IMPASSABLE), new Util.Value<Color, AbstractPlaceType>(new Color(0x808080), PlaceType.TEXTILE_WAREHOUSE_CORRIDOR), new Util.Value<Color, AbstractPlaceType>(new Color(0xFF0000), PlaceType.TEXTILE_WAREHOUSE_ENTRANCE), new Util.Value<Color, AbstractPlaceType>(new Color(0xFF00FF), PlaceType.TEXTILE_WAREHOUSE_STORAGE_ROOM), new Util.Value<Color, AbstractPlaceType>(new Color(0xFF8000), PlaceType.TEXTILE_WAREHOUSE_ENCHANTING), new Util.Value<Color, AbstractPlaceType>(new Color(65535), PlaceType.TEXTILE_WAREHOUSE_OVERSEER_STATION), new Util.Value<Color, AbstractPlaceType>(new Color(65280), PlaceType.TEXTILE_WAREHOUSE_OFFICE))){

            @Override
            public String getSexBlockedReason(GameCharacter character) {
                return "\u8fd9\u4e0d\u662f\u4e00\u4e2a\u9002\u5408\u505a\u7231\u7684\u597d\u5730\u65b9\uff01";
            }

            @Override
            public boolean isFurniturePresent() {
                return true;
            }
        };
        ENFORCER_HQ = new AbstractWorldType(WorldRegion.DOMINION, "\u6267\u6cd5\u8005\u603b\u90e8", PresetColour.BASE_BLUE, false, false, TeleportPermissions.OUTGOING_ONLY, "/com/lilithsthrone/res/map/dominion/enforcerHQ/enforcerHQ.png", (AbstractPlaceType)PlaceType.WORLD_MAP_DOMINION, PlaceType.ENFORCER_HQ_ENTRANCE, (Map)Util.newHashMapOfValues(new Util.Value<Color, AbstractPlaceType>(new Color(0xFFFFFF), PlaceType.GENERIC_IMPASSABLE), new Util.Value<Color, AbstractPlaceType>(new Color(0x808080), PlaceType.ENFORCER_HQ_CORRIDOR), new Util.Value<Color, AbstractPlaceType>(new Color(0xB9B9B9), PlaceType.ENFORCER_HQ_CELLS_CORRIDOR), new Util.Value<Color, AbstractPlaceType>(new Color(65280), PlaceType.ENFORCER_HQ_STAIRS), new Util.Value<Color, AbstractPlaceType>(new Color(0xFF0000), PlaceType.ENFORCER_HQ_ENTRANCE), new Util.Value<Color, AbstractPlaceType>(new Color(0x8000FF), PlaceType.ENFORCER_HQ_WAITING_AREA), new Util.Value<Color, AbstractPlaceType>(new Color(33023), PlaceType.ENFORCER_HQ_RECEPTION_DESK), new Util.Value<Color, AbstractPlaceType>(new Color(0xFFFF00), PlaceType.ENFORCER_HQ_GUARDED_DOOR), new Util.Value<Color, AbstractPlaceType>(new Color(0x808000), PlaceType.ENFORCER_HQ_REQUISITIONS_DOOR), new Util.Value<Color, AbstractPlaceType>(new Color(0xFF0080), PlaceType.ENFORCER_HQ_LOCKED_DOOR), new Util.Value<Color, AbstractPlaceType>(new Color(0x800080), PlaceType.ENFORCER_HQ_LOCKED_DOOR_EDGE), new Util.Value<Color, AbstractPlaceType>(new Color(0xFF8000), PlaceType.ENFORCER_HQ_BRAXS_OFFICE), new Util.Value<Color, AbstractPlaceType>(new Color(65535), PlaceType.ENFORCER_HQ_OFFICE), new Util.Value<Color, AbstractPlaceType>(new Color(0xFF8080), PlaceType.ENFORCER_HQ_CELLS_OFFICE), new Util.Value<Color, AbstractPlaceType>(new Color(0x3B3B3B), PlaceType.ENFORCER_HQ_CELL), new Util.Value<Color, AbstractPlaceType>(new Color(0xFF4000), PlaceType.ENFORCER_HQ_ENFORCER_ENTRANCE), new Util.Value<Color, AbstractPlaceType>(new Color(0x80FF80), PlaceType.ENFORCER_HQ_REQUISITIONS), new Util.Value<Color, AbstractPlaceType>(new Color(0xFF00FF), PlaceType.ENFORCER_HQ_OFFICE_QUARTERMASTER))){

            @Override
            public String getSexBlockedReason(GameCharacter character) {
                return "\u4f60\u4e0d\u80fd\u5728\u6267\u6cd5\u8005\u603b\u90e8\u91cc\u505a\u7231\uff01";
            }

            @Override
            public boolean isFurniturePresent() {
                return true;
            }
        };
        ENFORCER_WAREHOUSE = new AbstractWorldType(WorldRegion.DOMINION, "SWORD\u4ed3\u5e93", PresetColour.BASE_BLUE, false, false, TeleportPermissions.NONE, "/com/lilithsthrone/res/map/dominion/enforcerWarehouse/enforcerWarehouse.png", (AbstractPlaceType)PlaceType.WORLD_MAP_DOMINION, PlaceType.ENFORCER_WAREHOUSE_ENTRANCE, (Map)Util.newHashMapOfValues(new Util.Value<Color, AbstractPlaceType>(new Color(0xFFFFFF), PlaceType.GENERIC_IMPASSABLE), new Util.Value<Color, AbstractPlaceType>(new Color(0xFF0000), PlaceType.ENFORCER_WAREHOUSE_ENTRANCE), new Util.Value<Color, AbstractPlaceType>(new Color(0x808080), PlaceType.ENFORCER_WAREHOUSE_CORRIDOR), new Util.Value<Color, AbstractPlaceType>(new Color(0xFF8080), PlaceType.ENFORCER_WAREHOUSE_CLAIRE_WARNING), new Util.Value<Color, AbstractPlaceType>(new Color(0x404040), PlaceType.ENFORCER_WAREHOUSE_ENCLOSURE), new Util.Value<Color, AbstractPlaceType>(new Color(65280), PlaceType.ENFORCER_WAREHOUSE_ENCLOSURE_TELEPORT_PADS), new Util.Value<Color, AbstractPlaceType>(new Color(65535), PlaceType.ENFORCER_WAREHOUSE_ENCLOSURE_TELEPORT_SHELVING), new Util.Value<Color, AbstractPlaceType>(new Color(0xFF0080), PlaceType.ENFORCER_WAREHOUSE_ENFORCER_GUARD_POST), new Util.Value<Color, AbstractPlaceType>(new Color(0xFF8000), PlaceType.ENFORCER_WAREHOUSE_CRATES), new Util.Value<Color, AbstractPlaceType>(new Color(0xFFFF00), PlaceType.ENFORCER_WAREHOUSE_CRATES_ARK), new Util.Value<Color, AbstractPlaceType>(new Color(0xFF00FF), PlaceType.ENFORCER_WAREHOUSE_CRATES_LUST_WEAPON), new Util.Value<Color, AbstractPlaceType>(new Color(0x8000FF), PlaceType.ENFORCER_WAREHOUSE_CRATES_SPELL_BOOK))){

            @Override
            public String getSexBlockedReason(GameCharacter character) {
                return "\u4f60\u4e0d\u80fd\u5728\u8fd9\u4e48\u5371\u9669\u7684\u5730\u65b9\u505a\u7231\uff01";
            }

            @Override
            public boolean isFurniturePresent() {
                return true;
            }
        };
        CITY_HALL = new AbstractWorldType(WorldRegion.DOMINION, "\u5e02\u9547\u8bae\u4f1a\u5385", PresetColour.BASE_PURPLE, false, false, TeleportPermissions.OUTGOING_ONLY, "/com/lilithsthrone/res/map/dominion/cityHall/city_hall.png", (AbstractPlaceType)PlaceType.WORLD_MAP_DOMINION, PlaceType.CITY_HALL_ENTRANCE, (Map)Util.newHashMapOfValues(new Util.Value<Color, AbstractPlaceType>(new Color(0xFFFFFF), PlaceType.GENERIC_IMPASSABLE), new Util.Value<Color, AbstractPlaceType>(new Color(0x808080), PlaceType.CITY_HALL_CORRIDOR), new Util.Value<Color, AbstractPlaceType>(new Color(0xFF0000), PlaceType.CITY_HALL_ENTRANCE), new Util.Value<Color, AbstractPlaceType>(new Color(0xFFFF00), PlaceType.CITY_HALL_INFORMATION_DESK), new Util.Value<Color, AbstractPlaceType>(new Color(0x8000FF), PlaceType.CITY_HALL_WAITING_AREA), new Util.Value<Color, AbstractPlaceType>(new Color(0xFF8000), PlaceType.CITY_HALL_OFFICE), new Util.Value<Color, AbstractPlaceType>(new Color(65280), PlaceType.CITY_HALL_STAIRS), new Util.Value<Color, AbstractPlaceType>(new Color(0xFF0080), PlaceType.CITY_HALL_BUREAU_OF_DEMOGRAPHICS), new Util.Value<Color, AbstractPlaceType>(new Color(0xFF00FF), PlaceType.CITY_HALL_ARCHIVES), new Util.Value<Color, AbstractPlaceType>(new Color(0xFFFF80), PlaceType.CITY_HALL_BUREAU_OF_PROPERTY_RIGHTS_AND_COMMERCE))){

            @Override
            public String getSexBlockedReason(GameCharacter character) {
                return "\u8fd9\u4e0d\u662f\u4e00\u4e2a\u9002\u5408\u505a\u7231\u7684\u597d\u5730\u65b9\uff01";
            }

            @Override
            public boolean isFurniturePresent() {
                return true;
            }
        };
        HOME_IMPROVEMENTS = new AbstractWorldType(WorldRegion.DOMINION, "\u963f\u683c\u65af\u7684DIY\u4ed3\u5e93", PresetColour.BASE_ORANGE, false, false, TeleportPermissions.OUTGOING_ONLY, "/com/lilithsthrone/res/map/dominion/homeImprovements/homeImprovements.png", (AbstractPlaceType)PlaceType.WORLD_MAP_DOMINION, PlaceType.HOME_IMPROVEMENTS_ENTRANCE, (Map)Util.newHashMapOfValues(new Util.Value<Color, AbstractPlaceType>(new Color(0xFFFFFF), PlaceType.GENERIC_IMPASSABLE), new Util.Value<Color, AbstractPlaceType>(new Color(0x808080), PlaceType.HOME_IMPROVEMENTS_CORRIDOR), new Util.Value<Color, AbstractPlaceType>(new Color(65280), PlaceType.HOME_IMPROVEMENTS_ENTRANCE), new Util.Value<Color, AbstractPlaceType>(new Color(0xFFFF00), PlaceType.HOME_IMPROVEMENTS_SHELVING_PREMIUM), new Util.Value<Color, AbstractPlaceType>(new Color(0xFF80FF), PlaceType.HOME_IMPROVEMENTS_SHELVING_STANDARD), new Util.Value<Color, AbstractPlaceType>(new Color(0xFF8000), PlaceType.HOME_IMPROVEMENTS_BUILDING_SUPPLIES), new Util.Value<Color, AbstractPlaceType>(new Color(0xFF0080), PlaceType.HOME_IMPROVEMENTS_OFFICE), new Util.Value<Color, AbstractPlaceType>(new Color(65535), PlaceType.HOME_IMPROVEMENTS_TOILETS))){

            @Override
            public String getSexBlockedReason(GameCharacter character) {
                return "\u8fd9\u4e0d\u662f\u4e00\u4e2a\u9002\u5408\u505a\u7231\u7684\u597d\u5730\u65b9\uff01";
            }
        };
        DOMINION_EXPRESS = new AbstractWorldType(WorldRegion.DOMINION, "\u5fa1\u57ce\u901f\u9012", PresetColour.BASE_BROWN, false, false, TeleportPermissions.OUTGOING_ONLY, "/com/lilithsthrone/res/map/dominion/dominionExpress/dominionExpress.png", (AbstractPlaceType)PlaceType.WORLD_MAP_DOMINION, PlaceType.HOME_IMPROVEMENTS_ENTRANCE, (Map)Util.newHashMapOfValues(new Util.Value<Color, AbstractPlaceType>(new Color(0xFFFFFF), PlaceType.GENERIC_IMPASSABLE), new Util.Value<Color, AbstractPlaceType>(new Color(0x808080), PlaceType.DOMINION_EXPRESS_CORRIDOR), new Util.Value<Color, AbstractPlaceType>(new Color(0xFF0000), PlaceType.DOMINION_EXPRESS_EXIT), new Util.Value<Color, AbstractPlaceType>(new Color(0xFF00FF), PlaceType.DOMINION_EXPRESS_STORAGE), new Util.Value<Color, AbstractPlaceType>(new Color(65535), PlaceType.DOMINION_EXPRESS_OFFICE), new Util.Value<Color, AbstractPlaceType>(new Color(255), PlaceType.DOMINION_EXPRESS_FILLY_STATION), new Util.Value<Color, AbstractPlaceType>(new Color(0xFFFF00), PlaceType.DOMINION_EXPRESS_OFFICE_STABLE), new Util.Value<Color, AbstractPlaceType>(new Color(0xFF8000), PlaceType.DOMINION_EXPRESS_STABLES))){

            @Override
            public String getSexBlockedReason(GameCharacter character) {
                return "\u8fd9\u4e0d\u662f\u4e00\u4e2a\u9002\u5408\u505a\u7231\u7684\u597d\u5730\u65b9\uff01";
            }

            @Override
            public boolean isFurniturePresent() {
                return true;
            }
        };
        ANGELS_KISS_GROUND_FLOOR = new AbstractWorldType(WorldRegion.DOMINION, "\u5929\u4f7f\u4e4b\u543b \u4e00\u697c", PresetColour.BASE_MAGENTA, false, false, TeleportPermissions.BOTH, "/com/lilithsthrone/res/map/dominion/angelsKiss/angelsKissGroundFloor.png", (AbstractPlaceType)PlaceType.WORLD_MAP_DOMINION, PlaceType.ANGELS_KISS_ENTRANCE, (Map)Util.newHashMapOfValues(new Util.Value<Color, AbstractPlaceType>(new Color(0xFFFFFF), PlaceType.GENERIC_IMPASSABLE), new Util.Value<Color, AbstractPlaceType>(new Color(0x808080), PlaceType.ANGELS_KISS_CORRIDOR), new Util.Value<Color, AbstractPlaceType>(new Color(65280), PlaceType.ANGELS_KISS_ENTRANCE), new Util.Value<Color, AbstractPlaceType>(new Color(0xFF0000), PlaceType.ANGELS_KISS_STAIRCASE_UP), new Util.Value<Color, AbstractPlaceType>(new Color(65535), PlaceType.ANGELS_KISS_OFFICE), new Util.Value<Color, AbstractPlaceType>(new Color(0xFF00FF), PlaceType.ANGELS_KISS_BEDROOM))){

            @Override
            public boolean isFurniturePresent() {
                return true;
            }
        };
        ANGELS_KISS_FIRST_FLOOR = new AbstractWorldType(WorldRegion.DOMINION, "\u5929\u4f7f\u4e4b\u543b \u4e8c\u697c", PresetColour.BASE_MAGENTA, false, false, TeleportPermissions.BOTH, "/com/lilithsthrone/res/map/dominion/angelsKiss/angelsKissFirstFloor.png", (AbstractPlaceType)PlaceType.WORLD_MAP_DOMINION, PlaceType.ANGELS_KISS_STAIRCASE_DOWN, (Map)Util.newHashMapOfValues(new Util.Value<Color, AbstractPlaceType>(new Color(0xFFFFFF), PlaceType.GENERIC_IMPASSABLE), new Util.Value<Color, AbstractPlaceType>(new Color(0x808080), PlaceType.ANGELS_KISS_CORRIDOR), new Util.Value<Color, AbstractPlaceType>(new Color(0xFF0000), PlaceType.ANGELS_KISS_STAIRCASE_DOWN), new Util.Value<Color, AbstractPlaceType>(new Color(0xFF00FF), PlaceType.ANGELS_KISS_BEDROOM), new Util.Value<Color, AbstractPlaceType>(new Color(0xFFFF00), PlaceType.ANGELS_KISS_BEDROOM_BUNNY), new Util.Value<Color, AbstractPlaceType>(new Color(0xFF8000), PlaceType.ANGELS_KISS_BEDROOM_LOPPY))){

            @Override
            public boolean isFurniturePresent() {
                return true;
            }
        };
        NIGHTLIFE_CLUB = new AbstractWorldType(WorldRegion.DOMINION, "\u996e\u6c34\u6d3c\u591c\u5e97", PresetColour.BASE_BLUE, false, false, TeleportPermissions.NONE, "/com/lilithsthrone/res/map/dominion/nightLife/wateringHole.png", (AbstractPlaceType)PlaceType.WORLD_MAP_DOMINION, PlaceType.WATERING_HOLE_ENTRANCE, (Map)Util.newHashMapOfValues(new Util.Value<Color, AbstractPlaceType>(new Color(0xFFFFFF), PlaceType.GENERIC_IMPASSABLE), new Util.Value<Color, AbstractPlaceType>(new Color(65280), PlaceType.WATERING_HOLE_ENTRANCE), new Util.Value<Color, AbstractPlaceType>(new Color(0x808080), PlaceType.WATERING_HOLE_MAIN_AREA), new Util.Value<Color, AbstractPlaceType>(new Color(33023), PlaceType.WATERING_HOLE_SEATING_AREA), new Util.Value<Color, AbstractPlaceType>(new Color(0xFF00FF), PlaceType.WATERING_HOLE_VIP_AREA), new Util.Value<Color, AbstractPlaceType>(new Color(0xFF8000), PlaceType.WATERING_HOLE_BAR), new Util.Value<Color, AbstractPlaceType>(new Color(0xFFFF00), PlaceType.WATERING_HOLE_DANCE_FLOOR), new Util.Value<Color, AbstractPlaceType>(new Color(0xFF0000), PlaceType.WATERING_HOLE_TOILETS))){

            @Override
            public boolean isRevealedOnStart() {
                return true;
            }
        };
        DADDYS_APARTMENT = new AbstractWorldType(WorldRegion.DOMINION, "\u7239\u5730\u7684\u516c\u5bd3", PresetColour.RACE_DEMON, false, false, TeleportPermissions.NONE, "/com/lilithsthrone/res/map/dominion/daddy/apartment.png", (AbstractPlaceType)PlaceType.WORLD_MAP_DOMINION, PlaceType.DOMINION_DEMON_HOME_DADDY, (Map)Util.newHashMapOfValues(new Util.Value<Color, AbstractPlaceType>(new Color(0xFFFFFF), PlaceType.GENERIC_IMPASSABLE), new Util.Value<Color, AbstractPlaceType>(new Color(65280), PlaceType.DADDY_APARTMENT_ENTRANCE), new Util.Value<Color, AbstractPlaceType>(new Color(0xFFFF00), PlaceType.DADDY_APARTMENT_LOUNGE), new Util.Value<Color, AbstractPlaceType>(new Color(65535), PlaceType.DADDY_APARTMENT_KITCHEN), new Util.Value<Color, AbstractPlaceType>(new Color(0xFF00FF), PlaceType.DADDY_APARTMENT_BEDROOM))){

            @Override
            public String getName() {
                return UtilText.parse("[daddy.NamePos]\u7684\u516c\u5bd3", new ParserTag[0]);
            }

            @Override
            public boolean isRevealedOnStart() {
                return true;
            }

            @Override
            public String getSexBlockedReason(GameCharacter character) {
                return "\u4f60\u4e0d\u80fd\u5728[daddy.namePos]\u7684\u516c\u5bd3\u91cc\u505a\u7231\uff01";
            }

            @Override
            public boolean isFurniturePresent() {
                return true;
            }
        };
        FELICIA_APARTMENT = new AbstractWorldType(WorldRegion.DOMINION, "\u5c0f\u516c\u5bd3", PresetColour.BASE_YELLOW_PALE, false, false, TeleportPermissions.NONE, "/com/lilithsthrone/res/map/dominion/feliciaApartment/feliciaApartment.png", (AbstractPlaceType)PlaceType.WORLD_MAP_DOMINION, PlaceType.FELICIA_APARTMENT_ENTRYWAY, (Map)Util.newHashMapOfValues(new Util.Value<Color, AbstractPlaceType>(new Color(0xFFFFFF), PlaceType.GENERIC_IMPASSABLE), new Util.Value<Color, AbstractPlaceType>(new Color(0xD7D7D7), PlaceType.FELICIA_APARTMENT_HALLWAY), new Util.Value<Color, AbstractPlaceType>(new Color(0xFF3F13), PlaceType.FELICIA_APARTMENT_ENTRYWAY), new Util.Value<Color, AbstractPlaceType>(new Color(5041397), PlaceType.FELICIA_APARTMENT_DINING_AREA), new Util.Value<Color, AbstractPlaceType>(new Color(3012871), PlaceType.FELICIA_APARTMENT_KITCHEN), new Util.Value<Color, AbstractPlaceType>(new Color(0xFFF900), PlaceType.FELICIA_APARTMENT_BATHROOM), new Util.Value<Color, AbstractPlaceType>(new Color(0x909090), PlaceType.FELICIA_APARTMENT_LIVING_AREA), new Util.Value<Color, AbstractPlaceType>(new Color(20980), PlaceType.FELICIA_APARTMENT_BEDROOM))){

            @Override
            public String getSexBlockedReason(GameCharacter character) {
                return "\u4f60\u4e0d\u80fd\u5728\u83f2\u5229\u5e0c\u4e9a\u7684\u516c\u5bd3\u91cc\u505a\u7231\uff01";
            }

            @Override
            public boolean isFurniturePresent() {
                return true;
            }
        };
        HELENAS_APARTMENT = new AbstractWorldType(WorldRegion.DOMINION, "\u6d77\u4f26\u5a1c\u7684\u516c\u5bd3", PresetColour.BASE_GOLD, false, false, TeleportPermissions.NONE, "/com/lilithsthrone/res/map/dominion/helenaApartment/apartment.png", (AbstractPlaceType)PlaceType.WORLD_MAP_DOMINION, PlaceType.DOMINION_HELENA_HOTEL, (Map)Util.newHashMapOfValues(new Util.Value<Color, AbstractPlaceType>(new Color(0xFFFFFF), PlaceType.GENERIC_IMPASSABLE), new Util.Value<Color, AbstractPlaceType>(new Color(0x808080), PlaceType.HELENA_APARTMENT_HALLWAY), new Util.Value<Color, AbstractPlaceType>(new Color(65535), PlaceType.HELENA_APARTMENT_BALCONY), new Util.Value<Color, AbstractPlaceType>(new Color(65280), PlaceType.HELENA_APARTMENT_ENTRANCE), new Util.Value<Color, AbstractPlaceType>(new Color(0xFF00FF), PlaceType.HELENA_APARTMENT_HELENA_BEDROOM), new Util.Value<Color, AbstractPlaceType>(new Color(0xFF0080), PlaceType.HELENA_APARTMENT_SCARLETT_BEDROOM), new Util.Value<Color, AbstractPlaceType>(new Color(0xFF80FF), PlaceType.HELENA_APARTMENT_BEDROOM), new Util.Value<Color, AbstractPlaceType>(new Color(255), PlaceType.HELENA_APARTMENT_BATHROOM), new Util.Value<Color, AbstractPlaceType>(new Color(0x8080FF), PlaceType.HELENA_APARTMENT_OFFICE), new Util.Value<Color, AbstractPlaceType>(new Color(0xFF8000), PlaceType.HELENA_APARTMENT_KITCHEN), new Util.Value<Color, AbstractPlaceType>(new Color(32768), PlaceType.HELENA_APARTMENT_DINING_ROOM), new Util.Value<Color, AbstractPlaceType>(new Color(0xFFFF00), PlaceType.HELENA_APARTMENT_LOUNGE), new Util.Value<Color, AbstractPlaceType>(new Color(0x8000FF), PlaceType.HELENA_APARTMENT_HOT_TUB))){

            @Override
            public boolean isRevealedOnStart() {
                return true;
            }

            @Override
            public String getSexBlockedReason(GameCharacter character) {
                return "\u4f60\u4e0d\u80fd\u5728\u6d77\u4f26\u5a1c\u7684\u516c\u5bd3\u91cc\u505a\u7231\uff01";
            }

            @Override
            public boolean isFurniturePresent() {
                return true;
            }
        };
        NYANS_APARTMENT = new AbstractWorldType(WorldRegion.DOMINION, "\u59ae\u5b89\u7684\u516c\u5bd3", PresetColour.BASE_PINK_LIGHT, false, false, TeleportPermissions.NONE, "/com/lilithsthrone/res/map/dominion/nyanApartment/apartment.png", (AbstractPlaceType)PlaceType.WORLD_MAP_DOMINION, PlaceType.DOMINION_NYAN_APARTMENT, (Map)Util.newHashMapOfValues(new Util.Value<Color, AbstractPlaceType>(new Color(0xFFFFFF), PlaceType.GENERIC_IMPASSABLE), new Util.Value<Color, AbstractPlaceType>(new Color(0x808080), PlaceType.NYAN_APARTMENT_HALLWAY), new Util.Value<Color, AbstractPlaceType>(new Color(65280), PlaceType.NYAN_APARTMENT_ENTRANCE), new Util.Value<Color, AbstractPlaceType>(new Color(0xFF8000), PlaceType.NYAN_APARTMENT_DINING_ROOM), new Util.Value<Color, AbstractPlaceType>(new Color(0xFFFF00), PlaceType.NYAN_APARTMENT_KITCHEN), new Util.Value<Color, AbstractPlaceType>(new Color(255), PlaceType.NYAN_APARTMENT_BATHROOM), new Util.Value<Color, AbstractPlaceType>(new Color(65408), PlaceType.NYAN_APARTMENT_LOUNGE), new Util.Value<Color, AbstractPlaceType>(new Color(0xFF00FF), PlaceType.NYAN_APARTMENT_SPARE_BEDROOM), new Util.Value<Color, AbstractPlaceType>(new Color(0xFF0000), PlaceType.NYAN_APARTMENT_NYAN_BEDROOM), new Util.Value<Color, AbstractPlaceType>(new Color(65535), PlaceType.NYAN_APARTMENT_ENSUITE))){

            @Override
            public boolean isRevealedOnStart() {
                return true;
            }

            @Override
            public String getSexBlockedReason(GameCharacter character) {
                return "\u4f60\u4e0d\u80fd\u5728\u59ae\u5b89\u7684\u516c\u5bd3\u91cc\u505a\u7231\uff01";
            }

            @Override
            public boolean isFurniturePresent() {
                return true;
            }
        };
        SUBMISSION = new AbstractWorldType(WorldRegion.SUBMISSION, "\u5c48\u57ce\u533a", PresetColour.BASE_GREEN, true, true, TeleportPermissions.BOTH, "/com/lilithsthrone/res/map/submission/submission.png", (AbstractPlaceType)PlaceType.WORLD_MAP_DOMINION, PlaceType.SUBMISSION_ENTRANCE, (Map)Util.newHashMapOfValues(new Util.Value<Color, AbstractPlaceType>(new Color(0xFFFFFF), PlaceType.GENERIC_IMPASSABLE), new Util.Value<Color, AbstractPlaceType>(new Color(0x808000), PlaceType.SUBMISSION_ENTRANCE), new Util.Value<Color, AbstractPlaceType>(new Color(0x808080), PlaceType.SUBMISSION_WALKWAYS), new Util.Value<Color, AbstractPlaceType>(new Color(0xC10000), PlaceType.SUBMISSION_TUNNELS), new Util.Value<Color, AbstractPlaceType>(new Color(32896), PlaceType.SUBMISSION_BAT_CAVERNS), new Util.Value<Color, AbstractPlaceType>(new Color(16748800), PlaceType.SUBMISSION_RAT_WARREN), new Util.Value<Color, AbstractPlaceType>(new Color(0xFFFF00), PlaceType.SUBMISSION_GAMBLING_DEN), new Util.Value<Color, AbstractPlaceType>(new Color(0xFF00FF), PlaceType.SUBMISSION_LILIN_PALACE), new Util.Value<Color, AbstractPlaceType>(new Color(0), PlaceType.SUBMISSION_LILIN_PALACE_GATE), new Util.Value<Color, AbstractPlaceType>(new Color(0x404040), PlaceType.SUBMISSION_LILIN_PALACE_CAVERN), new Util.Value<Color, AbstractPlaceType>(new Color(20425), PlaceType.SUBMISSION_IMP_FORTRESS_ALPHA), new Util.Value<Color, AbstractPlaceType>(new Color(6655177), PlaceType.SUBMISSION_IMP_TUNNELS_ALPHA), new Util.Value<Color, AbstractPlaceType>(new Color(6891721), PlaceType.SUBMISSION_IMP_FORTRESS_DEMON), new Util.Value<Color, AbstractPlaceType>(new Color(9266633), PlaceType.SUBMISSION_IMP_TUNNELS_DEMON), new Util.Value<Color, AbstractPlaceType>(new Color(10627273), PlaceType.SUBMISSION_IMP_FORTRESS_FEMALES), new Util.Value<Color, AbstractPlaceType>(new Color(11560393), PlaceType.SUBMISSION_IMP_TUNNELS_FEMALES), new Util.Value<Color, AbstractPlaceType>(new Color(38601), PlaceType.SUBMISSION_IMP_FORTRESS_MALES), new Util.Value<Color, AbstractPlaceType>(new Color(6664393), PlaceType.SUBMISSION_IMP_TUNNELS_MALES))){

            @Override
            public int getMajorAreaIndex() {
                return 1;
            }

            @Override
            public String getOffspringTextFilePath(NPCOffspring o) {
                return "characters/offspring/submission_tunnel";
            }
        };
        LYSSIETH_PALACE = new AbstractWorldType(WorldRegion.SUBMISSION, "\u8389\u897f\u4e1d\u7684\u5bab\u6bbf", PresetColour.BASE_PURPLE, false, false, TeleportPermissions.NONE, "/com/lilithsthrone/res/map/submission/lyssiethsPalace/groundFloor.png", (AbstractPlaceType)PlaceType.WORLD_MAP_DOMINION, PlaceType.LYSSIETH_PALACE_ENTRANCE, (Map)Util.newHashMapOfValues(new Util.Value<Color, AbstractPlaceType>(new Color(0xFFFFFF), PlaceType.GENERIC_IMPASSABLE), new Util.Value<Color, AbstractPlaceType>(new Color(0x808080), PlaceType.LYSSIETH_PALACE_CORRIDOR), new Util.Value<Color, AbstractPlaceType>(new Color(0x404040), PlaceType.LYSSIETH_PALACE_WINDOWS), new Util.Value<Color, AbstractPlaceType>(new Color(65280), PlaceType.LYSSIETH_PALACE_ENTRANCE), new Util.Value<Color, AbstractPlaceType>(new Color(0xFF80FF), PlaceType.LYSSIETH_PALACE_ROOM), new Util.Value<Color, AbstractPlaceType>(new Color(0xFF8000), PlaceType.LYSSIETH_PALACE_HALL), new Util.Value<Color, AbstractPlaceType>(new Color(0x8000FF), PlaceType.LYSSIETH_PALACE_OFFICE), new Util.Value<Color, AbstractPlaceType>(new Color(0xFF0080), PlaceType.LYSSIETH_PALACE_SIREN_OFFICE), new Util.Value<Color, AbstractPlaceType>(new Color(0xFF0000), PlaceType.LYSSIETH_PALACE_STAIRS_1), new Util.Value<Color, AbstractPlaceType>(new Color(255), PlaceType.LYSSIETH_PALACE_STAIRS_2))){

            @Override
            public String getSexBlockedReason(GameCharacter character) {
                return "\u4f60\u4e0d\u80fd\u5728\u8389\u897f\u4e1d\u7684\u5bab\u6bbf\u91cc\u505a\u7231\uff01";
            }

            @Override
            public boolean isFurniturePresent() {
                return true;
            }
        };
        IMP_FORTRESS_ALPHA = new AbstractWorldType(WorldRegion.SUBMISSION, "\u5c0f\u6076\u9b54\u8981\u585e A", PresetColour.BASE_CRIMSON, false, false, TeleportPermissions.OUTGOING_ONLY, "/com/lilithsthrone/res/map/submission/impFortress/fortress1Map.png", (AbstractPlaceType)PlaceType.WORLD_MAP_DOMINION, PlaceType.FORTRESS_ALPHA_ENTRANCE, (Map)Util.newHashMapOfValues(new Util.Value<Color, AbstractPlaceType>(new Color(0xFFFFFF), PlaceType.GENERIC_IMPASSABLE), new Util.Value<Color, AbstractPlaceType>(new Color(0x808080), PlaceType.FORTRESS_ALPHA_COURTYARD), new Util.Value<Color, AbstractPlaceType>(new Color(65280), PlaceType.FORTRESS_ALPHA_ENTRANCE), new Util.Value<Color, AbstractPlaceType>(new Color(0xFF8000), PlaceType.FORTRESS_ALPHA_KEEP))){

            @Override
            public boolean isRevealedOnStart() {
                return true;
            }

            @Override
            public String getSexBlockedReason(GameCharacter character) {
                return "\u8fd9\u4e0d\u662f\u4e00\u4e2a\u9002\u5408\u505a\u7231\u7684\u597d\u5730\u65b9\uff01";
            }
        };
        IMP_FORTRESS_DEMON = new AbstractWorldType(WorldRegion.SUBMISSION, "\u5c0f\u6076\u9b54\u57ce\u5821", PresetColour.BASE_PURPLE, false, false, TeleportPermissions.OUTGOING_ONLY, "/com/lilithsthrone/res/map/submission/impFortress/fortress2Map.png", (AbstractPlaceType)PlaceType.WORLD_MAP_DOMINION, PlaceType.FORTRESS_DEMON_ENTRANCE, (Map)Util.newHashMapOfValues(new Util.Value<Color, AbstractPlaceType>(new Color(0xFFFFFF), PlaceType.GENERIC_IMPASSABLE), new Util.Value<Color, AbstractPlaceType>(new Color(0x808080), PlaceType.FORTRESS_DEMON_COURTYARD), new Util.Value<Color, AbstractPlaceType>(new Color(65280), PlaceType.FORTRESS_DEMON_ENTRANCE), new Util.Value<Color, AbstractPlaceType>(new Color(6664393), PlaceType.FORTRESS_DEMON_WELL), new Util.Value<Color, AbstractPlaceType>(new Color(0xFF8000), PlaceType.FORTRESS_DEMON_KEEP), new Util.Value<Color, AbstractPlaceType>(new Color(0x8000FF), PlaceType.FORTRESS_DEMON_CELLS), new Util.Value<Color, AbstractPlaceType>(new Color(0x80FF00), PlaceType.FORTRESS_LAB), new Util.Value<Color, AbstractPlaceType>(new Color(0xFF00FF), PlaceType.FORTRESS_DEMON_TREASURY))){

            @Override
            public boolean isRevealedOnStart() {
                return true;
            }

            @Override
            public String getSexBlockedReason(GameCharacter character) {
                return "\u8fd9\u4e0d\u662f\u4e00\u4e2a\u9002\u5408\u505a\u7231\u7684\u597d\u5730\u65b9\uff01";
            }
        };
        IMP_FORTRESS_FEMALES = new AbstractWorldType(WorldRegion.SUBMISSION, "\u5c0f\u6076\u9b54\u8981\u585e F", PresetColour.BASE_PINK, false, false, TeleportPermissions.OUTGOING_ONLY, "/com/lilithsthrone/res/map/submission/impFortress/fortress3Map.png", (AbstractPlaceType)PlaceType.WORLD_MAP_DOMINION, PlaceType.FORTRESS_FEMALES_ENTRANCE, (Map)Util.newHashMapOfValues(new Util.Value<Color, AbstractPlaceType>(new Color(0xFFFFFF), PlaceType.GENERIC_IMPASSABLE), new Util.Value<Color, AbstractPlaceType>(new Color(0x808080), PlaceType.FORTRESS_FEMALES_COURTYARD), new Util.Value<Color, AbstractPlaceType>(new Color(65280), PlaceType.FORTRESS_FEMALES_ENTRANCE), new Util.Value<Color, AbstractPlaceType>(new Color(0xFF8000), PlaceType.FORTRESS_FEMALES_KEEP))){

            @Override
            public boolean isRevealedOnStart() {
                return true;
            }

            @Override
            public String getSexBlockedReason(GameCharacter character) {
                return "\u8fd9\u4e0d\u662f\u4e00\u4e2a\u9002\u5408\u505a\u7231\u7684\u597d\u5730\u65b9\uff01";
            }
        };
        IMP_FORTRESS_MALES = new AbstractWorldType(WorldRegion.SUBMISSION, "\u5c0f\u6076\u9b54\u8981\u585e M", PresetColour.BASE_BLUE, false, false, TeleportPermissions.OUTGOING_ONLY, "/com/lilithsthrone/res/map/submission/impFortress/fortress4Map.png", (AbstractPlaceType)PlaceType.WORLD_MAP_DOMINION, PlaceType.FORTRESS_MALES_ENTRANCE, (Map)Util.newHashMapOfValues(new Util.Value<Color, AbstractPlaceType>(new Color(0xFFFFFF), PlaceType.GENERIC_IMPASSABLE), new Util.Value<Color, AbstractPlaceType>(new Color(0x808080), PlaceType.FORTRESS_MALES_COURTYARD), new Util.Value<Color, AbstractPlaceType>(new Color(65280), PlaceType.FORTRESS_MALES_ENTRANCE), new Util.Value<Color, AbstractPlaceType>(new Color(0xFF8000), PlaceType.FORTRESS_MALES_KEEP))){

            @Override
            public boolean isRevealedOnStart() {
                return true;
            }

            @Override
            public String getSexBlockedReason(GameCharacter character) {
                return "\u8fd9\u4e0d\u662f\u4e00\u4e2a\u9002\u5408\u505a\u7231\u7684\u597d\u5730\u65b9\uff01";
            }
        };
        BAT_CAVERNS = new AbstractWorldType(WorldRegion.SUBMISSION, "\u8759\u8760\u6d1e\u7a9f", PresetColour.BASE_BLACK, true, true, TeleportPermissions.BOTH, "/com/lilithsthrone/res/map/submission/batCaverns/batCaverns.png", (AbstractPlaceType)PlaceType.WORLD_MAP_DOMINION, PlaceType.BAT_CAVERN_ENTRANCE, (Map)Util.newHashMapOfValues(new Util.Value<Color, AbstractPlaceType>(new Color(0xFFFFFF), PlaceType.GENERIC_IMPASSABLE), new Util.Value<Color, AbstractPlaceType>(new Color(65280), PlaceType.BAT_CAVERN_ENTRANCE), new Util.Value<Color, AbstractPlaceType>(new Color(0xFFFF00), PlaceType.BAT_CAVERN_SHAFT), new Util.Value<Color, AbstractPlaceType>(new Color(32896), PlaceType.BAT_CAVERN_DARK), new Util.Value<Color, AbstractPlaceType>(new Color(0x808080), PlaceType.BAT_CAVERN_LIGHT), new Util.Value<Color, AbstractPlaceType>(new Color(33023), PlaceType.BAT_CAVERN_RIVER), new Util.Value<Color, AbstractPlaceType>(new Color(4240639), PlaceType.BAT_CAVERN_RIVER_CROSSING), new Util.Value<Color, AbstractPlaceType>(new Color(16512), PlaceType.BAT_CAVERN_RIVER_END), new Util.Value<Color, AbstractPlaceType>(new Color(0xFF80FF), PlaceType.BAT_CAVERN_SLIME_QUEEN_LAIR))){

            @Override
            public int getMajorAreaIndex() {
                return 2;
            }

            @Override
            public String getOffspringTextFilePath(NPCOffspring o) {
                return "characters/offspring/bat_cavern";
            }
        };
        SLIME_QUEENS_LAIR_GROUND_FLOOR = new AbstractWorldType(WorldRegion.SUBMISSION, "\u53f2\u83b1\u59c6\u5973\u738b\u5854 \u4e00\u697c", PresetColour.BASE_PINK, false, false, TeleportPermissions.OUTGOING_ONLY, "/com/lilithsthrone/res/map/submission/slimeQueensLair/slimeQueensLairGroundFloor.png", (AbstractPlaceType)PlaceType.WORLD_MAP_DOMINION, PlaceType.SLIME_QUEENS_LAIR_ENTRANCE, (Map)Util.newHashMapOfValues(new Util.Value<Color, AbstractPlaceType>(new Color(0xFFFFFF), PlaceType.GENERIC_IMPASSABLE), new Util.Value<Color, AbstractPlaceType>(new Color(0x808080), PlaceType.SLIME_QUEENS_LAIR_CORRIDOR), new Util.Value<Color, AbstractPlaceType>(new Color(65280), PlaceType.SLIME_QUEENS_LAIR_ENTRANCE), new Util.Value<Color, AbstractPlaceType>(new Color(0xFF0000), PlaceType.SLIME_QUEENS_LAIR_STAIRS_UP), new Util.Value<Color, AbstractPlaceType>(new Color(0xFF8000), PlaceType.SLIME_QUEENS_LAIR_STORAGE_VATS), new Util.Value<Color, AbstractPlaceType>(new Color(4240639), PlaceType.SLIME_QUEENS_LAIR_ROOM), new Util.Value<Color, AbstractPlaceType>(new Color(0xFF80FF), PlaceType.SLIME_QUEENS_LAIR_ENTRANCE_GUARDS), new Util.Value<Color, AbstractPlaceType>(new Color(0xFFFF00), PlaceType.SLIME_QUEENS_LAIR_SLIME_QUEEN))){

            @Override
            public String getSexBlockedReason(GameCharacter character) {
                return "\u8fd9\u4e0d\u662f\u4e00\u4e2a\u9002\u5408\u505a\u7231\u7684\u597d\u5730\u65b9\uff01";
            }
        };
        SLIME_QUEENS_LAIR_FIRST_FLOOR = new AbstractWorldType(WorldRegion.SUBMISSION, "\u53f2\u83b1\u59c6\u5973\u738b\u5854 \u4e8c\u697c", PresetColour.BASE_PINK, false, false, TeleportPermissions.OUTGOING_ONLY, "/com/lilithsthrone/res/map/submission/slimeQueensLair/slimeQueensLairFirstFloor.png", (AbstractPlaceType)PlaceType.WORLD_MAP_DOMINION, PlaceType.SLIME_QUEENS_LAIR_STAIRS_DOWN, (Map)Util.newHashMapOfValues(new Util.Value<Color, AbstractPlaceType>(new Color(0xFFFFFF), PlaceType.GENERIC_IMPASSABLE), new Util.Value<Color, AbstractPlaceType>(new Color(0x808080), PlaceType.SLIME_QUEENS_LAIR_CORRIDOR), new Util.Value<Color, AbstractPlaceType>(new Color(65280), PlaceType.SLIME_QUEENS_LAIR_STAIRS_DOWN), new Util.Value<Color, AbstractPlaceType>(new Color(4240639), PlaceType.SLIME_QUEENS_LAIR_ROOM), new Util.Value<Color, AbstractPlaceType>(new Color(0xFF00FF), PlaceType.SLIME_QUEENS_LAIR_ROYAL_GUARD), new Util.Value<Color, AbstractPlaceType>(new Color(0xFFFF00), PlaceType.SLIME_QUEENS_LAIR_SLIME_QUEEN))){

            @Override
            public String getSexBlockedReason(GameCharacter character) {
                return "\u8fd9\u4e0d\u662f\u4e00\u4e2a\u9002\u5408\u505a\u7231\u7684\u597d\u5730\u65b9\uff01";
            }
        };
        GAMBLING_DEN = new AbstractWorldType(WorldRegion.SUBMISSION, "\u8d4c\u573a", PresetColour.BASE_GOLD, false, false, TeleportPermissions.OUTGOING_ONLY, "/com/lilithsthrone/res/map/submission/gamblingDen/gamblingDen.png", (AbstractPlaceType)PlaceType.WORLD_MAP_DOMINION, PlaceType.GAMBLING_DEN_ENTRANCE, (Map)Util.newHashMapOfValues(new Util.Value<Color, AbstractPlaceType>(new Color(0xFFFFFF), PlaceType.GENERIC_IMPASSABLE), new Util.Value<Color, AbstractPlaceType>(new Color(0x808080), PlaceType.GAMBLING_DEN_CORRIDOR), new Util.Value<Color, AbstractPlaceType>(new Color(65280), PlaceType.GAMBLING_DEN_ENTRANCE), new Util.Value<Color, AbstractPlaceType>(new Color(4960720), PlaceType.GAMBLING_DEN_OFFICE), new Util.Value<Color, AbstractPlaceType>(new Color(0xFFFF00), PlaceType.GAMBLING_DEN_TRADER), new Util.Value<Color, AbstractPlaceType>(new Color(33023), PlaceType.GAMBLING_DEN_GAMBLING), new Util.Value<Color, AbstractPlaceType>(new Color(0xFF80FF), PlaceType.GAMBLING_DEN_PREGNANCY), new Util.Value<Color, AbstractPlaceType>(new Color(0xFF00FF), PlaceType.GAMBLING_DEN_FUTA_PREGNANCY), new Util.Value<Color, AbstractPlaceType>(new Color(0xFF8000), PlaceType.GAMBLING_DEN_PREGNANCY_ROULETTE))){

            @Override
            public boolean isRevealedOnStart() {
                return true;
            }

            @Override
            public String getSexBlockedReason(GameCharacter character) {
                return "\u8fd9\u4e0d\u662f\u4e00\u4e2a\u9002\u5408\u505a\u7231\u7684\u597d\u5730\u65b9\uff01";
            }

            @Override
            public boolean isFurniturePresent() {
                return true;
            }
        };
        RAT_WARRENS = new AbstractWorldType(WorldRegion.SUBMISSION, "\u9f20\u7a9f", PresetColour.BASE_BROWN, false, false, TeleportPermissions.NONE, "/com/lilithsthrone/res/map/submission/ratWarrens/ratWarrens.png", (AbstractPlaceType)PlaceType.WORLD_MAP_DOMINION, PlaceType.RAT_WARRENS_ENTRANCE, (Map)Util.newHashMapOfValues(new Util.Value<Color, AbstractPlaceType>(new Color(0xFFFFFF), PlaceType.GENERIC_IMPASSABLE), new Util.Value<Color, AbstractPlaceType>(new Color(0x808080), PlaceType.RAT_WARRENS_CORRIDOR_LEFT), new Util.Value<Color, AbstractPlaceType>(new Color(0xB9B9B9), PlaceType.RAT_WARRENS_CORRIDOR), new Util.Value<Color, AbstractPlaceType>(new Color(0x3B3B3B), PlaceType.RAT_WARRENS_CORRIDOR_RIGHT), new Util.Value<Color, AbstractPlaceType>(new Color(65280), PlaceType.RAT_WARRENS_ENTRANCE), new Util.Value<Color, AbstractPlaceType>(new Color(65535), PlaceType.RAT_WARRENS_CHECKPOINT_LEFT), new Util.Value<Color, AbstractPlaceType>(new Color(0x80FFFF), PlaceType.RAT_WARRENS_CHECKPOINT_RIGHT), new Util.Value<Color, AbstractPlaceType>(new Color(0xFF8080), PlaceType.RAT_WARRENS_DORMITORY_LEFT), new Util.Value<Color, AbstractPlaceType>(new Color(0xFF8000), PlaceType.RAT_WARRENS_DORMITORY_RIGHT), new Util.Value<Color, AbstractPlaceType>(new Color(255), PlaceType.RAT_WARRENS_DICE_DEN), new Util.Value<Color, AbstractPlaceType>(new Color(0xFFFF00), PlaceType.RAT_WARRENS_MILKING_ROOM), new Util.Value<Color, AbstractPlaceType>(new Color(0xFFBF00), PlaceType.RAT_WARRENS_MILKING_STORAGE), new Util.Value<Color, AbstractPlaceType>(new Color(0x8000FF), PlaceType.RAT_WARRENS_VENGARS_HALL), new Util.Value<Color, AbstractPlaceType>(new Color(0x800080), PlaceType.RAT_WARRENS_PRIVATE_BEDCHAMBERS))){

            @Override
            public String getSexBlockedReason(GameCharacter character) {
                return "\u8fd9\u4e0d\u662f\u4e00\u4e2a\u9002\u5408\u505a\u7231\u7684\u597d\u5730\u65b9\uff01";
            }

            @Override
            public boolean isFurniturePresent() {
                return true;
            }
        };
        REBEL_BASE = new AbstractWorldType(WorldRegion.SUBMISSION, "\u795e\u79d8\u6d1e\u7a9f", PresetColour.BASE_GREY, false, false, TeleportPermissions.NONE, "/com/lilithsthrone/res/map/submission/rebelBase/rebelBase.png", (AbstractPlaceType)PlaceType.WORLD_MAP_DOMINION, PlaceType.REBEL_BASE_ENTRANCE, (Map)Util.newHashMapOfValues(new Util.Value<Color, AbstractPlaceType>(new Color(0xFFFFFF), PlaceType.GENERIC_IMPASSABLE), new Util.Value<Color, AbstractPlaceType>(new Color(15539236), PlaceType.REBEL_BASE_ENTRANCE), new Util.Value<Color, AbstractPlaceType>(new Color(2273612), PlaceType.REBEL_BASE_CORRIDOR), new Util.Value<Color, AbstractPlaceType>(new Color(16290845), PlaceType.REBEL_BASE_SLEEPING_AREA), new Util.Value<Color, AbstractPlaceType>(new Color(6696337), PlaceType.REBEL_BASE_COMMON_AREA), new Util.Value<Color, AbstractPlaceType>(new Color(7196919), PlaceType.REBEL_BASE_ARMORY), new Util.Value<Color, AbstractPlaceType>(new Color(4147404), PlaceType.REBEL_BASE_CAVED_IN_ROOM))){

            @Override
            public String getSexBlockedReason(GameCharacter character) {
                return "\u968f\u65f6\u53ef\u80fd\u574d\u584c\u7684\u6d1e\u7a74\u4e0d\u662f\u505a\u7231\u7684\u597d\u5730\u65b9\uff01";
            }

            @Override
            public boolean isFurniturePresent() {
                return true;
            }
        };
        allWorldTypes = new ArrayList<AbstractWorldType>();
        worldToIdMap = new HashMap<AbstractWorldType, String>();
        idToWorldMap = new HashMap<String, AbstractWorldType>();
        Map<String, Map<String, File>> moddedFilesMap = Util.getExternalModFilesById("/maps", null, "worldType");
        for (Map.Entry<String, Map<String, File>> entry : moddedFilesMap.entrySet()) {
            for (Map.Entry<String, File> innerEntry : entry.getValue().entrySet()) {
                try {
                    AbstractWorldType worldType = new AbstractWorldType(innerEntry.getValue(), entry.getKey(), true){};
                    String id = innerEntry.getKey().replace("_worldType", "");
                    allWorldTypes.add(worldType);
                    worldToIdMap.put(worldType, id);
                    idToWorldMap.put(id, worldType);
                }
                catch (Exception ex) {
                    System.err.println("Loading modded world type failed at 'WorldType'. File path: " + innerEntry.getValue().getAbsolutePath());
                    System.err.println("Actual exception: ");
                    ex.printStackTrace(System.err);
                }
            }
        }
        Map<String, Map<String, File>> filesMap = Util.getExternalFilesById("res/maps", null, "worldType");
        for (Map.Entry<String, Map<String, File>> entry : filesMap.entrySet()) {
            for (Map.Entry<String, File> innerEntry : entry.getValue().entrySet()) {
                try {
                    AbstractWorldType worldType = new AbstractWorldType(innerEntry.getValue(), entry.getKey(), false){};
                    String id = innerEntry.getKey().replace("_worldType", "");
                    allWorldTypes.add(worldType);
                    worldToIdMap.put(worldType, id);
                    idToWorldMap.put(id, worldType);
                }
                catch (Exception ex) {
                    System.err.println("Loading world type failed at 'WorldType'. File path: " + innerEntry.getValue().getAbsolutePath());
                    System.err.println("Actual exception: ");
                    ex.printStackTrace(System.err);
                }
            }
        }
        for (Field f : fieldArray = WorldType.class.getFields()) {
            if (!AbstractWorldType.class.isAssignableFrom(f.getType())) continue;
            try {
                AbstractWorldType worldType = (AbstractWorldType)f.get(null);
                worldToIdMap.put(worldType, f.getName());
                idToWorldMap.put(f.getName(), worldType);
                allWorldTypes.add(worldType);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
    }
}

