/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.world.population;

import com.lilithsthrone.game.character.race.AbstractSubspecies;
import com.lilithsthrone.game.character.race.Subspecies;
import com.lilithsthrone.game.character.race.SubspeciesSpawnRarity;
import com.lilithsthrone.game.dialogue.utils.ParserTag;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.world.WorldType;
import com.lilithsthrone.world.places.PlaceType;
import com.lilithsthrone.world.population.AbstractPopulationType;
import com.lilithsthrone.world.population.PopulationDensity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Population {
    private boolean pluralPopulation;
    private AbstractPopulationType type;
    private PopulationDensity density;
    private Map<AbstractSubspecies, SubspeciesSpawnRarity> species;
    protected boolean inclusiveTimeRange = true;
    protected boolean usingDaylightHours = false;
    protected int dayStartOverride = -1;
    protected int dayEndOverride = -1;
    private String conditional;
    private String subspeciesWorldTypeId;
    private String subspeciesPlaceTypeId;
    private List<String> subspeciesIdToAdd;
    private List<String> subspeciesIdToRemove;

    public Population(boolean pluralPopulation, AbstractPopulationType type, PopulationDensity density, Map<AbstractSubspecies, SubspeciesSpawnRarity> species) {
        this.pluralPopulation = pluralPopulation;
        this.type = type;
        this.density = density;
        this.species = species;
        this.conditional = null;
    }

    public boolean isPluralPopulation() {
        return this.pluralPopulation;
    }

    public AbstractPopulationType getType() {
        return this.type;
    }

    private PopulationDensity getDensity() {
        return this.density;
    }

    public Map<AbstractSubspecies, SubspeciesSpawnRarity> getSpecies() {
        if (this.species == null) {
            if (this.subspeciesWorldTypeId != null && !this.subspeciesWorldTypeId.isEmpty()) {
                ArrayList<AbstractSubspecies> remove = new ArrayList<AbstractSubspecies>();
                if (this.subspeciesIdToRemove != null) {
                    for (String id : this.subspeciesIdToRemove) {
                        remove.add(Subspecies.getSubspeciesFromId(id));
                    }
                }
                this.species = Subspecies.getWorldSpecies(WorldType.getWorldTypeFromId(this.subspeciesWorldTypeId), PlaceType.getPlaceTypeFromId(this.subspeciesPlaceTypeId), true, true, remove);
            } else if (this.subspeciesIdToAdd != null && !this.subspeciesIdToAdd.isEmpty()) {
                this.species = new HashMap<AbstractSubspecies, SubspeciesSpawnRarity>();
                for (String id : this.subspeciesIdToAdd) {
                    this.species.put(Subspecies.getSubspeciesFromId(id), SubspeciesSpawnRarity.TEN);
                }
            } else {
                this.species = new HashMap<AbstractSubspecies, SubspeciesSpawnRarity>();
            }
        }
        return this.species;
    }

    public String getDescription(boolean includeDeterminer) {
        StringBuilder sb = new StringBuilder();
        if (includeDeterminer) {
            sb.append(this.getDensity().getName());
        }
        if (this.isPluralPopulation()) {
            sb.append(this.getType().getNamePlural());
        } else {
            sb.append(this.getType().getName());
        }
        return sb.toString();
    }

    public String getConditional() {
        return this.conditional;
    }

    public void setConditional(String conditional) {
        this.conditional = conditional;
    }

    public boolean isAvailableFromConditional() {
        return this.conditional == null || this.conditional.isEmpty() || Boolean.valueOf(UtilText.parse(this.conditional, new ParserTag[0]).trim()) != false;
    }

    public boolean isAvailableFromCurrentTime() {
        int dayStartMinutes = 0;
        int dayEndMinutes = 1440;
        if (this.usingDaylightHours) {
            dayStartMinutes = Main.game.getSunriseTimeInMinutes();
            dayEndMinutes = Main.game.getSunsetTimeInMinutes();
        } else if (this.dayEndOverride != -1 || this.dayStartOverride != -1) {
            dayStartMinutes = this.dayStartOverride != -1 ? this.dayStartOverride : Main.game.getSunriseTimeInMinutes();
            int n = dayEndMinutes = this.dayEndOverride != -1 ? this.dayEndOverride : Main.game.getSunsetTimeInMinutes();
        }
        if (this.inclusiveTimeRange) {
            return Main.game.getDayMinutes() >= dayStartMinutes && Main.game.getDayMinutes() <= dayEndMinutes;
        }
        return Main.game.getDayMinutes() < dayStartMinutes || Main.game.getDayMinutes() > dayEndMinutes;
    }

    public void setSubspeciesWorldTypeId(String subspeciesWorldTypeId) {
        this.subspeciesWorldTypeId = subspeciesWorldTypeId;
    }

    public void setSubspeciesPlaceTypeId(String subspeciesPlaceTypeId) {
        this.subspeciesPlaceTypeId = subspeciesPlaceTypeId;
    }

    public void setSubspeciesIdToAdd(List<String> subspeciesIdToAdd) {
        this.subspeciesIdToAdd = subspeciesIdToAdd;
    }

    public void setSubspeciesIdToRemove(List<String> subspeciesIdToRemove) {
        this.subspeciesIdToRemove = subspeciesIdToRemove;
    }

    public boolean isInclusiveTimeRange() {
        return this.inclusiveTimeRange;
    }

    public void setInclusiveTimeRange(boolean inclusiveTimeRange) {
        this.inclusiveTimeRange = inclusiveTimeRange;
    }

    public boolean isUsingDaylightHours() {
        return this.usingDaylightHours;
    }

    public void setUsingDaylightHours(boolean usingDaylightHours) {
        this.usingDaylightHours = usingDaylightHours;
    }

    public int getDayStartOverride() {
        return this.dayStartOverride;
    }

    public void setDayStartOverride(int dayStartOverride) {
        this.dayStartOverride = dayStartOverride;
    }

    public int getDayEndOverride() {
        return this.dayEndOverride;
    }

    public void setDayEndOverride(int dayEndOverride) {
        this.dayEndOverride = dayEndOverride;
    }
}

