import { A, createAsync } from "@solidjs/router"
import "./index.css"
import { Title } from "@solidjs/meta"
import { github } from "~/lib/github"
import { createMemo, Match, Switch } from "solid-js"
import { config } from "~/config"

export default function Black() {
  const githubData = createAsync(() => github())
  const starCount = createMemo(() =>
    githubData()?.stars
      ? new Intl.NumberFormat("en-US", {
          notation: "compact",
          compactDisplay: "short",
        }).format(githubData()!.stars!)
      : config.github.starsFormatted.compact,
  )

  // TODO: Frank, toggle this based on availability
  const available = false

  return (
    <div data-page="black">
      <Title>opencode</Title>
      <div data-component="header-gradient" />
      <header data-component="header">
        <div data-component="header-logo">
          <svg xmlns="http://www.w3.org/2000/svg" width="179" height="32" viewBox="0 0 179 32" fill="none">
            <g clip-path="url(#clip0_3654_210259)">
              <mask
                id="mask0_3654_210259"
                style="mask-type:luminance"
                maskUnits="userSpaceOnUse"
                x="0"
                y="0"
                width="179"
                height="32"
              >
                <path d="M178.286 0H0V32H178.286V0Z" fill="white" />
              </mask>
              <g mask="url(#mask0_3654_210259)">
                <path d="M13.7132 22.8577H4.57031V13.7148H13.7132V22.8577Z" fill="#444444" />
                <path
                  d="M13.7143 9.14174H4.57143V22.856H13.7143V9.14174ZM18.2857 27.4275H0V4.57031H18.2857V27.4275Z"
                  fill="#CDCDCD"
                />
                <path d="M36.5725 22.8577H27.4297V13.7148H36.5725V22.8577Z" fill="#444444" />
                <path
                  d="M27.4308 22.856H36.5737V9.14174H27.4308V22.856ZM41.1451 27.4275H27.4308V31.9989H22.8594V4.57031H41.1451V27.4275Z"
                  fill="#CDCDCD"
                />
                <path d="M64.0033 18.2852V22.8566H50.2891V18.2852H64.0033Z" fill="#444444" />
                <path
                  d="M63.9967 18.2846H50.2824V22.856H63.9967V27.4275H45.7109V4.57031H63.9967V18.2846ZM50.2824 13.7132H59.4252V9.14174H50.2824V13.7132Z"
                  fill="#CDCDCD"
                />
                <path d="M82.2835 27.4291H73.1406V13.7148H82.2835V27.4291Z" fill="#444444" />
                <path
                  d="M82.2846 9.14174H73.1417V27.4275H68.5703V4.57031H82.2846V9.14174ZM86.856 27.4275H82.2846V9.14174H86.856V27.4275Z"
                  fill="#CDCDCD"
                />
                <path d="M109.714 22.8577H96V13.7148H109.714V22.8577Z" fill="#444444" />
                <path
                  d="M109.715 9.14174H96.0011V22.856H109.715V27.4275H91.4297V4.57031H109.715V9.14174Z"
                  fill="white"
                />
                <path d="M128.002 22.8577H118.859V13.7148H128.002V22.8577Z" fill="#444444" />
                <path
                  d="M128.003 9.14174H118.86V22.856H128.003V9.14174ZM132.575 27.4275H114.289V4.57031H132.575V27.4275Z"
                  fill="white"
                />
                <path d="M150.854 22.8577H141.711V13.7148H150.854V22.8577Z" fill="#444444" />
                <path
                  d="M150.855 9.14286H141.712V22.8571H150.855V9.14286ZM155.426 27.4286H137.141V4.57143H150.855V0H155.426V27.4286Z"
                  fill="white"
                />
                <path d="M178.285 18.2852V22.8566H164.57V18.2852H178.285Z" fill="#444444" />
                <path
                  d="M164.571 9.14174V13.7132H173.714V9.14174H164.571ZM178.286 18.2846H164.571V22.856H178.286V27.4275H160V4.57031H178.286V18.2846Z"
                  fill="white"
                />
              </g>
            </g>
            <defs>
              <clipPath id="clip0_3654_210259">
                <rect width="178.286" height="32" fill="white" />
              </clipPath>
            </defs>
          </svg>
        </div>
      </header>
      <main data-component="content">
        <div data-slot="hero-black">
          <svg width="900" height="136" viewBox="0 0 900 136" fill="none" xmlns="http://www.w3.org/2000/svg">
            <mask
              id="path-1-outside-1_3654_210047"
              maskUnits="userSpaceOnUse"
              x="14"
              y="0"
              width="885"
              height="134"
              fill="black"
            >
              <rect fill="white" x="14" width="885" height="134" />
              <path d="M16.0158 4.36H58.6758C69.4758 4.36 77.9358 7.3 84.0558 13.18C90.1758 19.06 93.2358 26.92 93.2358 36.76C93.2358 44.32 91.3758 50.26 87.6558 54.58C84.0558 58.9 79.3758 61.96 73.6158 63.76V64.3C80.6958 65.98 86.5158 69.16 91.0758 73.84C95.6358 78.4 97.9158 85.06 97.9158 93.82C97.9158 98.86 97.0758 103.6 95.3958 108.04C93.7158 112.48 91.3158 116.32 88.1958 119.56C85.1958 122.8 81.5958 125.38 77.3958 127.3C73.3158 129.1 68.8758 130 64.0758 130H16.0158V4.36ZM59.5758 116.86C66.5358 116.86 71.9958 115.3 75.9558 112.18C79.9158 109.06 81.8958 104.26 81.8958 97.78V90.4C81.8958 84.04 79.9158 79.3 75.9558 76.18C71.9958 72.94 66.5358 71.32 59.5758 71.32H31.1358V116.86H59.5758ZM57.0558 58.9C63.4158 58.9 68.3958 57.52 71.9958 54.76C75.5958 51.88 77.3958 47.56 77.3958 41.8V34.78C77.3958 29.02 75.5958 24.7 71.9958 21.82C68.3958 18.94 63.4158 17.5 57.0558 17.5H31.1358V58.9H57.0558ZM219.705 130V4.36H234.825V116.86H294.405V130H219.705ZM482.615 130L471.995 94.18H427.895L417.275 130H401.615L440.135 4.36H460.115L498.635 130H482.615ZM450.755 20.38H449.135L431.495 81.04H468.395L450.755 20.38ZM652.105 132.16C636.745 132.16 625.285 126.58 617.725 115.42C610.285 104.26 606.565 88.18 606.565 67.18C606.565 46.18 610.285 30.1 617.725 18.94C625.285 7.77999 636.745 2.19999 652.105 2.19999C657.865 2.19999 662.845 2.97999 667.045 4.54C671.245 6.1 674.845 8.19999 677.845 10.84C680.845 13.48 683.365 16.48 685.405 19.84C687.445 23.08 689.245 26.38 690.805 29.74L677.845 35.68C676.765 32.92 675.505 30.34 674.065 27.94C672.625 25.42 670.885 23.26 668.845 21.46C666.925 19.54 664.585 18.04 661.825 16.96C659.185 15.88 655.945 15.34 652.105 15.34C642.145 15.34 634.705 19.12 629.785 26.68C624.985 34.24 622.585 44.32 622.585 56.92V77.44C622.585 90.04 624.985 100.12 629.785 107.68C634.705 115.24 642.145 119.02 652.105 119.02C655.945 119.02 659.185 118.48 661.825 117.4C664.585 116.32 666.925 114.88 668.845 113.08C670.885 111.16 672.625 109 674.065 106.6C675.505 104.08 676.765 101.44 677.845 98.68L690.805 104.62C689.245 108.1 687.445 111.46 685.405 114.7C683.365 117.94 680.845 120.88 677.845 123.52C674.845 126.16 671.245 128.26 667.045 129.82C662.845 131.38 657.865 132.16 652.105 132.16ZM840.315 68.44L822.315 89.68V130H807.195V4.36H822.315V69.88H822.855L839.415 49L876.495 4.36H894.675L850.575 57.28L895.935 130H878.295L840.315 68.44Z" />
            </mask>
            <path
              d="M16.0158 4.36H58.6758C69.4758 4.36 77.9358 7.3 84.0558 13.18C90.1758 19.06 93.2358 26.92 93.2358 36.76C93.2358 44.32 91.3758 50.26 87.6558 54.58C84.0558 58.9 79.3758 61.96 73.6158 63.76V64.3C80.6958 65.98 86.5158 69.16 91.0758 73.84C95.6358 78.4 97.9158 85.06 97.9158 93.82C97.9158 98.86 97.0758 103.6 95.3958 108.04C93.7158 112.48 91.3158 116.32 88.1958 119.56C85.1958 122.8 81.5958 125.38 77.3958 127.3C73.3158 129.1 68.8758 130 64.0758 130H16.0158V4.36ZM59.5758 116.86C66.5358 116.86 71.9958 115.3 75.9558 112.18C79.9158 109.06 81.8958 104.26 81.8958 97.78V90.4C81.8958 84.04 79.9158 79.3 75.9558 76.18C71.9958 72.94 66.5358 71.32 59.5758 71.32H31.1358V116.86H59.5758ZM57.0558 58.9C63.4158 58.9 68.3958 57.52 71.9958 54.76C75.5958 51.88 77.3958 47.56 77.3958 41.8V34.78C77.3958 29.02 75.5958 24.7 71.9958 21.82C68.3958 18.94 63.4158 17.5 57.0558 17.5H31.1358V58.9H57.0558ZM219.705 130V4.36H234.825V116.86H294.405V130H219.705ZM482.615 130L471.995 94.18H427.895L417.275 130H401.615L440.135 4.36H460.115L498.635 130H482.615ZM450.755 20.38H449.135L431.495 81.04H468.395L450.755 20.38ZM652.105 132.16C636.745 132.16 625.285 126.58 617.725 115.42C610.285 104.26 606.565 88.18 606.565 67.18C606.565 46.18 610.285 30.1 617.725 18.94C625.285 7.77999 636.745 2.19999 652.105 2.19999C657.865 2.19999 662.845 2.97999 667.045 4.54C671.245 6.1 674.845 8.19999 677.845 10.84C680.845 13.48 683.365 16.48 685.405 19.84C687.445 23.08 689.245 26.38 690.805 29.74L677.845 35.68C676.765 32.92 675.505 30.34 674.065 27.94C672.625 25.42 670.885 23.26 668.845 21.46C666.925 19.54 664.585 18.04 661.825 16.96C659.185 15.88 655.945 15.34 652.105 15.34C642.145 15.34 634.705 19.12 629.785 26.68C624.985 34.24 622.585 44.32 622.585 56.92V77.44C622.585 90.04 624.985 100.12 629.785 107.68C634.705 115.24 642.145 119.02 652.105 119.02C655.945 119.02 659.185 118.48 661.825 117.4C664.585 116.32 666.925 114.88 668.845 113.08C670.885 111.16 672.625 109 674.065 106.6C675.505 104.08 676.765 101.44 677.845 98.68L690.805 104.62C689.245 108.1 687.445 111.46 685.405 114.7C683.365 117.94 680.845 120.88 677.845 123.52C674.845 126.16 671.245 128.26 667.045 129.82C662.845 131.38 657.865 132.16 652.105 132.16ZM840.315 68.44L822.315 89.68V130H807.195V4.36H822.315V69.88H822.855L839.415 49L876.495 4.36H894.675L850.575 57.28L895.935 130H878.295L840.315 68.44Z"
              fill="url(#paint0_linear_3654_210047)"
              fill-opacity="0.1"
            />
            <path
              d="M16.0158 4.36V2.86H14.5158V4.36H16.0158ZM84.0558 13.18L85.095 12.0983L84.0558 13.18ZM87.6558 54.58L86.5191 53.6012L86.5112 53.6104L86.5035 53.6197L87.6558 54.58ZM73.6158 63.76L73.1684 62.3283L72.1158 62.6572V63.76H73.6158ZM73.6158 64.3H72.1158V65.4857L73.2695 65.7595L73.6158 64.3ZM91.0758 73.84L90.0014 74.8868L90.0082 74.8938L90.0151 74.9007L91.0758 73.84ZM95.3958 108.04L93.9929 107.509L95.3958 108.04ZM88.1958 119.56L87.1153 118.52L87.1051 118.53L87.0951 118.541L88.1958 119.56ZM77.3958 127.3L78.0012 128.672L78.0104 128.668L78.0194 128.664L77.3958 127.3ZM16.0158 130H14.5158V131.5H16.0158V130ZM75.9558 112.18L76.8841 113.358L75.9558 112.18ZM75.9558 76.18L75.0059 77.3409L75.0166 77.3497L75.0275 77.3582L75.9558 76.18ZM31.1358 71.32V69.82H29.6358V71.32H31.1358ZM31.1358 116.86H29.6358V118.36H31.1358V116.86ZM71.9958 54.76L72.9084 55.9504L72.9207 55.941L72.9328 55.9313L71.9958 54.76ZM31.1358 17.5V16H29.6358V17.5H31.1358ZM31.1358 58.9H29.6358V60.4H31.1358V58.9ZM16.0158 4.36V5.86H58.6758V4.36V2.86H16.0158V4.36ZM58.6758 4.36V5.86C69.1985 5.86 77.2464 8.71779 83.0165 14.2617L84.0558 13.18L85.095 12.0983C78.6252 5.8822 69.753 2.86 58.6758 2.86V4.36ZM84.0558 13.18L83.0165 14.2617C88.7947 19.8132 91.7358 27.2574 91.7358 36.76H93.2358H94.7358C94.7358 26.5826 91.5569 18.3068 85.095 12.0983L84.0558 13.18ZM93.2358 36.76H91.7358C91.7358 44.0794 89.9374 49.6316 86.5191 53.6012L87.6558 54.58L88.7924 55.5588C92.8141 50.8884 94.7358 44.5606 94.7358 36.76H93.2358ZM87.6558 54.58L86.5035 53.6197C83.1018 57.7017 78.674 60.6078 73.1684 62.3283L73.6158 63.76L74.0632 65.1917C80.0776 63.3122 85.0098 60.0983 88.8081 55.5403L87.6558 54.58ZM73.6158 63.76H72.1158V64.3H73.6158H75.1158V63.76H73.6158ZM73.6158 64.3L73.2695 65.7595C80.105 67.3815 85.6621 70.4333 90.0014 74.8868L91.0758 73.84L92.1501 72.7932C87.3694 67.8867 81.2865 64.5785 73.9621 62.8405L73.6158 64.3ZM91.0758 73.84L90.0151 74.9007C94.205 79.0905 96.4158 85.3115 96.4158 93.82H97.9158H99.4158C99.4158 84.8085 97.0666 77.7095 92.1364 72.7793L91.0758 73.84ZM97.9158 93.82H96.4158C96.4158 98.6899 95.6048 103.249 93.9929 107.509L95.3958 108.04L96.7987 108.571C98.5468 103.951 99.4158 99.0301 99.4158 93.82H97.9158ZM95.3958 108.04L93.9929 107.509C92.3807 111.77 90.0867 115.434 87.1153 118.52L88.1958 119.56L89.2763 120.6C92.5449 117.206 95.0509 113.19 96.7987 108.571L95.3958 108.04ZM88.1958 119.56L87.0951 118.541C84.2359 121.629 80.8003 124.094 76.7721 125.936L77.3958 127.3L78.0194 128.664C82.3913 126.666 86.1556 123.971 89.2964 120.579L88.1958 119.56ZM77.3958 127.3L76.7903 125.928C72.9153 127.637 68.6834 128.5 64.0758 128.5V130V131.5C69.0681 131.5 73.7163 130.563 78.0012 128.672L77.3958 127.3ZM64.0758 130V128.5H16.0158V130V131.5H64.0758V130ZM16.0158 130H17.5158V4.36H16.0158H14.5158V130H16.0158ZM59.5758 116.86V118.36C66.7461 118.36 72.5749 116.753 76.8841 113.358L75.9558 112.18L75.0275 111.002C71.4167 113.847 66.3255 115.36 59.5758 115.36V116.86ZM75.9558 112.18L76.8841 113.358C81.3041 109.876 83.3958 104.577 83.3958 97.78H81.8958H80.3958C80.3958 103.943 78.5275 108.244 75.0275 111.002L75.9558 112.18ZM81.8958 97.78H83.3958V90.4H81.8958H80.3958V97.78H81.8958ZM81.8958 90.4H83.3958C83.3958 83.7122 81.2973 78.4788 76.8841 75.0018L75.9558 76.18L75.0275 77.3582C78.5343 80.1212 80.3958 84.3678 80.3958 90.4H81.8958ZM75.9558 76.18L76.9056 75.0191C72.595 71.4922 66.7577 69.82 59.5758 69.82V71.32V72.82C66.3139 72.82 71.3965 74.3878 75.0059 77.3409L75.9558 76.18ZM59.5758 71.32V69.82H31.1358V71.32V72.82H59.5758V71.32ZM31.1358 71.32H29.6358V116.86H31.1358H32.6358V71.32H31.1358ZM31.1358 116.86V118.36H59.5758V116.86V115.36H31.1358V116.86ZM57.0558 58.9V60.4C63.616 60.4 68.9595 58.9779 72.9084 55.9504L71.9958 54.76L71.0831 53.5696C67.8321 56.0621 63.2155 57.4 57.0558 57.4V58.9ZM71.9958 54.76L72.9328 55.9313C76.9757 52.697 78.8958 47.8911 78.8958 41.8H77.3958H75.8958C75.8958 47.2289 74.2158 51.063 71.0587 53.5887L71.9958 54.76ZM77.3958 41.8H78.8958V34.78H77.3958H75.8958V41.8H77.3958ZM77.3958 34.78H78.8958C78.8958 28.6889 76.9757 23.883 72.9328 20.6487L71.9958 21.82L71.0587 22.9913C74.2158 25.517 75.8958 29.3511 75.8958 34.78H77.3958ZM71.9958 21.82L72.9328 20.6487C68.9818 17.4879 63.6286 16 57.0558 16V17.5V19C63.203 19 67.8098 20.3922 71.0587 22.9913L71.9958 21.82ZM57.0558 17.5V16H31.1358V17.5V19H57.0558V17.5ZM31.1358 17.5H29.6358V58.9H31.1358H32.6358V17.5H31.1358ZM31.1358 58.9V60.4H57.0558V58.9V57.4H31.1358V58.9ZM219.705 130H218.205V131.5H219.705V130ZM219.705 4.36V2.86H218.205V4.36H219.705ZM234.825 4.36H236.325V2.86H234.825V4.36ZM234.825 116.86H233.325V118.36H234.825V116.86ZM294.405 116.86H295.905V115.36H294.405V116.86ZM294.405 130V131.5H295.905V130H294.405ZM219.705 130H221.205V4.36H219.705H218.205V130H219.705ZM219.705 4.36V5.86H234.825V4.36V2.86H219.705V4.36ZM234.825 4.36H233.325V116.86H234.825H236.325V4.36H234.825ZM234.825 116.86V118.36H294.405V116.86V115.36H234.825V116.86ZM294.405 116.86H292.905V130H294.405H295.905V116.86H294.405ZM294.405 130V128.5H219.705V130V131.5H294.405V130ZM482.615 130L481.177 130.426L481.495 131.5H482.615V130ZM471.995 94.18L473.433 93.7536L473.115 92.68H471.995V94.18ZM427.895 94.18V92.68H426.775L426.457 93.7536L427.895 94.18ZM417.275 130V131.5H418.395L418.713 130.426L417.275 130ZM401.615 130L400.181 129.56L399.586 131.5H401.615V130ZM440.135 4.36V2.86H439.026L438.701 3.92031L440.135 4.36ZM460.115 4.36L461.549 3.92031L461.224 2.86H460.115V4.36ZM498.635 130V131.5H500.664L500.069 129.56L498.635 130ZM450.755 20.38L452.195 19.9611L451.881 18.88H450.755V20.38ZM449.135 20.38V18.88H448.009L447.695 19.9611L449.135 20.38ZM431.495 81.04L430.055 80.6212L429.497 82.54H431.495V81.04ZM468.395 81.04V82.54H470.393L469.836 80.6212L468.395 81.04ZM482.615 130L484.053 129.574L473.433 93.7536L471.995 94.18L470.557 94.6064L481.177 130.426L482.615 130ZM471.995 94.18V92.68H427.895V94.18V95.68H471.995V94.18ZM427.895 94.18L426.457 93.7536L415.837 129.574L417.275 130L418.713 130.426L429.333 94.6064L427.895 94.18ZM417.275 130V128.5H401.615V130V131.5H417.275V130ZM401.615 130L403.049 130.44L441.569 4.79968L440.135 4.36L438.701 3.92031L400.181 129.56L401.615 130ZM440.135 4.36V5.86H460.115V4.36V2.86H440.135V4.36ZM460.115 4.36L458.681 4.79968L497.201 130.44L498.635 130L500.069 129.56L461.549 3.92031L460.115 4.36ZM498.635 130V128.5H482.615V130V131.5H498.635V130ZM450.755 20.38V18.88H449.135V20.38V21.88H450.755V20.38ZM449.135 20.38L447.695 19.9611L430.055 80.6212L431.495 81.04L432.935 81.4588L450.576 20.7988L449.135 20.38ZM431.495 81.04V82.54H468.395V81.04V79.54H431.495V81.04ZM468.395 81.04L469.836 80.6212L452.195 19.9611L450.755 20.38L449.315 20.7988L466.955 81.4588L468.395 81.04ZM617.725 115.42L616.477 116.252L616.483 116.261L617.725 115.42ZM617.725 18.94L616.483 18.0987L616.477 18.1079L617.725 18.94ZM677.845 10.84L678.836 9.71392L677.845 10.84ZM685.405 19.84L684.123 20.6185L684.129 20.6289L684.135 20.6392L685.405 19.84ZM690.805 29.74L691.43 31.1036L692.8 30.4755L692.165 29.1083L690.805 29.74ZM677.845 35.68L676.448 36.2266L677.027 37.7051L678.47 37.0436L677.845 35.68ZM674.065 27.94L672.762 28.6842L672.77 28.6981L672.779 28.7117L674.065 27.94ZM668.845 21.46L667.784 22.5207L667.817 22.5538L667.852 22.5847L668.845 21.46ZM661.825 16.96L661.257 18.3483L661.268 18.3527L661.278 18.3569L661.825 16.96ZM629.785 26.68L628.528 25.8618L628.523 25.8689L628.519 25.876L629.785 26.68ZM629.785 107.68L628.519 108.484L628.523 108.491L628.528 108.498L629.785 107.68ZM661.825 117.4L661.278 116.003L661.268 116.007L661.257 116.012L661.825 117.4ZM668.845 113.08L669.871 114.174L669.873 114.172L668.845 113.08ZM674.065 106.6L675.351 107.372L675.359 107.358L675.367 107.344L674.065 106.6ZM677.845 98.68L678.47 97.3164L677.027 96.6549L676.448 98.1334L677.845 98.68ZM690.805 104.62L692.174 105.234L692.782 103.876L691.43 103.256L690.805 104.62ZM685.405 114.7L684.135 113.901L685.405 114.7ZM677.845 123.52L676.854 122.394L677.845 123.52ZM667.045 129.82L667.567 131.226L667.045 129.82ZM652.105 132.16V130.66C637.162 130.66 626.205 125.264 618.967 114.579L617.725 115.42L616.483 116.261C624.365 127.896 636.328 133.66 652.105 133.66V132.16ZM617.725 115.42L618.973 114.588C611.766 103.777 608.065 88.0384 608.065 67.18H606.565H605.065C605.065 88.3216 608.804 104.743 616.477 116.252L617.725 115.42ZM606.565 67.18H608.065C608.065 46.3216 611.766 30.5826 618.973 19.772L617.725 18.94L616.477 18.1079C608.804 29.6174 605.065 46.0384 605.065 67.18H606.565ZM617.725 18.94L618.967 19.7813C626.205 9.09591 637.162 3.7 652.105 3.7V2.2V0.699997C636.328 0.699997 624.365 6.46408 616.483 18.0987L617.725 18.94ZM652.105 2.2V3.7C657.735 3.7 662.53 4.4631 666.523 5.94614L667.045 4.53999L667.567 3.13386C663.16 1.49689 657.995 0.699997 652.105 0.699997V2.2ZM667.045 4.53999L666.523 5.94614C670.571 7.44994 674.007 9.46111 676.854 11.9661L677.845 10.84L678.836 9.71392C675.682 6.93889 671.918 4.75006 667.567 3.13386L667.045 4.53999ZM677.845 10.84L676.854 11.9661C679.742 14.5073 682.163 17.3906 684.123 20.6185L685.405 19.84L686.687 19.0615C684.567 15.5694 681.948 12.4527 678.836 9.71392L677.845 10.84ZM685.405 19.84L684.135 20.6392C686.143 23.8271 687.912 27.0713 689.444 30.3717L690.805 29.74L692.165 29.1083C690.578 25.6887 688.747 22.3328 686.674 19.0408L685.405 19.84ZM690.805 29.74L690.18 28.3764L677.22 34.3164L677.845 35.68L678.47 37.0436L691.43 31.1036L690.805 29.74ZM677.845 35.68L679.242 35.1334C678.133 32.2999 676.837 29.6441 675.351 27.1683L674.065 27.94L672.779 28.7117C674.173 31.0358 675.397 33.54 676.448 36.2266L677.845 35.68ZM674.065 27.94L675.367 27.1958C673.851 24.5424 672.009 22.2513 669.837 20.3352L668.845 21.46L667.852 22.5847C669.761 24.2687 671.399 26.2976 672.762 28.6842L674.065 27.94ZM668.845 21.46L669.906 20.3993C667.826 18.3201 665.306 16.7116 662.371 15.5631L661.825 16.96L661.278 18.3569C663.863 19.3684 666.023 20.7599 667.784 22.5207L668.845 21.46ZM661.825 16.96L662.393 15.5717C659.522 14.3972 656.076 13.84 652.105 13.84V15.34V16.84C655.814 16.84 658.848 17.3628 661.257 18.3483L661.825 16.96ZM652.105 15.34V13.84C641.7 13.84 633.757 17.8266 628.528 25.8618L629.785 26.68L631.042 27.4982C635.653 20.4134 642.59 16.84 652.105 16.84V15.34ZM629.785 26.68L628.519 25.876C623.516 33.7554 621.085 44.1461 621.085 56.92H622.585H624.085C624.085 44.4939 626.454 34.7246 631.051 27.484L629.785 26.68ZM622.585 56.92H621.085V77.44H622.585H624.085V56.92H622.585ZM622.585 77.44H621.085C621.085 90.2139 623.516 100.605 628.519 108.484L629.785 107.68L631.051 106.876C626.454 99.6354 624.085 89.8661 624.085 77.44H622.585ZM629.785 107.68L628.528 108.498C633.757 116.533 641.7 120.52 652.105 120.52V119.02V117.52C642.59 117.52 635.653 113.947 631.042 106.862L629.785 107.68ZM652.105 119.02V120.52C656.076 120.52 659.522 119.963 662.393 118.788L661.825 117.4L661.257 116.012C658.848 116.997 655.814 117.52 652.105 117.52V119.02ZM661.825 117.4L662.371 118.797C665.287 117.656 667.795 116.12 669.871 114.174L668.845 113.08L667.819 111.986C666.055 113.64 663.883 114.984 661.278 116.003L661.825 117.4ZM668.845 113.08L669.873 114.172C672.013 112.158 673.84 109.89 675.351 107.372L674.065 106.6L672.779 105.828C671.41 108.11 669.757 110.162 667.817 111.988L668.845 113.08ZM674.065 106.6L675.367 107.344C676.844 104.759 678.136 102.053 679.242 99.2266L677.845 98.68L676.448 98.1334C675.394 100.827 674.165 103.401 672.762 105.856L674.065 106.6ZM677.845 98.68L677.22 100.044L690.18 105.984L690.805 104.62L691.43 103.256L678.47 97.3164L677.845 98.68ZM690.805 104.62L689.436 104.006C687.905 107.422 686.138 110.72 684.135 113.901L685.405 114.7L686.674 115.499C688.751 112.2 690.585 108.778 692.174 105.234L690.805 104.62ZM685.405 114.7L684.135 113.901C682.175 117.014 679.751 119.845 676.854 122.394L677.845 123.52L678.836 124.646C681.939 121.915 684.554 118.866 686.674 115.499L685.405 114.7ZM677.845 123.52L676.854 122.394C674.007 124.899 670.571 126.91 666.523 128.414L667.045 129.82L667.567 131.226C671.918 129.61 675.682 127.421 678.836 124.646L677.845 123.52ZM667.045 129.82L666.523 128.414C662.53 129.897 657.735 130.66 652.105 130.66V132.16V133.66C657.995 133.66 663.16 132.863 667.567 131.226L667.045 129.82ZM840.315 68.44L841.591 67.6524L840.506 65.8938L839.17 67.4702L840.315 68.44ZM822.315 89.68L821.17 88.7102L820.815 89.1299V89.68H822.315ZM822.315 130V131.5H823.815V130H822.315ZM807.195 130H805.695V131.5H807.195V130ZM807.195 4.36V2.86H805.695V4.36H807.195ZM822.315 4.36H823.815V2.86H822.315V4.36ZM822.315 69.88H820.815V71.38H822.315V69.88ZM822.855 69.88V71.38H823.579L824.03 70.8121L822.855 69.88ZM839.415 49L838.261 48.0415L838.25 48.0546L838.239 48.0679L839.415 49ZM876.495 4.36V2.86H875.791L875.341 3.40155L876.495 4.36ZM894.675 4.36L895.827 5.32027L897.877 2.86H894.675V4.36ZM850.575 57.28L849.422 56.3197L848.728 57.1533L849.302 58.0739L850.575 57.28ZM895.935 130V131.5H898.638L897.207 129.206L895.935 130ZM878.295 130L877.018 130.788L877.457 131.5H878.295V130ZM840.315 68.44L839.17 67.4702L821.17 88.7102L822.315 89.68L823.459 90.6498L841.459 69.4098L840.315 68.44ZM822.315 89.68H820.815V130H822.315H823.815V89.68H822.315ZM822.315 130V128.5H807.195V130V131.5H822.315V130ZM807.195 130H808.695V4.36H807.195H805.695V130H807.195ZM807.195 4.36V5.86H822.315V4.36V2.86H807.195V4.36ZM822.315 4.36H820.815V69.88H822.315H823.815V4.36H822.315ZM822.315 69.88V71.38H822.855V69.88V68.38H822.315V69.88ZM822.855 69.88L824.03 70.8121L840.59 49.9321L839.415 49L838.239 48.0679L821.679 68.9479L822.855 69.88ZM839.415 49L840.568 49.9584L877.648 5.31844L876.495 4.36L875.341 3.40155L838.261 48.0415L839.415 49ZM876.495 4.36V5.86H894.675V4.36V2.86H876.495V4.36ZM894.675 4.36L893.522 3.39972L849.422 56.3197L850.575 57.28L851.727 58.2403L895.827 5.32027L894.675 4.36ZM850.575 57.28L849.302 58.0739L894.662 130.794L895.935 130L897.207 129.206L851.847 56.4861L850.575 57.28ZM895.935 130V128.5H878.295V130V131.5H895.935V130ZM878.295 130L879.571 129.212L841.591 67.6524L840.315 68.44L839.038 69.2276L877.018 130.788L878.295 130Z"
              fill="url(#paint1_linear_3654_210047)"
              mask="url(#path-1-outside-1_3654_210047)"
            />
            <defs>
              <linearGradient
                id="paint0_linear_3654_210047"
                x1="450"
                y1="1.8125"
                x2="450"
                y2="130"
                gradientUnits="userSpaceOnUse"
              >
                <stop stop-color="white" />
                <stop offset="1" stop-color="white" stop-opacity="0" />
              </linearGradient>
              <linearGradient
                id="paint1_linear_3654_210047"
                x1="450"
                y1="2.5"
                x2="450"
                y2="130"
                gradientUnits="userSpaceOnUse"
              >
                <stop stop-color="white" stop-opacity="0.6" />
                <stop offset="1" stop-color="white" stop-opacity="0" />
              </linearGradient>
            </defs>
          </svg>
        </div>
        <section data-slot="cta">
          <div data-slot="copy">
            <p data-slot="heading">
              Access all the world's <span>best coding models</span>
            </p>
            <p data-slot="subheading">Including Claude, GPT, Gemini, and more</p>
          </div>
          <Switch>
            <Match when={available}>
              <a href="/black/subscribe" data-slot="button">
                Subscribe $200/mo
              </a>
              <p data-slot="fine-print">Fair usage limits apply</p>
            </Match>
            <Match when={!available}>
              <p data-slot="back-soon">We’ll be back soon with more availability.</p>
              <a data-slot="follow-us" href="https://x.com/opencode" target="_blank">
                Follow @opencode
              </a>
            </Match>
          </Switch>
        </section>
      </main>
      <footer data-component="footer">
        <div data-slot="footer-content">
          <span data-slot="anomaly">
            ©{new Date().getFullYear()} <a href="https://anoma.ly">Anomaly</a>
          </span>
          <a href={config.github.repoUrl} target="_blank">
            GitHub <span data-slot="github-stars">[{starCount()}]</span>
          </a>
          <a href="/docs">Docs</a>
          <span>
            <A href="/legal/privacy-policy">Privacy</A>
          </span>
          <span>
            <A href="/legal/terms-of-service">Terms</A>
          </span>
        </div>
        <span data-slot="anomaly-alt">
          ©{new Date().getFullYear()} <a href="https://anoma.ly">Anomaly</a>
        </span>
      </footer>
    </div>
  )
}
